/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.BehaviorBase;
import atlantafx.base.controls.Calendar;
import atlantafx.base.controls.CalendarSkin;
import atlantafx.base.util.PlatformUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class CalendarBehavior
extends BehaviorBase<Calendar, CalendarSkin> {
    public CalendarBehavior(Calendar calendar, CalendarSkin calendarSkin) {
        super(calendar, calendarSkin);
    }

    public void onKeyPressed(KeyEvent keyEvent) {
        ((CalendarSkin)((Object)this.getSkin())).rememberFocusedDayCell();
        if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED) {
            switch (keyEvent.getCode()) {
                case HOME: {
                    ((CalendarSkin)((Object)this.getSkin())).goToDate(LocalDate.now(ZoneId.systemDefault()), true);
                    keyEvent.consume();
                    break;
                }
                case PAGE_UP: {
                    if (PlatformUtils.isMac() && keyEvent.isMetaDown() || !PlatformUtils.isMac() && keyEvent.isControlDown()) {
                        if (((CalendarSkin)((Object)this.getSkin())).canGoYearForward()) {
                            ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.YEARS, true);
                        }
                    } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthForward()) {
                        ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.MONTHS, true);
                    }
                    keyEvent.consume();
                    break;
                }
                case PAGE_DOWN: {
                    if (PlatformUtils.isMac() && keyEvent.isMetaDown() || !PlatformUtils.isMac() && keyEvent.isControlDown()) {
                        if (((CalendarSkin)((Object)this.getSkin())).canGoYearBack()) {
                            ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.YEARS, true);
                        }
                    } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthBack()) {
                        ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.MONTHS, true);
                    }
                    keyEvent.consume();
                }
            }
            ((CalendarSkin)((Object)this.getSkin())).rememberFocusedDayCell();
        }
        if (keyEvent.getCode() != KeyCode.ESCAPE) {
            keyEvent.consume();
        }
    }

    public void moveForward(MouseEvent mouseEvent) {
        if (PlatformUtils.isMac() && mouseEvent.isMetaDown() || !PlatformUtils.isMac() && mouseEvent.isControlDown()) {
            if (((CalendarSkin)((Object)this.getSkin())).canGoYearForward()) {
                ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.YEARS, true);
            }
        } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthForward()) {
            ((CalendarSkin)((Object)this.getSkin())).forward(1, ChronoUnit.MONTHS, true);
        }
        mouseEvent.consume();
    }

    public void moveBackward(MouseEvent mouseEvent) {
        if (PlatformUtils.isMac() && mouseEvent.isMetaDown() || !PlatformUtils.isMac() && mouseEvent.isControlDown()) {
            if (((CalendarSkin)((Object)this.getSkin())).canGoYearBack()) {
                ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.YEARS, true);
            }
        } else if (((CalendarSkin)((Object)this.getSkin())).canGoMonthBack()) {
            ((CalendarSkin)((Object)this.getSkin())).forward(-1, ChronoUnit.MONTHS, true);
        }
        mouseEvent.consume();
    }
}

