/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.CompressorStreamDeflater;
import ar.com.hjg.pngj.pixels.CompressorStreamLz4;
import ar.com.hjg.pngj.pixels.FiltersPerformance;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import java.util.LinkedList;

public class PixelsWriterMultiple
extends PixelsWriter {
    protected LinkedList<byte[]> rows;
    protected CompressorStream[] filterBank = new CompressorStream[6];
    protected byte[][] filteredRows = new byte[5][];
    protected byte[] filteredRowTmp;
    protected FiltersPerformance filtersPerf;
    protected int rowsPerBand = 0;
    protected int rowsPerBandCurrent = 0;
    protected int rowInBand = -1;
    protected int bandNum = -1;
    protected int firstRowInThisBand;
    protected int lastRowInThisBand;
    private boolean tryAdaptive = true;
    protected static final int HINT_MEMORY_DEFAULT_KB = 100;
    protected int hintMemoryKb = 100;
    private int hintRowsPerBand = 1000;
    private boolean useLz4 = true;

    public PixelsWriterMultiple(ImageInfo imageInfo) {
        super(imageInfo);
        this.filtersPerf = new FiltersPerformance(imageInfo);
        this.rows = new LinkedList();
        for (int i2 = 0; i2 < 2; ++i2) {
            this.rows.add(new byte[this.buflen]);
        }
        this.filteredRowTmp = new byte[this.buflen];
    }

    protected void filterAndWrite(byte[] byArray) {
        if (!this.initdone) {
            this.init();
        }
        if (byArray != this.rows.get(0)) {
            throw new RuntimeException("?");
        }
        this.setBandFromNewRown();
        byte[] byArray2 = this.rows.get(1);
        for (FilterType filterType : FilterType.getAllStandardNoneLast()) {
            if (this.currentRow == 0 && filterType != FilterType.FILTER_NONE && filterType != FilterType.FILTER_SUB) continue;
            byte[] byArray3 = this.filterRowWithFilterType(filterType, byArray, byArray2, this.filteredRows[filterType.val]);
            this.filterBank[filterType.val].write(byArray3);
            if (this.currentRow == 0 && filterType == FilterType.FILTER_SUB) {
                this.filterBank[FilterType.FILTER_PAETH.val].write(byArray3);
                this.filterBank[FilterType.FILTER_AVERAGE.val].write(byArray3);
                this.filterBank[FilterType.FILTER_UP.val].write(byArray3);
            }
            if (!this.tryAdaptive) continue;
            this.filtersPerf.updateFromFiltered(filterType, byArray3, this.currentRow);
        }
        this.filteredRows[0] = byArray;
        if (this.tryAdaptive) {
            FilterType n2 = this.filtersPerf.getPreferred();
            this.filterBank[5].write(this.filteredRows[n2.val]);
        }
        if (this.currentRow == this.lastRowInThisBand) {
            int n2 = this.getBestCompressor();
            byte[] byArray4 = this.filterBank[n2].getFirstBytes();
            int n3 = this.firstRowInThisBand;
            int n4 = 0;
            int n5 = this.lastRowInThisBand - this.firstRowInThisBand;
            while (n3 <= this.lastRowInThisBand) {
                byte by2 = byArray4[n4];
                byte[] byArray5 = null;
                byArray5 = n3 != this.lastRowInThisBand ? this.filterRowWithFilterType(FilterType.getByVal(by2), this.rows.get(n5), this.rows.get(n5 + 1), this.filteredRowTmp) : this.filteredRows[by2];
                this.sendToCompressedStream(byArray5);
                ++n3;
                --n5;
                ++n4;
            }
        }
        if (this.rows.size() > this.rowsPerBandCurrent) {
            this.rows.addFirst(this.rows.removeLast());
        } else {
            this.rows.addFirst(new byte[this.buflen]);
        }
    }

    public byte[] getRowb() {
        return this.rows.get(0);
    }

    private void setBandFromNewRown() {
        boolean bl2;
        boolean bl3 = bl2 = this.currentRow == 0 || this.currentRow > this.lastRowInThisBand;
        if (this.currentRow == 0) {
            this.bandNum = -1;
        }
        if (bl2) {
            ++this.bandNum;
            this.rowInBand = 0;
        } else {
            ++this.rowInBand;
        }
        if (bl2) {
            this.firstRowInThisBand = this.currentRow;
            this.lastRowInThisBand = this.firstRowInThisBand + this.rowsPerBand - 1;
            int n2 = this.firstRowInThisBand + 2 * this.rowsPerBand - 1;
            if (n2 >= this.imgInfo.rows) {
                this.lastRowInThisBand = this.imgInfo.rows - 1;
            }
            this.rowsPerBandCurrent = 1 + this.lastRowInThisBand - this.firstRowInThisBand;
            this.tryAdaptive = this.rowsPerBandCurrent > 3 && (this.rowsPerBandCurrent >= 10 || this.imgInfo.bytesPerRow >= 64);
            this.rebuildFiltersBank();
        }
    }

    private void rebuildFiltersBank() {
        long l2 = (long)this.rowsPerBandCurrent * (long)this.buflen;
        int n2 = 4;
        for (int i2 = 0; i2 <= 5; ++i2) {
            CompressorStream compressorStream = this.filterBank[i2];
            if (compressorStream == null || compressorStream.totalbytes != l2) {
                if (compressorStream != null) {
                    compressorStream.close();
                }
                compressorStream = this.useLz4 ? new CompressorStreamLz4(null, this.buflen, l2) : new CompressorStreamDeflater(null, this.buflen, l2, 4, 0);
                this.filterBank[i2] = compressorStream;
            } else {
                compressorStream.reset();
            }
            compressorStream.setStoreFirstByte(true, this.rowsPerBandCurrent);
        }
    }

    private int computeInitialRowsPerBand() {
        int n2 = (int)((double)this.hintMemoryKb * 1024.0 / (double)(this.imgInfo.bytesPerRow + 1) - 5.0);
        if (n2 < 1) {
            n2 = 1;
        }
        if (this.hintRowsPerBand > 0 && n2 > this.hintRowsPerBand) {
            n2 = this.hintRowsPerBand;
        }
        if (n2 > this.imgInfo.rows) {
            n2 = this.imgInfo.rows;
        }
        if (n2 > 2 && n2 > this.imgInfo.rows / 8) {
            int n3 = (this.imgInfo.rows + (n2 - 1)) / n2;
            n2 = (this.imgInfo.rows + n3 / 2) / n3;
        }
        PngHelperInternal.debug("rows :" + n2 + "/" + this.imgInfo.rows);
        return n2;
    }

    private int getBestCompressor() {
        int n2;
        double d2 = Double.MAX_VALUE;
        int n3 = -1;
        int n4 = n2 = this.tryAdaptive ? 5 : 4;
        while (n2 >= 0) {
            CompressorStream compressorStream = this.filterBank[n2];
            double d3 = compressorStream.getCompressionRatio();
            if (d3 <= d2) {
                n3 = n2;
                d2 = d3;
            }
            --n2;
        }
        return n3;
    }

    protected void initParams() {
        if (this.imgInfo.cols < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        if (this.imgInfo.rows < 3 && !FilterType.isValidStandard(this.filterType)) {
            this.filterType = FilterType.FILTER_DEFAULT;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            if (this.filteredRows[i2] != null && this.filteredRows[i2].length >= this.buflen) continue;
            this.filteredRows[i2] = new byte[this.buflen];
        }
        if (this.rowsPerBand == 0) {
            this.rowsPerBand = this.computeInitialRowsPerBand();
        }
    }

    public void close() {
        super.close();
        this.rows.clear();
        for (CompressorStream compressorStream : this.filterBank) {
            compressorStream.close();
        }
    }

    public void setHintMemoryKb(int n2) {
        this.hintMemoryKb = n2 <= 0 ? 100 : (n2 > 10000 ? 10000 : n2);
    }

    public void setHintRowsPerBand(int n2) {
        this.hintRowsPerBand = n2;
    }

    public void setUseLz4(boolean bl2) {
        this.useLz4 = bl2;
    }

    public FiltersPerformance getFiltersPerf() {
        return this.filtersPerf;
    }
}

