/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.DeflaterEstimatorLz4;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressorStreamLz4
extends CompressorStream {
    private final DeflaterEstimatorLz4 lz4 = new DeflaterEstimatorLz4();
    private byte[] buf;
    private final int buffer_size;
    private int inbuf = 0;
    private static final int MAX_BUFFER_SIZE = 16000;

    public CompressorStreamLz4(OutputStream outputStream, int n2, long l2) {
        super(outputStream, n2, l2);
        this.buffer_size = (int)(l2 > 16000L ? 16000L : l2);
    }

    public CompressorStreamLz4(OutputStream outputStream, int n2, long l2, Deflater deflater) {
        this(outputStream, n2, l2);
    }

    public CompressorStreamLz4(OutputStream outputStream, int n2, long l2, int n3, int n4) {
        this(outputStream, n2, l2);
    }

    public void mywrite(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.bytesIn += (long)n3;
        while (n3 > 0) {
            int n4;
            if (this.inbuf == 0 && (n3 >= 16000 || this.bytesIn == this.totalbytes)) {
                this.bytesOut += (long)this.lz4.compressEstim(byArray, n2, n3);
                n3 = 0;
                continue;
            }
            if (this.buf == null) {
                this.buf = new byte[this.buffer_size];
            }
            int n5 = n4 = this.inbuf + n3 <= this.buffer_size ? n3 : this.buffer_size - this.inbuf;
            if (n4 > 0) {
                System.arraycopy(byArray, n2, this.buf, this.inbuf, n4);
            }
            this.inbuf += n4;
            n3 -= n4;
            n2 += n4;
            if (this.inbuf != this.buffer_size) continue;
            this.compressFromBuffer();
        }
    }

    void compressFromBuffer() {
        if (this.inbuf > 0) {
            this.bytesOut += (long)this.lz4.compressEstim(this.buf, 0, this.inbuf);
            this.inbuf = 0;
        }
    }

    public void done() {
        if (!this.done) {
            this.compressFromBuffer();
            this.done = true;
            this.flush();
        }
    }

    public void close() {
        this.done();
        if (!this.closed) {
            super.close();
            this.buf = null;
        }
    }

    public void reset() {
        this.done();
        super.reset();
    }
}

