/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;
import java.util.Calendar;

public class PngChunkTIME
extends PngChunkSingle {
    public static final String ID = "tIME";
    private int year;
    private int mon;
    private int day;
    private int hour;
    private int min;
    private int sec;

    public PngChunkTIME(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NONE;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(7, true);
        PngHelperInternal.writeInt2tobytes(this.year, chunkRaw.data, 0);
        chunkRaw.data[2] = (byte)this.mon;
        chunkRaw.data[3] = (byte)this.day;
        chunkRaw.data[4] = (byte)this.hour;
        chunkRaw.data[5] = (byte)this.min;
        chunkRaw.data[6] = (byte)this.sec;
        return chunkRaw;
    }

    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 7) {
            throw new PngjException("bad chunk " + chunkRaw);
        }
        this.year = PngHelperInternal.readInt2fromBytes(chunkRaw.data, 0);
        this.mon = PngHelperInternal.readInt1fromByte(chunkRaw.data, 2);
        this.day = PngHelperInternal.readInt1fromByte(chunkRaw.data, 3);
        this.hour = PngHelperInternal.readInt1fromByte(chunkRaw.data, 4);
        this.min = PngHelperInternal.readInt1fromByte(chunkRaw.data, 5);
        this.sec = PngHelperInternal.readInt1fromByte(chunkRaw.data, 6);
    }

    public void setNow(int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis() - 1000L * (long)n2);
        this.year = calendar.get(1);
        this.mon = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.min = calendar.get(12);
        this.sec = calendar.get(13);
    }

    public void setYMDHMS(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.year = n2;
        this.mon = n3;
        this.day = n4;
        this.hour = n5;
        this.min = n6;
        this.sec = n7;
    }

    public int[] getYMDHMS() {
        return new int[]{this.year, this.mon, this.day, this.hour, this.min, this.sec};
    }

    public String getAsString() {
        return String.format("%04d/%02d/%02d %02d:%02d:%02d", this.year, this.mon, this.day, this.hour, this.min, this.sec);
    }
}

