/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.IChunkFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkBKGD;
import ar.com.hjg.pngj.chunks.PngChunkCHRM;
import ar.com.hjg.pngj.chunks.PngChunkGAMA;
import ar.com.hjg.pngj.chunks.PngChunkHIST;
import ar.com.hjg.pngj.chunks.PngChunkICCP;
import ar.com.hjg.pngj.chunks.PngChunkIDAT;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkITXT;
import ar.com.hjg.pngj.chunks.PngChunkOFFS;
import ar.com.hjg.pngj.chunks.PngChunkPHYS;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkSBIT;
import ar.com.hjg.pngj.chunks.PngChunkSPLT;
import ar.com.hjg.pngj.chunks.PngChunkSRGB;
import ar.com.hjg.pngj.chunks.PngChunkSTER;
import ar.com.hjg.pngj.chunks.PngChunkTEXT;
import ar.com.hjg.pngj.chunks.PngChunkTIME;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import ar.com.hjg.pngj.chunks.PngChunkUNKNOWN;
import ar.com.hjg.pngj.chunks.PngChunkZTXT;

public class ChunkFactory
implements IChunkFactory {
    boolean parse;

    public ChunkFactory() {
        this(true);
    }

    public ChunkFactory(boolean bl2) {
        this.parse = bl2;
    }

    public final PngChunk createChunk(ChunkRaw chunkRaw, ImageInfo imageInfo) {
        PngChunk pngChunk = this.createEmptyChunkKnown(chunkRaw.id, imageInfo);
        if (pngChunk == null) {
            pngChunk = this.createEmptyChunkExtended(chunkRaw.id, imageInfo);
        }
        if (pngChunk == null) {
            pngChunk = this.createEmptyChunkUnknown(chunkRaw.id, imageInfo);
        }
        pngChunk.setRaw(chunkRaw);
        if (this.parse && chunkRaw.data != null) {
            pngChunk.parseFromRaw(chunkRaw);
        }
        return pngChunk;
    }

    protected final PngChunk createEmptyChunkKnown(String string, ImageInfo imageInfo) {
        if (string.equals("IDAT")) {
            return new PngChunkIDAT(imageInfo);
        }
        if (string.equals("IHDR")) {
            return new PngChunkIHDR(imageInfo);
        }
        if (string.equals("PLTE")) {
            return new PngChunkPLTE(imageInfo);
        }
        if (string.equals("IEND")) {
            return new PngChunkIEND(imageInfo);
        }
        if (string.equals("tEXt")) {
            return new PngChunkTEXT(imageInfo);
        }
        if (string.equals("iTXt")) {
            return new PngChunkITXT(imageInfo);
        }
        if (string.equals("zTXt")) {
            return new PngChunkZTXT(imageInfo);
        }
        if (string.equals("bKGD")) {
            return new PngChunkBKGD(imageInfo);
        }
        if (string.equals("gAMA")) {
            return new PngChunkGAMA(imageInfo);
        }
        if (string.equals("pHYs")) {
            return new PngChunkPHYS(imageInfo);
        }
        if (string.equals("iCCP")) {
            return new PngChunkICCP(imageInfo);
        }
        if (string.equals("tIME")) {
            return new PngChunkTIME(imageInfo);
        }
        if (string.equals("tRNS")) {
            return new PngChunkTRNS(imageInfo);
        }
        if (string.equals("cHRM")) {
            return new PngChunkCHRM(imageInfo);
        }
        if (string.equals("sBIT")) {
            return new PngChunkSBIT(imageInfo);
        }
        if (string.equals("sRGB")) {
            return new PngChunkSRGB(imageInfo);
        }
        if (string.equals("hIST")) {
            return new PngChunkHIST(imageInfo);
        }
        if (string.equals("sPLT")) {
            return new PngChunkSPLT(imageInfo);
        }
        return null;
    }

    protected final PngChunk createEmptyChunkUnknown(String string, ImageInfo imageInfo) {
        return new PngChunkUNKNOWN(string, imageInfo);
    }

    protected PngChunk createEmptyChunkExtended(String string, ImageInfo imageInfo) {
        if (string.equals("oFFs")) {
            return new PngChunkOFFS(imageInfo);
        }
        if (string.equals("sTER")) {
            return new PngChunkSTER(imageInfo);
        }
        return null;
    }
}

