/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngIDatChunkOutputStream;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkCopyBehaviour;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngMetadata;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import ar.com.hjg.pngj.pixels.PixelsWriterDefault;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngWriter {
    public final ImageInfo imgInfo;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    private int passes = 1;
    private int currentpass = 0;
    private boolean shouldCloseStream = true;
    private int idatMaxSize = 0;
    private PngIDatChunkOutputStream datStream;
    protected PixelsWriter pixelsWriter;
    private final OutputStream os;
    private ChunkPredicate copyFromPredicate = null;
    private ChunksList copyFromList = null;
    protected StringBuilder debuginfo = new StringBuilder();

    public PngWriter(File file, ImageInfo imageInfo, boolean bl2) {
        this(PngHelperInternal.ostreamFromFile(file, bl2), imageInfo);
        this.setShouldCloseStream(true);
    }

    public PngWriter(File file, ImageInfo imageInfo) {
        this(file, imageInfo, true);
    }

    public PngWriter(OutputStream outputStream, ImageInfo imageInfo) {
        this.os = outputStream;
        this.imgInfo = imageInfo;
        this.chunksList = new ChunksListForWrite(imageInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.pixelsWriter = this.createPixelsWriter(imageInfo);
        this.setCompLevel(9);
    }

    private void initIdat() {
        this.datStream = new PngIDatChunkOutputStream(this.os, this.idatMaxSize);
        this.pixelsWriter.setOs(this.datStream);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void writeEndChunk() {
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(pngChunkIEND);
    }

    private void writeFirstChunks() {
        if (this.currentChunkGroup >= 4) {
            return;
        }
        int n2 = 0;
        this.currentChunkGroup = 1;
        this.queueChunksFromOther();
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (n2 > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n2 == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n2 = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void writeLastChunks() {
        this.queueChunksFromOther();
        this.currentChunkGroup = 5;
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> list = this.chunksList.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void writeSignatureAndIHDR() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR pngChunkIHDR = new PngChunkIHDR(this.imgInfo);
        pngChunkIHDR.setCols(this.imgInfo.cols);
        pngChunkIHDR.setRows(this.imgInfo.rows);
        pngChunkIHDR.setBitspc(this.imgInfo.bitDepth);
        int n2 = 0;
        if (this.imgInfo.alpha) {
            n2 += 4;
        }
        if (this.imgInfo.indexed) {
            ++n2;
        }
        if (!this.imgInfo.greyscale) {
            n2 += 2;
        }
        pngChunkIHDR.setColormodel(n2);
        pngChunkIHDR.setCompmeth(0);
        pngChunkIHDR.setFilmeth(0);
        pngChunkIHDR.setInterlaced(0);
        pngChunkIHDR.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(pngChunkIHDR);
    }

    private void queueChunksFromOther() {
        if (this.copyFromList == null || this.copyFromPredicate == null) {
            return;
        }
        boolean bl2 = this.currentChunkGroup >= 4;
        for (PngChunk pngChunk : this.copyFromList.getChunks()) {
            boolean bl3;
            int n2;
            if (pngChunk.getRaw().data == null || (n2 = pngChunk.getChunkGroup()) <= 4 && bl2 || n2 >= 4 && !bl2 || pngChunk.crit && !pngChunk.id.equals("PLTE") || !(bl3 = this.copyFromPredicate.match(pngChunk)) || !this.chunksList.getEquivalent(pngChunk).isEmpty() || !this.chunksList.getQueuedEquivalent(pngChunk).isEmpty()) continue;
            this.chunksList.queue(pngChunk);
        }
    }

    public void queueChunk(PngChunk pngChunk) {
        for (PngChunk pngChunk2 : this.chunksList.getQueuedEquivalent(pngChunk)) {
            this.getChunksList().removeChunk(pngChunk2);
        }
        this.chunksList.queue(pngChunk);
    }

    public void copyChunksFrom(ChunksList chunksList, int n2) {
        this.copyChunksFrom(chunksList, ChunkCopyBehaviour.createPredicate(n2, this.imgInfo));
    }

    public void copyChunksFrom(ChunksList chunksList) {
        this.copyChunksFrom(chunksList, 8);
    }

    public void copyChunksFrom(ChunksList chunksList, ChunkPredicate chunkPredicate) {
        if (this.copyFromList != null && chunksList != null) {
            PngHelperInternal.LOGGER.warning("copyChunksFrom should only be called once");
        }
        if (chunkPredicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.copyFromList = chunksList;
        this.copyFromPredicate = chunkPredicate;
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double d2 = this.datStream.getCountFlushed();
        double d3 = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return d2 / d3;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStream.flush();
            this.writeLastChunks();
            this.writeEndChunk();
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            if (this.datStream != null) {
                this.datStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.pixelsWriter != null) {
            this.pixelsWriter.close();
        }
        if (this.shouldCloseStream && this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                PngHelperInternal.LOGGER.warning("Error closing writer " + exception.toString());
            }
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setFilterType(FilterType filterType) {
        this.pixelsWriter.setFilterType(filterType);
    }

    public void setCompLevel(int n2) {
        this.pixelsWriter.setDeflaterCompLevel(n2);
    }

    public void setFilterPreserve(boolean bl2) {
        if (bl2) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_PRESERVE);
        } else if (this.pixelsWriter.getFilterType() == null) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_DEFAULT);
        }
    }

    public void setIdatMaxSize(int n2) {
        this.idatMaxSize = n2;
    }

    public void setShouldCloseStream(boolean bl2) {
        this.shouldCloseStream = bl2;
    }

    public void writeRow(IImageLine iImageLine) {
        this.writeRow(iImageLine, this.rowNum + 1);
    }

    public void writeRows(IImageLineSet<? extends IImageLine> iImageLineSet) {
        for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
            this.writeRow(iImageLineSet.getImageLine(i2));
        }
    }

    public void writeRow(IImageLine iImageLine, int n2) {
        ++this.rowNum;
        if (this.rowNum == this.imgInfo.rows) {
            this.rowNum = 0;
        }
        if (n2 == this.imgInfo.rows) {
            n2 = 0;
        }
        if (n2 >= 0 && this.rowNum != n2) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + n2);
        }
        if (this.rowNum == 0) {
            ++this.currentpass;
        }
        if (n2 == 0 && this.currentpass == this.passes) {
            this.initIdat();
            this.writeFirstChunks();
        }
        byte[] byArray = this.pixelsWriter.getRowb();
        iImageLine.writeToPngRaw(byArray);
        this.pixelsWriter.processRow(byArray);
    }

    public void writeRowInt(int[] nArray) {
        this.writeRow(new ImageLineInt(this.imgInfo, nArray));
    }

    protected PixelsWriter createPixelsWriter(ImageInfo imageInfo) {
        PixelsWriterDefault pixelsWriterDefault = new PixelsWriterDefault(imageInfo);
        return pixelsWriterDefault;
    }

    public final PixelsWriter getPixelsWriter() {
        return this.pixelsWriter;
    }

    public String getDebuginfo() {
        return this.debuginfo.toString();
    }
}

