/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.BufferedStreamFeeder;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IImageLineSetFactory;
import ar.com.hjg.pngj.IdatSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineSetDefault;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkLoadBehaviour;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.PngMetadata;
import java.io.File;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngReader {
    public static final long MAX_TOTAL_BYTES_READ_DEFAULT = 901001001L;
    public static final long MAX_BYTES_METADATA_DEFAULT = 5024024L;
    public static final long MAX_CHUNK_SIZE_SKIP = 2024024L;
    public final ImageInfo imgInfo;
    public final boolean interlaced;
    protected ChunkSeqReaderPng chunkseq;
    protected BufferedStreamFeeder streamFeeder;
    protected final PngMetadata metadata;
    protected int rowNum = -1;
    CRC32 idatCrca;
    Adler32 idatCrcb;
    protected IImageLineSet<? extends IImageLine> imlinesSet;
    private IImageLineSetFactory<? extends IImageLine> imageLineSetFactory;

    public PngReader(InputStream inputStream) {
        this(inputStream, true);
    }

    public PngReader(InputStream inputStream, boolean bl2) {
        try {
            this.streamFeeder = new BufferedStreamFeeder(inputStream);
            this.streamFeeder.setCloseStream(bl2);
            this.chunkseq = new ChunkSeqReaderPng(false);
            this.streamFeeder.setFailIfNoFeed(true);
            if (!this.streamFeeder.feedFixed(this.chunkseq, 36)) {
                throw new PngjInputException("error reading first 21 bytes");
            }
            this.imgInfo = this.chunkseq.getImageInfo();
            this.interlaced = this.chunkseq.getDeinterlacer() != null;
            this.setMaxBytesMetadata(5024024L);
            this.setMaxTotalBytesRead(901001001L);
            this.setSkipChunkMaxSize(2024024L);
            this.metadata = new PngMetadata(this.chunkseq.chunksList);
            this.setLineSetFactory(ImageLineSetDefault.getFactoryInt());
            this.rowNum = -1;
        }
        catch (RuntimeException runtimeException) {
            this.streamFeeder.close();
            if (this.chunkseq != null) {
                this.chunkseq.close();
            }
            throw runtimeException;
        }
    }

    public PngReader(File file) {
        this(PngHelperInternal.istreamFromFile(file), true);
    }

    protected void readFirstChunks() {
        while (this.chunkseq.currentChunkGroup < 4) {
            this.streamFeeder.feed(this.chunkseq);
        }
    }

    public void setChunkLoadBehaviour(ChunkLoadBehaviour chunkLoadBehaviour) {
        this.chunkseq.setChunkLoadBehaviour(chunkLoadBehaviour);
    }

    public ChunksList getChunksList() {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.chunkseq.chunksList;
    }

    int getCurrentChunkGroup() {
        return this.chunkseq.currentChunkGroup;
    }

    public PngMetadata getMetadata() {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        return this.metadata;
    }

    public IImageLine readRow() {
        return this.readRow(this.rowNum + 1);
    }

    public boolean hasMoreRows() {
        return this.rowNum < this.imgInfo.rows - 1;
    }

    public IImageLine readRow(int n2) {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (!this.interlaced) {
            if (this.imlinesSet == null) {
                this.imlinesSet = this.createLineSet(true, 1, 0, 1);
            }
            IImageLine iImageLine = this.imlinesSet.getImageLine(n2);
            if (n2 == this.rowNum) {
                return iImageLine;
            }
            if (n2 < this.rowNum) {
                throw new PngjInputException("rows must be read in increasing order: " + n2);
            }
            while (this.rowNum < n2) {
                while (!this.chunkseq.getIdatSet().isRowReady()) {
                    this.streamFeeder.feed(this.chunkseq);
                }
                ++this.rowNum;
                this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
                if (this.rowNum == n2) {
                    iImageLine.readFromPngRaw(this.chunkseq.getIdatSet().getUnfilteredRow(), this.imgInfo.bytesPerRow + 1, 0, 1);
                    iImageLine.endReadFromPngRaw();
                }
                this.chunkseq.getIdatSet().advanceToNextRow();
            }
            return iImageLine;
        }
        if (this.imlinesSet == null) {
            this.imlinesSet = this.createLineSet(false, this.imgInfo.rows, 0, 1);
            this.loadAllInterlaced(this.imgInfo.rows, 0, 1);
        }
        this.rowNum = n2;
        return this.imlinesSet.getImageLine(n2);
    }

    public IImageLineSet<? extends IImageLine> readRows() {
        return this.readRows(this.imgInfo.rows, 0, 1);
    }

    public IImageLineSet<? extends IImageLine> readRows(int n2, int n3, int n4) {
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        if (n2 < 0) {
            n2 = (this.imgInfo.rows - n3) / n4;
        }
        if (n4 < 1 || n3 < 0 || n2 == 0 || n2 * n4 + n3 > this.imgInfo.rows) {
            throw new PngjInputException("bad args");
        }
        if (this.rowNum >= 0) {
            throw new PngjInputException("readRows cannot be mixed with readRow");
        }
        this.imlinesSet = this.createLineSet(false, n2, n3, n4);
        if (!this.interlaced) {
            int n5 = -1;
            while (n5 < n2 - 1) {
                while (!this.chunkseq.getIdatSet().isRowReady()) {
                    this.streamFeeder.feed(this.chunkseq);
                }
                ++this.rowNum;
                this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
                n5 = (this.rowNum - n3) / n4;
                if (this.rowNum >= n3 && n4 * n5 + n3 == this.rowNum) {
                    IImageLine iImageLine = this.imlinesSet.getImageLine(this.rowNum);
                    iImageLine.readFromPngRaw(this.chunkseq.getIdatSet().getUnfilteredRow(), this.imgInfo.bytesPerRow + 1, 0, 1);
                    iImageLine.endReadFromPngRaw();
                }
                this.chunkseq.getIdatSet().advanceToNextRow();
            }
        } else {
            this.loadAllInterlaced(n2, n3, n4);
        }
        this.chunkseq.getIdatSet().done();
        this.end();
        return this.imlinesSet;
    }

    public void setLineSetFactory(IImageLineSetFactory<? extends IImageLine> iImageLineSetFactory) {
        this.imageLineSetFactory = iImageLineSetFactory;
    }

    protected IImageLineSet<? extends IImageLine> createLineSet(boolean bl2, int n2, int n3, int n4) {
        return this.imageLineSetFactory.create(this.imgInfo, bl2, n2, n3, n4);
    }

    protected void loadAllInterlaced(int n2, int n3, int n4) {
        int n5;
        int n6;
        IdatSet idatSet = this.chunkseq.getIdatSet();
        int n7 = 0;
        while (true) {
            if (!this.chunkseq.getIdatSet().isRowReady()) {
                this.streamFeeder.feed(this.chunkseq);
                continue;
            }
            this.chunkseq.getIdatSet().updateCrcs(this.idatCrca, this.idatCrcb);
            n6 = idatSet.rowinfo.rowNreal;
            int n8 = n5 = (n6 - n3) % n4 == 0 ? 1 : 0;
            if (n5 != 0) {
                this.imlinesSet.getImageLine(n6).readFromPngRaw(idatSet.getUnfilteredRow(), idatSet.rowinfo.buflen, idatSet.rowinfo.oX, idatSet.rowinfo.dX);
                ++n7;
            }
            idatSet.advanceToNextRow();
            if (n7 >= n2 && idatSet.isDone()) break;
        }
        idatSet.done();
        n6 = 0;
        n5 = n3;
        while (n6 < n2) {
            this.imlinesSet.getImageLine(n5).endReadFromPngRaw();
            ++n6;
            n5 += n4;
        }
    }

    public void readSkippingAllRows() {
        this.chunkseq.addChunkToSkip("IDAT");
        if (this.chunkseq.firstChunksNotYetRead()) {
            this.readFirstChunks();
        }
        this.end();
    }

    public void setMaxTotalBytesRead(long l2) {
        this.chunkseq.setMaxTotalBytesRead(l2);
    }

    public void setMaxBytesMetadata(long l2) {
        this.chunkseq.setMaxBytesMetadata(l2);
    }

    public void setSkipChunkMaxSize(long l2) {
        this.chunkseq.setSkipChunkMaxSize(l2);
    }

    public void setChunksToSkip(String ... stringArray) {
        this.chunkseq.setChunksToSkip(stringArray);
    }

    public void addChunkToSkip(String string) {
        this.chunkseq.addChunkToSkip(string);
    }

    public void setShouldCloseStream(boolean bl2) {
        this.streamFeeder.setCloseStream(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        try {
            if (this.chunkseq.firstChunksNotYetRead()) {
                this.readFirstChunks();
            }
            if (this.chunkseq.getIdatSet() != null && !this.chunkseq.getIdatSet().isDone()) {
                this.chunkseq.getIdatSet().done();
            }
            while (!this.chunkseq.isDone()) {
                this.streamFeeder.feed(this.chunkseq);
            }
        }
        finally {
            this.close();
        }
    }

    public void close() {
        try {
            if (this.chunkseq != null) {
                this.chunkseq.close();
            }
        }
        catch (Exception exception) {
            PngHelperInternal.LOGGER.warning("error closing chunk sequence:" + exception.getMessage());
        }
        if (this.streamFeeder != null) {
            this.streamFeeder.close();
        }
    }

    public boolean isInterlaced() {
        return this.interlaced;
    }

    public void setCrcCheckDisabled() {
        this.chunkseq.setCheckCrc(false);
    }

    public ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }

    public void prepareSimpleDigestComputation() {
        if (this.idatCrca == null) {
            this.idatCrca = new CRC32();
        } else {
            this.idatCrca.reset();
        }
        if (this.idatCrcb == null) {
            this.idatCrcb = new Adler32();
        } else {
            this.idatCrcb.reset();
        }
        this.idatCrca.update((byte)this.imgInfo.rows);
        this.idatCrca.update((byte)(this.imgInfo.rows >> 8));
        this.idatCrca.update((byte)(this.imgInfo.rows >> 16));
        this.idatCrca.update((byte)this.imgInfo.cols);
        this.idatCrca.update((byte)(this.imgInfo.cols >> 8));
        this.idatCrca.update((byte)(this.imgInfo.cols >> 16));
        this.idatCrca.update((byte)this.imgInfo.channels);
        this.idatCrca.update((byte)this.imgInfo.bitDepth);
        this.idatCrca.update((byte)(this.imgInfo.indexed ? 10 : 20));
        this.idatCrcb.update((byte)this.imgInfo.bytesPerRow);
        this.idatCrcb.update((byte)this.imgInfo.channels);
        this.idatCrcb.update((byte)this.imgInfo.rows);
    }

    long getSimpleDigest() {
        if (this.idatCrca == null) {
            return 0L;
        }
        return this.idatCrca.getValue() ^ this.idatCrcb.getValue() << 31;
    }

    public String getSimpleDigestHex() {
        return String.format("%016X", this.getSimpleDigest());
    }

    public String toString() {
        return this.imgInfo.toString() + " interlaced=" + this.interlaced;
    }

    public String toStringCompact() {
        return this.imgInfo.toStringBrief() + (this.interlaced ? "i" : "");
    }
}

