/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ProgressiveOutputStream;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import java.io.OutputStream;

public class PngIDatChunkOutputStream
extends ProgressiveOutputStream {
    private static final int SIZE_DEFAULT = 32768;
    private final OutputStream outputStream;
    private byte[] prefix = null;

    public PngIDatChunkOutputStream(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public PngIDatChunkOutputStream(OutputStream outputStream, int n2) {
        super(n2 > 0 ? n2 : 32768);
        this.outputStream = outputStream;
    }

    protected final void flushBuffer(byte[] byArray, int n2) {
        int n3 = this.prefix == null ? n2 : n2 + this.prefix.length;
        ChunkRaw chunkRaw = new ChunkRaw(n3, ChunkHelper.b_IDAT, false);
        if (n2 == n3) {
            chunkRaw.data = byArray;
        }
        chunkRaw.writeChunk(this.outputStream);
    }

    void setPrefix(byte[] byArray) {
        if (byArray == null) {
            this.prefix = null;
        } else {
            this.prefix = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.prefix, 0, byArray.length);
        }
    }
}

