/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.IImageLineSetFactory;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineByte;
import ar.com.hjg.pngj.ImageLineInt;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageLineSetDefault<T extends IImageLine>
implements IImageLineSet<T> {
    protected final ImageInfo imgInfo;
    private final boolean singleCursor;
    private final int nlines;
    private final int offset;
    private final int step;
    protected List<T> imageLines;
    protected T imageLine;
    protected int currentRow = -1;

    public ImageLineSetDefault(ImageInfo imageInfo, boolean bl2, int n2, int n3, int n4) {
        this.imgInfo = imageInfo;
        this.singleCursor = bl2;
        if (bl2) {
            this.nlines = 1;
            this.offset = 0;
            this.step = 1;
        } else {
            this.nlines = imageInfo.rows;
            this.offset = 0;
            this.step = 1;
        }
        this.createImageLines();
    }

    private void createImageLines() {
        if (this.singleCursor) {
            this.imageLine = this.createImageLine();
        } else {
            this.imageLines = new ArrayList<T>();
            for (int i2 = 0; i2 < this.nlines; ++i2) {
                this.imageLines.add(this.createImageLine());
            }
        }
    }

    protected abstract T createImageLine();

    @Override
    public T getImageLine(int n2) {
        this.currentRow = n2;
        if (this.singleCursor) {
            return this.imageLine;
        }
        return (T)((IImageLine)this.imageLines.get(this.imageRowToMatrixRowStrict(n2)));
    }

    @Override
    public boolean hasImageLine(int n2) {
        return this.singleCursor ? this.currentRow == n2 : this.imageRowToMatrixRowStrict(n2) >= 0;
    }

    @Override
    public int size() {
        return this.nlines;
    }

    public int imageRowToMatrixRowStrict(int n2) {
        int n3 = (n2 -= this.offset) >= 0 && n2 % this.step == 0 ? n2 / this.step : -1;
        return n3 < this.nlines ? n3 : -1;
    }

    public int matrixRowToImageRow(int n2) {
        return n2 * this.step + this.offset;
    }

    public int imageRowToMatrixRow(int n2) {
        int n3 = (n2 - this.offset) / this.step;
        return n3 < 0 ? 0 : (n3 < this.nlines ? n3 : this.nlines - 1);
    }

    public static IImageLineSetFactory<ImageLineInt> getFactoryInt() {
        return new IImageLineSetFactory<ImageLineInt>(){

            @Override
            public IImageLineSet<ImageLineInt> create(ImageInfo imageInfo, boolean bl2, int n2, int n3, int n4) {
                return new ImageLineSetDefault<ImageLineInt>(imageInfo, bl2, n2, n3, n4){

                    @Override
                    protected ImageLineInt createImageLine() {
                        return new ImageLineInt(this.imgInfo);
                    }
                };
            }
        };
    }

    public static IImageLineSetFactory<ImageLineByte> getFactoryByte() {
        return new IImageLineSetFactory<ImageLineByte>(){

            @Override
            public IImageLineSet<ImageLineByte> create(ImageInfo imageInfo, boolean bl2, int n2, int n3, int n4) {
                return new ImageLineSetDefault<ImageLineByte>(imageInfo, bl2, n2, n3, n4){

                    @Override
                    protected ImageLineByte createImageLine() {
                        return new ImageLineByte(this.imgInfo);
                    }
                };
            }
        };
    }
}

