/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.IBytesConsumer;
import ar.com.hjg.pngj.PngjInputException;
import java.io.IOException;
import java.io.InputStream;

public class BufferedStreamFeeder {
    private InputStream stream;
    private byte[] buf;
    private int pendinglen;
    private int offset;
    private boolean eof = false;
    private boolean closeStream = true;
    private boolean failIfNoFeed = false;
    private static final int DEFAULTSIZE = 8192;

    public BufferedStreamFeeder(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public BufferedStreamFeeder(InputStream inputStream, int n2) {
        this.stream = inputStream;
        this.buf = new byte[n2 < 1 ? 8192 : n2];
    }

    public InputStream getStream() {
        return this.stream;
    }

    public int feed(IBytesConsumer iBytesConsumer) {
        return this.feed(iBytesConsumer, -1);
    }

    public int feed(IBytesConsumer iBytesConsumer, int n2) {
        int n3;
        int n4 = 0;
        if (this.pendinglen == 0) {
            this.refillBuffer();
        }
        int n5 = n3 = n2 > 0 && n2 < this.pendinglen ? n2 : this.pendinglen;
        if (n3 > 0 && (n4 = iBytesConsumer.consume(this.buf, this.offset, n3)) > 0) {
            this.offset += n4;
            this.pendinglen -= n4;
        }
        if (n4 < 1 && this.failIfNoFeed) {
            throw new PngjInputException("failed feed bytes");
        }
        return n4;
    }

    public boolean feedFixed(IBytesConsumer iBytesConsumer, int n2) {
        int n3;
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            n3 = this.feed(iBytesConsumer, i2);
            if (n3 >= 1) continue;
            return false;
        }
        return true;
    }

    protected void refillBuffer() {
        if (this.pendinglen > 0 || this.eof) {
            return;
        }
        try {
            this.offset = 0;
            this.pendinglen = this.stream.read(this.buf);
            if (this.pendinglen < 0) {
                this.close();
                return;
            }
            return;
        }
        catch (IOException iOException) {
            throw new PngjInputException(iOException);
        }
    }

    public boolean hasMoreToFeed() {
        if (this.eof) {
            return this.pendinglen > 0;
        }
        this.refillBuffer();
        return this.pendinglen > 0;
    }

    public void setCloseStream(boolean bl2) {
        this.closeStream = bl2;
    }

    public void close() {
        this.eof = true;
        this.buf = null;
        this.pendinglen = 0;
        this.offset = 0;
        if (this.stream != null && this.closeStream) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.stream = null;
    }

    public void setInputStream(InputStream inputStream) {
        this.stream = inputStream;
        this.eof = false;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setFailIfNoFeed(boolean bl2) {
        this.failIfNoFeed = bl2;
    }
}

