/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.arh;
import us.hebi.gui.lib.ari;
import us.hebi.gui.lib.ark;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.aru;
import us.hebi.gui.lib.ary;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.auy;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avf;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awb;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.bap;
import us.hebi.gui.lib.bbj;
import us.hebi.gui.lib.bbk;
import us.hebi.gui.lib.bbl;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.bdb;
import us.hebi.gui.lib.bdd;
import us.hebi.gui.lib.bde;
import us.hebi.gui.lib.bdg;
import us.hebi.gui.lib.bea;
import us.hebi.gui.lib.fe;
import us.hebi.gui.lib.h;
import us.hebi.gui.views.scope.assets.Asset;
import us.hebi.gui.views.teachrepeat.state.ForwardKinematicsSampler;
import us.hebi.gui.views.teachrepeat.state.PickableWaypoints3D;
import us.hebi.gui.views.teachrepeat.state.TrajectorySampler;
import us.hebi.gui.views.teachrepeat.state.UpdatableGroupTrajectory;
import us.hebi.gui.views.teachrepeat.state.Waypoint;
import us.hebi.gui.views.teachrepeat.state.WaypointDataSet;
import us.hebi.gui.views.teachrepeat.state.WaypointDataSetRenderer;
import us.hebi.gui.views.teachrepeat.state.WaypointList;

public class TeachRepeatPresenter
extends axy {
    @FXML
    Pane root;
    @FXML
    Pane menuPane;
    @FXML
    ScrollPane waypointPane;
    @FXML
    ListView<Waypoint> waypointListView;
    @FXML
    Pane pane3d;
    @FXML
    Pane pane2d;
    @FXML
    Pane ikPane;
    @FXML
    private Button ikIncreaseX;
    @FXML
    private Button ikDecreaseX;
    @FXML
    private Button ikIncreaseY;
    @FXML
    private Button ikDecreaseY;
    @FXML
    private Button ikIncreaseZ;
    @FXML
    private Button ikDecreaseZ;
    final aro xyzLine = new aro().a(true);
    final PickableWaypoints3D xyzWaypoints = new PickableWaypoints3D();
    XYChart jointPosChart;
    private static final double LINEAR_INTERP_DISTANCE = anc.b.e(25.0);
    List<XValueIndicator> timeIndicators = new ArrayList<XValueIndicator>();
    ObjectProperty<Waypoint> selectedWaypoint = new SimpleObjectProperty((Object)Waypoint.newMove(0));
    public DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    @Inject
    arh robotModel;
    @Inject
    auc fileChooser;
    @Inject
    WaypointList waypoints;
    @Inject
    UpdatableGroupTrajectory groupTrajectory;
    static final int maxSamples2d = 1000;
    final ForwardKinematicsSampler cartesianSamplesCont = ForwardKinematicsSampler.createContinuous(1000);
    final ForwardKinematicsSampler cartesianSamplesKey = ForwardKinematicsSampler.createKeyFrame();
    final auy colorIndex = new auy();
    final double len = 100.0;
    final Node worldFrame = aru.a(100.0, 3.0, 10);
    final Node cubeWorld = new ark(2000.0).a();
    final ary worldScene = new ary(new Node[0]);

    @FXML
    public void selectHrdf(ActionEvent actionEvent) {
        Window window;
        File file;
        if (ayo.aV()) {
            Asset.loadCommonAssets();
        }
        if ((file = this.fileChooser.b(window = ayo.a(actionEvent))) == null) {
            return;
        }
        File file2 = file;
        this.robotModel.h.set((Object)file2);
    }

    public void updateCharts2d() {
        int n2 = this.waypoints.getNumJoints();
        Renderer renderer = (Renderer)this.jointPosChart.getRenderers().get(0);
        String string = DataSetStyleBuilder.instance().setMarkerSize(4.0).build();
        Renderer renderer2 = (Renderer)this.jointPosChart.getRenderers().get(1);
        renderer2.setShowInLegend(false);
        if (n2 != renderer.getDatasets().size()) {
            renderer.getDatasets().clear();
            renderer2.getDatasets().clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                bap bap2 = new bap(this, i2);
                DataSetNode dataSetNode = renderer.addDataSet(bap2.setStyle(string));
                renderer2.addDataSet(new avy(bap2.getName())).visibleProperty().bind((ObservableValue)dataSetNode.visibleProperty());
            }
        }
        Object object = renderer.getDatasets().iterator();
        while (object.hasNext()) {
            ((WaypointDataSet)((DataSet)object.next())).setWaypoints((List<Waypoint>)this.waypoints.getList(), this.groupTrajectory);
        }
        if (!this.groupTrajectory.isValid()) {
            return;
        }
        object = this.cartesianSamplesCont.getJointSampler();
        for (int i3 = 0; i3 < n2; ++i3) {
            ((avy)renderer2.getDatasets().get(i3)).b(((TrajectorySampler)object).getTime(), ((TrajectorySampler)object).getJointPosition(i3), ((TrajectorySampler)object).getNumSamples());
        }
    }

    public void updateLine3d() {
        if (!this.groupTrajectory.isValid()) {
            return;
        }
        this.colorIndex.ce = 0;
        Color color = (Color)auy.a(this.colorIndex.ce++).get();
        this.xyzLine.setColor(color);
        this.xyzLine.bk();
        this.cartesianSamplesCont.forEachCartesianSampleScaled(1000.0, (n2, d2, f2, f3, f4) -> {
            if (n2 == 0) {
                this.xyzLine.b(f2, f3, f4);
                this.xyzLine.bl();
                return;
            }
            this.xyzLine.c(f2, f3, f4);
        });
        this.xyzLine.bm();
    }

    public void updateRobotPosition() {
        if (this.groupTrajectory.isValid()) {
            double[] dArray;
            double[] dArray2;
            double d2 = this.selectedTime.get();
            double[] dArray3 = dArray2 = (dArray = this.groupTrajectory.getState(d2).getPosition());
            ari ari2 = (ari)this.robotModel.l.get();
            for (int i2 = 0; i2 < Math.min(dArray3.length, ari2.J.size()); ++i2) {
                ari2.b(i2, dArray3[i2]);
            }
        }
    }

    public void updateTimeIndicators() {
    }

    protected void onUpdate(List<Waypoint> list) {
        this.groupTrajectory.setWaypoints(list);
        if (this.groupTrajectory.isValid()) {
            this.cartesianSamplesKey.setTrajectory(this.groupTrajectory);
            this.cartesianSamplesCont.setTrajectory(this.groupTrajectory);
        } else {
            this.cartesianSamplesKey.clear();
            this.cartesianSamplesCont.clear();
        }
        this.updateCharts2d();
        this.xyzWaypoints.update(this.cartesianSamplesKey);
        this.updateLine3d();
        this.updateRobotPosition();
    }

    @Override
    public void initializeFx() {
        this.worldScene.a(this.pane3d);
        this.worldScene.b.a().setTranslateZ(-800.0);
        this.worldScene.d.getChildren().add(1, (Object)this.robotModel.b);
        this.worldScene.d.getChildren().setAll((Object[])new Node[]{this.robotModel.b, this.xyzWaypoints, this.xyzLine.e, this.worldFrame, this.cubeWorld});
        this.pane3d.visibleProperty().bind((ObservableValue)this.robotModel.cD);
        this.pane3d.managedProperty().bind((ObservableValue)this.pane3d.visibleProperty());
        this.ikPane.visibleProperty().bind((ObservableValue)this.robotModel.cD.and((ObservableBooleanValue)this.selectedWaypoint.isNotNull()));
        this.ikPane.managedProperty().bind((ObservableValue)this.ikPane.visibleProperty());
        this.xyzWaypoints.pickedIndexProperty().bind((ObservableValue)this.waypointListView.getSelectionModel().selectedIndexProperty());
        this.worldScene.d.setOnMouseClicked(this.xyzWaypoints.getPickHandler(n2 -> this.waypointListView.getSelectionModel().select(n2)));
        this.cartesianSamplesCont.forwardKinematicsProperty().bind(this.robotModel.j);
        this.cartesianSamplesKey.forwardKinematicsProperty().bind(this.robotModel.j);
        this.waypoints.addOnUpdate(this::onUpdate);
        this.selectedTime.addListener(observable -> this.updateRobotPosition());
        this.robotModel.j.addListener((observableValue, bcu2, bcu3) -> this.waypoints.setDirty());
        this.waypoints.numWaypointsProperty().addListener(observable -> this.updateTimeIndicators());
        this.jointPosChart = auz.a(-1.0, 1.0, "rad/s");
        this.pane2d.getChildren().setAll((Object[])new Node[]{this.jointPosChart});
        ayo.c(this.jointPosChart);
        this.waypoints.add(Waypoint.newMove(6).setTime(0.0).setPositions(1.39582300186157, 1.08106410503387, 1.65824282169342, 7.68387192884554, 2.54659485816956, 9.45026928583254));
        this.waypoints.add(Waypoint.newMove(6).setTime(1.0).setPositions(0.316830635070801, 1.1332973241806, 1.34299612045288, 8.07372874418368, 0.685708403587341, 9.29459578195681));
        this.waypoints.add(Waypoint.newStop(6).setTime(2.0).setPositions(1.07498550415039, 1.01677846908569, 1.89047479629517, 6.96188486019243, 2.57030248641968, 9.301078144704));
        this.waypoints.add(Waypoint.newMove(6).setTime(3.0).setPositions(1.02414417266846, 1.59279942512512, 1.49439251422882, 5.47959715524782, 3.01673936843872, 9.03658038774599));
        this.waypointListView.setItems(this.waypoints.getList());
        this.selectedWaypoint.addListener((observableValue, waypoint, waypoint2) -> this.selectedTime.set(waypoint2 == null ? 0.0 : waypoint2.time));
        this.selectedWaypoint.bind((ObservableValue)this.waypointListView.getSelectionModel().selectedItemProperty());
        this.jointPosChart.getRenderers().setAll((Object[])new Renderer[]{new WaypointDataSetRenderer(), auz.a()});
        this.jointPosChart.getPlugins().add((Object)new avf());
        XValueIndicator xValueIndicator = new XValueIndicator(this.jointPosChart.getXAxis(), 1.0);
        this.jointPosChart.getPlugins().add((Object)xValueIndicator);
        xValueIndicator.valueProperty().bindBidirectional((Property)this.selectedTime);
    }

    public void interpolateLinear() {
        aa.b(this.robotModel.c.get() == 6, (Object)"Not valid 6 DoF");
        bcu bcu2 = (bcu)this.robotModel.j.get();
        awb awb2 = (awb)this.robotModel.k.get();
        bbj bbj2 = new bbj();
        bbj bbj3 = new bbj();
        bbj bbj4 = new bbj();
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        bbl bbl2 = bbl.c();
        bbl.c();
        bbl bbl3 = bbl.c();
        bbl bbl4 = bbl.c();
        bbl.c();
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        for (int i2 = 1; i2 < this.waypoints.getNumWaypoints(); ++i2) {
            Waypoint waypoint = (Waypoint)this.waypoints.getList().get(i2 - 1);
            Waypoint waypoint2 = (Waypoint)this.waypoints.getList().get(i2);
            dArray = waypoint.getPositions(dArray);
            dArray2 = waypoint2.getPositions(dArray2);
            if (dArray3 == null) {
                dArray3 = (double[])dArray.clone();
            }
            if (dArray4 == null) {
                dArray4 = (double[])dArray.clone();
            }
            bcu2.a(dArray, bbl2).a(bbj2);
            bcu2.a(dArray2, bbl3).a(bbj3);
            double d2 = bbl3.dL - bbl2.dL;
            double d3 = bbl3.dN - bbl2.dN;
            double d4 = bbl3.dR - bbl2.dR;
            double d5 = waypoint2.getTime() - waypoint.getTime();
            double d6 = d2;
            double d7 = d3;
            double d8 = d4;
            int n2 = (int)Math.floor(Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8) / LINEAR_INTERP_DISTANCE);
            d3 /= (double)n2;
            d4 /= (double)n2;
            d5 /= (double)n2;
            aa.b(Double.isFinite(d2 /= (double)n2), (Object)"can't work with non finite waypoints");
            if (!arrayList.contains(waypoint)) {
                arrayList.add(waypoint);
            }
            for (int i3 = 1; i3 < n2; ++i3) {
                bbl4.a(bbk.a(bbj2, bbj3, bbj4, (double)i3 / (double)n2));
                bbl4.a(bbl2.dL + (double)i3 * d2, bbl2.dN + (double)i3 * d3, bbl2.dR + (double)i3 * d4);
                for (int i4 = 0; i4 < dArray.length; ++i4) {
                    dArray3[i4] = dArray[i4] + (double)i3 * (dArray2[i4] - dArray[i4]) / (double)n2;
                }
                Object object = awb2;
                awb2.aZ = false;
                ((awb)object).ba = false;
                ((awb)object).bb = false;
                ((awb)object).a.K = bdb.L;
                Object object2 = awb2.a;
                h.a(true, (Object)"max iterations must be greater than zero");
                ((bdd)object2).aF = 25;
                Object object3 = bbl4;
                object = awb2;
                Object object4 = object3;
                object2 = object;
                bbl bbl5 = object4;
                bde bde2 = ((awb)object).a;
                bbl bbl6 = bbl5;
                h.a(fe.a(0.0 + bbl6.u + bbl6.v + bbl6.dK + bbl6.w + bbl6.x + bbl6.dM + bbl6.dO + bbl6.dP + bbl6.dQ), (Object)"SO3 target may not contain NaN or Inf");
                bde2.V.c(bbl5);
                ((awb)object2).ba = true;
                double d9 = ((bbl)object3).dR;
                double d10 = ((bbl)object3).dN;
                double d11 = ((bbl)object3).dL;
                object2 = object;
                double d12 = d9;
                double d13 = d10;
                double d14 = d11;
                bdg bdg2 = ((awb)object2).a;
                h.a(!Double.isInfinite(d14) && !Double.isInfinite(d13) && !Double.isInfinite(d12), (Object)"Xyz objective may not contain Inf values");
                bdg2.dY = d14;
                bdg2.dZ = d13;
                bdg2.ea = d12;
                ((awb)object2).aZ = true;
                object3 = dArray3;
                object = awb2;
                h.a(((Object)object3).length == ((awb)object).c.numJoints, (Object)"length must match DOF");
                object4 = object3;
                ((awb)object).a.K = (double[])object4;
                ((awb)object).bb = true;
                object2 = dArray4;
                object3 = dArray3;
                object = awb2;
                if (((awb)object).a.a(((awb)object).b, (double[])object3, (double[])object2)) {
                    object = dArray4;
                    if (bea.a(dArray4, dArray4.length)) {
                        arrayList.add(Waypoint.newMove(waypoint.getNumJoints()).setTime(waypoint.getTime() + (double)i3 * d5).setPositions(dArray4));
                        continue;
                    }
                }
                System.err.println("Found no solution. Ignoring intermediate point");
            }
            if (arrayList.contains(waypoint2)) continue;
            arrayList.add(waypoint2);
        }
        this.waypoints.getList().setAll(arrayList);
        this.waypoints.setDirty();
        TeachRepeatPresenter teachRepeatPresenter = this;
        teachRepeatPresenter.onUpdate((List<Waypoint>)teachRepeatPresenter.waypoints.getList());
    }

    public String toString() {
        return "TeachRepeatPresenter(root=" + this.root + ", menuPane=" + this.menuPane + ", waypointPane=" + this.waypointPane + ", waypointListView=" + this.waypointListView + ", pane3d=" + this.pane3d + ", pane2d=" + this.pane2d + ", ikPane=" + this.ikPane + ", ikIncreaseX=" + this.ikIncreaseX + ", ikDecreaseX=" + this.ikDecreaseX + ", ikIncreaseY=" + this.ikIncreaseY + ", ikDecreaseY=" + this.ikDecreaseY + ", ikIncreaseZ=" + this.ikIncreaseZ + ", ikDecreaseZ=" + this.ikDecreaseZ + ", xyzLine=" + this.xyzLine + ", xyzWaypoints=" + this.xyzWaypoints + ", jointPosChart=" + this.jointPosChart + ", timeIndicators=" + this.timeIndicators + ", selectedWaypoint=" + this.selectedWaypoint + ", selectedTime=" + this.selectedTime + ", robotModel=" + this.robotModel + ", fileChooser=" + this.fileChooser + ", waypoints=" + this.waypoints + ", groupTrajectory=" + this.groupTrajectory + ", cartesianSamplesCont=" + this.cartesianSamplesCont + ", cartesianSamplesKey=" + this.cartesianSamplesKey + ", colorIndex=" + this.colorIndex + ", len=" + this.len + ", worldFrame=" + this.worldFrame + ", cubeWorld=" + this.cubeWorld + ", worldScene=" + this.worldScene + ")";
    }

    private static /* synthetic */ void lambda$updateTimeIndicators$1(Waypoint waypoint, ObservableValue observableValue, Number number, Number number2) {
        if (number2 != null) {
            waypoint.setTime(number2.doubleValue());
        }
    }
}

