/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Parent;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.afc;
import us.hebi.gui.lib.atr;
import us.hebi.gui.lib.ats;
import us.hebi.gui.lib.att;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.uk;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class AdcCalibrationDialog
extends CalibrationDialog<ats> {
    ReadOnlyObjectProperty<afc> controlStrategy;
    DoubleBinding baseOffset;
    DoubleBinding sampleRange;
    DoubleBinding numSamples;

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("Calibrate ADC offsets");
        List<afc> list = Arrays.stream(afc.values()).filter(afc2 -> afc2 != afc.a).toList();
        this.controlStrategy = this.addEnumParameter("Control strategy", list, afc.b, "The strategy that the adc should be calibrated in. We recommend using 'Off'. The strategy will not be reset afterwards.");
        this.baseOffset = this.addDoubleParameter("Base offset", 38.0, "center base");
        this.sampleRange = this.addDoubleParameter("Sample range", 4.0, "searches base offset +/- sample range");
        this.numSamples = this.addDoubleParameter("# Samples", 200.0, "number of samples");
    }

    @Override
    protected void fillResultGrid(ats ats2) {
        this.addResult("I a", ats2.a);
        this.addResult("I b", ats2.b);
        this.addResult("I c", ats2.c);
        this.addResult("I bus", ats2.d);
    }

    private void addResult(String string, att att2) {
        this.addResult(string, uk.d(att2.g()[0]), this.getComment(att2));
    }

    private String getComment(att att2) {
        if (!att2.f(0.01)) {
            return "Bad fit: " + att2.cO();
        }
        return "Ok";
    }

    @Override
    protected Parent renderResult(ats ats2) {
        XYChart xYChart = auz.d();
        xYChart.setTitle("Phase Current");
        xYChart.getXAxis().setName("Offset");
        xYChart.getYAxis().setName("Current");
        xYChart.getYAxis().setUnit("A");
        DataSet dataSet = AdcCalibrationDialog.wrap("A", ats2.a);
        DataSet dataSet2 = AdcCalibrationDialog.wrap("B", ats2.b);
        DataSet dataSet3 = AdcCalibrationDialog.wrap("C", ats2.c);
        xYChart.getDatasets().addAll((Object[])new DataSet[]{dataSet, dataSet2, dataSet3});
        auz.a(xYChart, "A", ats2.K);
        auz.a(xYChart, "B", ats2.L);
        auz.a(xYChart, "C", ats2.M);
        auz.a(xYChart, null);
        XYChart xYChart2 = auz.d();
        xYChart2.setTitle("Bus Current");
        xYChart2.getXAxis().setName("Offset");
        xYChart2.getYAxis().setName("Current");
        xYChart2.getYAxis().setUnit("A");
        DataSet dataSet4 = AdcCalibrationDialog.wrap("Bus", ats2.d);
        xYChart2.getDatasets().add((Object)dataSet4);
        auz.a(xYChart2, null, ats2.N);
        auz.a(xYChart2, null);
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.setPrimaryChart(xYChart);
        calibrationResultDialog.setSecondaryChart(xYChart2);
        calibrationResultDialog.addResult("Offset A", ats2.a.g()[0], this.getComment(ats2.a));
        calibrationResultDialog.addResult("Offset B", ats2.b.g()[0], this.getComment(ats2.b));
        calibrationResultDialog.addResult("Offset C", ats2.c.g()[0], this.getComment(ats2.c));
        calibrationResultDialog.addResult("Offset Bus", ats2.d.g()[0], this.getComment(ats2.d));
        return calibrationResultDialog;
    }

    private static DataSet wrap(String string, att att2) {
        return new avy(string, att2::getNumSamples, att2::c, att2::d).addStyleClasses(new String[]{awf.c.F()});
    }

    private static DataSet wrapCoeffs(att att2) {
        jh jh2 = new jh(100);
        jh jh3 = new jh(100);
        att2.g();
        return new avy("coeffs", jh2, jh3).addStyleClasses(new String[]{awf.c.F()});
    }

    @Override
    protected Callable<ats> createTask(aee aee2) {
        atr atr2 = new atr(aee2, (afc)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue());
        AdcCalibrationDialog adcCalibrationDialog = this;
        new atr(aee2, (afc)((Object)((Object)this.controlStrategy.get())), this.numSamples.intValue(), this.baseOffset.floatValue(), this.sampleRange.floatValue()).a = adcCalibrationDialog;
        return atr2;
    }
}

