/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXToggleButton;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.aga;
import us.hebi.gui.lib.ahq;
import us.hebi.gui.lib.aqe;
import us.hebi.gui.lib.aqf;
import us.hebi.gui.lib.aqg;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.awb;
import us.hebi.gui.lib.awc;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PinUtils;

public class MonitoringIoController
implements Initializable {
    @FXML
    private VBox bankA;
    @FXML
    private VBox bankB;
    @FXML
    private VBox bankE;
    @FXML
    private VBox bankF;
    @Inject
    atl module;
    @Inject
    asy commandService;
    private final ahq cmd = new ahq();
    boolean commandsEnabled = true;
    @Inject
    auv plottingService;
    @Inject
    atg selectorService;

    private void sendCommands() {
        if (!this.commandsEnabled) {
            return;
        }
        this.cmd.clear();
        aga aga2 = this.cmd.getIoBoard().a();
        this.addDigitalOut(1, aga2::d);
        this.addDigitalOut(2, aga2::e);
        this.addDigitalOut(3, aga2::f);
        this.addDigitalOut(4, aga2::g);
        this.addDigitalOut(5, aga2::h);
        this.addDigitalOut(6, aga2::i);
        this.addDigitalOut(7, aga2::j);
        this.addDigitalOut(8, aga2::k);
        aga aga3 = this.cmd.getIoBoard().b();
        this.addPwmOut(1, aga3::d);
        this.addPwmOut(2, aga3::e);
        this.addPwmOut(3, aga3::f);
        this.addPwmOut(4, aga3::g);
        this.addPwmOut(5, aga3::h);
        this.addPwmOut(6, aga3::i);
        this.addPwmOut(7, aga3::j);
        this.addPwmOut(8, aga3::k);
        this.selectorService.getSelectedModules().forEach(aqq2 -> this.commandService.a(aqq2.a(), this.cmd));
    }

    private void addDigitalOut(int n2, DoubleConsumer doubleConsumer) {
        HBox hBox = MonitoringIoController.getPin(this.bankE, n2);
        ToggleButton toggleButton = (ToggleButton)hBox.getChildren().get(2);
        if (hBox.isDisable() || toggleButton.isDisable() || !toggleButton.isVisible()) {
            return;
        }
        doubleConsumer.accept(toggleButton.isSelected() ? 1.0 : 0.0);
    }

    private void addPwmOut(int n2, DoubleConsumer doubleConsumer) {
        HBox hBox = MonitoringIoController.getPin(this.bankF, n2);
        Slider slider = (Slider)hBox.getChildren().get(2);
        if (hBox.isDisable() || slider.isDisable() || !slider.isVisible()) {
            return;
        }
        doubleConsumer.accept(slider.getValue());
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.commandsEnabled = false;
        Object object = this.module.getInfo();
        aqg aqg2 = ((aqe)object).a;
        MonitoringIoController monitoringIoController = this;
        object = aqg2;
        monitoringIoController.initializeBank(monitoringIoController.bankA, ((aqg)object).a);
        MonitoringIoController monitoringIoController2 = this;
        aqg aqg3 = aqg2;
        monitoringIoController2.initializeBank(monitoringIoController2.bankB, aqg3.b);
        MonitoringIoController monitoringIoController3 = this;
        aqg3 = aqg2;
        monitoringIoController3.initializeBank(monitoringIoController3.bankE, aqg3.e);
        MonitoringIoController monitoringIoController4 = this;
        aqg3 = aqg2;
        monitoringIoController4.initializeBank(monitoringIoController4.bankF, aqg3.f);
        this.commandsEnabled = true;
    }

    private void initializeBank(VBox vBox, aqf aqf2) {
        InvalidationListener invalidationListener = observable -> this.sendCommands();
        for (int i2 = 1; i2 <= 8; ++i2) {
            ChangeListener changeListener;
            Object object;
            CheckBox checkBox;
            ReadOnlyDoubleProperty readOnlyDoubleProperty = PinUtils.getPinProperty(i2, aqf2);
            HBox hBox = MonitoringIoController.getPin(vBox, i2);
            hBox.disableProperty().bind((ObservableValue)ParseUtils.isNaN((ObservableDoubleValue)readOnlyDoubleProperty));
            Text text = MonitoringIoController.getText((Pane)hBox);
            text.textProperty().bind((ObservableValue)ParseUtils.asFormattedString(readOnlyDoubleProperty));
            text.visibleProperty().bind((ObservableValue)hBox.disabledProperty().not());
            Button button = MonitoringIoController.getButton((Pane)hBox);
            Supplier<awc> supplier = awb.a(button.getText());
            button.setOnAction(this.plottingService.a((List<aqq>)this.selectorService.getSelectedModules(), button.getText(), supplier));
            if (vBox == this.bankE) {
                checkBox = (CheckBox)hBox.getChildren().get(1);
                object = (JFXToggleButton)((Object)hBox.getChildren().get(2));
                changeListener = (arg_0, arg_1, arg_2) -> this.lambda$initializeBank$2((JFXToggleButton)((Object)object), invalidationListener, readOnlyDoubleProperty, arg_0, arg_1, arg_2);
                checkBox.selectedProperty().addListener(changeListener);
                changeListener.changed(null, null, (Object)checkBox.isSelected());
            }
            if (vBox != this.bankF) continue;
            checkBox = (CheckBox)hBox.getChildren().get(1);
            object = (JFXSlider)((Object)hBox.getChildren().get(2));
            changeListener = (Button)hBox.getChildren().get(3);
            ChangeListener changeListener2 = (arg_0, arg_1, arg_2) -> this.lambda$initializeBank$3((JFXSlider)((Object)object), invalidationListener, readOnlyDoubleProperty, arg_0, arg_1, arg_2);
            checkBox.selectedProperty().addListener(changeListener2);
            changeListener2.changed(null, null, (Object)checkBox.isSelected());
            SliderUtil.setValueLabelFactory((JFXSlider)((Object)object), d2 -> d2);
            SliderUtil.setupTargetButton((Slider)object, checkBox.selectedProperty(), (Button)changeListener, d2 -> d2, d2 -> d2);
        }
    }

    private static HBox getPin(VBox vBox, int n2) {
        return (HBox)vBox.getChildren().get(n2);
    }

    private static Button getButton(Pane pane) {
        if (pane.getChildren().get(0) instanceof HBox) {
            pane = (Pane)pane.getChildren().get(0);
        }
        return (Button)pane.getChildren().get(0);
    }

    private static Text getText(Pane pane) {
        if (pane.getChildren().get(0) instanceof HBox) {
            pane = (Pane)pane.getChildren().get(0);
        }
        return (Text)pane.getChildren().get(1);
    }

    private /* synthetic */ void lambda$initializeBank$3(JFXSlider jFXSlider, InvalidationListener invalidationListener, ReadOnlyDoubleProperty readOnlyDoubleProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (bl3.booleanValue()) {
            jFXSlider.setDisable(false);
            jFXSlider.valueProperty().unbind();
            jFXSlider.valueProperty().addListener(invalidationListener);
        } else {
            jFXSlider.setDisable(true);
            jFXSlider.valueProperty().bind((ObservableValue)readOnlyDoubleProperty);
            jFXSlider.valueProperty().removeListener(invalidationListener);
        }
        this.sendCommands();
    }

    private /* synthetic */ void lambda$initializeBank$2(JFXToggleButton jFXToggleButton, InvalidationListener invalidationListener, ReadOnlyDoubleProperty readOnlyDoubleProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (bl3.booleanValue()) {
            jFXToggleButton.setDisable(false);
            jFXToggleButton.selectedProperty().unbind();
            jFXToggleButton.selectedProperty().addListener(invalidationListener);
        } else {
            jFXToggleButton.setDisable(true);
            jFXToggleButton.selectedProperty().bind((ObservableValue)readOnlyDoubleProperty.isEqualTo(1));
            jFXToggleButton.selectedProperty().removeListener(invalidationListener);
        }
        this.sendCommands();
    }
}

