/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.buttons.HActionButton;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.awc;
import us.hebi.gui.lib.awj;
import us.hebi.gui.lib.awk;
import us.hebi.gui.lib.ayo;

public class MonitoringCustomController {
    @FXML
    private Parent root;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button reloadFilesBtn;
    private static final int NUM_COLS = 4;
    @Inject
    auv plottingService;
    @Inject
    atg selectorService;
    @Inject
    awk customChartDirectory;

    private void reloadFiles() {
        this.reloadFilesBtn.setDisable(true);
        CompletableFuture.supplyAsync(() -> {
            ArrayList arrayList = new ArrayList();
            this.customChartDirectory.forEachXml(awn2 -> {
                HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
                hActionButton.setText(awn2.getTitle());
                hActionButton.disableProperty().bind((ObservableValue)this.selectorService.selectionEmpty());
                Supplier<awc> supplier = awj.a(awn2);
                hActionButton.setOnAction(this.plottingService.a((List<aqq>)this.selectorService.getSelectedModules(), awn2.getTitle(), supplier));
                arrayList.add(hActionButton);
            }, (path, string) -> {
                HActionButton hActionButton = Css.addClass(new HActionButton(), "btn-PlotButton");
                hActionButton.pseudoClassStateChanged(Css.CLASS_INVALID, true);
                hActionButton.setText(path.getFileName().toString());
                hActionButton.setOnAction(actionEvent -> asf.a(string, ayo.a(actionEvent)));
                arrayList.add(hActionButton);
            });
            return arrayList;
        }).thenAcceptAsync(list -> {
            int n2 = 0;
            this.gridPane.getChildren().clear();
            for (Node node : list) {
                this.gridPane.add(node, MonitoringCustomController.getRow(n2), MonitoringCustomController.getCol(n2));
                GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
                ++n2;
            }
            this.reloadFilesBtn.setDisable(false);
        }, ayo.d);
    }

    @FXML
    void initialize() {
        this.customChartDirectory.selectedDirectoryProperty().addListener(observable -> this.reloadFiles());
        this.reloadFiles();
        this.reloadFilesBtn.setOnAction(actionEvent -> this.reloadFiles());
    }

    private static int getRow(int n2) {
        return n2 % 4;
    }

    private static int getCol(int n2) {
        return n2 / 4;
    }
}

