/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import com.jfoenix.controls.JFXSlider;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javax.inject.Inject;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.afc;
import us.hebi.gui.lib.ahq;
import us.hebi.gui.lib.app;
import us.hebi.gui.lib.apz;
import us.hebi.gui.lib.aqe;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.arz;
import us.hebi.gui.lib.asb;
import us.hebi.gui.lib.ase;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.baj;
import us.hebi.gui.views.scope.assets.Asset;
import us.hebi.gui.views.scope.dialogs.convertlog.ConvertLogPresenter;
import us.hebi.gui.views.scope.dialogs.convertlog.ConvertLogView;

public class MonitoringController {
    @FXML
    private Text fbkFrequencyLabel;
    @FXML
    private Button fbkFrequencyTarget;
    @FXML
    private JFXSlider fbkFrequencySlider;
    @FXML
    private ToggleButton fbkFrequencyEnabledCheckbox;
    @FXML
    private Button startLogButton;
    @FXML
    private Button stopLogButton;
    @FXML
    private ComboBox<String> timeRangeSelector;
    @FXML
    private TabPane tabPane;
    @FXML
    private Button closePlotsButton;
    @FXML
    private Tab customTab;
    @FXML
    private Button viewHrdfBtn;
    @FXML
    private Button viewLogBtn;
    @FXML
    private Button convertLogBtn;
    public static final StringConverter<Double> frequencylabelFormatter = new baj();
    private final DoubleProperty posFbk = new SimpleDoubleProperty(Double.NaN);
    private final DoubleProperty velFbk = new SimpleDoubleProperty(Double.NaN);
    private final DoubleProperty effortFbk = new SimpleDoubleProperty(Double.NaN);
    boolean commandsEnabled = false;
    @Inject
    auv plottingService;
    @Inject
    atl module;
    @Inject
    ase loggingService;
    @Inject
    aqt properties;
    @Inject
    asy commandService;
    final ahq command = new ahq();
    @Inject
    auc fileChooser;
    @Inject
    asb dialogHelper;
    @Inject
    asg notificationService;
    @Inject
    arz hebiFileLoader;

    @FXML
    void initialize() {
        this.timeRangeSelector.getSelectionModel().select((Object)((String)this.properties.a.get()));
        this.properties.a.bind((ObservableValue)this.timeRangeSelector.getSelectionModel().selectedItemProperty());
        ChangeListener changeListener = (observableValue, string, string2) -> {
            if (string2 != null) {
                if (string2.startsWith("60")) {
                    this.plottingService.a(TimeUnit.SECONDS, 60L);
                    return;
                }
                if (string2.startsWith("30")) {
                    this.plottingService.a(TimeUnit.SECONDS, 30L);
                    return;
                }
                if (string2.startsWith("10")) {
                    this.plottingService.a(TimeUnit.SECONDS, 10L);
                    return;
                }
                if (string2.startsWith("5")) {
                    this.plottingService.a(TimeUnit.SECONDS, 5L);
                    return;
                }
                this.plottingService.bH();
                return;
            }
            this.plottingService.bH();
        };
        changeListener.changed(null, null, (Object)((String)this.timeRangeSelector.getSelectionModel().getSelectedItem()));
        this.timeRangeSelector.getSelectionModel().selectedItemProperty().addListener(changeListener);
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> MonitoringController.sliderToHz(this.fbkFrequencyEnabledCheckbox.isSelected(), this.fbkFrequencySlider.getValue()), (Observable[])new Observable[]{this.fbkFrequencyEnabledCheckbox.selectedProperty(), this.fbkFrequencySlider.valueProperty()});
        this.fbkFrequencySlider.disableProperty().bind((ObservableValue)this.fbkFrequencyEnabledCheckbox.selectedProperty().not());
        this.fbkFrequencyLabel.textProperty().bind((ObservableValue)doubleBinding.asString("%.1f Hz"));
        this.fbkFrequencySlider.setLabelFormatter(frequencylabelFormatter);
        SliderUtil.setValueLabelFactory(this.fbkFrequencySlider, MonitoringController::sliderToHz);
        SliderUtil.setupTargetButton(this.fbkFrequencySlider, this.fbkFrequencyEnabledCheckbox.selectedProperty(), this.fbkFrequencyTarget, MonitoringController::hzToSlider, MonitoringController::sliderToHz0);
        this.fbkFrequencySlider.setValue(MonitoringController.hzToSlider(100.0));
        this.plottingService.k.bind((ObservableValue)doubleBinding);
        Object object = this.module.getInfo();
        BooleanBinding booleanBinding = ((aqe)object).d.greaterThan(0);
        this.startLogButton.disableProperty().bind((ObservableValue)booleanBinding.not().or((ObservableBooleanValue)this.loggingService.M));
        this.startLogButton.setOnAction(actionEvent -> {
            this.loggingService.p((ActionEvent)actionEvent);
            this.startLogButton.getParent().requestFocus();
        });
        this.stopLogButton.disableProperty().bind((ObservableValue)this.loggingService.M.not());
        this.stopLogButton.setOnAction(actionEvent -> {
            this.loggingService.q((ActionEvent)actionEvent);
            this.stopLogButton.getParent().requestFocus();
        });
        this.startLogButton.visibleProperty().bind((ObservableValue)this.loggingService.M.not());
        this.startLogButton.managedProperty().bind((ObservableValue)this.startLogButton.visibleProperty());
        this.stopLogButton.visibleProperty().bind((ObservableValue)this.startLogButton.visibleProperty().not());
        this.stopLogButton.managedProperty().bind((ObservableValue)this.stopLogButton.visibleProperty());
        object = this.module.getFeedback();
        this.posFbk.bind((ObservableValue)((app)object).y);
        object = this.module.getFeedback();
        this.velFbk.bind((ObservableValue)((app)object).D);
        Observable[] observableArray = new Observable[2];
        object = this.module.getGains();
        observableArray[0] = ((apz)object).u;
        object = this.module.getFeedback();
        observableArray[1] = ((app)object).h;
        this.effortFbk.bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.module.getGains().a() == afc.c) {
                return Double.NaN;
            }
            app app2 = this.module.getFeedback();
            return app2.h.get();
        }, (Observable[])observableArray));
        this.closePlotsButton.disableProperty().bind((ObservableValue)this.plottingService.O.not());
        this.closePlotsButton.setOnAction(actionEvent -> this.plottingService.bF());
        this.closePlotsButton.disabledProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl2.booleanValue() && !bl3.booleanValue()) {
                this.tabPane.requestFocus();
            }
        });
        if (!ayo.aV()) {
            this.viewHrdfBtn.setDisable(true);
        }
    }

    @FXML
    public void viewHrdf(ActionEvent actionEvent) {
        Asset.loadCommonAssets();
        Window window = ayo.a(actionEvent);
        File file = this.fileChooser.b(window);
        if (file == null) {
            return;
        }
        this.hebiFileLoader.a(window, file);
    }

    @FXML
    public void viewLogfile(ActionEvent actionEvent) {
        Window window = ayo.a(actionEvent);
        File file = this.fileChooser.a(window);
        if (file == null) {
            return;
        }
        arz.b(window, file);
    }

    @FXML
    void convertLogfile(ActionEvent actionEvent) {
        File file = this.fileChooser.a(ayo.a(actionEvent));
        if (file == null) {
            return;
        }
        ConvertLogView convertLogView = new ConvertLogView(file);
        convertLogView.getViewAsync(parent -> this.dialogHelper.a((Parent)parent, ((ConvertLogPresenter)convertLogView.getPresenter()).getCloseButton()));
    }

    public static double hzToSlider(double d2) {
        return Math.log10(d2);
    }

    public static double sliderToHz(double d2) {
        return MonitoringController.sliderToHz(true, d2);
    }

    public static double sliderToHz(boolean bl2, double d2) {
        if (bl2) {
            return MonitoringController.sliderToHz0(d2);
        }
        return 0.0;
    }

    private static double sliderToHz0(double d2) {
        return Math.pow(10.0, d2);
    }
}

