/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.utils;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.hebi.gui.lib.amq;
import us.hebi.gui.lib.bhz;
import us.hebi.gui.lib.bib;
import us.hebi.gui.lib.bil;
import us.hebi.gui.lib.bin;
import us.hebi.gui.lib.bxm;
import us.hebi.gui.views.maps.utils.MapsFeedbackDataSet;

public class MapsFeedbackRenderer
extends AbstractRendererXY<MapsFeedbackRenderer> {
    bxm ascan;
    amq xToDisplay;
    amq yToDisplay;
    double ascanLineWidth = 2.0;
    double gateLineWidth = 2.0;
    double gateLineSideLength = 4.0;
    double refPosWidth = 4.0;

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        if (!(dataSet instanceof MapsFeedbackDataSet)) {
            return;
        }
        MapsFeedbackDataSet mapsFeedbackDataSet = (MapsFeedbackDataSet)dataSet;
        this.xToDisplay = d2 -> this.xAxis.getDisplayPosition(mapsFeedbackDataSet.xTransform.apply(d2));
        this.yToDisplay = d2 -> this.yAxis.getDisplayPosition(mapsFeedbackDataSet.yTransform.apply(d2));
        this.ascan = mapsFeedbackDataSet.utData.a;
        bib bib2 = mapsFeedbackDataSet.message.a.b;
        bin bin2 = mapsFeedbackDataSet.message.a.a;
        graphicsContext.save();
        this.drawAscan(graphicsContext, dataSetNode.getLineColor());
        if (bin2.ce()) {
            graphicsContext.setLineWidth(this.refPosWidth);
            graphicsContext.setStroke(dataSetNode.getMarkerColor());
            graphicsContext.setLineDashes(dataSetNode.getMarkerLineDashes());
            this.drawDashedVerticalLine(graphicsContext, bin2.do);
            graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        }
        this.drawGate(graphicsContext, bib2.a, bin2.a, bib2.bA, 0, Color.RED);
        this.drawGate(graphicsContext, bib2.b, bin2.b, bib2.bA, bin2.a.dl, Color.GREEN);
        this.drawGate(graphicsContext, bib2.c, bin2.c, bib2.bA, bin2.b.dl, Color.BLUE);
        graphicsContext.restore();
    }

    private void drawAscan(GraphicsContext graphicsContext, Paint paint) {
        if (this.ascan.aw() == 0) {
            return;
        }
        graphicsContext.setLineWidth(this.ascanLineWidth);
        graphicsContext.setStroke(paint);
        graphicsContext.beginPath();
        graphicsContext.moveTo(this.xToDisplay.apply(0.0), this.yToDisplay.apply(this.ascan.a(0)));
        for (int i2 = 1; i2 < this.ascan.aw(); ++i2) {
            graphicsContext.lineTo(this.xToDisplay.apply(i2), this.yToDisplay.apply(this.ascan.a(i2)));
        }
        graphicsContext.stroke();
    }

    private void drawGate(GraphicsContext graphicsContext, bhz bhz2, bil bil2, boolean bl2, int n2, Color color) {
        if (bhz2.isEmpty()) {
            return;
        }
        if (!bl2) {
            n2 = 0;
        }
        double d2 = this.xToDisplay.apply(bhz2.dd + n2);
        double d3 = this.xToDisplay.apply(bhz2.dd + bhz2.de + n2);
        double d4 = this.yToDisplay.apply(bhz2.df);
        double d5 = this.yToDisplay.apply((double)bhz2.df + this.gateLineSideLength);
        double d6 = this.yToDisplay.apply((double)bhz2.df - this.gateLineSideLength);
        graphicsContext.setStroke((Paint)color);
        graphicsContext.setLineWidth(this.gateLineWidth);
        graphicsContext.strokeLine(d2, d4, d3, d4);
        graphicsContext.strokeLine(d2, d5, d2, d6);
        graphicsContext.strokeLine(d3, d5, d3, d6);
        if (!bil2.isEmpty()) {
            DefaultMarker.drawCross(graphicsContext, this.xToDisplay.apply(bil2.dl), d4, 8.0);
            DefaultMarker.drawEmptyCircle(graphicsContext, this.xToDisplay.apply(bil2.dm), this.yToDisplay.apply(bil2.dn), 8.0);
        }
    }

    private void drawDashedVerticalLine(GraphicsContext graphicsContext, int n2) {
        graphicsContext.strokeLine(this.xToDisplay.apply(n2), Math.min(this.yToDisplay.apply(-128.0), this.yToDisplay.apply(0.0)), this.xToDisplay.apply(n2), Math.max(this.yToDisplay.apply(127.0), this.yToDisplay.apply(0.0)));
    }

    @Override
    protected MapsFeedbackRenderer getThis() {
        return this;
    }
}

