/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Mesh;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.b;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.aoe;
import us.hebi.gui.lib.aof;
import us.hebi.gui.lib.aog;
import us.hebi.gui.lib.apd;
import us.hebi.gui.lib.apg;
import us.hebi.gui.lib.are;
import us.hebi.gui.lib.arn;
import us.hebi.gui.lib.ars;
import us.hebi.gui.lib.arv;
import us.hebi.gui.lib.arw;
import us.hebi.gui.lib.ary;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.axz;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.bbl;
import us.hebi.gui.lib.bhj;
import us.hebi.gui.lib.bhk;
import us.hebi.gui.lib.bjh;
import us.hebi.gui.lib.bmi;
import us.hebi.gui.lib.bxj;
import us.hebi.gui.lib.jj;
import us.hebi.gui.lib.lj;
import us.hebi.gui.lib.xg;
import us.hebi.gui.views.maps.EncoderState;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsAppState$View;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.ScanningState;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ScanningController
extends axy {
    @FXML
    private ToggleButton pauseToggle;
    @FXML
    private Pane pauseArea;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane pane3d;
    @FXML
    private TextField resolutionField;
    @FXML
    private TextField distanceField;
    @FXML
    private Button startBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Button restartBtn;
    @FXML
    private Button repeatBtn;
    @FXML
    private Button completeBtn;
    @FXML
    private Button backBtn;
    ars coverageImg;
    aoe coverageGrid = new aoe();
    apd mappedSurface = null;
    @Inject
    aof maps;
    @Inject
    MapsAppState state;
    @Inject
    EncoderState encoderState;
    @Inject
    ScanningState scanState;
    @Inject
    asg notifications;
    final xg logWriter = xg.a();

    @Override
    public void initializeFx() {
        this.resolutionField.textProperty().bindBidirectional((Property)this.state.getString("scanResolution", "10"));
        this.distanceField.textProperty().bindBidirectional((Property)this.state.getString("scanMaxDistance", "30"));
        this.state.addUnitFields(this.resolutionField, this.distanceField);
        ayo.a(() -> this.pauseArea.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.pauseToggle.selectedProperty().get()), new Observable[]{this.pauseToggle.selectedProperty()});
        this.pauseToggle.selectedProperty().bindBidirectional((Property)this.scanState.pausedProperty());
        SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty();
        arn arn2 = new arn();
        arw arw2 = MapsCss.createEndEffectorAxes3d();
        arw arw3 = new arw(new Node[]{arw2, arn2.c});
        arw arw4 = new arw(new Node[]{arw3, arv.a.a()});
        new ary(new Node[]{arw4}).a().a(this.pane3d);
        ImageView imageView = MapsCss.createView2d(this.pane2d);
        this.maps.b(arg_0 -> this.lambda$initializeFx$1((Property)simpleObjectProperty, arn2, arw3, imageView, arg_0));
        this.maps.d(aog2 -> {
            double d2;
            aog2.cj = d2 = this.coverageGrid.cj;
            this.scanState.setInContact(aog2.isInContact());
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                if (this.state.getShowLiveMap()) {
                    this.mappedSurface.a((aog)aog2, this.state.getProbeWidth());
                }
                if (this.scanState.isActive().booleanValue() && this.scanState.isInContact()) {
                    boolean bl2;
                    aog aog3 = aog2;
                    aoe aoe2 = this.coverageGrid;
                    if (aoe2.aw && (are.a(aog3.o, aoe2.r) || are.a(aog3.p, aoe2.s))) {
                        aoe2.r = aog3.o - (float)aoe2.ce;
                        aoe2.a.a(aoe2.r);
                        aoe2.s = aog3.p - (float)aoe2.cg;
                        aoe2.b.a(aoe2.s);
                        aoe2.c.a(aog3.u);
                        jj jj2 = aoe2.a;
                        int n2 = jj2.M - 1;
                        int n3 = aoe2.q(n2);
                        int n4 = aoe2.r(n2);
                        if (aoe2.a.a(n3, n4) || (double)aog3.u > aoe2.cj) {
                            bl2 = false;
                        } else {
                            aoe2.a.f(n3, n4);
                            bl2 = true;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (bl2 && this.state.getShowLiveMap()) {
                        this.redrawCoverage();
                    }
                }
            }
        });
        this.maps.c(bbl2 -> {
            if (this.state.isOnView(MapsAppState$View.Scanning) && this.mappedSurface != null) {
                arw2.b((bbl)bbl2);
            }
        });
        ValidationSupport validationSupport = ayb.a();
        ayb.a(validationSupport, this.resolutionField);
        ayb.a(validationSupport, this.distanceField);
        ayo.a(this::updateGrid, new Observable[]{this.resolutionField.textProperty(), this.distanceField.textProperty()});
        this.backBtn.setOnAction(this.state::previousView);
        SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(false);
        this.scanState.pausedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$initializeFx$4((BooleanProperty)simpleBooleanProperty, arg_0, arg_1, arg_2));
        this.encoderState.encoderStartMessageProperty().addListener((observableValue, bhj2, bhj3) -> this.scanState.reset());
        this.startBtn.setOnAction(ayo.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.mappedSurface == null) {
                this.notifications.i("Scan cannot be started without a map.");
                return;
            }
            Optional.ofNullable(this.encoderState.getEncoderStartMessage()).ifPresent(bhj2 -> {
                bhj bhj3 = bhj2;
                aof aof2 = this.maps;
                aof2.b.c().a().a(bhj3);
                aof aof3 = aof2;
                aof3.a(aof3.b, null);
            });
            this.startLogging();
            this.scanState.startScan();
        })));
        this.cancelBtn.setOnAction(ayo.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.h("Cancelling this scan will irrecoverably delete data. Do you want to delete this scan?")) {
                this.reset();
                this.cancelLogging();
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.restartBtn.setOnAction(ayo.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.h("Restarting will discard the current scan and begin a new scan on this same surface. Do you want to restart")) {
                this.reset();
                this.cancelLogging();
                this.maps.a(bhk.b);
            }
        })));
        this.repeatBtn.setOnAction(ayo.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.h("Repeating will complete the current scan and begin a new scan on this same surface. Do you want to repeat?")) {
                this.reset();
                this.stopLogging().ifPresent(file -> asf.a(file, ayo.a(actionEvent)));
                this.maps.a(bhk.b);
            }
        })));
        this.completeBtn.setOnAction(ayo.a((BooleanProperty)simpleBooleanProperty, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            if (this.notifications.h("Completing a scan will finish this scan and let you set up a new surface. Do you want to complete this scan?")) {
                this.reset();
                this.maps.a(bhk.d);
                this.stopLogging().ifPresent(file -> asf.a(file, ayo.a(actionEvent)));
                this.state.setActiveView(MapsAppState$View.Configuration);
            }
        })));
        this.updateGrid();
    }

    private void reset() {
        this.scanState.reset();
        this.coverageGrid.aS();
        this.redrawCoverage();
    }

    private void updateGrid() {
        Double d2 = ParseUtils.tryParseFiniteDouble(this.resolutionField);
        Double d3 = ParseUtils.tryParseFiniteDouble(this.distanceField);
        if (this.mappedSurface != null && d2 != null && d2 > 0.0) {
            this.mappedSurface.m(anc.b.e(d2));
        }
        if (d2 != null && d3 != null && d2 > 0.0 && d3 > 0.0) {
            boolean bl2;
            boolean bl3;
            double d4 = anc.b.e(d2);
            aoe aoe2 = this.coverageGrid;
            if (aoe2.ci != d4) {
                aoe2.ci = d4;
                aoe2.aR();
                bl3 = true;
            } else {
                bl3 = false;
            }
            boolean bl4 = false | bl3;
            d4 = anc.b.e(d3);
            aoe2 = this.coverageGrid;
            if (aoe2.cj != d4) {
                aoe2.cj = d4;
                aoe2.aR();
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (bl4 | bl2) {
                this.redrawCoverage();
            }
        }
    }

    private void redrawCoverage() {
        lj lj2 = this.coverageGrid.a;
        if (lj2.j() == 0) {
            return;
        }
        if (this.coverageImg == null || this.coverageImg.ca != lj2.ad || this.coverageImg.cb != lj2.ac) {
            this.coverageImg = new ars((double)lj2.ad, (double)lj2.ac);
        }
        int n2 = ars.a(Color.WHITE);
        int n3 = ars.a(b.c);
        for (int i2 = 0; i2 < lj2.ad; ++i2) {
            for (int i3 = 0; i3 < lj2.ac; ++i3) {
                int n4 = lj2.a(i3, i2) ? n3 : n2;
                this.coverageImg.f(i2, i3, n4);
            }
        }
        aoe aoe2 = this.coverageGrid;
        aoe aoe3 = aoe2;
        aoe3 = this.coverageGrid;
        this.mappedSurface.a((Image)this.coverageImg.a().a, this.coverageGrid.ce, this.coverageGrid.cg, (double)aoe2.L() * aoe3.ci, (double)aoe3.K() * aoe3.ci);
    }

    private void startLogging() {
        try {
            UUID uUID = UUID.randomUUID();
            bmi bmi2 = xg.a();
            bmi2.a("MAPS Feedback Log").a().a(axz.b.ag).b(axz.b.af);
            this.logWriter.a(new File(this.state.getLogDirectory(), uUID + ".mapslog"), bmi2);
            this.maps.a(this.logWriter);
            aof aof2 = this.maps;
            bjh bjh2 = bjh.a();
            bjh2.c().a().d().a(true);
            aof2.a(bjh2, null);
            return;
        }
        catch (Exception exception) {
            this.notifications.e(exception);
            return;
        }
    }

    private Optional<File> stopLogging() {
        try {
            this.maps.a((xg)null);
            return Optional.ofNullable(this.logWriter.b());
        }
        catch (Exception exception) {
            this.notifications.e(exception);
            return Optional.empty();
        }
    }

    private void cancelLogging() {
        this.stopLogging().map(File::delete).ifPresent(bl2 -> bxj.e(bl2, "Failed to delete log file"));
    }

    public MapsAppState getState() {
        return this.state;
    }

    public EncoderState getEncoderState() {
        return this.encoderState;
    }

    public ScanningState getScanState() {
        return this.scanState;
    }

    private /* synthetic */ void lambda$initializeFx$4(BooleanProperty booleanProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (!booleanProperty.get()) {
            this.maps.a(bl3 != false ? null : this.logWriter);
            this.maps.a(bl3 != false ? bhk.e : bhk.f);
        }
    }

    private /* synthetic */ void lambda$initializeFx$1(Property property, arn arn2, arw arw2, ImageView imageView, apg apg2) {
        apg apg3 = apg2;
        aoe aoe2 = this.coverageGrid;
        this.coverageGrid.ce = apg3.cE;
        aoe2.cg = apg3.cF;
        aoe2.cf = apg3.cG;
        aoe2.ch = apg3.cH;
        aoe aoe3 = aoe2;
        aoe3.s = Float.NaN;
        aoe3.r = Float.NaN;
        aoe2.aw = true;
        aoe2.aS();
        aoe2.aR();
        property.setValue((Object)apg2);
        arn2.a((Mesh)apg2.a());
        ayo.a((Node)arw2, aa.a((Mesh)apg2.a()));
        this.mappedSurface = apd.a(apg2, 1000.0, 1000.0);
        arn2.d.diffuseMapProperty().bind(this.mappedSurface.a);
        arn2.e.diffuseMapProperty().bind(this.mappedSurface.b);
        imageView.imageProperty().bind(this.mappedSurface.a);
        this.updateGrid();
        this.scanState.reset();
        this.stopLogging();
    }
}

