/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.mapslog.data;

import java.util.function.Supplier;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avr;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.bht;
import us.hebi.gui.lib.bix;
import us.hebi.gui.lib.bjj;
import us.hebi.gui.lib.bjz;
import us.hebi.gui.lib.bkb;
import us.hebi.gui.lib.blv;
import us.hebi.gui.lib.bme;
import us.hebi.gui.lib.bmi;
import us.hebi.gui.lib.bxs;
import us.hebi.gui.lib.bxu;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.xa;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class MapsLogFeedback
extends xa {
    private static final Supplier<String> poseCategory = () -> "World Pose";
    private static final Supplier<String> MapPointCategory = () -> "Mapped Point";
    private static final Supplier<String> utCategory = () -> "UT Data";
    private static final Supplier<String> RobotCategory = () -> "Robot";
    private static final Supplier<String> RuntimeCategory = () -> "Runtime";
    long startTime = 0L;
    int numJoints = -1;
    int maxEntries = -1;
    public jh time;
    public jh mapX;
    public jh mapY;
    public jh mapTheta;
    public jh mapDistance;
    public jh mapAngularDistance;
    public jh[] mapXyz;
    public jh runtimeAmbientTemperature;
    public jh runtimeBatteryVoltage;
    public jh runtimePcResidentMemoryUsage;
    public jh runtimePcVirtualMemoryUsage;
    public jh runtimePcUserCpuUsage;
    public jh runtimePcKernelCpuUsage;
    public jh runtimePcTemperature;
    public jh runtimePcVoltage;
    public jh runtimeMainCycleTimeMs;
    public jh runtimeMainBusyTimeMs;
    public jh runtimeCyclesSincePositionSourceData;
    public jh utThicknessSamples;
    public jh[] poseTranslation;
    public jh[] poseOrientation;
    public jh poseDelay;
    public jh[] position;
    public jh[] velocity;
    public jh[] power;
    public jh[] sequence;
    public jh[] rxSequence;
    public jh[] temperature;
    public jh[] voltage;
    public jh[] roundTripTime;
    public jh[] hwResponseTime;
    public jh[] transmitTimeDelta;
    public jh[] packetLoss;
    public jh[] firstOrientation;
    private final bjz prevRobotFbk = bjz.a();

    public MapsLogFeedback() {
        this.init(8192);
    }

    public MapsLogFeedback init(int n2) {
        this.maxEntries = n2;
        this.resize();
        return this;
    }

    private jh[] resizeGroup(jh[] jhArray) {
        return this.resizeMultiple(jhArray, this.numJoints);
    }

    private jh[] resizeMultiple(jh[] jhArray, int n2) {
        return TDoubleArrayListRegistry.resizeMultiple(jhArray, n2, this.maxEntries);
    }

    private jh resizeSingle(jh jh2) {
        return TDoubleArrayListRegistry.resizeSingle(jh2, this.maxEntries);
    }

    @Override
    public void onHeader(bmi bmi2) {
        if (bmi2.eG()) {
            this.startTime = bmi2.aS;
            return;
        }
        if (bmi2.eF()) {
            this.startTime = bmi2.Y;
        }
    }

    @Override
    public void onResponse(bme bme2, bjj bjj2, int n2) {
        if (!bjj2.cA()) {
            return;
        }
        bht bht2 = bjj2.a;
        bix bix2 = bjj2.a.a;
        this.time.d(ano.a(bme2.Y - this.startTime));
        this.mapX.d(bix2.o);
        this.mapY.d(bix2.p);
        this.mapTheta.d(bix2.t);
        this.mapDistance.d(bix2.u);
        this.mapAngularDistance.d(bix2.v);
        this.mapXyz[0].d((double)bix2.a.o * 1000.0);
        this.mapXyz[1].d((double)bix2.a.p * 1000.0);
        this.mapXyz[2].d((double)bix2.a.q * 1000.0);
        bkb bkb2 = bjj2.a.a;
        this.runtimeAmbientTemperature.d(bkb2.ad);
        this.runtimeBatteryVoltage.d(bkb2.ae);
        this.runtimePcResidentMemoryUsage.d(bkb2.af / 1024.0f);
        this.runtimePcVirtualMemoryUsage.d(bkb2.ag / 1024.0f);
        this.runtimePcUserCpuUsage.d(bkb2.ah);
        this.runtimePcKernelCpuUsage.d(bkb2.ai);
        this.runtimePcTemperature.d(bkb2.aj);
        this.runtimePcVoltage.d(bkb2.ak);
        this.runtimeMainCycleTimeMs.d(bkb2.al);
        this.runtimeMainBusyTimeMs.d(bkb2.am);
        this.runtimeCyclesSincePositionSourceData.d(bkb2.dx);
        this.utThicknessSamples.d(bht2.a.do);
        blv blv2 = bjj2.a.a;
        this.poseTranslation[0].d((double)blv2.d.o * 1000.0);
        this.poseTranslation[1].d((double)blv2.d.p * 1000.0);
        this.poseTranslation[2].d((double)blv2.d.q * 1000.0);
        this.poseOrientation[0].d(blv2.c.ac);
        this.poseOrientation[1].d(blv2.c.o);
        this.poseOrientation[2].d(blv2.c.p);
        this.poseOrientation[3].d(blv2.c.q);
        this.poseDelay.d(blv2.dI);
        if (bht2.bH()) {
            bjz bjz2 = bht2.a;
            if (this.numJoints < 0) {
                this.numJoints = bjz2.d.aw();
                this.resizeRobotFeedback(bjz2);
            }
            MapsLogFeedback mapsLogFeedback = this;
            mapsLogFeedback.addMultiple(mapsLogFeedback.position, bjz2.d);
            MapsLogFeedback mapsLogFeedback2 = this;
            mapsLogFeedback2.addMultiple(mapsLogFeedback2.velocity, bjz2.e);
            MapsLogFeedback mapsLogFeedback3 = this;
            mapsLogFeedback3.addMultiple(mapsLogFeedback3.power, bjz2.f);
            MapsLogFeedback mapsLogFeedback4 = this;
            mapsLogFeedback4.addMultiple(mapsLogFeedback4.sequence, bjz2.a);
            MapsLogFeedback mapsLogFeedback5 = this;
            mapsLogFeedback5.addMultiple(mapsLogFeedback5.rxSequence, bjz2.b);
            MapsLogFeedback mapsLogFeedback6 = this;
            mapsLogFeedback6.addMultiple(mapsLogFeedback6.temperature, bjz2.g);
            MapsLogFeedback mapsLogFeedback7 = this;
            mapsLogFeedback7.addMultiple(mapsLogFeedback7.voltage, bjz2.h);
            MapsLogFeedback mapsLogFeedback8 = this;
            mapsLogFeedback8.addMultiple(mapsLogFeedback8.firstOrientation, bjz2.i);
            for (int i2 = 0; i2 < this.roundTripTime.length; ++i2) {
                this.roundTripTime[i2].d(1000.0 * ano.a(bjz2.e.e(i2) - bjz2.f.e(i2)));
                this.hwResponseTime[i2].d(1000.0 * ano.a(bjz2.d.e(i2) - bjz2.c.e(i2)));
                if (this.prevRobotFbk.isEmpty()) {
                    this.transmitTimeDelta[i2].d(Double.NaN);
                    this.packetLoss[i2].d(Double.NaN);
                    continue;
                }
                double d2 = ano.a(bjz2.f.e(i2) - this.prevRobotFbk.f.e(i2));
                this.transmitTimeDelta[i2].d(d2 * 1000.0);
                this.packetLoss[i2].d(bjz2.a.e(i2) - this.prevRobotFbk.a.e(i2) - 1L);
            }
            this.prevRobotFbk.a(bjz2);
        }
    }

    private void addMultiple(jh[] jhArray, bxs bxs2) {
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            jhArray[i2].d(bxs2.a(i2));
        }
    }

    private void addMultiple(jh[] jhArray, bxu bxu2) {
        for (int i2 = 0; i2 < jhArray.length; ++i2) {
            jhArray[i2].d(bxu2.e(i2));
        }
    }

    public void getCharts(ChartList chartList) {
        chartList.setTime(this.time).setTraceType(awf.a).addTimeTraces(MapPointCategory, "Position XY", null, 0.0, 1.0, new jh[]{this.mapX, this.mapY}, renderer -> {
            auz.a(renderer, 0, "X", "trace-solid");
            auz.a(renderer, 1, "Y", "trace-solid");
        }).addDeviceXY(MapPointCategory, "Position XY (2D)", avr.a("X", null), new jh[]{this.mapX}, avr.a("Y", null), new jh[]{this.mapY}).addSingleTrace(MapPointCategory, "Theta", null, 0.0, 1.0, this.mapTheta).addSingleTrace(MapPointCategory, "Distance", null, 0.0, 0.0, this.mapDistance).addSingleTrace(MapPointCategory, "Angular Distance", null, 0.0, 0.0, this.mapAngularDistance).addXyzChart(MapPointCategory, "Position XYZ (closest)", "mm", -50.0, 50.0, this.mapXyz).addXyzChart(poseCategory, "Position XYZ", "mm", -50.0, 50.0, this.poseTranslation).addQuaternionTraces(poseCategory, "Orientation", this.poseOrientation).addSingleTrace(poseCategory, "Delay", "ms", 0.0, 10.0, this.poseDelay);
        if (!this.prevRobotFbk.isEmpty()) {
            chartList.setTraceType(awf.a).addDeviceChart(RobotCategory, "Position", "rad", -1.5707963267948966, 1.5707963267948966, this.position).addDeviceChart(RobotCategory, "Velocity", "rad/s", -5.0, 5.0, this.velocity).addDeviceChart(RobotCategory, "Power", "W", 0.0, 1.0, this.power).addDeviceChart(RobotCategory, "Voltage", "V", 0.0, 50.0, this.voltage).addDeviceChart(RobotCategory, "Temperature", "\u00b0C", 0.0, 100.0, this.temperature).addQuaternionTraces(RobotCategory, "First Orientation", this.firstOrientation).setTraceType(awf.c).addDeviceChart(RobotCategory, "Round Trip Time", "ms", 0.0, 0.5, this.roundTripTime).addAsHistogram(RobotCategory, "Round Trip Time %", "ms", this.roundTripTime).addDeviceChart(RobotCategory, "Hardware Response Time", "ms", 0.0, 0.5, this.hwResponseTime).addAsHistogram(RobotCategory, "Hardware Response Time %", "ms", this.hwResponseTime).addDeviceChart(RobotCategory, "Transmit Time Delta", "ms", 0.0, 0.5, this.transmitTimeDelta).addAsHistogram(RobotCategory, "Transmit Time Delta %", "ms", this.transmitTimeDelta).addDeviceChart(RobotCategory, "Packet Loss", "", 0.0, 1.0, this.packetLoss).addAsHistogram(RobotCategory, "Packet Loss %", "", this.packetLoss).addDeviceChart(RobotCategory, "Rx Sequence", "", 0.0, 1.0, this.rxSequence).setTraceType(awf.a);
        }
        chartList.setTraceType(awf.a).addTimeTraces(RuntimeCategory, "Voltage", "V", 0.0, 50.0, new jh[]{this.runtimeBatteryVoltage, this.runtimePcVoltage}, renderer -> {
            auz.a(renderer, 0, "battery", new String[0]);
            auz.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Temperature", "\u00b0C", 0.0, 50.0, new jh[]{this.runtimeAmbientTemperature, this.runtimePcTemperature}, renderer -> {
            auz.a(renderer, 0, "ambient", new String[0]);
            auz.a(renderer, 1, "computer", new String[0]);
        }).addTimeTraces(RuntimeCategory, "CPU Usage", "%", 0.0, 100.0, new jh[]{this.runtimePcUserCpuUsage, this.runtimePcKernelCpuUsage}, renderer -> {
            auz.a(renderer, 0, "user", new String[0]);
            auz.a(renderer, 1, "kernel", new String[0]);
        }).addTimeTraces(RuntimeCategory, "Memory Usage", "MB", 0.0, 10.0, new jh[]{this.runtimePcResidentMemoryUsage, this.runtimePcVirtualMemoryUsage}, renderer -> {
            auz.a(renderer, 0, "resident", new String[0]);
            auz.a(renderer, 1, "virtual", new String[0]);
        }).addSingleTrace(RuntimeCategory, "Cycles Since Position", null, 0.0, 1.0, this.runtimeCyclesSincePositionSourceData).setTraceType(awf.c).addTimeTraces(RuntimeCategory, "Main Loop Times", "ms", 0.0, 10.0, new jh[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            auz.a(renderer, 0, "cycle time", new String[0]);
            auz.a(renderer, 1, "busy time", new String[0]);
        }).addAsHistogram(RuntimeCategory, "Main Loop Times %", "ms", new jh[]{this.runtimeMainCycleTimeMs, this.runtimeMainBusyTimeMs}, renderer -> {
            auz.a(renderer, 0, "cycle time", new String[0]);
            auz.a(renderer, 1, "busy time", new String[0]);
        });
    }

    private void resize() {
        this.time = this.resizeSingle(this.time);
        this.mapX = this.resizeSingle(this.mapX);
        this.mapY = this.resizeSingle(this.mapY);
        this.mapTheta = this.resizeSingle(this.mapTheta);
        this.mapDistance = this.resizeSingle(this.mapDistance);
        this.mapAngularDistance = this.resizeSingle(this.mapAngularDistance);
        this.mapXyz = this.resizeMultiple(this.mapXyz, 3);
        this.runtimeAmbientTemperature = this.resizeSingle(this.runtimeAmbientTemperature);
        this.runtimeBatteryVoltage = this.resizeSingle(this.runtimeBatteryVoltage);
        this.runtimePcResidentMemoryUsage = this.resizeSingle(this.runtimePcResidentMemoryUsage);
        this.runtimePcVirtualMemoryUsage = this.resizeSingle(this.runtimePcVirtualMemoryUsage);
        this.runtimePcUserCpuUsage = this.resizeSingle(this.runtimePcUserCpuUsage);
        this.runtimePcKernelCpuUsage = this.resizeSingle(this.runtimePcKernelCpuUsage);
        this.runtimePcTemperature = this.resizeSingle(this.runtimePcTemperature);
        this.runtimePcVoltage = this.resizeSingle(this.runtimePcVoltage);
        this.runtimeMainCycleTimeMs = this.resizeSingle(this.runtimeMainCycleTimeMs);
        this.runtimeMainBusyTimeMs = this.resizeSingle(this.runtimeMainBusyTimeMs);
        this.runtimeCyclesSincePositionSourceData = this.resizeSingle(this.runtimeCyclesSincePositionSourceData);
        this.utThicknessSamples = this.resizeSingle(this.utThicknessSamples);
        this.poseTranslation = this.resizeMultiple(this.poseTranslation, 3);
        this.poseOrientation = this.resizeMultiple(this.poseOrientation, 4);
        this.poseDelay = this.resizeSingle(this.poseDelay);
    }

    private void resizeRobotFeedback(bjz bjz2) {
        this.numJoints = bjz2.d.aw();
        this.position = this.resizeMultiple(this.position, bjz2.d.aw());
        this.velocity = this.resizeMultiple(this.velocity, bjz2.e.aw());
        this.power = this.resizeMultiple(this.power, bjz2.f.aw());
        this.sequence = this.resizeMultiple(this.sequence, bjz2.a.aw());
        this.rxSequence = this.resizeMultiple(this.rxSequence, bjz2.b.aw());
        this.roundTripTime = this.resizeMultiple(this.roundTripTime, bjz2.c.aw());
        this.hwResponseTime = this.resizeMultiple(this.hwResponseTime, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.transmitTimeDelta = this.resizeMultiple(this.transmitTimeDelta, this.roundTripTime.length);
        this.packetLoss = this.resizeMultiple(this.packetLoss, this.roundTripTime.length);
        this.temperature = this.resizeMultiple(this.temperature, bjz2.g.aw());
        this.voltage = this.resizeMultiple(this.voltage, bjz2.h.aw());
        this.firstOrientation = this.resizeMultiple(this.firstOrientation, 4);
        this.prevRobotFbk.c();
    }
}

