/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.custom;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import us.hebi.core.messages.flat.FlatFeedback;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.afo;
import us.hebi.gui.lib.akk;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awm;
import us.hebi.gui.lib.awn;
import us.hebi.gui.lib.awo;
import us.hebi.gui.lib.azq;
import us.hebi.gui.lib.jh;

public class DeviceData {
    final aee deviceAddress;
    String family;
    String name;
    final jh time = new jh();
    final List<awn> xmlCharts;
    final HashMap<String, azq> expressionMap = new HashMap();
    final List<azq> traceValues;
    private boolean hasInfo = false;
    private final akk info = new akk();
    private List<List<DataSet>> allChartTraces = Collections.emptyList();

    public DeviceData(aee aee2, List<awn> list, int n2) {
        this.xmlCharts = list;
        this.deviceAddress = aee2;
        for (awn awn2 : list) {
            for (awo awo2 : awn2.getTraces()) {
                if (this.expressionMap.containsKey(awo2.getValue())) continue;
                this.expressionMap.put(awo2.getValue(), new azq(awo2.getFunc(), new jh(n2)));
            }
            awm awm2 = awn2.getAxisX();
            if (awm2 == null || this.expressionMap.containsKey(awm2.getExpression())) continue;
            this.expressionMap.put(awm2.getExpression(), new azq(awm2.getFunc(), new jh(n2)));
        }
        this.traceValues = List.copyOf(this.expressionMap.values());
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public afo getInfo() {
        return this.info;
    }

    public void addInfo(afo afo2) {
        this.family = afo2.getFamily();
        this.name = afo2.getName();
        this.info.a(afo2);
        this.hasInfo = true;
    }

    public void addFeedback(double d2, FlatFeedback flatFeedback, FlatFeedback flatFeedback2) {
        this.time.d(d2);
        Iterator<azq> iterator = this.traceValues.iterator();
        while (iterator.hasNext()) {
            FlatFeedback flatFeedback3 = flatFeedback2;
            FlatFeedback flatFeedback4 = flatFeedback;
            azq azq2 = iterator.next();
            azq2.d.d(azq2.a.computeValue(flatFeedback4, flatFeedback3));
        }
    }

    public void convertToDataSets() {
        double[] dArray = DeviceData.toArrayAndReset(this.time);
        this.allChartTraces = new ArrayList<List<DataSet>>(this.xmlCharts.size());
        for (int i2 = 0; i2 < this.xmlCharts.size(); ++i2) {
            awn awn2 = this.xmlCharts.get(i2);
            int n2 = awn2.getTraces().size();
            ArrayList<avy> arrayList = new ArrayList<avy>(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                awo awo2 = awn2.getTraces().get(i3);
                double[] dArray2 = awn2.getAxisX() == null ? dArray : this.getValues(awn2.getAxisX().getExpression());
                double[] dArray3 = this.getValues(awo2.getValue());
                String string = awo2.getLabel() + "[" + awo2.getUnits() + "]";
                avy avy2 = new avy(string, dArray2, dArray3);
                avy2.addStyleClasses(new String[]{awo2.getStyle().F()});
                avy2.setStyle(DataSetStyleBuilder.instance().setDatasetColor(auz.a(awo2.getColor())).build());
                arrayList.add(avy2);
            }
            this.allChartTraces.add(arrayList);
        }
    }

    public List<DataSet> getDataSets(int n2) {
        return this.allChartTraces.get(n2);
    }

    static double[] toArrayAndReset(jh jh2) {
        try {
            double[] dArray = jh2.a();
            return dArray;
        }
        finally {
            jh2.F();
        }
    }

    private double[] getValues(String string) {
        azq azq2 = this.expressionMap.get(string);
        if (azq2.F == null) {
            azq2.F = DeviceData.toArrayAndReset(azq2.d);
        }
        return azq2.F;
    }

    public String toString() {
        if (this.family != null || this.name != null) {
            return this.family + " | " + this.name;
        }
        return String.valueOf(this.deviceAddress).substring(1);
    }
}

