/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer;

import io.fair_acc.chartfx.XYChart;
import java.io.File;
import java.io.FileOutputStream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Material;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.e;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.any;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.arb;
import us.hebi.gui.lib.ari;
import us.hebi.gui.lib.arq;
import us.hebi.gui.lib.arv;
import us.hebi.gui.lib.arw;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.auc;
import us.hebi.gui.lib.auy;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.axy;
import us.hebi.gui.lib.ayn;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ays;
import us.hebi.gui.lib.ayt;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.azh;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azn;
import us.hebi.gui.lib.bbt;
import us.hebi.gui.lib.bcw;
import us.hebi.gui.lib.bcx;
import us.hebi.gui.lib.ze;
import us.hebi.gui.views.logviewer.custom.CustomLogviewerView;
import us.hebi.gui.views.logviewer.hebilog.HebiLogContent;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.NamedChart;
import us.hebi.gui.views.scope.assets.Asset;

public class LogviewerPresenter
extends axy {
    @FXML
    private Pane root;
    @FXML
    private TreeView<NamedChart> plotTree;
    @FXML
    private AnchorPane chartPane;
    @FXML
    private Button saveGainsBtn;
    @FXML
    private Button loadHrdfBtn;
    @FXML
    private Button loadCustomBtn;
    @FXML
    private Button view3dBtn;
    public static final PseudoClass CELL_CATEGORY = PseudoClass.getPseudoClass((String)"category");
    final TreeItem<NamedChart> rootNode = new TreeItem();
    @Inject
    HebiLogContent logContent;
    @Inject
    auc fileChooser;
    @Inject
    aqt properties;
    @Inject
    asg notificationService;
    ayt indicator = new ayt();
    DoubleProperty selectedTime = new SimpleDoubleProperty(0.0);
    ayn timer = ayn.a(d2 -> this.selectedTime.set(this.selectedTime.get() + d2));
    IntegerBinding selectedIndex = Bindings.createIntegerBinding(() -> {
        double d2 = this.selectedTime.get();
        if (!Double.isFinite(d2) || this.logContent == null || !this.logContent.hasValidFeedback()) {
            return -1;
        }
        return this.logContent.getFeedback().getIndexAt(d2);
    }, (Observable[])new Observable[]{this.selectedTime});
    BooleanProperty showModelCmd = new SimpleBooleanProperty(false);

    @Override
    public void initializeFx() {
        azj.g((Parent)this.root);
        this.indicator.a((Pane)this.root).loading.bind((ObservableValue)this.logContent.loadingProperty());
        this.logContent.loadAsync().thenRunAsync(this::updateChartMenu, Platform::runLater);
        XYChart xYChart = auz.a(-10.0, 10.0, "");
        this.chartPane.getChildren().setAll((Object[])new Node[]{ayo.c(xYChart)});
        ays.b((Node)this.chartPane);
        this.plotTree.setCellFactory(LogviewerPresenter::createStyledCell);
        this.plotTree.setRoot(this.rootNode);
        this.plotTree.getSelectionModel().selectedItemProperty().addListener((observableValue, treeItem, treeItem2) -> {
            if (treeItem2 == null || treeItem2.getValue() == null || ((NamedChart)treeItem2.getValue()).isCategory()) {
                return;
            }
            this.chartPane.getChildren().setAll((Object[])new Node[]{ayo.c(((NamedChart)treeItem2.getValue()).getChart())});
        });
        this.saveGainsBtn.disableProperty().bind((ObservableValue)this.logContent.hasInfoProperty().not());
        this.saveGainsBtn.setOnAction(actionEvent -> {
            Window window = ayo.a(actionEvent);
            File file = this.fileChooser.e(window);
            if (file != null) {
                try {
                    File file2 = file;
                    ze ze2 = ze.a(this.logContent.getInfo());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        ze2.a(fileOutputStream);
                    }
                    asf.a(file, window);
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.e(exception);
                }
            }
        });
        this.loadHrdfBtn.setOnAction(actionEvent -> {
            Window window = ayo.a(actionEvent);
            File file = this.fileChooser.b(window);
            if (file != null) {
                try {
                    int n2 = bcx.a(file).a().W();
                    if (this.logContent.getNumJoints() != n2) {
                        throw new IllegalArgumentException("The log file contains " + this.logContent.getNumJoints() + " joints, but the selected HRDF lists " + n2 + " joints.");
                    }
                    this.logContent.setHrdfFile(file);
                    this.updateChartMenu();
                    return;
                }
                catch (Exception exception) {
                    this.notificationService.e(exception);
                }
            }
        });
        this.loadCustomBtn.setOnAction(actionEvent -> new CustomLogviewerView(this.logContent.getFile()).getViewAsync(parent -> {
            Stage stage = new Stage();
            stage.getIcons().add((Object)e.c);
            stage.setTitle(this.logContent.getFileName());
            stage.setScene(new Scene(parent));
            ayo.a(stage, ayo.a(actionEvent));
        }));
        if (!ayo.aV()) {
            this.view3dBtn.setDisable(true);
        } else {
            BooleanBinding booleanBinding = Bindings.size(this.logContent.getMobileIoList()).isEqualTo(0);
            this.view3dBtn.disableProperty().bind((ObservableValue)booleanBinding.and((ObservableBooleanValue)this.logContent.hasValidHrdf().not()));
            this.view3dBtn.setOnAction(actionEvent -> {
                Window window = ayo.a(actionEvent);
                if (this.logContent.hasValidHrdf().get()) {
                    this.launchStage(window, (Pane)this.createRobotView3d());
                }
                for (MobileIoFeedback mobileIoFeedback : this.logContent.getMobileIoList()) {
                    this.launchStage(window, (Pane)this.createMobileIo3d(mobileIoFeedback));
                }
            });
        }
        this.selectedTime.bindBidirectional((Property)this.logContent.getChartList().getIndicatorTime());
        ayo.a((Node)this.root, this::registerKeyHandler);
    }

    private void launchStage(Window window, Pane pane) {
        Stage stage = new Stage();
        stage.getIcons().add((Object)e.c);
        stage.setTitle(this.logContent.getFileName());
        stage.setScene(new Scene((Parent)pane, 700.0, 450.0, true));
        ayo.a(stage, window);
        Stage stage2 = stage;
        ays.a(stage2, () -> ((Stage)stage2).close());
    }

    private void registerKeyHandler(Scene scene) {
        scene.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (ays.o.match(keyEvent)) {
                this.timer.bW();
                keyEvent.consume();
                return;
            }
            if (ays.a.match(keyEvent)) {
                this.showModelCmd.set(!this.showModelCmd.get());
                keyEvent.consume();
                return;
            }
            if (ays.e.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() - 1.0);
                keyEvent.consume();
                return;
            }
            if (ays.f.match(keyEvent)) {
                this.selectedTime.set(this.selectedTime.get() + 1.0);
                keyEvent.consume();
            }
        });
    }

    private AnchorPane createRobotView3d() {
        arv arv2 = new arv();
        any any2 = arv2.a;
        ari ari2 = new ari(this.logContent.getXmlContent());
        ari2.A.bind((ObservableValue)arv2.e.visibleProperty());
        ari2.B.bind((ObservableValue)any2.a("CoM Axes", false));
        Object object = "Models";
        ari2.C.bind((ObservableValue)any2.a("Models", true));
        BooleanProperty booleanProperty = any2.a("Command Overlay", this.showModelCmd.get(), "ctrl + f");
        ayo.a(booleanProperty, this.showModelCmd);
        ari ari3 = new ari(this.logContent.getXmlContent());
        ari3.A.set(false);
        ari3.B.set(false);
        ari3.C.bind((ObservableValue)ari2.C);
        ari3.c.visibleProperty().bind((ObservableValue)booleanProperty);
        aa.a((Node)ari3.c, (Material)ari.c);
        XyzLogData xyzLogData = this.logContent.getXyzData();
        arq arq2 = new arq(xyzLogData.xyzPosition, auy.f);
        arq arq3 = new arq(xyzLogData.xyzPositionCmd, auy.e);
        object = "Fbk Line";
        arq2.visibleProperty().bind((ObservableValue)any2.a("Fbk Line", true));
        object = "Cmd Line";
        arq3.visibleProperty().bind((ObservableValue)any2.a("Cmd Line", true));
        BooleanProperty booleanProperty2 = any2.a("Full Line", false);
        arq2.L.bind((ObservableValue)booleanProperty2);
        arq3.L.bind((ObservableValue)booleanProperty2);
        Node node = ari.a();
        node.visibleProperty().bind((ObservableValue)ari2.B);
        bbt bbt2 = bcx.a(this.logContent.getXmlContent()).a();
        object = node;
        arb arb2 = new arb(new bcw(bbt2));
        new arb(new bcw(bbt2)).b = object;
        arv arv3 = arv2;
        object = arv3.d;
        v0.a = object;
        arb arb3 = arb2;
        arb3.y.bind((ObservableValue)any2.a("Orient Base", false));
        arb3.z.bind((ObservableValue)any2.a("Offset Base", false));
        arb3.update();
        ayo.a(any2.a("Play", this.timer.U.get(), "ctrl + space"), this.timer.U);
        arv3 = arv2;
        arv3.d.getChildren().setAll((Object[])new Node[]{ari2.c, ari3.c, arq2, arq3, node});
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            arq3.w(n2);
            arq2.w(n2);
            HebiLogFeedback hebiLogFeedback = this.logContent.getFeedback();
            for (int i2 = 0; i2 < hebiLogFeedback.getNumJoints(); ++i2) {
                ari2.b(i2, hebiLogFeedback.position[i2].a(n2));
                ari3.b(i2, hebiLogFeedback.positionCmd[i2].a(n2));
                arb3.a(i2, hebiLogFeedback.position[i2].a(n2));
            }
            arb3.a(hebiLogFeedback.firstOrientation[0].a(n2), hebiLogFeedback.firstOrientation[1].a(n2), hebiLogFeedback.firstOrientation[2].a(n2), hebiLogFeedback.firstOrientation[3].a(n2));
            arb3.update();
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        ays.a((Node)arv2, () -> {
            any2.setVisible(false);
            Image image = ayo.a((Node)arv2);
            any2.setVisible(true);
            return image;
        });
        ayo.a((Node)arv2, this::registerKeyHandler);
        azh.f((Parent)arv2);
        azg.d((Parent)arv2);
        azj.g((Parent)arv2);
        ayo.b((Parent)arv2);
        return arv2;
    }

    private AnchorPane createMobileIo3d(MobileIoFeedback mobileIoFeedback) {
        arv arv2 = new arv();
        any any2 = arv2.a;
        String string = "Model";
        BooleanProperty booleanProperty = any2.a("Model", true);
        arw arw2 = new arw(new Node[0]);
        ayo.a(Asset.Iphone::getModel, group -> {
            group.visibleProperty().bind((ObservableValue)booleanProperty);
            arw2.getChildren().add(group);
        });
        arq arq2 = new arq(mobileIoFeedback.arPosition, auy.i);
        BooleanProperty booleanProperty2 = any2.a("Full Path", false);
        string = "Path";
        arq2.visibleProperty().bind((ObservableValue)any2.a("Path", true));
        arq2.L.bind((ObservableValue)booleanProperty2);
        ayo.a(any2.a("Play", this.timer.U.get(), "ctrl + space"), this.timer.U);
        arv arv3 = arv2;
        arv3.d.getChildren().setAll((Object[])new Node[]{arq2, arw2});
        Runnable runnable = () -> {
            int n2 = this.selectedIndex.get();
            if (n2 < 0) {
                return;
            }
            arq2.w(n2);
            arw2.b(mobileIoFeedback.arOrientation[0].a(n2), mobileIoFeedback.arOrientation[1].a(n2), mobileIoFeedback.arOrientation[2].a(n2), mobileIoFeedback.arOrientation[3].a(n2), mobileIoFeedback.arPosition[0].a(n2), mobileIoFeedback.arPosition[1].a(n2), mobileIoFeedback.arPosition[2].a(n2));
        };
        this.selectedIndex.addListener(observable -> runnable.run());
        runnable.run();
        ays.a((Node)arv2, () -> {
            any2.setVisible(false);
            Image image = ayo.a((Node)arv2);
            any2.setVisible(true);
            return image;
        });
        ayo.a((Node)arv2, this::registerKeyHandler);
        azh.f((Parent)arv2);
        azg.d((Parent)arv2);
        azj.g((Parent)arv2);
        ayo.b((Parent)arv2);
        return arv2;
    }

    public void updateChartMenu() {
        this.plotTree.getSelectionModel().clearSelection();
        this.rootNode.getChildren().setAll(this.logContent.createChartHierarchy());
        if (this.rootNode.getChildren().size() > 0) {
            this.plotTree.getSelectionModel().select(1);
        }
    }

    public static <T> TreeCell<NamedChart> createStyledCell(TreeView<NamedChart> treeView) {
        return new azn();
    }
}

