/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.imitation;

import atlantafx.base.controls.CustomTextField;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import us.hebi.gui.lib.acj;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.anu;
import us.hebi.gui.lib.aod;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.ayb;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azm;
import us.hebi.gui.lib.wb;
import us.hebi.gui.lib.wc;
import us.hebi.gui.lib.wm;
import us.hebi.gui.views.imitation.ImitationPresenter$Properties;

public class ImitationPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private ToggleButton arm6Regular;
    @FXML
    private ToggleGroup selectedArm;
    @FXML
    private ToggleButton arm6DoubleShoulder;
    @FXML
    private ToggleButton arm7Regular;
    @FXML
    private ToggleGroup selectedArm1;
    @FXML
    private ToggleButton arm7DoubleShoulder;
    @FXML
    private ToggleButton baseOmni;
    @FXML
    private ToggleGroup selectedBase;
    @FXML
    private ToggleButton baseHexapod;
    @FXML
    private ToggleButton baseMecanum;
    @FXML
    private ToggleButton baseTready;
    @FXML
    private ToggleButton baseDiffDrive;
    @FXML
    private ToggleButton baseIgor;
    @FXML
    private ToggleGroup selectedPort;
    @FXML
    private ToggleGroup selectedInterface;
    @FXML
    private TextArea customNames;
    @FXML
    private CustomTextField familyName;
    @FXML
    private VBox interfaceToggleBox;
    @FXML
    private ToggleButton interfaceLocalhost;
    @FXML
    private ToggleButton interfaceAny;
    @FXML
    private ToggleButton portDefault;
    @FXML
    private ToggleButton portRandom;
    @FXML
    private Text localAddressPort;
    @FXML
    private Text localAddressIp;
    @FXML
    private Circle connectionLed;
    int uniqueId;
    private final List<wb> kitDeviceList = new ArrayList<wb>();
    private final List<wb> customDeviceList = new ArrayList<wb>();
    private Map<azm, List<wb>> kitMap;
    private wc deviceWrapper = new wc();
    private wm server;
    BooleanProperty hasErrors = new SimpleBooleanProperty(false);
    @Inject
    ImitationPresenter$Properties properties;
    @Inject
    aqt scopeProperties;

    @FXML
    void initialize() throws IOException {
        ayo.b(this::initializeOnFxThread);
    }

    public void setNamesFromRobotConfig(acj acj2) {
        this.selectedArm.selectToggle(null);
        this.selectedBase.selectToggle(null);
        this.familyName.setText(acj2.getFamilies().get(0));
        this.customNames.setText(String.valueOf(acj2.getNames()));
    }

    private void initializeOnFxThread() {
        this.selectedArm.selectedToggleProperty().addListener(observable -> this.update());
        this.selectedBase.selectedToggleProperty().addListener(observable -> this.update());
        ayb.a((Labeled)this.portDefault, (ReadOnlyBooleanProperty)this.hasErrors);
        int n2 = this.properties.selectedArmIndex.get();
        if (n2 >= 0 && n2 < this.selectedArm.getToggles().size()) {
            this.selectedArm.selectToggle((Toggle)this.selectedArm.getToggles().get(n2));
        }
        this.selectedArm.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedArm.getToggles().indexOf(toggle2);
            this.properties.selectedArmIndex.set(n2);
        });
        n2 = this.properties.selectedBaseIndex.get();
        if (n2 >= 0 && n2 < this.selectedBase.getToggles().size()) {
            this.selectedBase.selectToggle((Toggle)this.selectedBase.getToggles().get(n2));
        }
        this.selectedBase.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedBase.getToggles().indexOf(toggle2);
            this.properties.selectedBaseIndex.set(n2);
        });
        this.customNames.textProperty().addListener((observableValue, string, string2) -> this.updateCustomNames());
        this.customNames.textProperty().bindBidirectional((Property)this.properties.customNames);
        this.customNames.setTooltip(azj.a("delimiters\n*  newline\n*  comma\n*  semicolon\n\nignored\n*  quotes\n*  brackets\n*  parentheses\n*  whitespace"));
        this.familyName.textProperty().addListener((observableValue, string, string2) -> this.applyFamily());
        this.familyName.textProperty().bindBidirectional((Property)this.properties.familyName);
        this.localAddressPort.visibleProperty().bind((ObservableValue)this.portRandom.selectedProperty());
        this.localAddressPort.managedProperty().bind((ObservableValue)this.localAddressPort.visibleProperty());
        this.localAddressIp.visibleProperty().bind((ObservableValue)this.interfaceLocalhost.selectedProperty());
        this.localAddressIp.managedProperty().bind((ObservableValue)this.localAddressIp.visibleProperty());
        this.selectedPort.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> this.initServer());
        this.selectedInterface.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == null) {
                this.selectedInterface.selectToggle((Toggle)this.interfaceAny);
                return;
            }
            this.initServer();
        });
        this.initServer();
        azj.g((Parent)this.rootPane);
    }

    void initServer() {
        AutoCloseable[] cfr_ignored_0 = new AutoCloseable[0];
        ame.a(this.server);
        aod.a((Node)this.connectionLed, anu.a);
        if (this.selectedPort.getSelectedToggle() == null) {
            this.server = null;
            return;
        }
        try {
            InetAddress inetAddress = this.interfaceLocalhost.isSelected() ? InetAddress.getLoopbackAddress() : null;
            int n2 = this.portDefault.isSelected() ? 16665 : 0;
            this.deviceWrapper.m(this.properties.uniqueSenderId.get());
            this.deviceWrapper.a(this.getFullDeviceList());
            this.server = new wm(inetAddress, n2, this.deviceWrapper);
            aod.a((Node)this.connectionLed, anu.b);
            this.hasErrors.set(false);
            this.localAddressPort.setText(String.valueOf(((aem)this.server).b.getPort()));
            this.localAddressIp.setText(((aem)this.server).b.getAddress().toString().substring(1));
            wm wm2 = this.server;
            Thread thread = new Thread(wm2);
            thread.setDaemon(true);
            thread.start();
            return;
        }
        catch (IOException iOException) {
            aod.a((Node)this.connectionLed, anu.c);
            this.hasErrors.set(true);
            Platform.runLater(() -> asf.a(new RuntimeException("You may already be running another imitation process", iOException), this.rootPane.getScene().getWindow()));
            return;
        }
    }

    void applyFamily() {
        String string = this.familyName.getText();
        Iterator<wb> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
        iterator = this.customDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
    }

    void updateCustomNames() {
        List<String> list = Arrays.stream(this.customNames.getText().split("[,;\n]")).map(string -> string.replaceAll("['\"{}\\[\\]()]", "")).map(String::strip).filter(string -> !string.isEmpty()).limit(16382 - this.kitDeviceList.size()).toList();
        boolean bl2 = false;
        while (this.customDeviceList.size() < list.size()) {
            this.customDeviceList.add(wb.a().a(this.familyName.getText()));
            bl2 = true;
        }
        int n2 = 0;
        for (wb wb2 : this.customDeviceList) {
            if (n2 < list.size()) {
                wb2.b(list.get(n2));
                wb2.J = false;
            } else {
                wb2.J = true;
            }
            ++n2;
        }
        if (bl2 && this.server != null) {
            this.deviceWrapper.a(this.getFullDeviceList());
        }
    }

    @PostConstruct
    public void init() {
        this.kitMap = new HashMap<azm, List<wb>>();
        for (azm azm2 : azm.values()) {
            List<wb> list = azm2.ac.stream().map(string -> {
                wb wb2 = wb.a();
                wb.a().J = true;
                return wb2.b((String)string);
            }).toList();
            this.kitMap.put(azm2, list);
            this.kitDeviceList.addAll(list);
        }
    }

    private List<wb> getFullDeviceList() {
        if (this.customDeviceList.size() == 0) {
            return this.kitDeviceList;
        }
        ArrayList<wb> arrayList = new ArrayList<wb>(this.kitDeviceList.size() + this.customDeviceList.size());
        arrayList.addAll(this.kitDeviceList);
        arrayList.addAll(this.customDeviceList);
        return arrayList;
    }

    @PreDestroy
    public void stop() {
        AutoCloseable[] cfr_ignored_0 = new AutoCloseable[0];
        ame.a(this.server);
    }

    void update() {
        ArrayList arrayList = new ArrayList();
        Toggle toggle = this.selectedArm.getSelectedToggle();
        if (toggle == this.arm6Regular) {
            arrayList.addAll(this.kitMap.get((Object)azm.a));
        } else if (toggle == this.arm6DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)azm.b));
        } else if (toggle == this.arm7Regular) {
            arrayList.addAll(this.kitMap.get((Object)azm.c));
        } else if (toggle == this.arm7DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)azm.d));
        }
        Toggle toggle2 = this.selectedBase.getSelectedToggle();
        if (toggle2 == this.baseOmni) {
            arrayList.addAll(this.kitMap.get((Object)azm.e));
        } else if (toggle2 == this.baseDiffDrive) {
            arrayList.addAll(this.kitMap.get((Object)azm.f));
        } else if (toggle2 == this.baseMecanum) {
            arrayList.addAll(this.kitMap.get((Object)azm.g));
        } else if (toggle2 == this.baseHexapod) {
            arrayList.addAll(this.kitMap.get((Object)azm.h));
        } else if (toggle2 == this.baseTready) {
            arrayList.addAll(this.kitMap.get((Object)azm.i));
        } else if (toggle2 == this.baseIgor) {
            arrayList.addAll(this.kitMap.get((Object)azm.j));
        }
        Iterator<wb> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().J = true;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().J = false;
        }
        this.applyFamily();
    }
}

