/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.bootloader;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.TaskProgressView;
import us.hebi.gui.lib.ad;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.afq;
import us.hebi.gui.lib.ahq;
import us.hebi.gui.lib.amd;
import us.hebi.gui.lib.aob;
import us.hebi.gui.lib.aoc;
import us.hebi.gui.lib.app;
import us.hebi.gui.lib.apx;
import us.hebi.gui.lib.apz;
import us.hebi.gui.lib.aqc;
import us.hebi.gui.lib.aqe;
import us.hebi.gui.lib.aqh;
import us.hebi.gui.lib.aqm;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asi;
import us.hebi.gui.lib.asr;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.atf;
import us.hebi.gui.lib.atg;
import us.hebi.gui.lib.ato;
import us.hebi.gui.lib.atq;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.baz;
import us.hebi.gui.lib.bba;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bnx;
import us.hebi.gui.lib.bpl;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.vj;
import us.hebi.gui.lib.vl;

public class BootloaderPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ToolBar topBar;
    @FXML
    private Button loginButton;
    @FXML
    private Button bootButton;
    @FXML
    private Button calibrateCurrentButton;
    @FXML
    private Button programRawButton;
    @FXML
    private Button programEncryptingButton;
    @FXML
    private Button showMacAddressesButton;
    @FXML
    private Button setBootloaderParametersButton;
    @FXML
    private Button setApplicationParametersButton;
    @FXML
    private Button fullUpdateButton;
    @FXML
    private Button updateApplicationButton;
    @FXML
    private Button updateBootloaderButton;
    @FXML
    private Button updateBootloaderLoaderButton;
    @FXML
    private Button eraseApplicationButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button calibratePositionButton;
    @FXML
    private Button calibrateEffortButton;
    @FXML
    private Button setDatabaseValueButton;
    @FXML
    private Button eraseDatabaseButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button saveApplicationButton;
    @FXML
    private Button saveBootloaderButton;
    @FXML
    private Button saveAllPartitionsButton;
    @FXML
    private Button saveDatabaseButton;
    @FXML
    private TaskProgressView<Task<?>> taskProgressView;
    @FXML
    private VBox buttonVBox;
    @FXML
    public TreeView<String> typeTree;
    @FXML
    private TreeView<aqq> moduleTree;
    @FXML
    private RadioButton viewSelectorFamilyName;
    @FXML
    private ChoiceBox<String> interfaceChoiceBox;
    @FXML
    private TextField hwType;
    @FXML
    private TextField hwEceType;
    @FXML
    private TextField hwEceRevision;
    @FXML
    private TextField hwSerial;
    @FXML
    private TextField fwType;
    @FXML
    private TextField fwRevision;
    @FXML
    private TextField ethMacAddress;
    @FXML
    private TextField ethIpAddress;
    @FXML
    private TextField ethNetmask;
    @FXML
    private TextField ethGateway;
    @FXML
    private TextField fwMode;
    @FXML
    private TextField hwRevision;
    @FXML
    private TextField hwSpringConstant;
    private static final String DATABASE_MESSAGE = "Clearing the database will wipe any existing calibration data and requires an appropriate physical setup. Continuing may render the device unusable. Are you sure that you want to proceed?";
    private static final String CALIBRATION_MESSAGE = "Calibrating will wipe any existing calibration data and requires an appropriate physical setup.Are you sure that you want to proceed?";
    int dbAddress = 28672;
    Float floatVal = null;
    Integer intVal = null;
    @Inject
    asr oAuth2Service;
    @Inject
    atf lookupService;
    @Inject
    atg selector;
    @Inject
    atd interfaceChoiceService;
    @Inject
    atq simpleCategoryTree;
    @Inject
    public ato filteredFlatModuleTree;
    @Inject
    asy commandService;
    ahq command;
    @Inject
    aoc moduleTreeCellFactory;
    @Inject
    asi bootloaderService;

    @FXML
    void refreshInterfaces(ActionEvent actionEvent) {
        this.interfaceChoiceService.refreshInterfaces();
    }

    @FXML
    void reset(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setResetFlag();
        this.selector.getSelectedAddresses().forEach(aee2 -> this.commandService.a((aee)aee2, this.command));
    }

    @FXML
    void stopBoot(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setStayInBootloaderFlag();
        this.selector.getSelectedAddresses().forEach(aee2 -> this.commandService.a((aee)aee2, this.command));
    }

    @FXML
    void boot(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setBootFlag();
        this.selector.getSelectedAddresses().forEach(aee2 -> this.commandService.a((aee)aee2, this.command));
    }

    @FXML
    void setBootloaderHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setBootloaderHardwareParameters((List<aqq>)this.selector.getSelectedModules());
    }

    @FXML
    void setApplicationHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setApplicationHardwareParameters((List<aqq>)this.selector.getSelectedModules());
    }

    @FXML
    void programApplication(ActionEvent actionEvent) {
        this.bootloaderService.programApplicationMultiple((List<aqq>)this.selector.getSelectedModules(), this.programRawButton.getScene().getWindow());
    }

    @FXML
    void programEncryptingFirmware(ActionEvent actionEvent) {
        this.bootloaderService.programEncryptingFirmwareMultiple((List<aqq>)this.selector.getSelectedModules(), this.programEncryptingButton.getScene().getWindow());
    }

    @FXML
    void doFullUpdate(ActionEvent actionEvent) {
        this.bootloaderService.doFullUpdate(this.selector.getSingleSelection());
    }

    @FXML
    void updateApplication(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aqq>)this.selector.getSelectedModules(), bba.d);
    }

    @FXML
    void updateBootloader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aqq>)this.selector.getSelectedModules(), bba.e);
    }

    @FXML
    void updateBootloaderLoader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aqq>)this.selector.getSelectedModules(), bba.f);
    }

    @FXML
    void eraseApplication(ActionEvent actionEvent) {
        for (aqq aqq2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aqq2), bnx.d);
        }
    }

    @FXML
    void eraseDatabase(ActionEvent actionEvent) {
        if (!asf.a(CALIBRATION_MESSAGE, ayo.a(actionEvent))) {
            return;
        }
        for (aqq aqq2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aqq2), bnx.e);
        }
    }

    @FXML
    void saveAllPartitions(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bnx.c, this.saveAllPartitionsButton.getScene().getWindow());
    }

    @FXML
    void saveBootloader(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bnx.f, this.saveBootloaderButton.getScene().getWindow());
    }

    @FXML
    void saveApplication(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bnx.d, this.saveApplicationButton.getScene().getWindow());
    }

    @FXML
    void saveDatabase(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bnx.e, this.saveDatabaseButton.getScene().getWindow());
    }

    @FXML
    void calibrateCurrent(ActionEvent actionEvent) {
        if (!asf.a(CALIBRATION_MESSAGE, ayo.a(actionEvent))) {
            return;
        }
        System.out.println("continue");
        this.selector.getSelectedAddresses().forEach(aee2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().d(true);
            this.commandService.a((aee)aee2, this.command);
        });
    }

    @FXML
    void calibratePosition(ActionEvent actionEvent) {
        if (!asf.a(CALIBRATION_MESSAGE, ayo.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(aee2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().a(true);
            this.commandService.a((aee)aee2, this.command);
        });
    }

    @FXML
    void calibrateEffort(ActionEvent actionEvent) {
        if (!asf.a(CALIBRATION_MESSAGE, ayo.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(aee2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().b(true);
            this.commandService.a((aee)aee2, this.command);
        });
    }

    @FXML
    void showMacAddresses(ActionEvent actionEvent) {
        aqq aqq22;
        Object object = "";
        for (aqq aqq22 : this.selector.getSelectedModules()) {
            object = (String)object + aqq22.c().toString() + "\n";
        }
        Iterator iterator = new TextArea((String)object);
        aqq22 = new Dialog();
        aqq22.setTitle("Mac Address");
        DialogPane dialogPane = aqq22.getDialogPane();
        dialogPane.setContent((Node)iterator);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        aqq22.show();
    }

    @FXML
    void showLoginDialog(ActionEvent actionEvent) {
        baz baz2 = this.oAuth2Service.authenticationService;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("approval_prompt", "force");
        baz2.a = baz2.a.getAuthorizationUrlWithPKCE(hashMap);
        baz2.webViewer.showDocument(baz2.a.getAuthorizationUrl());
    }

    @FXML
    void setDatabaseValue(ActionEvent actionEvent) {
        Optional optional = aob.a("Set Database Value", h.a(new String[]{"Address", "FloatValue", "IntValue"}), h.a(new String[]{"0x" + Integer.toHexString(this.dbAddress), this.floatVal == null ? "" : this.floatVal.toString(), this.intVal == null ? "" : this.intVal.toString()})).showAndWait();
        if (!optional.isPresent()) {
            return;
        }
        List list = (List)optional.get();
        try {
            boolean bl2 = !ad.a((String)list.get(1));
            boolean bl3 = !ad.a((String)list.get(2));
            h.a(!ad.a((String)list.get(0)), (Object)"Address must not be empty");
            h.a(bl2 || bl3, (Object)"Expected a value field to be set.");
            h.a(!bl2 || !bl3, (Object)"Expected only one value field to be set.");
            this.dbAddress = Integer.decode((String)list.get(0));
            this.floatVal = bl2 ? Float.valueOf(Float.parseFloat((String)list.get(1))) : null;
            this.intVal = bl3 ? Integer.decode((String)list.get(2)) : null;
            this.command.clear();
            bpl bpl2 = this.command.getRootMessage().d().d();
            bpl2.b(this.dbAddress);
            if (bl2) {
                bpl2.a(this.floatVal.floatValue());
            }
            if (bl3) {
                bpl2.a(this.intVal);
            }
            this.selector.getSelectedAddresses().forEach(aee2 -> this.commandService.a((aee)aee2, this.command));
            return;
        }
        catch (Exception exception) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(null);
            alert.setContentText(exception.getMessage());
            alert.showAndWait();
            return;
        }
    }

    @FXML
    void initialize() {
        assert (this.bootButton != null) : "fx:id=\"bootButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibrateCurrentButton != null) : "fx:id=\"calibrateCurrentButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.taskProgressView != null) : "fx:id=\"taskProgressView\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.moduleTree != null) : "fx:id=\"moduleTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.typeTree != null) : "fx:id=\"typeTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programRawButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programEncryptingButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.updateApplicationButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseApplicationButton != null) : "fx:id=\"eraseApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.stopButton != null) : "fx:id=\"stopButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibratePositionButton != null) : "fx:id=\"calibratePositionButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseDatabaseButton != null) : "fx:id=\"eraseDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.resetButton != null) : "fx:id=\"resetButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveAllPartitionsButton != null) : "fx:id=\"saveAllPartitionsButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveApplicationButton != null) : "fx:id=\"saveApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveBootloaderButton != null) : "fx:id=\"saveBootloaderButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveDatabaseButton != null) : "fx:id=\"saveDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        this.typeTree.setRoot(this.simpleCategoryTree.getCategoryTree());
        this.typeTree.setShowRoot(false);
        this.typeTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.moduleTreeCellFactory.d.bind((ObservableValue)this.viewSelectorFamilyName.selectedProperty());
        this.moduleTree.setCellFactory((Callback)this.moduleTreeCellFactory);
        this.moduleTree.setRoot(this.filteredFlatModuleTree.getModuleTree());
        this.moduleTree.setShowRoot(false);
        this.moduleTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selector.setDataSource((ObservableList<TreeItem<aqq>>)this.moduleTree.getSelectionModel().getSelectedItems());
        this.typeTree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new azk(this));
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> !this.taskProgressView.getTasks().isEmpty(), (Observable[])new Observable[]{this.taskProgressView.getTasks()});
        this.taskProgressView.visibleProperty().bind((ObservableValue)booleanBinding);
        this.bootloaderService.setTaskList(this.taskProgressView.getTasks());
        this.taskProgressView.getTasks().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                block5: for (Task task : change.getRemoved()) {
                    if (task.getState() != Worker.State.FAILED) {
                        amd.g("hebi.bootloader.showSuccessNotifications");
                    }
                    Notifications notifications = Notifications.create().position(Pos.BOTTOM_RIGHT).hideAfter(Duration.INDEFINITE).owner(this.taskProgressView).title(task.getTitle()).text(task.getMessage());
                    switch (task.getState()) {
                        case FAILED: {
                            notifications.showError();
                            continue block5;
                        }
                        case CANCELLED: {
                            notifications.showWarning();
                            continue block5;
                        }
                    }
                    notifications.showInformation();
                }
            }
        });
        BooleanBinding booleanBinding2 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionEmpty());
        BooleanBinding booleanBinding3 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionSingle().not());
        BooleanBinding booleanBinding4 = this.oAuth2Service.N.not();
        ayo.a((ObservableBooleanValue)booleanBinding2, new Node[]{this.bootButton, this.stopButton, this.updateApplicationButton, this.updateBootloaderButton, this.showMacAddressesButton, this.programRawButton, this.eraseApplicationButton, this.resetButton, this.calibrateCurrentButton, this.calibratePositionButton, this.calibrateEffortButton});
        ayo.a((ObservableBooleanValue)booleanBinding3, new Node[]{this.fullUpdateButton});
        ayo.a((ObservableBooleanValue)booleanBinding4.or((ObservableBooleanValue)booleanBinding2), new Node[]{this.updateBootloaderLoaderButton, this.programEncryptingButton, this.eraseDatabaseButton, this.setDatabaseValueButton, this.setBootloaderParametersButton, this.setApplicationParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        bbc.a();
        if (!bbc.aY()) {
            this.topBar.getItems().remove((Object)this.loginButton);
            this.buttonVBox.getChildren().removeAll((Object[])new Node[]{this.programEncryptingButton, this.setBootloaderParametersButton, this.setApplicationParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        }
        this.interfaceChoiceService.init(this.interfaceChoiceBox);
        this.selector.addSingleSelectionChangeListener(this::bindToModule);
        this.bindToModule(atg.EMPTY_MODULE);
    }

    private void bindToModule(aqq aqq2) {
        if (aqq2 == null) {
            System.out.println("can't bind to null module");
            return;
        }
        aqe aqe2 = aqq2.getInfo();
        Object object = aqe2;
        apx apx2 = aqe2.a;
        object = aqe2;
        aqc aqc2 = ((aqe)object).a;
        object = aqe2;
        aqm aqm2 = ((aqe)object).a;
        object = aqe2;
        app app2 = ((aqe)object).a;
        object = aqe2;
        aqh cfr_ignored_0 = ((aqe)object).a;
        object = aqe2;
        apz cfr_ignored_1 = ((aqe)object).a;
        object = aqc2;
        this.hwType.visibleProperty().bind((ObservableValue)((aqc)object).q.isNotEmpty());
        object = aqc2;
        this.hwType.textProperty().bind((ObservableValue)((aqc)object).q);
        object = aqc2;
        this.hwRevision.visibleProperty().bind((ObservableValue)((aqc)object).p.isNotEmpty());
        object = aqc2;
        this.hwRevision.textProperty().bind((ObservableValue)((aqc)object).p);
        object = aqc2;
        this.hwEceType.visibleProperty().bind((ObservableValue)((aqc)object).o.isNotEmpty());
        object = aqc2;
        this.hwEceType.textProperty().bind((ObservableValue)((aqc)object).o);
        object = aqc2;
        this.hwEceRevision.visibleProperty().bind((ObservableValue)((aqc)object).n.isNotEmpty());
        object = aqc2;
        this.hwEceRevision.textProperty().bind((ObservableValue)((aqc)object).n);
        object = aqc2;
        this.hwSerial.visibleProperty().bind((ObservableValue)((aqc)object).r.isNotEmpty());
        object = aqc2;
        this.hwSerial.textProperty().bind((ObservableValue)((aqc)object).r);
        app app3 = app2;
        object = app3;
        object = app2;
        DoubleBinding doubleBinding = app3.h.divide((ObservableNumberValue)((app)object).f).multiply(-1);
        this.hwSpringConstant.textProperty().bind((ObservableValue)doubleBinding.asString("%.3f"));
        object = apx2;
        this.fwType.visibleProperty().bind((ObservableValue)((apx)object).m.isNotEmpty());
        object = apx2;
        this.fwType.textProperty().bind((ObservableValue)((apx)object).m);
        object = apx2;
        this.fwRevision.visibleProperty().bind((ObservableValue)((apx)object).l.isNotEmpty());
        object = apx2;
        this.fwRevision.textProperty().bind((ObservableValue)((apx)object).l);
        object = apx2;
        this.fwMode.visibleProperty().bind((ObservableValue)((apx)object).t.isNotEqualTo((Object)afq.a));
        object = apx2;
        this.fwMode.textProperty().bind((ObservableValue)((apx)object).t.asString());
        object = aqm2;
        this.ethMacAddress.visibleProperty().bind((ObservableValue)((aqm)object).B.isNotEqualTo((Object)vl.a));
        object = aqm2;
        this.ethMacAddress.textProperty().bind((ObservableValue)((aqm)object).B.asString());
        object = aqm2;
        this.ethIpAddress.visibleProperty().bind((ObservableValue)((aqm)object).y.isNotEqualTo((Object)vj.a));
        Observable[] observableArray = new Observable[2];
        object = aqm2;
        observableArray[0] = ((aqm)object).y;
        object = aqm2;
        observableArray[1] = ((aqm)object).z;
        this.ethIpAddress.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String string = aqm2.b().toString();
            switch (aqm2.a()) {
                case b: {
                    return string + " (dhcp)";
                }
                case c: {
                    return string + " (static)";
                }
            }
            return string;
        }, (Observable[])observableArray));
        object = aqm2;
        this.ethNetmask.visibleProperty().bind((ObservableValue)((aqm)object).D.isNotEqualTo((Object)vj.a));
        object = aqm2;
        this.ethNetmask.textProperty().bind((ObservableValue)((aqm)object).D.asString());
        object = aqm2;
        this.ethGateway.visibleProperty().bind((ObservableValue)((aqm)object).A.isNotEqualTo((Object)vj.a));
        object = aqm2;
        this.ethGateway.textProperty().bind((ObservableValue)((aqm)object).A.asString());
        BooleanBinding booleanBinding = this.selector.selectionMultiple().not();
        BooleanBinding booleanBinding2 = this.oAuth2Service.N.not();
        object = apx2;
        BooleanBinding booleanBinding3 = ((apx)object).t.isNotEqualTo((Object)afq.b);
        object = apx2;
        BooleanBinding booleanBinding4 = ((apx)object).t.isNotEqualTo((Object)afq.c);
        ayo.a((ObservableBooleanValue)booleanBinding2.or((ObservableBooleanValue)booleanBinding3.and((ObservableBooleanValue)booleanBinding)), new Node[]{this.setBootloaderParametersButton});
        ayo.a((ObservableBooleanValue)booleanBinding2.or((ObservableBooleanValue)booleanBinding4.and((ObservableBooleanValue)booleanBinding)), new Node[]{this.setApplicationParametersButton});
    }

    @PostConstruct
    public void postConstruct() {
        this.lookupService.setFrequency(5.0);
        this.command = asy.b();
    }
}

