/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import com.jfoenix.controls.JFXSlider;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;
import us.hebi.gui.controls.DoubleConverter;
import us.hebi.gui.controls.TextUtil;

public class SliderUtil {
    public static void bindSliderRange(Slider slider, ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2, ReadOnlyDoubleProperty readOnlyDoubleProperty3, ReadOnlyDoubleProperty readOnlyDoubleProperty4, double d2) {
        DoubleBinding doubleBinding = SliderUtil.createDefaultableBinding(readOnlyDoubleProperty, readOnlyDoubleProperty3, -d2);
        DoubleBinding doubleBinding2 = SliderUtil.createDefaultableBinding(readOnlyDoubleProperty2, readOnlyDoubleProperty4, d2);
        SliderUtil.bindSliderRange(slider, doubleBinding, doubleBinding2);
    }

    public static void bindSliderRange(Slider slider, DoubleBinding doubleBinding, DoubleBinding doubleBinding2) {
        DoubleBinding doubleBinding3 = doubleBinding2.subtract((ObservableNumberValue)doubleBinding);
        int n2 = 3;
        int n3 = 4;
        int n4 = 1000;
        slider.maxProperty().bind((ObservableValue)doubleBinding2);
        slider.minProperty().bind((ObservableValue)doubleBinding);
        slider.blockIncrementProperty().bind((ObservableValue)doubleBinding3.divide(1000));
        slider.majorTickUnitProperty().bind((ObservableValue)doubleBinding3.divide(4));
        slider.setMinorTickCount(3);
    }

    private static DoubleBinding createDefaultableBinding(ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2, double d2) {
        if (!Double.isFinite(d2)) {
            throw new IllegalArgumentException("Default value must be finite");
        }
        return Bindings.createDoubleBinding(() -> {
            double d3 = readOnlyDoubleProperty.get();
            if (Double.isFinite(d3)) {
                return d3;
            }
            d3 = readOnlyDoubleProperty2.get();
            if (d3 == 0.0 || !Double.isFinite(d3)) {
                return d2;
            }
            return d3;
        }, (Observable[])new Observable[]{readOnlyDoubleProperty, readOnlyDoubleProperty2});
    }

    public static void setValueLabelFactory(JFXSlider jFXSlider2, DoubleConverter doubleConverter) {
        jFXSlider2.setValueFactory((Callback<JFXSlider, StringBinding>)((Callback)jFXSlider -> Bindings.createStringBinding(() -> String.format("%.1f", doubleConverter.scale(jFXSlider.getValue())), (Observable[])new Observable[]{jFXSlider.valueProperty()})));
    }

    public static void setupTargetButton(Slider slider, BooleanProperty booleanProperty, Button button, DoubleConverter doubleConverter, DoubleConverter doubleConverter2) {
        EventHandler eventHandler = actionEvent -> {
            double d2;
            String string = TextUtil.format4digitsWithoutZeros(doubleConverter2.scale(slider.getValue()));
            TextInputDialog textInputDialog = new TextInputDialog(string);
            textInputDialog.setTitle("Set Value");
            textInputDialog.setContentText(null);
            textInputDialog.setHeaderText(null);
            textInputDialog.initOwner(slider.getScene().getWindow());
            Optional optional = textInputDialog.showAndWait();
            if (optional.isPresent() && !Double.isNaN(d2 = TextUtil.parseDouble((String)optional.get()))) {
                double d3 = doubleConverter.scale(d2);
                if (Double.isNaN(d3)) {
                    return;
                }
                double d4 = Math.min(slider.getMax(), d3);
                double d5 = Math.max(slider.getMin(), d4);
                if (slider.valueProperty().isBound()) {
                    slider.valueProperty().unbind();
                }
                double d6 = 1.0E-4;
                slider.setValue(d5 + 1.0E-4);
                booleanProperty.set(true);
                slider.setValue(d5);
            }
        };
        button.setOnAction(eventHandler);
        button.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                eventHandler.handle(null);
            }
        });
    }
}

