/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    public static final String VERSION = "4.7.0";
    private static final Tracer TRACER = new Tracer();
    private Model.CommandSpec commandSpec;
    private final Interpreter interpreter;
    private final IFactory factory;
    private Object executionResult;
    private PrintWriter out;
    private PrintWriter err;
    private Help.ColorScheme colorScheme = Help.defaultColorScheme(Help.Ansi.AUTO);
    private IExitCodeExceptionMapper exitCodeExceptionMapper;
    private IExecutionStrategy executionStrategy = new RunLast();
    private IParameterExceptionHandler parameterExceptionHandler = new IParameterExceptionHandler(){

        public int handleParseException(ParameterException parameterException, String[] stringArray) {
            CommandLine commandLine = parameterException.getCommandLine();
            DefaultExceptionHandler.internalHandleParseException(parameterException, commandLine.getErr(), commandLine.getColorScheme());
            return CommandLine.mappedExitCode(parameterException, commandLine.getExitCodeExceptionMapper(), commandLine.getCommandSpec().exitCodeOnInvalidInput());
        }
    };
    private IExecutionExceptionHandler executionExceptionHandler = new IExecutionExceptionHandler(){

        public int handleExecutionException(Exception exception, CommandLine commandLine, ParseResult parseResult) throws Exception {
            throw exception;
        }
    };

    public CommandLine(Object object) {
        this(object, new DefaultFactory());
    }

    public CommandLine(Object object, IFactory iFactory) {
        this(object, iFactory, true);
    }

    private CommandLine(Object object, IFactory iFactory, boolean bl2) {
        this.factory = Assert.notNull(iFactory, "factory");
        this.interpreter = new Interpreter();
        this.commandSpec = Model.CommandSpec.forAnnotatedObject(object, iFactory);
        this.commandSpec.commandLine(this);
        if (bl2) {
            this.applyModelTransformations();
        }
        this.commandSpec.validate();
        if (this.commandSpec.unmatchedArgsBindings().size() > 0) {
            this.setUnmatchedArgumentsAllowed(true);
        }
    }

    private void applyModelTransformations() {
        if (this.commandSpec.modelTransformer != null) {
            this.commandSpec = this.commandSpec.modelTransformer.transform(this.commandSpec);
        }
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.applyModelTransformations();
        }
    }

    private CommandLine copy() {
        CommandLine commandLine = new CommandLine(this.commandSpec.copy(), this.factory);
        commandLine.err = this.err;
        commandLine.out = this.out;
        commandLine.colorScheme = this.colorScheme;
        commandLine.executionStrategy = this.executionStrategy;
        commandLine.exitCodeExceptionMapper = this.exitCodeExceptionMapper;
        commandLine.executionExceptionHandler = this.executionExceptionHandler;
        commandLine.parameterExceptionHandler = this.parameterExceptionHandler;
        commandLine.interpreter.converterRegistry.clear();
        commandLine.interpreter.converterRegistry.putAll(this.interpreter.converterRegistry);
        return commandLine;
    }

    public Model.CommandSpec getCommandSpec() {
        return this.commandSpec;
    }

    public CommandLine addMixin(String string, Object object) {
        this.getCommandSpec().addMixin(string, Model.CommandSpec.forAnnotatedObject(object, this.factory));
        return this;
    }

    public Map<String, Object> getMixins() {
        Map<String, Model.CommandSpec> map = this.getCommandSpec().mixins();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (String string : map.keySet()) {
            linkedHashMap.put(string, map.get(string).userObject.getInstance());
        }
        return linkedHashMap;
    }

    public CommandLine addSubcommand(Object object) {
        return this.addSubcommand(null, object, new String[0]);
    }

    public CommandLine addSubcommand(String string, Object object) {
        return this.addSubcommand(string, object, new String[0]);
    }

    public CommandLine addSubcommand(String string, Object object, String ... stringArray) {
        CommandLine commandLine = CommandLine.toCommandLine(object, this.factory);
        commandLine.getCommandSpec().aliases.addAll(Arrays.asList(stringArray));
        this.getCommandSpec().addSubcommand(string, commandLine);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new Model.CaseAwareLinkedMap<String, CommandLine>(this.getCommandSpec().commands);
    }

    public CommandLine getParent() {
        Model.CommandSpec commandSpec = this.getCommandSpec().parent();
        return commandSpec == null ? null : commandSpec.commandLine();
    }

    public <T> T getCommand() {
        return (T)this.getCommandSpec().userObject();
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public boolean isUsageHelpRequested() {
        return this.interpreter.parseResultBuilder != null && this.interpreter.parseResultBuilder.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.interpreter.parseResultBuilder != null && this.interpreter.parseResultBuilder.versionHelpRequested;
    }

    public Help getHelp() {
        return this.getHelpFactory().create(this.getCommandSpec(), this.getColorScheme());
    }

    public IHelpFactory getHelpFactory() {
        return this.getCommandSpec().usageMessage().helpFactory();
    }

    public CommandLine setHelpFactory(IHelpFactory iHelpFactory) {
        this.getCommandSpec().usageMessage().helpFactory(iHelpFactory);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpFactory(iHelpFactory);
        }
        return this;
    }

    public List<String> getHelpSectionKeys() {
        return this.getCommandSpec().usageMessage().sectionKeys();
    }

    public CommandLine setHelpSectionKeys(List<String> list) {
        this.getCommandSpec().usageMessage().sectionKeys(list);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpSectionKeys(list);
        }
        return this;
    }

    public Map<String, IHelpSectionRenderer> getHelpSectionMap() {
        return this.getCommandSpec().usageMessage().sectionMap();
    }

    public CommandLine setHelpSectionMap(Map<String, IHelpSectionRenderer> map) {
        this.getCommandSpec().usageMessage().sectionMap(map);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setHelpSectionMap(map);
        }
        return this;
    }

    public boolean isAdjustLineBreaksForWideCJKCharacters() {
        return this.getCommandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters();
    }

    public CommandLine setAdjustLineBreaksForWideCJKCharacters(boolean bl2) {
        this.getCommandSpec().usageMessage().adjustLineBreaksForWideCJKCharacters(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAdjustLineBreaksForWideCJKCharacters(bl2);
        }
        return this;
    }

    public boolean isToggleBooleanFlags() {
        return this.getCommandSpec().parser().toggleBooleanFlags();
    }

    public CommandLine setToggleBooleanFlags(boolean bl2) {
        this.getCommandSpec().parser().toggleBooleanFlags(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setToggleBooleanFlags(bl2);
        }
        return this;
    }

    public boolean isInterpolateVariables() {
        return this.getCommandSpec().interpolateVariables();
    }

    public CommandLine setInterpolateVariables(boolean bl2) {
        this.getCommandSpec().interpolateVariables(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setInterpolateVariables(bl2);
        }
        return this;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.getCommandSpec().parser().overwrittenOptionsAllowed();
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean bl2) {
        this.getCommandSpec().parser().overwrittenOptionsAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setOverwrittenOptionsAllowed(bl2);
        }
        return this;
    }

    public boolean isPosixClusteredShortOptionsAllowed() {
        return this.getCommandSpec().parser().posixClusteredShortOptionsAllowed();
    }

    public CommandLine setPosixClusteredShortOptionsAllowed(boolean bl2) {
        this.getCommandSpec().parser().posixClusteredShortOptionsAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setPosixClusteredShortOptionsAllowed(bl2);
        }
        return this;
    }

    public boolean isCaseInsensitiveEnumValuesAllowed() {
        return this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed();
    }

    public CommandLine setCaseInsensitiveEnumValuesAllowed(boolean bl2) {
        this.getCommandSpec().parser().caseInsensitiveEnumValuesAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setCaseInsensitiveEnumValuesAllowed(bl2);
        }
        return this;
    }

    public boolean isTrimQuotes() {
        return this.getCommandSpec().parser().trimQuotes();
    }

    public CommandLine setTrimQuotes(boolean bl2) {
        this.getCommandSpec().parser().trimQuotes(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setTrimQuotes(bl2);
        }
        return this;
    }

    @Deprecated
    public boolean isSplitQuotedStrings() {
        return this.getCommandSpec().parser().splitQuotedStrings();
    }

    @Deprecated
    public CommandLine setSplitQuotedStrings(boolean bl2) {
        this.getCommandSpec().parser().splitQuotedStrings(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSplitQuotedStrings(bl2);
        }
        return this;
    }

    public String getEndOfOptionsDelimiter() {
        return this.getCommandSpec().parser().endOfOptionsDelimiter();
    }

    public CommandLine setEndOfOptionsDelimiter(String string) {
        this.getCommandSpec().parser().endOfOptionsDelimiter(string);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setEndOfOptionsDelimiter(string);
        }
        return this;
    }

    public boolean isSubcommandsCaseInsensitive() {
        return this.getCommandSpec().subcommandsCaseInsensitive();
    }

    public CommandLine setSubcommandsCaseInsensitive(boolean bl2) {
        this.getCommandSpec().subcommandsCaseInsensitive(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSubcommandsCaseInsensitive(bl2);
        }
        return this;
    }

    public boolean isOptionsCaseInsensitive() {
        return this.getCommandSpec().optionsCaseInsensitive();
    }

    public CommandLine setOptionsCaseInsensitive(boolean bl2) {
        this.getCommandSpec().optionsCaseInsensitive(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setOptionsCaseInsensitive(bl2);
        }
        return this;
    }

    public boolean isAbbreviatedSubcommandsAllowed() {
        return this.getCommandSpec().parser().abbreviatedSubcommandsAllowed();
    }

    public CommandLine setAbbreviatedSubcommandsAllowed(boolean bl2) {
        this.getCommandSpec().parser().abbreviatedSubcommandsAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAbbreviatedSubcommandsAllowed(bl2);
        }
        return this;
    }

    public boolean isAbbreviatedOptionsAllowed() {
        return this.getCommandSpec().parser().abbreviatedOptionsAllowed();
    }

    public CommandLine setAbbreviatedOptionsAllowed(boolean bl2) {
        this.getCommandSpec().parser().abbreviatedOptionsAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAbbreviatedOptionsAllowed(bl2);
        }
        return this;
    }

    public IDefaultValueProvider getDefaultValueProvider() {
        return this.getCommandSpec().defaultValueProvider();
    }

    public CommandLine setDefaultValueProvider(IDefaultValueProvider iDefaultValueProvider) {
        this.getCommandSpec().defaultValueProvider(iDefaultValueProvider);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setDefaultValueProvider(iDefaultValueProvider);
        }
        return this;
    }

    public boolean isStopAtPositional() {
        return this.getCommandSpec().parser().stopAtPositional();
    }

    public CommandLine setStopAtPositional(boolean bl2) {
        this.getCommandSpec().parser().stopAtPositional(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setStopAtPositional(bl2);
        }
        return this;
    }

    public boolean isStopAtUnmatched() {
        return this.getCommandSpec().parser().stopAtUnmatched();
    }

    public CommandLine setStopAtUnmatched(boolean bl2) {
        this.getCommandSpec().parser().stopAtUnmatched(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setStopAtUnmatched(bl2);
        }
        if (bl2) {
            this.setUnmatchedArgumentsAllowed(true);
        }
        return this;
    }

    public boolean isAllowSubcommandsAsOptionParameters() {
        return this.getCommandSpec().parser().allowSubcommandsAsOptionParameters();
    }

    public CommandLine setAllowSubcommandsAsOptionParameters(boolean bl2) {
        this.getCommandSpec().parser().allowSubcommandsAsOptionParameters(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAllowSubcommandsAsOptionParameters(bl2);
        }
        return this;
    }

    public boolean isAllowOptionsAsOptionParameters() {
        return this.getCommandSpec().parser().allowOptionsAsOptionParameters();
    }

    public CommandLine setAllowOptionsAsOptionParameters(boolean bl2) {
        this.getCommandSpec().parser().allowOptionsAsOptionParameters(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAllowOptionsAsOptionParameters(bl2);
        }
        return this;
    }

    public boolean isUnmatchedOptionsAllowedAsOptionParameters() {
        return this.getCommandSpec().parser().unmatchedOptionsAllowedAsOptionParameters();
    }

    public CommandLine setUnmatchedOptionsAllowedAsOptionParameters(boolean bl2) {
        this.getCommandSpec().parser().unmatchedOptionsAllowedAsOptionParameters(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedOptionsAllowedAsOptionParameters(bl2);
        }
        return this;
    }

    public boolean isUnmatchedOptionsArePositionalParams() {
        return this.getCommandSpec().parser().unmatchedOptionsArePositionalParams();
    }

    public CommandLine setUnmatchedOptionsArePositionalParams(boolean bl2) {
        this.getCommandSpec().parser().unmatchedOptionsArePositionalParams(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedOptionsArePositionalParams(bl2);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.getCommandSpec().parser().unmatchedArgumentsAllowed();
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean bl2) {
        this.getCommandSpec().parser().unmatchedArgumentsAllowed(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUnmatchedArgumentsAllowed(bl2);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.interpreter.parseResultBuilder == null ? Collections.emptyList() : UnmatchedArgumentException.stripErrorMessage(this.interpreter.parseResultBuilder.unmatched);
    }

    private static int mappedExitCode(Throwable throwable, IExitCodeExceptionMapper iExitCodeExceptionMapper, int n2) {
        try {
            return iExitCodeExceptionMapper != null ? iExitCodeExceptionMapper.getExitCode(throwable) : n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n2;
        }
    }

    public Help.ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public CommandLine setColorScheme(Help.ColorScheme colorScheme) {
        this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setColorScheme(colorScheme);
        }
        return this;
    }

    public PrintWriter getOut() {
        if (this.out == null) {
            this.setOut(CommandLine.newPrintWriter(System.out, CommandLine.getStdoutEncoding()));
        }
        return this.out;
    }

    public CommandLine setOut(PrintWriter printWriter) {
        this.out = Assert.notNull(printWriter, "out");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setOut(printWriter);
        }
        return this;
    }

    public PrintWriter getErr() {
        if (this.err == null) {
            this.setErr(CommandLine.newPrintWriter(System.err, CommandLine.getStderrEncoding()));
        }
        return this.err;
    }

    public CommandLine setErr(PrintWriter printWriter) {
        this.err = Assert.notNull(printWriter, "err");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setErr(printWriter);
        }
        return this;
    }

    public IExitCodeExceptionMapper getExitCodeExceptionMapper() {
        return this.exitCodeExceptionMapper;
    }

    public CommandLine setExitCodeExceptionMapper(IExitCodeExceptionMapper iExitCodeExceptionMapper) {
        this.exitCodeExceptionMapper = Assert.notNull(iExitCodeExceptionMapper, "exitCodeExceptionMapper");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExitCodeExceptionMapper(iExitCodeExceptionMapper);
        }
        return this;
    }

    public IExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    public CommandLine setExecutionStrategy(IExecutionStrategy iExecutionStrategy) {
        this.executionStrategy = Assert.notNull(iExecutionStrategy, "executionStrategy");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExecutionStrategy(iExecutionStrategy);
        }
        return this;
    }

    public IParameterExceptionHandler getParameterExceptionHandler() {
        return this.parameterExceptionHandler;
    }

    public CommandLine setParameterExceptionHandler(IParameterExceptionHandler iParameterExceptionHandler) {
        this.parameterExceptionHandler = Assert.notNull(iParameterExceptionHandler, "parameterExceptionHandler");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setParameterExceptionHandler(iParameterExceptionHandler);
        }
        return this;
    }

    public IExecutionExceptionHandler getExecutionExceptionHandler() {
        return this.executionExceptionHandler;
    }

    public CommandLine setExecutionExceptionHandler(IExecutionExceptionHandler iExecutionExceptionHandler) {
        this.executionExceptionHandler = Assert.notNull(iExecutionExceptionHandler, "executionExceptionHandler");
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.setExecutionExceptionHandler(iExecutionExceptionHandler);
        }
        return this;
    }

    public static <T> T populateCommand(T t2, String ... stringArray) {
        CommandLine commandLine = CommandLine.toCommandLine(t2, new DefaultFactory());
        commandLine.parse(stringArray);
        return t2;
    }

    public static <T> T populateSpec(Class<T> clazz, String ... stringArray) {
        CommandLine commandLine = CommandLine.toCommandLine(clazz, new DefaultFactory());
        commandLine.parse(stringArray);
        return commandLine.getCommand();
    }

    @Deprecated
    public List<CommandLine> parse(String ... stringArray) {
        return this.interpreter.parse(stringArray);
    }

    public ParseResult parseArgs(String ... stringArray) {
        this.interpreter.parse(stringArray);
        return this.getParseResult();
    }

    public ParseResult getParseResult() {
        return this.interpreter.parseResultBuilder == null ? null : this.interpreter.parseResultBuilder.build();
    }

    public <T> T getExecutionResult() {
        return (T)this.executionResult;
    }

    public void setExecutionResult(Object object) {
        this.executionResult = object;
    }

    public void clearExecutionResults() {
        this.executionResult = null;
        for (CommandLine commandLine : this.getSubcommands().values()) {
            commandLine.clearExecutionResults();
        }
    }

    public static DefaultExceptionHandler<List<Object>> defaultExceptionHandler() {
        return new DefaultExceptionHandler<List<Object>>();
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(list, printStream, printStream, ansi);
    }

    public static boolean printHelpIfRequested(ParseResult parseResult) {
        return CommandLine.executeHelpRequest(parseResult) != null;
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> list, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(list, printStream, printStream2, Help.defaultColorScheme(ansi));
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> list, PrintStream printStream, PrintStream printStream2, Help.ColorScheme colorScheme) {
        for (CommandLine commandLine : list) {
            commandLine.setOut(CommandLine.newPrintWriter(printStream, CommandLine.getStdoutEncoding())).setErr(CommandLine.newPrintWriter(printStream2, CommandLine.getStderrEncoding())).setColorScheme(colorScheme);
        }
        return CommandLine.executeHelpRequest(list) != null;
    }

    public static Integer executeHelpRequest(ParseResult parseResult) {
        return CommandLine.executeHelpRequest(parseResult.asCommandLineList());
    }

    static Integer executeHelpRequest(List<CommandLine> list) {
        Tracer tracer = CommandLine.tracer();
        for (CommandLine commandLine : list) {
            Help.ColorScheme colorScheme = commandLine.getColorScheme();
            PrintWriter printWriter = commandLine.getOut();
            if (commandLine.isUsageHelpRequested()) {
                tracer.debug("Printing usage help for '%s' as requested.", commandLine.commandSpec.qualifiedName());
                commandLine.usage(printWriter, colorScheme);
                return commandLine.getCommandSpec().exitCodeOnUsageHelp();
            }
            if (commandLine.isVersionHelpRequested()) {
                tracer.debug("Printing version info for '%s' as requested.", commandLine.commandSpec.qualifiedName());
                commandLine.printVersionHelp(printWriter, colorScheme.ansi, new Object[0]);
                return commandLine.getCommandSpec().exitCodeOnVersionHelp();
            }
            if (!commandLine.getCommandSpec().helpCommand()) continue;
            String string = commandLine.commandSpec.qualifiedName();
            PrintWriter printWriter2 = commandLine.getErr();
            if (commandLine.getCommand() instanceof IHelpCommandInitializable2) {
                tracer.debug("Initializing helpCommand '%s' (IHelpCommandInitializable2::init)...", string);
                ((IHelpCommandInitializable2)commandLine.getCommand()).init(commandLine, colorScheme, printWriter, printWriter2);
            } else if (commandLine.getCommand() instanceof IHelpCommandInitializable) {
                tracer.debug("Initializing helpCommand '%s' (IHelpCommandInitializable::init)...", string);
                ((IHelpCommandInitializable)commandLine.getCommand()).init(commandLine, colorScheme.ansi, System.out, System.err);
            } else {
                tracer.debug("helpCommand '%s' does not implement IHelpCommandInitializable2 or IHelpCommandInitializable...", string);
            }
            tracer.debug("Executing helpCommand '%s'...", string);
            CommandLine.executeUserObject(commandLine, new ArrayList<Object>());
            return commandLine.getCommandSpec().exitCodeOnUsageHelp();
        }
        tracer.debug("Help was not requested. Continuing to process ParseResult...", new Object[0]);
        return null;
    }

    private static List<Object> executeUserObject(CommandLine commandLine, List<Object> list) {
        Tracer tracer = CommandLine.tracer();
        Object t2 = commandLine.getCommand();
        if (t2 instanceof Runnable) {
            try {
                tracer.debug("Invoking Runnable::run on user object %s@%s...", t2.getClass().getName(), Integer.toHexString(t2.hashCode()));
                ((Runnable)t2).run();
                commandLine.setExecutionResult(null);
                list.add(null);
                return list;
            }
            catch (ParameterException parameterException) {
                throw parameterException;
            }
            catch (ExecutionException executionException) {
                throw executionException;
            }
            catch (Exception exception) {
                throw new ExecutionException(commandLine, "Error while running command (" + t2 + "): " + exception, exception);
            }
        }
        if (t2 instanceof Callable) {
            try {
                tracer.debug("Invoking Callable::call on user object %s@%s...", t2.getClass().getName(), Integer.toHexString(t2.hashCode()));
                Callable callable = (Callable)t2;
                Object v2 = callable.call();
                commandLine.setExecutionResult(v2);
                list.add(v2);
                return list;
            }
            catch (ParameterException parameterException) {
                throw parameterException;
            }
            catch (ExecutionException executionException) {
                throw executionException;
            }
            catch (Exception exception) {
                throw new ExecutionException(commandLine, "Error while calling command (" + t2 + "): " + exception, exception);
            }
        }
        if (t2 instanceof Method) {
            try {
                Object object;
                Method method = (Method)t2;
                Object[] objectArray = commandLine.getCommandSpec().commandMethodParamValues();
                if (Modifier.isStatic(method.getModifiers())) {
                    tracer.debug("Invoking static method %s with parameters %s", method, Arrays.toString(objectArray));
                    object = method.invoke(null, objectArray);
                } else {
                    Object object2 = commandLine.getCommandSpec().parent() != null ? commandLine.getCommandSpec().parent().userObject() : commandLine.factory.create(method.getDeclaringClass());
                    tracer.debug("Invoking method %s on %s@%s with parameters %s", method, object2.getClass().getName(), Integer.toHexString(object2.hashCode()), Arrays.toString(objectArray));
                    object = method.invoke(object2, objectArray);
                }
                commandLine.setExecutionResult(object);
                list.add(object);
                return list;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ParameterException) {
                    throw (ParameterException)throwable;
                }
                if (throwable instanceof ExecutionException) {
                    throw (ExecutionException)throwable;
                }
                throw new ExecutionException(commandLine, "Error while calling command (" + t2 + "): " + throwable, throwable);
            }
            catch (Exception exception) {
                throw new ExecutionException(commandLine, "Unhandled error while calling command (" + t2 + "): " + exception, exception);
            }
        }
        if (commandLine.getSubcommands().isEmpty()) {
            throw new ExecutionException(commandLine, "Parsed command (" + t2 + ") is not a Method, Runnable or Callable");
        }
        throw new ParameterException(commandLine, "Missing required subcommand");
    }

    public int execute(String ... stringArray) {
        ParseResult[] parseResultArray = new ParseResult[1];
        this.clearExecutionResults();
        try {
            parseResultArray[0] = this.parseArgs(stringArray);
            return this.enrichForBackwardsCompatibility(this.getExecutionStrategy()).execute(parseResultArray[0]);
        }
        catch (ParameterException parameterException) {
            try {
                return this.getParameterExceptionHandler().handleParseException(parameterException, stringArray);
            }
            catch (Exception exception) {
                return CommandLine.handleUnhandled(exception, parameterException.getCommandLine(), parameterException.getCommandLine().getCommandSpec().exitCodeOnInvalidInput());
            }
        }
        catch (ExecutionException executionException) {
            try {
                ExecutionException executionException2 = executionException.getCause() instanceof Exception ? (Exception)executionException.getCause() : executionException;
                return this.getExecutionExceptionHandler().handleExecutionException(executionException2, executionException.getCommandLine(), parseResultArray[0]);
            }
            catch (Exception exception) {
                return CommandLine.handleUnhandled(exception, executionException.getCommandLine(), executionException.getCommandLine().getCommandSpec().exitCodeOnExecutionException());
            }
        }
        catch (Exception exception) {
            return CommandLine.handleUnhandled(exception, this, this.getCommandSpec().exitCodeOnExecutionException());
        }
    }

    private static int handleUnhandled(Exception exception, CommandLine commandLine, int n2) {
        commandLine.getErr().print(CommandLine.throwableToColorString(exception, commandLine.getColorScheme()));
        commandLine.getErr().flush();
        return CommandLine.mappedExitCode(exception, commandLine.getExitCodeExceptionMapper(), n2);
    }

    private static String throwableToColorString(Throwable throwable, Help.ColorScheme colorScheme) {
        Help.ColorScheme colorScheme2 = new Help.ColorScheme.Builder(colorScheme).applySystemProperties().build();
        ColoredStackTraceWriter coloredStackTraceWriter = new ColoredStackTraceWriter(colorScheme2);
        throwable.printStackTrace(new PrintWriter(coloredStackTraceWriter));
        return coloredStackTraceWriter.toString();
    }

    private <T> T enrichForBackwardsCompatibility(T t2) {
        if (t2 instanceof AbstractHandler) {
            AbstractHandler abstractHandler = (AbstractHandler)t2;
            if (abstractHandler.out() != System.out) {
                this.setOut(CommandLine.newPrintWriter(abstractHandler.out(), CommandLine.getStdoutEncoding()));
            }
            if (abstractHandler.err() != System.err) {
                this.setErr(CommandLine.newPrintWriter(abstractHandler.err(), CommandLine.getStderrEncoding()));
            }
            if (abstractHandler.ansi() != Help.Ansi.AUTO) {
                this.setColorScheme(abstractHandler.colorScheme());
            }
        }
        return t2;
    }

    @Deprecated
    public List<Object> parseWithHandler(IParseResultHandler iParseResultHandler, PrintStream printStream, String ... stringArray) {
        return this.parseWithHandlers(iParseResultHandler, printStream, Help.Ansi.AUTO, CommandLine.defaultExceptionHandler(), stringArray);
    }

    @Deprecated
    public <R> R parseWithHandler(IParseResultHandler2<R> iParseResultHandler2, String[] stringArray) {
        return this.parseWithHandlers(iParseResultHandler2, new DefaultExceptionHandler(), stringArray);
    }

    @Deprecated
    public List<Object> parseWithHandlers(IParseResultHandler iParseResultHandler, PrintStream printStream, Help.Ansi ansi, IExceptionHandler iExceptionHandler, String ... stringArray) {
        this.clearExecutionResults();
        try {
            List<CommandLine> list = this.parse(stringArray);
            return iParseResultHandler.handleParseResult(list, printStream, ansi);
        }
        catch (ParameterException parameterException) {
            return iExceptionHandler.handleException(parameterException, printStream, ansi, stringArray);
        }
    }

    @Deprecated
    public <R> R parseWithHandlers(IParseResultHandler2<R> iParseResultHandler2, IExceptionHandler2<R> iExceptionHandler2, String ... stringArray) {
        this.clearExecutionResults();
        ParseResult parseResult = null;
        try {
            parseResult = this.parseArgs(stringArray);
            return iParseResultHandler2.handleParseResult(parseResult);
        }
        catch (ParameterException parameterException) {
            return iExceptionHandler2.handleParseException(parameterException, stringArray);
        }
        catch (ExecutionException executionException) {
            return iExceptionHandler2.handleExecutionException(executionException, parseResult);
        }
    }

    static String versionString() {
        return String.format("%s, JVM: %s (%s %s %s), OS: %s %s %s", VERSION, System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static void usage(Object object, PrintStream printStream) {
        CommandLine.toCommandLine(object, new DefaultFactory()).usage(printStream);
    }

    public static void usage(Object object, PrintStream printStream, Help.Ansi ansi) {
        CommandLine.toCommandLine(object, new DefaultFactory()).usage(printStream, ansi);
    }

    public static void usage(Object object, PrintStream printStream, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(object, new DefaultFactory()).usage(printStream, colorScheme);
    }

    public void usage(PrintStream printStream) {
        this.usage(printStream, this.getColorScheme());
    }

    public void usage(PrintWriter printWriter) {
        this.usage(printWriter, this.getColorScheme());
    }

    public void usage(PrintStream printStream, Help.Ansi ansi) {
        this.usage(printStream, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintWriter printWriter, Help.Ansi ansi) {
        this.usage(printWriter, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream printStream, Help.ColorScheme colorScheme) {
        printStream.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
        printStream.flush();
    }

    public void usage(PrintWriter printWriter, Help.ColorScheme colorScheme) {
        printWriter.print(this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)));
        printWriter.flush();
    }

    public String getUsageMessage() {
        return this.usage(new StringBuilder(), this.getHelp()).toString();
    }

    public String getUsageMessage(Help.Ansi ansi) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), Help.defaultColorScheme(ansi))).toString();
    }

    public String getUsageMessage(Help.ColorScheme colorScheme) {
        return this.usage(new StringBuilder(), this.getHelpFactory().create(this.getCommandSpec(), colorScheme)).toString();
    }

    private StringBuilder usage(StringBuilder stringBuilder, Help help) {
        for (String string : this.getHelpSectionKeys()) {
            IHelpSectionRenderer iHelpSectionRenderer = this.getHelpSectionMap().get(string);
            if (iHelpSectionRenderer == null) continue;
            stringBuilder.append(iHelpSectionRenderer.render(help));
        }
        return stringBuilder;
    }

    public void printVersionHelp(PrintStream printStream) {
        this.printVersionHelp(printStream, this.getColorScheme().ansi());
    }

    public void printVersionHelp(PrintStream printStream, Help.Ansi ansi) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            printStream.println(ansi2.new Help.Ansi.Text(string, this.getColorScheme()));
        }
        printStream.flush();
    }

    public void printVersionHelp(PrintStream printStream, Help.Ansi ansi, Object ... objectArray) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            printStream.println(ansi2.new Help.Ansi.Text(CommandLine.format(string, objectArray), this.getColorScheme()));
        }
        printStream.flush();
    }

    public void printVersionHelp(PrintWriter printWriter) {
        this.printVersionHelp(printWriter, this.getColorScheme().ansi(), new Object[0]);
    }

    public void printVersionHelp(PrintWriter printWriter, Help.Ansi ansi, Object ... objectArray) {
        for (String string : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            printWriter.println(ansi2.new Help.Ansi.Text(CommandLine.format(string, objectArray), this.getColorScheme()));
        }
        printWriter.flush();
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C c2, String ... stringArray) {
        CommandLine commandLine = new CommandLine(c2);
        List<Object> list = commandLine.parseWithHandler(new RunLast(), stringArray);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C c2, PrintStream printStream, String ... stringArray) {
        return CommandLine.call(c2, printStream, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C c2, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        return CommandLine.call(c2, printStream, System.err, ansi, stringArray);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(C c2, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(c2);
        List list = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(printStream)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(printStream2)).useAnsi(ansi), stringArray);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> clazz, IFactory iFactory, String ... stringArray) {
        CommandLine commandLine = new CommandLine(clazz, iFactory);
        List<Object> list = commandLine.parseWithHandler(new RunLast(), stringArray);
        return CommandLine.firstElement(list);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> clazz, IFactory iFactory, PrintStream printStream, String ... stringArray) {
        return CommandLine.call(clazz, iFactory, printStream, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> clazz, IFactory iFactory, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        return CommandLine.call(clazz, iFactory, printStream, System.err, ansi, stringArray);
    }

    @Deprecated
    public static <C extends Callable<T>, T> T call(Class<C> clazz, IFactory iFactory, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(clazz, iFactory);
        List list = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(printStream)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(printStream2)).useAnsi(ansi), stringArray);
        return CommandLine.firstElement(list);
    }

    private static <T> T firstElement(List<Object> list) {
        return (T)(list == null || list.isEmpty() ? null : list.get(0));
    }

    @Deprecated
    public static <R extends Runnable> void run(R r2, String ... stringArray) {
        CommandLine.run(r2, System.out, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(R r2, PrintStream printStream, String ... stringArray) {
        CommandLine.run(r2, printStream, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(R r2, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        CommandLine.run(r2, printStream, System.err, ansi, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(R r2, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(r2);
        commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(printStream)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(printStream2)).useAnsi(ansi), stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> clazz, IFactory iFactory, String ... stringArray) {
        CommandLine.run(clazz, iFactory, System.out, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> clazz, IFactory iFactory, PrintStream printStream, String ... stringArray) {
        CommandLine.run(clazz, iFactory, printStream, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> clazz, IFactory iFactory, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        CommandLine.run(clazz, iFactory, printStream, System.err, ansi, stringArray);
    }

    @Deprecated
    public static <R extends Runnable> void run(Class<R> clazz, IFactory iFactory, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(clazz, iFactory);
        commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(printStream)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(printStream2)).useAnsi(ansi), stringArray);
    }

    @Deprecated
    public static Object invoke(String string, Class<?> clazz, String ... stringArray) {
        return CommandLine.invoke(string, clazz, System.out, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static Object invoke(String string, Class<?> clazz, PrintStream printStream, String ... stringArray) {
        return CommandLine.invoke(string, clazz, printStream, System.err, Help.Ansi.AUTO, stringArray);
    }

    @Deprecated
    public static Object invoke(String string, Class<?> clazz, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        return CommandLine.invoke(string, clazz, printStream, System.err, ansi, stringArray);
    }

    @Deprecated
    public static Object invoke(String string, Class<?> clazz, PrintStream printStream, PrintStream printStream2, Help.Ansi ansi, String ... stringArray) {
        List<Method> list = CommandLine.getCommandMethods(clazz, string);
        if (list.size() != 1) {
            throw new InitializationException("Expected exactly one @Command-annotated method for " + clazz.getName() + "::" + string + "(...), but got: " + list);
        }
        Method method = list.get(0);
        CommandLine commandLine = new CommandLine(method);
        List list2 = (List)commandLine.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(printStream)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(printStream2)).useAnsi(ansi), stringArray);
        return list2 == null ? null : list2.get(0);
    }

    public static List<Method> getCommandMethods(Class<?> clazz, String string) {
        return CommandLine.getCommandMethods(clazz, string, true);
    }

    private static List<Method> getCommandMethods(Class<?> clazz, String string, boolean bl2) {
        HashSet<Method> hashSet = new HashSet<Method>();
        if (bl2) {
            hashSet.addAll(Arrays.asList(Assert.notNull(clazz, "class").getMethods()));
        }
        hashSet.addAll(Arrays.asList(Assert.notNull(clazz, "class").getDeclaredMethods()));
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : hashSet) {
            if (!method.isAnnotationPresent(Command.class) || string != null && !string.equals(method.getName())) continue;
            arrayList.add(method);
        }
        Collections.sort(arrayList, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return method.getName().compareTo(method2.getName());
            }
        });
        return arrayList;
    }

    public <K> CommandLine registerConverter(Class<K> clazz, ITypeConverter<K> iTypeConverter) {
        this.interpreter.converterRegistry.put(Assert.notNull(clazz, "class"), Assert.notNull(iTypeConverter, "converter"));
        for (CommandLine commandLine : this.getCommandSpec().commands.values()) {
            commandLine.registerConverter(clazz, iTypeConverter);
        }
        return this;
    }

    public String getSeparator() {
        return this.getCommandSpec().parser().separator();
    }

    public CommandLine setSeparator(String string) {
        this.getCommandSpec().parser().separator(Assert.notNull(string, "separator"));
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setSeparator(string);
        }
        return this;
    }

    public ResourceBundle getResourceBundle() {
        return this.getCommandSpec().resourceBundle();
    }

    public CommandLine setResourceBundle(ResourceBundle resourceBundle) {
        this.getCommandSpec().resourceBundle(resourceBundle);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setResourceBundle(resourceBundle);
        }
        return this;
    }

    public int getUsageHelpWidth() {
        return this.getCommandSpec().usageMessage().width();
    }

    public CommandLine setUsageHelpWidth(int n2) {
        this.getCommandSpec().usageMessage().width(n2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpWidth(n2);
        }
        return this;
    }

    public int getUsageHelpLongOptionsMaxWidth() {
        return this.getCommandSpec().usageMessage().longOptionsMaxWidth();
    }

    public CommandLine setUsageHelpLongOptionsMaxWidth(int n2) {
        this.getCommandSpec().usageMessage().longOptionsMaxWidth(n2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpLongOptionsMaxWidth(n2);
        }
        return this;
    }

    public boolean isUsageHelpAutoWidth() {
        return this.getCommandSpec().usageMessage().autoWidth();
    }

    public CommandLine setUsageHelpAutoWidth(boolean bl2) {
        this.getCommandSpec().usageMessage().autoWidth(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUsageHelpAutoWidth(bl2);
        }
        return this;
    }

    public String getCommandName() {
        return this.getCommandSpec().name();
    }

    public CommandLine setCommandName(String string) {
        this.getCommandSpec().name(Assert.notNull(string, "commandName"));
        return this;
    }

    public boolean isExpandAtFiles() {
        return this.getCommandSpec().parser().expandAtFiles();
    }

    public CommandLine setExpandAtFiles(boolean bl2) {
        this.getCommandSpec().parser().expandAtFiles(bl2);
        return this;
    }

    public Character getAtFileCommentChar() {
        return this.getCommandSpec().parser().atFileCommentChar();
    }

    public CommandLine setAtFileCommentChar(Character c2) {
        this.getCommandSpec().parser().atFileCommentChar(c2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setAtFileCommentChar(c2);
        }
        return this;
    }

    public boolean isUseSimplifiedAtFiles() {
        return this.getCommandSpec().parser().useSimplifiedAtFiles();
    }

    public CommandLine setUseSimplifiedAtFiles(boolean bl2) {
        this.getCommandSpec().parser().useSimplifiedAtFiles(bl2);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setUseSimplifiedAtFiles(bl2);
        }
        return this;
    }

    public INegatableOptionTransformer getNegatableOptionTransformer() {
        return this.getCommandSpec().negatableOptionTransformer();
    }

    public CommandLine setNegatableOptionTransformer(INegatableOptionTransformer iNegatableOptionTransformer) {
        this.getCommandSpec().negatableOptionTransformer(iNegatableOptionTransformer);
        for (CommandLine commandLine : this.getCommandSpec().subcommands().values()) {
            commandLine.setNegatableOptionTransformer(iNegatableOptionTransformer);
        }
        return this;
    }

    private static boolean empty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static boolean empty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static String str(String[] stringArray, int n2) {
        return stringArray == null || stringArray.length <= n2 ? "" : stringArray[n2];
    }

    private static boolean isBoolean(Class<?>[] classArray) {
        return CommandLine.isBoolean(classArray[0]) || CommandLine.isOptional(classArray[0]) && CommandLine.isBoolean(classArray[1]);
    }

    private static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object object, IFactory iFactory) {
        return object instanceof CommandLine ? (CommandLine)object : new CommandLine(object, iFactory, false);
    }

    private static boolean isMultiValue(Class<?> clazz) {
        return clazz.isArray() && clazz != char[].class || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private static boolean isOptional(Class<?> clazz) {
        return clazz != null && "java.util.Optional".equals(clazz.getName());
    }

    private static Object getOptionalEmpty() throws Exception {
        return Class.forName("java.util.Optional").getMethod("empty", new Class[0]).invoke(null, new Object[0]);
    }

    private static Object getOptionalOfNullable(Object object) throws Exception {
        return Class.forName("java.util.Optional").getMethod("ofNullable", Object.class).invoke(null, object);
    }

    private static String format(String string, Object ... objectArray) {
        try {
            return string == null ? "" : String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            CommandLine.tracer().warn("Could not format '%s' (Underlying error: %s). Using raw String: '%%n' format strings have not been replaced with newlines. Please ensure to escape '%%' characters with another '%%'.", string, illegalFormatException.getMessage());
            return string;
        }
    }

    private static Map<String, Object> mapOf(String string, Object object, Object ... objectArray) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(string, object);
        for (int i2 = 0; i2 < objectArray.length - 1; i2 += 2) {
            linkedHashMap.put(String.valueOf(objectArray[i2]), objectArray[i2 + 1]);
        }
        return linkedHashMap;
    }

    public static IFactory defaultFactory() {
        return new DefaultFactory();
    }

    private static void validatePositionalParameters(List<Model.PositionalParamSpec> list) {
        int n2 = 0;
        for (Model.PositionalParamSpec positionalParamSpec : list) {
            Range range = positionalParamSpec.index();
            if (range.min > n2 && !range.isRelative()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Model.PositionalParamSpec positionalParamSpec2 : list) {
                    arrayList.add(positionalParamSpec2.index().internalToString());
                }
                throw new ParameterIndexGapException("Command definition should have a positional parameter with index=" + n2 + ". Nearest positional parameter '" + positionalParamSpec.paramLabel() + "' has index=" + range + ". (Full list: " + arrayList + ")");
            }
            n2 = (n2 = Math.max(n2, range.max)) == Integer.MAX_VALUE ? n2 : n2 + 1;
        }
    }

    private static Stack<String> copy(Stack<String> stack) {
        return (Stack)stack.clone();
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    private static <T> List<T> reverseList(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    private static <T> T[] reverseArray(T[] TArray) {
        for (int i2 = 0; i2 < TArray.length / 2; ++i2) {
            T t2 = TArray[i2];
            TArray[i2] = TArray[TArray.length - i2 - 1];
            TArray[TArray.length - i2 - 1] = t2;
        }
        return TArray;
    }

    static <K, T> void addValueToListInMap(Map<K, List<T>> map, K k2, T t2) {
        List<T> list = map.get(k2);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(k2, list);
        }
        list.add(t2);
    }

    static <T> List<T> flatList(Collection<? extends Collection<T>> collection) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<T> collection2 : collection) {
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    private static String optionDescription(String string, Model.ArgSpec argSpec, int n2) {
        String string2;
        if (argSpec.isOption()) {
            string2 = string + "option '" + ((Model.OptionSpec)argSpec).longestName() + "'";
            if (n2 >= 0) {
                if (argSpec.arity().max > 1) {
                    string2 = string2 + " at index " + n2;
                }
                if (argSpec.arity().max > 0) {
                    string2 = string2 + " (" + argSpec.paramLabel() + ")";
                }
            }
        } else {
            string2 = string + "positional parameter at index " + ((Model.PositionalParamSpec)argSpec).index() + " (" + argSpec.paramLabel() + ")";
        }
        return string2;
    }

    private static String createMissingParameterMessage(Model.ArgSpec argSpec, Range range, List<Model.PositionalParamSpec> list, Stack<String> stack, int n2) {
        if (range.min == 1) {
            if (argSpec.isOption()) {
                return "Missing required parameter for " + CommandLine.optionDescription("", argSpec, 0);
            }
            String string = "";
            String string2 = ": ";
            String string3 = "";
            String string4 = " at index ";
            int n3 = 0;
            for (Model.PositionalParamSpec positionalParamSpec : list) {
                if (positionalParamSpec.arity().min <= 0) continue;
                string2 = string2 + string + "'" + positionalParamSpec.paramLabel() + "'";
                string3 = string3 + string + positionalParamSpec.index();
                string = ", ";
                ++n3;
            }
            Object object = "Missing required parameter";
            if (n3 > 1 || range.min - n2 > 1) {
                object = (String)object + "s";
            }
            if (n3 > 1) {
                string4 = " at indices ";
            }
            return System.getProperty("picocli.verbose.errors") != null ? (String)object + string2 + string4 + string3 : (String)object + string2;
        }
        if (stack.isEmpty()) {
            return CommandLine.optionDescription("", argSpec, 0) + " requires at least " + range.min + " values, but none were specified.";
        }
        return CommandLine.optionDescription("", argSpec, 0) + " requires at least " + range.min + " values, but only " + n2 + " were specified: " + CommandLine.reverse(stack);
    }

    String smartUnquoteIfEnabled(String string) {
        if (string == null || !this.commandSpec.parser().trimQuotes()) {
            return string;
        }
        return CommandLine.smartUnquote(string);
    }

    static String smartUnquote(String string) {
        int n2;
        String string2 = CommandLine.unquote(string);
        if (string2 == string) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length(); i2 += Character.charCount(n2)) {
            n2 = string2.codePointAt(i2);
            switch (n2) {
                case 92: {
                    ++n3;
                    break;
                }
                case 34: {
                    if (n3 == 0) {
                        return string;
                    }
                    n3 = 0;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if ((n3 & 1) != 0) continue;
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    private static String unquote(String string) {
        if (string == null) {
            return null;
        }
        return string.length() > 1 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            CommandLine.tracer().warn("Could not close " + closeable + ": " + exception.toString(), new Object[0]);
        }
    }

    static Charset getStdoutEncoding() {
        return CommandLine.charsetForName(System.getProperty("sun.stdout.encoding"));
    }

    static Charset getStderrEncoding() {
        return CommandLine.charsetForName(System.getProperty("sun.stderr.encoding"));
    }

    static Charset charsetForName(String string) {
        if (string != null) {
            if ("cp65001".equalsIgnoreCase(string)) {
                string = "UTF-8";
            }
            return Charset.forName(string);
        }
        return Charset.defaultCharset();
    }

    static PrintWriter newPrintWriter(OutputStream outputStream, Charset charset) {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, charset)), true);
    }

    public static Tracer tracer() {
        if (!CommandLine.TRACER.modified) {
            TRACER.level = TraceLevel.lookup(System.getProperty("picocli.trace"));
            TRACER.stream = System.err;
        }
        return TRACER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AbbreviationMatcher {
        AbbreviationMatcher() {
        }

        public static List<String> splitIntoChunks(String string, boolean bl2) {
            String string2;
            int n2;
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < string.length() && !Character.isLetterOrDigit(n3 = string.codePointAt(n2)); n2 += Character.charCount(n3)) {
                stringBuilder.appendCodePoint(n3);
            }
            if (stringBuilder.length() > 0) {
                arrayList.add(stringBuilder.toString());
            }
            for (int i2 = n2; i2 < string.length(); i2 += Character.charCount(n3)) {
                n3 = string.codePointAt(i2);
                if ((bl2 || !Character.isUpperCase(n3)) && 45 != n3) continue;
                String string3 = AbbreviationMatcher.makeCanonical(string.substring(n2, i2));
                if (string3.length() > 0) {
                    arrayList.add(string3);
                }
                n2 = i2;
            }
            if (n2 < string.length() && (string2 = AbbreviationMatcher.makeCanonical(string.substring(n2))).length() > 0) {
                arrayList.add(string2);
            }
            return arrayList;
        }

        private static String makeCanonical(String string) {
            if ("-".equals(string)) {
                return "";
            }
            if (string.startsWith("-") && string.length() > 1) {
                String string2 = String.valueOf(Character.toChars(Character.toUpperCase(string.codePointAt(1))));
                return string2 + string.substring(1 + string2.length());
            }
            return string;
        }

        public static <T> MatchResult<T> match(Map<String, T> map, String string, boolean bl2, CommandLine commandLine) {
            MatchResult<T> matchResult = new MatchResult<T>(string, map.get(string));
            if (matchResult.hasValue() || map.isEmpty()) {
                return matchResult;
            }
            List<String> list = AbbreviationMatcher.splitIntoChunks(string, bl2);
            LinkedHashMap<String, T> linkedHashMap = new LinkedHashMap<String, T>();
            for (Map.Entry<String, T> entry : map.entrySet()) {
                List<String> list2 = AbbreviationMatcher.splitIntoChunks(entry.getKey(), bl2);
                if (!AbbreviationMatcher.matchKeyChunks(list, list2, bl2)) continue;
                if (!matchResult.hasValue()) {
                    matchResult = new MatchResult<T>(entry.getKey(), entry.getValue());
                }
                linkedHashMap.put(entry.getKey(), entry.getValue());
            }
            if (!AbbreviationMatcher.isAllCandidatesSame(linkedHashMap.values())) {
                String string2 = linkedHashMap.keySet().toString();
                throw new ParameterException(commandLine, "Error: '" + string + "' is not unique: it matches '" + string2.substring(1, string2.length() - 1).replace(", ", "', '") + "'");
            }
            return matchResult;
        }

        private static boolean matchKeyChunks(List<String> list, List<String> list2, boolean bl2) {
            if (list.size() > list2.size()) {
                return false;
            }
            int n2 = 0;
            if (AbbreviationMatcher.isNonAlphabetic(list2.get(0))) {
                if (!list2.get(0).equals(list.get(0))) {
                    return false;
                }
                ++n2;
            }
            if (!AbbreviationMatcher.startsWith(list2.get(n2), list.get(n2), bl2)) {
                return false;
            }
            int n3 = ++n2;
            int n4 = n2;
            while (n3 < list.size()) {
                boolean bl3 = false;
                for (int i2 = n4; i2 < list2.size(); ++i2) {
                    bl3 = AbbreviationMatcher.startsWith(list2.get(i2), list.get(n3), bl2);
                    if (!bl3) continue;
                    n4 = i2 + 1;
                    break;
                }
                if (!bl3) break;
                ++n3;
                ++n2;
            }
            return n2 == list.size();
        }

        private static boolean startsWith(String string, String string2, boolean bl2) {
            if (string2.length() > string.length()) {
                return false;
            }
            String string3 = string.substring(0, string2.length());
            return bl2 ? string3.equalsIgnoreCase(string2) : string3.equals(string2);
        }

        private static boolean isNonAlphabetic(String string) {
            int n2;
            for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
                n2 = string.codePointAt(i2);
                if (!Character.isLetterOrDigit(n2)) continue;
                return false;
            }
            return true;
        }

        private static <T> boolean isAllCandidatesSame(Collection<T> collection) {
            if (collection.isEmpty()) {
                return true;
            }
            Iterator<T> iterator = collection.iterator();
            T t2 = iterator.next();
            while (iterator.hasNext()) {
                if (iterator.next() == t2) continue;
                return false;
            }
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MatchResult<V> {
            private final String fullName;
            private final V value;

            MatchResult(String string, V v2) {
                this.fullName = string;
                this.value = v2;
            }

            String getFullName() {
                return this.fullName;
            }

            boolean hasValue() {
                return this.value != null;
            }

            V getValue() {
                return this.value;
            }

            public boolean equals(Object object) {
                if (!(object instanceof MatchResult)) {
                    return false;
                }
                MatchResult matchResult = (MatchResult)object;
                return this.fullName.equals(matchResult.fullName) && (this.hasValue() ? this.value.equals(matchResult.value) : this.value == matchResult.value);
            }

            public int hashCode() {
                return this.fullName.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
            }
        }
    }

    public static class PropertiesDefaultProvider
    implements IDefaultValueProvider {
        private Properties properties;
        private File location;

        public PropertiesDefaultProvider() {
        }

        public PropertiesDefaultProvider(Properties properties) {
            this.properties = properties;
        }

        public PropertiesDefaultProvider(File file) {
            this(PropertiesDefaultProvider.createProperties(file, null));
            this.properties.remove("__picocli_internal_location");
            this.location = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Properties createProperties(File file, Model.CommandSpec commandSpec) {
            if (file == null) {
                throw new NullPointerException("file is null");
            }
            Tracer tracer = CommandLine.tracer();
            Properties properties = new Properties();
            if (file.exists() && file.canRead()) {
                FileInputStream fileInputStream = null;
                try {
                    String string = commandSpec == null ? "unknown command" : commandSpec.qualifiedName();
                    tracer.debug("Reading defaults from %s for %s", file.getAbsolutePath(), string);
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    properties.put("__picocli_internal_location", file);
                    CommandLine.close(fileInputStream);
                }
                catch (IOException iOException) {
                    tracer.warn("could not read defaults from %s: %s", file.getAbsolutePath(), iOException);
                }
                finally {
                    CommandLine.close(fileInputStream);
                }
            } else {
                tracer.warn("defaults configuration file %s does not exist or is not readable", file.getAbsolutePath());
            }
            return properties;
        }

        private static Properties loadProperties(Model.CommandSpec commandSpec) {
            if (commandSpec == null) {
                return null;
            }
            Properties properties = System.getProperties();
            for (String string : commandSpec.names()) {
                String string2 = properties.getProperty("picocli.defaults." + string + ".path");
                File file = new File(properties.getProperty("user.home"), "." + string + ".properties");
                File file2 = string2 == null ? file : new File(string2);
                if (!file2.canRead()) continue;
                return PropertiesDefaultProvider.createProperties(file2, commandSpec);
            }
            return PropertiesDefaultProvider.loadProperties(commandSpec.parent());
        }

        public String defaultValue(Model.ArgSpec argSpec) throws Exception {
            if (this.properties == null) {
                this.properties = PropertiesDefaultProvider.loadProperties(argSpec.command());
                File file = this.location = this.properties == null ? null : (File)this.properties.remove("__picocli_internal_location");
            }
            if (this.properties == null || this.properties.isEmpty()) {
                return null;
            }
            return argSpec.isOption() ? this.optionDefaultValue((Model.OptionSpec)argSpec) : this.positionalDefaultValue((Model.PositionalParamSpec)argSpec);
        }

        private String optionDefaultValue(Model.OptionSpec optionSpec) {
            String string = this.getValue(optionSpec.descriptionKey(), optionSpec.command());
            string = string != null ? string : this.getValue(PropertiesDefaultProvider.stripPrefix(optionSpec.longestName()), optionSpec.command());
            return string;
        }

        private static String stripPrefix(String string) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (!Character.isJavaIdentifierPart(string.charAt(i2))) continue;
                return string.substring(i2);
            }
            return string;
        }

        private String positionalDefaultValue(Model.PositionalParamSpec positionalParamSpec) {
            String string = this.getValue(positionalParamSpec.descriptionKey(), positionalParamSpec.command());
            string = string != null ? string : this.getValue(positionalParamSpec.paramLabel(), positionalParamSpec.command());
            return string;
        }

        private String getValue(String string, Model.CommandSpec commandSpec) {
            String string2 = null;
            if (commandSpec != null) {
                String string3 = commandSpec.qualifiedName(".");
                string2 = this.properties.getProperty(string3 + "." + string);
            }
            if (string2 != null) {
                return string2;
            }
            return string == null ? null : this.properties.getProperty(string);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.location + "]";
        }
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;
        private final Model.ArgSpec overwrittenArg;

        public OverwrittenOptionException(CommandLine commandLine, Model.ArgSpec argSpec, String string) {
            super(commandLine, string);
            this.overwrittenArg = argSpec;
        }

        public Model.ArgSpec getOverwritten() {
            return this.overwrittenArg;
        }
    }

    public static class MaxValuesExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        public MaxValuesExceededException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;
        private List<String> unmatched = Collections.emptyList();

        public UnmatchedArgumentException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }

        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> stack) {
            this(commandLine, new ArrayList<String>(CommandLine.reverse(stack)));
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> list) {
            this(commandLine, list, "");
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> list, String string) {
            this(commandLine, UnmatchedArgumentException.describe(Assert.notNull(list, "unmatched list"), commandLine) + ": " + UnmatchedArgumentException.quoteElements(list) + string);
            this.unmatched = new ArrayList<String>(list);
        }

        public static boolean printSuggestions(ParameterException parameterException, PrintStream printStream) {
            return parameterException instanceof UnmatchedArgumentException && ((UnmatchedArgumentException)parameterException).printSuggestions(printStream);
        }

        public static boolean printSuggestions(ParameterException parameterException, PrintWriter printWriter) {
            return parameterException instanceof UnmatchedArgumentException && ((UnmatchedArgumentException)parameterException).printSuggestions(printWriter);
        }

        public List<String> getUnmatched() {
            return UnmatchedArgumentException.stripErrorMessage(this.unmatched);
        }

        static List<String> stripErrorMessage(List<String> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (string == null) {
                    arrayList.add(null);
                    continue;
                }
                int n2 = string.indexOf(" (while processing option:");
                arrayList.add(n2 < 0 ? string : string.substring(0, n2));
            }
            return Collections.unmodifiableList(arrayList);
        }

        public boolean isUnknownOption() {
            return UnmatchedArgumentException.isUnknownOption(this.unmatched, this.getCommandLine());
        }

        public boolean printSuggestions(PrintStream printStream) {
            return this.printSuggestions(CommandLine.newPrintWriter(printStream, CommandLine.getStdoutEncoding()));
        }

        public boolean printSuggestions(PrintWriter printWriter) {
            List<String> list = this.getSuggestions();
            if (!list.isEmpty()) {
                printWriter.println(this.isUnknownOption() ? "Possible solutions: " + UnmatchedArgumentException.str(list) : "Did you mean: " + UnmatchedArgumentException.str(list).replace(", ", " or ") + "?");
                printWriter.flush();
            }
            return !list.isEmpty();
        }

        private static String str(List<String> list) {
            String string = list.toString();
            return string.substring(0, string.length() - 1).substring(1);
        }

        public List<String> getSuggestions() {
            if (this.unmatched.isEmpty()) {
                return Collections.emptyList();
            }
            String string = this.unmatched.get(0);
            String string2 = Model.CommandSpec.stripPrefix(string);
            Model.CommandSpec commandSpec = this.getCommandLine().getCommandSpec();
            if (commandSpec.resemblesOption(string)) {
                return commandSpec.findVisibleOptionNamesWithPrefix(string2.substring(0, Math.min(2, string2.length())));
            }
            if (!commandSpec.subcommands().isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry<String, CommandLine> entry : commandSpec.subcommands().entrySet()) {
                    if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
                    arrayList.add(entry.getKey());
                }
                List<String> list = CosineSimilarity.mostSimilar(string, arrayList);
                return list.subList(0, Math.min(3, list.size()));
            }
            return Collections.emptyList();
        }

        private static boolean isUnknownOption(List<String> list, CommandLine commandLine) {
            return list != null && !list.isEmpty() && commandLine.getCommandSpec().resemblesOption(list.get(0));
        }

        private static String describe(List<String> list, CommandLine commandLine) {
            String string;
            String string2 = string = list.size() == 1 ? "" : "s";
            if (UnmatchedArgumentException.isUnknownOption(list, commandLine)) {
                return "Unknown option" + string;
            }
            String string3 = list.size() == 1 ? " at" : " from";
            int n2 = commandLine.interpreter.parseResultBuilder == null ? 0 : commandLine.interpreter.parseResultBuilder.firstUnmatchedPosition;
            return "Unmatched argument" + string + string3 + " index " + n2;
        }

        static String quoteElements(List<String> list) {
            String string = "";
            String string2 = "";
            for (String string3 : list) {
                int n2;
                if (string.length() > 0) {
                    string = string + ", ";
                }
                if (string3 != null && (n2 = string3.indexOf(" (while processing option:")) >= 0) {
                    string2 = string3.substring(n2);
                    string3 = string3.substring(0, n2);
                }
                string = string + "'" + string3 + "'" + string2;
                string2 = "";
            }
            return string;
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String string) {
            super(string);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends DuplicateNameException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String string) {
            super(string);
        }

        private static DuplicateOptionAnnotationsException create(String string, Model.ArgSpec argSpec, Model.ArgSpec argSpec2) {
            return new DuplicateOptionAnnotationsException("Option name '" + string + "' is used by both " + argSpec.toString() + " and " + argSpec2.toString());
        }
    }

    public static class DuplicateNameException
    extends InitializationException {
        private static final long serialVersionUID = -4126747467955626054L;

        public DuplicateNameException(String string) {
            super(string);
        }
    }

    public static class MutuallyExclusiveArgsException
    extends ParameterException {
        private static final long serialVersionUID = -5557715106221420986L;

        public MutuallyExclusiveArgsException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;
        private final List<Model.ArgSpec> missing;

        public MissingParameterException(CommandLine commandLine, Model.ArgSpec argSpec, String string) {
            this(commandLine, Collections.singletonList(argSpec), string);
        }

        public MissingParameterException(CommandLine commandLine, Collection<Model.ArgSpec> collection, String string) {
            super(commandLine, string);
            this.missing = Collections.unmodifiableList(new ArrayList<Model.ArgSpec>(collection));
        }

        public List<Model.ArgSpec> getMissing() {
            return this.missing;
        }

        private static MissingParameterException create(CommandLine commandLine, Collection<Model.ArgSpec> collection, String string) {
            String string2 = Model.ArgSpec.describe(collection, ", ", string, "'", "'");
            String string3 = Model.ArgSpec.describeTypes(collection);
            return new MissingParameterException(commandLine, collection, "Missing required " + string3 + ": " + string2);
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;
        private Model.ArgSpec argSpec = null;
        private String value = null;

        public ParameterException(CommandLine commandLine, String string) {
            super(string);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String string, Throwable throwable) {
            super(string, throwable);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String string, Throwable throwable, Model.ArgSpec argSpec, String string2) {
            super(string, throwable);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && string2 == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = string2;
        }

        public ParameterException(CommandLine commandLine, String string, Model.ArgSpec argSpec, String string2) {
            super(string);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
            if (argSpec == null && string2 == null) {
                throw new IllegalArgumentException("ArgSpec and value cannot both be null");
            }
            this.argSpec = argSpec;
            this.value = string2;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        public Model.ArgSpec getArgSpec() {
            return this.argSpec;
        }

        public String getValue() {
            return this.value;
        }

        private static ParameterException create(CommandLine commandLine, Exception exception, String string, int n2, String[] stringArray) {
            String string2 = exception.getClass().getSimpleName() + ": " + exception.getLocalizedMessage() + " while processing argument at or before arg[" + n2 + "] '" + string + "' in " + Arrays.toString(stringArray) + ": " + exception.toString();
            return new ParameterException(commandLine, string2, exception, null, string);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        public TypeConversionException(String string) {
            super(string);
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        public ExecutionException(CommandLine commandLine, String string) {
            super(string);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ExecutionException(CommandLine commandLine, String string, Throwable throwable) {
            super(string, throwable);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        public InitializationException(String string) {
            super(string);
        }

        public InitializationException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        public PicocliException(String string) {
            super(string);
        }

        public PicocliException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CosineSimilarity {
        private CosineSimilarity() {
        }

        static List<String> mostSimilar(String string, Iterable<String> iterable) {
            return CosineSimilarity.mostSimilar(string, iterable, 0.0);
        }

        static List<String> mostSimilar(String string, Iterable<String> iterable, double d2) {
            string = string.toLowerCase();
            TreeMap<Double, String> treeMap = new TreeMap<Double, String>();
            for (String string2 : iterable) {
                double d3 = CosineSimilarity.similarity(string, string2.toLowerCase(), 2);
                if (!(d3 > d2)) continue;
                treeMap.put(d3, string2);
            }
            return CommandLine.reverseList(new ArrayList(treeMap.values()));
        }

        private static double similarity(String string, String string2, int n2) {
            Map<String, Integer> map = CosineSimilarity.countNgramFrequency(string, n2);
            Map<String, Integer> map2 = CosineSimilarity.countNgramFrequency(string2, n2);
            return CosineSimilarity.dotProduct(map, map2) / Math.sqrt(CosineSimilarity.dotProduct(map, map) * CosineSimilarity.dotProduct(map2, map2));
        }

        private static Map<String, Integer> countNgramFrequency(String string, int n2) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n3 = 0;
            while (n3 + n2 <= string.length()) {
                String string2;
                hashMap.put(string2, 1 + (hashMap.containsKey(string2 = string.substring(n3, n3 + n2)) ? (Integer)hashMap.get(string2) : 0));
                ++n3;
            }
            return hashMap;
        }

        private static double dotProduct(Map<String, Integer> map, Map<String, Integer> map2) {
            double d2 = 0.0;
            for (String string : map.keySet()) {
                d2 += (double)(map.get(string) * (map2.containsKey(string) ? map2.get(string) : 0));
            }
            return d2;
        }
    }

    public static final class Tracer {
        private PrintStream stream = System.err;
        private TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        boolean modified;

        private Tracer() {
        }

        public TraceLevel getLevel() {
            return this.level;
        }

        public void setLevel(TraceLevel traceLevel) {
            this.level = Assert.notNull(traceLevel, "level");
            this.modified = true;
        }

        public boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }

        public boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        public boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        public boolean isOff() {
            return this.level == TraceLevel.OFF;
        }

        public void warn(String string, Object ... objectArray) {
            TraceLevel.WARN.print(this, string, objectArray);
        }

        public void info(String string, Object ... objectArray) {
            TraceLevel.INFO.print(this, string, objectArray);
        }

        public void debug(String string, Object ... objectArray) {
            TraceLevel.DEBUG.print(this, string, objectArray);
        }

        public String toString() {
            return "Tracer[" + (Object)((Object)this.level) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        public boolean isEnabled(TraceLevel traceLevel) {
            return this.ordinal() >= traceLevel.ordinal();
        }

        private void print(Tracer tracer, String string, Object ... objectArray) {
            if (tracer.level.isEnabled(this)) {
                tracer.stream.printf(this.prefix(string) + "%n", objectArray);
            }
        }

        private String prefix(String string) {
            return "[picocli " + (Object)((Object)this) + "] " + string;
        }

        static TraceLevel lookup(String string) {
            return string == null ? WARN : (CommandLine.empty(string) || "true".equalsIgnoreCase(string) ? INFO : TraceLevel.valueOf(string.toUpperCase(Locale.ENGLISH)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Assert {
        static <T> T notNull(T t2, String string) {
            if (t2 == null) {
                throw new NullPointerException(string);
            }
            return t2;
        }

        static boolean equals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        static int hashCode(Object object) {
            return object == null ? 0 : object.hashCode();
        }

        static int hashCode(boolean bl2) {
            return bl2 ? 1 : 0;
        }

        static void assertTrue(boolean bl2, String string) {
            if (!bl2) {
                throw new IllegalStateException(string);
            }
        }

        static void assertTrue(boolean bl2, IHelpSectionRenderer iHelpSectionRenderer) {
            if (!bl2) {
                throw new IllegalStateException(iHelpSectionRenderer.render(null));
            }
        }

        private Assert() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        public final Model.PositionalParamSpec AT_FILE_POSITIONAL_PARAM = ((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)((Model.PositionalParamSpec.Builder)Model.PositionalParamSpec.builder().paramLabel("${picocli.atfile.label:-@<filename>}")).description("${picocli.atfile.description:-One or more argument files containing options.}")).arity("0..*")).descriptionKey("picocli.atfile")).build();
        public final Model.OptionSpec END_OF_OPTIONS_OPTION = this.createEndOfOptionsOption("--");
        private final Model.CommandSpec commandSpec;
        private final ColorScheme colorScheme;
        private final Map<String, Help> allCommands = new LinkedHashMap<String, Help>();
        private final Map<String, Help> visibleCommands = new LinkedHashMap<String, Help>();
        private List<String> aliases;
        private final IParamLabelRenderer parameterLabelRenderer;

        private Model.OptionSpec createEndOfOptionsOption(String string) {
            return ((Model.OptionSpec.Builder)((Model.OptionSpec.Builder)((Model.OptionSpec.Builder)Model.OptionSpec.builder(string, new String[0]).description("${picocli.endofoptions.description:-This option can be used to separate command-line options from the list of positional parameters.}")).arity("0")).descriptionKey("picocli.endofoptions")).build();
        }

        public Help(Object object) {
            this(object, Ansi.AUTO);
        }

        public Help(Object object, Ansi ansi) {
            this(object, Help.defaultColorScheme(ansi));
        }

        @Deprecated
        public Help(Object object, ColorScheme colorScheme) {
            this(Model.CommandSpec.forAnnotatedObject(object, new DefaultFactory()), colorScheme);
        }

        public Help(Model.CommandSpec commandSpec, ColorScheme colorScheme) {
            this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            this.aliases = new ArrayList<String>(Arrays.asList(commandSpec.aliases()));
            this.aliases.add(0, commandSpec.name());
            this.colorScheme = new ColorScheme.Builder(colorScheme).applySystemProperties().build();
            this.parameterLabelRenderer = new DefaultParamLabelRenderer(commandSpec);
            this.registerSubcommands(commandSpec.subcommands());
            this.AT_FILE_POSITIONAL_PARAM.commandSpec = commandSpec;
        }

        Help withCommandNames(List<String> list) {
            this.aliases = list;
            return this;
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public ColorScheme colorScheme() {
            return this.colorScheme;
        }

        private IHelpFactory getHelpFactory() {
            return this.commandSpec.usageMessage().helpFactory();
        }

        public Map<String, Help> subcommands() {
            return Collections.unmodifiableMap(this.visibleCommands);
        }

        public Map<String, Help> allSubcommands() {
            return Collections.unmodifiableMap(this.allCommands);
        }

        protected List<String> aliases() {
            return Collections.unmodifiableList(this.aliases);
        }

        public IParamLabelRenderer parameterLabelRenderer() {
            return this.parameterLabelRenderer;
        }

        public Help addAllSubcommands(Map<String, CommandLine> map) {
            if (map != null) {
                this.registerSubcommands(map);
            }
            return this;
        }

        private void registerSubcommands(Map<String, CommandLine> map) {
            Object object;
            IdentityHashMap<CommandLine, ArrayList<String>> identityHashMap = new IdentityHashMap<CommandLine, ArrayList<String>>();
            for (CommandLine object2 : map.values()) {
                if (identityHashMap.containsKey(object2)) continue;
                identityHashMap.put(object2, new ArrayList<String>(Arrays.asList(object2.commandSpec.aliases())));
            }
            for (Map.Entry entry : map.entrySet()) {
                object = (List)identityHashMap.get(entry.getValue());
                if (object.contains(entry.getKey())) continue;
                object.add(0, entry.getKey());
            }
            for (Map.Entry entry : map.entrySet()) {
                object = (CommandLine)entry.getValue();
                List list = (List)identityHashMap.remove(object);
                if (list == null) continue;
                String string = list.toString().substring(1, list.toString().length() - 1);
                Help help = this.getHelpFactory().create(((CommandLine)object).commandSpec, this.colorScheme).withCommandNames(list);
                this.allCommands.put(string, help);
                if (help.commandSpec().usageMessage().hidden()) continue;
                this.visibleCommands.put(string, help);
            }
        }

        @Deprecated
        public Help addSubcommand(String string, Object object) {
            Help help = this.getHelpFactory().create(Model.CommandSpec.forAnnotatedObject(object, this.commandSpec.commandLine().factory), Help.defaultColorScheme(Ansi.AUTO));
            this.visibleCommands.put(string, help);
            this.allCommands.put(string, help);
            return this;
        }

        List<Model.OptionSpec> options() {
            return this.commandSpec.options();
        }

        List<Model.PositionalParamSpec> positionalParameters() {
            return this.commandSpec.positionalParameters();
        }

        String commandName() {
            return this.commandSpec.name();
        }

        public String fullSynopsis() {
            return this.synopsisHeading(new Object[0]) + this.synopsis(this.synopsisHeadingLength());
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int n2) {
            if (!CommandLine.empty(this.commandSpec.usageMessage().customSynopsis())) {
                return this.customSynopsis(new Object[0]);
            }
            Comparator<Model.OptionSpec> comparator = this.commandSpec.usageMessage().sortSynopsis() ? Help.createShortOptionArityAndNameComparator() : Help.createOrderComparatorIfNecessary(this.commandSpec.options());
            boolean bl2 = this.commandSpec.parser().posixClusteredShortOptionsAllowed();
            return this.commandSpec.usageMessage().abbreviateSynopsis() ? this.abbreviatedSynopsis() : this.detailedSynopsis(n2, comparator, bl2);
        }

        public String abbreviatedSynopsis() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.commandSpec.optionsMap().isEmpty()) {
                stringBuilder.append(" [OPTIONS]");
            }
            for (Model.PositionalParamSpec positionalParamSpec : this.commandSpec.positionalParameters()) {
                if (positionalParamSpec.hidden()) continue;
                stringBuilder.append(' ').append(this.parameterLabelRenderer().renderParameterLabel(positionalParamSpec, this.ansi(), this.colorScheme.parameterStyles));
            }
            if (!this.commandSpec.subcommands().isEmpty()) {
                stringBuilder.append(" ").append(this.commandSpec.usageMessage().synopsisSubcommandLabel());
            }
            return this.colorScheme.commandText(this.commandSpec.qualifiedName()).toString() + stringBuilder.toString() + System.getProperty("line.separator");
        }

        @Deprecated
        public String detailedSynopsis(Comparator<Model.OptionSpec> comparator, boolean bl2) {
            return this.detailedSynopsis(0, comparator, bl2);
        }

        public String detailedSynopsis(int n2, Comparator<Model.OptionSpec> comparator, boolean bl2) {
            HashSet<Model.ArgSpec> hashSet = new HashSet<Model.ArgSpec>();
            Ansi.Text text = this.createDetailedSynopsisGroupsText(hashSet);
            Ansi.Text text2 = this.createDetailedSynopsisOptionsText(hashSet, comparator, bl2);
            Ansi.Text text3 = this.createDetailedSynopsisEndOfOptionsText();
            Ansi.Text text4 = this.createDetailedSynopsisPositionalsText(hashSet);
            Ansi.Text text5 = this.createDetailedSynopsisCommandText();
            return this.makeSynopsisFromParts(n2, text2, text, text3, text4, text5);
        }

        protected String makeSynopsisFromParts(int n2, Ansi.Text text, Ansi.Text text2, Ansi.Text text3, Ansi.Text text4, Ansi.Text text5) {
            boolean bl2 = true;
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec().argGroups()) {
                if (!argGroupSpec.validate()) continue;
                bl2 &= argGroupSpec.allOptionsNested().isEmpty();
            }
            Ansi.Text text6 = bl2 ? text.concat(text3).concat(text2).concat(text4).concat(text5) : text.concat(text2).concat(text3).concat(text4).concat(text5);
            return this.insertSynopsisCommandName(n2, text6);
        }

        protected Ansi.Text createDetailedSynopsisGroupsText(Set<Model.ArgSpec> set) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec().argGroups()) {
                if (!argGroupSpec.validate()) continue;
                text = text.concat(" ").concat(argGroupSpec.synopsisText(this.colorScheme(), set));
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisOptionsText(Collection<Model.ArgSpec> collection, Comparator<Model.OptionSpec> comparator, boolean bl2) {
            return this.createDetailedSynopsisOptionsText(collection, this.commandSpec.options(), comparator, bl2);
        }

        protected Ansi.Text createDetailedSynopsisOptionsText(Collection<Model.ArgSpec> collection, List<Model.OptionSpec> list, Comparator<Model.OptionSpec> comparator, boolean bl2) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(list);
            if (comparator != null) {
                Collections.sort(arrayList, comparator);
            }
            arrayList.removeAll(collection);
            if (bl2) {
                ArrayList arrayList2 = new ArrayList();
                StringBuilder object = new StringBuilder("-");
                StringBuilder stringBuilder = new StringBuilder("-");
                for (Model.OptionSpec optionSpec : arrayList) {
                    String string;
                    boolean bl3;
                    if (optionSpec.hidden() || !(bl3 = optionSpec.typeInfo().isBoolean()) || optionSpec.arity().max > 0 || (string = optionSpec.shortestName()).length() != 2 || !string.startsWith("-") || optionSpec.negatable() && !string.equals(this.commandSpec.negatableOptionTransformer().makeSynopsis(string, this.commandSpec))) continue;
                    arrayList2.add(optionSpec);
                    if (optionSpec.required()) {
                        object.append(string.substring(1));
                        continue;
                    }
                    stringBuilder.append(string.substring(1));
                }
                arrayList.removeAll(arrayList2);
                if (object.length() > 1) {
                    text = text.concat(" ").concat(this.colorScheme.optionText(object.toString()));
                }
                if (stringBuilder.length() > 1) {
                    text = text.concat(" [").concat(this.colorScheme.optionText(stringBuilder.toString())).concat("]");
                }
            }
            for (Model.OptionSpec optionSpec : arrayList) {
                text = Help.concatOptionText(" ", text, this.colorScheme, optionSpec, this.parameterLabelRenderer());
            }
            return text;
        }

        static Ansi.Text concatOptionText(String string, Ansi.Text text, ColorScheme colorScheme, Model.OptionSpec optionSpec, IParamLabelRenderer iParamLabelRenderer) {
            if (!optionSpec.hidden()) {
                Object object;
                String string2 = optionSpec.shortestName();
                if (optionSpec.negatable) {
                    object = optionSpec.commandSpec == null ? RegexTransformer.createDefault() : optionSpec.commandSpec.negatableOptionTransformer();
                    string2 = object.makeSynopsis(optionSpec.shortestName(), optionSpec.commandSpec);
                }
                object = colorScheme.optionText(string2);
                Ansi.Text text2 = iParamLabelRenderer.renderParameterLabel(optionSpec, colorScheme.ansi(), colorScheme.optionParamStyles);
                text = text.concat(string);
                if (optionSpec.required()) {
                    text = text.concat((Ansi.Text)object).concat(text2).concat("");
                    if (optionSpec.isMultiValue()) {
                        text = text.concat(" [").concat((Ansi.Text)object).concat(text2).concat("]...");
                    }
                } else {
                    text = text.concat("[").concat((Ansi.Text)object).concat(text2).concat("]");
                    if (optionSpec.isMultiValue()) {
                        text = text.concat("...");
                    }
                }
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisEndOfOptionsText() {
            if (!this.commandSpec.usageMessage.showEndOfOptionsDelimiterInUsageHelp()) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(0);
            }
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            return ansi.new Ansi.Text(0).concat(" [").concat(this.colorScheme.optionText(this.commandSpec.parser().endOfOptionsDelimiter())).concat("]");
        }

        protected Ansi.Text createDetailedSynopsisPositionalsText(Collection<Model.ArgSpec> collection) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(this.commandSpec.positionalParameters());
            if (this.hasAtFileParameter()) {
                arrayList.add(0, this.AT_FILE_POSITIONAL_PARAM);
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
            }
            arrayList.removeAll(collection);
            for (Model.PositionalParamSpec positionalParamSpec : arrayList) {
                text = Help.concatPositionalText(" ", text, this.colorScheme, positionalParamSpec, this.parameterLabelRenderer());
            }
            return text;
        }

        static Ansi.Text concatPositionalText(String string, Ansi.Text text, ColorScheme colorScheme, Model.PositionalParamSpec positionalParamSpec, IParamLabelRenderer iParamLabelRenderer) {
            if (!positionalParamSpec.hidden()) {
                Ansi.Text text2 = iParamLabelRenderer.renderParameterLabel(positionalParamSpec, colorScheme.ansi(), colorScheme.parameterStyles);
                text = text.concat(string).concat(text2);
            }
            return text;
        }

        protected Ansi.Text createDetailedSynopsisCommandText() {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            if (!this.commandSpec.subcommands().isEmpty()) {
                return text.concat(" ").concat(this.commandSpec.usageMessage().synopsisSubcommandLabel());
            }
            return text;
        }

        protected String insertSynopsisCommandName(int n2, Ansi.Text text) {
            if (n2 < 0) {
                throw new IllegalArgumentException("synopsisHeadingLength must be a positive number but was " + n2);
            }
            String string = this.commandSpec.qualifiedName();
            int n3 = n2 + string.length() + 1;
            if ((double)n3 > this.commandSpec.usageMessage().synopsisAutoIndentThreshold() * (double)this.width()) {
                n3 = this.commandSpec.usageMessage().synopsisIndent() < 0 ? n2 : this.commandSpec.usageMessage().synopsisIndent();
                n3 = Math.min(n3, (int)(0.9 * (double)this.width()));
            }
            TextTable textTable = TextTable.forColumnWidths(this.colorScheme, this.width());
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            textTable.indentWrappedLines = n3;
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text2 = ansi.new Ansi.Text(Help.stringOf('X', n2), text.colorScheme);
            textTable.addRowValues(text2.concat(this.colorScheme.commandText(string)).concat(text));
            return textTable.toString().substring(n2);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] stringArray = ansi.new Ansi.Text(this.commandSpec.usageMessage().synopsisHeading()).toString().split("\\r?\\n|\\r|%n", -1);
            return stringArray[stringArray.length - 1].length();
        }

        private List<Model.OptionSpec> excludeHiddenAndGroupOptions(List<Model.OptionSpec> list) {
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(list);
            for (Model.ArgGroupSpec argGroupSpec : this.optionSectionGroups()) {
                arrayList.removeAll(argGroupSpec.allOptionsNested());
            }
            Iterator<Model.ArgGroupSpec> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!((Model.OptionSpec)((Object)iterator.next())).hidden()) continue;
                iterator.remove();
            }
            return arrayList;
        }

        private List<Model.PositionalParamSpec> excludeHiddenAndGroupParams(List<Model.PositionalParamSpec> list) {
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(list);
            for (Model.ArgGroupSpec argGroupSpec : this.optionSectionGroups()) {
                arrayList.removeAll(argGroupSpec.allPositionalParametersNested());
            }
            Iterator<Model.ArgGroupSpec> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!((Model.PositionalParamSpec)((Object)iterator.next())).hidden()) continue;
                iterator.remove();
            }
            return arrayList;
        }

        private static Comparator<Model.OptionSpec> createOrderComparatorIfNecessary(List<Model.OptionSpec> list) {
            for (Model.OptionSpec optionSpec : list) {
                if (optionSpec.order() == -1) continue;
                return Help.createOrderComparator();
            }
            return null;
        }

        public Comparator<Model.OptionSpec> createDefaultOptionSort() {
            return this.commandSpec.usageMessage().sortOptions() ? Help.createShortOptionNameComparator() : Help.createOrderComparatorIfNecessary(this.commandSpec.options());
        }

        public String optionList() {
            return this.optionList(this.createDefaultLayout(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        public String optionListExcludingGroups(List<Model.OptionSpec> list) {
            return this.optionListExcludingGroups(list, this.createDefaultLayout(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        public String optionList(Layout layout, Comparator<Model.OptionSpec> comparator, IParamLabelRenderer iParamLabelRenderer) {
            List<Model.OptionSpec> list = this.excludeHiddenAndGroupOptions(this.options());
            return this.optionListExcludingGroups(list, layout, comparator, iParamLabelRenderer) + this.optionListGroupSections();
        }

        public String optionListExcludingGroups(List<Model.OptionSpec> list, Layout layout, Comparator<Model.OptionSpec> comparator, IParamLabelRenderer iParamLabelRenderer) {
            ArrayList<Model.OptionSpec> arrayList = new ArrayList<Model.OptionSpec>(list);
            if (comparator != null) {
                Collections.sort(arrayList, comparator);
            }
            layout.addAllOptions(arrayList, iParamLabelRenderer);
            return layout.toString();
        }

        public String optionListGroupSections() {
            return this.optionListGroupSections(this.optionSectionGroups(), this.createDefaultOptionSort(), this.parameterLabelRenderer());
        }

        private String optionListGroupSections(List<Model.ArgGroupSpec> list, Comparator<Model.OptionSpec> comparator, IParamLabelRenderer iParamLabelRenderer) {
            HashSet<Model.ArgSpec> hashSet = new HashSet<Model.ArgSpec>();
            ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>(list);
            Collections.sort(arrayList, new SortByOrder());
            StringBuilder stringBuilder = new StringBuilder();
            for (Model.ArgGroupSpec argGroupSpec : arrayList) {
                ArrayList<Model.OptionSpec> arrayList2 = new ArrayList<Model.OptionSpec>(argGroupSpec.allOptionsNested());
                if (comparator != null) {
                    Collections.sort(arrayList2, comparator);
                }
                arrayList2.removeAll(hashSet);
                hashSet.addAll(arrayList2);
                ArrayList<Model.PositionalParamSpec> arrayList3 = new ArrayList<Model.PositionalParamSpec>(argGroupSpec.allPositionalParametersNested());
                arrayList3.removeAll(hashSet);
                hashSet.addAll(arrayList3);
                Layout layout = this.createDefaultLayout();
                layout.addPositionalParameters(arrayList3, iParamLabelRenderer);
                layout.addOptions(arrayList2, iParamLabelRenderer);
                stringBuilder.append(this.createHeading(argGroupSpec.heading(), new Object[0]));
                stringBuilder.append(layout);
            }
            return stringBuilder.toString();
        }

        public List<Model.ArgGroupSpec> optionSectionGroups() {
            ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>();
            Help.optionSectionGroups(this.commandSpec.argGroups(), arrayList);
            return arrayList;
        }

        private static void optionSectionGroups(List<Model.ArgGroupSpec> list, List<Model.ArgGroupSpec> list2) {
            for (Model.ArgGroupSpec argGroupSpec : list) {
                Help.optionSectionGroups(argGroupSpec.subgroups(), list2);
                if (argGroupSpec.heading() == null) continue;
                list2.add(argGroupSpec);
            }
        }

        public String parameterList() {
            return this.parameterList(this.excludeHiddenAndGroupParams(this.positionalParameters()));
        }

        public String parameterList(List<Model.PositionalParamSpec> list) {
            return this.parameterList(list, this.createDefaultLayout(), this.parameterLabelRenderer());
        }

        public String parameterList(Layout layout, IParamLabelRenderer iParamLabelRenderer) {
            return this.parameterList(this.excludeHiddenAndGroupParams(this.positionalParameters()), layout, iParamLabelRenderer);
        }

        public String parameterList(List<Model.PositionalParamSpec> list, Layout layout, IParamLabelRenderer iParamLabelRenderer) {
            layout.addAllPositionalParameters(list, iParamLabelRenderer);
            return layout.toString();
        }

        public boolean hasAtFileParameter() {
            return this.commandSpec.parser.expandAtFiles() && this.commandSpec.usageMessage.showAtFileInUsageHelp();
        }

        public String atFileParameterList() {
            if (this.hasAtFileParameter()) {
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
                Layout layout = this.createDefaultLayout();
                layout.addPositionalParameter(this.AT_FILE_POSITIONAL_PARAM, this.parameterLabelRenderer());
                return layout.toString();
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String endOfOptionsList() {
            if (!this.commandSpec.usageMessage.showEndOfOptionsDelimiterInUsageHelp()) {
                return "";
            }
            Model.OptionSpec optionSpec = "--".equals(this.commandSpec.parser().endOfOptionsDelimiter()) ? this.END_OF_OPTIONS_OPTION : this.createEndOfOptionsOption(this.commandSpec.parser().endOfOptionsDelimiter());
            optionSpec.commandSpec = this.commandSpec;
            try {
                optionSpec.messages(this.commandSpec.usageMessage().messages());
                Layout layout = this.createDefaultLayout();
                layout.addOption(optionSpec, this.parameterLabelRenderer());
                String string = layout.toString();
                return string;
            }
            finally {
                optionSpec.commandSpec = null;
            }
        }

        private static String heading(Ansi ansi, int n2, boolean bl2, String string, Object ... objectArray) {
            StringBuilder stringBuilder = Help.join(ansi, n2, bl2, new String[]{string}, new StringBuilder(), objectArray);
            return Help.trimLineSeparator(stringBuilder.toString()) + new String(Help.spaces(Help.countTrailingSpaces(string)));
        }

        static String trimLineSeparator(String string) {
            return string.endsWith(System.getProperty("line.separator")) ? string.substring(0, string.length() - System.getProperty("line.separator").length()) : string;
        }

        private static char[] spaces(int n2) {
            char[] cArray = new char[n2];
            Arrays.fill(cArray, ' ');
            return cArray;
        }

        private static int countTrailingSpaces(String string) {
            if (string == null) {
                return 0;
            }
            int n2 = 0;
            for (int i2 = string.length() - 1; i2 >= 0 && string.charAt(i2) == ' '; --i2) {
                ++n2;
            }
            return n2;
        }

        @Deprecated
        public static StringBuilder join(Ansi ansi, int n2, String[] stringArray, StringBuilder stringBuilder, Object ... objectArray) {
            return Help.join(ansi, n2, Model.UsageMessageSpec.DEFAULT_ADJUST_CJK, stringArray, stringBuilder, objectArray);
        }

        public static StringBuilder join(Ansi ansi, int n2, boolean bl2, String[] stringArray, StringBuilder stringBuilder, Object ... objectArray) {
            if (stringArray != null) {
                TextTable textTable = TextTable.forColumnWidths(ansi, n2);
                textTable.setAdjustLineBreaksForWideCJKCharacters(bl2);
                textTable.indentWrappedLines = 0;
                for (String string : stringArray) {
                    textTable.addRowValues(CommandLine.format(string, objectArray));
                }
                textTable.toString(stringBuilder);
            }
            return stringBuilder;
        }

        private int width() {
            return this.commandSpec.usageMessage().width();
        }

        private boolean adjustCJK() {
            return this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters();
        }

        public String customSynopsis(Object ... objectArray) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().customSynopsis(), new StringBuilder(), objectArray).toString();
        }

        public String description(Object ... objectArray) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().description(), new StringBuilder(), objectArray).toString();
        }

        public String header(Object ... objectArray) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().header(), new StringBuilder(), objectArray).toString();
        }

        public String footer(Object ... objectArray) {
            return Help.join(this.ansi(), this.width(), this.adjustCJK(), this.commandSpec.usageMessage().footer(), new StringBuilder(), objectArray).toString();
        }

        public String headerHeading(Object ... objectArray) {
            return this.createHeading(this.commandSpec.usageMessage().headerHeading(), objectArray);
        }

        public String synopsisHeading(Object ... objectArray) {
            return this.createHeading(this.commandSpec.usageMessage().synopsisHeading(), objectArray);
        }

        public String descriptionHeading(Object ... objectArray) {
            return CommandLine.empty(this.commandSpec.usageMessage().descriptionHeading()) ? "" : this.createHeading(this.commandSpec.usageMessage().descriptionHeading(), objectArray);
        }

        public String parameterListHeading(Object ... objectArray) {
            if (this.hasAtFileParameter() || !this.commandSpec.positionalParameters().isEmpty()) {
                return this.createHeading(this.commandSpec.usageMessage().parameterListHeading(), objectArray);
            }
            return "";
        }

        public String optionListHeading(Object ... objectArray) {
            boolean bl2 = false;
            for (Model.OptionSpec optionSpec : this.commandSpec.options()) {
                bl2 |= !optionSpec.hidden();
            }
            if (this.commandSpec.usageMessage().showEndOfOptionsDelimiterInUsageHelp() || bl2) {
                return this.createHeading(this.commandSpec.usageMessage().optionListHeading(), objectArray);
            }
            return "";
        }

        public String commandListHeading(Object ... objectArray) {
            return this.visibleCommands.isEmpty() ? "" : this.createHeading(this.commandSpec.usageMessage().commandListHeading(), objectArray);
        }

        public String footerHeading(Object ... objectArray) {
            return this.createHeading(this.commandSpec.usageMessage().footerHeading(), objectArray);
        }

        public String exitCodeListHeading(Object ... objectArray) {
            return this.createHeading(this.commandSpec.usageMessage().exitCodeListHeading(), objectArray);
        }

        public String exitCodeList() {
            return this.createTextTable(this.commandSpec.usageMessage().exitCodeList()).toString();
        }

        public String createHeading(String string, Object ... objectArray) {
            return Help.heading(this.ansi(), this.width(), this.adjustCJK(), string, objectArray);
        }

        public TextTable createTextTable(Map<?, ?> map) {
            if (map == null || map.isEmpty()) {
                return TextTable.forColumnWidths(this.colorScheme, 10, this.width() - 10);
            }
            int n2 = 3;
            int n3 = 2;
            int n4 = Math.min(this.width() - n2 - 1, Help.maxLength(map.keySet()));
            TextTable textTable = TextTable.forColumns(this.ansi(), new Column(n4 + n2, n3, Column.Overflow.SPAN), new Column(this.width() - (n4 + n2), n3, Column.Overflow.WRAP));
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.adjustCJK());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                textTable.addRowValues(CommandLine.format(String.valueOf(entry.getKey()), new Object[0]), CommandLine.format(String.valueOf(entry.getValue()), new Object[0]));
            }
            return textTable;
        }

        public String commandList() {
            return this.commandList(this.subcommands());
        }

        public String commandList(Map<String, Help> map) {
            if (map.isEmpty()) {
                return "";
            }
            int n2 = Help.maxLength(map.keySet());
            TextTable textTable = TextTable.forColumns(this.colorScheme().ansi(), new Column(n2 + 2, 2, Column.Overflow.SPAN), new Column(this.width() - (n2 + 2), 2, Column.Overflow.WRAP));
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.adjustCJK());
            for (Map.Entry<String, Help> entry : map.entrySet()) {
                Help help = entry.getValue();
                Model.UsageMessageSpec usageMessageSpec = help.commandSpec().usageMessage();
                String string = !CommandLine.empty(usageMessageSpec.header()) ? usageMessageSpec.header()[0] : (!CommandLine.empty(usageMessageSpec.description()) ? usageMessageSpec.description()[0] : "");
                Ansi.Text[] textArray = this.colorScheme().text(CommandLine.format(string, new Object[0])).splitLines();
                for (int i2 = 0; i2 < textArray.length; ++i2) {
                    textTable.addRowValues(i2 == 0 ? help.commandNamesText(", ") : Ansi.EMPTY_TEXT, textArray[i2]);
                }
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<?> collection) {
            int n2 = 0;
            for (Object obj : collection) {
                n2 = Math.max(n2, String.valueOf(obj).length());
            }
            return n2;
        }

        public Ansi.Text commandNamesText(String string) {
            Ansi.Text text = this.colorScheme().commandText(this.aliases().get(0));
            for (int i2 = 1; i2 < this.aliases().size(); ++i2) {
                text = text.concat(string).concat(this.colorScheme().commandText(this.aliases().get(i2)));
            }
            return text;
        }

        private static String join(String[] stringArray, int n2, int n3, String string) {
            if (stringArray == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                stringBuilder.append(i2 > n2 ? string : "").append(stringArray[i2]);
            }
            return stringBuilder.toString();
        }

        private static String stringOf(char c2, int n2) {
            char[] cArray = new char[n2];
            Arrays.fill(cArray, c2);
            return new String(cArray);
        }

        public Layout createDefaultLayout() {
            return this.createDefaultLayout(this.options(), this.positionalParameters(), this.colorScheme());
        }

        public Layout createDefaultLayout(List<Model.OptionSpec> list, List<Model.PositionalParamSpec> list2, ColorScheme colorScheme) {
            return this.createLayout(this.calcLongOptionColumnWidth(list, list2, colorScheme), colorScheme);
        }

        private Layout createLayout(int n2, ColorScheme colorScheme) {
            TextTable textTable = TextTable.forDefaultColumns(colorScheme, n2, this.width());
            textTable.setAdjustLineBreaksForWideCJKCharacters(this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters());
            return new Layout(colorScheme, textTable, this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        public int calcLongOptionColumnWidth(List<Model.OptionSpec> list, List<Model.PositionalParamSpec> list2, ColorScheme colorScheme) {
            Object object;
            int n2 = 0;
            IOptionRenderer iOptionRenderer = this.createDefaultOptionRenderer();
            boolean bl2 = this.commandSpec.usageMessage().adjustLineBreaksForWideCJKCharacters();
            int n3 = this.commandSpec.usageMessage().longOptionsMaxWidth() + 1;
            for (Model.OptionSpec object22 : list) {
                if (object22.hidden()) continue;
                object = iOptionRenderer.render(object22, this.parameterLabelRenderer(), colorScheme);
                int text = bl2 ? object[0][3].getCJKAdjustedLength() : object[0][3].length;
                if (text >= n3) continue;
                n2 = Math.max(n2, text);
            }
            ArrayList<Model.PositionalParamSpec> arrayList = new ArrayList<Model.PositionalParamSpec>(list2);
            if (this.hasAtFileParameter()) {
                arrayList.add(0, this.AT_FILE_POSITIONAL_PARAM);
                this.AT_FILE_POSITIONAL_PARAM.messages(this.commandSpec.usageMessage().messages());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Model.PositionalParamSpec)iterator.next();
                if (((Model.ArgSpec)object).hidden()) continue;
                Ansi.Text text = this.parameterLabelRenderer().renderParameterLabel((Model.ArgSpec)object, colorScheme.ansi(), colorScheme.parameterStyles);
                int n4 = bl2 ? text.getCJKAdjustedLength() : text.length;
                if (n4 >= n3) continue;
                n2 = Math.max(n2, n4);
            }
            return n2 + 3;
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            return new DefaultOptionRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            return new DefaultParameterRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> list) {
                    return argSpec.command() != null && argSpec.command().commandLine() != null ? argSpec.command().commandLine().getColorScheme().apply(argSpec.paramLabel(), list) : ansi.apply(argSpec.paramLabel(), list);
                }

                @Override
                public String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.commandSpec);
        }

        public static Comparator<Model.OptionSpec> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Model.OptionSpec> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        static Comparator<Model.OptionSpec> createOrderComparator() {
            return new SortByOrder<Model.OptionSpec>();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        private static void addTrailingDefaultLine(List<Ansi.Text[]> list, Model.ArgSpec argSpec, ColorScheme colorScheme) {
            Ansi.Text text = Ansi.EMPTY_TEXT;
            Ansi.Text[] textArray = new Ansi.Text[5];
            textArray[0] = text;
            textArray[1] = text;
            textArray[2] = text;
            textArray[3] = text;
            Ansi ansi = colorScheme.ansi();
            ((Object)((Object)ansi)).getClass();
            textArray[4] = ansi.new Ansi.Text("  Default: " + argSpec.defaultValueString(true), colorScheme);
            list.add(textArray);
        }

        private static Ansi.Text[] createDescriptionFirstLines(ColorScheme colorScheme, Model.ArgSpec argSpec, String[] stringArray, boolean[] blArray) {
            Ansi ansi = colorScheme.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text[] textArray = ansi.new Ansi.Text(CommandLine.str(stringArray, 0), colorScheme).splitLines();
            if (textArray.length == 0 || textArray.length == 1 && textArray[0].plain.length() == 0) {
                if (blArray[0]) {
                    Ansi.Text[] textArray2 = new Ansi.Text[1];
                    Ansi ansi2 = colorScheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    textArray2[0] = ansi2.new Ansi.Text("  Default: " + argSpec.defaultValueString(true), colorScheme);
                    textArray = textArray2;
                    blArray[0] = false;
                } else {
                    textArray = new Ansi.Text[]{Ansi.EMPTY_TEXT};
                }
            }
            return textArray;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme.Builder(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic).errors(Ansi.Style.fg_red, Ansi.Style.bold).stackTraces(Ansi.Style.italic).build();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static Boolean tty;

            static boolean isTTY() {
                if (tty == null) {
                    tty = Ansi.calcTTY();
                }
                return tty;
            }

            static final boolean isWindows() {
                return System.getProperty("os.name").toLowerCase().contains("win");
            }

            static final boolean isMac() {
                return System.getProperty("os.name").toLowerCase().contains("mac");
            }

            static final boolean isXterm() {
                return System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
            }

            static final boolean isCygwin() {
                return System.getenv("TERM") != null && System.getenv("TERM").toLowerCase(Locale.ENGLISH).contains("cygwin");
            }

            static final boolean hasOsType() {
                return System.getenv("OSTYPE") != null;
            }

            static final boolean hintDisabled() {
                return "0".equals(System.getenv("CLICOLOR")) || "OFF".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean hintEnabled() {
                return System.getenv("ANSICON") != null || "1".equals(System.getenv("CLICOLOR")) || "ON".equals(System.getenv("ConEmuANSI"));
            }

            static final boolean forceDisabled() {
                return System.getenv("NO_COLOR") != null;
            }

            static final boolean forceEnabled() {
                return System.getenv("CLICOLOR_FORCE") != null && !"0".equals(System.getenv("CLICOLOR_FORCE"));
            }

            static boolean calcTTY() {
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable throwable) {
                    return true;
                }
            }

            static boolean isPseudoTTY() {
                return Ansi.isWindows() && (Ansi.isXterm() || Ansi.isCygwin() || Ansi.hasOsType());
            }

            static boolean ansiPossible() {
                if (Ansi.forceDisabled()) {
                    return false;
                }
                if (Ansi.forceEnabled()) {
                    return true;
                }
                if (Ansi.isWindows() && Ansi.isJansiConsoleInstalled()) {
                    return true;
                }
                if (Ansi.hintDisabled()) {
                    return false;
                }
                if (!Ansi.isTTY() && !Ansi.isPseudoTTY()) {
                    return false;
                }
                return Ansi.hintEnabled() || !Ansi.isWindows() || Ansi.isXterm() || Ansi.isCygwin() || Ansi.hasOsType();
            }

            static boolean isJansiConsoleInstalled() {
                try {
                    if (Boolean.getBoolean("org.fusesource.jansi.Ansi.disable")) {
                        return false;
                    }
                    Class<?> clazz = Class.forName("org.fusesource.jansi.Ansi");
                    Boolean bl2 = (Boolean)clazz.getDeclaredMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
                    if (!bl2.booleanValue()) {
                        return false;
                    }
                    Class<?> clazz2 = Class.forName("org.fusesource.jansi.AnsiConsole");
                    Field field = clazz2.getField("out");
                    return field.get(null) == System.out;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public boolean enabled() {
                boolean bl2;
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                String string = System.getProperty("picocli.ansi");
                boolean bl3 = string == null || "AUTO".equalsIgnoreCase(string);
                boolean bl4 = bl2 = "TTY".equalsIgnoreCase(string) && (Ansi.isTTY() || Ansi.isPseudoTTY());
                return bl3 ? Ansi.ansiPossible() : bl2 || Boolean.getBoolean("picocli.ansi");
            }

            public Text text(String string) {
                return new Text(string);
            }

            public String string(String string) {
                return new Text(string).toString();
            }

            public static Ansi valueOf(boolean bl2) {
                return bl2 ? ON : OFF;
            }

            @Deprecated
            public Text apply(String string, List<IStyle> list) {
                return Help.defaultColorScheme(this).apply(string, list);
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private List<StyledSection> sections = new ArrayList<StyledSection>();
                private ColorScheme colorScheme;

                public Text(int n2) {
                    this(n2, Help.defaultColorScheme(ansi));
                }

                public Text(int n2, ColorScheme colorScheme) {
                    this.maxLength = n2;
                    this.colorScheme = colorScheme;
                }

                public Text(Text text) {
                    this.maxLength = text.maxLength;
                    this.from = text.from;
                    this.length = text.length;
                    this.plain = new StringBuilder(text.plain);
                    this.sections = new ArrayList<StyledSection>(text.sections);
                    this.colorScheme = text.colorScheme;
                }

                public Text(String string) {
                    this(string, Help.defaultColorScheme(ansi));
                }

                public Text(String string, ColorScheme colorScheme) {
                    this.colorScheme = colorScheme;
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        if ((n3 = string.indexOf("@|", n2)) == -1) {
                            if (n2 == 0) {
                                this.plain.append(string);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(string.substring(n2));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(string, n2, n3);
                        int n4 = string.indexOf("|@", n3);
                        if (n4 == -1) {
                            this.plain.append(string);
                            this.length = this.plain.length();
                            return;
                        }
                        String string2 = string.substring(n3 += 2, n4);
                        String[] stringArray = string2.split(" ", 2);
                        if (stringArray.length == 1) {
                            this.plain.append(string);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] objectArray = colorScheme.parse(stringArray[0]);
                        this.addStyledSection(this.plain.length(), stringArray[1].length(), Style.on((IStyle[])objectArray), Style.off((IStyle[])CommandLine.reverseArray(objectArray)) + colorScheme.resetStyle().off());
                        this.plain.append(stringArray[1]);
                        n2 = n4 + 2;
                    }
                }

                private void addStyledSection(int n2, int n3, String string, String string2) {
                    this.sections.add(new StyledSection(n2, n3, string, string2));
                }

                public Object clone() {
                    return new Text(this);
                }

                public Text[] splitLines() {
                    ArrayList<Text> arrayList = new ArrayList<Text>();
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < this.plain.length()) {
                        boolean bl2;
                        char c2 = this.plain.charAt(n4);
                        boolean bl3 = bl2 = c2 == '\n';
                        if (c2 == '\r' && n4 + 1 < this.plain.length() && this.plain.charAt(n4 + 1) == '\n') {
                            bl2 = true;
                            ++n4;
                        }
                        if (bl2 |= c2 == '\r') {
                            arrayList.add(this.substring(n2, n3));
                            n2 = n4 + 1;
                        }
                        n3 = ++n4;
                    }
                    arrayList.add(this.substring(n2, this.plain.length()));
                    return arrayList.toArray(new Text[arrayList.size()]);
                }

                public Text substring(int n2) {
                    return this.substring(n2, this.length);
                }

                public Text substring(int n2, int n3) {
                    Text text = (Text)this.clone();
                    text.from = this.from + n2;
                    text.length = n3 - n2;
                    text.sections.clear();
                    for (StyledSection styledSection : this.sections) {
                        if (styledSection.startIndex >= text.from + text.length || styledSection.startIndex + styledSection.length <= text.from) continue;
                        text.sections.add(styledSection);
                    }
                    return text;
                }

                @Deprecated
                public Text append(String string) {
                    return this.concat(string);
                }

                @Deprecated
                public Text append(Text text) {
                    return this.concat(text);
                }

                public Text concat(String string) {
                    return this.concat(new Text(string, this.colorScheme));
                }

                public Text concat(Text text) {
                    Text text2 = (Text)this.clone();
                    text2.plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    text2.from = 0;
                    text2.sections = new ArrayList<StyledSection>();
                    for (StyledSection styledSection : this.sections) {
                        text2.sections.add(styledSection.withStartIndex(styledSection.startIndex - this.from));
                    }
                    text2.plain.append(text.plain.toString(), text.from, text.from + text.length);
                    for (StyledSection styledSection : text.sections) {
                        int n2 = text2.length + styledSection.startIndex - text.from;
                        text2.sections.add(styledSection.withStartIndex(n2));
                    }
                    text2.length = text2.plain.length();
                    return text2;
                }

                public void getStyledChars(int n2, int n3, Text text, int n4) {
                    if (text.length < n4) {
                        for (int i2 = text.length; i2 < n4; ++i2) {
                            text.plain.append(' ');
                        }
                        text.length = n4;
                    }
                    for (StyledSection styledSection : this.sections) {
                        if (styledSection.startIndex - n2 + styledSection.length < 0) continue;
                        text.sections.add(styledSection.withStartIndex(styledSection.startIndex - n2 + text.length));
                    }
                    text.plain.append(this.plain.toString(), n2, n2 + n3);
                    text.length = text.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object object) {
                    return this.toString().equals(String.valueOf(object));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection styledSection = null;
                    int n2 = Math.min(this.from + this.length, this.plain.length());
                    for (int i2 = this.from; i2 < n2; ++i2) {
                        StyledSection styledSection2 = this.findSectionContaining(i2);
                        if (styledSection2 != styledSection) {
                            if (styledSection != null) {
                                stringBuilder.append(styledSection.endStyles);
                            }
                            if (styledSection2 != null) {
                                stringBuilder.append(styledSection2.startStyles);
                            }
                            styledSection = styledSection2;
                        }
                        stringBuilder.append(this.plain.charAt(i2));
                    }
                    if (styledSection != null) {
                        stringBuilder.append(styledSection.endStyles);
                    }
                    return stringBuilder.toString();
                }

                private StyledSection findSectionContaining(int n2) {
                    for (StyledSection styledSection : this.sections) {
                        if (n2 < styledSection.startIndex || n2 >= styledSection.startIndex + styledSection.length) continue;
                        return styledSection;
                    }
                    return null;
                }

                public int getCJKAdjustedLength() {
                    return this.getCJKAdjustedLength(this.from, this.length);
                }

                public int getCJKAdjustedLength(int n2, int n3) {
                    String string = this.plain.substring(this.from, this.from + n3);
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < string.length()) {
                        int n6;
                        int n7;
                        if (!Character.isHighSurrogate((char)(n7 = string.charAt(n5++))) || n5 >= this.length) {
                            n6 = n7;
                        } else {
                            char c2 = string.charAt(n5);
                            if (Character.isLowSurrogate(c2)) {
                                ++n5;
                                n6 = Character.toCodePoint((char)n7, c2);
                            } else {
                                n6 = n7;
                            }
                        }
                        n4 += Model.UsageMessageSpec.isCodePointCJK(n6) ? 2 : 1;
                    }
                    return n4;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                StyledSection(int n2, int n3, String string, String string2) {
                    this.startIndex = n2;
                    this.length = n3;
                    this.startStyles = string;
                    this.endStyles = string2;
                }

                StyledSection withStartIndex(int n2) {
                    return new StyledSection(n2, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean bl2, String string) {
                    this.fgbg = bl2 ? 38 : 48;
                    String[] stringArray = string.split(";");
                    this.color = stringArray.length == 3 ? 16 + 36 * Integer.decode(stringArray[0]) + 6 * Integer.decode(stringArray[1]) + Integer.decode(stringArray[2]) : Integer.decode(string);
                }

                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }

                public boolean equals(Object object) {
                    if (object == this) {
                        return true;
                    }
                    if (!(object instanceof Palette256Color)) {
                        return false;
                    }
                    Palette256Color palette256Color = (Palette256Color)object;
                    return palette256Color.fgbg == this.fgbg && palette256Color.color == this.color;
                }

                public int hashCode() {
                    return (17 + this.fgbg) * 37 + this.color;
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int n3, int n4) {
                    this.startCode = n3;
                    this.endCode = n4;
                }

                @Override
                public String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... iStyleArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (IStyle iStyle : iStyleArray) {
                        stringBuilder.append(iStyle.on());
                    }
                    return stringBuilder.toString();
                }

                public static String off(IStyle ... iStyleArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (IStyle iStyle : iStyleArray) {
                        stringBuilder.append(iStyle.off());
                    }
                    return stringBuilder.toString();
                }

                public static IStyle fg(String string) {
                    try {
                        return Style.valueOf(string.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + string.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, string);
                        }
                    }
                }

                public static IStyle bg(String string) {
                    try {
                        return Style.valueOf(string.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + string.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, string);
                        }
                    }
                }

                public static IStyle[] parse(String string) {
                    String[] stringArray = string.split(",");
                    IStyle[] iStyleArray = new IStyle[stringArray.length];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        int n2;
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.fg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.bg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        iStyleArray[i2] = Style.fg(stringArray[i2]);
                    }
                    return iStyleArray;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ColorScheme {
            private static final Ansi.IStyle EMPTY_STYLE = new Ansi.IStyle(){

                public String on() {
                    return "";
                }

                public String off() {
                    return "";
                }
            };
            private final List<Ansi.IStyle> commandStyles;
            private final List<Ansi.IStyle> optionStyles;
            private final List<Ansi.IStyle> parameterStyles;
            private final List<Ansi.IStyle> optionParamStyles;
            private final List<Ansi.IStyle> errorStyles;
            private final List<Ansi.IStyle> stackTraceStyles;
            private final Ansi ansi;
            private final Map<String, Ansi.IStyle> markupMap;

            ColorScheme(Builder builder) {
                Assert.notNull(builder, "builder");
                this.ansi = Assert.notNull(builder.ansi(), "ansi");
                this.commandStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.commandStyles()));
                this.optionStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.optionStyles()));
                this.parameterStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.parameterStyles()));
                this.optionParamStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.optionParamStyles()));
                this.errorStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.errorStyles()));
                this.stackTraceStyles = Collections.unmodifiableList(new ArrayList<Ansi.IStyle>(builder.stackTraceStyles()));
                this.markupMap = builder.markupMap == null ? null : Collections.unmodifiableMap(new HashMap(builder.markupMap));
            }

            public Ansi.Text commandText(String string) {
                return this.apply(string, this.commandStyles);
            }

            public Ansi.Text optionText(String string) {
                return this.apply(string, this.optionStyles);
            }

            public Ansi.Text parameterText(String string) {
                return this.apply(string, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String string) {
                return this.apply(string, this.optionParamStyles);
            }

            public Ansi.Text errorText(String string) {
                return this.apply(string, this.errorStyles);
            }

            public Ansi.Text stackTraceText(String string) {
                return this.apply(string, this.stackTraceStyles);
            }

            public Ansi.Text stackTraceText(Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                return this.stackTraceText(stringWriter.toString());
            }

            public String richStackTraceString(Throwable throwable) {
                return CommandLine.throwableToColorString(throwable, this);
            }

            public Ansi ansi() {
                return this.ansi;
            }

            public List<Ansi.IStyle> commandStyles() {
                return this.commandStyles;
            }

            public List<Ansi.IStyle> optionStyles() {
                return this.optionStyles;
            }

            public List<Ansi.IStyle> parameterStyles() {
                return this.parameterStyles;
            }

            public List<Ansi.IStyle> optionParamStyles() {
                return this.optionParamStyles;
            }

            public List<Ansi.IStyle> errorStyles() {
                return this.errorStyles;
            }

            public List<Ansi.IStyle> stackTraceStyles() {
                return this.stackTraceStyles;
            }

            public Map<String, Ansi.IStyle> customMarkupMap() {
                return this.markupMap == null ? Collections.emptyMap() : this.markupMap;
            }

            public Ansi.IStyle[] parse(String string) {
                if (this.markupMap == null) {
                    return Ansi.Style.parse(string);
                }
                String[] stringArray = string.split(",");
                ArrayList<Ansi.IStyle> arrayList = new ArrayList<Ansi.IStyle>();
                for (String string2 : stringArray) {
                    Ansi.IStyle iStyle;
                    Ansi.IStyle iStyle2 = iStyle = this.markupMap.containsKey(string2 = string2.toLowerCase(Locale.ENGLISH).replace("(", "_").replace(")", "")) ? this.markupMap.get(string2) : this.markupMap.get("fg_" + string2);
                    if (iStyle == null) continue;
                    arrayList.add(iStyle);
                }
                return arrayList.toArray(new Ansi.IStyle[0]);
            }

            public Ansi.IStyle resetStyle() {
                if (this.markupMap == null) {
                    return Ansi.Style.reset;
                }
                return this.markupMap.containsKey("reset") ? this.markupMap.get("reset") : EMPTY_STYLE;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof ColorScheme)) {
                    return false;
                }
                ColorScheme colorScheme = (ColorScheme)object;
                return this.ansi.equals((Object)colorScheme.ansi) && this.commandStyles.equals(colorScheme.commandStyles) && this.optionStyles.equals(colorScheme.optionStyles) && this.parameterStyles.equals(colorScheme.parameterStyles) && this.optionParamStyles.equals(colorScheme.optionParamStyles) && this.errorStyles.equals(colorScheme.errorStyles) && this.stackTraceStyles.equals(colorScheme.stackTraceStyles) && this.markupMap == null ? colorScheme.markupMap == null : this.markupMap.equals(colorScheme.markupMap);
            }

            public int hashCode() {
                int n2 = 17;
                n2 = n2 * 37 + this.ansi.hashCode();
                n2 = n2 * 37 + this.commandStyles.hashCode();
                n2 = n2 * 37 + this.optionStyles.hashCode();
                n2 = n2 * 37 + this.parameterStyles.hashCode();
                n2 = n2 * 37 + this.optionParamStyles.hashCode();
                n2 = n2 * 37 + this.errorStyles.hashCode();
                n2 = n2 * 37 + this.stackTraceStyles.hashCode();
                n2 = n2 * 37 + (this.markupMap == null ? 0 : this.markupMap.hashCode());
                return n2;
            }

            public String toString() {
                return "ColorScheme[ansi=" + (Object)((Object)this.ansi) + ", commands=" + this.commandStyles + ", optionStyles=" + this.optionStyles + ", parameterStyles=" + this.parameterStyles + ", optionParamStyles=" + this.optionParamStyles + ", errorStyles=" + this.errorStyles + ", stackTraceStyles=" + this.stackTraceStyles + ", customMarkupMap=" + this.markupMap + "]";
            }

            public Ansi.Text apply(String string, List<Ansi.IStyle> list) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text text = ansi.new Ansi.Text(string.length());
                text.colorScheme = this;
                if (string.length() == 0) {
                    return text;
                }
                Object[] objectArray = list.toArray(new Ansi.IStyle[list.size()]);
                text.sections.add(new Ansi.StyledSection(0, string.length(), Ansi.Style.on((Ansi.IStyle[])objectArray), Ansi.Style.off((Ansi.IStyle[])CommandLine.reverseArray(objectArray)) + this.resetStyle().off()));
                text.plain.append(string);
                text.length = text.plain.length();
                return text;
            }

            public Ansi.Text text(String string) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(string, this);
            }

            public String string(String string) {
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                return ansi.new Ansi.Text(string, this).toString();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder {
                private final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> errorStyles = new ArrayList<Ansi.IStyle>();
                private final List<Ansi.IStyle> stackTraceStyles = new ArrayList<Ansi.IStyle>();
                private Ansi ansi = Ansi.AUTO;
                private Map<String, Ansi.IStyle> markupMap;

                public Builder() {
                }

                public Builder(Ansi ansi) {
                    this.ansi = Assert.notNull(ansi, "ansi");
                }

                public Builder(ColorScheme colorScheme) {
                    Assert.notNull(colorScheme, "colorScheme");
                    this.ansi = Assert.notNull(colorScheme.ansi(), "ansi");
                    this.commandStyles.addAll(colorScheme.commandStyles());
                    this.optionStyles.addAll(colorScheme.optionStyles());
                    this.parameterStyles.addAll(colorScheme.parameterStyles());
                    this.optionParamStyles.addAll(colorScheme.optionParamStyles());
                    this.errorStyles.addAll(colorScheme.errorStyles());
                    this.stackTraceStyles.addAll(colorScheme.stackTraceStyles());
                    if (colorScheme.markupMap != null) {
                        this.markupMap = new HashMap<String, Ansi.IStyle>(colorScheme.markupMap);
                    }
                }

                public Ansi ansi() {
                    return this.ansi;
                }

                public Builder ansi(Ansi ansi) {
                    this.ansi = Assert.notNull(ansi, "ansi");
                    return this;
                }

                public List<Ansi.IStyle> commandStyles() {
                    return this.commandStyles;
                }

                public List<Ansi.IStyle> optionStyles() {
                    return this.optionStyles;
                }

                public List<Ansi.IStyle> parameterStyles() {
                    return this.parameterStyles;
                }

                public List<Ansi.IStyle> optionParamStyles() {
                    return this.optionParamStyles;
                }

                public List<Ansi.IStyle> errorStyles() {
                    return this.errorStyles;
                }

                public List<Ansi.IStyle> stackTraceStyles() {
                    return this.stackTraceStyles;
                }

                public Map<String, Ansi.IStyle> customMarkupMap() {
                    return this.markupMap;
                }

                public Builder customMarkupMap(Map<String, Ansi.IStyle> map) {
                    this.markupMap = map;
                    return this;
                }

                public Builder commands(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.commandStyles, iStyleArray);
                }

                public Builder options(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.optionStyles, iStyleArray);
                }

                public Builder parameters(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.parameterStyles, iStyleArray);
                }

                public Builder optionParams(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.optionParamStyles, iStyleArray);
                }

                public Builder errors(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.errorStyles, iStyleArray);
                }

                public Builder stackTraces(Ansi.IStyle ... iStyleArray) {
                    return this.addAll(this.stackTraceStyles, iStyleArray);
                }

                public Builder applySystemProperties() {
                    this.replace(this.commandStyles, System.getProperty("picocli.color.commands"));
                    this.replace(this.optionStyles, System.getProperty("picocli.color.options"));
                    this.replace(this.parameterStyles, System.getProperty("picocli.color.parameters"));
                    this.replace(this.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                    this.replace(this.errorStyles, System.getProperty("picocli.color.errors"));
                    this.replace(this.stackTraceStyles, System.getProperty("picocli.color.stackTraces"));
                    return this;
                }

                private void replace(List<Ansi.IStyle> list, String string) {
                    if (string != null) {
                        list.clear();
                        this.addAll(list, Ansi.Style.parse(string));
                    }
                }

                private Builder addAll(List<Ansi.IStyle> list, Ansi.IStyle ... iStyleArray) {
                    list.addAll(Arrays.asList(iStyleArray));
                    return this;
                }

                public ColorScheme build() {
                    return new ColorScheme(this);
                }
            }
        }

        public static class Column {
            public final int width;
            public int indent;
            public final Overflow overflow;

            public Column(int n2, int n3, Overflow overflow) {
                this.width = n2;
                this.indent = n3;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            public boolean equals(Object object) {
                return object instanceof Column && ((Column)object).width == this.width && ((Column)object).indent == this.indent && ((Column)object).overflow == this.overflow;
            }

            public int hashCode() {
                return 17 * this.width + 37 * this.indent + 37 * this.overflow.hashCode();
            }

            public String toString() {
                return String.format("Column[width=%d, indent=%d, overflow=%s]", new Object[]{this.width, this.indent, this.overflow});
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            private static final int OPTION_SEPARATOR_COLUMN = 2;
            private static final int LONG_OPTION_COLUMN = 3;
            private final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final ColorScheme colorScheme;
            private final int tableWidth;
            private boolean adjustLineBreaksForWideCJKCharacters = true;

            @Deprecated
            public static TextTable forDefaultColumns(Ansi ansi, int n2) {
                return TextTable.forDefaultColumns(Help.defaultColorScheme(ansi), 24, n2);
            }

            @Deprecated
            public static TextTable forDefaultColumns(Ansi ansi, int n2, int n3) {
                return TextTable.forDefaultColumns(Help.defaultColorScheme(ansi), n2, n3);
            }

            public static TextTable forDefaultColumns(ColorScheme colorScheme, int n2, int n3) {
                int n4 = n3 - 5 - n2;
                return TextTable.forColumns(colorScheme, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.SPAN), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(n2, 1, Column.Overflow.SPAN), new Column(n4, 1, Column.Overflow.WRAP));
            }

            @Deprecated
            public static TextTable forColumnWidths(Ansi ansi, int ... nArray) {
                return TextTable.forColumnWidths(Help.defaultColorScheme(ansi), nArray);
            }

            public static TextTable forColumnWidths(ColorScheme colorScheme, int ... nArray) {
                Column[] columnArray = new Column[nArray.length];
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    columnArray[i2] = new Column(nArray[i2], 0, i2 == nArray.length - 1 ? Column.Overflow.WRAP : Column.Overflow.SPAN);
                }
                return new TextTable(colorScheme, columnArray);
            }

            @Deprecated
            public static TextTable forColumns(Ansi ansi, Column ... columnArray) {
                return new TextTable(ansi, columnArray);
            }

            public static TextTable forColumns(ColorScheme colorScheme, Column ... columnArray) {
                return new TextTable(colorScheme, columnArray);
            }

            @Deprecated
            protected TextTable(Ansi ansi, Column[] columnArray) {
                this(Help.defaultColorScheme(ansi), columnArray);
            }

            protected TextTable(ColorScheme colorScheme, Column[] columnArray) {
                this.colorScheme = Assert.notNull(colorScheme, "ansi");
                this.columns = (Column[])Assert.notNull(columnArray, "columns").clone();
                if (columnArray.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
                int n2 = 0;
                for (Column column : columnArray) {
                    n2 += column.width;
                }
                this.tableWidth = n2;
            }

            public boolean isAdjustLineBreaksForWideCJKCharacters() {
                return this.adjustLineBreaksForWideCJKCharacters;
            }

            public TextTable setAdjustLineBreaksForWideCJKCharacters(boolean bl2) {
                this.adjustLineBreaksForWideCJKCharacters = bl2;
                return this;
            }

            public Column[] columns() {
                return (Column[])this.columns.clone();
            }

            public Ansi.Text textAt(int n2, int n3) {
                return this.columnValues.get(n3 + n2 * this.columns.length);
            }

            @Deprecated
            public Ansi.Text cellAt(int n2, int n3) {
                return this.textAt(n2, n3);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (Column column : this.columns) {
                    Ansi ansi = this.colorScheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(column.width, this.colorScheme));
                }
            }

            public void addRowValues(String ... stringArray) {
                int n2 = stringArray.length;
                Ansi.Text[][] textArrayArray = new Ansi.Text[n2][];
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Ansi.Text[] textArray;
                    if (stringArray[i2] == null) {
                        Ansi.Text[] textArray2 = new Ansi.Text[1];
                        textArray = textArray2;
                        textArray2[0] = Ansi.EMPTY_TEXT;
                    } else {
                        textArray = this.colorScheme.text(stringArray[i2]).splitLines();
                    }
                    textArrayArray[i2] = textArray;
                    n3 = Math.max(n3, textArrayArray[i2].length);
                }
                Object[] objectArray = new Ansi.Text[n2];
                for (int i3 = 0; i3 < n3; ++i3) {
                    Arrays.fill(objectArray, Ansi.EMPTY_TEXT);
                    for (int i4 = 0; i4 < n2; ++i4) {
                        if (i3 >= textArrayArray[i4].length) continue;
                        objectArray[i4] = textArrayArray[i4][i3];
                    }
                    this.addRowValues((Ansi.Text[])objectArray);
                }
            }

            public void addRowValues(Ansi.Text ... textArray) {
                if (textArray.length > this.columns.length) {
                    throw new IllegalArgumentException(textArray.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                int n2 = this.unindent(textArray);
                for (int i2 = 0; i2 < textArray.length; ++i2) {
                    int n3 = this.rowCount() - 1;
                    Cell cell = this.putValue(n3, i2, textArray[i2]);
                    if (cell.row == n3 && cell.column == i2 || i2 == textArray.length - 1) continue;
                    this.addEmptyRow();
                }
                this.reindent(n2);
            }

            private int unindent(Ansi.Text[] textArray) {
                if (this.columns.length <= 3) {
                    return 0;
                }
                int n2 = this.columns[3].indent;
                if (Help.DEFAULT_SEPARATOR.equals(textArray[2].toString())) {
                    this.columns[3].indent = 0;
                }
                return n2;
            }

            private void reindent(int n2) {
                if (this.columns.length <= 3) {
                    return;
                }
                this.columns[3].indent = n2;
            }

            public Cell putValue(int n2, int n3, Ansi.Text text) {
                if (n2 > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + n2 + ": rowCount=" + this.rowCount());
                }
                if (text == null || text.plain.length() == 0) {
                    return new Cell(n3, n2);
                }
                Column column = this.columns[n3];
                int n4 = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        this.copy(text, this.textAt(n2, n3), n4);
                        return new Cell(n3, n2);
                    }
                    case SPAN: {
                        int n5 = n3;
                        do {
                            boolean bl2 = n3 == this.columns.length - 1;
                            int n6 = bl2 ? this.copy(BreakIterator.getLineInstance(), text, this.textAt(n2, n3), n4) : this.copy(text, this.textAt(n2, n3), n4);
                            text = text.substring(n6);
                            n4 = 0;
                            if (text.length > 0) {
                                ++n3;
                            }
                            if (text.length <= 0 || n3 < this.columns.length) continue;
                            this.addEmptyRow();
                            ++n2;
                            n3 = n5;
                            n4 = column.indent + this.indentWrappedLines;
                        } while (text.length > 0);
                        return new Cell(n3, n2);
                    }
                    case WRAP: {
                        BreakIterator breakIterator = BreakIterator.getLineInstance();
                        do {
                            int n7 = this.copy(breakIterator, text, this.textAt(n2, n3), n4);
                            text = text.substring(n7);
                            n4 = column.indent + this.indentWrappedLines;
                            if (text.length <= 0) continue;
                            ++n2;
                            this.addEmptyRow();
                        } while (text.length > 0);
                        return new Cell(n3, n2);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private int length(Ansi.Text text) {
                return text.getCJKAdjustedLength();
            }

            private int length(Ansi.Text text, int n2, int n3) {
                if (!this.adjustLineBreaksForWideCJKCharacters) {
                    return n3 - n2;
                }
                return text.getCJKAdjustedLength(n2, n3);
            }

            private int copy(BreakIterator breakIterator, Ansi.Text text, Ansi.Text text2, int n2) {
                breakIterator.setText(text.plainString().replace("-", "\u00ff"));
                Count count = new Count();
                int n3 = breakIterator.first();
                int n4 = breakIterator.next();
                while (n4 != -1) {
                    Ansi.Text text3 = text.substring(n3, n4);
                    if (text2.maxLength < n2 + count.columnCount + this.length(text3)) break;
                    this.copy(text3, text2, n2 + count.charCount, count);
                    n3 = n4;
                    n4 = breakIterator.next();
                }
                if (count.charCount == 0 && this.length(text) + n2 > text2.maxLength) {
                    this.copy(text, text2, n2, count);
                }
                return count.charCount;
            }

            private int copy(Ansi.Text text, Ansi.Text text2, int n2) {
                Count count = new Count();
                this.copy(text, text2, n2, count);
                return count.charCount;
            }

            private void copy(Ansi.Text text, Ansi.Text text2, int n2, Count count) {
                int n3 = Math.min(text.length, text2.maxLength - n2);
                text.getStyledChars(text.from, n3, text2, n2);
                count.columnCount += this.length(text, text.from, n3);
                count.charCount += n3;
            }

            public StringBuilder toString(StringBuilder stringBuilder) {
                int n2 = this.columns.length;
                StringBuilder stringBuilder2 = new StringBuilder(this.tableWidth);
                for (int i2 = 0; i2 < this.columnValues.size(); ++i2) {
                    int n3;
                    Ansi.Text text = this.columnValues.get(i2);
                    stringBuilder2.append(text.toString());
                    stringBuilder2.append(new String(Help.spaces(this.columns[i2 % n2].width - text.length)));
                    if (i2 % n2 != n2 - 1) continue;
                    for (n3 = stringBuilder2.length() - 1; n3 >= 0 && stringBuilder2.charAt(n3) == ' '; --n3) {
                    }
                    stringBuilder2.setLength(n3 + 1);
                    stringBuilder.append(stringBuilder2.toString()).append(System.getProperty("line.separator"));
                    stringBuilder2.setLength(0);
                }
                return stringBuilder;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            static class Count {
                int charCount;
                int columnCount;

                Count() {
                }
            }

            public static class Cell {
                public final int column;
                public final int row;

                public Cell(int n2, int n3) {
                    this.column = n2;
                    this.row = n3;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByOrder<T extends Model.IOrdered>
        implements Comparator<T> {
            SortByOrder() {
            }

            @Override
            public int compare(T t2, T t3) {
                return Integer.signum(t2.order() - t3.order());
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            public int compare(Model.OptionSpec optionSpec, Model.OptionSpec optionSpec2) {
                Range range = optionSpec.arity();
                Range range2 = optionSpec2.arity();
                int n2 = range.max - range2.max;
                if (n2 == 0) {
                    n2 = range.min - range2.min;
                }
                if (n2 == 0) {
                    if (optionSpec.isMultiValue() && !optionSpec2.isMultiValue()) {
                        n2 = 1;
                    }
                    if (!optionSpec.isMultiValue() && optionSpec2.isMultiValue()) {
                        n2 = -1;
                    }
                }
                return n2 == 0 ? super.compare(optionSpec, optionSpec2) : n2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Model.OptionSpec> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Model.OptionSpec optionSpec, Model.OptionSpec optionSpec2) {
                if (optionSpec == null) {
                    return 1;
                }
                if (optionSpec2 == null) {
                    return -1;
                }
                String[] stringArray = ShortestFirst.sort(optionSpec.names());
                String[] stringArray2 = ShortestFirst.sort(optionSpec2.names());
                String string = Model.CommandSpec.stripPrefix(stringArray[0]);
                String string2 = Model.CommandSpec.stripPrefix(stringArray2[0]);
                int n2 = string.toUpperCase().compareTo(string2.toUpperCase());
                int n3 = n2 = n2 == 0 ? -string.compareTo(string2) : n2;
                return optionSpec.help() == optionSpec2.help() ? n2 : (optionSpec2.help() ? -1 : 1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String string, String string2) {
                return string.length() - string2.length();
            }

            public static String[] sort(String[] stringArray) {
                Arrays.sort(stringArray, new ShortestFirst());
                return stringArray;
            }

            public static String[] longestFirst(String[] stringArray) {
                Arrays.sort(stringArray, Collections.reverseOrder(new ShortestFirst()));
                return stringArray;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme, int n2) {
                this(colorScheme, TextTable.forDefaultColumns(colorScheme, 24, n2));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(false, " "), new DefaultParameterRenderer(false, " "));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer iOptionRenderer, IParameterRenderer iParameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(iOptionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(iParameterRenderer, "parameterRenderer");
            }

            public void layout(Model.ArgSpec argSpec, Ansi.Text[][] textArray) {
                for (Ansi.Text[] textArray2 : textArray) {
                    this.table.addRowValues(textArray2);
                }
            }

            public void addOptions(List<Model.OptionSpec> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Model.OptionSpec optionSpec : list) {
                    if (optionSpec.hidden()) continue;
                    this.addOption(optionSpec, iParamLabelRenderer);
                }
            }

            public void addAllOptions(List<Model.OptionSpec> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Model.OptionSpec optionSpec : list) {
                    this.addOption(optionSpec, iParamLabelRenderer);
                }
            }

            public void addOption(Model.OptionSpec optionSpec, IParamLabelRenderer iParamLabelRenderer) {
                Ansi.Text[][] textArray = this.optionRenderer.render(optionSpec, iParamLabelRenderer, this.colorScheme);
                this.layout(optionSpec, textArray);
            }

            public void addPositionalParameters(List<Model.PositionalParamSpec> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Model.PositionalParamSpec positionalParamSpec : list) {
                    if (positionalParamSpec.hidden()) continue;
                    this.addPositionalParameter(positionalParamSpec, iParamLabelRenderer);
                }
            }

            public void addAllPositionalParameters(List<Model.PositionalParamSpec> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Model.PositionalParamSpec positionalParamSpec : list) {
                    this.addPositionalParameter(positionalParamSpec, iParamLabelRenderer);
                }
            }

            public void addPositionalParameter(Model.PositionalParamSpec positionalParamSpec, IParamLabelRenderer iParamLabelRenderer) {
                Ansi.Text[][] textArray = this.parameterRenderer.render(positionalParamSpec, iParamLabelRenderer, this.colorScheme);
                this.layout(positionalParamSpec, textArray);
            }

            public String toString() {
                return this.table.toString();
            }

            public ColorScheme colorScheme() {
                return this.colorScheme;
            }

            public TextTable textTable() {
                return this.table;
            }

            public IOptionRenderer optionRenderer() {
                return this.optionRenderer;
            }

            public IParameterRenderer parameterRenderer() {
                return this.parameterRenderer;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            private final Model.CommandSpec commandSpec;

            public DefaultParamLabelRenderer(Model.CommandSpec commandSpec) {
                this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            }

            @Override
            public String separator() {
                return this.commandSpec.parser().separator();
            }

            @Override
            public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> list) {
                String string;
                int n2;
                Ansi.Text text;
                ColorScheme colorScheme;
                Range range = argSpec.isOption() ? argSpec.arity() : ((Model.PositionalParamSpec)argSpec).capacity();
                ColorScheme colorScheme2 = colorScheme = this.commandSpec.commandLine() == null ? Help.defaultColorScheme(ansi) : this.commandSpec.commandLine().getColorScheme();
                if (range.max == 0) {
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    return ansi2.new Ansi.Text("", colorScheme);
                }
                if (argSpec.hideParamSyntax()) {
                    return colorScheme.apply((argSpec.isOption() ? this.separator() : "") + argSpec.paramLabel(), list);
                }
                String string2 = argSpec.splitRegex();
                if (!CommandLine.empty(string2)) {
                    string2 = CommandLine.empty(argSpec.splitRegexSynopsisLabel()) ? string2 : argSpec.splitRegexSynopsisLabel();
                }
                String string3 = CommandLine.empty(string2) ? " " : string2;
                String string4 = CommandLine.empty(string2) ? " [" : "[" + string2;
                boolean bl2 = !CommandLine.empty(string2) && !this.commandSpec.parser().limitSplit();
                boolean bl3 = !CommandLine.empty(string2) && this.commandSpec.parser().limitSplit();
                Ansi.Text text2 = text = colorScheme.apply(argSpec.paramLabel(), list);
                int n3 = 1;
                if (bl2) {
                    text2 = text.concat("[" + string2).concat(text).concat("...]");
                    ++n3;
                    string3 = " ";
                    string4 = " [";
                }
                Ansi.Text text3 = text2;
                for (int i2 = 1; i2 < range.min; ++i2) {
                    text3 = text3.concat(string3).concat(text2);
                    n3 += n3;
                }
                if (!range.isVariable) {
                    for (n2 = i2; n2 < range.max; ++n2) {
                        text3 = text3.concat(string4).concat(text);
                        ++n3;
                    }
                    for (n2 = i2; n2 < range.max; ++n2) {
                        text3 = text3.concat("]");
                    }
                }
                int n4 = n2 = range.isVariable || bl3 && n3 == 1 ? 1 : 0;
                if (bl3 && n2 != 0 && n3 == 1) {
                    text3 = text3.concat(string4).concat(text2).concat("]");
                }
                if (n2 != 0) {
                    if (!argSpec.arity().isVariable && argSpec.arity().min > 1) {
                        Ansi ansi3 = ansi;
                        ((Object)((Object)ansi3)).getClass();
                        text3 = ansi3.new Ansi.Text("(", colorScheme).concat(text3).concat(")");
                    }
                    text3 = text3.concat("...");
                }
                String string5 = string = argSpec.isOption() ? this.separator() : "";
                if (range.min == 0) {
                    String string6 = CommandLine.empty(string.trim()) ? string + "[" : "[" + string;
                    Ansi ansi4 = ansi;
                    ((Object)((Object)ansi4)).getClass();
                    text3 = ansi4.new Ansi.Text(string6, colorScheme).concat(text3).concat("]");
                } else {
                    Ansi ansi5 = ansi;
                    ((Object)((Object)ansi5)).getClass();
                    text3 = ansi5.new Ansi.Text(string, colorScheme).concat(text3);
                }
                return text3;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Model.ArgSpec var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            private final String requiredMarker;
            private final boolean showDefaultValues;

            public DefaultParameterRenderer(boolean bl2, String string) {
                this.showDefaultValues = bl2;
                this.requiredMarker = Assert.notNull(string, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec positionalParamSpec, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                int n2;
                Ansi.Text text = iParamLabelRenderer.renderParameterLabel(positionalParamSpec, colorScheme.ansi(), colorScheme.parameterStyles);
                Ansi.Text text2 = colorScheme.parameterText(positionalParamSpec.arity().min > 0 ? this.requiredMarker : "");
                Ansi.Text text3 = Ansi.EMPTY_TEXT;
                boolean[] blArray = new boolean[]{positionalParamSpec.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                String[] stringArray = positionalParamSpec.description();
                Ansi.Text[] textArray = Help.createDescriptionFirstLines(colorScheme, positionalParamSpec, stringArray, blArray);
                arrayList.add(new Ansi.Text[]{text2, text3, text3, text, textArray[0]});
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, textArray[n2]});
                }
                for (n2 = 1; n2 < stringArray.length; ++n2) {
                    Ansi.Text[] textArray2;
                    Ansi ansi = colorScheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    for (Ansi.Text text4 : textArray2 = ansi.new Ansi.Text(stringArray[n2], colorScheme).splitLines()) {
                        arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, text4});
                    }
                }
                if (blArray[0]) {
                    Help.addTrailingDefaultLine(arrayList, positionalParamSpec, colorScheme);
                }
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Model.PositionalParamSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec positionalParamSpec, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = iParamLabelRenderer.renderParameterLabel(positionalParamSpec, colorScheme.ansi(), colorScheme.parameterStyles);
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(positionalParamSpec.description().length == 0 ? "" : positionalParamSpec.description()[0], colorScheme);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            public Ansi.Text[][] render(Model.OptionSpec optionSpec, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                Ansi.Text text = optionSpec.negatable() ? colorScheme.optionText(optionSpec.commandSpec.negatableOptionTransformer().makeSynopsis(optionSpec.names()[0], optionSpec.commandSpec)) : colorScheme.optionText(optionSpec.names()[0]);
                Ansi.Text text2 = iParamLabelRenderer.renderParameterLabel(optionSpec, colorScheme.ansi(), colorScheme.optionParamStyles);
                text = text.concat(text2);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = text;
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(optionSpec.description().length == 0 ? "" : optionSpec.description()[0], colorScheme);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            private final String requiredMarker;
            private final boolean showDefaultValues;
            private String sep;

            public DefaultOptionRenderer(boolean bl2, String string) {
                this.showDefaultValues = bl2;
                this.requiredMarker = Assert.notNull(string, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.OptionSpec optionSpec, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                Object object;
                String[] stringArray = ShortestFirst.sort(optionSpec.names());
                int n2 = stringArray[0].length() == 2 ? 1 : 0;
                String string = n2 > 0 ? stringArray[0] : "";
                String string2 = this.sep = n2 > 0 && stringArray.length > 1 ? "," : "";
                if (optionSpec.negatable()) {
                    object = optionSpec.commandSpec.negatableOptionTransformer();
                    if (n2 > 0) {
                        string = object.makeSynopsis(string, optionSpec.commandSpec);
                    }
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = object.makeSynopsis(stringArray[i2], optionSpec.commandSpec);
                    }
                }
                object = Help.join(stringArray, n2, stringArray.length - n2, ", ");
                Ansi.Text text = this.createLongOptionText(optionSpec, iParamLabelRenderer, colorScheme, (String)object);
                String string3 = !optionSpec.originallyRequired() && optionSpec.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines(optionSpec, colorScheme, string3, string, text);
            }

            private Ansi.Text createLongOptionText(Model.OptionSpec optionSpec, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme, String string) {
                Ansi.Text text = iParamLabelRenderer.renderParameterLabel(optionSpec, colorScheme.ansi(), colorScheme.optionParamStyles);
                if (text.length > 0 && string.length() == 0) {
                    this.sep = iParamLabelRenderer.separator();
                    int n2 = text.plainString().indexOf(this.sep);
                    Ansi.Text text2 = text.substring(0, n2);
                    text = text2.concat(text.substring(n2 + this.sep.length()));
                }
                Ansi.Text text3 = colorScheme.optionText(string);
                text3 = text3.concat(text);
                return text3;
            }

            private Ansi.Text[][] renderDescriptionLines(Model.OptionSpec optionSpec, ColorScheme colorScheme, String string, String string2, Ansi.Text text) {
                int n2;
                Ansi.Text text2 = Ansi.EMPTY_TEXT;
                boolean[] blArray = new boolean[]{optionSpec.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                String[] stringArray = optionSpec.description();
                Ansi.Text[] textArray = Help.createDescriptionFirstLines(colorScheme, optionSpec, stringArray, blArray);
                Ansi.Text[] textArray2 = new Ansi.Text[5];
                textArray2[0] = colorScheme.optionText(string);
                textArray2[1] = colorScheme.optionText(string2);
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[2] = ansi.new Ansi.Text(this.sep, colorScheme);
                textArray2[3] = text;
                textArray2[4] = textArray[0];
                arrayList.add(textArray2);
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text2, text2, text2, text2, textArray[n2]});
                }
                for (n2 = 1; n2 < stringArray.length; ++n2) {
                    Ansi.Text[] textArray3;
                    Ansi ansi2 = colorScheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text text3 : textArray3 = ansi2.new Ansi.Text(stringArray[n2], colorScheme).splitLines()) {
                        arrayList.add(new Ansi.Text[]{text2, text2, text2, text2, text3});
                    }
                }
                if (blArray[0]) {
                    Help.addTrailingDefaultLine(arrayList, optionSpec, colorScheme);
                }
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Model.OptionSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Visibility {
            ALWAYS,
            NEVER,
            ON_DEMAND;

        }
    }

    public static interface IHelpSectionRenderer {
        public String render(Help var1);
    }

    public static interface IHelpCommandInitializable2 {
        public void init(CommandLine var1, Help.ColorScheme var2, PrintWriter var3, PrintWriter var4);
    }

    @Deprecated
    public static interface IHelpCommandInitializable {
        @Deprecated
        public void init(CommandLine var1, Help.Ansi var2, PrintStream var3, PrintStream var4);
    }

    @Command(name="help", header={"Display help information about the specified command."}, synopsisHeading="%nUsage: ", helpCommand=true, description={"%nWhen no COMMAND is given, the usage help for the main command is displayed.", "If a COMMAND is specified, the help for that command is shown.%n"})
    public static final class HelpCommand
    implements IHelpCommandInitializable,
    IHelpCommandInitializable2,
    Runnable {
        @Option(names={"-h", "--help"}, usageHelp=true, descriptionKey="helpCommand.help", description={"Show usage help for the help command and exit."})
        private boolean helpRequested;
        @Parameters(paramLabel="COMMAND", arity="0..1", descriptionKey="helpCommand.command", description={"The COMMAND to display the usage help message for."})
        private String commands;
        private CommandLine self;
        private PrintStream out;
        private PrintStream err;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private Help.Ansi ansi;
        private Help.ColorScheme colorScheme;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Help.ColorScheme colorScheme;
            CommandLine commandLine;
            if (this.self == null) {
                return;
            }
            CommandLine commandLine2 = commandLine = this.self.getParent();
            if (commandLine == null) {
                return;
            }
            Help.ColorScheme colorScheme2 = colorScheme = this.colorScheme != null ? this.colorScheme : Help.defaultColorScheme(this.ansi);
            if (this.commands != null) {
                Map<String, CommandLine> map = commandLine.getCommandSpec().subcommands();
                CommandLine commandLine3 = map.get(this.commands);
                if (commandLine3 == null && commandLine.isAbbreviatedSubcommandsAllowed()) {
                    commandLine3 = AbbreviationMatcher.match(map, this.commands, commandLine.isSubcommandsCaseInsensitive(), this.self).getValue();
                }
                if (commandLine3 == null) throw new ParameterException(commandLine, "Unknown subcommand '" + this.commands + "'.", null, this.commands);
                if (this.outWriter != null) {
                    commandLine3.usage(this.outWriter, colorScheme);
                    return;
                } else {
                    commandLine3.usage(this.out, colorScheme);
                }
                return;
            } else if (this.outWriter != null) {
                commandLine.usage(this.outWriter, colorScheme);
                return;
            } else {
                commandLine.usage(this.out, colorScheme);
            }
        }

        @Deprecated
        public void init(CommandLine commandLine, Help.Ansi ansi, PrintStream printStream, PrintStream printStream2) {
            this.self = Assert.notNull(commandLine, "helpCommandLine");
            this.ansi = Assert.notNull(ansi, "ansi");
            this.out = Assert.notNull(printStream, "out");
            this.err = Assert.notNull(printStream2, "err");
        }

        public void init(CommandLine commandLine, Help.ColorScheme colorScheme, PrintWriter printWriter, PrintWriter printWriter2) {
            this.self = Assert.notNull(commandLine, "helpCommandLine");
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
            this.outWriter = Assert.notNull(printWriter, "outWriter");
            this.errWriter = Assert.notNull(printWriter2, "errWriter");
        }
    }

    static class AutoHelpMixin {
        private static final String KEY = "mixinStandardHelpOptions";
        @Option(names={"${picocli.help.name.0:--h}", "${picocli.help.name.1:---help}"}, usageHelp=true, descriptionKey="mixinStandardHelpOptions.help", description={"Show this help message and exit."})
        private boolean helpRequested;
        @Option(names={"${picocli.version.name.0:--V}", "${picocli.version.name.1:---version}"}, versionHelp=true, descriptionKey="mixinStandardHelpOptions.version", description={"Print version information and exit."})
        private boolean versionRequested;

        AutoHelpMixin() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuiltIn {
        static Set<String> traced = new HashSet<String>();

        private static TypeConversionException fail(String string, Class<?> clazz) {
            return BuiltIn.fail(string, clazz, "'%s' is not a %s");
        }

        private static TypeConversionException fail(String string, Class<?> clazz, String string2) {
            return new TypeConversionException(String.format(string2, string, clazz.getSimpleName()));
        }

        static void handle(Exception exception, String string) {
            Tracer tracer = CommandLine.tracer();
            if (!traced.contains(string)) {
                tracer.debug("Could not register converter for %s: %s", string, exception.toString());
            }
            traced.add(string);
        }

        static boolean excluded(String string) {
            String[] stringArray;
            Tracer tracer = CommandLine.tracer();
            for (String string2 : stringArray = System.getProperty("picocli.converters.excludes", "").split(",")) {
                if (!string.matches(string2)) continue;
                tracer.debug("BuiltIn type converter for %s is not loaded: (picocli.converters.excludes=%s)", string, System.getProperty("picocli.converters.excludes"));
                return true;
            }
            return false;
        }

        private BuiltIn() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ReflectionConverter
        implements ITypeConverter<Object> {
            private final Method method;
            private final Class<?>[] paramTypes;

            public ReflectionConverter(Method method, Class<?> ... classArray) {
                this.method = Assert.notNull(method, "method");
                this.paramTypes = Assert.notNull(classArray, "paramTypes");
            }

            @Override
            public Object convert(String string) {
                try {
                    if (this.paramTypes.length > 1) {
                        return this.method.invoke(null, string, new String[0]);
                    }
                    return this.method.invoke(null, string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new TypeConversionException(String.format("cannot convert '%s' to %s (%s)", string, this.method.getReturnType(), invocationTargetException.getTargetException()));
                }
                catch (Exception exception) {
                    throw new TypeConversionException(String.format("Internal error converting '%s' to %s (%s)", string, this.method.getReturnType(), exception));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NetworkInterfaceConverter
        implements ITypeConverter<NetworkInterface> {
            NetworkInterfaceConverter() {
            }

            @Override
            public NetworkInterface convert(String string) throws Exception {
                try {
                    InetAddress inetAddress = new InetAddressConverter().convert(string);
                    return NetworkInterface.getByInetAddress(inetAddress);
                }
                catch (Exception exception) {
                    try {
                        return NetworkInterface.getByName(string);
                    }
                    catch (Exception exception2) {
                        throw new TypeConversionException("'" + string + "' is not an InetAddress or NetworkInterface name");
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ClassConverter
        implements ITypeConverter<Class<?>> {
            ClassConverter() {
            }

            @Override
            public Class<?> convert(String string) throws Exception {
                return Class.forName(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteOrderConverter
        implements ITypeConverter<ByteOrder> {
            ByteOrderConverter() {
            }

            @Override
            public ByteOrder convert(String string) throws Exception {
                if (string.equalsIgnoreCase(ByteOrder.BIG_ENDIAN.toString())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                if (string.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString())) {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                throw new TypeConversionException("'" + string + "' is not a valid ByteOrder");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TimeZoneConverter
        implements ITypeConverter<TimeZone> {
            TimeZoneConverter() {
            }

            @Override
            public TimeZone convert(String string) throws Exception {
                return TimeZone.getTimeZone(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CurrencyConverter
        implements ITypeConverter<Currency> {
            CurrencyConverter() {
            }

            @Override
            public Currency convert(String string) throws Exception {
                return Currency.getInstance(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String string) throws Exception {
                return UUID.fromString(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String string) {
                return Pattern.compile(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String string) throws Exception {
                return InetAddress.getByName(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String string) {
                return Charset.forName(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String string) {
                return new BigInteger(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String string) {
                return new BigDecimal(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601TimeConverter
        implements ITypeConverter<Object> {
            private final Constructor<?> constructor;

            ISO8601TimeConverter(Constructor<?> constructor) {
                this.constructor = Assert.notNull(constructor, "time class constructor");
            }

            @Override
            public Object convert(String string) {
                try {
                    if (string.length() <= 5) {
                        return this.createTime(new SimpleDateFormat("HH:mm").parse(string).getTime());
                    }
                    if (string.length() <= 8) {
                        return this.createTime(new SimpleDateFormat("HH:mm:ss").parse(string).getTime());
                    }
                    if (string.length() <= 12) {
                        try {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss.SSS").parse(string).getTime());
                        }
                        catch (ParseException parseException) {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss,SSS").parse(string).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                throw new TypeConversionException("'" + string + "' is not a HH:mm[:ss[.SSS]] time");
            }

            private Object createTime(long l2) {
                try {
                    return this.constructor.newInstance(l2);
                }
                catch (Exception exception) {
                    throw new TypeConversionException("Unable to create new java.sql.Time with long value " + l2 + ": " + exception.getMessage());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String string) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(string);
                }
                catch (ParseException parseException) {
                    throw new TypeConversionException("'" + string + "' is not a yyyy-MM-dd date");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String string) throws URISyntaxException {
                return new URI(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String string) throws MalformedURLException {
                return new URL(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String string) {
                return new File(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String string) {
                try {
                    return Double.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Double.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String string) {
                try {
                    return Float.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Float.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String string) {
                try {
                    return Long.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Long.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String string) {
                try {
                    return Integer.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Integer.TYPE, "'%s' is not an %s");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String string) {
                try {
                    return Short.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Short.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String string) {
                try {
                    return Byte.valueOf(string);
                }
                catch (Exception exception) {
                    throw BuiltIn.fail(string, Byte.TYPE);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String string) {
                if (string.length() > 1) {
                    throw new TypeConversionException("'" + string + "' is not a single character");
                }
                return Character.valueOf(string.charAt(0));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String string) {
                if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                    return Boolean.parseBoolean(string);
                }
                throw new TypeConversionException("'" + string + "' is not a boolean");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String string) {
                return string;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String string) {
                return new StringBuilder(string);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String string) {
                return string;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharArrayConverter
        implements ITypeConverter<char[]> {
            CharArrayConverter() {
            }

            @Override
            public char[] convert(String string) {
                return string.toCharArray();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PositionalParametersSorter
    implements Comparator<Model.ArgSpec> {
        private static final Range OPTION_INDEX = new Range(0, 0, false, true, "0");

        PositionalParametersSorter() {
        }

        @Override
        public int compare(Model.ArgSpec argSpec, Model.ArgSpec argSpec2) {
            int n2 = this.index(argSpec).compareTo(this.index(argSpec2));
            return n2 == 0 ? argSpec.arity().compareTo(argSpec2.arity()) : n2;
        }

        private Range index(Model.ArgSpec argSpec) {
            return argSpec.isOption() ? OPTION_INDEX : ((Model.PositionalParamSpec)argSpec).index();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Interpreter {
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private boolean isHelpRequested;
        private int position;
        private int interactiveCount;
        private boolean endOfOptions;
        private ParseResult.Builder parseResultBuilder;

        Interpreter() {
            this.registerBuiltInConverters();
        }

        private void registerBuiltInConverters() {
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(char[].class, new BuiltIn.CharArrayConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.converterRegistry.put(Currency.class, new BuiltIn.CurrencyConverter());
            this.converterRegistry.put(TimeZone.class, new BuiltIn.TimeZoneConverter());
            this.converterRegistry.put(ByteOrder.class, new BuiltIn.ByteOrderConverter());
            this.converterRegistry.put(Class.class, new BuiltIn.ClassConverter());
            this.converterRegistry.put(NetworkInterface.class, new BuiltIn.NetworkInterfaceConverter());
            if (!this.excl("java.sql.Time")) {
                try {
                    this.reg(Class.forName("java.sql.Time"), new BuiltIn.ISO8601TimeConverter(Class.forName("java.sql.Time").getDeclaredConstructor(Long.TYPE)));
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.sql.Time");
                }
            }
            if (!this.excl("java.sql.Connection")) {
                try {
                    this.reg(Class.forName("java.sql.Connection"), Class.forName("java.sql.DriverManager").getDeclaredMethod("getConnection", String.class), String.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.sql.Connection");
                }
            }
            if (!this.excl("java.sql.Driver")) {
                try {
                    this.reg(Class.forName("java.sql.Driver"), Class.forName("java.sql.DriverManager").getDeclaredMethod("getDriver", String.class), String.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.sql.DriverManager");
                }
            }
            if (!this.excl("java.sql.Timestamp")) {
                try {
                    this.reg(Class.forName("java.sql.Timestamp"), Class.forName("java.sql.Timestamp").getDeclaredMethod("valueOf", String.class), String.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.sql.Timestamp");
                }
            }
            if (!this.excl("java.time.Duration")) {
                try {
                    this.reg(Class.forName("java.time.Duration"), Class.forName("java.time.Duration").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.Duration");
                }
            }
            if (!this.excl("java.time.Instant")) {
                try {
                    this.reg(Class.forName("java.time.Instant"), Class.forName("java.time.Instant").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.Instant");
                }
            }
            if (!this.excl("java.time.LocalDate")) {
                try {
                    this.reg(Class.forName("java.time.LocalDate"), Class.forName("java.time.LocalDate").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.LocalDate");
                }
            }
            if (!this.excl("java.time.LocalDateTime")) {
                try {
                    this.reg(Class.forName("java.time.LocalDateTime"), Class.forName("java.time.LocalDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.LocalDateTime");
                }
            }
            if (!this.excl("java.time.LocalTime")) {
                try {
                    this.reg(Class.forName("java.time.LocalTime"), Class.forName("java.time.LocalTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.LocalTime");
                }
            }
            if (!this.excl("java.time.MonthDay")) {
                try {
                    this.reg(Class.forName("java.time.MonthDay"), Class.forName("java.time.MonthDay").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.MonthDay");
                }
            }
            if (!this.excl("java.time.OffsetDateTime")) {
                try {
                    this.reg(Class.forName("java.time.OffsetDateTime"), Class.forName("java.time.OffsetDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.OffsetDateTime");
                }
            }
            if (!this.excl("java.time.OffsetTime")) {
                try {
                    this.reg(Class.forName("java.time.OffsetTime"), Class.forName("java.time.OffsetTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.OffsetTime");
                }
            }
            if (!this.excl("java.time.Period")) {
                try {
                    this.reg(Class.forName("java.time.Period"), Class.forName("java.time.Period").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.Period");
                }
            }
            if (!this.excl("java.time.Year")) {
                try {
                    this.reg(Class.forName("java.time.Year"), Class.forName("java.time.Year").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.Year");
                }
            }
            if (!this.excl("java.time.YearMonth")) {
                try {
                    this.reg(Class.forName("java.time.YearMonth"), Class.forName("java.time.YearMonth").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.YearMonth");
                }
            }
            if (!this.excl("java.time.ZonedDateTime")) {
                try {
                    this.reg(Class.forName("java.time.ZonedDateTime"), Class.forName("java.time.ZonedDateTime").getDeclaredMethod("parse", CharSequence.class), CharSequence.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.ZonedDateTime");
                }
            }
            if (!this.excl("java.time.ZoneId")) {
                try {
                    this.reg(Class.forName("java.time.ZoneId"), Class.forName("java.time.ZoneId").getDeclaredMethod("of", String.class), String.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.ZoneId");
                }
            }
            if (!this.excl("java.time.ZoneOffset")) {
                try {
                    this.reg(Class.forName("java.time.ZoneOffset"), Class.forName("java.time.ZoneOffset").getDeclaredMethod("of", String.class), String.class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.time.ZoneOffset");
                }
            }
            if (!this.excl("java.nio.file.Path")) {
                try {
                    this.reg(Class.forName("java.nio.file.Path"), Class.forName("java.nio.file.Paths").getDeclaredMethod("get", String.class, String[].class), String.class, String[].class);
                }
                catch (Exception exception) {
                    BuiltIn.handle(exception, "java.nio.file.Path");
                }
            }
        }

        private boolean excl(String string) {
            return BuiltIn.excluded(string);
        }

        private void reg(Class<?> clazz, Method method, Class<?> ... classArray) {
            this.converterRegistry.put(clazz, new BuiltIn.ReflectionConverter(method, classArray));
        }

        private void reg(Class<?> clazz, BuiltIn.ISO8601TimeConverter iSO8601TimeConverter) {
            this.converterRegistry.put(clazz, iSO8601TimeConverter);
        }

        private Model.ParserSpec config() {
            return CommandLine.this.commandSpec.parser();
        }

        List<CommandLine> parse(String ... stringArray) {
            Assert.notNull(stringArray, "argument array");
            Tracer tracer = CommandLine.tracer();
            if (tracer.isInfo()) {
                tracer.info("Picocli version: %s", CommandLine.versionString());
            }
            if (tracer.isInfo()) {
                tracer.info("Parsing %d command line args %s", stringArray.length, Arrays.toString(stringArray));
            }
            if (tracer.isDebug()) {
                tracer.debug("Parser configuration: optionsCaseInsensitive=%s, subcommandsCaseInsensitive=%s, %s", CommandLine.this.commandSpec.optionsCaseInsensitive(), CommandLine.this.commandSpec.subcommandsCaseInsensitive(), this.config());
            }
            if (tracer.isDebug()) {
                tracer.debug("(ANSI is %s by default: systemproperty[picocli.ansi]=%s, isatty=%s, TERM=%s, OSTYPE=%s, isWindows=%s, JansiConsoleInstalled=%s, ANSICON=%s, ConEmuANSI=%s, NO_COLOR=%s, CLICOLOR=%s, CLICOLOR_FORCE=%s)", Help.Ansi.AUTO.enabled() ? "enabled" : "disabled", System.getProperty("picocli.ansi"), Help.Ansi.isTTY(), System.getenv("TERM"), System.getenv("OSTYPE"), Help.Ansi.isWindows(), Help.Ansi.isJansiConsoleInstalled(), System.getenv("ANSICON"), System.getenv("ConEmuANSI"), System.getenv("NO_COLOR"), System.getenv("CLICOLOR"), System.getenv("CLICOLOR_FORCE"));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                this.addOrExpand(string, arrayList, new LinkedHashSet<String>());
            }
            Stack stack = new Stack();
            stack.addAll(CommandLine.reverseList(arrayList));
            ArrayList<CommandLine> arrayList2 = new ArrayList<CommandLine>();
            this.parse(arrayList2, stack, stringArray, new ArrayList<Object>(), new HashSet<Model.ArgSpec>());
            return arrayList2;
        }

        private void addOrExpand(String string, List<String> list, Set<String> set) {
            if (this.config().expandAtFiles() && !string.equals("@") && string.startsWith("@")) {
                string = string.substring(1);
                Tracer tracer = CommandLine.tracer();
                if (string.startsWith("@")) {
                    if (tracer.isInfo()) {
                        tracer.info("Not expanding @-escaped argument %s (trimmed leading '@' char)", string);
                    }
                } else {
                    if (tracer.isInfo()) {
                        tracer.info("Expanding argument file @%s", string);
                    }
                    this.expandArgumentFile(string, list, set);
                    return;
                }
            }
            list.add(string);
        }

        private void expandArgumentFile(String string, List<String> list, Set<String> set) {
            Tracer tracer = CommandLine.tracer();
            File file = new File(string);
            if (!file.canRead()) {
                if (tracer.isInfo()) {
                    tracer.info("File %s does not exist or cannot be read; treating argument literally", string);
                }
                list.add("@" + string);
            } else if (set.contains(file.getAbsolutePath())) {
                if (tracer.isInfo()) {
                    tracer.info("Already visited file %s; ignoring...", file.getAbsolutePath());
                }
            } else {
                this.expandValidArgumentFile(string, file, list, set);
            }
        }

        private void expandValidArgumentFile(String string, File file, List<String> list, Set<String> set) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            LineNumberReader lineNumberReader = null;
            try {
                set.add(file.getAbsolutePath());
                lineNumberReader = new LineNumberReader(new FileReader(file));
                if (CommandLine.this.commandSpec.parser().useSimplifiedAtFiles()) {
                    while ((object = lineNumberReader.readLine()) != null) {
                        if (((String)object).length() <= 0 || ((String)object).trim().startsWith(String.valueOf(CommandLine.this.commandSpec.parser().atFileCommentChar()))) continue;
                        this.addOrExpand((String)object, arrayList, set);
                    }
                } else {
                    object = new StreamTokenizer(lineNumberReader);
                    ((StreamTokenizer)object).resetSyntax();
                    ((StreamTokenizer)object).wordChars(32, 255);
                    ((StreamTokenizer)object).whitespaceChars(0, 32);
                    ((StreamTokenizer)object).quoteChar(34);
                    ((StreamTokenizer)object).quoteChar(39);
                    if (CommandLine.this.commandSpec.parser().atFileCommentChar() != null) {
                        ((StreamTokenizer)object).commentChar(CommandLine.this.commandSpec.parser().atFileCommentChar().charValue());
                    }
                    while (((StreamTokenizer)object).nextToken() != -1) {
                        this.addOrExpand(((StreamTokenizer)object).sval, arrayList, set);
                    }
                }
            }
            catch (Exception exception) {
                try {
                    throw new InitializationException("Could not read argument file @" + string, exception);
                }
                catch (Throwable throwable) {
                    CommandLine.close(lineNumberReader);
                    throw throwable;
                }
            }
            CommandLine.close(lineNumberReader);
            object = CommandLine.tracer();
            if (((Tracer)object).isInfo()) {
                ((Tracer)object).info("Expanded file @%s to arguments %s", string, arrayList);
            }
            list.addAll(arrayList);
        }

        private void clear() {
            CommandLine.this.getCommandSpec().userObject();
            this.position = 0;
            this.endOfOptions = false;
            this.isHelpRequested = false;
            this.parseResultBuilder = ParseResult.builder(CommandLine.this.getCommandSpec());
            for (Model.OptionSpec object : CommandLine.this.getCommandSpec().options()) {
                this.clear(object);
            }
            for (Model.PositionalParamSpec positionalParamSpec : CommandLine.this.getCommandSpec().positionalParameters()) {
                this.clear(positionalParamSpec);
            }
            for (Model.ArgGroupSpec argGroupSpec : CommandLine.this.getCommandSpec().argGroups()) {
                this.clear(argGroupSpec);
            }
            for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                unmatchedArgsBinding.clear();
            }
        }

        private void clear(Model.ArgSpec argSpec) {
            argSpec.resetStringValues();
            argSpec.resetOriginalStringValues();
            argSpec.typedValues.clear();
            argSpec.typedValueAtPosition.clear();
            if (argSpec.inherited()) {
                CommandLine.tracer().debug("Not applying initial value for inherited %s", CommandLine.optionDescription("", argSpec, -1));
            } else if (argSpec.group() == null) {
                argSpec.applyInitialValue();
            }
        }

        private void clear(Model.ArgGroupSpec argGroupSpec) {
            for (Model.ArgSpec object : argGroupSpec.args()) {
                this.clear(object);
            }
            for (Model.ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups()) {
                this.clear(argGroupSpec2);
            }
        }

        void maybeThrow(PicocliException picocliException) throws PicocliException {
            if (!CommandLine.this.commandSpec.parser().collectErrors) {
                throw picocliException;
            }
            this.parseResultBuilder.addError(picocliException);
        }

        private void parse(List<CommandLine> list, Stack<String> stack, String[] stringArray, List<Object> list2, Collection<Model.ArgSpec> collection) {
            this.parse(list, stack, stringArray, list2, collection, new LinkedHashSet<Model.ArgSpec>());
        }

        private void parse(List<CommandLine> list, Stack<String> stack, String[] stringArray, List<Object> list2, Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set) {
            int n2;
            Tracer tracer = CommandLine.tracer();
            if (tracer.isDebug()) {
                tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d groups, %d subcommands.", CommandLine.this.commandSpec.toString(), new HashSet<Model.OptionSpec>(CommandLine.this.commandSpec.optionsMap().values()).size(), CommandLine.this.commandSpec.positionalParameters().size(), CommandLine.this.commandSpec.requiredArgs().size(), CommandLine.this.commandSpec.argGroups().size(), CommandLine.this.commandSpec.subcommands().size());
            }
            this.clear();
            list.add(CommandLine.this);
            ArrayList<Model.ArgSpec> arrayList = new ArrayList<Model.ArgSpec>(CommandLine.this.commandSpec.requiredArgs());
            this.addPostponedRequiredArgs(collection, arrayList);
            Collections.sort(arrayList, new PositionalParametersSorter());
            boolean bl2 = CommandLine.this.commandSpec.parser().collectErrors();
            Map map = CommandLine.mapOf("versionHelpRequested", this.parseResultBuilder.versionHelpRequested, new Object[]{"usageHelpRequested", this.parseResultBuilder.usageHelpRequested});
            if (CommandLine.this.commandSpec.preprocessor().preprocess(stack, CommandLine.this.commandSpec, null, map)) {
                this.parseResultBuilder.versionHelpRequested = (Boolean)map.get("versionHelpRequested");
                this.parseResultBuilder.usageHelpRequested = (Boolean)map.get("usageHelpRequested");
                return;
            }
            do {
                n2 = stack.size();
                try {
                    this.processArguments(list, stack, arrayList, set, stringArray, list2);
                    this.applyDefaultValues(arrayList, set);
                }
                catch (InitializationException initializationException) {
                    this.maybeThrow(initializationException);
                }
                catch (ParameterException parameterException) {
                    this.maybeThrow(parameterException);
                }
                catch (Exception exception) {
                    int n3 = stringArray.length - stack.size() - 1;
                    String string = n3 >= 0 && n3 < stringArray.length ? stringArray[n3] : "?";
                    this.maybeThrow(ParameterException.create(CommandLine.this, exception, string, n3, stringArray));
                }
                if (!bl2 || n2 != stack.size() || n2 <= 0) continue;
                this.parseResultBuilder.addUnmatched(this.parseResultBuilder.totalArgCount() - stack.size(), stack.pop());
            } while (!stack.isEmpty() && bl2);
            n2 = this.isAnyHelpRequested() ? 1 : 0;
            CommandLine commandLine = CommandLine.this;
            while (commandLine.getParent() != null) {
                commandLine = commandLine.getParent();
                n2 |= commandLine.interpreter.isAnyHelpRequested();
            }
            if (n2 == 0) {
                this.validateConstraints(stack, arrayList, set);
            }
        }

        private void addPostponedRequiredArgs(Collection<Model.ArgSpec> collection, List<Model.ArgSpec> list) {
            for (Model.ArgSpec argSpec : collection) {
                Model.ArgSpec argSpec2;
                if (argSpec.isOption()) {
                    argSpec2 = CommandLine.this.commandSpec.findOption(((Model.OptionSpec)argSpec).longestName());
                    Assert.notNull(argSpec2, "inherited option " + argSpec);
                    list.add(argSpec2);
                    continue;
                }
                argSpec2 = (Model.PositionalParamSpec)argSpec;
                for (Model.PositionalParamSpec positionalParamSpec : CommandLine.this.commandSpec.positionalParameters()) {
                    if (!positionalParamSpec.inherited() || !positionalParamSpec.index().equals(((Model.PositionalParamSpec)argSpec2).index()) || !positionalParamSpec.arity().equals(argSpec2.arity()) || !positionalParamSpec.typeInfo().equals(argSpec2.typeInfo()) || !Assert.equals(positionalParamSpec.paramLabel(), argSpec2.paramLabel()) || !Assert.equals(positionalParamSpec.hideParamSyntax(), argSpec2.hideParamSyntax()) || !Assert.equals(positionalParamSpec.required(), argSpec2.required()) || !Assert.equals(positionalParamSpec.splitRegex(), argSpec2.splitRegex()) || !Arrays.equals(positionalParamSpec.description(), argSpec2.description()) || !Assert.equals(positionalParamSpec.descriptionKey(), argSpec2.descriptionKey()) || !Assert.equals(positionalParamSpec.parameterConsumer(), argSpec2.parameterConsumer())) continue;
                    list.add(positionalParamSpec);
                }
            }
        }

        private void validateConstraints(Stack<String> stack, List<Model.ArgSpec> list, Set<Model.ArgSpec> set) {
            String[] stringArray;
            if (!list.isEmpty()) {
                for (Model.ArgSpec object : list) {
                    Assert.assertTrue(object.group() == null, "Arguments in a group are not necessarily required for the command");
                    if (object.isOption()) {
                        this.maybeThrow(MissingParameterException.create(CommandLine.this, list, this.config().separator()));
                        continue;
                    }
                    this.assertNoMissingParameters(object, object.arity(), stack);
                }
            }
            if (!this.parseResultBuilder.unmatched.isEmpty()) {
                Tracer tracer;
                stringArray = this.parseResultBuilder.unmatched.toArray(new String[0]);
                for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                    unmatchedArgsBinding.addAll((String[])stringArray.clone());
                }
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    this.maybeThrow(new UnmatchedArgumentException(CommandLine.this, Collections.unmodifiableList(this.parseResultBuilder.unmatched)));
                }
                if ((tracer = CommandLine.tracer()).isInfo()) {
                    tracer.info("Unmatched arguments: %s", this.parseResultBuilder.unmatched);
                }
            }
            stringArray = this.parseResultBuilder.build();
            stringArray.validateGroups();
        }

        private void applyDefaultValues(List<Model.ArgSpec> list, Set<Model.ArgSpec> set) throws Exception {
            this.parseResultBuilder.isInitializingDefaultValues = true;
            Tracer tracer = CommandLine.tracer();
            tracer.debug("Applying default values for command '%s'", CommandLine.this.commandSpec.qualifiedName());
            for (Model.ArgSpec object : CommandLine.this.commandSpec.args()) {
                if (object.group() != null || set.contains(object)) continue;
                if (object.inherited()) {
                    tracer.debug("Not applying default value for inherited %s", CommandLine.optionDescription("", object, -1));
                    continue;
                }
                if (!this.applyDefault(CommandLine.this.commandSpec.defaultValueProvider(), object)) continue;
                list.remove(object);
            }
            for (Model.ArgGroupSpec argGroupSpec : CommandLine.this.commandSpec.argGroups()) {
                this.applyGroupDefaults(CommandLine.this.commandSpec.defaultValueProvider(), argGroupSpec, list, set);
            }
            this.parseResultBuilder.isInitializingDefaultValues = false;
        }

        private void applyGroupDefaults(IDefaultValueProvider iDefaultValueProvider, Model.ArgGroupSpec argGroupSpec, List<Model.ArgSpec> list, Set<Model.ArgSpec> set) throws Exception {
            Tracer tracer = CommandLine.tracer();
            tracer.debug("Applying default values for group '%s'", argGroupSpec.synopsis());
            for (Model.ArgSpec object : argGroupSpec.args()) {
                if (object.scope().get() == null || set.contains(object)) continue;
                if (object.inherited()) {
                    tracer.debug("Not applying default value for inherited %s", CommandLine.optionDescription("", object, -1));
                    continue;
                }
                if (!this.applyDefault(iDefaultValueProvider, object)) continue;
                list.remove(object);
            }
            for (Model.ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups()) {
                this.applyGroupDefaults(iDefaultValueProvider, argGroupSpec2, list, set);
            }
        }

        private boolean applyDefault(IDefaultValueProvider iDefaultValueProvider, Model.ArgSpec argSpec) throws Exception {
            String string = iDefaultValueProvider == null ? null : iDefaultValueProvider.defaultValue(argSpec);
            String string2 = string == null ? argSpec.defaultValue() : argSpec.interpolate(string);
            String string3 = iDefaultValueProvider == null ? "" : " from " + iDefaultValueProvider.toString();
            Tracer tracer = CommandLine.tracer();
            if (string2 != null && !"_NULL_".equals(string2)) {
                if (tracer.isDebug()) {
                    tracer.debug("Applying defaultValue (%s)%s to %s on %s", string2, string3, argSpec, argSpec.scopeString());
                }
                Range range = argSpec.arity().min(Math.max(1, argSpec.arity().min));
                this.applyOption(argSpec, false, LookBehind.SEPARATE, false, range, this.stack(string2), new HashSet<Model.ArgSpec>(), argSpec.toString);
            } else if (argSpec.typeInfo().isOptional()) {
                if (tracer.isDebug()) {
                    tracer.debug("Applying Optional.empty() to %s on %s", argSpec, argSpec.scopeString());
                }
                argSpec.setValue(CommandLine.getOptionalEmpty());
            } else {
                if ("__unspecified__".equals(argSpec.originalDefaultValue)) {
                    tracer.debug("defaultValue not defined for %s", argSpec);
                    return false;
                }
                if ("_NULL_".equals(argSpec.originalDefaultValue)) {
                    string2 = null;
                    if (tracer.isDebug()) {
                        tracer.debug("Applying defaultValue (%s)%s to %s on %s", string2, string3, argSpec, argSpec.scopeString());
                    }
                    argSpec.setValue(string2);
                    return true;
                }
                tracer.debug("defaultValue not defined for %s", argSpec);
            }
            return string2 != null;
        }

        private Stack<String> stack(String string) {
            Stack<String> stack = new Stack<String>();
            stack.push(string);
            return stack;
        }

        private void processArguments(List<CommandLine> list, Stack<String> stack, Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, String[] stringArray, List<Object> list2) throws Exception {
            Object object;
            if (this.parseResultBuilder.expandedArgList.isEmpty()) {
                object = new ArrayList<String>(stack);
                Collections.reverse(object);
                this.parseResultBuilder.expandedArgs((Collection<String>)object);
                this.parseResultBuilder.originalArgs(stringArray);
                this.parseResultBuilder.nowProcessing = list2;
            }
            object = this.config().separator();
            Tracer tracer = CommandLine.tracer();
            while (!stack.isEmpty()) {
                LinkedHashSet linkedHashSet;
                String string;
                boolean bl2;
                if (this.endOfOptions) {
                    this.processRemainderAsPositionalParameters(collection, set, stack);
                    return;
                }
                String string2 = stack.pop();
                boolean bl3 = bl2 = !string2.equals(string = CommandLine.this.smartUnquoteIfEnabled(string2));
                if (tracer.isDebug()) {
                    int n2 = stringArray.length - (stack.size() + 1);
                    if (bl2) {
                        tracer.debug("[%d] Processing argument '%s' (trimmed from '%s'). Remainder=%s", n2, string, string2, CommandLine.reverse(CommandLine.copy(stack)));
                    } else {
                        tracer.debug("[%d] Processing argument '%s'. Remainder=%s", n2, string, CommandLine.reverse(CommandLine.copy(stack)));
                    }
                }
                if (CommandLine.this.commandSpec.parser.endOfOptionsDelimiter().equals(string)) {
                    tracer.info("Found end-of-options delimiter '%s'. Treating remainder as positional parameters.", CommandLine.this.commandSpec.parser.endOfOptionsDelimiter());
                    this.endOfOptions = true;
                    this.processRemainderAsPositionalParameters(collection, set, stack);
                    return;
                }
                CommandLine commandLine = CommandLine.this.commandSpec.subcommands().get(string);
                if (commandLine == null && CommandLine.this.commandSpec.parser().abbreviatedSubcommandsAllowed()) {
                    commandLine = AbbreviationMatcher.match(CommandLine.this.commandSpec.subcommands(), string, CommandLine.this.commandSpec.subcommandsCaseInsensitive(), CommandLine.this).getValue();
                }
                if (commandLine != null) {
                    this.processSubcommand(commandLine, this.parseResultBuilder, list, stack, collection, set, stringArray, list2, (String)object, string);
                    return;
                }
                Model.CommandSpec commandSpec = CommandLine.this.commandSpec.parent();
                if (commandSpec != null && commandSpec.subcommandsRepeatable()) {
                    commandLine = commandSpec.subcommands().get(string);
                    if (commandLine == null && commandSpec.parser().abbreviatedSubcommandsAllowed()) {
                        commandLine = AbbreviationMatcher.match(commandSpec.subcommands(), string, commandSpec.subcommandsCaseInsensitive(), CommandLine.this).getValue();
                    }
                    if (commandLine != null) {
                        tracer.debug("'%s' is a repeatable subcommand of %s", string, CommandLine.this.commandSpec.parent().qualifiedName());
                        linkedHashSet = set;
                        if (((CommandLine)commandLine).interpreter.parseResultBuilder != null) {
                            tracer.debug("Subcommand '%s' has been matched before. Making a copy...", commandLine.getCommandName());
                            commandLine = commandLine.copy();
                            commandLine.getCommandSpec().parent(CommandLine.this.commandSpec.parent());
                            linkedHashSet = new LinkedHashSet(linkedHashSet);
                        }
                        this.processSubcommand(commandLine, ((CommandLine)CommandLine.this.getParent()).interpreter.parseResultBuilder, list, stack, collection, linkedHashSet, stringArray, list2, (String)object, string);
                        continue;
                    }
                }
                linkedHashSet = new LinkedHashMap<String, Model.OptionSpec>();
                if (CommandLine.this.commandSpec.parser().abbreviatedOptionsAllowed()) {
                    ((HashMap)((Object)linkedHashSet)).putAll(CommandLine.this.commandSpec.optionsMap());
                    ((HashMap)((Object)linkedHashSet)).putAll(CommandLine.this.commandSpec.negatedOptionsMap());
                    string = AbbreviationMatcher.match(linkedHashSet, string, CommandLine.this.commandSpec.optionsCaseInsensitive(), CommandLine.this).getFullName();
                }
                LookBehind lookBehind = LookBehind.SEPARATE;
                int n3 = string.indexOf((String)object);
                if (n3 > 0) {
                    String string3 = string.substring(0, n3);
                    if (this.isStandaloneOption(string3 = AbbreviationMatcher.match(linkedHashSet, string3, CommandLine.this.commandSpec.optionsCaseInsensitive(), CommandLine.this).getFullName()) && this.isStandaloneOption(string)) {
                        tracer.warn("Both '%s' and '%s' are valid option names in %s. Using '%s'...", string, string3, CommandLine.this.getCommandName(), string);
                    } else if (this.isStandaloneOption(string3)) {
                        lookBehind = LookBehind.ATTACHED_WITH_SEPARATOR;
                        String string4 = string.substring(n3 + ((String)object).length());
                        stack.push(string4);
                        string = string3;
                        if (tracer.isDebug()) {
                            tracer.debug("Separated '%s' option from '%s' option parameter", string3, string4);
                        }
                    } else if (tracer.isDebug()) {
                        tracer.debug("'%s' contains separator '%s' but '%s' is not a known option", string, object, string3);
                    }
                } else if (tracer.isDebug()) {
                    tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>", string, object);
                }
                if (this.isStandaloneOption(string)) {
                    this.processStandaloneOption(collection, set, string, bl2, stack, lookBehind);
                    continue;
                }
                if (this.config().posixClusteredShortOptionsAllowed() && string.length() > 2 && string.startsWith("-")) {
                    if (tracer.isDebug()) {
                        tracer.debug("Trying to process '%s' as clustered short options", string, stack);
                    }
                    this.processClusteredShortOptions(collection, set, string, bl2, stack);
                    continue;
                }
                stack.push(string);
                if (tracer.isDebug()) {
                    tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...", string);
                }
                if (tracer.isDebug()) {
                    tracer.debug("No option named '%s' found. Processing as positional parameter", string);
                }
                this.processPositionalParameter(collection, set, bl2, stack);
            }
        }

        private void processSubcommand(CommandLine commandLine, ParseResult.Builder builder, List<CommandLine> list, Stack<String> stack, Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, String[] stringArray, List<Object> list2, String string, String string2) {
            Object object;
            Tracer tracer = CommandLine.tracer();
            if (tracer.isDebug()) {
                tracer.debug("Found subcommand '%s' (%s)", string2, commandLine.commandSpec.toString());
            }
            list2.add(commandLine.commandSpec);
            this.updateHelpRequested(commandLine.commandSpec);
            ArrayList<Model.ArgSpec> arrayList = new ArrayList<Model.ArgSpec>();
            if (tracer.isDebug()) {
                tracer.debug("Checking required args for parent %s...", commandLine.commandSpec.parent());
            }
            Iterator<Model.ArgSpec> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((Model.ArgSpec)object).scopeType() != ScopeType.INHERIT && !((Model.ArgSpec)object).inherited()) continue;
                if (tracer.isDebug()) {
                    tracer.debug("Postponing validation for required %s: scopeType=%s, inherited=%s", new Object[]{CommandLine.optionDescription("", (Model.ArgSpec)object, -1), ((Model.ArgSpec)object).scopeType(), ((Model.ArgSpec)object).inherited()});
                }
                if (!arrayList.contains(object)) {
                    arrayList.add((Model.ArgSpec)object);
                }
                iterator.remove();
            }
            if (!this.isAnyHelpRequested() && !collection.isEmpty()) {
                throw MissingParameterException.create(CommandLine.this, collection, string);
            }
            object = new LinkedHashSet();
            commandLine.interpreter.parse(list, stack, stringArray, list2, arrayList, (Set<Model.ArgSpec>)object);
            set.addAll((Collection<Model.ArgSpec>)object);
            builder.subcommand(((CommandLine)commandLine).interpreter.parseResultBuilder.build());
        }

        private boolean isStandaloneOption(String string) {
            return CommandLine.this.commandSpec.optionsMap().containsKey(string) || CommandLine.this.commandSpec.negatedOptionsMap().containsKey(string);
        }

        private void handleUnmatchedArgument(Stack<String> stack) throws Exception {
            if (!stack.isEmpty()) {
                this.parseResultBuilder.addUnmatched(this.parseResultBuilder.totalArgCount() - stack.size(), stack.pop());
            }
            if (this.config().stopAtUnmatched()) {
                this.parseResultBuilder.addUnmatched(stack);
            }
        }

        private void processRemainderAsPositionalParameters(Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, Stack<String> stack) throws Exception {
            while (!stack.empty()) {
                this.processPositionalParameter(collection, set, false, stack);
            }
        }

        private void processPositionalParameter(Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, boolean bl2, Stack<String> stack) throws Exception {
            int n2;
            final Tracer tracer = CommandLine.tracer();
            String string = stack.peek();
            if (!this.endOfOptions && CommandLine.this.commandSpec.resemblesOption(string)) {
                if (!CommandLine.this.commandSpec.parser().unmatchedOptionsArePositionalParams()) {
                    this.handleUnmatchedArgument(stack);
                    return;
                }
                if (tracer.isDebug()) {
                    tracer.debug("Parser is configured to treat all unmatched options as positional parameter", string);
                }
            }
            int n3 = this.parseResultBuilder.originalArgList.size() - stack.size();
            if (tracer.isDebug()) {
                tracer.debug("[%d] Processing next arg as a positional parameter. Command-local position=%d. Remainder=%s", n3, this.position, CommandLine.reverse(CommandLine.copy(stack)));
            }
            if (this.config().stopAtPositional()) {
                if (!this.endOfOptions && tracer.isDebug()) {
                    tracer.debug("Parser was configured with stopAtPositional=true, treating remaining arguments as positional parameters.", new Object[0]);
                }
                this.endOfOptions = true;
            }
            int n4 = this.interactiveCount;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.parseResultBuilder.nowProcessing.size();
            ArrayList<1> arrayList = new ArrayList<1>();
            for (n2 = 0; n2 < CommandLine.this.commandSpec.positionalParameters().size(); ++n2) {
                Object object;
                Model.PositionalParamSpec positionalParamSpec = CommandLine.this.commandSpec.positionalParameters().get(n2);
                Range object2 = positionalParamSpec.index();
                int n9 = this.getPosition(positionalParamSpec);
                if (positionalParamSpec.group() != null ? !((ParseResult.GroupMatchContainer)(object = this.parseResultBuilder.groupMatchContainer.findOrCreateMatchingGroup(positionalParamSpec, CommandLine.this.commandSpec.commandLine()))).canMatchPositionalParam(positionalParamSpec) : !object2.contains(n9) || positionalParamSpec.typedValueAtPosition.get(n9) != null) continue;
                object = CommandLine.copy(stack);
                Range range = positionalParamSpec.arity();
                if (tracer.isDebug()) {
                    tracer.debug("Position %s is in index range %s. Trying to assign args to %s, arity=%s", this.positionDesc(positionalParamSpec), object2.internalToString(), positionalParamSpec, range);
                }
                if (!this.assertNoMissingParameters(positionalParamSpec, range, (Stack<String>)object)) break;
                int n10 = ((Vector)object).size();
                int n11 = this.applyOption(positionalParamSpec, false, LookBehind.SEPARATE, bl2, range, (Stack<String>)object, set, "args[" + object2.internalToString() + "] at position " + n9);
                int n12 = n10 - ((Vector)object).size();
                if (n12 > 0 || n11 > 0) {
                    collection.remove(positionalParamSpec);
                    n7 = this.interactiveCount - n4;
                }
                if (positionalParamSpec.group() == null) {
                    n6 = Math.max(n6, n12);
                } else {
                    final int n13 = n9 + n12;
                    final ParseResult.GroupMatchContainer groupMatchContainer = this.parseResultBuilder.groupMatchContainer.findOrCreateMatchingGroup(positionalParamSpec, CommandLine.this.commandSpec.commandLine());
                    arrayList.add(new Runnable(){

                        public void run() {
                            if (groupMatchContainer != null) {
                                groupMatchContainer.lastMatch().position = n13;
                                if (tracer.isDebug()) {
                                    tracer.debug("Updated group position to %s for group %s.", groupMatchContainer.lastMatch().position, groupMatchContainer);
                                }
                            }
                        }
                    });
                    n5 = Math.max(n5, n12);
                }
                while (this.parseResultBuilder.nowProcessing.size() > n8 + n12) {
                    this.parseResultBuilder.nowProcessing.remove(this.parseResultBuilder.nowProcessing.size() - 1);
                }
            }
            n2 = Math.max(n5, n6);
            for (int i2 = 0; i2 < n2; ++i2) {
                stack.pop();
            }
            this.position += n6 + n7;
            if (tracer.isDebug()) {
                tracer.debug("Consumed %d arguments and %d interactive values, moving command-local position to index %d.", n6, n7, this.position);
            }
            for (Runnable runnable : arrayList) {
                runnable.run();
            }
            if (n5 == 0 && n6 == 0 && n7 == 0 && !stack.isEmpty()) {
                this.handleUnmatchedArgument(stack);
            }
        }

        private void processStandaloneOption(Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, String string, boolean bl2, Stack<String> stack, LookBehind lookBehind) throws Exception {
            Tracer tracer;
            boolean bl3;
            Model.ArgSpec argSpec = CommandLine.this.commandSpec.optionsMap().get(string);
            boolean bl4 = bl3 = argSpec == null;
            if (bl3) {
                argSpec = CommandLine.this.commandSpec.negatedOptionsMap().get(string);
            }
            collection.remove(argSpec);
            Range range = argSpec.arity();
            if (lookBehind.isAttached()) {
                range = range.min(Math.max(1, range.min));
            }
            if ((tracer = CommandLine.tracer()).isDebug()) {
                tracer.debug("Found option named '%s': %s, arity=%s", string, argSpec, range);
            }
            this.parseResultBuilder.nowProcessing.add(argSpec);
            this.applyOption(argSpec, bl3, lookBehind, bl2, range, stack, set, "option " + string);
        }

        private void processClusteredShortOptions(Collection<Model.ArgSpec> collection, Set<Model.ArgSpec> set, String string, boolean bl2, Stack<String> stack) throws Exception {
            Object object;
            String string2 = string.substring(0, 1);
            String string3 = string.substring(1);
            boolean bl3 = true;
            boolean bl4 = true;
            Tracer tracer = CommandLine.tracer();
            while (string3.length() > 0 && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(string3.charAt(0)))) {
                LookBehind lookBehind;
                object = CommandLine.this.commandSpec.posixOptionsMap().get(Character.valueOf(string3.charAt(0)));
                Range range = ((Model.ArgSpec)object).arity();
                String string4 = "option " + string2 + string3.charAt(0);
                if (tracer.isDebug()) {
                    tracer.debug("Found option '%s%s' in %s: %s, arity=%s", string2, Character.valueOf(string3.charAt(0)), string, object, range);
                }
                collection.remove(object);
                string3 = string3.substring(1);
                bl3 = string3.length() > 0;
                LookBehind lookBehind2 = lookBehind = bl3 ? LookBehind.ATTACHED : LookBehind.SEPARATE;
                if (string3.startsWith(this.config().separator())) {
                    lookBehind = LookBehind.ATTACHED_WITH_SEPARATOR;
                    string3 = string3.substring(this.config().separator().length());
                    range = range.min(Math.max(1, range.min));
                }
                if (range.min > 0 && !CommandLine.empty(string3) && tracer.isDebug()) {
                    tracer.debug("Trying to process '%s' as option parameter", string3);
                }
                if (!CommandLine.empty(string3)) {
                    stack.push(string3);
                }
                if (bl4) {
                    this.parseResultBuilder.nowProcessing.add(object);
                    bl4 = false;
                } else {
                    this.parseResultBuilder.nowProcessing.set(this.parseResultBuilder.nowProcessing.size() - 1, object);
                }
                int n2 = stack.size();
                int n3 = this.applyOption((Model.ArgSpec)object, false, lookBehind, bl2, range, stack, set, string4);
                if (CommandLine.empty(string3) || stack.isEmpty() || stack.size() < n2) {
                    return;
                }
                string3 = stack.pop();
            }
            if (string3.length() == 0) {
                return;
            }
            if (string.endsWith(string3)) {
                stack.push(bl3 ? string2 + string3 : string3);
                if (stack.peek().equals(string)) {
                    if (tracer.isDebug()) {
                        tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...", string);
                    }
                    this.processPositionalParameter(collection, set, bl2, stack);
                    return;
                }
                if (tracer.isDebug()) {
                    tracer.debug("No option found for %s in %s", string3, string);
                }
                object = stack.pop();
                object = (String)object + " (while processing option: '" + string + "')";
                stack.push((String)object);
                this.handleUnmatchedArgument(stack);
            } else {
                stack.push(string3);
                if (tracer.isDebug()) {
                    tracer.debug("%s is not an option parameter for %s", string3, string);
                }
                this.processPositionalParameter(collection, set, bl2, stack);
            }
        }

        private int applyOption(Model.ArgSpec argSpec, boolean bl2, LookBehind lookBehind, boolean bl3, Range range, Stack<String> stack, Set<Model.ArgSpec> set, String string) throws Exception {
            this.updateHelpRequested(argSpec);
            this.parseResultBuilder.beforeMatchingGroupElement(argSpec);
            int n2 = stack.size();
            Map map = CommandLine.mapOf("separator", lookBehind.toString(CommandLine.this.commandSpec.parser().separator()), new Object[]{"negated", bl2, "unquoted", bl3, "versionHelpRequested", this.parseResultBuilder.versionHelpRequested, "usageHelpRequested", this.parseResultBuilder.usageHelpRequested});
            boolean bl4 = argSpec.preprocessor().preprocess(stack, CommandLine.this.commandSpec, argSpec, map);
            this.parseResultBuilder.versionHelpRequested = (Boolean)map.get("versionHelpRequested");
            this.parseResultBuilder.usageHelpRequested = (Boolean)map.get("usageHelpRequested");
            bl2 = (Boolean)map.get("negated");
            bl3 = (Boolean)map.get("unquoted");
            lookBehind = LookBehind.parse(String.valueOf(map.get("separator")));
            if (bl4) {
                return stack.size() - n2;
            }
            if (argSpec.parameterConsumer() != null) {
                argSpec.parameterConsumer().consumeParameters(stack, argSpec, CommandLine.this.commandSpec);
                return stack.size() - n2;
            }
            boolean bl5 = CommandLine.this.commandSpec.parser().aritySatisfiedByAttachedOptionParam() && lookBehind.isAttached();
            Stack<String> stack2 = stack;
            if (bl5) {
                stack2 = stack.isEmpty() ? stack : this.stack(stack.pop());
            } else if (!this.assertNoMissingParameters(argSpec, range, stack)) {
                return 0;
            }
            int n3 = argSpec.typeInfo().isArray() ? this.applyValuesToArrayField(argSpec, bl2, lookBehind, bl3, range, stack2, set, string) : (argSpec.typeInfo().isCollection() ? this.applyValuesToCollectionField(argSpec, bl2, lookBehind, bl3, range, stack2, set, string) : (argSpec.typeInfo().isMap() ? this.applyValuesToMapField(argSpec, lookBehind, bl3, range, stack2, set, string) : this.applyValueToSingleValuedField(argSpec, bl2, lookBehind, bl3, range, stack2, set, string)));
            if (stack2 != stack && !stack2.isEmpty()) {
                stack.push(stack2.pop());
                Assert.assertTrue(stack2.isEmpty(), "Working stack should be empty but was " + new ArrayList<String>(stack2));
            }
            return n3;
        }

        private void addToInitialized(Model.ArgSpec argSpec, Set<Model.ArgSpec> set) {
            set.add(argSpec);
            Model.ArgSpec argSpec2 = argSpec.root();
            if (argSpec2 != null) {
                set.add(argSpec2);
            }
        }

        private int applyValueToSingleValuedField(Model.ArgSpec argSpec, boolean bl2, LookBehind lookBehind, boolean bl3, Range range, Stack<String> stack, Set<Model.ArgSpec> set, String string) throws Exception {
            Object object;
            Object object2;
            int n2;
            Range range2;
            String string2;
            Tracer tracer = CommandLine.tracer();
            boolean bl4 = stack.isEmpty();
            String string3 = string2 = bl4 ? null : stack.pop();
            if (CommandLine.this.commandSpec.parser().trimQuotes() && !bl3) {
                string2 = CommandLine.unquote(string2);
            }
            Range range3 = range2 = argSpec.arity().isUnspecified ? range : argSpec.arity();
            if (range2.max == 0 && !range2.isUnspecified && lookBehind == LookBehind.ATTACHED_WITH_SEPARATOR) {
                throw new MaxValuesExceededException(CommandLine.this, CommandLine.optionDescription("", argSpec, 0) + " should be specified without '" + string2 + "' parameter");
            }
            if (range2.min > 0) {
                stack.push(string3);
                n2 = this.assertNoMissingMandatoryParameter(argSpec, stack, 0, range2) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, stack, 0, range2) ? 1 : 0;
                stack.pop();
                if (n2 != 0) {
                    return 0;
                }
            }
            n2 = range2.min;
            String string4 = string2;
            Object object3 = null;
            Class<?> clazz = argSpec.auxiliaryTypes()[0];
            if (range2.min <= 0) {
                boolean bl5 = true;
                n2 = 1;
                if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                    boolean bl6;
                    boolean bl7 = bl6 = range2.max > 0 && ("true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2));
                    if (!bl6 && lookBehind != LookBehind.ATTACHED_WITH_SEPARATOR) {
                        object2 = this.booleanValue(argSpec, argSpec.calcDefaultValue(true));
                        if (argSpec.isOption() && !CommandLine.empty(((Model.OptionSpec)argSpec).fallbackValue())) {
                            object2 = !this.booleanValue(argSpec, ((Model.OptionSpec)argSpec).fallbackValue());
                        }
                        Object object4 = object = CommandLine.this.commandSpec.parser().toggleBooleanFlags() ? (Boolean)argSpec.getValue() : object2;
                        if (object == null) {
                            object = false;
                        }
                        string4 = String.valueOf(!((Boolean)object).booleanValue());
                        if (argSpec.isOption() && ((Model.OptionSpec)argSpec).negatable() && bl2) {
                            string4 = String.valueOf(object);
                        }
                        bl5 = false;
                        n2 = 0;
                    }
                } else {
                    String string5;
                    String string6 = string5 = argSpec.isOption() ? ((Model.OptionSpec)argSpec).fallbackValue() : "";
                    if (!this.varargCanConsumeNextValue(argSpec, string2) || string2 == null) {
                        string4 = string5;
                        bl5 = false;
                        n2 = 0;
                    }
                }
                if (argSpec.interactive() && (range2.max == 0 || !bl5)) {
                    object3 = this.readUserInput(argSpec);
                    n2 = 0;
                }
            }
            if (n2 == 0) {
                if (string2 != null) {
                    stack.push(string2);
                }
            } else if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, string2);
            }
            String string7 = "Setting %s to '%3$s' (was '%2$s') for %4$s on %5$s";
            String string8 = "Overwriting %s value '%s' with '%s' for %s on %s";
            Object object5 = object2 = object3 != null ? object3 : string4;
            if (bl4 && string4 == null && object3 == null) {
                n2 = 0;
            } else {
                n2 = 1;
                if (object3 != null) {
                    if (argSpec.echo()) {
                        string7 = "Setting %s to %3$s (interactive value) for %4$s on %5$s";
                        string8 = "Overwriting %s value with %3$s (interactive value) for %s on %5$s";
                    } else {
                        string7 = "Setting %s to *** (masked interactive value) for %4$s on %5$s";
                        string8 = "Overwriting %s value with *** (masked interactive value) for %s on %5$s";
                    }
                }
                if ((clazz == Boolean.class || clazz == Boolean.TYPE) && range2.min >= 1) {
                    object = this.booleanValue(argSpec, string2);
                    string4 = argSpec.isOption() && ((Model.OptionSpec)argSpec).negatable() && bl2 ? String.valueOf(!((Boolean)object).booleanValue()) : String.valueOf(object);
                }
                if (!char[].class.equals(clazz) && !char[].class.equals(argSpec.type())) {
                    if (object3 != null) {
                        string4 = new String((char[])object3);
                    }
                    object = this.getTypeConverter(argSpec.auxiliaryTypes(), argSpec, 0);
                    object2 = this.tryConvert(argSpec, -1, (ITypeConverter<?>)object, string4, 0);
                } else if (object3 == null) {
                    object2 = string4.toCharArray();
                } else {
                    string4 = this.getMaskedValue(argSpec, new String((char[])object3));
                    object2 = object3;
                }
            }
            object = argSpec.getValue();
            String string9 = string7;
            if (argSpec.group() == null && set.contains(argSpec)) {
                if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                    throw new OverwrittenOptionException(CommandLine.this, argSpec, CommandLine.optionDescription("", argSpec, 0) + " should be specified only once");
                }
                string9 = string8;
            }
            this.addToInitialized(argSpec, set);
            if (argSpec.typeInfo().isOptional()) {
                object2 = CommandLine.getOptionalOfNullable(object2);
            }
            if (tracer.isInfo()) {
                tracer.info(string9, argSpec.toString(), String.valueOf(object), String.valueOf(object2), string, argSpec.scopeString());
            }
            int n3 = this.getPosition(argSpec);
            argSpec.setValue(object2);
            this.parseResultBuilder.addOriginalStringValue(argSpec, string4);
            this.parseResultBuilder.addStringValue(argSpec, string4);
            this.parseResultBuilder.addTypedValues(argSpec, n3, object2);
            this.parseResultBuilder.add(argSpec, n3);
            return n2;
        }

        private int applyValuesToMapField(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, Stack<String> stack, Set<Model.ArgSpec> set, String string) throws Exception {
            if (argSpec.auxiliaryTypes().length < 2) {
                throw new ParameterException(CommandLine.this, argSpec.toString() + " needs two types (one for the map key, one for the value) but only has " + argSpec.auxiliaryTypes().length + " types configured.", argSpec, null);
            }
            Map<Object, Object> map = (Map<Object, Object>)argSpec.getValue();
            Tracer tracer = CommandLine.tracer();
            if (map == null || !set.contains(argSpec)) {
                tracer.debug("Initializing binding for %s on %s with empty %s", CommandLine.optionDescription("", argSpec, 0), argSpec.scopeString(), argSpec.type().getSimpleName());
                map = this.createMap(argSpec.type());
                argSpec.setValue(map);
            }
            this.addToInitialized(argSpec, set);
            int n2 = map.size();
            int n3 = this.getPosition(argSpec);
            this.consumeMapArguments(argSpec, lookBehind, bl2, range, stack, map, string);
            this.parseResultBuilder.add(argSpec, n3);
            argSpec.setValue(map);
            return map.size() - n2;
        }

        private void consumeMapArguments(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, Stack<String> stack, Map<Object, Object> map, String string) throws Exception {
            String string2;
            int n2 = this.getPosition(argSpec);
            Class<?>[] classArray = argSpec.auxiliaryTypes();
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(classArray, argSpec, 0);
            ITypeConverter<?> iTypeConverter2 = this.getTypeConverter(classArray, argSpec, 1);
            int n3 = argSpec.stringValues().size();
            int n4 = this.consumedCountMap(0, n3, argSpec);
            int n5 = 0;
            while (n4 < range.min && !stack.isEmpty()) {
                LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, linkedHashMap);
                if (this.assertNoMissingMandatoryParameter(argSpec, stack, n5, range) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, stack, n5, range)) break;
                this.consumeOneMapArgument(argSpec, lookBehind, bl2, range, n4, stack.pop(), classArray, iTypeConverter, iTypeConverter2, linkedHashMap, n5, string);
                map.putAll(linkedHashMap);
                n4 = this.consumedCountMap(n5 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                bl2 = false;
                ++n5;
            }
            String string3 = string2 = n4 == 0 && argSpec.isOption() && !"".equals(((Model.OptionSpec)argSpec).fallbackValue()) ? ((Model.OptionSpec)argSpec).fallbackValue() : null;
            if (string2 != null && (stack.isEmpty() || !this.varargCanConsumeNextValue(argSpec, stack.peek()))) {
                stack.push(string2);
            }
            int n6 = n4;
            while (n4 < range.max && !stack.isEmpty() && this.varargCanConsumeNextValue(argSpec, stack.peek())) {
                LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, linkedHashMap);
                if (!this.canConsumeOneMapArgument(argSpec, lookBehind, bl2, range, n4, stack.peek(), classArray, iTypeConverter, iTypeConverter2, string) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, stack, n6, range)) break;
                this.consumeOneMapArgument(argSpec, lookBehind, bl2, range, n4, stack.pop(), classArray, iTypeConverter, iTypeConverter2, linkedHashMap, n6, string);
                map.putAll(linkedHashMap);
                n4 = this.consumedCountMap(n6 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                bl2 = false;
                ++n6;
            }
        }

        private void consumeOneMapArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, int n2, String string, Class<?>[] classArray, ITypeConverter<?> iTypeConverter, ITypeConverter<?> iTypeConverter2, Map<Object, Object> map, int n3, String string2) throws Exception {
            if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, string);
            }
            String[] stringArray = this.unquoteAndSplit(argSpec, lookBehind, bl2, range, n2, string);
            Tracer tracer = CommandLine.tracer();
            for (String string3 : stringArray) {
                String[] stringArray2 = this.splitKeyValue(argSpec, string3);
                Object object = this.tryConvert(argSpec, n3, iTypeConverter, stringArray2[0], 0);
                String string4 = stringArray2.length == 1 ? argSpec.mapFallbackValue() : stringArray2[1];
                Object object2 = this.tryConvert(argSpec, n3, iTypeConverter2, string4, 1);
                map.put(object, object2);
                if (tracer.isInfo()) {
                    tracer.info("Putting [%s : %s] in %s<%s, %s> %s for %s on %s", String.valueOf(object), String.valueOf(object2), map.getClass().getSimpleName(), classArray[0].getSimpleName(), classArray[1].getSimpleName(), argSpec.toString(), string2, argSpec.scopeString());
                }
                this.parseResultBuilder.addStringValue(argSpec, stringArray2[0]);
                this.parseResultBuilder.addStringValue(argSpec, string4);
            }
            this.parseResultBuilder.addOriginalStringValue(argSpec, string);
        }

        private String[] unquoteAndSplit(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, int n2, String string) {
            String string2 = lookBehind.isAttached() && bl2 ? string : CommandLine.this.smartUnquoteIfEnabled(string);
            return argSpec.splitValue(string2, CommandLine.this.commandSpec.parser(), range, n2);
        }

        private boolean canConsumeOneMapArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, int n2, String string, Class<?>[] classArray, ITypeConverter<?> iTypeConverter, ITypeConverter<?> iTypeConverter2, String string2) {
            String[] stringArray = this.unquoteAndSplit(argSpec, lookBehind, bl2, range, n2, string);
            try {
                for (String string3 : stringArray) {
                    String[] stringArray2 = this.splitKeyValue(argSpec, string3);
                    this.tryConvert(argSpec, -1, iTypeConverter, stringArray2[0], 0);
                    String string4 = stringArray2.length == 1 ? argSpec.mapFallbackValue() : stringArray2[1];
                    this.tryConvert(argSpec, -1, iTypeConverter2, string4, 1);
                }
                return true;
            }
            catch (PicocliException picocliException) {
                CommandLine.tracer().debug("%s cannot be assigned to %s: type conversion fails: %s.", string, string2, picocliException.getMessage());
                return false;
            }
        }

        private String[] splitKeyValue(Model.ArgSpec argSpec, String string) {
            String[] stringArray = Model.ArgSpec.splitRespectingQuotedStrings(string, 2, this.config(), argSpec, "=");
            if (stringArray.length < 2 && "__unspecified__".equals(argSpec.mapFallbackValue())) {
                String string2 = argSpec.splitRegex();
                if (string2.length() == 0) {
                    throw new ParameterException(CommandLine.this, "Value for option " + CommandLine.optionDescription("", argSpec, 0) + " should be in KEY=VALUE format but was " + string, argSpec, string);
                }
                throw new ParameterException(CommandLine.this, "Value for option " + CommandLine.optionDescription("", argSpec, 0) + " should be in KEY=VALUE[" + string2 + "KEY=VALUE]... format but was " + string, argSpec, string);
            }
            return stringArray;
        }

        private boolean assertNoMissingMandatoryParameter(Model.ArgSpec argSpec, Stack<String> stack, int n2, Range range) {
            if (!this.varargCanConsumeNextValue(argSpec, stack.peek())) {
                String string = this.createMissingParameterMessageFoundOtherOption(argSpec, stack, n2, range);
                this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, string));
                return true;
            }
            return false;
        }

        private String createMissingParameterMessageFoundOtherOption(Model.ArgSpec argSpec, Stack<String> stack, int n2, Range range) {
            String string = range.min > 1 ? n2 + 1 + " (of " + range.min + " mandatory parameters) " : "";
            return "Expected parameter " + string + "for " + CommandLine.optionDescription("", argSpec, -1) + " but found '" + stack.peek() + "'";
        }

        private boolean isArgResemblesOptionThereforeDiscontinue(Model.ArgSpec argSpec, Stack<String> stack, int n2, Range range) throws Exception {
            boolean bl2 = false;
            String string = stack.peek();
            if (CommandLine.this.commandSpec.resemblesOption(string)) {
                if (argSpec.isPositional() && !this.endOfOptions && !CommandLine.this.commandSpec.parser().unmatchedOptionsArePositionalParams()) {
                    this.handleUnmatchedArgument(stack);
                    bl2 = true;
                }
                if (argSpec.isOption() && !CommandLine.this.commandSpec.parser().unmatchedOptionsAllowedAsOptionParameters()) {
                    String string2 = "Unknown option: '" + string + "'; " + this.createMissingParameterMessageFoundOtherOption(argSpec, stack, n2, range);
                    this.maybeThrow(new UnmatchedArgumentException(CommandLine.this.commandSpec.commandLine(), string2));
                    bl2 = true;
                }
                if (CommandLine.tracer().isDebug()) {
                    CommandLine.tracer().debug("Parser is configured to allow unmatched option '%s' as option or positional parameter.", string);
                }
            }
            return bl2;
        }

        private int applyValuesToArrayField(Model.ArgSpec argSpec, boolean bl2, LookBehind lookBehind, boolean bl3, Range range, Stack<String> stack, Set<Model.ArgSpec> set, String string) throws Exception {
            Object t2 = argSpec.getValue();
            int n2 = t2 == null ? 0 : Array.getLength(t2);
            int n3 = this.getPosition(argSpec);
            List<Object> list = this.consumeArguments(argSpec, bl2, lookBehind, bl3, bl3, range, stack, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (set.contains(argSpec)) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(Array.get(t2, i2));
                }
            }
            this.addToInitialized(argSpec, set);
            for (Object object : list) {
                if (object instanceof Collection) {
                    arrayList.addAll((Collection)object);
                    continue;
                }
                arrayList.add(object);
            }
            Object object = Array.newInstance(argSpec.auxiliaryTypes()[0], arrayList.size());
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Array.set(object, i3, arrayList.get(i3));
            }
            argSpec.setValue(object);
            this.parseResultBuilder.add(argSpec, n3);
            return list.size();
        }

        private int applyValuesToCollectionField(Model.ArgSpec argSpec, boolean bl2, LookBehind lookBehind, boolean bl3, Range range, Stack<String> stack, Set<Model.ArgSpec> set, String string) throws Exception {
            Collection<Object> collection = (Collection<Object>)argSpec.getValue();
            int n2 = this.getPosition(argSpec);
            List<Object> list = this.consumeArguments(argSpec, bl2, lookBehind, bl3, bl3, range, stack, string);
            if (collection == null || !set.contains(argSpec)) {
                CommandLine.tracer().debug("Initializing binding for %s on %s with empty %s", CommandLine.optionDescription("", argSpec, 0), argSpec.scopeString(), argSpec.type().getSimpleName());
                collection = this.createCollection(argSpec.type(), argSpec.auxiliaryTypes());
                argSpec.setValue(collection);
            }
            this.addToInitialized(argSpec, set);
            for (Object object : list) {
                if (object instanceof Collection) {
                    collection.addAll((Collection)object);
                    continue;
                }
                collection.add(object);
            }
            this.parseResultBuilder.add(argSpec, n2);
            argSpec.setValue(collection);
            return list.size();
        }

        private List<Object> consumeArguments(Model.ArgSpec argSpec, boolean bl2, LookBehind lookBehind, boolean bl3, boolean bl4, Range range, Stack<String> stack, String string) throws Exception {
            String string2;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = this.getPosition(argSpec);
            int n3 = argSpec.stringValues().size();
            int n4 = this.consumedCount(0, n3, argSpec);
            int n5 = 0;
            while (n4 < range.min && !stack.isEmpty()) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                this.parseResultBuilder.addTypedValues(argSpec, n2++, arrayList2);
                if (this.assertNoMissingMandatoryParameter(argSpec, stack, n5, range) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, stack, n5, range)) break;
                this.consumeOneArgument(argSpec, lookBehind, bl3, range, n4, stack.pop(), arrayList2, n5, string);
                arrayList.addAll(arrayList2);
                n4 = this.consumedCount(n5 + 1, n3, argSpec);
                lookBehind = LookBehind.SEPARATE;
                bl3 = false;
                ++n5;
            }
            if (argSpec.interactive() && argSpec.arity().max == 0) {
                n4 = this.addUserInputToList(argSpec, arrayList, n4, string);
            }
            String string3 = string2 = n4 == 0 && argSpec.isOption() && !"".equals(((Model.OptionSpec)argSpec).fallbackValue()) ? ((Model.OptionSpec)argSpec).fallbackValue() : null;
            if (string2 != null && (stack.isEmpty() || !this.varargCanConsumeNextValue(argSpec, stack.peek()))) {
                stack.push(string2);
            }
            int n6 = n4;
            while (n4 < range.max && !stack.isEmpty()) {
                if (argSpec.interactive() && argSpec.arity().max == 1 && !this.varargCanConsumeNextValue(argSpec, stack.peek())) {
                    n4 = this.addUserInputToList(argSpec, arrayList, n4, string);
                } else {
                    if (!this.varargCanConsumeNextValue(argSpec, stack.peek())) break;
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    this.parseResultBuilder.addTypedValues(argSpec, n2++, arrayList3);
                    if (!this.canConsumeOneArgument(argSpec, lookBehind, bl3, range, n4, stack.peek(), string) || this.isArgResemblesOptionThereforeDiscontinue(argSpec, stack, n6, range)) break;
                    this.consumeOneArgument(argSpec, lookBehind, bl3, range, n4, stack.pop(), arrayList3, n6, string);
                    arrayList.addAll(arrayList3);
                    n4 = this.consumedCount(n6 + 1, n3, argSpec);
                    lookBehind = LookBehind.SEPARATE;
                    bl3 = false;
                }
                ++n6;
            }
            if (arrayList.isEmpty() && range.min == 0 && range.max <= 1 && CommandLine.isBoolean(argSpec.auxiliaryTypes())) {
                if (argSpec.isOption() && ((Model.OptionSpec)argSpec).negatable()) {
                    Object object = argSpec.calcDefaultValue(true);
                    boolean bl5 = false;
                    if (object instanceof String) {
                        bl5 = Boolean.parseBoolean(String.valueOf(object));
                    }
                    if (bl2) {
                        return Collections.singletonList(bl5);
                    }
                    return Collections.singletonList(!bl5);
                }
                return Collections.singletonList(Boolean.TRUE);
            }
            return arrayList;
        }

        private int consumedCount(int n2, int n3, Model.ArgSpec argSpec) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? argSpec.stringValues().size() - n3 : n2;
        }

        private int consumedCountMap(int n2, int n3, Model.ArgSpec argSpec) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? (argSpec.stringValues().size() - n3) / 2 : n2;
        }

        private int addUserInputToList(Model.ArgSpec argSpec, List<Object> list, int n2, String string) {
            String string2;
            char[] cArray = this.readUserInput(argSpec);
            String string3 = new String(cArray);
            if (CommandLine.tracer().isInfo()) {
                string2 = argSpec.echo() ? string3 + " (interactive value)" : "*** (masked interactive value)";
                CommandLine.tracer().info("Adding %s to %s for %s on %s", string2, argSpec.toString(), string, argSpec.scopeString());
            }
            string2 = this.getMaskedValue(argSpec, string3);
            this.parseResultBuilder.addStringValue(argSpec, string2);
            this.parseResultBuilder.addOriginalStringValue(argSpec, string2);
            if (!char[].class.equals(argSpec.auxiliaryTypes()[0]) && !char[].class.equals(argSpec.type())) {
                Object object = this.tryConvert(argSpec, n2, this.getTypeConverter(argSpec.auxiliaryTypes(), argSpec, 0), new String(cArray), 0);
                list.add(object);
            } else {
                list.add(cArray);
            }
            return ++n2;
        }

        private String getMaskedValue(Model.ArgSpec argSpec, String string) {
            return argSpec.echo() ? string : "***";
        }

        private int consumeOneArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, int n2, String string, List<Object> list, int n3, String string2) {
            if (!lookBehind.isAttached()) {
                this.parseResultBuilder.nowProcessing(argSpec, string);
            }
            String[] stringArray = this.unquoteAndSplit(argSpec, lookBehind, bl2, range, n2, string);
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(argSpec.auxiliaryTypes(), argSpec, 0);
            for (String string3 : stringArray) {
                Object object = this.tryConvert(argSpec, n3, iTypeConverter, string3, 0);
                list.add(object);
                if (CommandLine.tracer().isInfo()) {
                    CommandLine.tracer().info("Adding [%s] to %s for %s on %s", String.valueOf(list.get(list.size() - 1)), argSpec.toString(), string2, argSpec.scopeString());
                }
                this.parseResultBuilder.addStringValue(argSpec, string3);
            }
            this.parseResultBuilder.addOriginalStringValue(argSpec, string);
            return ++n3;
        }

        private boolean canConsumeOneArgument(Model.ArgSpec argSpec, LookBehind lookBehind, boolean bl2, Range range, int n2, String string, String string2) {
            if (char[].class.equals(argSpec.auxiliaryTypes()[0]) || char[].class.equals(argSpec.type())) {
                return true;
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(argSpec.auxiliaryTypes(), argSpec, 0);
            try {
                String[] stringArray;
                for (String string3 : stringArray = this.unquoteAndSplit(argSpec, lookBehind, bl2, range, n2, string)) {
                    this.tryConvert(argSpec, -1, iTypeConverter, string3, 0);
                }
                return true;
            }
            catch (PicocliException picocliException) {
                CommandLine.tracer().debug("%s cannot be assigned to %s: type conversion fails: %s.", string, string2, picocliException.getMessage());
                return false;
            }
        }

        private boolean varargCanConsumeNextValue(Model.ArgSpec argSpec, String string) {
            if (this.endOfOptions && argSpec.isPositional()) {
                return true;
            }
            if (this.isEndOfOptionsDelimiter(string)) {
                return false;
            }
            boolean bl2 = this.isCommand(string);
            boolean bl3 = argSpec.isOption() && CommandLine.this.commandSpec.parser().allowSubcommandsAsOptionParameters();
            boolean bl4 = argSpec.isOption() && CommandLine.this.commandSpec.parser().allowOptionsAsOptionParameters();
            return !(bl2 && !bl3 || this.isOption(string) && !bl4);
        }

        private boolean isOption(String string) {
            if (string == null) {
                return false;
            }
            if (this.isEndOfOptionsDelimiter(string)) {
                return true;
            }
            if (CommandLine.this.commandSpec.optionsMap().containsKey(string)) {
                return true;
            }
            if (CommandLine.this.commandSpec.negatedOptionsByNameMap.containsKey(string)) {
                return true;
            }
            int n2 = string.indexOf(this.config().separator());
            if (n2 > 0 && CommandLine.this.commandSpec.optionsMap().containsKey(string.substring(0, n2))) {
                return true;
            }
            return string.length() > 2 && string.startsWith("-") && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(string.charAt(1)));
        }

        private boolean isCommand(String string) {
            if (CommandLine.this.commandSpec.subcommands().containsKey(string)) {
                return true;
            }
            Model.CommandSpec commandSpec = CommandLine.this.commandSpec.parent();
            return commandSpec != null && commandSpec.subcommandsRepeatable() && commandSpec.subcommands().containsKey(string);
        }

        private boolean isEndOfOptionsDelimiter(String string) {
            return CommandLine.this.commandSpec.parser().endOfOptionsDelimiter().equals(string);
        }

        private Object tryConvert(Model.ArgSpec argSpec, int n2, ITypeConverter<?> iTypeConverter, String string, int n3) throws ParameterException {
            try {
                return iTypeConverter.convert(string);
            }
            catch (TypeConversionException typeConversionException) {
                String string2 = String.format("Invalid value for %s: %s", CommandLine.optionDescription("", argSpec, n2), typeConversionException.getMessage());
                throw new ParameterException(CommandLine.this, string2, typeConversionException, argSpec, string);
            }
            catch (Exception exception) {
                String string3 = CommandLine.optionDescription("", argSpec, n2);
                String string4 = argSpec.auxiliaryTypes()[n3].getSimpleName();
                if (CommandLine.isOptional(argSpec.auxiliaryTypes()[n3])) {
                    string4 = string4 + "<" + argSpec.auxiliaryTypes()[n3 + 1].getSimpleName() + ">";
                }
                String string5 = String.format("Invalid value for %s: cannot convert '%s' to %s (%s)", string3, string, string4, exception);
                throw new ParameterException(CommandLine.this, string5, exception, argSpec, string);
            }
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || this.parseResultBuilder.versionHelpRequested || this.parseResultBuilder.usageHelpRequested;
        }

        private void updateHelpRequested(Model.CommandSpec commandSpec) {
            this.isHelpRequested |= commandSpec.helpCommand();
        }

        private void updateHelpRequested(Model.ArgSpec argSpec) {
            if (!this.parseResultBuilder.isInitializingDefaultValues && argSpec.isOption()) {
                Model.OptionSpec optionSpec = (Model.OptionSpec)argSpec;
                this.isHelpRequested |= this.is(argSpec, "help", optionSpec.help());
                ParseResult.Builder builder = this.parseResultBuilder;
                builder.versionHelpRequested = builder.versionHelpRequested | this.is(argSpec, "versionHelp", optionSpec.versionHelp());
                builder = this.parseResultBuilder;
                builder.usageHelpRequested = builder.usageHelpRequested | this.is(argSpec, "usageHelp", optionSpec.usageHelp());
            }
        }

        private boolean is(Model.ArgSpec argSpec, String string, boolean bl2) {
            if (bl2 && CommandLine.tracer().isInfo()) {
                CommandLine.tracer().info("%s has '%s' annotation: not validating required fields", argSpec.toString(), string);
            }
            return bl2;
        }

        private Collection<Object> createCollection(Class<?> clazz, Class<?>[] classArray) throws Exception {
            if (EnumSet.class.isAssignableFrom(clazz) && Enum.class.isAssignableFrom(classArray[0])) {
                EnumSet<?> enumSet = EnumSet.noneOf(classArray[0]);
                return enumSet;
            }
            return (Collection)CommandLine.this.factory.create(clazz);
        }

        private Map<Object, Object> createMap(Class<?> clazz) throws Exception {
            return (Map)CommandLine.this.factory.create(clazz);
        }

        private ITypeConverter<?> getTypeConverter(Class<?>[] classArray, Model.ArgSpec argSpec, int n2) {
            if (argSpec.converters().length > n2 && !argSpec.converters()[n2].getClass().equals(UseDefaultConverter.class)) {
                return argSpec.converters()[n2];
            }
            Class<?> clazz = classArray[n2];
            if (CommandLine.isOptional(clazz)) {
                if (classArray.length <= n2 + 1) {
                    throw new PicocliException("Cannot create converter for types " + Arrays.asList(classArray) + " for " + argSpec);
                }
                final ITypeConverter<?> iTypeConverter = this.getActualTypeConverter(classArray[n2 + 1], argSpec);
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String string) throws Exception {
                        return string == null ? CommandLine.getOptionalEmpty() : CommandLine.getOptionalOfNullable(iTypeConverter.convert(string));
                    }
                };
            }
            return this.getActualTypeConverter(clazz, argSpec);
        }

        private ITypeConverter<?> getActualTypeConverter(Class<?> clazz, Model.ArgSpec argSpec) {
            if (char[].class.equals(argSpec.type()) && argSpec.interactive()) {
                return this.converterRegistry.get(char[].class);
            }
            if (this.converterRegistry.containsKey(clazz)) {
                return this.converterRegistry.get(clazz);
            }
            if (clazz.isEnum()) {
                return this.getEnumTypeConverter(clazz);
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + clazz.getName() + " of " + argSpec);
        }

        private ITypeConverter<Object> getEnumTypeConverter(final Class<?> clazz) {
            return new ITypeConverter<Object>(){

                @Override
                public Object convert(String string) throws Exception {
                    try {
                        return Enum.valueOf(clazz, string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        boolean bl2 = CommandLine.this.commandSpec.parser().caseInsensitiveEnumValuesAllowed();
                        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                            String string2 = enum_.toString();
                            String string3 = enum_.name();
                            if (!string.equals(string2) && !string.equals(string3) && (!bl2 || !string.equalsIgnoreCase(string2) && !string.equalsIgnoreCase(string3))) continue;
                            return enum_;
                        }
                        String string4 = bl2 ? "case-insensitive" : "case-sensitive";
                        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (Enum enum_ : enumArray) {
                            arrayList.add(enum_.name());
                            if (arrayList.contains(enum_.toString()) || bl2 && enum_.name().equalsIgnoreCase(enum_.toString())) continue;
                            arrayList.add(enum_.toString());
                        }
                        throw new TypeConversionException(CommandLine.format("expected one of %s (%s) but was '%s'", new Object[]{arrayList, string4, string}));
                    }
                }
            };
        }

        private boolean booleanValue(Model.ArgSpec argSpec, Object object) {
            String string;
            if (object == null) {
                return false;
            }
            if (CommandLine.isOptional(object.getClass())) {
                try {
                    object = object.getClass().getMethod("orElse", Object.class).invoke(object, "null");
                }
                catch (Exception exception) {
                    throw new TypeConversionException("Could not convert '" + object + "' to an Optional<Boolean>: " + exception.getMessage());
                }
            }
            if (CommandLine.empty(string = String.valueOf(object)) || "null".equals(string) || "Optional.empty".equals(object)) {
                return false;
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(new Class[]{Boolean.class}, argSpec, 0);
            return (Boolean)this.tryConvert(argSpec, -1, iTypeConverter, string, 0);
        }

        private boolean assertNoMissingParameters(Model.ArgSpec argSpec, Range range, Stack<String> stack) {
            if (argSpec.interactive()) {
                return true;
            }
            int n2 = stack.size();
            if (n2 > 0 && CommandLine.this.commandSpec.parser().splitFirst() && argSpec.splitRegex().length() > 0) {
                n2 += argSpec.splitValue(stack.peek(), CommandLine.this.commandSpec.parser(), range, 0).length - 1;
            }
            if (range.min > n2) {
                List<Object> list = Collections.emptyList();
                List<Model.PositionalParamSpec> list2 = CommandLine.this.commandSpec.positionalParameters();
                if (argSpec.isPositional() && list2.contains(argSpec)) {
                    list = list2.subList(list2.indexOf(argSpec), list2.size());
                }
                String string = CommandLine.createMissingParameterMessage(argSpec, range, list, stack, n2);
                this.maybeThrow(new MissingParameterException(CommandLine.this, argSpec, string));
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        char[] readUserInput(Model.ArgSpec argSpec) {
            String string = argSpec.isOption() ? ((Model.OptionSpec)argSpec).longestName() : "position " + this.position;
            String string2 = CommandLine.str(argSpec.description(), 0);
            String string3 = CommandLine.empty(string2) ? String.format("Enter value for %s: ", string) : String.format("Enter value for %s (%s): ", string, string2);
            String string4 = CommandLine.empty(argSpec.prompt()) ? string3 : argSpec.prompt();
            try {
                char[] cArray;
                Tracer tracer = CommandLine.tracer();
                if (tracer.isDebug()) {
                    tracer.debug("Reading value for %s from console...", string);
                }
                char[] cArray2 = cArray = argSpec.echo() ? this.readUserInputWithEchoing(string4) : this.readPassword(string4);
                if (tracer.isDebug()) {
                    tracer.debug(this.createUserInputDebugString(argSpec, cArray, string), new Object[0]);
                }
                char[] cArray3 = cArray;
                return cArray3;
            }
            finally {
                ++this.interactiveCount;
            }
        }

        private String createUserInputDebugString(Model.ArgSpec argSpec, char[] cArray, String string) {
            return argSpec.echo() ? String.format("User entered %s for %s.%n", new String(cArray), string) : String.format("User entered %d characters for %s.%n", cArray.length, string);
        }

        char[] readPassword(String string) {
            try {
                Object object = System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]);
                Method method = Class.forName("java.io.Console").getDeclaredMethod("readPassword", String.class, Object[].class);
                return (char[])method.invoke(object, string, new Object[0]);
            }
            catch (Exception exception) {
                return this.readUserInputWithEchoing(string);
            }
        }

        char[] readUserInputWithEchoing(String string) {
            System.out.print(string);
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string2 = bufferedReader.readLine();
                return string2 == null ? new char[]{} : string2.toCharArray();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        int getPosition(Model.ArgSpec argSpec) {
            if (argSpec.group() == null) {
                return this.position;
            }
            ParseResult.GroupMatchContainer groupMatchContainer = this.parseResultBuilder.groupMatchContainer.findLastMatchContainer(argSpec.group());
            return groupMatchContainer == null ? 0 : groupMatchContainer.lastMatch().position;
        }

        String positionDesc(Model.ArgSpec argSpec) {
            int n2 = this.getPosition(argSpec);
            return argSpec.group() == null ? n2 + " (command-local)" : n2 + " (in group " + argSpec.group().synopsis() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LookBehind {
        SEPARATE,
        ATTACHED,
        ATTACHED_WITH_SEPARATOR;


        static LookBehind parse(String string) {
            if ("".equals(string)) {
                return ATTACHED;
            }
            if (" ".equals(string)) {
                return SEPARATE;
            }
            return ATTACHED_WITH_SEPARATOR;
        }

        String toString(String string) {
            return this == ATTACHED ? "" : (this == SEPARATE ? " " : string);
        }

        public boolean isAttached() {
            return this != SEPARATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult {
        private final Model.CommandSpec commandSpec;
        private final Set<Model.OptionSpec> matchedUniqueOptions;
        private final Set<Model.PositionalParamSpec> matchedUniquePositionals;
        private final List<Model.ArgSpec> matchedArgs;
        private final List<Model.OptionSpec> matchedOptions;
        private final List<Model.PositionalParamSpec> matchedPositionals;
        private final List<String> originalArgs;
        private final List<String> expandedArgs;
        private final List<String> unmatched;
        private final List<List<Model.PositionalParamSpec>> matchedPositionalParams;
        private final List<Exception> errors;
        private final GroupMatchContainer groupMatchContainer;
        private final List<ParseResult> subcommands;
        final List<Object> tentativeMatch;
        private final boolean usageHelpRequested;
        private final boolean versionHelpRequested;

        private ParseResult(Builder builder) {
            this.commandSpec = builder.commandSpec;
            this.subcommands = builder.subcommands;
            this.matchedOptions = new ArrayList<Model.OptionSpec>(builder.matchedOptionsList);
            this.matchedUniqueOptions = new LinkedHashSet<Model.OptionSpec>(builder.options);
            this.unmatched = new ArrayList<String>(builder.unmatched);
            this.originalArgs = new ArrayList<String>(builder.originalArgList);
            this.expandedArgs = new ArrayList<String>(builder.expandedArgList);
            this.matchedArgs = new ArrayList<Model.ArgSpec>(builder.matchedArgsList);
            this.matchedUniquePositionals = new LinkedHashSet<Model.PositionalParamSpec>(builder.positionals);
            this.matchedPositionals = new ArrayList<Model.PositionalParamSpec>(builder.matchedPositionalsList);
            this.matchedPositionalParams = new ArrayList<List<Model.PositionalParamSpec>>(builder.positionalParams);
            this.errors = new ArrayList<Exception>(builder.errors);
            this.usageHelpRequested = builder.usageHelpRequested;
            this.versionHelpRequested = builder.versionHelpRequested;
            this.tentativeMatch = builder.nowProcessing;
            this.groupMatchContainer = builder.groupMatchContainer.trim();
        }

        public static Builder builder(Model.CommandSpec commandSpec) {
            return new Builder(commandSpec);
        }

        public List<GroupMatchContainer> findMatches(Model.ArgGroupSpec argGroupSpec) {
            return this.groupMatchContainer.findMatchContainers(argGroupSpec, new ArrayList<GroupMatchContainer>());
        }

        public List<GroupMatch> getGroupMatches() {
            return this.groupMatchContainer.matches();
        }

        public Model.OptionSpec matchedOption(char c2) {
            return Model.CommandSpec.findOption(c2, this.matchedOptions);
        }

        public Model.OptionSpec matchedOption(String string) {
            return Model.CommandSpec.findOption(string, this.matchedOptions);
        }

        public Model.PositionalParamSpec matchedPositional(int n2) {
            if (this.matchedPositionalParams.size() <= n2 || this.matchedPositionalParams.get(n2).isEmpty()) {
                return null;
            }
            return this.matchedPositionalParams.get(n2).get(0);
        }

        public List<Model.PositionalParamSpec> matchedPositionals(int n2) {
            if (this.matchedPositionalParams.size() <= n2) {
                return Collections.emptyList();
            }
            return this.matchedPositionalParams.get(n2) == null ? Collections.emptyList() : this.matchedPositionalParams.get(n2);
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public boolean hasMatchedOption(char c2) {
            return this.matchedOption(c2) != null;
        }

        public boolean hasMatchedOption(String string) {
            return this.matchedOption(string) != null;
        }

        public boolean hasMatchedOption(Model.OptionSpec optionSpec) {
            return this.matchedOptions.contains(optionSpec);
        }

        public boolean hasMatchedPositional(int n2) {
            return this.matchedPositional(n2) != null;
        }

        public boolean hasMatchedPositional(Model.PositionalParamSpec positionalParamSpec) {
            return this.matchedUniquePositionals.contains(positionalParamSpec);
        }

        public Set<Model.OptionSpec> matchedOptionsSet() {
            return Collections.unmodifiableSet(this.matchedUniqueOptions);
        }

        public List<Model.OptionSpec> matchedOptions() {
            return Collections.unmodifiableList(this.matchedOptions);
        }

        public Set<Model.PositionalParamSpec> matchedPositionalsSet() {
            return Collections.unmodifiableSet(this.matchedUniquePositionals);
        }

        public List<Model.PositionalParamSpec> matchedPositionals() {
            return Collections.unmodifiableList(this.matchedPositionals);
        }

        public List<Model.ArgSpec> matchedArgs() {
            return Collections.unmodifiableList(this.matchedArgs);
        }

        public List<String> unmatched() {
            return Collections.unmodifiableList(this.unmatched);
        }

        public List<String> originalArgs() {
            return Collections.unmodifiableList(this.originalArgs);
        }

        public List<String> expandedArgs() {
            return Collections.unmodifiableList(this.expandedArgs);
        }

        public List<Exception> errors() {
            return Collections.unmodifiableList(this.errors);
        }

        public <T> T matchedOptionValue(char c2, T t2) {
            return this.matchedOptionValue(this.matchedOption(c2), t2);
        }

        public <T> T matchedOptionValue(String string, T t2) {
            return this.matchedOptionValue(this.matchedOption(string), t2);
        }

        private <T> T matchedOptionValue(Model.OptionSpec optionSpec, T t2) {
            return optionSpec == null ? t2 : optionSpec.getValue();
        }

        public <T> T matchedPositionalValue(int n2, T t2) {
            return this.matchedPositionalValue(this.matchedPositional(n2), t2);
        }

        private <T> T matchedPositionalValue(Model.PositionalParamSpec positionalParamSpec, T t2) {
            return positionalParamSpec == null ? t2 : positionalParamSpec.getValue();
        }

        public boolean hasSubcommand() {
            return !this.subcommands.isEmpty();
        }

        public ParseResult subcommand() {
            return !this.hasSubcommand() ? null : this.subcommands.get(this.subcommands.size() - 1);
        }

        public List<ParseResult> subcommands() {
            return Collections.unmodifiableList(this.subcommands);
        }

        public boolean isUsageHelpRequested() {
            return this.usageHelpRequested;
        }

        public boolean isVersionHelpRequested() {
            return this.versionHelpRequested;
        }

        public List<CommandLine> asCommandLineList() {
            return this.recursivelyAddCommandLineTo(new ArrayList<CommandLine>());
        }

        private List<CommandLine> recursivelyAddCommandLineTo(List<CommandLine> list) {
            list.add(this.commandSpec().commandLine());
            for (ParseResult parseResult : this.subcommands()) {
                parseResult.recursivelyAddCommandLineTo(list);
            }
            return list;
        }

        void validateGroups() {
            for (Model.ArgGroupSpec argGroupSpec : this.commandSpec.argGroups()) {
                this.groupMatchContainer.updateUnmatchedGroups(argGroupSpec);
            }
            this.groupMatchContainer.validate(this.commandSpec.commandLine());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GroupMatch {
            int position;
            final int startPosition;
            final GroupMatchContainer container;
            Map<Model.ArgGroupSpec, GroupMatchContainer> matchedSubgroups = new LinkedHashMap<Model.ArgGroupSpec, GroupMatchContainer>(2);
            Map<Model.ArgSpec, List<Object>> matchedValues = new IdentityHashMap<Model.ArgSpec, List<Object>>();
            Map<Model.ArgSpec, List<String>> originalStringValues = new LinkedHashMap<Model.ArgSpec, List<String>>();
            Map<Model.ArgSpec, Map<Integer, List<Object>>> matchedValuesAtPosition = new IdentityHashMap<Model.ArgSpec, Map<Integer, List<Object>>>();
            private GroupValidationResult validationResult;

            GroupMatch(GroupMatchContainer groupMatchContainer) {
                this.container = groupMatchContainer;
                if (!groupMatchContainer.matches().isEmpty()) {
                    this.position = groupMatchContainer.matches().get((int)(groupMatchContainer.matches().size() - 1)).position;
                }
                this.startPosition = this.position;
            }

            public boolean isEmpty() {
                return this.originalStringValues.isEmpty() && this.matchedSubgroups.isEmpty();
            }

            public Model.ArgGroupSpec group() {
                return this.container.group;
            }

            public GroupMatchContainer container() {
                return this.container;
            }

            public Map<Model.ArgGroupSpec, GroupMatchContainer> matchedSubgroups() {
                return Collections.unmodifiableMap(this.matchedSubgroups);
            }

            int matchCount(Model.ArgSpec argSpec) {
                return this.matchedValues.get(argSpec) == null ? 0 : this.matchedValues.get(argSpec).size();
            }

            public List<Object> matchedValues(Model.ArgSpec argSpec) {
                return this.matchedValues.get(argSpec) == null ? Collections.emptyList() : Collections.unmodifiableList(this.matchedValues.get(argSpec));
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String string) {
                CommandLine.addValueToListInMap(this.originalStringValues, argSpec, string);
            }

            void addMatchedValue(Model.ArgSpec argSpec, int n2, Object object, Tracer tracer) {
                CommandLine.addValueToListInMap(this.matchedValues, argSpec, object);
                Map<Integer, List<Object>> map = this.matchedValuesAtPosition.get(argSpec);
                if (map == null) {
                    map = new TreeMap<Integer, List<Object>>();
                    this.matchedValuesAtPosition.put(argSpec, map);
                }
                CommandLine.addValueToListInMap(map, n2, object);
            }

            boolean hasMatchedValueAtPosition(Model.ArgSpec argSpec, int n2) {
                Map<Integer, List<Object>> map = this.matchedValuesAtPosition.get(argSpec);
                return map != null && map.containsKey(n2);
            }

            boolean matchedMinElements() {
                return this.matchedFully(false);
            }

            boolean matchedMaxElements() {
                return this.matchedFully(true);
            }

            private boolean matchedFully(boolean bl2) {
                if (this.group().exclusive()) {
                    return !this.matchedValues.isEmpty() || this.hasFullyMatchedSubgroup(bl2);
                }
                for (Model.ArgSpec object : this.group().args()) {
                    if (this.matchedValues.get(object) != null || !object.required() && !bl2) continue;
                    return false;
                }
                for (Model.ArgGroupSpec argGroupSpec : this.group().subgroups()) {
                    GroupMatchContainer groupMatchContainer = this.matchedSubgroups.get(argGroupSpec);
                    if (!(groupMatchContainer != null ? !groupMatchContainer.matchedFully(bl2) : bl2 || argGroupSpec.multiplicity().min > 0)) continue;
                    return false;
                }
                return true;
            }

            private boolean hasFullyMatchedSubgroup(boolean bl2) {
                for (GroupMatchContainer groupMatchContainer : this.matchedSubgroups.values()) {
                    if (!groupMatchContainer.matchedFully(bl2)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            private StringBuilder toString(StringBuilder stringBuilder) {
                int n2 = stringBuilder.length();
                for (Model.ArgSpec object : this.originalStringValues.keySet()) {
                    List<String> list = this.originalStringValues.get(object);
                    for (String string : list) {
                        if (stringBuilder.length() != n2) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(Model.ArgSpec.describe(object, "=", string));
                    }
                }
                for (GroupMatchContainer groupMatchContainer : this.matchedSubgroups.values()) {
                    if (stringBuilder.length() != n2) {
                        stringBuilder.append(" ");
                    }
                    if (n2 == 0) {
                        stringBuilder.append(groupMatchContainer.toString());
                        continue;
                    }
                    groupMatchContainer.toString(stringBuilder);
                }
                return stringBuilder;
            }

            void validate(CommandLine commandLine) {
                this.validationResult = GroupValidationResult.SUCCESS_PRESENT;
                if (this.group() != null && !this.group().validate()) {
                    return;
                }
                for (GroupMatchContainer object : this.matchedSubgroups.values()) {
                    object.validate(commandLine);
                    if (!object.validationResult.blockingFailure()) continue;
                    this.validationResult = object.validationResult;
                    return;
                }
                if (this.group() != null) {
                    this.validationResult = this.group().validateArgs(commandLine, this.matchedValues.keySet());
                    if (this.validationResult.blockingFailure()) {
                        return;
                    }
                    LinkedHashSet<Model.ArgSpec> linkedHashSet = new LinkedHashSet<Model.ArgSpec>(this.group().args());
                    LinkedHashSet<Model.ArgSpec> linkedHashSet2 = new LinkedHashSet<Model.ArgSpec>(this.group().requiredArgs());
                    LinkedHashSet<Model.ArgSpec> linkedHashSet3 = new LinkedHashSet<Model.ArgSpec>(this.matchedValues.keySet());
                    linkedHashSet2.removeAll(this.matchedValues.keySet());
                    linkedHashSet.retainAll(linkedHashSet3);
                    String string = Model.ArgSpec.describe(linkedHashSet);
                    String string2 = Model.ArgSpec.describe(this.group().requiredArgs());
                    String string3 = Model.ArgSpec.describe(linkedHashSet2);
                    LinkedHashSet<Model.ArgGroupSpec> linkedHashSet4 = new LinkedHashSet<Model.ArgGroupSpec>(this.group().subgroups());
                    linkedHashSet4.removeAll(this.matchedSubgroups.keySet());
                    int n2 = 0;
                    for (Model.ArgGroupSpec bl2 : linkedHashSet4) {
                        if (bl2.multiplicity().min() <= 0) continue;
                        ++n2;
                        if (string3.length() > 0) {
                            string3 = string3 + " and ";
                        }
                        string3 = string3 + bl2.synopsisUnit();
                    }
                    for (Model.ArgGroupSpec bl2 : this.group().subgroups()) {
                        if (string.length() > 0) {
                            string = string + " and ";
                        }
                        string = string + bl2.synopsisUnit();
                        if (bl2.multiplicity().min <= 0) continue;
                        if (string2.length() > 0) {
                            string2 = string2 + " and ";
                        }
                        string2 = string2 + bl2.synopsisUnit();
                    }
                    int n3 = this.matchedValues.size() + this.matchedSubgroups.size();
                    boolean bl2 = !linkedHashSet2.isEmpty() || n2 > 0;
                    this.validationResult = this.group().validate(commandLine, n3, bl2, n3 > 0 && bl2, string, string2, string3);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class GroupMatchContainer {
            private final Model.ArgGroupSpec group;
            private GroupMatchContainer parentContainer;
            private final List<Model.ArgGroupSpec> unmatchedSubgroups = new ArrayList<Model.ArgGroupSpec>();
            private final List<GroupMatch> matches = new ArrayList<GroupMatch>();
            private GroupValidationResult validationResult;

            GroupMatchContainer(Model.ArgGroupSpec argGroupSpec, CommandLine commandLine) {
                this.group = argGroupSpec;
                this.addMatch(commandLine);
            }

            public Model.ArgGroupSpec group() {
                return this.group;
            }

            public List<GroupMatch> matches() {
                return Collections.unmodifiableList(this.matches);
            }

            void addMatch(CommandLine commandLine) {
                Tracer tracer = CommandLine.tracer();
                if (this.group != null && this.isMaxMultiplicityReached()) {
                    tracer.info("Completing GroupMatchContainer %s: max multiplicity is reached.", this);
                    this.complete(commandLine);
                } else {
                    if (this.group != null) {
                        tracer.info("Adding match to GroupMatchContainer %s (group=%s %s).", this, this.group.id(), this.group.synopsisUnit());
                    }
                    this.matches.add(new GroupMatch(this));
                    if (this.group == null) {
                        return;
                    }
                }
                this.group.initUserObject(commandLine);
            }

            void complete(CommandLine commandLine) {
                if (this.parentContainer == null) {
                    this.addMatch(commandLine);
                } else {
                    this.parentContainer.addMatch(commandLine);
                }
            }

            GroupMatch lastMatch() {
                return this.matches.get(this.matches.size() - 1);
            }

            boolean isMaxMultiplicityReached() {
                return this.matches.size() >= ((Model.ArgGroupSpec)this.group).multiplicity.max;
            }

            boolean isMinMultiplicityReached() {
                return this.matches.size() >= ((Model.ArgGroupSpec)this.group).multiplicity.min;
            }

            boolean matchedMinElements() {
                return this.matchedFully(false);
            }

            boolean matchedMaxElements() {
                return this.matchedFully(true);
            }

            private boolean matchedFully(boolean bl2) {
                for (GroupMatch groupMatch : this.matches) {
                    boolean bl3;
                    if (groupMatch.matchedFully(bl3 = bl2 && groupMatch == this.lastMatch())) continue;
                    return false;
                }
                return bl2 ? this.isMaxMultiplicityReached() : this.isMinMultiplicityReached();
            }

            private GroupMatchContainer findOrCreateMatchingGroup(Model.ArgSpec argSpec, CommandLine commandLine) {
                GroupMatchContainer groupMatchContainer;
                Model.ArgGroupSpec argGroupSpec = Assert.notNull(argSpec.group(), "group for " + argSpec);
                if (argGroupSpec == (groupMatchContainer = this).group()) {
                    return groupMatchContainer;
                }
                ArrayList<Model.ArgGroupSpec> arrayList = new ArrayList<Model.ArgGroupSpec>();
                while (argGroupSpec != null) {
                    arrayList.add(argGroupSpec);
                    argGroupSpec = argGroupSpec.parentGroup();
                }
                Collections.reverse(arrayList);
                for (Model.ArgGroupSpec argGroupSpec2 : arrayList) {
                    GroupMatchContainer groupMatchContainer2 = groupMatchContainer.lastMatch().matchedSubgroups().get(argGroupSpec2);
                    if (groupMatchContainer2 == null) {
                        groupMatchContainer2 = this.createGroupMatchContainer(argGroupSpec2, groupMatchContainer, commandLine);
                    }
                    groupMatchContainer = groupMatchContainer2;
                }
                return groupMatchContainer;
            }

            private GroupMatchContainer createGroupMatchContainer(Model.ArgGroupSpec argGroupSpec, GroupMatchContainer groupMatchContainer, CommandLine commandLine) {
                GroupMatchContainer groupMatchContainer2 = new GroupMatchContainer(argGroupSpec, commandLine);
                groupMatchContainer2.parentContainer = groupMatchContainer;
                groupMatchContainer.lastMatch().matchedSubgroups.put(argGroupSpec, groupMatchContainer2);
                return groupMatchContainer2;
            }

            GroupMatchContainer trim() {
                Iterator<GroupMatch> iterator = this.matches.iterator();
                while (iterator.hasNext()) {
                    GroupMatch groupMatch = iterator.next();
                    if (groupMatch.isEmpty()) {
                        iterator.remove();
                    }
                    for (GroupMatchContainer groupMatchContainer : groupMatch.matchedSubgroups.values()) {
                        groupMatchContainer.trim();
                    }
                }
                return this;
            }

            List<GroupMatchContainer> findMatchContainers(Model.ArgGroupSpec argGroupSpec, List<GroupMatchContainer> list) {
                if (this.group == argGroupSpec) {
                    list.add(this);
                    return list;
                }
                for (GroupMatch groupMatch : this.matches()) {
                    for (GroupMatchContainer groupMatchContainer : groupMatch.matchedSubgroups.values()) {
                        groupMatchContainer.findMatchContainers(argGroupSpec, list);
                    }
                }
                return list;
            }

            GroupMatchContainer findLastMatchContainer(Model.ArgGroupSpec argGroupSpec) {
                List<GroupMatchContainer> list = this.findMatchContainers(argGroupSpec, new ArrayList<GroupMatchContainer>());
                return list.isEmpty() ? null : list.get(list.size() - 1);
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            private StringBuilder toString(StringBuilder stringBuilder) {
                String string;
                String string2 = stringBuilder.length() == 0 ? "={" : "";
                String string3 = string = stringBuilder.length() == 0 ? "}" : "";
                if (this.group != null && stringBuilder.length() == 0) {
                    stringBuilder.append(this.group.synopsis());
                }
                stringBuilder.append(string2);
                String string4 = "";
                for (GroupMatch groupMatch : this.matches) {
                    stringBuilder.append(string4);
                    groupMatch.toString(stringBuilder);
                    string4 = " ";
                }
                return stringBuilder.append(string);
            }

            void updateUnmatchedGroups(final Model.ArgGroupSpec argGroupSpec) {
                Assert.assertTrue(Assert.equals(this.group(), argGroupSpec.parentGroup()), new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return "Internal error: expected " + argGroupSpec.parentGroup() + " (the parent of " + argGroupSpec + "), but was " + GroupMatchContainer.this.group();
                    }
                });
                List<GroupMatchContainer> list = this.findMatchContainers(argGroupSpec, new ArrayList<GroupMatchContainer>());
                if (list.isEmpty()) {
                    this.unmatchedSubgroups.add(argGroupSpec);
                }
                for (GroupMatchContainer groupMatchContainer : list) {
                    for (Model.ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups()) {
                        groupMatchContainer.updateUnmatchedGroups(argGroupSpec2);
                    }
                }
            }

            void validate(CommandLine commandLine) {
                if (this.group() == null && this.matches.size() > 1) {
                    this.failGroupMultiplicityExceeded(this.matches, commandLine);
                }
                this.validationResult = this.matches.isEmpty() ? GroupValidationResult.SUCCESS_ABSENT : GroupValidationResult.SUCCESS_PRESENT;
                for (Model.ArgGroupSpec object : this.unmatchedSubgroups) {
                    if (!object.validate() || object.multiplicity().min <= 0) continue;
                    int n2 = 0;
                    boolean bl2 = true;
                    boolean bl3 = false;
                    String string = object.synopsisUnit();
                    String string2 = object.synopsisUnit();
                    this.validationResult = object.validate(commandLine, n2, bl2, bl3, string, string2, string2);
                }
                this.validateGroupMultiplicity(commandLine);
                if (this.validationResult.blockingFailure()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
                for (GroupMatch groupMatch : this.matches()) {
                    groupMatch.validate(commandLine);
                    if (!groupMatch.validationResult.blockingFailure()) continue;
                    this.validationResult = groupMatch.validationResult;
                    break;
                }
                if (this.validationResult.blockingFailure()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
                if (this.group() == null && !this.validationResult.success()) {
                    commandLine.interpreter.maybeThrow(this.validationResult.exception);
                }
            }

            private void failGroupMultiplicityExceeded(List<GroupMatch> list, CommandLine commandLine) {
                LinkedHashMap<Model.ArgGroupSpec, List<List<GroupMatch>>> linkedHashMap = new LinkedHashMap<Model.ArgGroupSpec, List<List<GroupMatch>>>();
                String string = "";
                for (GroupMatch groupMatch : list) {
                    if (string.length() > 0) {
                        string = string + " and ";
                    }
                    string = string + groupMatch;
                    Map<Model.ArgGroupSpec, GroupMatchContainer> map = groupMatch.matchedSubgroups();
                    for (Model.ArgGroupSpec argGroupSpec : map.keySet()) {
                        if (!argGroupSpec.validate()) continue;
                        CommandLine.addValueToListInMap(linkedHashMap, argGroupSpec, map.get(argGroupSpec).matches());
                    }
                }
                if (!linkedHashMap.isEmpty() && !this.simplifyErrorMessageForSingleGroup(linkedHashMap, commandLine)) {
                    commandLine.interpreter.maybeThrow(new MaxValuesExceededException(commandLine, "Error: expected only one match but got " + string));
                }
            }

            private boolean simplifyErrorMessageForSingleGroup(Map<Model.ArgGroupSpec, List<List<GroupMatch>>> map, CommandLine commandLine) {
                for (Model.ArgGroupSpec argGroupSpec : map.keySet()) {
                    List<GroupMatch> list = CommandLine.flatList((Collection)map.get(argGroupSpec));
                    LinkedHashSet<Model.ArgSpec> linkedHashSet = new LinkedHashSet<Model.ArgSpec>();
                    for (GroupMatch groupMatch : list) {
                        if (!groupMatch.matchedSubgroups().isEmpty()) {
                            return false;
                        }
                        linkedHashSet.addAll(groupMatch.matchedValues.keySet());
                    }
                    GroupValidationResult groupValidationResult = argGroupSpec.validateArgs(commandLine, linkedHashSet);
                    if (groupValidationResult.exception == null) continue;
                    commandLine.interpreter.maybeThrow(groupValidationResult.exception);
                    return true;
                }
                return false;
            }

            private void validateGroupMultiplicity(CommandLine commandLine) {
                boolean bl2;
                if (this.group == null || !this.group.validate()) {
                    return;
                }
                int n2 = this.matches().size();
                boolean bl3 = bl2 = n2 > 0 || !this.group.args().isEmpty();
                if (bl2 && n2 < this.group.multiplicity().min) {
                    if (this.validationResult.success()) {
                        this.validationResult = new GroupValidationResult(n2 == 0 ? GroupValidationResult.Type.FAILURE_ABSENT : GroupValidationResult.Type.FAILURE_PARTIAL, new MissingParameterException(commandLine, this.group.args(), "Error: Group: " + this.group.synopsisUnit() + " must be specified " + this.group.multiplicity().min + " times but was matched " + n2 + " times"));
                    }
                } else if (n2 > this.group.multiplicity().max && !this.validationResult.blockingFailure()) {
                    this.validationResult = new GroupValidationResult(GroupValidationResult.Type.FAILURE_PRESENT, new MaxValuesExceededException(commandLine, "Error: Group: " + this.group.synopsisUnit() + " can only be specified " + this.group.multiplicity().max + " times but was matched " + n2 + " times."));
                }
            }

            boolean canMatchPositionalParam(Model.PositionalParamSpec positionalParamSpec) {
                int n2;
                boolean bl2;
                boolean bl3 = !this.matches.isEmpty() && this.lastMatch().matchedMinElements();
                boolean bl4 = bl2 = !this.matches.isEmpty() && this.lastMatch().matchedMaxElements();
                if (bl2 && this.isMaxMultiplicityReached()) {
                    return false;
                }
                int n3 = this.matches.isEmpty() ? 0 : this.lastMatch().startPosition;
                int n4 = this.matches.isEmpty() ? 0 : this.lastMatch().position;
                int n5 = n4 - n3;
                if (bl3 && (n2 = positionalParamSpec.group().localPositionalParamCount()) != 0) {
                    n5 %= n2;
                }
                return positionalParamSpec.index().contains(n5) && !this.lastMatch().hasMatchedValueAtPosition(positionalParamSpec, n4);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class GroupValidationResult {
            static final GroupValidationResult SUCCESS_PRESENT = new GroupValidationResult(Type.SUCCESS_PRESENT);
            static final GroupValidationResult SUCCESS_ABSENT = new GroupValidationResult(Type.SUCCESS_ABSENT);
            Type type;
            ParameterException exception;

            GroupValidationResult(Type type) {
                this.type = type;
            }

            GroupValidationResult(Type type, ParameterException parameterException) {
                this.type = type;
                this.exception = parameterException;
            }

            static GroupValidationResult extractBlockingFailure(List<GroupValidationResult> list) {
                for (GroupValidationResult groupValidationResult : list) {
                    if (!groupValidationResult.blockingFailure()) continue;
                    return groupValidationResult;
                }
                return null;
            }

            boolean blockingFailure() {
                return this.type == Type.FAILURE_PRESENT || this.type == Type.FAILURE_PARTIAL;
            }

            boolean present() {
                return this.type == Type.SUCCESS_PRESENT;
            }

            boolean success() {
                return this.type == Type.SUCCESS_ABSENT || this.type == Type.SUCCESS_PRESENT;
            }

            public String toString() {
                return (Object)((Object)this.type) + (this.exception == null ? "" : ": " + this.exception.getMessage());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static enum Type {
                SUCCESS_PRESENT,
                SUCCESS_ABSENT,
                FAILURE_PRESENT,
                FAILURE_ABSENT,
                FAILURE_PARTIAL;

            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder {
            private final Model.CommandSpec commandSpec;
            private final List<Model.ArgSpec> matchedArgsList = new ArrayList<Model.ArgSpec>();
            private final List<Model.OptionSpec> matchedOptionsList = new ArrayList<Model.OptionSpec>();
            private final List<Model.PositionalParamSpec> matchedPositionalsList = new ArrayList<Model.PositionalParamSpec>();
            private final Set<Model.OptionSpec> options = new LinkedHashSet<Model.OptionSpec>();
            private final Set<Model.PositionalParamSpec> positionals = new LinkedHashSet<Model.PositionalParamSpec>();
            private final List<String> unmatched = new ArrayList<String>();
            private int firstUnmatchedPosition = Integer.MAX_VALUE;
            private final List<String> originalArgList = new ArrayList<String>();
            private final List<String> expandedArgList = new ArrayList<String>();
            private final List<List<Model.PositionalParamSpec>> positionalParams = new ArrayList<List<Model.PositionalParamSpec>>();
            private final List<ParseResult> subcommands = new ArrayList<ParseResult>();
            private boolean usageHelpRequested;
            private boolean versionHelpRequested;
            boolean isInitializingDefaultValues;
            private final List<Exception> errors = new ArrayList<Exception>(1);
            private List<Object> nowProcessing;
            private final GroupMatchContainer groupMatchContainer = new GroupMatchContainer(null, null);

            private Builder(Model.CommandSpec commandSpec) {
                this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            }

            public ParseResult build() {
                return new ParseResult(this);
            }

            private void nowProcessing(Model.ArgSpec argSpec, Object object) {
                if (this.nowProcessing != null && !this.isInitializingDefaultValues) {
                    this.nowProcessing.add(argSpec.isPositional() ? argSpec : object);
                }
            }

            public Builder add(Model.ArgSpec argSpec, int n2) {
                if (argSpec.isOption()) {
                    this.addOption((Model.OptionSpec)argSpec);
                } else {
                    this.addPositionalParam((Model.PositionalParamSpec)argSpec, n2);
                }
                return this;
            }

            public Builder addOption(Model.OptionSpec optionSpec) {
                if (!this.isInitializingDefaultValues) {
                    this.options.add(optionSpec);
                    this.matchedOptionsList.add(optionSpec);
                    this.matchedArgsList.add(optionSpec);
                }
                return this;
            }

            public Builder addPositionalParam(Model.PositionalParamSpec positionalParamSpec, int n2) {
                if (this.isInitializingDefaultValues) {
                    return this;
                }
                this.positionals.add(positionalParamSpec);
                this.matchedPositionalsList.add(positionalParamSpec);
                this.matchedArgsList.add(positionalParamSpec);
                while (this.positionalParams.size() <= n2) {
                    this.positionalParams.add(new ArrayList());
                }
                this.positionalParams.get(n2).add(positionalParamSpec);
                return this;
            }

            private Builder addUnmatched(int n2, String string) {
                if (n2 >= 0) {
                    this.firstUnmatchedPosition = Math.min(n2, this.firstUnmatchedPosition);
                }
                this.unmatched.add(string);
                return this;
            }

            public Builder addUnmatched(String string) {
                return this.addUnmatched(-1, string);
            }

            public Builder addUnmatched(Stack<String> stack) {
                while (!stack.isEmpty()) {
                    this.addUnmatched(this.totalArgCount() - stack.size(), stack.pop());
                }
                return this;
            }

            private int totalArgCount() {
                CommandLine commandLine = this.commandSpec.root().commandLine;
                Builder builder = commandLine == null || commandLine.interpreter.parseResultBuilder == null ? this : commandLine.interpreter.parseResultBuilder;
                return builder.expandedArgList.size();
            }

            public Builder subcommand(ParseResult parseResult) {
                this.subcommands.add(0, parseResult);
                return this;
            }

            public Builder originalArgs(String[] stringArray) {
                this.originalArgList.addAll(Arrays.asList(stringArray));
                return this;
            }

            public Builder expandedArgs(Collection<String> collection) {
                this.expandedArgList.addAll(collection);
                return this;
            }

            void addStringValue(Model.ArgSpec argSpec, String string) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.stringValues.add(string);
                }
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String string) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.originalStringValues.add(string);
                    if (argSpec.group() != null) {
                        GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findLastMatchContainer(argSpec.group());
                        groupMatchContainer.lastMatch().addOriginalStringValue(argSpec, string);
                    }
                }
            }

            void addTypedValues(Model.ArgSpec argSpec, int n2, Object object) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.typedValues.add(object);
                    if (argSpec.group() == null) {
                        argSpec.typedValueAtPosition.put(n2, object);
                    } else {
                        GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findLastMatchContainer(argSpec.group());
                        groupMatchContainer.lastMatch().addMatchedValue(argSpec, n2, object, CommandLine.tracer());
                    }
                }
            }

            public void addError(PicocliException picocliException) {
                this.errors.add(Assert.notNull(picocliException, "exception"));
            }

            void beforeMatchingGroupElement(Model.ArgSpec argSpec) throws Exception {
                Model.ArgGroupSpec argGroupSpec = argSpec.group();
                if (argGroupSpec == null || this.isInitializingDefaultValues) {
                    return;
                }
                Tracer tracer = CommandLine.tracer();
                GroupMatchContainer groupMatchContainer = this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                GroupMatch groupMatch = groupMatchContainer.lastMatch();
                boolean bl2 = true;
                boolean bl3 = bl2 && argSpec.isMultiValue();
                String string = Model.ArgSpec.describe(argSpec, "=");
                if (groupMatch.matchedMinElements() && (argSpec.required() || groupMatch.matchCount(argSpec) > 0) && !bl3) {
                    String string2 = argSpec.required() ? "is required" : "has already been matched";
                    tracer.info("GroupMatch %s is complete: its mandatory elements are all matched. (User object: %s.) %s %s in the group, so it starts a new GroupMatch.", groupMatchContainer.lastMatch(), groupMatchContainer.group.userObject(), string, string2);
                    groupMatchContainer.addMatch(this.commandSpec.commandLine);
                    this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                } else if (groupMatch.matchCount(argSpec) > 0 && !bl3) {
                    tracer.info("GroupMatch %s is incomplete: its mandatory elements are not all matched. (User object: %s.) However, %s has already been matched in the group, so it starts a new GroupMatch.", groupMatchContainer.lastMatch(), groupMatchContainer.group.userObject(), string);
                    groupMatchContainer.addMatch(this.commandSpec.commandLine);
                    this.groupMatchContainer.findOrCreateMatchingGroup(argSpec, this.commandSpec.commandLine);
                }
            }
        }
    }

    public static final class Model {
        private Model() {
        }

        private static boolean initializable(Object object, Object object2, Object object3) {
            return object == null && Model.isNonDefault(object2, object3);
        }

        private static boolean initializable(Object object, Object[] objectArray, Object[] objectArray2) {
            return object == null && Model.isNonDefault(objectArray, objectArray2);
        }

        private static boolean isNonDefault(Object object, Object object2) {
            return !Assert.notNull(object2, "defaultValue").equals(object);
        }

        private static boolean isNonDefault(Object[] objectArray, Object[] objectArray2) {
            return !Arrays.equals(Assert.notNull(objectArray2, "defaultValue"), objectArray);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Interpolator {
            private final CommandSpec commandSpec;
            private final Map<String, ILookup> lookups = new LinkedHashMap<String, ILookup>();

            public Interpolator(final CommandSpec commandSpec) {
                this.commandSpec = commandSpec;
                this.lookups.put("sys:", new ILookup(){

                    public String get(String string) {
                        return System.getProperty(string);
                    }
                });
                this.lookups.put("env:", new ILookup(){

                    public String get(String string) {
                        return System.getenv(string);
                    }
                });
                this.lookups.put("bundle:", new ILookup(){

                    public String get(String string) {
                        return Interpolator.bundleValue(commandSpec.resourceBundle(), string);
                    }
                });
                this.lookups.put("", new ILookup(){

                    public String get(String string) {
                        String string2;
                        String string3 = "COMMAND-NAME".equals(string) ? commandSpec.name() : ("COMMAND-FULL-NAME".equals(string) ? commandSpec.qualifiedName() : ("PARENT-COMMAND-NAME".equals(string) && commandSpec.parent() != null ? commandSpec.parent().name() : ("PARENT-COMMAND-FULL-NAME".equals(string) && commandSpec.parent() != null ? commandSpec.parent().qualifiedName() : (string2 = "ROOT-COMMAND-NAME".equals(string) ? commandSpec.root().name() : null))));
                        if (string2 == null) {
                            string2 = System.getProperty(string);
                        }
                        if (string2 == null) {
                            string2 = System.getenv(string);
                        }
                        if (string2 == null) {
                            string2 = Interpolator.bundleValue(commandSpec.resourceBundle(), string);
                        }
                        return string2;
                    }
                });
            }

            private static String bundleValue(ResourceBundle resourceBundle, String string) {
                if (resourceBundle != null) {
                    try {
                        return resourceBundle.getString(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return null;
                    }
                }
                return null;
            }

            public String[] interpolate(String[] stringArray) {
                if (stringArray == null || stringArray.length == 0) {
                    return stringArray;
                }
                String[] stringArray2 = new String[stringArray.length];
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    stringArray2[i2] = this.interpolate(stringArray[i2]);
                }
                return stringArray2;
            }

            public String interpolate(String string) {
                if (string == null || !this.commandSpec.interpolateVariables()) {
                    return string;
                }
                return this.resolveLookups(string, new HashSet<String>(), new HashMap<String, String>());
            }

            public String interpolateCommandName(String string) {
                if (string == null || !this.commandSpec.interpolateVariables()) {
                    return string;
                }
                return this.resolveLookups(string, new HashSet<String>(), new HashMap<String, String>());
            }

            private String resolveLookups(String string, Set<String> set, Map<String, String> map) {
                if (string == null) {
                    return null;
                }
                for (String string2 : this.lookups.keySet()) {
                    ILookup iLookup = this.lookups.get(string2);
                    String string3 = "${" + string2;
                    int n2 = 0;
                    while ((n2 = this.findOpeningDollar(string, string3, n2)) >= 0) {
                        String string4;
                        String string5;
                        int n3 = this.findClosingBrace(string, n2 + string3.length());
                        if (n3 < 0) {
                            n3 = string.length() - 1;
                        }
                        String string6 = string5 = string.substring(n2 + string3.length(), n3);
                        int n4 = string5.indexOf(":-");
                        if (n4 >= 0) {
                            string6 = string5.substring(0, n4);
                        }
                        String string7 = string4 = map.containsKey(string3 + string6) ? map.get(string3 + string6) : iLookup.get(string6);
                        if (set.contains(string3 + string6) && !map.containsKey(string3 + string6)) {
                            throw new InitializationException("Lookup '" + string3 + string6 + "' has a circular reference.");
                        }
                        set.add(string3 + string6);
                        if (string4 == null && n4 >= 0) {
                            String string8 = string5.substring(n4 + 2);
                            string4 = this.resolveLookups(string8, set, map);
                        }
                        map.put(string3 + string6, string4);
                        if (string4 == null && n2 == 0 && n3 == string.length() - 1) {
                            return null;
                        }
                        string = string.substring(0, n2) + string4 + string.substring(n3 + 1);
                        n2 += string4 == null ? "null".length() : string4.length();
                    }
                }
                return string.replace("$$", "$");
            }

            private int findOpeningDollar(String string, String string2, int n2) {
                int n3;
                int n4 = -1;
                boolean bl2 = false;
                for (int i2 = n2; i2 < string.length(); i2 += Character.charCount(n3)) {
                    n3 = string.codePointAt(i2);
                    if (n3 == 36) {
                        n4 = bl2 ? -1 : i2;
                        bl2 = !bl2;
                    } else {
                        bl2 = false;
                    }
                    if (n4 != -1 && n3 != string2.codePointAt(i2 - n4)) {
                        n4 = -1;
                    }
                    if (n4 == -1 || i2 - n4 != string2.length() - 1) continue;
                    return n4;
                }
                return -1;
            }

            private int findClosingBrace(String string, int n2) {
                int n3;
                int n4 = 1;
                boolean bl2 = false;
                block5: for (int i2 = n2; i2 < string.length(); i2 += Character.charCount(n3)) {
                    n3 = string.codePointAt(i2);
                    switch (n3) {
                        case 92: {
                            bl2 = !bl2;
                            continue block5;
                        }
                        case 125: {
                            if (!bl2) {
                                --n4;
                            }
                            if (n4 == 0) {
                                return i2;
                            }
                            bl2 = false;
                            continue block5;
                        }
                        case 123: {
                            if (!bl2) {
                                ++n4;
                            }
                            bl2 = false;
                            continue block5;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                }
                return -1;
            }

            static interface ILookup {
                public String get(String var1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CommandUserObject
        implements IScope {
            private final IFactory factory;
            private Object instance;
            private Class<?> type;
            private CommandSpec commandSpec;

            private CommandUserObject(Object object, IFactory iFactory) {
                this.factory = Assert.notNull(iFactory, "factory");
                if (object instanceof Class) {
                    this.instance = null;
                    this.type = (Class)object;
                } else {
                    this.instance = object;
                    this.type = object == null || object instanceof Method ? null : object.getClass();
                }
            }

            public String toString() {
                if (this.type == null && this.instance == null) {
                    return "null";
                }
                if (this.type == null) {
                    return String.valueOf(this.instance);
                }
                if (this.instance == null) {
                    return String.valueOf(this.type);
                }
                return this.type.getName() + "@" + Integer.toHexString(System.identityHashCode(this.instance));
            }

            public CommandUserObject copy() {
                return new CommandUserObject(this.type == null ? this.instance : this.type, this.factory);
            }

            public static CommandUserObject create(Object object, IFactory iFactory) {
                if (object instanceof CommandUserObject) {
                    return (CommandUserObject)object;
                }
                return new CommandUserObject(object, iFactory);
            }

            public Object getInstance() {
                if (this.instance == null) {
                    Tracer tracer = CommandLine.tracer();
                    if (this.type == null) {
                        tracer.debug("Returning a null user object instance", new Object[0]);
                        return null;
                    }
                    try {
                        tracer.debug("Getting a %s instance from factory %s", this.type.getName(), this.factory);
                        this.instance = DefaultFactory.create(this.factory, this.type);
                        this.type = this.instance.getClass();
                        tracer.debug("Factory returned a %s instance (%s)", this.type.getName(), Integer.toHexString(System.identityHashCode(this.instance)));
                    }
                    catch (InitializationException initializationException) {
                        if (this.type.isInterface()) {
                            tracer.debug("%s. Creating Proxy for interface %s", initializationException.getCause(), this.type.getName());
                            this.instance = Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (InvocationHandler)new PicocliInvocationHandler());
                            tracer.debug("Created Proxy instance (%s)", Integer.toHexString(System.identityHashCode(this.instance)));
                        }
                        throw initializationException;
                    }
                    if (this.commandSpec != null) {
                        for (ArgSpec argSpec : this.commandSpec.args()) {
                            if (argSpec.group() != null || argSpec.hasInitialValue()) continue;
                            argSpec.initialValue();
                        }
                    }
                }
                return this.instance;
            }

            public Class<?> getType() {
                return this.type;
            }

            public boolean isMethod() {
                return this.instance instanceof Method;
            }

            @Override
            public <T> T get() {
                return (T)this.getInstance();
            }

            @Override
            public <T> T set(T t2) {
                throw new UnsupportedOperationException();
            }

            public boolean isProxyClass() {
                if (this.type == null || !this.type.isInterface()) {
                    return false;
                }
                return Proxy.isProxyClass(this.getInstance().getClass());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ObjectScope
        implements IScope {
            private Object value;

            public ObjectScope(Object object) {
                this.value = object;
            }

            public static boolean isProxyClass(IScope iScope) {
                if (iScope instanceof CommandUserObject) {
                    return ((CommandUserObject)iScope).isProxyClass();
                }
                Object object = ObjectScope.tryGet(iScope);
                return object != null && Proxy.isProxyClass(object.getClass());
            }

            public static boolean hasInstance(IScope iScope) {
                if (iScope instanceof CommandUserObject) {
                    return ((CommandUserObject)iScope).instance != null;
                }
                return ObjectScope.tryGet(iScope) != null;
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T t2) {
                Object object = this.value;
                this.value = t2;
                return (T)object;
            }

            public static Object tryGet(IScope iScope) {
                try {
                    return iScope.get();
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not get scope value", exception);
                }
            }

            static IScope asScope(Object object) {
                return object instanceof IScope ? (IScope)object : new ObjectScope(object);
            }

            public String toString() {
                return String.format("Scope(value=%s)", this.value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ObjectBinding
        implements IGetter,
        ISetter {
            private Object value;

            private ObjectBinding() {
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T t2) {
                T t3 = t2;
                this.value = t2;
                return t3;
            }

            public String toString() {
                return String.format("%s(value=%s)", this.getClass().getSimpleName(), this.value);
            }
        }

        private static class PicocliInvocationHandler
        implements InvocationHandler {
            final Map<String, Object> map = new HashMap<String, Object>();

            private PicocliInvocationHandler() {
            }

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                return this.map.get(method.getName());
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ProxyBinding
            implements IGetter,
            ISetter {
                private final Method method;

                ProxyBinding(Method method) {
                    this.method = Assert.notNull(method, "method");
                }

                @Override
                public <T> T get() {
                    return (T)PicocliInvocationHandler.this.map.get(this.method.getName());
                }

                @Override
                public <T> T set(T t2) {
                    T t3 = this.get();
                    PicocliInvocationHandler.this.map.put(this.method.getName(), t2);
                    return t3;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MethodBinding
        implements IGetter,
        ISetter,
        IScoped {
            private final IScope scope;
            private final Method method;
            private final CommandSpec spec;
            private Object currentValue;

            MethodBinding(IScope iScope, Method method, CommandSpec commandSpec) {
                this.scope = iScope;
                this.method = method;
                this.spec = commandSpec;
            }

            @Override
            public IScope getScope() {
                return this.scope;
            }

            @Override
            public <T> T get() {
                return (T)this.currentValue;
            }

            @Override
            public <T> T set(T t2) throws PicocliException {
                Object t3;
                try {
                    t3 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for method " + this.method, exception);
                }
                try {
                    Object object = this.currentValue;
                    this.method.invoke(t3, t2);
                    this.currentValue = t2;
                    return (T)object;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof PicocliException) {
                        throw (PicocliException)invocationTargetException.getTargetException();
                    }
                    throw this.createParameterException(t2, invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    throw this.createParameterException(t2, exception);
                }
            }

            private ParameterException createParameterException(Object object, Throwable throwable) {
                CommandLine commandLine = this.spec.commandLine() == null ? new CommandLine(this.spec) : this.spec.commandLine();
                return new ParameterException(commandLine, "Could not invoke " + this.method + " with " + object + " (" + throwable + ")", throwable);
            }

            public String toString() {
                return String.format("%s(%s)", this.getClass().getSimpleName(), this.method);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FieldBinding
        implements IGetter,
        ISetter,
        IScoped {
            private final IScope scope;
            private final Field field;

            FieldBinding(Object object, Field field) {
                this(ObjectScope.asScope(object), field);
            }

            FieldBinding(IScope iScope, Field field) {
                this.scope = iScope;
                this.field = field;
            }

            @Override
            public IScope getScope() {
                return this.scope;
            }

            @Override
            public <T> T get() throws PicocliException {
                Object t2;
                try {
                    t2 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for field " + this.field, exception);
                }
                try {
                    Object object = this.field.get(t2);
                    return (T)object;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get value for field " + this.field, exception);
                }
            }

            @Override
            public <T> T set(T t2) throws PicocliException {
                Object t3;
                try {
                    t3 = this.scope.get();
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get scope for field " + this.field, exception);
                }
                try {
                    Object object = this.field.get(t3);
                    this.field.set(t3, t2);
                    return (T)object;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not set value for field " + this.field + " to " + t2, exception);
                }
            }

            public String toString() {
                return String.format("%s(%s %s.%s)", this.getClass().getSimpleName(), this.field.getType().getName(), this.field.getDeclaringClass().getName(), this.field.getName());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CommandReflection {
            private CommandReflection() {
            }

            static ArgGroupSpec extractArgGroupSpec(IAnnotatedElement iAnnotatedElement, IFactory iFactory, CommandSpec commandSpec, boolean bl2) throws Exception {
                Class<Object> clazz;
                Object object = null;
                try {
                    object = iAnnotatedElement.getter().get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Class<Object> clazz2 = clazz = object == null ? iAnnotatedElement.getTypeInfo().getType() : object.getClass();
                if (iAnnotatedElement.isMultiValue()) {
                    clazz = iAnnotatedElement.getTypeInfo().getAuxiliaryTypes()[0];
                }
                ObjectScope objectScope = new ObjectScope(object);
                ArgGroupSpec.Builder builder = ArgGroupSpec.builder(iAnnotatedElement);
                builder.updateArgGroupAttributes(iAnnotatedElement.getAnnotation(ArgGroup.class));
                if (iAnnotatedElement.isOption() || iAnnotatedElement.isParameter()) {
                    if (iAnnotatedElement instanceof TypedMember) {
                        CommandReflection.validateArgSpecMember((TypedMember)iAnnotatedElement);
                    }
                    builder.addArg(CommandReflection.buildArgForMember(iAnnotatedElement, iFactory));
                }
                Stack<Class> stack = new Stack<Class>();
                while (clazz != null) {
                    stack.add(clazz);
                    clazz = clazz.getSuperclass();
                }
                boolean bl3 = false;
                while (!stack.isEmpty()) {
                    clazz = (Class<Object>)stack.pop();
                    bl3 |= CommandReflection.initFromAnnotatedMembers(objectScope, clazz, commandSpec, builder, iFactory, null);
                }
                ArgGroupSpec argGroupSpec = builder.build();
                if (bl2) {
                    CommandReflection.validateArgGroupSpec(argGroupSpec, bl3, clazz.getName());
                }
                return argGroupSpec;
            }

            static CommandSpec extractCommandSpec(Object object, IFactory iFactory, boolean bl2) {
                Assert.notNull(object, "command user object");
                Tracer tracer = CommandLine.tracer();
                if (object instanceof CommandSpec) {
                    tracer.debug("extractCommandSpec returning existing CommandSpec instance %s", object);
                    return (CommandSpec)object;
                }
                CommandUserObject commandUserObject = CommandUserObject.create(object, iFactory);
                tracer.debug("Creating CommandSpec for %s with factory %s", commandUserObject, iFactory.getClass().getName());
                CommandSpec commandSpec = CommandSpec.wrapWithoutInspection(commandUserObject, iFactory);
                boolean bl3 = false;
                if (commandUserObject.isMethod()) {
                    Method method = (Method)object;
                    tracer.debug("Using method %s as command ", method);
                    method.setAccessible(true);
                    Command command = method.getAnnotation(Command.class);
                    commandSpec.updateCommandAttributes(command, iFactory);
                    CommandReflection.injectSpecIntoVersionProvider(commandSpec, command, iFactory);
                    commandSpec.setAddMethodSubcommands(false);
                    bl3 = true;
                    CommandReflection.initSubcommands(command, null, commandSpec, iFactory, Collections.<Class<?>>emptySet());
                    commandSpec.mixinStandardHelpOptions(command.mixinStandardHelpOptions());
                    CommandReflection.initFromMethodParameters(commandUserObject, method, commandSpec, null, iFactory);
                    commandSpec.initName(((Method)object).getName());
                } else {
                    Class clazz;
                    Stack<Class> stack = new Stack<Class>();
                    for (clazz = commandUserObject.getType(); clazz != null; clazz = clazz.getSuperclass()) {
                        stack.add(clazz);
                    }
                    HashSet hashSet = new HashSet(stack);
                    boolean bl4 = false;
                    while (!stack.isEmpty()) {
                        clazz = (Class)stack.pop();
                        Command command = clazz.getAnnotation(Command.class);
                        if (command != null) {
                            commandSpec.updateCommandAttributes(command, iFactory);
                            CommandReflection.injectSpecIntoVersionProvider(commandSpec, command, iFactory);
                            bl3 = true;
                            bl4 |= command.mixinStandardHelpOptions();
                        }
                        CommandReflection.initSubcommands(command, clazz, commandSpec, iFactory, hashSet);
                        CommandReflection.initMethodSubcommands(clazz, commandSpec, iFactory);
                        bl3 |= CommandReflection.initFromAnnotatedMembers(commandUserObject, clazz, commandSpec, null, iFactory, null);
                    }
                    commandSpec.mixinStandardHelpOptions(bl4);
                }
                commandSpec.updateArgSpecMessages();
                if (bl2) {
                    CommandReflection.validateCommandSpec(commandSpec, bl3, commandUserObject.toString());
                }
                commandSpec.validate();
                return commandSpec;
            }

            private static void injectSpecIntoVersionProvider(CommandSpec commandSpec, Command command, IFactory iFactory) {
                if (commandSpec.versionProvider() == null) {
                    return;
                }
                CommandReflection.initFromAnnotatedMembers(new ObjectScope(commandSpec.versionProvider()), command.versionProvider(), commandSpec, null, iFactory, new Predicate<TypedMember>(){

                    @Override
                    public boolean test(TypedMember typedMember) {
                        return typedMember.isSpec() && !typedMember.isArgGroup() && !typedMember.isUnmatched() && !typedMember.isMixin() && !typedMember.isOption() && !typedMember.isParameter() && !typedMember.isParentCommand();
                    }
                });
            }

            private static void initSubcommands(Command command, Class<?> clazz, CommandSpec commandSpec, IFactory iFactory, Set<Class<?>> set) {
                if (command == null) {
                    return;
                }
                for (Class<?> clazz2 : command.subcommands()) {
                    if (clazz2.equals(clazz)) {
                        throw new InitializationException(command.name() + " (" + clazz.getName() + ") cannot be a subcommand of itself");
                    }
                    if (set.contains(clazz2)) {
                        throw new InitializationException(command.name() + " (" + clazz.getName() + ") has a subcommand (" + clazz2.getName() + ") that is a subclass of itself");
                    }
                    try {
                        if (Help.class == clazz2) {
                            throw new InitializationException(Help.class.getName() + " is not a valid subcommand. Did you mean " + HelpCommand.class.getName() + "?");
                        }
                        CommandLine commandLine = CommandLine.toCommandLine(clazz2, iFactory);
                        commandSpec.addSubcommand(CommandReflection.subcommandName(clazz2), commandLine);
                        commandLine.getCommandSpec().injectParentCommand(commandSpec.userObject);
                        for (CommandSpec commandSpec2 : commandLine.getCommandSpec().mixins().values()) {
                            commandSpec2.injectParentCommand(commandSpec.userObject);
                        }
                    }
                    catch (InitializationException initializationException) {
                        throw initializationException;
                    }
                    catch (Exception exception) {
                        throw new InitializationException("Could not instantiate and add subcommand " + clazz2.getName() + ": " + exception, exception);
                    }
                }
            }

            private static void initMethodSubcommands(Class<?> clazz, CommandSpec commandSpec, IFactory iFactory) {
                if (commandSpec.isAddMethodSubcommands() && clazz != null) {
                    for (CommandLine commandLine : CommandSpec.createMethodSubcommands(clazz, iFactory, false)) {
                        commandSpec.addSubcommand(commandLine.getCommandName(), commandLine);
                        for (CommandSpec commandSpec2 : commandLine.getCommandSpec().mixins().values()) {
                            commandSpec2.injectParentCommand(commandSpec.userObject);
                        }
                    }
                }
            }

            private static String subcommandName(Class<?> clazz) {
                Command command = clazz.getAnnotation(Command.class);
                if (command == null || "<main class>".equals(command.name())) {
                    throw new InitializationException("Subcommand " + clazz.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                }
                return command.name();
            }

            private static boolean initFromAnnotatedMembers(IScope iScope, Class<?> clazz, CommandSpec commandSpec, ArgGroupSpec.Builder builder, IFactory iFactory, Predicate<TypedMember> predicate) {
                boolean bl2 = false;
                for (Field accessibleObject : clazz.getDeclaredFields()) {
                    bl2 |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated(accessibleObject, iScope), predicate, commandSpec, builder, iFactory);
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    bl2 |= CommandReflection.initFromAnnotatedTypedMembers(TypedMember.createIfAnnotated((Method)accessibleObject, iScope, commandSpec), predicate, commandSpec, builder, iFactory);
                }
                return bl2;
            }

            private static boolean initFromAnnotatedTypedMembers(TypedMember typedMember, Predicate<TypedMember> predicate, CommandSpec commandSpec, ArgGroupSpec.Builder builder, IFactory iFactory) {
                if (typedMember == null || predicate != null && !predicate.test(typedMember)) {
                    return false;
                }
                boolean bl2 = false;
                if (typedMember.isMixin()) {
                    CommandReflection.assertNoDuplicateAnnotations(typedMember, Mixin.class, Option.class, Parameters.class, Unmatched.class, Spec.class, ArgGroup.class);
                    if (builder != null) {
                        throw new InitializationException("@Mixins are not supported on @ArgGroups");
                    }
                    CommandSpec commandSpec2 = CommandReflection.buildMixinForMember(typedMember, iFactory);
                    commandSpec.addMixin(typedMember.getMixinName(), commandSpec2, typedMember);
                    for (IAnnotatedElement iAnnotatedElement : commandSpec2.specElements) {
                        if (iAnnotatedElement.getAnnotation(Spec.class).value() != Spec.Target.MIXEE) continue;
                        try {
                            iAnnotatedElement.setter().set(commandSpec);
                        }
                        catch (Exception exception) {
                            throw new InitializationException("Could not inject MIXEE spec", exception);
                        }
                    }
                    bl2 = true;
                }
                if (typedMember.isArgGroup()) {
                    CommandReflection.assertNoDuplicateAnnotations(typedMember, ArgGroup.class, Spec.class, Parameters.class, Option.class, Unmatched.class, Mixin.class);
                    if (builder != null) {
                        builder.addSubgroup(CommandReflection.buildArgGroupForMember(typedMember, iFactory, commandSpec));
                    } else {
                        commandSpec.addArgGroup(CommandReflection.buildArgGroupForMember(typedMember, iFactory, commandSpec));
                    }
                    return true;
                }
                if (typedMember.isUnmatched()) {
                    CommandReflection.assertNoDuplicateAnnotations(typedMember, Unmatched.class, Mixin.class, Option.class, Parameters.class, Spec.class, ArgGroup.class);
                    if (builder != null) {
                        throw new InitializationException("@Unmatched are not supported on @ArgGroups");
                    }
                    commandSpec.addUnmatchedArgsBinding(CommandReflection.buildUnmatchedForMember(typedMember));
                }
                if (typedMember.isArgSpec()) {
                    CommandReflection.validateArgSpecMember(typedMember);
                    if (builder != null) {
                        builder.addArg(CommandReflection.buildArgForMember(typedMember, iFactory));
                    } else {
                        commandSpec.add(CommandReflection.buildArgForMember(typedMember, iFactory));
                    }
                    bl2 = true;
                }
                if (typedMember.isSpec()) {
                    CommandReflection.validateInjectSpec(typedMember);
                    if (builder != null) {
                        builder.addSpecElement(typedMember);
                    } else {
                        commandSpec.addSpecElement(typedMember);
                        if (typedMember.getAnnotation(Spec.class).value() == Spec.Target.SELF) {
                            try {
                                typedMember.setter().set(commandSpec);
                            }
                            catch (Exception exception) {
                                throw new InitializationException("Could not inject spec", exception);
                            }
                        }
                    }
                }
                if (typedMember.isParentCommand()) {
                    commandSpec.addParentCommandElement(typedMember);
                }
                return bl2;
            }

            private static boolean initFromMethodParameters(IScope iScope, Method method, CommandSpec commandSpec, ArgGroupSpec.Builder builder, IFactory iFactory) {
                boolean bl2 = false;
                int n2 = 0;
                TypedMember[] typedMemberArray = new TypedMember[method.getParameterTypes().length];
                int n3 = typedMemberArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    MethodParam methodParam = new MethodParam(method, i2);
                    if (methodParam.isAnnotationPresent(Option.class) || methodParam.isAnnotationPresent(Mixin.class) || methodParam.isAnnotationPresent(ArgGroup.class)) {
                        ++n2;
                    } else {
                        methodParam.position = i2 - n2;
                    }
                    typedMemberArray[i2] = new TypedMember(methodParam, iScope);
                    bl2 |= CommandReflection.initFromAnnotatedTypedMembers(typedMemberArray[i2], null, commandSpec, builder, iFactory);
                }
                CommandSpec.access$16802(commandSpec, typedMemberArray);
                return bl2;
            }

            private static void validateArgSpecMember(TypedMember typedMember) {
                if (!typedMember.isArgSpec()) {
                    throw new IllegalStateException("Bug: validateArgSpecMember() should only be called with an @Option or @Parameters member");
                }
                if (typedMember.isOption()) {
                    CommandReflection.assertNoDuplicateAnnotations(typedMember, Option.class, Unmatched.class, Mixin.class, Parameters.class, Spec.class, ArgGroup.class);
                } else {
                    CommandReflection.assertNoDuplicateAnnotations(typedMember, Parameters.class, Option.class, Unmatched.class, Mixin.class, Spec.class, ArgGroup.class);
                }
                if (!(typedMember.accessible instanceof Field)) {
                    return;
                }
                Field field = (Field)typedMember.accessible;
                if (Modifier.isFinal(field.getModifiers()) && (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()))) {
                    throw new InitializationException("Constant (final) primitive and String fields like " + field + " cannot be used as " + (typedMember.isOption() ? "an @Option" : "a @Parameter") + ": compile-time constant inlining may hide new values written to it.");
                }
            }

            private static void validateCommandSpec(CommandSpec commandSpec, boolean bl2, String string) {
                if (!bl2 && commandSpec.positionalParameters.isEmpty() && commandSpec.optionsByNameMap.isEmpty() && commandSpec.unmatchedArgs.isEmpty()) {
                    throw new InitializationException(string + " is not a command: it has no @Command, @Option, @Parameters or @Unmatched annotations");
                }
            }

            private static void validateArgGroupSpec(ArgGroupSpec argGroupSpec, boolean bl2, String string) {
                if (!bl2 && argGroupSpec.args().isEmpty()) {
                    throw new InitializationException(string + " is not a group: it has no @Option or @Parameters annotations");
                }
            }

            private static void validateInjectSpec(TypedMember typedMember) {
                if (!typedMember.isSpec()) {
                    throw new IllegalStateException("Bug: validateInjectSpec() should only be called with @Spec members");
                }
                CommandReflection.assertNoDuplicateAnnotations(typedMember, Spec.class, Parameters.class, Option.class, Unmatched.class, Mixin.class, ArgGroup.class);
                if (!CommandSpec.class.getName().equals(typedMember.getTypeInfo().getClassName())) {
                    throw new InitializationException("@picocli.CommandLine.Spec annotation is only supported on fields of type " + CommandSpec.class.getName());
                }
            }

            private static void assertNoDuplicateAnnotations(TypedMember typedMember, Class<? extends Annotation> clazz, Class<? extends Annotation> ... classArray) {
                for (Class<? extends Annotation> clazz2 : classArray) {
                    if (!typedMember.isAnnotationPresent(clazz2)) continue;
                    throw new DuplicateOptionAnnotationsException("A member cannot have both @" + clazz.getSimpleName() + " and @" + clazz2.getSimpleName() + " annotations, but '" + typedMember + "' has both.");
                }
            }

            private static CommandSpec buildMixinForMember(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                try {
                    Object object = iAnnotatedElement.getter().get();
                    if (object == null) {
                        object = iFactory.create(iAnnotatedElement.getTypeInfo().getType());
                        iAnnotatedElement.setter().set(object);
                    }
                    CommandSpec commandSpec = CommandSpec.forAnnotatedObject(object, iFactory);
                    return commandSpec.withToString(iAnnotatedElement.getToString());
                }
                catch (InitializationException initializationException) {
                    throw initializationException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not access or modify mixin member " + iAnnotatedElement + ": " + exception, exception);
                }
            }

            private static ArgSpec buildArgForMember(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                if (iAnnotatedElement.isOption()) {
                    return OptionSpec.builder(iAnnotatedElement, iFactory).build();
                }
                if (iAnnotatedElement.isParameter()) {
                    return PositionalParamSpec.builder(iAnnotatedElement, iFactory).build();
                }
                return PositionalParamSpec.builder(iAnnotatedElement, iFactory).build();
            }

            private static ArgGroupSpec buildArgGroupForMember(IAnnotatedElement iAnnotatedElement, IFactory iFactory, CommandSpec commandSpec) {
                try {
                    return CommandReflection.extractArgGroupSpec(iAnnotatedElement, iFactory, commandSpec, true);
                }
                catch (InitializationException initializationException) {
                    throw initializationException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not access or modify ArgGroup member " + iAnnotatedElement + ": " + exception, exception);
                }
            }

            private static UnmatchedArgsBinding buildUnmatchedForMember(IAnnotatedElement iAnnotatedElement) {
                ITypeInfo iTypeInfo = iAnnotatedElement.getTypeInfo();
                if (!(iTypeInfo.getClassName().equals(String[].class.getName()) || iTypeInfo.isCollection() && iTypeInfo.getActualGenericTypeArguments().equals(Collections.singletonList(String.class.getName())))) {
                    throw new InitializationException("Invalid type for " + iAnnotatedElement + ": must be either String[] or List<String>");
                }
                if (iTypeInfo.getClassName().equals(String[].class.getName())) {
                    return UnmatchedArgsBinding.forStringArrayConsumer(iAnnotatedElement.setter());
                }
                return UnmatchedArgsBinding.forStringCollectionSupplier(iAnnotatedElement.getter());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static interface Predicate<T> {
            public boolean test(T var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Messages {
            private final CommandSpec spec;
            private final String bundleBaseName;
            private final ResourceBundle rb;
            private final Set<String> keys;
            private Messages parent;

            public Messages(CommandSpec commandSpec, String string) {
                this(commandSpec, string, Messages.createBundle(string));
            }

            public Messages(CommandSpec commandSpec, ResourceBundle resourceBundle) {
                this(commandSpec, Messages.extractName(resourceBundle), resourceBundle);
            }

            public Messages(CommandSpec commandSpec, String string, ResourceBundle resourceBundle) {
                this.spec = Assert.notNull(commandSpec, "CommandSpec");
                this.bundleBaseName = string;
                this.rb = resourceBundle;
                this.keys = Messages.keys(resourceBundle);
                if (resourceBundle != null) {
                    CommandLine.tracer().debug("Created Messages from resourceBundle[base=%s] for command '%s' (%s)", string, commandSpec.name(), commandSpec);
                }
            }

            private static ResourceBundle createBundle(String string) {
                return ResourceBundle.getBundle(string);
            }

            private static String extractName(ResourceBundle resourceBundle) {
                try {
                    return (String)ResourceBundle.class.getDeclaredMethod("getBaseBundleName", new Class[0]).invoke((Object)resourceBundle, new Object[0]);
                }
                catch (Exception exception) {
                    return "?";
                }
            }

            public Messages parent() {
                CommandSpec commandSpec = this.spec.parent();
                if (this.parent == null || this.parent.spec != commandSpec) {
                    this.parent = null;
                    while (this.parent == null && commandSpec != null) {
                        String string = commandSpec.resourceBundleBaseName();
                        if (string != null && !string.equals(this.bundleBaseName)) {
                            this.parent = new Messages(commandSpec, string);
                            continue;
                        }
                        commandSpec = commandSpec.parent();
                    }
                }
                return this.parent;
            }

            private static Set<String> keys(ResourceBundle resourceBundle) {
                if (resourceBundle == null) {
                    return Collections.emptySet();
                }
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    linkedHashSet.add(enumeration.nextElement());
                }
                return linkedHashSet;
            }

            public static Messages copy(CommandSpec commandSpec, Messages messages) {
                return messages == null ? null : new Messages(commandSpec, messages.bundleBaseName, messages.rb);
            }

            public static boolean empty(Messages messages) {
                return messages == null || messages.isEmpty();
            }

            public String getString(String string, String string2) {
                if (this.isEmpty()) {
                    return string2;
                }
                String string3 = this.spec.qualifiedName(".");
                String string4 = string3 + "." + string;
                String string5 = this.getStringForExactKey(string4);
                if (string5 == null) {
                    string5 = this.getStringForExactKey(string);
                }
                return string5 != null ? string5 : string2;
            }

            private String getStringForExactKey(String string) {
                if (this.keys.contains(string)) {
                    return this.rb.getString(string);
                }
                if (this.parent() != null) {
                    return this.parent().getStringForExactKey(string);
                }
                return null;
            }

            boolean isEmpty() {
                return !(this.rb != null && !this.keys.isEmpty() || this.parent() != null && !this.parent().isEmpty());
            }

            public String[] getStringArray(String string, String[] stringArray) {
                if (this.isEmpty()) {
                    return stringArray;
                }
                String string2 = this.spec.qualifiedName(".");
                String string3 = string2 + "." + string;
                String[] stringArray2 = this.getStringArrayForExactKey(string3);
                if (stringArray2 == null) {
                    stringArray2 = this.getStringArrayForExactKey(string);
                }
                return stringArray2 != null ? stringArray2 : stringArray;
            }

            private String[] getStringArrayForExactKey(String string) {
                List<String> list = Messages.addAllWithPrefix(this.rb, string, this.keys, new ArrayList<String>());
                if (!list.isEmpty()) {
                    return list.toArray(new String[0]);
                }
                return this.parent() == null ? null : this.parent().getStringArrayForExactKey(string);
            }

            private static List<String> addAllWithPrefix(ResourceBundle resourceBundle, String string, Set<String> set, List<String> list) {
                if (set.contains(string)) {
                    list.add(resourceBundle.getString(string));
                }
                int n2 = 0;
                String string2;
                while (set.contains(string2 = string + "." + n2)) {
                    list.add(resourceBundle.getString(string2));
                    ++n2;
                }
                return list;
            }

            public static String resourceBundleBaseName(Messages messages) {
                return messages == null ? null : messages.resourceBundleBaseName();
            }

            public static ResourceBundle resourceBundle(Messages messages) {
                return messages == null ? null : messages.resourceBundle();
            }

            public String resourceBundleBaseName() {
                return this.bundleBaseName;
            }

            public ResourceBundle resourceBundle() {
                return this.rb;
            }

            public CommandSpec commandSpec() {
                return this.spec;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TypedMember
        implements IAnnotatedElement,
        IExtensible {
            final AccessibleObject accessible;
            final String name;
            final ITypeInfo typeInfo;
            private final InitialValueState initialValueState;
            private IScope scope;
            private IGetter getter;
            private ISetter setter;

            static TypedMember createIfAnnotated(Field field, IScope iScope) {
                return TypedMember.isAnnotated(field) ? new TypedMember(field, iScope) : null;
            }

            static boolean isAnnotated(AnnotatedElement annotatedElement) {
                return annotatedElement.isAnnotationPresent(Option.class) || annotatedElement.isAnnotationPresent(Parameters.class) || annotatedElement.isAnnotationPresent(ArgGroup.class) || annotatedElement.isAnnotationPresent(Unmatched.class) || annotatedElement.isAnnotationPresent(Mixin.class) || annotatedElement.isAnnotationPresent(Spec.class) || annotatedElement.isAnnotationPresent(ParentCommand.class);
            }

            TypedMember(Field field) {
                this.accessible = Assert.notNull(field, "field");
                this.accessible.setAccessible(true);
                this.name = field.getName();
                this.typeInfo = this.createTypeInfo(field.getType(), field.getGenericType());
                this.initialValueState = InitialValueState.POSTPONED;
            }

            private TypedMember(Field field, IScope iScope) {
                this(field);
                if (ObjectScope.isProxyClass(iScope)) {
                    throw new InitializationException("Invalid picocli annotation on interface field");
                }
                FieldBinding fieldBinding = new FieldBinding(iScope, field);
                this.getter = fieldBinding;
                this.setter = fieldBinding;
                this.scope = iScope;
            }

            static TypedMember createIfAnnotated(Method method, IScope iScope, CommandSpec commandSpec) {
                return TypedMember.isAnnotated(method) ? new TypedMember(method, iScope, commandSpec) : null;
            }

            private TypedMember(Method method, IScope iScope, CommandSpec commandSpec) {
                this.scope = iScope;
                this.accessible = Assert.notNull(method, "method");
                this.accessible.setAccessible(true);
                this.name = TypedMember.propertyName(method.getName());
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0) {
                    this.typeInfo = this.createTypeInfo(classArray[0], method.getGenericParameterTypes()[0]);
                    MethodBinding methodBinding = new MethodBinding(iScope, method, commandSpec);
                    this.getter = methodBinding;
                    this.setter = methodBinding;
                    this.initialValueState = InitialValueState.UNAVAILABLE;
                } else {
                    if (method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class) {
                        throw new InitializationException("Invalid method, must be either getter or setter: " + method);
                    }
                    this.typeInfo = this.createTypeInfo(method.getReturnType(), method.getGenericReturnType());
                    if (ObjectScope.isProxyClass(iScope)) {
                        PicocliInvocationHandler picocliInvocationHandler;
                        Object object = ObjectScope.tryGet(iScope);
                        PicocliInvocationHandler picocliInvocationHandler2 = picocliInvocationHandler = (PicocliInvocationHandler)Proxy.getInvocationHandler(object);
                        picocliInvocationHandler2.getClass();
                        PicocliInvocationHandler.ProxyBinding proxyBinding = picocliInvocationHandler2.new PicocliInvocationHandler.ProxyBinding(method);
                        this.getter = proxyBinding;
                        this.setter = proxyBinding;
                        this.initializeInitialValue(method);
                    } else {
                        MethodBinding methodBinding = new MethodBinding(iScope, method, commandSpec);
                        this.getter = methodBinding;
                        this.setter = methodBinding;
                    }
                    this.initialValueState = InitialValueState.POSTPONED;
                }
            }

            TypedMember(MethodParam methodParam, IScope iScope) {
                this.scope = iScope;
                this.accessible = Assert.notNull(methodParam, "command method parameter");
                this.accessible.setAccessible(true);
                this.name = methodParam.getName();
                this.typeInfo = this.createTypeInfo(methodParam.getType(), methodParam.getParameterizedType());
                ObjectBinding objectBinding = new ObjectBinding();
                this.getter = objectBinding;
                this.setter = objectBinding;
                this.initializeInitialValue(methodParam);
                this.initialValueState = InitialValueState.POSTPONED;
            }

            private ITypeInfo createTypeInfo(Class<?> clazz, Type type) {
                Range range = null;
                if (this.isOption()) {
                    range = Range.valueOf(this.getAnnotation(Option.class).arity());
                }
                if (this.isParameter()) {
                    range = Range.valueOf(this.getAnnotation(Parameters.class).arity());
                }
                if (range == null || range.isUnspecified) {
                    range = this.isOption() ? (clazz == null || CommandLine.isBoolean(clazz) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1");
                    range = range.unspecified(true);
                }
                return RuntimeTypeInfo.create(clazz, this.annotationTypes(), type, range, this.isOption() ? Boolean.TYPE : String.class, this.isInteractive());
            }

            private void initializeInitialValue(Object object) {
                Class<?> clazz = this.typeInfo.getType();
                try {
                    if (clazz == Boolean.TYPE) {
                        this.setter.set(false);
                    } else if (clazz == Byte.TYPE) {
                        this.setter.set((byte)0);
                    } else if (clazz == Character.TYPE) {
                        this.setter.set(Character.valueOf('\u0000'));
                    } else if (clazz == Short.TYPE) {
                        this.setter.set((short)0);
                    } else if (clazz == Integer.TYPE) {
                        this.setter.set(0);
                    } else if (clazz == Long.TYPE) {
                        this.setter.set(0L);
                    } else if (clazz == Float.TYPE) {
                        this.setter.set(Float.valueOf(0.0f));
                    } else if (clazz == Double.TYPE) {
                        this.setter.set(0.0);
                    } else {
                        this.setter.set(null);
                    }
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not set initial value for " + object + ": " + exception.toString(), exception);
                }
            }

            @Override
            public Object userObject() {
                return this.accessible;
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
                return this.accessible.isAnnotationPresent(clazz);
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                return this.accessible.getAnnotation(clazz);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean isArgSpec() {
                return this.isOption() || this.isParameter() || this.isMethodParameter() && !this.isMixin();
            }

            @Override
            public boolean isOption() {
                return this.isAnnotationPresent(Option.class);
            }

            @Override
            public boolean isParameter() {
                return this.isAnnotationPresent(Parameters.class);
            }

            @Override
            public boolean isArgGroup() {
                return this.isAnnotationPresent(ArgGroup.class);
            }

            @Override
            public boolean isMixin() {
                return this.isAnnotationPresent(Mixin.class);
            }

            @Override
            public boolean isUnmatched() {
                return this.isAnnotationPresent(Unmatched.class);
            }

            @Override
            public boolean isSpec() {
                return this.isAnnotationPresent(Spec.class);
            }

            @Override
            public boolean isParentCommand() {
                return this.isAnnotationPresent(ParentCommand.class);
            }

            @Override
            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.getType());
            }

            @Override
            public boolean isInteractive() {
                return this.isOption() && this.getAnnotation(Option.class).interactive() || this.isParameter() && this.getAnnotation(Parameters.class).interactive();
            }

            @Override
            public IScope scope() {
                return this.scope;
            }

            @Override
            public IGetter getter() {
                return this.getter;
            }

            @Override
            public ISetter setter() {
                return this.setter;
            }

            @Override
            public ITypeInfo getTypeInfo() {
                return this.typeInfo;
            }

            public Class<?> getType() {
                return this.typeInfo.getType();
            }

            public Class<?>[] getAuxiliaryTypes() {
                return this.typeInfo.getAuxiliaryTypes();
            }

            private Class<?>[] annotationTypes() {
                if (this.isOption()) {
                    return this.getAnnotation(Option.class).type();
                }
                if (this.isParameter()) {
                    return this.getAnnotation(Parameters.class).type();
                }
                return new Class[0];
            }

            public String toString() {
                return this.accessible.toString();
            }

            @Override
            public String getToString() {
                if (this.isMixin()) {
                    return TypedMember.abbreviate("mixin from member " + this.toGenericString());
                }
                return (this.accessible instanceof Field ? "field " : (this.accessible instanceof Method ? "method " : this.accessible.getClass().getSimpleName() + " ")) + TypedMember.abbreviate(this.toGenericString());
            }

            public String toGenericString() {
                return this.accessible instanceof Field ? ((Field)this.accessible).toGenericString() : (this.accessible instanceof Method ? ((Method)this.accessible).toGenericString() : this.accessible.toString());
            }

            @Override
            public boolean hasInitialValue() {
                return this.initialValueState == InitialValueState.CACHED || this.initialValueState == InitialValueState.POSTPONED;
            }

            @Override
            public boolean isMethodParameter() {
                return this.accessible instanceof MethodParam;
            }

            @Override
            public int getMethodParamPosition() {
                return this.isMethodParameter() ? ((MethodParam)this.accessible).position : -1;
            }

            @Override
            public String getMixinName() {
                String string = this.getAnnotation(Mixin.class).name();
                return CommandLine.empty(string) ? this.getName() : string;
            }

            static String propertyName(String string) {
                if (string.length() > 3 && (string.startsWith("get") || string.startsWith("set"))) {
                    return TypedMember.decapitalize(string.substring(3));
                }
                return TypedMember.decapitalize(string);
            }

            private static String decapitalize(String string) {
                if (string == null || string.length() == 0) {
                    return string;
                }
                char[] cArray = string.toCharArray();
                cArray[0] = Character.toLowerCase(cArray[0]);
                return new String(cArray);
            }

            static String abbreviate(String string) {
                return string.replace("private ", "").replace("protected ", "").replace("public ", "").replace("java.lang.", "");
            }

            @Override
            public <T> T getExtension(Class<T> clazz) {
                if (clazz == InitialValueState.class) {
                    return clazz.cast((Object)this.initialValueState);
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IExtensible {
            public <T> T getExtension(Class<T> var1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IAnnotatedElement {
            public Object userObject();

            public boolean isAnnotationPresent(Class<? extends Annotation> var1);

            public <T extends Annotation> T getAnnotation(Class<T> var1);

            public String getName();

            public String getMixinName();

            public boolean isArgSpec();

            public boolean isOption();

            public boolean isParameter();

            public boolean isArgGroup();

            public boolean isMixin();

            public boolean isUnmatched();

            public boolean isSpec();

            public boolean isParentCommand();

            public boolean isMultiValue();

            public boolean isInteractive();

            public boolean hasInitialValue();

            public boolean isMethodParameter();

            public int getMethodParamPosition();

            public IScope scope();

            public IGetter getter();

            public ISetter setter();

            public ITypeInfo getTypeInfo();

            public String getToString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class RuntimeTypeInfo
        implements ITypeInfo {
            static final String ERRORMSG = "Unsupported generic type %s. Only List<T>, Map<K,V>, Optional<T>, and Map<K, Optional<V>> are supported. Type parameters may be char[], a non-array type, or a wildcard type with an upper or lower bound.";
            private final Class<?> type;
            private final Class<?>[] auxiliaryTypes;
            private final List<String> actualGenericTypeArguments;

            RuntimeTypeInfo(Class<?> clazz, Class<?>[] classArray, List<String> list) {
                this.type = Assert.notNull(clazz, "type");
                this.auxiliaryTypes = (Class[])Assert.notNull(classArray, "auxiliaryTypes").clone();
                this.actualGenericTypeArguments = list == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(list));
            }

            static ITypeInfo createForAuxType(Class<?> clazz) {
                return RuntimeTypeInfo.create(clazz, new Class[0], (Type)null, Range.valueOf("1"), String.class, false);
            }

            public static ITypeInfo create(Class<?> clazz, Class<?>[] classArray, Type type, Range range, Class<?> clazz2, boolean bl2) {
                Class<?>[] classArray2 = RuntimeTypeInfo.inferTypes(clazz, classArray, type);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (type instanceof ParameterizedType) {
                    Class<?>[] classArray3;
                    for (Class<?> clazz3 : classArray3 = RuntimeTypeInfo.extractTypeParameters((ParameterizedType)type)) {
                        arrayList.add(clazz3.getName());
                    }
                }
                return RuntimeTypeInfo.create(clazz, classArray2, arrayList, range, clazz2, bl2);
            }

            public static ITypeInfo create(Class<?> clazz, Class<?>[] classArray, List<String> list, Range range, Class<?> clazz2, boolean bl2) {
                if (clazz == null) {
                    clazz = classArray == null || classArray.length == 0 ? (bl2 ? char[].class : (range.isVariable || range.max > 1 ? String[].class : (range.max == 1 ? String.class : clazz2))) : classArray[0];
                }
                if (classArray == null || classArray.length == 0) {
                    classArray = clazz.isArray() ? (clazz.equals(char[].class) ? new Class[]{char[].class} : new Class[]{clazz.getComponentType()}) : (Collection.class.isAssignableFrom(clazz) ? new Class[]{bl2 ? char[].class : String.class} : (Map.class.isAssignableFrom(clazz) ? new Class[]{String.class, String.class} : new Class[]{clazz}));
                }
                return new RuntimeTypeInfo(clazz, classArray, list);
            }

            static Class<?>[] inferTypes(Class<?> clazz, Class<?>[] classArray, Type type) {
                if (classArray != null && classArray.length > 0) {
                    return classArray;
                }
                if (clazz.isArray()) {
                    if (CommandLine.isOptional(clazz.getComponentType())) {
                        throw new InitializationException(String.format(ERRORMSG, type));
                    }
                    return new Class[]{clazz.getComponentType()};
                }
                if (CommandLine.isMultiValue(clazz) || CommandLine.isOptional(clazz)) {
                    if (type instanceof ParameterizedType) {
                        return RuntimeTypeInfo.extractTypeParameters((ParameterizedType)type);
                    }
                    return new Class[]{String.class, String.class};
                }
                return new Class[]{clazz};
            }

            static Class<?>[] extractTypeParameters(ParameterizedType parameterizedType) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type[] typeArray2;
                    Type[] typeArray3;
                    Type type;
                    if (typeArray[i2] instanceof Class) {
                        arrayList.add((Class)typeArray[i2]);
                        continue;
                    }
                    if (typeArray[i2] instanceof ParameterizedType) {
                        type = (ParameterizedType)typeArray[i2];
                        typeArray3 = type.getRawType();
                        if (typeArray3 instanceof Class) {
                            arrayList.add((Class)typeArray3);
                            if (i2 != 1 || !CommandLine.isOptional((Class)typeArray3) || (typeArray2 = RuntimeTypeInfo.extractTypeParameters((ParameterizedType)type)).length != 1) continue;
                            arrayList.add(typeArray2[0]);
                            continue;
                        }
                    } else if (typeArray[i2] instanceof WildcardType) {
                        type = (WildcardType)typeArray[i2];
                        typeArray3 = type.getLowerBounds();
                        if (typeArray3.length > 0 && typeArray3[0] instanceof Class) {
                            arrayList.add((Class)typeArray3[0]);
                            continue;
                        }
                        typeArray2 = type.getUpperBounds();
                        if (typeArray2.length > 0 && typeArray2[0] instanceof Class) {
                            arrayList.add((Class)typeArray2[0]);
                            continue;
                        }
                    } else if (typeArray[i2] instanceof GenericArrayType && Character.TYPE.equals((type = (GenericArrayType)typeArray[i2]).getGenericComponentType())) {
                        arrayList.add(char[].class);
                        continue;
                    }
                    throw new InitializationException(String.format(ERRORMSG, parameterizedType));
                }
                return arrayList.toArray(new Class[0]);
            }

            @Override
            public boolean isBoolean() {
                return this.auxiliaryTypes[0] == Boolean.TYPE || this.auxiliaryTypes[0] == Boolean.class;
            }

            @Override
            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.type);
            }

            @Override
            public boolean isArray() {
                return this.type.isArray() && this.type != char[].class;
            }

            @Override
            public boolean isCollection() {
                return Collection.class.isAssignableFrom(this.type);
            }

            @Override
            public boolean isMap() {
                return Map.class.isAssignableFrom(this.type);
            }

            @Override
            public boolean isOptional() {
                return CommandLine.isOptional(this.type);
            }

            @Override
            public boolean isEnum() {
                return this.auxiliaryTypes[0].isEnum();
            }

            @Override
            public String getClassName() {
                return this.type.getName();
            }

            @Override
            public String getClassSimpleName() {
                return this.type.getSimpleName();
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public Class<?>[] getAuxiliaryTypes() {
                return this.auxiliaryTypes;
            }

            @Override
            public List<String> getActualGenericTypeArguments() {
                return this.actualGenericTypeArguments;
            }

            @Override
            public List<ITypeInfo> getAuxiliaryTypeInfos() {
                ArrayList<ITypeInfo> arrayList = new ArrayList<ITypeInfo>();
                for (Class<?> clazz : this.auxiliaryTypes) {
                    arrayList.add(RuntimeTypeInfo.createForAuxType(clazz));
                }
                return arrayList;
            }

            @Override
            public List<String> getEnumConstantNames() {
                if (!this.isEnum()) {
                    return Collections.emptyList();
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object obj : this.auxiliaryTypes[0].getEnumConstants()) {
                    arrayList.add(obj.toString());
                }
                return arrayList;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof RuntimeTypeInfo)) {
                    return false;
                }
                RuntimeTypeInfo runtimeTypeInfo = (RuntimeTypeInfo)object;
                return Arrays.equals(runtimeTypeInfo.auxiliaryTypes, this.auxiliaryTypes) && this.type.equals(runtimeTypeInfo.type);
            }

            public int hashCode() {
                return Arrays.hashCode(this.auxiliaryTypes) + 37 * Assert.hashCode(this.type);
            }

            public String toString() {
                return String.format("RuntimeTypeInfo(%s, aux=%s, collection=%s, map=%s)", this.type.getCanonicalName(), Arrays.toString(this.auxiliaryTypes), this.isCollection(), this.isMap());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ITypeInfo {
            public boolean isBoolean();

            public boolean isMultiValue();

            public boolean isOptional();

            public boolean isArray();

            public boolean isCollection();

            public boolean isMap();

            public boolean isEnum();

            public List<String> getEnumConstantNames();

            public String getClassName();

            public String getClassSimpleName();

            public List<ITypeInfo> getAuxiliaryTypeInfos();

            public List<String> getActualGenericTypeArguments();

            public Class<?> getType();

            public Class<?>[] getAuxiliaryTypes();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MethodParam
        extends AccessibleObject {
            final Method method;
            final int paramIndex;
            final String name;
            int position;

            public MethodParam(Method method, int n2) {
                this.method = method;
                this.paramIndex = n2;
                String string = "arg" + n2;
                try {
                    Method method2 = Method.class.getMethod("getParameters", new Class[0]);
                    Object object = method2.invoke((Object)method, new Object[0]);
                    Object object2 = Array.get(object, n2);
                    string = (String)Class.forName("java.lang.reflect.Parameter").getDeclaredMethod("getName", new Class[0]).invoke(object2, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.name = string;
            }

            public Type getParameterizedType() {
                return this.method.getGenericParameterTypes()[this.paramIndex];
            }

            public String getName() {
                return this.name;
            }

            public Class<?> getType() {
                return this.method.getParameterTypes()[this.paramIndex];
            }

            public Method getDeclaringExecutable() {
                return this.method;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                for (Annotation annotation : this.getDeclaredAnnotations()) {
                    if (!clazz.isAssignableFrom(annotation.annotationType())) continue;
                    return (T)((Annotation)clazz.cast(annotation));
                }
                return null;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.method.getParameterAnnotations()[this.paramIndex];
            }

            @Override
            public void setAccessible(boolean bl2) throws SecurityException {
                this.method.setAccessible(bl2);
            }

            @Override
            public boolean isAccessible() throws SecurityException {
                return this.method.isAccessible();
            }

            public String toString() {
                return this.method.toString() + ":" + this.getName();
            }
        }

        public static class UnmatchedArgsBinding {
            private final IGetter getter;
            private final ISetter setter;
            private Object initialValue;

            public static UnmatchedArgsBinding forStringArrayConsumer(ISetter iSetter) {
                return new UnmatchedArgsBinding(null, iSetter);
            }

            public static UnmatchedArgsBinding forStringCollectionSupplier(IGetter iGetter) {
                return new UnmatchedArgsBinding(iGetter, null);
            }

            private UnmatchedArgsBinding(IGetter iGetter, ISetter iSetter) {
                if (iGetter == null && iSetter == null) {
                    throw new IllegalArgumentException("Getter and setter cannot both be null");
                }
                this.setter = iSetter;
                this.getter = iGetter;
                IGetter iGetter2 = iSetter instanceof IGetter ? (IGetter)((Object)iSetter) : iGetter;
                try {
                    this.initialValue = iGetter2.get();
                }
                catch (Exception exception) {
                    CommandLine.tracer().debug("Could not obtain initial value for unmatched from %s", iGetter2);
                }
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            void addAll(String[] stringArray) {
                if (this.setter != null) {
                    try {
                        this.setter.set(stringArray);
                    }
                    catch (Exception exception) {
                        throw new PicocliException(String.format("Could not invoke setter (%s) with unmatched argument array '%s': %s", this.setter, Arrays.toString(stringArray), exception), exception);
                    }
                }
                try {
                    ArrayList<String> arrayList = (ArrayList<String>)this.getter.get();
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        ((ISetter)((Object)this.getter)).set(arrayList);
                    }
                    arrayList.addAll(Arrays.asList(stringArray));
                }
                catch (Exception exception) {
                    throw new PicocliException(String.format("Could not add unmatched argument array '%s' to collection returned by getter (%s): %s", Arrays.toString(stringArray), this.getter, exception), exception);
                }
            }

            void clear() {
                ISetter iSetter = this.setter;
                if (iSetter == null) {
                    if (this.getter instanceof ISetter) {
                        iSetter = (ISetter)((Object)this.getter);
                    } else {
                        CommandLine.tracer().warn("Unable to clear %s: it does not implement ISetter", this.getter);
                        return;
                    }
                }
                try {
                    iSetter.set(this.initialValue);
                }
                catch (Exception exception) {
                    throw new PicocliException(String.format("Could not invoke setter (%s) with initial value: %s", iSetter, exception), exception);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ArgGroupSpec
        implements IOrdered {
            static final int DEFAULT_ORDER = -1;
            private static final String NO_HEADING = "__no_heading__";
            private static final String NO_HEADING_KEY = "__no_heading_key__";
            private final String heading;
            private final String headingKey;
            private final boolean exclusive;
            private final Range multiplicity;
            private final boolean validate;
            private final int order;
            private final IGetter getter;
            private final ISetter setter;
            private final IScope scope;
            private final ITypeInfo typeInfo;
            private final List<ArgGroupSpec> subgroups;
            private final Set<ArgSpec> args;
            private Messages messages;
            private ArgGroupSpec parentGroup;
            private String id = "1";
            private final List<IAnnotatedElement> specElements;

            /*
             * WARNING - void declaration
             */
            ArgGroupSpec(Builder builder) {
                this.heading = NO_HEADING.equals(builder.heading) ? null : builder.heading;
                this.headingKey = NO_HEADING_KEY.equals(builder.headingKey) ? null : builder.headingKey;
                this.exclusive = builder.exclusive && builder.validate;
                this.multiplicity = builder.multiplicity;
                if (this.multiplicity.max() <= 0) {
                    throw new InitializationException("ArgGroup must have multiplicity that allows at least one occurrence, but had multiplicity=" + this.multiplicity);
                }
                this.validate = builder.validate;
                this.order = builder.order;
                this.typeInfo = builder.typeInfo;
                this.getter = builder.getter;
                this.setter = builder.setter;
                this.scope = builder.scope;
                this.specElements = Collections.unmodifiableList(new ArrayList<IAnnotatedElement>(builder.specElements()));
                this.args = Collections.unmodifiableSet(new LinkedHashSet<ArgSpec>(builder.args()));
                this.subgroups = Collections.unmodifiableList(new ArrayList<ArgGroupSpec>(builder.subgroups()));
                if (this.args.isEmpty() && this.subgroups.isEmpty()) {
                    throw new InitializationException("ArgGroup has no options or positional parameters, and no subgroups: " + (this.getter == null ? this.setter : this.getter) + " in " + this.scope);
                }
                int n2 = 1;
                for (ArgGroupSpec object : this.subgroups) {
                    object.parentGroup = this;
                    object.id = this.id + "." + n2++;
                }
                for (ArgSpec argSpec : this.args) {
                    argSpec.group = this;
                }
                if (!this.validate && builder.exclusive) {
                    CommandLine.tracer().info("Setting exclusive=%s because %s is a non-validating group.", this.exclusive, this.synopsisUnit());
                }
                if (this.exclusive) {
                    Object object2 = "";
                    String string = "";
                    for (ArgSpec argSpec : this.args) {
                        void var4_8;
                        if (argSpec.required()) continue;
                        object2 = (String)object2 + (String)var4_8 + (argSpec.isOption() ? ((OptionSpec)argSpec).longestName() : argSpec.paramLabel() + "[" + ((PositionalParamSpec)argSpec).index() + "]");
                        String string2 = ",";
                        argSpec.originallyRequired = true;
                        argSpec.required = true;
                    }
                    if (((String)object2).length() > 0) {
                        CommandLine.tracer().info("Made %s required in the group because %s is an exclusive group.", object2, this.synopsisUnit());
                    }
                }
            }

            public static Builder builder() {
                return new Builder();
            }

            public static Builder builder(IAnnotatedElement iAnnotatedElement) {
                return new Builder(Assert.notNull(iAnnotatedElement, "annotatedElement"));
            }

            public boolean exclusive() {
                return this.exclusive;
            }

            public Range multiplicity() {
                return this.multiplicity;
            }

            public boolean validate() {
                return this.validate;
            }

            @Override
            public int order() {
                return this.order;
            }

            public String heading() {
                if (this.messages() == null) {
                    return this.heading;
                }
                String string = this.messages().getString(this.headingKey(), null);
                if (string != null) {
                    return string;
                }
                return this.heading;
            }

            public String headingKey() {
                return this.headingKey;
            }

            public ArgGroupSpec parentGroup() {
                return this.parentGroup;
            }

            public List<ArgGroupSpec> subgroups() {
                return this.subgroups;
            }

            public List<IAnnotatedElement> specElements() {
                return this.specElements;
            }

            public boolean isSubgroupOf(ArgGroupSpec argGroupSpec) {
                for (ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups) {
                    if (this == argGroupSpec2) {
                        return true;
                    }
                    if (!this.isSubgroupOf(argGroupSpec2)) continue;
                    return true;
                }
                return false;
            }

            public ITypeInfo typeInfo() {
                return this.typeInfo;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public IScope scope() {
                return this.scope;
            }

            Object userObject() {
                try {
                    return this.getter.get();
                }
                catch (Exception exception) {
                    return exception.toString();
                }
            }

            Object userObjectOr(Object object) {
                try {
                    return this.getter.get();
                }
                catch (Exception exception) {
                    return object;
                }
            }

            String id() {
                return this.id;
            }

            int argCount() {
                int n2 = this.args.size();
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    n2 += argGroupSpec.argCount();
                }
                return n2;
            }

            int localPositionalParamCount() {
                int n2 = 0;
                for (ArgSpec argSpec : this.args) {
                    if (!argSpec.isPositional()) continue;
                    n2 += ((PositionalParamSpec)argSpec).capacity().max();
                }
                return n2;
            }

            public Set<ArgSpec> args() {
                return this.args;
            }

            public Set<ArgSpec> requiredArgs() {
                LinkedHashSet<ArgSpec> linkedHashSet = new LinkedHashSet<ArgSpec>(this.args);
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    if (((ArgSpec)iterator.next()).required()) continue;
                    iterator.remove();
                }
                return Collections.unmodifiableSet(linkedHashSet);
            }

            public List<PositionalParamSpec> positionalParameters() {
                ArrayList<PositionalParamSpec> arrayList = new ArrayList<PositionalParamSpec>();
                for (ArgSpec argSpec : this.args()) {
                    if (!(argSpec instanceof PositionalParamSpec)) continue;
                    arrayList.add((PositionalParamSpec)argSpec);
                }
                return Collections.unmodifiableList(arrayList);
            }

            public List<OptionSpec> options() {
                ArrayList<OptionSpec> arrayList = new ArrayList<OptionSpec>();
                for (ArgSpec argSpec : this.args()) {
                    if (!(argSpec instanceof OptionSpec)) continue;
                    arrayList.add((OptionSpec)argSpec);
                }
                return Collections.unmodifiableList(arrayList);
            }

            public List<OptionSpec> allOptionsNested() {
                return this.addGroupOptionsToListRecursively(new ArrayList<OptionSpec>());
            }

            private List<OptionSpec> addGroupOptionsToListRecursively(List<OptionSpec> list) {
                list.addAll(this.options());
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.addGroupOptionsToListRecursively(list);
                }
                return list;
            }

            public List<PositionalParamSpec> allPositionalParametersNested() {
                return this.addGroupPositionalsToListRecursively(new ArrayList<PositionalParamSpec>());
            }

            private List<PositionalParamSpec> addGroupPositionalsToListRecursively(List<PositionalParamSpec> list) {
                list.addAll(this.positionalParameters());
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.addGroupPositionalsToListRecursively(list);
                }
                return list;
            }

            public String synopsis() {
                return this.synopsisText(new Help.ColorScheme.Builder(Help.Ansi.OFF).build(), new HashSet<ArgSpec>()).toString();
            }

            String synopsisUnit() {
                Help.ColorScheme colorScheme = new Help.ColorScheme.Builder(Help.Ansi.OFF).build();
                return this.synopsisUnitText(colorScheme, this.rawSynopsisUnitText(colorScheme, new HashSet<ArgSpec>())).toString();
            }

            public Help.Ansi.Text synopsisText(Help.ColorScheme colorScheme, Set<ArgSpec> set) {
                int n2;
                Help.Ansi.Text text = this.rawSynopsisUnitText(colorScheme, set);
                Help.Ansi.Text text2 = this.synopsisUnitText(colorScheme, text);
                for (n2 = 1; n2 < this.multiplicity.min(); ++n2) {
                    text2 = text2.concat(" (").concat(text).concat(")");
                }
                if (this.multiplicity().isVariable()) {
                    text2 = text2.concat("...");
                } else {
                    while (n2 < this.multiplicity.max()) {
                        text2 = text2.concat(" [").concat(text).concat("]");
                        ++n2;
                    }
                }
                return text2;
            }

            private Help.Ansi.Text synopsisUnitText(Help.ColorScheme colorScheme, Help.Ansi.Text text) {
                String string = this.args().size() > 1 || !this.subgroups().isEmpty() ? "(" : "";
                String string2 = this.args().size() > 1 || !this.subgroups().isEmpty() ? ")" : "";
                String string3 = this.multiplicity().min() > 0 ? string : "[";
                String string4 = this.multiplicity().min() > 0 ? string2 : "]";
                return colorScheme.text(string3).concat(text).concat(string4);
            }

            private Help.Ansi.Text rawSynopsisUnitText(Help.ColorScheme colorScheme, Set<ArgSpec> set) {
                boolean bl2;
                String string = this.exclusive() ? " | " : " ";
                Help.Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Help.Ansi.Text text = ansi.new Help.Ansi.Text(0);
                boolean bl3 = bl2 = !this.args.isEmpty() && this.args.iterator().next().command() != null && !this.args.iterator().next().command().usageMessage().sortSynopsis();
                if (bl2) {
                    String string2;
                    ArrayList<IOrdered> arrayList = new ArrayList<IOrdered>();
                    ArrayList<PositionalParamSpec> arrayList2 = new ArrayList<PositionalParamSpec>();
                    for (ArgSpec argSpec : this.args()) {
                        if (argSpec instanceof OptionSpec) {
                            arrayList.add((IOrdered)((Object)argSpec));
                            continue;
                        }
                        arrayList2.add((PositionalParamSpec)argSpec);
                    }
                    arrayList.addAll(this.subgroups());
                    Collections.sort(arrayList, new Help.SortByOrder());
                    for (IOrdered iOrdered : arrayList) {
                        String string3 = string2 = text.length > 0 ? string : "";
                        if (iOrdered instanceof OptionSpec) {
                            text = this.concatOptionText(string2, text, colorScheme, (OptionSpec)iOrdered);
                            set.add((OptionSpec)iOrdered);
                            continue;
                        }
                        text = text.concat(((ArgGroupSpec)iOrdered).synopsisText(colorScheme, set));
                    }
                    for (PositionalParamSpec positionalParamSpec : arrayList2) {
                        string2 = text.length > 0 ? string : "";
                        text = this.concatPositionalText(string2, text, colorScheme, positionalParamSpec);
                        set.add(positionalParamSpec);
                    }
                } else {
                    for (ArgSpec object : this.args()) {
                        String string4 = text.length > 0 ? string : "";
                        text = object instanceof OptionSpec ? this.concatOptionText(string4, text, colorScheme, (OptionSpec)object) : this.concatPositionalText(string4, text, colorScheme, (PositionalParamSpec)object);
                        set.add(object);
                    }
                    for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                        if (text.length > 0) {
                            text = text.concat(string);
                        }
                        text = text.concat(argGroupSpec.synopsisText(colorScheme, set));
                    }
                }
                return text;
            }

            private Help.Ansi.Text concatOptionText(String string, Help.Ansi.Text text, Help.ColorScheme colorScheme, OptionSpec optionSpec) {
                return Help.concatOptionText(string, text, colorScheme, optionSpec, this.createLabelRenderer(optionSpec.commandSpec));
            }

            private Help.Ansi.Text concatPositionalText(String string, Help.Ansi.Text text, Help.ColorScheme colorScheme, PositionalParamSpec positionalParamSpec) {
                return Help.concatPositionalText(string, text, colorScheme, positionalParamSpec, this.createLabelRenderer(positionalParamSpec.commandSpec));
            }

            public Help.IParamLabelRenderer createLabelRenderer(CommandSpec commandSpec) {
                return new Help.DefaultParamLabelRenderer(commandSpec == null ? CommandSpec.create() : commandSpec);
            }

            public Messages messages() {
                return this.messages;
            }

            public ArgGroupSpec messages(Messages messages) {
                this.messages = messages;
                for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                    argGroupSpec.messages(messages);
                }
                return this;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof ArgGroupSpec)) {
                    return false;
                }
                ArgGroupSpec argGroupSpec = (ArgGroupSpec)object;
                return this.exclusive == argGroupSpec.exclusive && Assert.equals(this.multiplicity, argGroupSpec.multiplicity) && this.validate == argGroupSpec.validate && this.order == argGroupSpec.order && Assert.equals(this.heading, argGroupSpec.heading) && Assert.equals(this.headingKey, argGroupSpec.headingKey) && Assert.equals(this.subgroups, argGroupSpec.subgroups) && Assert.equals(this.args, argGroupSpec.args);
            }

            public int hashCode() {
                int n2 = 17;
                n2 += 37 * n2 + Assert.hashCode(this.exclusive);
                n2 += 37 * n2 + Assert.hashCode(this.multiplicity);
                n2 += 37 * n2 + Assert.hashCode(this.validate);
                n2 += 37 * n2 + this.order;
                n2 += 37 * n2 + Assert.hashCode(this.heading);
                n2 += 37 * n2 + Assert.hashCode(this.headingKey);
                n2 += 37 * n2 + Assert.hashCode(this.subgroups);
                n2 += 37 * n2 + Assert.hashCode(this.args);
                return n2;
            }

            public String toString() {
                return "ArgGroup[exclusive=" + this.exclusive + ", multiplicity=" + this.multiplicity + ", validate=" + this.validate + ", order=" + this.order + ", args=[" + ArgSpec.describe(this.args()) + "], headingKey=" + ArgGroupSpec.quote(this.headingKey) + ", heading=" + ArgGroupSpec.quote(this.heading) + ", subgroups=" + this.subgroups + "]";
            }

            private static String quote(String string) {
                return string == null ? "null" : "'" + string + "'";
            }

            void initUserObject(CommandLine commandLine) {
                if (commandLine == null) {
                    CommandLine.tracer().debug("Could not create user object for %s with null CommandLine%n.", this);
                    return;
                }
                try {
                    this.tryInitUserObject(commandLine);
                }
                catch (PicocliException picocliException) {
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new InitializationException("Could not create user object for " + this, exception);
                }
            }

            void tryInitUserObject(CommandLine commandLine) throws Exception {
                Tracer tracer = CommandLine.tracer();
                if (this.typeInfo() != null) {
                    tracer.debug("Creating new user object of type %s for group %s", this.typeInfo().getAuxiliaryTypes()[0], this.synopsis());
                    Object obj = DefaultFactory.create(commandLine.factory, this.typeInfo().getAuxiliaryTypes()[0]);
                    tracer.debug("Created %s, invoking setter %s with scope %s", obj, this.setter(), this.scope());
                    this.setUserObject(obj, commandLine.factory);
                    for (ArgSpec object : this.args()) {
                        tracer.debug("Initializing %s in group %s: setting scope to user object %s and initializing initial and default values", ArgSpec.describe(object, "="), this.synopsis(), obj);
                        object.scope().set(obj);
                        ((Interpreter)((CommandLine)commandLine).interpreter).parseResultBuilder.isInitializingDefaultValues = true;
                        object.applyInitialValue();
                        commandLine.interpreter.applyDefault(commandLine.getCommandSpec().defaultValueProvider(), object);
                        ((Interpreter)((CommandLine)commandLine).interpreter).parseResultBuilder.isInitializingDefaultValues = false;
                    }
                    for (ArgGroupSpec argGroupSpec : this.subgroups()) {
                        tracer.debug("Setting scope for subgroup %s with setter=%s in group %s to user object %s", argGroupSpec.synopsis(), argGroupSpec.setter(), this.synopsis(), obj);
                        argGroupSpec.scope().set(obj);
                    }
                    for (IAnnotatedElement iAnnotatedElement : this.specElements()) {
                        tracer.debug("Setting @Spec with setter=%s in user object %s to %s", iAnnotatedElement.setter(), obj, commandLine.getCommandSpec());
                        iAnnotatedElement.scope().set(obj);
                        iAnnotatedElement.setter().set(commandLine.getCommandSpec());
                    }
                } else {
                    tracer.debug("No type information available for group %s: cannot create new user object. Scope for arg setters is not changed.", this.synopsis());
                }
                tracer.debug("Initialization complete for group %s", this.synopsis());
            }

            void setUserObject(Object object, IFactory iFactory) throws Exception {
                if (this.typeInfo().isCollection()) {
                    Collection collection = (Collection)this.getter().get();
                    if (collection == null) {
                        Collection collection2;
                        collection = collection2 = (Collection)DefaultFactory.create(iFactory, this.typeInfo.getType());
                        this.setter().set(collection);
                    }
                    collection.add(object);
                } else if (this.typeInfo().isArray()) {
                    Object t2 = this.getter().get();
                    int n2 = t2 == null ? 0 : Array.getLength(t2);
                    Object object2 = Array.newInstance(this.typeInfo().getAuxiliaryTypes()[0], n2 + 1);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Array.set(object2, i2, Array.get(t2, i2));
                    }
                    Array.set(object2, n2, object);
                    this.setter().set(object2);
                } else {
                    this.setter().set(object);
                }
            }

            ParseResult.GroupValidationResult validateArgs(CommandLine commandLine, Collection<ArgSpec> collection) {
                LinkedHashSet<ArgSpec> linkedHashSet = new LinkedHashSet<ArgSpec>(this.args());
                LinkedHashSet<ArgSpec> linkedHashSet2 = new LinkedHashSet<ArgSpec>(this.requiredArgs());
                LinkedHashSet<ArgSpec> linkedHashSet3 = new LinkedHashSet<ArgSpec>(collection);
                linkedHashSet2.removeAll(collection);
                linkedHashSet.retainAll(linkedHashSet3);
                int n2 = linkedHashSet.size();
                boolean bl2 = !linkedHashSet2.isEmpty() && !this.exclusive();
                boolean bl3 = bl2 && !linkedHashSet.isEmpty();
                String string = ArgSpec.describe(linkedHashSet);
                String string2 = ArgSpec.describe(this.requiredArgs());
                String string3 = ArgSpec.describe(linkedHashSet2);
                return this.validate(commandLine, n2, bl2, bl3, string, string2, string3);
            }

            private ParseResult.GroupValidationResult validate(CommandLine commandLine, int n2, boolean bl2, boolean bl3, String string, String string2, String string3) {
                if (this.exclusive()) {
                    if (n2 > 1) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_PRESENT, new MutuallyExclusiveArgsException(commandLine, "Error: " + string + " are mutually exclusive (specify only one)"));
                    }
                    if (this.multiplicity().min > 0 && bl2) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_ABSENT, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument (specify one of these): " + string2));
                    }
                } else {
                    if (bl3) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_PARTIAL, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument(s): " + string3));
                    }
                    if (this.multiplicity().min > 0 && bl2) {
                        return new ParseResult.GroupValidationResult(ParseResult.GroupValidationResult.Type.FAILURE_ABSENT, new MissingParameterException(commandLine, this.args(), "Error: Missing required argument(s): " + string3));
                    }
                }
                return n2 > 0 ? ParseResult.GroupValidationResult.SUCCESS_PRESENT : ParseResult.GroupValidationResult.SUCCESS_ABSENT;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder {
                private IGetter getter;
                private ISetter setter;
                private IScope scope;
                private ITypeInfo typeInfo;
                private String heading;
                private String headingKey;
                private boolean exclusive = true;
                private Range multiplicity = Range.valueOf("0..1");
                private boolean validate = true;
                private int order = -1;
                private final List<ArgSpec> args = new ArrayList<ArgSpec>();
                private final List<ArgGroupSpec> subgroups = new ArrayList<ArgGroupSpec>();
                private final List<IAnnotatedElement> specElements = new ArrayList<IAnnotatedElement>();
                private Boolean topologicalSortDone;
                private final List<Builder> compositesReferencingMe = new ArrayList<Builder>();

                Builder() {
                }

                Builder(IAnnotatedElement iAnnotatedElement) {
                    this.typeInfo = iAnnotatedElement.getTypeInfo();
                    this.getter = iAnnotatedElement.getter();
                    this.setter = iAnnotatedElement.setter();
                    this.scope = iAnnotatedElement.scope();
                }

                public Builder updateArgGroupAttributes(ArgGroup argGroup) {
                    return this.heading(argGroup.heading()).headingKey(argGroup.headingKey()).exclusive(argGroup.exclusive()).multiplicity(argGroup.multiplicity()).validate(argGroup.validate()).order(argGroup.order());
                }

                public ArgGroupSpec build() {
                    return new ArgGroupSpec(this);
                }

                public boolean exclusive() {
                    return this.exclusive;
                }

                public Builder exclusive(boolean bl2) {
                    this.exclusive = bl2;
                    return this;
                }

                public Range multiplicity() {
                    return this.multiplicity;
                }

                public Builder multiplicity(String string) {
                    return this.multiplicity(Range.valueOf(string));
                }

                public Builder multiplicity(Range range) {
                    this.multiplicity = range;
                    return this;
                }

                public boolean validate() {
                    return this.validate;
                }

                public Builder validate(boolean bl2) {
                    this.validate = bl2;
                    return this;
                }

                public int order() {
                    return this.order;
                }

                public Builder order(int n2) {
                    this.order = n2;
                    return this;
                }

                public String heading() {
                    return this.heading;
                }

                public Builder heading(String string) {
                    this.heading = string;
                    return this;
                }

                public String headingKey() {
                    return this.headingKey;
                }

                public Builder headingKey(String string) {
                    this.headingKey = string;
                    return this;
                }

                public ITypeInfo typeInfo() {
                    return this.typeInfo;
                }

                public Builder typeInfo(ITypeInfo iTypeInfo) {
                    this.typeInfo = iTypeInfo;
                    return this;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public Builder getter(IGetter iGetter) {
                    this.getter = iGetter;
                    return this;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public Builder setter(ISetter iSetter) {
                    this.setter = iSetter;
                    return this;
                }

                public IScope scope() {
                    return this.scope;
                }

                public Builder scope(IScope iScope) {
                    this.scope = iScope;
                    return this;
                }

                public Builder addArg(ArgSpec argSpec) {
                    this.args.add(argSpec);
                    return this;
                }

                public List<ArgSpec> args() {
                    return this.args;
                }

                public Builder addSubgroup(ArgGroupSpec argGroupSpec) {
                    this.subgroups.add(argGroupSpec);
                    return this;
                }

                public List<ArgGroupSpec> subgroups() {
                    return this.subgroups;
                }

                public Builder addSpecElement(IAnnotatedElement iAnnotatedElement) {
                    this.specElements.add(iAnnotatedElement);
                    return this;
                }

                public List<IAnnotatedElement> specElements() {
                    return this.specElements;
                }
            }
        }

        public static interface IOrdered {
            public int order();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class PositionalParamSpec
        extends ArgSpec {
            private Range index;
            private Range capacity;
            private final Range builderCapacity;

            private PositionalParamSpec(Builder builder) {
                super(builder);
                this.index = builder.index == null ? Range.defaultParameterIndex(this.typeInfo) : builder.index;
                this.builderCapacity = builder.capacity;
                this.initCapacity();
                if (this.toString == null) {
                    this.toString = "positional parameter[" + this.index() + "]";
                }
            }

            private void initCapacity() {
                this.capacity = this.builderCapacity == null ? Range.parameterCapacity(this.arity(), this.index) : this.builderCapacity;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static Builder builder(PositionalParamSpec positionalParamSpec) {
                return new Builder(positionalParamSpec);
            }

            public static Builder builder(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                return new Builder(iAnnotatedElement, iFactory);
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            @Override
            public boolean isOption() {
                return false;
            }

            @Override
            public boolean isPositional() {
                return true;
            }

            @Override
            protected Collection<String> getAdditionalDescriptionKeys() {
                return Collections.singletonList(this.paramLabel() + "[" + this.index() + "]");
            }

            public Range index() {
                return this.index;
            }

            private Range capacity() {
                return this.capacity;
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.capacity) + 37 * Assert.hashCode(this.index);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof PositionalParamSpec)) {
                    return false;
                }
                PositionalParamSpec positionalParamSpec = (PositionalParamSpec)object;
                return super.equalsImpl(positionalParamSpec) && Assert.equals(this.capacity, positionalParamSpec.capacity) && Assert.equals(this.index, positionalParamSpec.index);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private Range capacity;
                private Range index;

                private Builder() {
                }

                private Builder(PositionalParamSpec positionalParamSpec) {
                    super(positionalParamSpec);
                    this.index = positionalParamSpec.index;
                    this.capacity = positionalParamSpec.capacity;
                }

                private Builder(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                    super(iAnnotatedElement.getAnnotation(Parameters.class), iAnnotatedElement, iFactory);
                    this.index = Range.parameterIndex(iAnnotatedElement);
                    this.capacity = Range.parameterCapacity(iAnnotatedElement);
                }

                @Override
                public PositionalParamSpec build() {
                    return new PositionalParamSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public Range index() {
                    return this.index;
                }

                public Builder index(String string) {
                    return this.index(Range.valueOf(string));
                }

                public Builder index(Range range) {
                    this.index = range;
                    return this.self();
                }

                Range capacity() {
                    return this.capacity;
                }

                Builder capacity(Range range) {
                    this.capacity = range;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class OptionSpec
        extends ArgSpec
        implements IOrdered {
            public static final String DEFAULT_FALLBACK_VALUE = "";
            static final int DEFAULT_ORDER = -1;
            private final String[] names;
            private final boolean help;
            private final boolean usageHelp;
            private final boolean versionHelp;
            private final boolean negatable;
            private final String fallbackValue;
            private final String originalFallbackValue;
            private final int order;

            public static Builder builder(String string, String ... stringArray) {
                String[] stringArray2 = new String[Assert.notNull(stringArray, "names").length + 1];
                stringArray2[0] = Assert.notNull(string, "name");
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                return new Builder(stringArray2);
            }

            public static Builder builder(String[] stringArray) {
                return new Builder(stringArray);
            }

            public static Builder builder(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                return new Builder(iAnnotatedElement, iFactory);
            }

            public static Builder builder(OptionSpec optionSpec) {
                return new Builder(optionSpec);
            }

            private OptionSpec(Builder builder) {
                super(builder);
                if (builder.names == null) {
                    throw new InitializationException("OptionSpec names cannot be null. Specify at least one option name.");
                }
                this.names = (String[])builder.names.clone();
                this.help = builder.help;
                this.usageHelp = builder.usageHelp;
                this.versionHelp = builder.versionHelp;
                this.order = builder.order;
                this.negatable = builder.negatable;
                this.fallbackValue = builder.fallbackValue;
                this.originalFallbackValue = builder.originalFallbackValue;
                if (this.names.length == 0 || Arrays.asList(this.names).contains(DEFAULT_FALLBACK_VALUE)) {
                    throw new InitializationException("Invalid names: " + Arrays.toString(this.names));
                }
                if (this.toString == null) {
                    this.toString = "option " + this.longestName();
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            @Override
            public boolean isOption() {
                return true;
            }

            @Override
            public boolean isPositional() {
                return false;
            }

            @Override
            protected boolean internalShowDefaultValue(boolean bl2) {
                return super.internalShowDefaultValue(bl2) && !this.help() && !this.versionHelp() && !this.usageHelp();
            }

            @Override
            protected Collection<String> getAdditionalDescriptionKeys() {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                for (String string : this.names()) {
                    linkedHashSet.add(CommandSpec.stripPrefix(string));
                }
                return linkedHashSet;
            }

            public String[] names() {
                return this.interpolate((String[])this.names.clone());
            }

            public String longestName() {
                return Help.ShortestFirst.longestFirst(this.names())[0];
            }

            public String shortestName() {
                return Help.ShortestFirst.sort(this.names())[0];
            }

            @Override
            public int order() {
                return this.order;
            }

            @Deprecated
            public boolean help() {
                return this.help;
            }

            public boolean usageHelp() {
                return this.usageHelp;
            }

            public boolean versionHelp() {
                return this.versionHelp;
            }

            public boolean negatable() {
                return this.negatable;
            }

            public String fallbackValue() {
                return this.interpolate(this.fallbackValue);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof OptionSpec)) {
                    return false;
                }
                OptionSpec optionSpec = (OptionSpec)object;
                return super.equalsImpl(optionSpec) && this.help == optionSpec.help && this.usageHelp == optionSpec.usageHelp && this.versionHelp == optionSpec.versionHelp && this.order == optionSpec.order && this.negatable == optionSpec.negatable && Assert.equals(this.fallbackValue, optionSpec.fallbackValue) && new HashSet<String>(Arrays.asList(this.names)).equals(new HashSet<String>(Arrays.asList(optionSpec.names)));
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.help) + 37 * Assert.hashCode(this.usageHelp) + 37 * Assert.hashCode(this.versionHelp) + 37 * Arrays.hashCode(this.names) + 37 * Assert.hashCode(this.negatable) + 37 * Assert.hashCode(this.fallbackValue) + 37 * this.order;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private String[] names;
                private boolean help;
                private boolean usageHelp;
                private boolean versionHelp;
                private boolean negatable;
                private String fallbackValue = "";
                private String originalFallbackValue = "__unspecified__";
                private int order = -1;

                private Builder(String[] stringArray) {
                    this.names = stringArray;
                }

                private Builder(OptionSpec optionSpec) {
                    super(optionSpec);
                    this.names = optionSpec.names;
                    this.help = optionSpec.help;
                    this.usageHelp = optionSpec.usageHelp;
                    this.versionHelp = optionSpec.versionHelp;
                    this.negatable = optionSpec.negatable;
                    this.fallbackValue = optionSpec.fallbackValue;
                    this.originalFallbackValue = optionSpec.originalFallbackValue;
                    this.order = optionSpec.order;
                }

                private Builder(IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                    super(iAnnotatedElement.getAnnotation(Option.class), iAnnotatedElement, iFactory);
                    Option option = iAnnotatedElement.getAnnotation(Option.class);
                    this.names = option.names();
                    this.help = option.help();
                    this.usageHelp = option.usageHelp();
                    this.versionHelp = option.versionHelp();
                    this.negatable = option.negatable();
                    this.fallbackValue = "_NULL_".equals(option.fallbackValue()) ? null : option.fallbackValue();
                    this.originalFallbackValue = option.fallbackValue();
                    this.order = option.order();
                }

                @Override
                public OptionSpec build() {
                    return new OptionSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public String[] names() {
                    return (String[])this.names.clone();
                }

                @Deprecated
                public boolean help() {
                    return this.help;
                }

                public boolean usageHelp() {
                    return this.usageHelp;
                }

                public boolean versionHelp() {
                    return this.versionHelp;
                }

                public boolean negatable() {
                    return this.negatable;
                }

                public String fallbackValue() {
                    return this.fallbackValue;
                }

                public int order() {
                    return this.order;
                }

                public Builder names(String ... stringArray) {
                    this.names = (String[])Assert.notNull(stringArray, "names").clone();
                    return this.self();
                }

                public Builder help(boolean bl2) {
                    this.help = bl2;
                    return this.self();
                }

                public Builder usageHelp(boolean bl2) {
                    this.usageHelp = bl2;
                    return this.self();
                }

                public Builder versionHelp(boolean bl2) {
                    this.versionHelp = bl2;
                    return this.self();
                }

                public Builder negatable(boolean bl2) {
                    this.negatable = bl2;
                    return this.self();
                }

                public Builder fallbackValue(String string) {
                    this.fallbackValue = string;
                    return this.self();
                }

                public Builder order(int n2) {
                    this.order = n2;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class ArgSpec {
            static final String NULL_VALUE = "_NULL_";
            static final String DESCRIPTION_VARIABLE_DEFAULT_VALUE = "${DEFAULT-VALUE}";
            static final String DESCRIPTION_VARIABLE_FALLBACK_VALUE = "${FALLBACK-VALUE}";
            static final String DESCRIPTION_VARIABLE_MAP_FALLBACK_VALUE = "${MAP-FALLBACK-VALUE}";
            static final String DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES = "${COMPLETION-CANDIDATES}";
            private static final String NO_DEFAULT_VALUE = "__no_default_value__";
            private static final String UNSPECIFIED = "__unspecified__";
            private final boolean inherited;
            private final ArgSpec root;
            private final boolean hidden;
            private final String paramLabel;
            private final boolean hideParamSyntax;
            private final String[] description;
            private final String descriptionKey;
            private final Help.Visibility showDefaultValue;
            private Messages messages;
            CommandSpec commandSpec;
            private ArgGroupSpec group;
            private final Object userObject;
            private boolean required;
            private boolean originallyRequired;
            private final boolean interactive;
            private final boolean echo;
            private final String prompt;
            private final String splitRegex;
            private final String splitRegexSynopsisLabel;
            protected final ITypeInfo typeInfo;
            private final ITypeConverter<?>[] converters;
            private final Iterable<String> completionCandidates;
            private final IParameterConsumer parameterConsumer;
            private final IParameterPreprocessor preprocessor;
            private final String mapFallbackValue;
            private final String defaultValue;
            private final String originalDefaultValue;
            private final String originalMapFallbackValue;
            private Object initialValue;
            private final boolean hasInitialValue;
            private InitialValueState initialValueState;
            protected final IAnnotatedElement annotatedElement;
            private final IGetter getter;
            private final ISetter setter;
            private final IScope scope;
            private final ScopeType scopeType;
            private Range arity;
            private List<String> stringValues = new ArrayList<String>();
            private List<String> originalStringValues = new ArrayList<String>();
            protected String toString;
            private final List<Object> typedValues = new ArrayList<Object>();
            Map<Integer, Object> typedValueAtPosition = new TreeMap<Integer, Object>();

            private <T extends Builder<T>> ArgSpec(Builder<T> builder) {
                this.userObject = ((Builder)builder).userObject;
                this.description = ((Builder)builder).description == null ? new String[]{} : ((Builder)builder).description;
                this.descriptionKey = ((Builder)builder).descriptionKey;
                this.splitRegex = ((Builder)builder).splitRegex == null ? "" : ((Builder)builder).splitRegex;
                this.splitRegexSynopsisLabel = ((Builder)builder).splitRegexSynopsisLabel == null ? "" : ((Builder)builder).splitRegexSynopsisLabel;
                this.paramLabel = CommandLine.empty(((Builder)builder).paramLabel) ? "PARAM" : ((Builder)builder).paramLabel;
                this.hideParamSyntax = ((Builder)builder).hideParamSyntax;
                this.converters = ((Builder)builder).converters == null ? new ITypeConverter[]{} : ((Builder)builder).converters;
                this.parameterConsumer = ((Builder)builder).parameterConsumer;
                this.preprocessor = ((Builder)builder).preprocessor != null ? ((Builder)builder).preprocessor : new NoOpParameterPreprocessor();
                this.showDefaultValue = ((Builder)builder).showDefaultValue == null ? Help.Visibility.ON_DEMAND : ((Builder)builder).showDefaultValue;
                this.hidden = ((Builder)builder).hidden;
                this.inherited = ((Builder)builder).inherited;
                this.root = ((Builder)builder).root == null && ScopeType.INHERIT.equals((Object)((Builder)builder).scopeType) ? this : ((Builder)builder).root;
                this.interactive = ((Builder)builder).interactive;
                this.echo = ((Builder)builder).echo;
                this.prompt = ((Builder)builder).prompt;
                this.initialValue = ((Builder)builder).initialValue;
                this.hasInitialValue = ((Builder)builder).hasInitialValue;
                this.initialValueState = ((Builder)builder).initialValueState;
                this.annotatedElement = ((Builder)builder).annotatedElement;
                this.defaultValue = NO_DEFAULT_VALUE.equals(((Builder)builder).defaultValue) ? null : ((Builder)builder).defaultValue;
                this.required = ((Builder)builder).required;
                this.originallyRequired = ((Builder)builder).originallyRequired;
                this.toString = ((Builder)builder).toString;
                this.getter = ((Builder)builder).getter;
                this.setter = ((Builder)builder).setter;
                this.scope = ((Builder)builder).scope;
                this.scopeType = ((Builder)builder).scopeType;
                this.mapFallbackValue = ((Builder)builder).mapFallbackValue;
                this.originalDefaultValue = ((Builder)builder).originalDefaultValue;
                this.originalMapFallbackValue = ((Builder)builder).originalMapFallbackValue;
                Range range = ((Builder)builder).arity;
                if (range == null) {
                    range = this.interactive ? Range.valueOf("0") : (this.isOption() ? (((Builder)builder).type == null || CommandLine.isBoolean(((Builder)builder).type) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1"));
                    range = range.unspecified(true);
                }
                this.arity = range;
                this.typeInfo = ((Builder)builder).typeInfo == null ? RuntimeTypeInfo.create(((Builder)builder).type, ((Builder)builder).auxiliaryTypes, Collections.<String>emptyList(), this.arity, this.isOption() ? Boolean.TYPE : String.class, this.interactive) : ((Builder)builder).typeInfo;
                if (((Builder)builder).completionCandidates == null && this.typeInfo.isEnum()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : this.typeInfo.getEnumConstantNames()) {
                        arrayList.add(string.toString());
                    }
                    this.completionCandidates = Collections.unmodifiableList(arrayList);
                } else {
                    this.completionCandidates = ((Builder)builder).completionCandidates;
                }
                if (this.interactive && !this.arity.isValidForInteractiveArgs()) {
                    throw new InitializationException("Interactive options and positional parameters are only supported for arity=0 and arity=0..1; not for arity=" + this.arity);
                }
                if (!CommandLine.empty(this.splitRegex) && !this.typeInfo.isMultiValue() && System.getProperty("picocli.ignore.invalid.split") == null) {
                    throw new InitializationException("Only multi-value options and positional parameters should have a split regex (this check can be disabled by setting system property 'picocli.ignore.invalid.split')");
                }
            }

            void applyInitialValue() {
                Tracer tracer = CommandLine.tracer();
                if (this.hasInitialValue()) {
                    try {
                        this.setter().set(this.initialValue());
                        tracer.debug("Set initial value for %s of type %s to %s.", this, this.type(), String.valueOf(this.initialValue()));
                    }
                    catch (Exception exception) {
                        tracer.warn("Could not set initial value for %s of type %s to %s: %s", this, this.type(), String.valueOf(this.initialValue()), exception);
                    }
                } else {
                    tracer.debug("Initial value not available for %s", this);
                }
            }

            public boolean originallyRequired() {
                return this.originallyRequired;
            }

            public boolean required() {
                return this.required && this.defaultValue() == null && this.defaultValueFromProvider() == null;
            }

            public boolean interactive() {
                return this.interactive;
            }

            public boolean echo() {
                return this.echo;
            }

            public String prompt() {
                return this.prompt;
            }

            public String[] description() {
                String[] stringArray = (String[])this.description.clone();
                if (this.messages() != null) {
                    String[] stringArray2 = this.messages().getStringArray(this.descriptionKey(), null);
                    if (stringArray2 == null) {
                        for (String string : this.getAdditionalDescriptionKeys()) {
                            stringArray2 = this.messages().getStringArray(string, null);
                            if (stringArray2 == null) continue;
                            stringArray = stringArray2;
                            break;
                        }
                    } else {
                        stringArray = stringArray2;
                    }
                }
                if (this.commandSpec == null || this.commandSpec.interpolateVariables()) {
                    stringArray = this.expandVariables(stringArray);
                }
                return stringArray;
            }

            protected abstract Collection<String> getAdditionalDescriptionKeys();

            public String descriptionKey() {
                return this.interpolate(this.descriptionKey);
            }

            private String[] expandVariables(String[] stringArray) {
                String[] stringArray2;
                if (stringArray.length == 0) {
                    return stringArray;
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                Object object = stringArray;
                int n2 = ((String[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringArray2 = object[i2];
                    if (!stringArray2.contains(DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && (object = this.completionCandidates()) != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string);
                    }
                }
                object = this.defaultValueString(false);
                String string = this.isOption() ? ((OptionSpec)this).fallbackValue : "";
                String string2 = String.valueOf(this.mapFallbackValue);
                stringArray2 = new String[stringArray.length];
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    stringArray2[i3] = CommandLine.format(stringArray[i3].replace(DESCRIPTION_VARIABLE_DEFAULT_VALUE, ((String)object).replace("%", "%%")).replace(DESCRIPTION_VARIABLE_FALLBACK_VALUE, string.replace("%", "%%")).replace(DESCRIPTION_VARIABLE_MAP_FALLBACK_VALUE, string2.replace("%", "%%")).replace(DESCRIPTION_VARIABLE_COMPLETION_CANDIDATES, stringBuilder.toString()), new Object[0]);
                }
                return this.interpolate(stringArray2);
            }

            @Deprecated
            public String[] renderedDescription() {
                return this.description();
            }

            public Range arity() {
                return this.arity;
            }

            public String paramLabel() {
                return this.interpolate(this.paramLabel);
            }

            public boolean hideParamSyntax() {
                return this.hideParamSyntax;
            }

            public Class<?>[] auxiliaryTypes() {
                return this.typeInfo.getAuxiliaryTypes();
            }

            public ITypeConverter<?>[] converters() {
                return (ITypeConverter[])this.converters.clone();
            }

            public String splitRegex() {
                return this.interpolate(this.splitRegex);
            }

            public String splitRegexSynopsisLabel() {
                return this.interpolate(this.splitRegexSynopsisLabel);
            }

            public boolean hidden() {
                return this.hidden;
            }

            public boolean inherited() {
                return this.inherited;
            }

            public ArgSpec root() {
                return this.root;
            }

            public Class<?> type() {
                return this.typeInfo.getType();
            }

            public ITypeInfo typeInfo() {
                return this.typeInfo;
            }

            public Object userObject() {
                return this.userObject;
            }

            public String mapFallbackValue() {
                String string = this.interpolate(this.mapFallbackValue);
                return NULL_VALUE.equals(string) ? null : string;
            }

            public String defaultValue() {
                return this.interpolate(this.defaultValue);
            }

            public Object initialValue() {
                if (this.initialValueState == InitialValueState.POSTPONED && this.annotatedElement != null) {
                    try {
                        this.initialValue = this.annotatedElement.getter().get();
                        this.initialValueState = InitialValueState.CACHED;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.initialValue;
            }

            public boolean hasInitialValue() {
                return this.hasInitialValue || this.initialValueState == InitialValueState.CACHED || this.initialValueState == InitialValueState.POSTPONED;
            }

            public Help.Visibility showDefaultValue() {
                return this.showDefaultValue;
            }

            public String defaultValueString() {
                return this.defaultValueString(false);
            }

            public String defaultValueString(boolean bl2) {
                Object object = this.calcDefaultValue(bl2);
                if (object != null && object.getClass().isArray()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i2 = 0; i2 < Array.getLength(object); ++i2) {
                        stringBuilder.append(i2 > 0 ? ", " : "").append(Array.get(object, i2));
                    }
                    return stringBuilder.insert(0, "[").append("]").toString();
                }
                return String.valueOf(object);
            }

            private Object calcDefaultValue(boolean bl2) {
                String string = this.defaultValueFromProvider();
                if (string == null) {
                    string = bl2 ? this.defaultValue() : this.defaultValue;
                }
                return string == null ? this.initialValue() : string;
            }

            private String defaultValueFromProvider() {
                if (this.commandSpec == null) {
                    return null;
                }
                String string = null;
                IDefaultValueProvider iDefaultValueProvider = null;
                try {
                    iDefaultValueProvider = this.commandSpec.defaultValueProvider();
                    string = iDefaultValueProvider == null ? null : iDefaultValueProvider.defaultValue(this);
                }
                catch (Exception exception) {
                    CommandLine.tracer().info("Error getting default value for %s from %s: %s", this, iDefaultValueProvider, exception);
                }
                return string;
            }

            public Iterable<String> completionCandidates() {
                return this.completionCandidates;
            }

            public IParameterConsumer parameterConsumer() {
                return this.parameterConsumer;
            }

            public IParameterPreprocessor preprocessor() {
                return this.preprocessor;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public IScope scope() {
                return this.scope;
            }

            public ScopeType scopeType() {
                return this.scopeType;
            }

            public boolean isValueGettable() {
                if (this.getter instanceof IScoped) {
                    IScoped iScoped = (IScoped)((Object)this.getter);
                    IScope iScope = iScoped.getScope();
                    if (iScope == null) {
                        return false;
                    }
                    try {
                        return iScope.get() != null;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return true;
            }

            public <T> T getValue() throws PicocliException {
                if (!this.isValueGettable()) {
                    return null;
                }
                try {
                    return this.getter.get();
                }
                catch (PicocliException picocliException) {
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not get value for " + this + ": " + exception, exception);
                }
            }

            public <T> T setValue(T t2) throws PicocliException {
                try {
                    return this.setter.set(t2);
                }
                catch (PicocliException picocliException) {
                    throw picocliException;
                }
                catch (Exception exception) {
                    throw new PicocliException("Could not set value (" + t2 + ") for " + this + ": " + exception, exception);
                }
            }

            @Deprecated
            public <T> T setValue(T t2, CommandLine commandLine) throws PicocliException {
                return this.setValue(t2);
            }

            public boolean isMultiValue() {
                return this.typeInfo.isMultiValue();
            }

            public abstract boolean isOption();

            public abstract boolean isPositional();

            public ArgGroupSpec group() {
                return this.group;
            }

            public CommandSpec command() {
                return this.commandSpec;
            }

            public List<String> stringValues() {
                return Collections.unmodifiableList(this.stringValues);
            }

            public List<Object> typedValues() {
                return Collections.unmodifiableList(this.typedValues);
            }

            protected void resetStringValues() {
                this.stringValues = new ArrayList<String>();
            }

            public List<String> originalStringValues() {
                return Collections.unmodifiableList(this.originalStringValues);
            }

            protected void resetOriginalStringValues() {
                this.originalStringValues = new ArrayList<String>();
            }

            protected boolean internalShowDefaultValue(boolean bl2) {
                if (this.showDefaultValue() == Help.Visibility.ALWAYS) {
                    return true;
                }
                if (this.showDefaultValue() == Help.Visibility.NEVER) {
                    return false;
                }
                if (this.initialValue() == null && this.defaultValue() == null && this.defaultValueFromProvider() == null) {
                    return false;
                }
                return bl2 && !CommandLine.isBoolean(this.type());
            }

            public Messages messages() {
                return this.messages;
            }

            public ArgSpec messages(Messages messages) {
                this.messages = messages;
                return this;
            }

            public String toString() {
                return this.toString;
            }

            private String scopeString() {
                try {
                    Object t2 = this.scope.get();
                    if (t2 == null) {
                        return "<no user object>";
                    }
                    return t2.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(t2));
                }
                catch (Exception exception) {
                    return "?: " + exception.toString();
                }
            }

            String[] splitValue(String string, ParserSpec parserSpec, Range range, int n2) {
                int n3;
                if (this.splitRegex().length() == 0) {
                    return new String[]{string};
                }
                int n4 = n3 = parserSpec.limitSplit() ? Math.max(range.max - n2, 0) : 0;
                if (parserSpec.splitQuotedStrings()) {
                    return this.debug(string.split(this.splitRegex(), n3), "Split (ignoring quotes)", string);
                }
                return this.debug(ArgSpec.splitRespectingQuotedStrings(string, n3, parserSpec, this, this.splitRegex()), "Split", string);
            }

            private String[] debug(String[] stringArray, String string, String string2) {
                Tracer tracer = CommandLine.tracer();
                if (tracer.isDebug()) {
                    tracer.debug("%s with regex '%s' resulted in %s parts: %s", string, this.splitRegex(), stringArray.length, Arrays.asList(stringArray));
                }
                return stringArray;
            }

            private static String[] splitRespectingQuotedStrings(String string, int n2, ParserSpec parserSpec, ArgSpec argSpec, String string2) {
                int n3;
                int n4;
                LinkedList<String> linkedList = new LinkedList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                StringBuilder stringBuilder3 = stringBuilder;
                boolean bl2 = false;
                boolean bl3 = false;
                block4: for (n3 = 0; n3 < string.length(); n3 += Character.charCount(n4)) {
                    n4 = string.codePointAt(n3);
                    switch (n4) {
                        case 92: {
                            bl2 = !bl2;
                            break;
                        }
                        case 34: {
                            if (!bl2) {
                                bl3 = !bl3;
                                StringBuilder stringBuilder4 = stringBuilder3 = bl3 ? stringBuilder2 : stringBuilder;
                                if (bl3) {
                                    stringBuilder.appendCodePoint(n4);
                                    continue block4;
                                }
                                linkedList.add(stringBuilder2.toString());
                                stringBuilder2.setLength(0);
                            }
                            bl2 = false;
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                    stringBuilder3.appendCodePoint(n4);
                }
                if (stringBuilder2.length() > 0) {
                    CommandLine.tracer().warn("Unbalanced quotes in [%s] for %s (value=%s)", stringBuilder2, argSpec, string);
                    linkedList.add(stringBuilder2.toString());
                    stringBuilder2.setLength(0);
                }
                String[] stringArray = stringBuilder.toString().split(string2, n2);
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = ArgSpec.restoreQuotedValues(stringArray[n3], linkedList, parserSpec);
                }
                if (!linkedList.isEmpty()) {
                    CommandLine.tracer().warn("Unable to respect quotes while splitting value %s for %s (unprocessed remainder: %s)", string, argSpec, linkedList);
                    return string.split(string2, n2);
                }
                return stringArray;
            }

            private static String restoreQuotedValues(String string, Queue<String> queue, ParserSpec parserSpec) {
                int n2;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
                    n2 = string.codePointAt(i2);
                    switch (n2) {
                        case 92: {
                            bl2 = !bl2;
                            break;
                        }
                        case 34: {
                            if (bl2) break;
                            boolean bl5 = bl3 = !bl3;
                            if (bl3) break;
                            stringBuilder.append(queue.remove());
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                    if (!bl4) {
                        stringBuilder.appendCodePoint(n2);
                    }
                    bl4 = false;
                }
                return parserSpec.trimQuotes() ? CommandLine.smartUnquote(stringBuilder.toString()) : stringBuilder.toString();
            }

            protected boolean equalsImpl(ArgSpec argSpec) {
                return Assert.equals(this.defaultValue, argSpec.defaultValue) && Assert.equals(this.mapFallbackValue, argSpec.mapFallbackValue) && Assert.equals(this.arity, argSpec.arity) && Assert.equals(this.hidden, argSpec.hidden) && Assert.equals(this.inherited, argSpec.inherited) && Assert.equals(this.paramLabel, argSpec.paramLabel) && Assert.equals(this.hideParamSyntax, argSpec.hideParamSyntax) && Assert.equals(this.required, argSpec.required) && Assert.equals(this.splitRegex, argSpec.splitRegex) && Assert.equals(this.splitRegexSynopsisLabel, argSpec.splitRegexSynopsisLabel) && Arrays.equals(this.description, argSpec.description) && Assert.equals(this.descriptionKey, argSpec.descriptionKey) && Assert.equals(this.parameterConsumer, argSpec.parameterConsumer) && Assert.equals(this.preprocessor, argSpec.preprocessor) && this.typeInfo.equals(argSpec.typeInfo) && this.scopeType.equals((Object)argSpec.scopeType);
            }

            protected int hashCodeImpl() {
                return 17 + 37 * Assert.hashCode(this.defaultValue) + 37 * Assert.hashCode(this.mapFallbackValue) + 37 * Assert.hashCode(this.arity) + 37 * Assert.hashCode(this.hidden) + 37 * Assert.hashCode(this.inherited) + 37 * Assert.hashCode(this.paramLabel) + 37 * Assert.hashCode(this.hideParamSyntax) + 37 * Assert.hashCode(this.required) + 37 * Assert.hashCode(this.splitRegex) + 37 * Assert.hashCode(this.splitRegexSynopsisLabel) + 37 * Arrays.hashCode(this.description) + 37 * Assert.hashCode(this.descriptionKey) + 37 * Assert.hashCode(this.parameterConsumer) + 37 * Assert.hashCode(this.preprocessor) + 37 * this.typeInfo.hashCode() + 37 * this.scopeType.hashCode();
            }

            private static String describeTypes(Collection<ArgSpec> collection) {
                if (collection.isEmpty()) {
                    return "";
                }
                int n2 = 0;
                int n3 = 0;
                for (ArgSpec argSpec : collection) {
                    if (argSpec.isOption()) {
                        ++n2;
                        continue;
                    }
                    ++n3;
                }
                if (n2 == 0) {
                    return n3 == 1 ? "parameter" : "parameters";
                }
                if (n3 == 0) {
                    return n2 == 1 ? "option" : "options";
                }
                return "options and parameters";
            }

            private static String describe(Collection<ArgSpec> collection) {
                return ArgSpec.describe(collection, ", ", "=", "", "");
            }

            private static String describe(Collection<ArgSpec> collection, String string, String string2, String string3, String string4) {
                StringBuilder stringBuilder = new StringBuilder();
                for (ArgSpec argSpec : collection) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(string);
                    }
                    if (argSpec.isPositional()) {
                        stringBuilder.append(string3).append(argSpec.paramLabel()).append(string4);
                        continue;
                    }
                    stringBuilder.append(string3).append(((OptionSpec)argSpec).longestName());
                    if (argSpec.arity().min() > 0) {
                        stringBuilder.append(string2).append(argSpec.paramLabel());
                    }
                    stringBuilder.append(string4);
                }
                return stringBuilder.toString();
            }

            private static String describe(ArgSpec argSpec, String string) {
                return ArgSpec.describe(argSpec, string, argSpec.paramLabel());
            }

            private static String describe(ArgSpec argSpec, String string, String string2) {
                String string3 = argSpec.isOption() ? ((OptionSpec)argSpec).longestName() : "params[" + ((PositionalParamSpec)argSpec).index() + "]";
                return argSpec.arity().min > 0 ? string3 + string + string2 : string3;
            }

            String interpolate(String string) {
                return this.commandSpec == null ? string : this.commandSpec.interpolator.interpolate(string);
            }

            String[] interpolate(String[] stringArray) {
                return this.commandSpec == null ? stringArray : this.commandSpec.interpolator.interpolate(stringArray);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static abstract class Builder<T extends Builder<T>> {
                private Object userObject;
                private Range arity;
                private String[] description;
                private String descriptionKey;
                private boolean required;
                private boolean originallyRequired;
                private boolean interactive;
                private boolean echo;
                private String prompt;
                private String paramLabel;
                private boolean hideParamSyntax;
                private String splitRegex;
                private String splitRegexSynopsisLabel;
                private boolean hidden;
                private ArgSpec root;
                private boolean inherited;
                private Class<?> type;
                private Class<?>[] auxiliaryTypes;
                private ITypeInfo typeInfo;
                private ITypeConverter<?>[] converters;
                private String defaultValue;
                private Object initialValue;
                private boolean hasInitialValue = true;
                private InitialValueState initialValueState = InitialValueState.UNAVAILABLE;
                private Help.Visibility showDefaultValue;
                private Iterable<String> completionCandidates;
                private IParameterConsumer parameterConsumer;
                private IParameterPreprocessor preprocessor;
                private String toString;
                private IGetter getter = new ObjectBinding();
                private ISetter setter = (ISetter)((Object)this.getter);
                private IScope scope = new ObjectScope(null);
                private ScopeType scopeType = ScopeType.LOCAL;
                private IAnnotatedElement annotatedElement;
                private String mapFallbackValue = "__unspecified__";
                private String originalDefaultValue = "__unspecified__";
                private String originalMapFallbackValue = "__unspecified__";

                Builder() {
                }

                Builder(ArgSpec argSpec) {
                    this.userObject = argSpec.userObject;
                    this.arity = argSpec.arity;
                    this.description = argSpec.description;
                    this.descriptionKey = argSpec.descriptionKey;
                    this.required = argSpec.required;
                    this.originallyRequired = argSpec.originallyRequired;
                    this.interactive = argSpec.interactive;
                    this.echo = argSpec.echo;
                    this.prompt = argSpec.prompt;
                    this.paramLabel = argSpec.paramLabel;
                    this.hideParamSyntax = argSpec.hideParamSyntax;
                    this.splitRegex = argSpec.splitRegex;
                    this.splitRegexSynopsisLabel = argSpec.splitRegexSynopsisLabel;
                    this.hidden = argSpec.hidden;
                    this.inherited = argSpec.inherited;
                    this.root = argSpec.root;
                    this.setTypeInfo(argSpec.typeInfo);
                    this.converters = argSpec.converters;
                    this.defaultValue = argSpec.defaultValue;
                    this.annotatedElement = argSpec.annotatedElement;
                    this.initialValue = argSpec.initialValue;
                    this.initialValueState = argSpec.initialValueState;
                    this.hasInitialValue = argSpec.hasInitialValue;
                    this.showDefaultValue = argSpec.showDefaultValue;
                    this.completionCandidates = argSpec.completionCandidates;
                    this.parameterConsumer = argSpec.parameterConsumer;
                    this.preprocessor = argSpec.preprocessor;
                    this.toString = argSpec.toString;
                    this.getter = argSpec.getter;
                    this.setter = argSpec.setter;
                    this.scope = argSpec.scope;
                    this.scopeType = argSpec.scopeType;
                    this.originalDefaultValue = argSpec.originalDefaultValue;
                    this.originalMapFallbackValue = argSpec.originalMapFallbackValue;
                }

                Builder(IAnnotatedElement iAnnotatedElement) {
                    this.annotatedElement = iAnnotatedElement;
                    this.userObject = iAnnotatedElement.userObject();
                    this.setTypeInfo(iAnnotatedElement.getTypeInfo());
                    this.toString = iAnnotatedElement.getToString();
                    this.getter = iAnnotatedElement.getter();
                    this.setter = iAnnotatedElement.setter();
                    this.scope = iAnnotatedElement.scope();
                    this.hasInitialValue = iAnnotatedElement.hasInitialValue();
                    if (iAnnotatedElement instanceof IExtensible) {
                        this.initialValueState = ((IExtensible)((Object)iAnnotatedElement)).getExtension(InitialValueState.class);
                    }
                }

                Builder(Option option, IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                    this(iAnnotatedElement);
                    this.arity = Range.optionArity(iAnnotatedElement);
                    this.required = option.required();
                    this.paramLabel = Builder.inferLabel(option.paramLabel(), iAnnotatedElement.getName(), iAnnotatedElement.getTypeInfo());
                    this.hideParamSyntax = option.hideParamSyntax();
                    this.interactive = option.interactive();
                    this.echo = option.echo();
                    this.prompt = option.prompt();
                    this.description = option.description();
                    this.descriptionKey = option.descriptionKey();
                    this.splitRegex = option.split();
                    this.splitRegexSynopsisLabel = option.splitSynopsisLabel();
                    this.hidden = option.hidden();
                    this.defaultValue = ArgSpec.NULL_VALUE.equals(option.defaultValue()) ? null : option.defaultValue();
                    this.mapFallbackValue = ArgSpec.NULL_VALUE.equals(option.mapFallbackValue()) ? null : option.mapFallbackValue();
                    this.originalDefaultValue = option.defaultValue();
                    this.originalMapFallbackValue = option.mapFallbackValue();
                    this.showDefaultValue = option.showDefaultValue();
                    this.scopeType = option.scope();
                    this.inherited = false;
                    if (iFactory != null) {
                        this.converters = DefaultFactory.createConverter(iFactory, option.converter());
                        if (!NoCompletionCandidates.class.equals(option.completionCandidates())) {
                            this.completionCandidates = DefaultFactory.createCompletionCandidates(iFactory, option.completionCandidates());
                        }
                        if (!NullParameterConsumer.class.equals(option.parameterConsumer())) {
                            this.parameterConsumer = DefaultFactory.createParameterConsumer(iFactory, option.parameterConsumer());
                        }
                        if (!NoOpParameterPreprocessor.class.equals(option.preprocessor())) {
                            this.preprocessor = DefaultFactory.create(iFactory, option.preprocessor());
                        }
                    }
                }

                Builder(Parameters parameters, IAnnotatedElement iAnnotatedElement, IFactory iFactory) {
                    this(iAnnotatedElement);
                    this.arity = Range.parameterArity(iAnnotatedElement);
                    boolean bl2 = this.required = this.arity.min > 0;
                    if (parameters == null) {
                        this.paramLabel = Builder.inferLabel(null, iAnnotatedElement.getName(), iAnnotatedElement.getTypeInfo());
                    } else {
                        this.paramLabel = Builder.inferLabel(parameters.paramLabel(), iAnnotatedElement.getName(), iAnnotatedElement.getTypeInfo());
                        this.hideParamSyntax = parameters.hideParamSyntax();
                        this.interactive = parameters.interactive();
                        this.echo = parameters.echo();
                        this.prompt = parameters.prompt();
                        this.description = parameters.description();
                        this.descriptionKey = parameters.descriptionKey();
                        this.splitRegex = parameters.split();
                        this.splitRegexSynopsisLabel = parameters.splitSynopsisLabel();
                        this.hidden = parameters.hidden();
                        this.defaultValue = ArgSpec.NULL_VALUE.equals(parameters.defaultValue()) ? null : parameters.defaultValue();
                        this.mapFallbackValue = ArgSpec.NULL_VALUE.equals(parameters.mapFallbackValue()) ? null : parameters.mapFallbackValue();
                        this.originalDefaultValue = parameters.defaultValue();
                        this.originalMapFallbackValue = parameters.mapFallbackValue();
                        this.showDefaultValue = parameters.showDefaultValue();
                        this.scopeType = parameters.scope();
                        this.inherited = false;
                        if (iFactory != null) {
                            this.converters = DefaultFactory.createConverter(iFactory, parameters.converter());
                            if (!NoCompletionCandidates.class.equals(parameters.completionCandidates())) {
                                this.completionCandidates = DefaultFactory.createCompletionCandidates(iFactory, parameters.completionCandidates());
                            }
                            if (!NullParameterConsumer.class.equals(parameters.parameterConsumer())) {
                                this.parameterConsumer = DefaultFactory.createParameterConsumer(iFactory, parameters.parameterConsumer());
                            }
                            if (!NoOpParameterPreprocessor.class.equals(parameters.preprocessor())) {
                                this.preprocessor = DefaultFactory.create(iFactory, parameters.preprocessor());
                            }
                        }
                    }
                }

                private static String inferLabel(String string, String string2, ITypeInfo iTypeInfo) {
                    if (!CommandLine.empty(string)) {
                        return string.trim();
                    }
                    String string3 = string2;
                    if (iTypeInfo.isMap()) {
                        List<ITypeInfo> list = iTypeInfo.getAuxiliaryTypeInfos();
                        string3 = list.size() < 2 || list.get(0) == null || list.get(1) == null ? "String=String" : list.get(0).getClassSimpleName() + "=" + list.get(1).getClassSimpleName();
                    }
                    return "<" + string3 + ">";
                }

                public abstract ArgSpec build();

                protected abstract T self();

                public boolean required() {
                    return this.required;
                }

                public boolean interactive() {
                    return this.interactive;
                }

                public boolean echo() {
                    return this.echo;
                }

                public String prompt() {
                    return this.prompt;
                }

                public String[] description() {
                    return this.description;
                }

                public String descriptionKey() {
                    return this.descriptionKey;
                }

                public Range arity() {
                    return this.arity;
                }

                public String paramLabel() {
                    return this.paramLabel;
                }

                public boolean hideParamSyntax() {
                    return this.hideParamSyntax;
                }

                public Class<?>[] auxiliaryTypes() {
                    return this.auxiliaryTypes;
                }

                public ITypeConverter<?>[] converters() {
                    return this.converters;
                }

                public String splitRegex() {
                    return this.splitRegex;
                }

                public String splitRegexSynopsisLabel() {
                    return this.splitRegexSynopsisLabel;
                }

                public boolean hidden() {
                    return this.hidden;
                }

                public boolean inherited() {
                    return this.inherited;
                }

                public ArgSpec root() {
                    return this.root;
                }

                public Class<?> type() {
                    return this.type;
                }

                public ITypeInfo typeInfo() {
                    return this.typeInfo;
                }

                public Object userObject() {
                    return this.userObject;
                }

                public String mapFallbackValue() {
                    return this.mapFallbackValue;
                }

                public String defaultValue() {
                    return this.defaultValue;
                }

                public Object initialValue() {
                    return this.initialValue;
                }

                public boolean hasInitialValue() {
                    return this.hasInitialValue;
                }

                public Help.Visibility showDefaultValue() {
                    return this.showDefaultValue;
                }

                public Iterable<String> completionCandidates() {
                    return this.completionCandidates;
                }

                public IParameterConsumer parameterConsumer() {
                    return this.parameterConsumer;
                }

                public IParameterPreprocessor preprocessor() {
                    return this.preprocessor;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public IScope scope() {
                    return this.scope;
                }

                public ScopeType scopeType() {
                    return this.scopeType;
                }

                public String toString() {
                    return this.toString;
                }

                public T required(boolean bl2) {
                    this.required = bl2;
                    return this.self();
                }

                public T interactive(boolean bl2) {
                    this.interactive = bl2;
                    return this.self();
                }

                public T echo(boolean bl2) {
                    this.echo = bl2;
                    return this.self();
                }

                public T prompt(String string) {
                    this.prompt = string;
                    return this.self();
                }

                public T description(String ... stringArray) {
                    this.description = (String[])Assert.notNull(stringArray, "description").clone();
                    return this.self();
                }

                public T descriptionKey(String string) {
                    this.descriptionKey = string;
                    return this.self();
                }

                public T arity(String string) {
                    return this.arity(Range.valueOf(string));
                }

                public T arity(Range range) {
                    this.arity = Assert.notNull(range, "arity");
                    return this.self();
                }

                public T paramLabel(String string) {
                    this.paramLabel = Assert.notNull(string, "paramLabel");
                    return this.self();
                }

                public T hideParamSyntax(boolean bl2) {
                    this.hideParamSyntax = bl2;
                    return this.self();
                }

                public T auxiliaryTypes(Class<?> ... classArray) {
                    this.auxiliaryTypes = (Class[])Assert.notNull(classArray, "types").clone();
                    return this.self();
                }

                public T converters(ITypeConverter<?> ... iTypeConverterArray) {
                    this.converters = (ITypeConverter[])Assert.notNull(iTypeConverterArray, "type converters").clone();
                    return this.self();
                }

                public T splitRegex(String string) {
                    this.splitRegex = Assert.notNull(string, "splitRegex");
                    return this.self();
                }

                public T splitRegexSynopsisLabel(String string) {
                    this.splitRegexSynopsisLabel = Assert.notNull(string, "splitRegexSynopsisLabel");
                    return this.self();
                }

                public T showDefaultValue(Help.Visibility visibility) {
                    this.showDefaultValue = Assert.notNull(visibility, "visibility");
                    return this.self();
                }

                public T completionCandidates(Iterable<String> iterable) {
                    this.completionCandidates = iterable;
                    return this.self();
                }

                public T parameterConsumer(IParameterConsumer iParameterConsumer) {
                    this.parameterConsumer = iParameterConsumer;
                    return this.self();
                }

                public T preprocessor(IParameterPreprocessor iParameterPreprocessor) {
                    this.preprocessor = iParameterPreprocessor;
                    return this.self();
                }

                public T hidden(boolean bl2) {
                    this.hidden = bl2;
                    return this.self();
                }

                public T inherited(boolean bl2) {
                    this.inherited = bl2;
                    return this.self();
                }

                public T root(ArgSpec argSpec) {
                    this.root = argSpec;
                    return this.self();
                }

                public T type(Class<?> clazz) {
                    this.type = Assert.notNull(clazz, "type");
                    return this.self();
                }

                public T typeInfo(ITypeInfo iTypeInfo) {
                    this.setTypeInfo(Assert.notNull(iTypeInfo, "typeInfo"));
                    return this.self();
                }

                private void setTypeInfo(ITypeInfo iTypeInfo) {
                    this.typeInfo = iTypeInfo;
                    if (this.typeInfo != null) {
                        this.type = this.typeInfo.getType();
                        this.auxiliaryTypes = this.typeInfo.getAuxiliaryTypes();
                    }
                }

                public T userObject(Object object) {
                    this.userObject = Assert.notNull(object, "userObject");
                    return this.self();
                }

                public Builder mapFallbackValue(String string) {
                    this.mapFallbackValue = string;
                    return this.self();
                }

                public T defaultValue(String string) {
                    this.defaultValue = string;
                    return this.self();
                }

                public T initialValue(Object object) {
                    this.initialValue = object;
                    return this.self();
                }

                public T hasInitialValue(boolean bl2) {
                    this.hasInitialValue = bl2;
                    return this.self();
                }

                public T getter(IGetter iGetter) {
                    this.getter = iGetter;
                    return this.self();
                }

                public T setter(ISetter iSetter) {
                    this.setter = iSetter;
                    return this.self();
                }

                public T scope(IScope iScope) {
                    this.scope = iScope;
                    return this.self();
                }

                public T scopeType(ScopeType scopeType) {
                    this.scopeType = scopeType;
                    return this.self();
                }

                public T withToString(String string) {
                    this.toString = string;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum InitialValueState {
            CACHED,
            POSTPONED,
            UNAVAILABLE;

        }

        public static class ParserSpec {
            static final String DEFAULT_SEPARATOR = "=";
            static final String DEFAULT_END_OF_OPTIONS_DELIMITER = "--";
            private boolean abbreviatedOptionsAllowed = false;
            private boolean abbreviatedSubcommandsAllowed = false;
            private boolean allowOptionsAsOptionParameters = false;
            private boolean allowSubcommandsAsOptionParameters = false;
            private boolean aritySatisfiedByAttachedOptionParam = false;
            private Character atFileCommentChar = Character.valueOf('#');
            private boolean caseInsensitiveEnumValuesAllowed = false;
            private boolean collectErrors = false;
            private String endOfOptionsDelimiter = "--";
            private boolean expandAtFiles = true;
            private boolean limitSplit = false;
            private boolean overwrittenOptionsAllowed = false;
            private boolean posixClusteredShortOptionsAllowed = true;
            private String separator;
            private boolean splitQuotedStrings = false;
            private boolean stopAtPositional = false;
            private boolean stopAtUnmatched = false;
            private boolean toggleBooleanFlags = false;
            private boolean trimQuotes = this.shouldTrimQuotes();
            private boolean unmatchedArgumentsAllowed = false;
            private boolean unmatchedOptionsAllowedAsOptionParameters = true;
            private boolean unmatchedOptionsArePositionalParams = false;
            private boolean useSimplifiedAtFiles = false;

            public String separator() {
                return this.separator == null ? DEFAULT_SEPARATOR : this.separator;
            }

            public boolean stopAtUnmatched() {
                return this.stopAtUnmatched;
            }

            public boolean stopAtPositional() {
                return this.stopAtPositional;
            }

            public String endOfOptionsDelimiter() {
                return this.endOfOptionsDelimiter;
            }

            public boolean toggleBooleanFlags() {
                return this.toggleBooleanFlags;
            }

            public boolean overwrittenOptionsAllowed() {
                return this.overwrittenOptionsAllowed;
            }

            public boolean unmatchedArgumentsAllowed() {
                return this.unmatchedArgumentsAllowed;
            }

            public boolean abbreviatedSubcommandsAllowed() {
                return this.abbreviatedSubcommandsAllowed;
            }

            public boolean abbreviatedOptionsAllowed() {
                return this.abbreviatedOptionsAllowed;
            }

            public boolean expandAtFiles() {
                return this.expandAtFiles;
            }

            public Character atFileCommentChar() {
                return this.atFileCommentChar;
            }

            public boolean useSimplifiedAtFiles() {
                String string = System.getProperty("picocli.useSimplifiedAtFiles");
                if (string != null) {
                    return "".equals(string) || Boolean.parseBoolean(string);
                }
                return this.useSimplifiedAtFiles;
            }

            public boolean posixClusteredShortOptionsAllowed() {
                return this.posixClusteredShortOptionsAllowed;
            }

            public boolean caseInsensitiveEnumValuesAllowed() {
                return this.caseInsensitiveEnumValuesAllowed;
            }

            public boolean trimQuotes() {
                return this.trimQuotes;
            }

            public boolean splitQuotedStrings() {
                return this.splitQuotedStrings;
            }

            public boolean unmatchedOptionsArePositionalParams() {
                return this.unmatchedOptionsArePositionalParams;
            }

            public boolean unmatchedOptionsAllowedAsOptionParameters() {
                return this.unmatchedOptionsAllowedAsOptionParameters;
            }

            public boolean allowSubcommandsAsOptionParameters() {
                return this.allowSubcommandsAsOptionParameters;
            }

            public boolean allowOptionsAsOptionParameters() {
                return this.allowOptionsAsOptionParameters;
            }

            private boolean splitFirst() {
                return this.limitSplit();
            }

            public boolean limitSplit() {
                return this.limitSplit;
            }

            public boolean aritySatisfiedByAttachedOptionParam() {
                return this.aritySatisfiedByAttachedOptionParam;
            }

            public boolean collectErrors() {
                return this.collectErrors;
            }

            public ParserSpec separator(String string) {
                this.separator = string;
                return this;
            }

            public ParserSpec stopAtUnmatched(boolean bl2) {
                this.stopAtUnmatched = bl2;
                return this;
            }

            public ParserSpec stopAtPositional(boolean bl2) {
                this.stopAtPositional = bl2;
                return this;
            }

            public ParserSpec endOfOptionsDelimiter(String string) {
                this.endOfOptionsDelimiter = Assert.notNull(string, "end-of-options delimiter");
                return this;
            }

            public ParserSpec toggleBooleanFlags(boolean bl2) {
                this.toggleBooleanFlags = bl2;
                return this;
            }

            public ParserSpec overwrittenOptionsAllowed(boolean bl2) {
                this.overwrittenOptionsAllowed = bl2;
                return this;
            }

            public ParserSpec unmatchedArgumentsAllowed(boolean bl2) {
                this.unmatchedArgumentsAllowed = bl2;
                return this;
            }

            public ParserSpec abbreviatedSubcommandsAllowed(boolean bl2) {
                this.abbreviatedSubcommandsAllowed = bl2;
                return this;
            }

            public ParserSpec abbreviatedOptionsAllowed(boolean bl2) {
                this.abbreviatedOptionsAllowed = bl2;
                return this;
            }

            public ParserSpec expandAtFiles(boolean bl2) {
                this.expandAtFiles = bl2;
                return this;
            }

            public ParserSpec atFileCommentChar(Character c2) {
                this.atFileCommentChar = c2;
                return this;
            }

            public ParserSpec useSimplifiedAtFiles(boolean bl2) {
                this.useSimplifiedAtFiles = bl2;
                return this;
            }

            public ParserSpec posixClusteredShortOptionsAllowed(boolean bl2) {
                this.posixClusteredShortOptionsAllowed = bl2;
                return this;
            }

            public ParserSpec caseInsensitiveEnumValuesAllowed(boolean bl2) {
                this.caseInsensitiveEnumValuesAllowed = bl2;
                return this;
            }

            public ParserSpec trimQuotes(boolean bl2) {
                this.trimQuotes = bl2;
                return this;
            }

            public ParserSpec splitQuotedStrings(boolean bl2) {
                this.splitQuotedStrings = bl2;
                return this;
            }

            public ParserSpec unmatchedOptionsAllowedAsOptionParameters(boolean bl2) {
                this.unmatchedOptionsAllowedAsOptionParameters = bl2;
                return this;
            }

            public ParserSpec unmatchedOptionsArePositionalParams(boolean bl2) {
                this.unmatchedOptionsArePositionalParams = bl2;
                return this;
            }

            public ParserSpec allowSubcommandsAsOptionParameters(boolean bl2) {
                this.allowSubcommandsAsOptionParameters = bl2;
                return this;
            }

            public ParserSpec allowOptionsAsOptionParameters(boolean bl2) {
                this.allowOptionsAsOptionParameters = bl2;
                return this;
            }

            public ParserSpec collectErrors(boolean bl2) {
                this.collectErrors = bl2;
                return this;
            }

            public ParserSpec aritySatisfiedByAttachedOptionParam(boolean bl2) {
                this.aritySatisfiedByAttachedOptionParam = bl2;
                return this;
            }

            public ParserSpec limitSplit(boolean bl2) {
                this.limitSplit = bl2;
                return this;
            }

            private boolean shouldTrimQuotes() {
                String string = System.getProperty("picocli.trimQuotes");
                if ("".equals(string)) {
                    string = "true";
                }
                return Boolean.parseBoolean(string);
            }

            void initSeparator(String string) {
                if (Model.initializable(this.separator, string, DEFAULT_SEPARATOR)) {
                    this.separator = string;
                }
            }

            void updateSeparator(String string) {
                if (Model.isNonDefault(string, DEFAULT_SEPARATOR)) {
                    this.separator = string;
                }
            }

            public String toString() {
                return String.format("abbreviatedOptionsAllowed=%s, abbreviatedSubcommandsAllowed=%s, allowOptionsAsOptionParameters=%s, allowSubcommandsAsOptionParameters=%s, aritySatisfiedByAttachedOptionParam=%s, atFileCommentChar=%s, caseInsensitiveEnumValuesAllowed=%s, collectErrors=%s, endOfOptionsDelimiter=%s, expandAtFiles=%s, limitSplit=%s, overwrittenOptionsAllowed=%s, posixClusteredShortOptionsAllowed=%s, separator=%s, splitQuotedStrings=%s, stopAtPositional=%s, stopAtUnmatched=%s, toggleBooleanFlags=%s, trimQuotes=%s, unmatchedArgumentsAllowed=%s, unmatchedOptionsAllowedAsOptionParameters=%s, unmatchedOptionsArePositionalParams=%s, useSimplifiedAtFiles=%s", this.abbreviatedOptionsAllowed, this.abbreviatedSubcommandsAllowed, this.allowOptionsAsOptionParameters, this.allowSubcommandsAsOptionParameters, this.aritySatisfiedByAttachedOptionParam, this.atFileCommentChar, this.caseInsensitiveEnumValuesAllowed, this.collectErrors, this.endOfOptionsDelimiter, this.expandAtFiles, this.limitSplit, this.overwrittenOptionsAllowed, this.posixClusteredShortOptionsAllowed, this.separator, this.splitQuotedStrings, this.stopAtPositional, this.stopAtUnmatched, this.toggleBooleanFlags, this.trimQuotes, this.unmatchedArgumentsAllowed, this.unmatchedOptionsAllowedAsOptionParameters, this.unmatchedOptionsArePositionalParams, this.useSimplifiedAtFiles);
            }

            void initFrom(ParserSpec parserSpec) {
                this.abbreviatedOptionsAllowed = parserSpec.abbreviatedOptionsAllowed;
                this.abbreviatedSubcommandsAllowed = parserSpec.abbreviatedSubcommandsAllowed;
                this.allowOptionsAsOptionParameters = parserSpec.allowOptionsAsOptionParameters;
                this.allowSubcommandsAsOptionParameters = parserSpec.allowSubcommandsAsOptionParameters;
                this.aritySatisfiedByAttachedOptionParam = parserSpec.aritySatisfiedByAttachedOptionParam;
                this.atFileCommentChar = parserSpec.atFileCommentChar;
                this.caseInsensitiveEnumValuesAllowed = parserSpec.caseInsensitiveEnumValuesAllowed;
                this.collectErrors = parserSpec.collectErrors;
                this.endOfOptionsDelimiter = parserSpec.endOfOptionsDelimiter;
                this.expandAtFiles = parserSpec.expandAtFiles;
                this.limitSplit = parserSpec.limitSplit;
                this.overwrittenOptionsAllowed = parserSpec.overwrittenOptionsAllowed;
                this.posixClusteredShortOptionsAllowed = parserSpec.posixClusteredShortOptionsAllowed;
                this.separator = parserSpec.separator;
                this.splitQuotedStrings = parserSpec.splitQuotedStrings;
                this.stopAtPositional = parserSpec.stopAtPositional;
                this.stopAtUnmatched = parserSpec.stopAtUnmatched;
                this.toggleBooleanFlags = parserSpec.toggleBooleanFlags;
                this.trimQuotes = parserSpec.trimQuotes;
                this.unmatchedArgumentsAllowed = parserSpec.unmatchedArgumentsAllowed;
                this.unmatchedOptionsAllowedAsOptionParameters = parserSpec.unmatchedOptionsAllowedAsOptionParameters;
                this.unmatchedOptionsArePositionalParams = parserSpec.unmatchedOptionsArePositionalParams;
                this.useSimplifiedAtFiles = parserSpec.useSimplifiedAtFiles;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class UsageMessageSpec {
            public static final String SECTION_KEY_HEADER_HEADING = "headerHeading";
            public static final String SECTION_KEY_HEADER = "header";
            public static final String SECTION_KEY_SYNOPSIS_HEADING = "synopsisHeading";
            public static final String SECTION_KEY_SYNOPSIS = "synopsis";
            public static final String SECTION_KEY_DESCRIPTION_HEADING = "descriptionHeading";
            public static final String SECTION_KEY_DESCRIPTION = "description";
            public static final String SECTION_KEY_PARAMETER_LIST_HEADING = "parameterListHeading";
            public static final String SECTION_KEY_AT_FILE_PARAMETER = "atFileParameterList";
            public static final String SECTION_KEY_PARAMETER_LIST = "parameterList";
            public static final String SECTION_KEY_OPTION_LIST_HEADING = "optionListHeading";
            public static final String SECTION_KEY_OPTION_LIST = "optionList";
            public static final String SECTION_KEY_END_OF_OPTIONS = "endOfOptionsList";
            public static final String SECTION_KEY_COMMAND_LIST_HEADING = "commandListHeading";
            public static final String SECTION_KEY_COMMAND_LIST = "commandList";
            public static final String SECTION_KEY_EXIT_CODE_LIST_HEADING = "exitCodeListHeading";
            public static final String SECTION_KEY_EXIT_CODE_LIST = "exitCodeList";
            public static final String SECTION_KEY_FOOTER_HEADING = "footerHeading";
            public static final String SECTION_KEY_FOOTER = "footer";
            public static final int DEFAULT_USAGE_WIDTH = 80;
            private static final int MINIMUM_USAGE_WIDTH = 55;
            static final int DEFAULT_USAGE_LONG_OPTIONS_WIDTH = 20;
            private static final int DEFAULT_SYNOPSIS_INDENT = -1;
            private static final double DEFAULT_SYNOPSIS_AUTO_INDENT_THRESHOLD = 0.5;
            private static final double MAX_SYNOPSIS_AUTO_INDENT_THRESHOLD = 0.9;
            static final Boolean DEFAULT_USAGE_AUTO_WIDTH = Boolean.FALSE;
            static final String DEFAULT_SYNOPSIS_HEADING = "Usage: ";
            static final String DEFAULT_SYNOPSIS_SUBCOMMANDS = "[COMMAND]";
            static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:%n";
            static final char DEFAULT_REQUIRED_OPTION_MARKER = ' ';
            static final Boolean DEFAULT_ABBREVIATE_SYNOPSIS = Boolean.FALSE;
            static final Boolean DEFAULT_SORT_OPTIONS = Boolean.TRUE;
            static final Boolean DEFAULT_SORT_SYNOPSIS = Boolean.TRUE;
            static final Boolean DEFAULT_SHOW_AT_FILE = Boolean.FALSE;
            static final Boolean DEFAULT_SHOW_END_OF_OPTIONS = Boolean.FALSE;
            static final Boolean DEFAULT_SHOW_DEFAULT_VALUES = Boolean.FALSE;
            static final Boolean DEFAULT_HIDDEN = Boolean.FALSE;
            static final Boolean DEFAULT_ADJUST_CJK = Boolean.TRUE;
            static final String DEFAULT_SINGLE_VALUE = "";
            static final String[] DEFAULT_MULTI_LINE = new String[0];
            private IHelpFactory helpFactory;
            private List<String> sectionKeys = Collections.unmodifiableList(Arrays.asList("headerHeading", "header", "synopsisHeading", "synopsis", "descriptionHeading", "description", "parameterListHeading", "atFileParameterList", "parameterList", "optionListHeading", "optionList", "endOfOptionsList", "commandListHeading", "commandList", "exitCodeListHeading", "exitCodeList", "footerHeading", "footer"));
            private Map<String, IHelpSectionRenderer> helpSectionRendererMap = this.createHelpSectionRendererMap();
            private String[] description;
            private String[] customSynopsis;
            private String[] header;
            private String[] footer;
            private Boolean abbreviateSynopsis;
            private Boolean sortOptions;
            private Boolean sortSynopsis;
            private Boolean showDefaultValues;
            private Boolean showAtFileInUsageHelp;
            private Boolean showEndOfOptionsDelimiterInUsageHelp;
            private Boolean hidden;
            private Boolean autoWidth;
            private Character requiredOptionMarker;
            private String headerHeading;
            private String synopsisHeading;
            private String synopsisSubcommandLabel;
            private Double synopsisAutoIndentThreshold;
            private Integer synopsisIndent;
            private String descriptionHeading;
            private String parameterListHeading;
            private String optionListHeading;
            private String commandListHeading;
            private String footerHeading;
            private String exitCodeListHeading;
            private String[] exitCodeListStrings;
            private Map<String, String> exitCodeList;
            private Integer width;
            private Integer longOptionsMaxWidth;
            private Integer cachedTerminalWidth;
            private final Interpolator interpolator;
            private Messages messages;
            private Boolean adjustLineBreaksForWideCJKCharacters;

            public UsageMessageSpec() {
                this(null);
            }

            UsageMessageSpec(Interpolator interpolator) {
                this.interpolator = interpolator;
            }

            public UsageMessageSpec width(int n2) {
                if (n2 < 55) {
                    throw new InitializationException("Invalid usage message width " + n2 + ". Minimum value is " + 55);
                }
                this.width = n2;
                return this;
            }

            public UsageMessageSpec longOptionsMaxWidth(int n2) {
                if (n2 < 20) {
                    CommandLine.tracer().info("Invalid usage long options max width %d. Minimum value is %d", n2, 20);
                } else if (n2 > this.width() - 20) {
                    CommandLine.tracer().info("Invalid usage long options max width %d. Value must not exceed width(%d) - %d", n2, this.width(), 20);
                } else {
                    this.longOptionsMaxWidth = n2;
                }
                return this;
            }

            private int getSysPropertyWidthOrDefault(int n2, boolean bl2) {
                if (bl2) {
                    if (this.cachedTerminalWidth == null) {
                        this.cachedTerminalWidth = UsageMessageSpec.getTerminalWidth();
                    }
                    return this.cachedTerminalWidth < 0 ? n2 : Math.max(this.cachedTerminalWidth, 55);
                }
                String string = System.getProperty("picocli.usage.width");
                if (string == null) {
                    return n2;
                }
                try {
                    int n3 = Integer.parseInt(string);
                    if (n3 < 55) {
                        CommandLine.tracer().warn("Invalid picocli.usage.width value %d. Using minimum usage width %d.", n3, 55);
                        return 55;
                    }
                    return n3;
                }
                catch (NumberFormatException numberFormatException) {
                    CommandLine.tracer().warn("Invalid picocli.usage.width value '%s'. Using usage width %d.", string, n2);
                    return n2;
                }
            }

            private static boolean shouldDetectTerminalSize(boolean bl2) {
                String string = System.getProperty("picocli.usage.width");
                boolean bl3 = Arrays.asList("AUTO", "TERM", "TERMINAL").contains(String.valueOf(string).toUpperCase(Locale.ENGLISH));
                return bl3 || bl2 && !UsageMessageSpec.isNumeric(string);
            }

            private static boolean isNumeric(String string) {
                try {
                    Integer.parseInt(string);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }

            private static int getTerminalWidth() {
                return Help.Ansi.isTTY() || Help.Ansi.isPseudoTTY() ? UsageMessageSpec.detectTerminalWidth() : -1;
            }

            private static int detectTerminalWidth() {
                String[] stringArray;
                long l2 = System.nanoTime();
                final Tracer tracer = CommandLine.tracer();
                final AtomicInteger atomicInteger = new AtomicInteger(-1);
                if (Help.Ansi.isWindows() && !Help.Ansi.isPseudoTTY()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "cmd.exe";
                    stringArray2[1] = "/c";
                    stringArray = stringArray2;
                    stringArray2[2] = "mode con";
                } else if (Help.Ansi.isMac()) {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "tput";
                    stringArray = stringArray3;
                    stringArray3[1] = "cols";
                } else {
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = "stty";
                    stringArray4[1] = "-a";
                    stringArray4[2] = "-F";
                    stringArray = stringArray4;
                    stringArray4[3] = "/dev/tty";
                }
                final String[] stringArray5 = stringArray;
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block9: {
                            BufferedReader bufferedReader;
                            block8: {
                                Process process = null;
                                bufferedReader = null;
                                try {
                                    String string;
                                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray5);
                                    tracer.debug("getTerminalWidth() executing command %s", processBuilder.command());
                                    Class<?> clazz = Class.forName("java.lang.ProcessBuilder$Redirect");
                                    Object object = clazz.getField("INHERIT").get(null);
                                    Method method = ProcessBuilder.class.getDeclaredMethod("redirectError", clazz);
                                    method.invoke((Object)processBuilder, object);
                                    process = processBuilder.start();
                                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                    String string2 = UsageMessageSpec.DEFAULT_SINGLE_VALUE;
                                    while ((string = bufferedReader.readLine()) != null) {
                                        string2 = string2 + " " + string;
                                    }
                                    tracer.debug("getTerminalWidth() parsing output: %s", string2);
                                    Pattern pattern = Help.Ansi.isWindows() && !Help.Ansi.isPseudoTTY() ? Pattern.compile(".*?:\\s*(\\d+)\\D.*?:\\s*(\\d+)\\D.*", 32) : (Help.Ansi.isMac() ? Pattern.compile("(\\s*)(\\d+)\\s*") : Pattern.compile(".*olumns(:)?\\s+(\\d+)\\D.*", 32));
                                    Matcher matcher = pattern.matcher(string2);
                                    if (matcher.matches()) {
                                        atomicInteger.set(Integer.parseInt(matcher.group(2)));
                                    }
                                    if (process == null) break block8;
                                    process.destroy();
                                }
                                catch (Exception exception) {
                                    tracer.debug("getTerminalWidth() ERROR: %s", exception);
                                    break block9;
                                }
                                finally {
                                    if (process != null) {
                                        process.destroy();
                                    }
                                    CommandLine.close(bufferedReader);
                                }
                            }
                            CommandLine.close(bufferedReader);
                        }
                    }
                });
                thread.start();
                long l3 = System.currentTimeMillis();
                while (atomicInteger.intValue() < 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() < l3 + 2000L && thread.isAlive()) continue;
                }
                double d2 = (double)(System.nanoTime() - l2) / 1000000.0;
                tracer.debug("getTerminalWidth() returning: %s in %,.1fms", atomicInteger, d2);
                return atomicInteger.intValue();
            }

            public int width() {
                return this.getSysPropertyWidthOrDefault(this.width == null ? 80 : this.width, this.autoWidth());
            }

            public int longOptionsMaxWidth() {
                return this.longOptionsMaxWidth == null ? 20 : this.longOptionsMaxWidth;
            }

            public boolean autoWidth() {
                return UsageMessageSpec.shouldDetectTerminalSize(this.autoWidth == null ? DEFAULT_USAGE_AUTO_WIDTH : this.autoWidth);
            }

            public UsageMessageSpec autoWidth(boolean bl2) {
                this.autoWidth = bl2;
                return this;
            }

            static boolean isCodePointCJK(int n2) {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n2);
                return n2 == 177 || unicodeBlock == Character.UnicodeBlock.HIRAGANA || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS && n2 < 65377;
            }

            private Map<String, IHelpSectionRenderer> createHelpSectionRendererMap() {
                HashMap<String, IHelpSectionRenderer> hashMap = new HashMap<String, IHelpSectionRenderer>();
                hashMap.put(SECTION_KEY_HEADER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.headerHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_HEADER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.header(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_SYNOPSIS_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.synopsisHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_SYNOPSIS, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.synopsis(help.synopsisHeadingLength());
                    }
                });
                hashMap.put(SECTION_KEY_DESCRIPTION_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.descriptionHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_DESCRIPTION, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.description(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_PARAMETER_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_AT_FILE_PARAMETER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.atFileParameterList();
                    }
                });
                hashMap.put(SECTION_KEY_PARAMETER_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.parameterList();
                    }
                });
                hashMap.put(SECTION_KEY_OPTION_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_OPTION_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.optionList();
                    }
                });
                hashMap.put(SECTION_KEY_END_OF_OPTIONS, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.endOfOptionsList();
                    }
                });
                hashMap.put(SECTION_KEY_COMMAND_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_COMMAND_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.commandList();
                    }
                });
                hashMap.put(SECTION_KEY_EXIT_CODE_LIST_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.exitCodeListHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_EXIT_CODE_LIST, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.exitCodeList();
                    }
                });
                hashMap.put(SECTION_KEY_FOOTER_HEADING, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footerHeading(new Object[0]);
                    }
                });
                hashMap.put(SECTION_KEY_FOOTER, new IHelpSectionRenderer(){

                    public String render(Help help) {
                        return help.footer(new Object[0]);
                    }
                });
                return hashMap;
            }

            public List<String> sectionKeys() {
                return this.sectionKeys;
            }

            public UsageMessageSpec sectionKeys(List<String> list) {
                this.sectionKeys = Collections.unmodifiableList(new ArrayList<String>(list));
                return this;
            }

            public Map<String, IHelpSectionRenderer> sectionMap() {
                return this.helpSectionRendererMap;
            }

            public UsageMessageSpec sectionMap(Map<String, IHelpSectionRenderer> map) {
                this.helpSectionRendererMap = new LinkedHashMap<String, IHelpSectionRenderer>(map);
                return this;
            }

            public IHelpFactory helpFactory() {
                if (this.helpFactory == null) {
                    this.helpFactory = new DefaultHelpFactory();
                }
                return this.helpFactory;
            }

            public UsageMessageSpec helpFactory(IHelpFactory iHelpFactory) {
                this.helpFactory = Assert.notNull(iHelpFactory, "helpFactory");
                return this;
            }

            private String interpolate(String string) {
                return this.interpolator == null ? string : this.interpolator.interpolate(string);
            }

            private String[] interpolate(String[] stringArray) {
                return this.interpolator == null ? stringArray : this.interpolator.interpolate(stringArray);
            }

            private String str(String string, String string2, String string3) {
                return this.interpolate(string != null ? string : (string2 != null ? string2 : string3));
            }

            private String[] arr(String[] stringArray, String[] stringArray2, String[] stringArray3) {
                return this.interpolate(stringArray != null ? stringArray : (stringArray2 != null ? (String[])stringArray2.clone() : stringArray3));
            }

            private String resourceStr(String string) {
                return this.messages == null ? null : this.messages.getString(string, null);
            }

            private String[] resourceArr(String string) {
                return this.messages == null ? null : this.messages.getStringArray(string, null);
            }

            public String headerHeading() {
                return this.str(this.resourceStr("usage.headerHeading"), this.headerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] header() {
                return this.arr(this.resourceArr("usage.header"), this.header, DEFAULT_MULTI_LINE);
            }

            public String synopsisHeading() {
                return this.str(this.resourceStr("usage.synopsisHeading"), this.synopsisHeading, DEFAULT_SYNOPSIS_HEADING);
            }

            public String synopsisSubcommandLabel() {
                return this.str(this.resourceStr("usage.synopsisSubcommandLabel"), this.synopsisSubcommandLabel, DEFAULT_SYNOPSIS_SUBCOMMANDS);
            }

            public double synopsisAutoIndentThreshold() {
                return this.synopsisAutoIndentThreshold == null ? 0.5 : this.synopsisAutoIndentThreshold;
            }

            public int synopsisIndent() {
                return this.synopsisIndent == null ? -1 : this.synopsisIndent;
            }

            public boolean abbreviateSynopsis() {
                return this.abbreviateSynopsis == null ? DEFAULT_ABBREVIATE_SYNOPSIS : this.abbreviateSynopsis;
            }

            public String[] customSynopsis() {
                return this.arr(this.resourceArr("usage.customSynopsis"), this.customSynopsis, DEFAULT_MULTI_LINE);
            }

            public String descriptionHeading() {
                return this.str(this.resourceStr("usage.descriptionHeading"), this.descriptionHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] description() {
                return this.arr(this.resourceArr("usage.description"), this.description, DEFAULT_MULTI_LINE);
            }

            public String parameterListHeading() {
                return this.str(this.resourceStr("usage.parameterListHeading"), this.parameterListHeading, DEFAULT_SINGLE_VALUE);
            }

            public String optionListHeading() {
                return this.str(this.resourceStr("usage.optionListHeading"), this.optionListHeading, DEFAULT_SINGLE_VALUE);
            }

            public boolean sortOptions() {
                return this.sortOptions == null ? DEFAULT_SORT_OPTIONS : this.sortOptions;
            }

            public boolean sortSynopsis() {
                return this.sortSynopsis == null ? DEFAULT_SORT_SYNOPSIS : this.sortSynopsis;
            }

            public char requiredOptionMarker() {
                return this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue();
            }

            public boolean showDefaultValues() {
                return this.showDefaultValues == null ? DEFAULT_SHOW_DEFAULT_VALUES : this.showDefaultValues;
            }

            public boolean showAtFileInUsageHelp() {
                return this.showAtFileInUsageHelp == null ? DEFAULT_SHOW_AT_FILE : this.showAtFileInUsageHelp;
            }

            public boolean showEndOfOptionsDelimiterInUsageHelp() {
                return this.showEndOfOptionsDelimiterInUsageHelp == null ? DEFAULT_SHOW_END_OF_OPTIONS : this.showEndOfOptionsDelimiterInUsageHelp;
            }

            public boolean hidden() {
                return this.hidden == null ? DEFAULT_HIDDEN : this.hidden;
            }

            public String commandListHeading() {
                return this.str(this.resourceStr("usage.commandListHeading"), this.commandListHeading, DEFAULT_COMMAND_LIST_HEADING);
            }

            public String exitCodeListHeading() {
                return this.str(this.resourceStr("usage.exitCodeListHeading"), this.exitCodeListHeading, DEFAULT_SINGLE_VALUE);
            }

            public Map<String, String> exitCodeList() {
                String[] stringArray = this.resourceArr("usage.exitCodeList");
                if (stringArray == null && this.exitCodeList != null) {
                    return this.exitCodeList;
                }
                Map<String, String> map = UsageMessageSpec.keyValuesMap(this.arr(stringArray, this.exitCodeListStrings, DEFAULT_MULTI_LINE));
                return Collections.unmodifiableMap(map);
            }

            public static Map<String, String> keyValuesMap(String ... stringArray) {
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                if (stringArray == null) {
                    return linkedHashMap;
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    int n2 = stringArray[i2].indexOf(58);
                    if (n2 >= 0) {
                        linkedHashMap.put(stringArray[i2].substring(0, n2), stringArray[i2].substring(n2 + 1));
                        continue;
                    }
                    CommandLine.tracer().info("Ignoring line at index %d: cannot split '%s' into 'key:value'", i2, stringArray[i2]);
                }
                return linkedHashMap;
            }

            public String footerHeading() {
                return this.str(this.resourceStr("usage.footerHeading"), this.footerHeading, DEFAULT_SINGLE_VALUE);
            }

            public String[] footer() {
                return this.arr(this.resourceArr("usage.footer"), this.footer, DEFAULT_MULTI_LINE);
            }

            public UsageMessageSpec headerHeading(String string) {
                this.headerHeading = string;
                return this;
            }

            public UsageMessageSpec header(String ... stringArray) {
                this.header = stringArray;
                return this;
            }

            public UsageMessageSpec synopsisHeading(String string) {
                this.synopsisHeading = string;
                return this;
            }

            public UsageMessageSpec synopsisSubcommandLabel(String string) {
                this.synopsisSubcommandLabel = string;
                return this;
            }

            public UsageMessageSpec synopsisAutoIndentThreshold(double d2) {
                if (d2 < 0.0 || d2 > 0.9) {
                    throw new IllegalArgumentException("synopsisAutoIndentThreshold must be between 0.0 and 0.9 (inclusive), but was " + d2);
                }
                this.synopsisAutoIndentThreshold = d2;
                return this;
            }

            public UsageMessageSpec synopsisIndent(int n2) {
                this.synopsisIndent = n2;
                return this;
            }

            public UsageMessageSpec abbreviateSynopsis(boolean bl2) {
                this.abbreviateSynopsis = bl2;
                return this;
            }

            public UsageMessageSpec customSynopsis(String ... stringArray) {
                this.customSynopsis = stringArray;
                return this;
            }

            public UsageMessageSpec descriptionHeading(String string) {
                this.descriptionHeading = string;
                return this;
            }

            public UsageMessageSpec description(String ... stringArray) {
                this.description = stringArray;
                return this;
            }

            public UsageMessageSpec parameterListHeading(String string) {
                this.parameterListHeading = string;
                return this;
            }

            public UsageMessageSpec optionListHeading(String string) {
                this.optionListHeading = string;
                return this;
            }

            public UsageMessageSpec sortOptions(boolean bl2) {
                this.sortOptions = bl2;
                return this;
            }

            public UsageMessageSpec sortSynopsis(boolean bl2) {
                this.sortSynopsis = bl2;
                return this;
            }

            public UsageMessageSpec requiredOptionMarker(char c2) {
                this.requiredOptionMarker = Character.valueOf(c2);
                return this;
            }

            public UsageMessageSpec showDefaultValues(boolean bl2) {
                this.showDefaultValues = bl2;
                return this;
            }

            public UsageMessageSpec showAtFileInUsageHelp(boolean bl2) {
                this.showAtFileInUsageHelp = bl2;
                return this;
            }

            public UsageMessageSpec showEndOfOptionsDelimiterInUsageHelp(boolean bl2) {
                this.showEndOfOptionsDelimiterInUsageHelp = bl2;
                return this;
            }

            public UsageMessageSpec hidden(boolean bl2) {
                this.hidden = bl2;
                return this;
            }

            public UsageMessageSpec commandListHeading(String string) {
                this.commandListHeading = string;
                return this;
            }

            public UsageMessageSpec exitCodeListHeading(String string) {
                this.exitCodeListHeading = string;
                return this;
            }

            public UsageMessageSpec exitCodeList(Map<String, String> map) {
                this.exitCodeList = map == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(map));
                return this;
            }

            public UsageMessageSpec footerHeading(String string) {
                this.footerHeading = string;
                return this;
            }

            public UsageMessageSpec footer(String ... stringArray) {
                this.footer = stringArray;
                return this;
            }

            public Messages messages() {
                return this.messages;
            }

            public UsageMessageSpec messages(Messages messages) {
                this.messages = messages;
                return this;
            }

            public boolean adjustLineBreaksForWideCJKCharacters() {
                return this.adjustLineBreaksForWideCJKCharacters == null ? DEFAULT_ADJUST_CJK : this.adjustLineBreaksForWideCJKCharacters;
            }

            public UsageMessageSpec adjustLineBreaksForWideCJKCharacters(boolean bl2) {
                this.adjustLineBreaksForWideCJKCharacters = bl2;
                return this;
            }

            void updateFromCommand(Command command, CommandSpec commandSpec, boolean bl2) {
                if (!CommandLine.empty(command.resourceBundle())) {
                    if (bl2) {
                        this.messages(new Messages(commandSpec, command.resourceBundle()));
                    } else {
                        ResourceBundle resourceBundle = null;
                        try {
                            resourceBundle = ResourceBundle.getBundle(command.resourceBundle());
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                        this.messages(new Messages(commandSpec, command.resourceBundle(), resourceBundle));
                    }
                }
                if (Model.isNonDefault(command.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = command.abbreviateSynopsis();
                }
                if (Model.isNonDefault(command.usageHelpAutoWidth(), UsageMessageSpec.DEFAULT_USAGE_AUTO_WIDTH)) {
                    this.autoWidth = command.usageHelpAutoWidth();
                }
                if (Model.isNonDefault(command.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = command.commandListHeading();
                }
                if (Model.isNonDefault(command.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])command.customSynopsis().clone();
                }
                if (Model.isNonDefault(command.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])command.description().clone();
                }
                if (Model.isNonDefault(command.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = command.descriptionHeading();
                }
                if (Model.isNonDefault(command.exitCodeList(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.exitCodeListStrings = (String[])command.exitCodeList().clone();
                }
                if (Model.isNonDefault(command.exitCodeListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.exitCodeListHeading = command.exitCodeListHeading();
                }
                if (Model.isNonDefault(command.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])command.footer().clone();
                }
                if (Model.isNonDefault(command.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = command.footerHeading();
                }
                if (Model.isNonDefault(command.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])command.header().clone();
                }
                if (Model.isNonDefault(command.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = command.headerHeading();
                }
                if (Model.isNonDefault(command.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = command.hidden();
                }
                if (Model.isNonDefault(command.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = command.optionListHeading();
                }
                if (Model.isNonDefault(command.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = command.parameterListHeading();
                }
                if (Model.isNonDefault(Character.valueOf(command.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(command.requiredOptionMarker());
                }
                if (Model.isNonDefault(command.showAtFileInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_AT_FILE)) {
                    this.showAtFileInUsageHelp = command.showAtFileInUsageHelp();
                }
                if (Model.isNonDefault(command.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = command.showDefaultValues();
                }
                if (Model.isNonDefault(command.showEndOfOptionsDelimiterInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_END_OF_OPTIONS)) {
                    this.showEndOfOptionsDelimiterInUsageHelp = command.showEndOfOptionsDelimiterInUsageHelp();
                }
                if (Model.isNonDefault(command.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = command.sortOptions();
                }
                if (Model.isNonDefault(command.sortSynopsis(), UsageMessageSpec.DEFAULT_SORT_SYNOPSIS)) {
                    this.sortSynopsis = command.sortSynopsis();
                }
                if (Model.isNonDefault(command.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = command.synopsisHeading();
                }
                if (Model.isNonDefault(command.synopsisSubcommandLabel(), DEFAULT_SYNOPSIS_SUBCOMMANDS)) {
                    this.synopsisSubcommandLabel = command.synopsisSubcommandLabel();
                }
                if (Model.isNonDefault(command.usageHelpWidth(), 80)) {
                    this.width(command.usageHelpWidth());
                }
            }

            void initFromMixin(UsageMessageSpec usageMessageSpec, CommandSpec commandSpec) {
                if (Model.initializable(this.abbreviateSynopsis, usageMessageSpec.abbreviateSynopsis(), UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = usageMessageSpec.abbreviateSynopsis();
                }
                if (Model.initializable(this.adjustLineBreaksForWideCJKCharacters, usageMessageSpec.adjustLineBreaksForWideCJKCharacters(), UsageMessageSpec.DEFAULT_ADJUST_CJK)) {
                    this.adjustLineBreaksForWideCJKCharacters = usageMessageSpec.adjustLineBreaksForWideCJKCharacters();
                }
                if (Model.initializable(this.autoWidth, usageMessageSpec.autoWidth(), UsageMessageSpec.DEFAULT_USAGE_AUTO_WIDTH)) {
                    this.autoWidth = usageMessageSpec.autoWidth();
                }
                if (Model.initializable(this.commandListHeading, usageMessageSpec.commandListHeading(), DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = usageMessageSpec.commandListHeading();
                }
                if (Model.initializable(this.customSynopsis, usageMessageSpec.customSynopsis(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])usageMessageSpec.customSynopsis().clone();
                }
                if (Model.initializable(this.description, usageMessageSpec.description(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])usageMessageSpec.description().clone();
                }
                if (Model.initializable(this.descriptionHeading, usageMessageSpec.descriptionHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = usageMessageSpec.descriptionHeading();
                }
                if (Model.initializable(this.exitCodeList, usageMessageSpec.exitCodeList(), Collections.emptyMap()) && this.exitCodeListStrings == null) {
                    this.exitCodeList = Collections.unmodifiableMap(new LinkedHashMap<String, String>(usageMessageSpec.exitCodeList()));
                }
                if (Model.initializable(this.exitCodeListHeading, usageMessageSpec.exitCodeListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.exitCodeListHeading = usageMessageSpec.exitCodeListHeading();
                }
                if (Model.initializable(this.footer, usageMessageSpec.footer(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])usageMessageSpec.footer().clone();
                }
                if (Model.initializable(this.footerHeading, usageMessageSpec.footerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = usageMessageSpec.footerHeading();
                }
                if (Model.initializable(this.header, usageMessageSpec.header(), UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])usageMessageSpec.header().clone();
                }
                if (Model.initializable(this.headerHeading, usageMessageSpec.headerHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = usageMessageSpec.headerHeading();
                }
                if (Model.initializable(this.hidden, usageMessageSpec.hidden(), UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = usageMessageSpec.hidden();
                }
                if (Model.initializable(this.longOptionsMaxWidth, usageMessageSpec.longOptionsMaxWidth(), 20)) {
                    this.longOptionsMaxWidth = usageMessageSpec.longOptionsMaxWidth();
                }
                if (Messages.empty(this.messages) && Messages.resourceBundleBaseName(this.messages) == null) {
                    this.messages(Messages.copy(commandSpec, usageMessageSpec.messages()));
                }
                if (Model.initializable(this.optionListHeading, usageMessageSpec.optionListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = usageMessageSpec.optionListHeading();
                }
                if (Model.initializable(this.parameterListHeading, usageMessageSpec.parameterListHeading(), DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = usageMessageSpec.parameterListHeading();
                }
                if (Model.initializable(this.requiredOptionMarker, Character.valueOf(usageMessageSpec.requiredOptionMarker()), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(usageMessageSpec.requiredOptionMarker());
                }
                if (Model.initializable(this.showAtFileInUsageHelp, usageMessageSpec.showAtFileInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_AT_FILE)) {
                    this.showAtFileInUsageHelp = usageMessageSpec.showAtFileInUsageHelp();
                }
                if (Model.initializable(this.showDefaultValues, usageMessageSpec.showDefaultValues(), UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = usageMessageSpec.showDefaultValues();
                }
                if (Model.initializable(this.showEndOfOptionsDelimiterInUsageHelp, usageMessageSpec.showEndOfOptionsDelimiterInUsageHelp(), UsageMessageSpec.DEFAULT_SHOW_END_OF_OPTIONS)) {
                    this.showEndOfOptionsDelimiterInUsageHelp = usageMessageSpec.showEndOfOptionsDelimiterInUsageHelp();
                }
                if (Model.initializable(this.sortOptions, usageMessageSpec.sortOptions(), UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = usageMessageSpec.sortOptions();
                }
                if (Model.initializable(this.sortSynopsis, usageMessageSpec.sortSynopsis(), UsageMessageSpec.DEFAULT_SORT_SYNOPSIS)) {
                    this.sortSynopsis = usageMessageSpec.sortSynopsis();
                }
                if (Model.initializable(this.synopsisHeading, usageMessageSpec.synopsisHeading(), DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = usageMessageSpec.synopsisHeading();
                }
                if (Model.initializable(this.synopsisSubcommandLabel, usageMessageSpec.synopsisSubcommandLabel(), DEFAULT_SYNOPSIS_SUBCOMMANDS)) {
                    this.synopsisSubcommandLabel = usageMessageSpec.synopsisSubcommandLabel();
                }
                if (Model.initializable(this.width, usageMessageSpec.width(), 80)) {
                    this.width = usageMessageSpec.width();
                }
            }

            void initFrom(UsageMessageSpec usageMessageSpec, CommandSpec commandSpec) {
                this.abbreviateSynopsis = usageMessageSpec.abbreviateSynopsis;
                this.adjustLineBreaksForWideCJKCharacters = usageMessageSpec.adjustLineBreaksForWideCJKCharacters;
                this.autoWidth = usageMessageSpec.autoWidth;
                this.commandListHeading = usageMessageSpec.commandListHeading;
                this.customSynopsis = usageMessageSpec.customSynopsis;
                this.description = usageMessageSpec.description;
                this.descriptionHeading = usageMessageSpec.descriptionHeading;
                this.exitCodeList = usageMessageSpec.exitCodeList;
                this.exitCodeListHeading = usageMessageSpec.exitCodeListHeading;
                this.exitCodeListStrings = usageMessageSpec.exitCodeListStrings;
                this.footer = usageMessageSpec.footer;
                this.footerHeading = usageMessageSpec.footerHeading;
                this.header = usageMessageSpec.header;
                this.headerHeading = usageMessageSpec.headerHeading;
                this.helpFactory = usageMessageSpec.helpFactory;
                this.helpSectionRendererMap = usageMessageSpec.helpSectionRendererMap;
                this.hidden = usageMessageSpec.hidden;
                this.longOptionsMaxWidth = usageMessageSpec.longOptionsMaxWidth;
                this.messages = Messages.copy(commandSpec, usageMessageSpec.messages());
                this.optionListHeading = usageMessageSpec.optionListHeading;
                this.parameterListHeading = usageMessageSpec.parameterListHeading;
                this.requiredOptionMarker = usageMessageSpec.requiredOptionMarker;
                this.sectionKeys = usageMessageSpec.sectionKeys;
                this.showAtFileInUsageHelp = usageMessageSpec.showAtFileInUsageHelp;
                this.showDefaultValues = usageMessageSpec.showDefaultValues;
                this.showEndOfOptionsDelimiterInUsageHelp = usageMessageSpec.showEndOfOptionsDelimiterInUsageHelp;
                this.sortOptions = usageMessageSpec.sortOptions;
                this.sortSynopsis = usageMessageSpec.sortSynopsis;
                this.synopsisAutoIndentThreshold = usageMessageSpec.synopsisAutoIndentThreshold;
                this.synopsisHeading = usageMessageSpec.synopsisHeading;
                this.synopsisIndent = usageMessageSpec.synopsisIndent;
                this.synopsisSubcommandLabel = usageMessageSpec.synopsisSubcommandLabel;
                this.width = usageMessageSpec.width;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CommandSpec {
            public static final String DEFAULT_COMMAND_NAME = "<main class>";
            static final Boolean DEFAULT_IS_HELP_COMMAND = false;
            static final Boolean DEFAULT_IS_ADD_METHOD_SUBCOMMANDS = true;
            static final Boolean DEFAULT_INTERPOLATE_VARIABLES = true;
            static final Boolean DEFAULT_SUBCOMMANDS_REPEATABLE = false;
            private final CaseAwareLinkedMap<String, CommandLine> commands = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<String, OptionSpec> optionsByNameMap = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<String, OptionSpec> negatedOptionsByNameMap = new CaseAwareLinkedMap();
            private final CaseAwareLinkedMap<Character, OptionSpec> posixOptionsByKeyMap = new CaseAwareLinkedMap();
            private final Map<String, CommandSpec> mixins = new LinkedHashMap<String, CommandSpec>();
            private final Map<String, IAnnotatedElement> mixinAnnotatedElements = new LinkedHashMap<String, IAnnotatedElement>();
            private final List<ArgSpec> requiredArgs = new ArrayList<ArgSpec>();
            private final List<ArgSpec> args = new ArrayList<ArgSpec>();
            private final List<OptionSpec> options = new ArrayList<OptionSpec>();
            private final List<PositionalParamSpec> positionalParameters = new ArrayList<PositionalParamSpec>();
            private final List<UnmatchedArgsBinding> unmatchedArgs = new ArrayList<UnmatchedArgsBinding>();
            private final List<IAnnotatedElement> specElements = new ArrayList<IAnnotatedElement>();
            private final List<IAnnotatedElement> parentCommandElements = new ArrayList<IAnnotatedElement>();
            private final List<ArgGroupSpec> groups = new ArrayList<ArgGroupSpec>();
            private final ParserSpec parser = new ParserSpec();
            private final Interpolator interpolator = new Interpolator(this);
            private final UsageMessageSpec usageMessage = new UsageMessageSpec(this.interpolator);
            private TypedMember[] methodParams;
            private final CommandUserObject userObject;
            private CommandLine commandLine;
            private CommandSpec parent;
            private Boolean isAddMethodSubcommands;
            private Boolean interpolateVariables;
            private String name;
            private Set<String> aliases = new LinkedHashSet<String>();
            private Boolean isHelpCommand;
            private IVersionProvider versionProvider;
            private IDefaultValueProvider defaultValueProvider;
            private INegatableOptionTransformer negatableOptionTransformer = RegexTransformer.createDefault();
            private Boolean subcommandsRepeatable;
            private String[] version;
            private String toString;
            private boolean inherited = false;
            private ScopeType scopeType = null;
            private Integer exitCodeOnSuccess;
            private Integer exitCodeOnUsageHelp;
            private Integer exitCodeOnVersionHelp;
            private Integer exitCodeOnInvalidInput;
            private Integer exitCodeOnExecutionException;
            private IModelTransformer modelTransformer = null;
            private IParameterPreprocessor preprocessor = new NoOpParameterPreprocessor();

            private CommandSpec(CommandUserObject commandUserObject) {
                this.userObject = commandUserObject;
                this.userObject.commandSpec = this;
            }

            private CommandSpec copy() {
                Object object = this.userObject.type == null ? this.userObject.instance : this.userObject.type;
                CommandSpec commandSpec = object == null ? CommandSpec.create() : CommandSpec.forAnnotatedObject(object, this.userObject.factory);
                commandSpec.commandLine = this.commandLine;
                commandSpec.parent = this.parent;
                commandSpec.methodParams = this.methodParams;
                commandSpec.isAddMethodSubcommands = this.isAddMethodSubcommands;
                commandSpec.interpolateVariables = this.interpolateVariables;
                commandSpec.name = this.name;
                commandSpec.aliases = this.aliases;
                commandSpec.isHelpCommand = this.isHelpCommand;
                commandSpec.versionProvider = this.versionProvider;
                commandSpec.modelTransformer = this.modelTransformer;
                commandSpec.defaultValueProvider = this.defaultValueProvider;
                commandSpec.negatableOptionTransformer = this.negatableOptionTransformer;
                commandSpec.subcommandsRepeatable = this.subcommandsRepeatable;
                commandSpec.version = this.version;
                commandSpec.toString = this.toString;
                commandSpec.exitCodeOnSuccess = this.exitCodeOnSuccess;
                commandSpec.exitCodeOnUsageHelp = this.exitCodeOnUsageHelp;
                commandSpec.exitCodeOnVersionHelp = this.exitCodeOnVersionHelp;
                commandSpec.exitCodeOnInvalidInput = this.exitCodeOnInvalidInput;
                commandSpec.exitCodeOnExecutionException = this.exitCodeOnExecutionException;
                commandSpec.usageMessage.initFrom(this.usageMessage, this);
                commandSpec.parser(this.parser);
                commandSpec.inherited = this.inherited;
                commandSpec.scopeType = this.scopeType;
                return commandSpec;
            }

            public static CommandSpec create() {
                return CommandSpec.wrapWithoutInspection(null);
            }

            public static CommandSpec wrapWithoutInspection(Object object) {
                return new CommandSpec(CommandUserObject.create(object, CommandLine.defaultFactory()));
            }

            public static CommandSpec wrapWithoutInspection(Object object, IFactory iFactory) {
                return new CommandSpec(CommandUserObject.create(object, iFactory));
            }

            public static CommandSpec forAnnotatedObject(Object object) {
                return CommandSpec.forAnnotatedObject(object, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObject(Object object, IFactory iFactory) {
                return CommandReflection.extractCommandSpec(object, iFactory, true);
            }

            public static CommandSpec forAnnotatedObjectLenient(Object object) {
                return CommandSpec.forAnnotatedObjectLenient(object, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObjectLenient(Object object, IFactory iFactory) {
                return CommandReflection.extractCommandSpec(object, iFactory, false);
            }

            void validate() {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                CommandLine.validatePositionalParameters(this.positionalParameters);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (OptionSpec object2 : this.options()) {
                    if (object2.usageHelp()) {
                        arrayList3.add(object2.longestName());
                        if (!CommandLine.isBoolean(object2.type())) {
                            arrayList.add(object2.longestName());
                        }
                    }
                    if (!object2.versionHelp()) continue;
                    arrayList4.add(object2.longestName());
                    if (CommandLine.isBoolean(object2.type())) continue;
                    arrayList2.add(object2.longestName());
                }
                String string = "Non-boolean options like %s should not be marked as '%s=true'. Usually a command has one %s boolean flag that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.";
                String string2 = "Multiple options %s are marked as '%s=true'. Usually a command has only one %s option that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.";
                if (!arrayList.isEmpty()) {
                    throw new InitializationException(String.format(string, arrayList, "usageHelp", "--help", "usage help message"));
                }
                if (!arrayList2.isEmpty()) {
                    throw new InitializationException(String.format(string, arrayList2, "versionHelp", "--version", "version information"));
                }
                if (arrayList3.size() > 1) {
                    CommandLine.tracer().warn(string2, arrayList3, "usageHelp", "--help", "usage help message");
                }
                if (arrayList4.size() > 1) {
                    CommandLine.tracer().warn(string2, arrayList4, "versionHelp", "--version", "version information");
                }
            }

            public Object userObject() {
                return this.userObject.getInstance();
            }

            public CommandLine commandLine() {
                return this.commandLine;
            }

            protected CommandSpec commandLine(CommandLine commandLine) {
                this.commandLine = commandLine;
                for (CommandSpec object : this.mixins.values()) {
                    object.commandLine(commandLine);
                }
                for (CommandLine commandLine2 : this.commands.values()) {
                    commandLine2.getCommandSpec().parent(this);
                }
                return this;
            }

            public ParserSpec parser() {
                return this.parser;
            }

            public CommandSpec parser(ParserSpec parserSpec) {
                this.parser.initFrom(parserSpec);
                return this;
            }

            public UsageMessageSpec usageMessage() {
                return this.usageMessage;
            }

            public CommandSpec usageMessage(UsageMessageSpec usageMessageSpec) {
                this.usageMessage.initFrom(usageMessageSpec, this);
                return this;
            }

            public boolean subcommandsCaseInsensitive() {
                return this.commands.isCaseInsensitive();
            }

            public CommandSpec subcommandsCaseInsensitive(boolean bl2) {
                if (this.subcommandsCaseInsensitive() == bl2) {
                    return this;
                }
                CommandLine.tracer().debug("Changing subcommandsCaseInsensitive to %s", bl2);
                this.commands.setCaseInsensitive(bl2);
                return this;
            }

            public boolean optionsCaseInsensitive() {
                return this.optionsByNameMap.isCaseInsensitive();
            }

            public CommandSpec optionsCaseInsensitive(boolean bl2) {
                if (this.optionsCaseInsensitive() == bl2) {
                    return this;
                }
                CommandLine.tracer().debug("Changing optionsCaseInsensitive to %s", bl2);
                this.optionsByNameMap.setCaseInsensitive(bl2);
                this.negatedOptionsByNameMap.setCaseInsensitive(bl2);
                this.posixOptionsByKeyMap.setCaseInsensitive(bl2);
                RegexTransformer regexTransformer = bl2 ? RegexTransformer.createCaseInsensitive() : RegexTransformer.createDefault();
                this.negatableOptionTransformer(regexTransformer);
                return this;
            }

            public String resourceBundleBaseName() {
                return Messages.resourceBundleBaseName(this.usageMessage.messages());
            }

            public CommandSpec resourceBundleBaseName(String string) {
                ResourceBundle resourceBundle = CommandLine.empty(string) ? null : ResourceBundle.getBundle(string);
                this.setBundle(string, resourceBundle);
                return this;
            }

            public ResourceBundle resourceBundle() {
                return Messages.resourceBundle(this.usageMessage.messages());
            }

            public CommandSpec resourceBundle(ResourceBundle resourceBundle) {
                this.setBundle(Messages.extractName(resourceBundle), resourceBundle);
                return this;
            }

            private void setBundle(String string, ResourceBundle resourceBundle) {
                this.usageMessage().messages(new Messages(this, string, resourceBundle));
                this.updateArgSpecMessages();
            }

            private void updateArgSpecMessages() {
                for (OptionSpec object : this.options()) {
                    object.messages(this.usageMessage().messages());
                }
                for (PositionalParamSpec positionalParamSpec : this.positionalParameters()) {
                    positionalParamSpec.messages(this.usageMessage().messages());
                }
                for (ArgGroupSpec argGroupSpec : this.argGroups()) {
                    argGroupSpec.messages(this.usageMessage().messages());
                }
            }

            public Map<String, CommandLine> subcommands() {
                return Collections.unmodifiableMap(this.commands);
            }

            public CommandSpec addSubcommand(String string, CommandSpec commandSpec) {
                return this.addSubcommand(string, new CommandLine(commandSpec));
            }

            public CommandSpec addSubcommand(String string, CommandLine commandLine) {
                CommandSpec commandSpec = commandLine.getCommandSpec();
                String string2 = this.validateSubcommandName(this.interpolator.interpolateCommandName(string), commandSpec);
                Tracer tracer = CommandLine.tracer();
                if (tracer.isDebug()) {
                    tracer.debug("Adding subcommand '%s' to '%s'", string2, this.qualifiedName());
                }
                String string3 = this.commands.getCaseSensitiveKey(string2);
                CommandLine commandLine2 = this.commands.put(string2, commandLine);
                if (commandLine2 != null && commandLine2 != commandLine) {
                    throw new DuplicateNameException("Another subcommand named '" + string3 + "' already exists for command '" + this.name() + "'");
                }
                if (commandSpec.name == null) {
                    commandSpec.name(string2);
                }
                commandSpec.parent(this);
                Object object = commandSpec.aliases();
                int n2 = ((String[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string4 = object[i2];
                    this.addAlias(string4, string2, commandLine, tracer);
                }
                commandSpec.initCommandHierarchyWithResourceBundle(this.resourceBundleBaseName(), this.resourceBundle());
                if (this.scopeType() == ScopeType.INHERIT) {
                    commandSpec.inheritAttributesFrom(this);
                } else if (this.inherited()) {
                    for (object = this.parent(); object != null && ((CommandSpec)object).scopeType() != ScopeType.INHERIT; object = ((CommandSpec)object).parent()) {
                    }
                    if (object == null) {
                        throw new InitializationException("Cannot find scope=INHERIT root for " + this);
                    }
                    commandSpec.inheritAttributesFrom((CommandSpec)object);
                }
                for (ArgSpec argSpec : this.args()) {
                    if (argSpec.scopeType() != ScopeType.INHERIT) continue;
                    commandSpec.add(argSpec.isOption() ? ((OptionSpec.Builder)OptionSpec.builder((OptionSpec)argSpec).inherited(true)).build() : ((PositionalParamSpec.Builder)PositionalParamSpec.builder((PositionalParamSpec)argSpec).inherited(true)).build());
                }
                return this;
            }

            private void addAlias(String string, String string2, CommandLine commandLine, Tracer tracer) {
                CommandLine commandLine2;
                CommandSpec commandSpec = commandLine.getCommandSpec();
                if (tracer.isDebug()) {
                    tracer.debug("Adding alias '%s' for '%s'", (commandSpec.parent() == null ? "" : commandSpec.parent().qualifiedName() + " ") + string, commandSpec.qualifiedName());
                }
                if ((commandLine2 = this.commands.put(this.interpolator.interpolate(string), commandLine)) != null && commandLine2 != commandLine) {
                    throw new DuplicateNameException("Alias '" + string + "' for subcommand '" + string2 + "' is already used by another subcommand of '" + this.name() + "'");
                }
            }

            private void removeAlias(String string, CommandLine commandLine, Tracer tracer) {
                CommandSpec commandSpec = commandLine.getCommandSpec();
                if (tracer.isDebug()) {
                    tracer.debug("Removing alias '%s' for '%s'", (commandSpec.parent() == null ? "" : commandSpec.parent().qualifiedName() + " ") + string, commandSpec.qualifiedName());
                }
                this.commands.remove(this.interpolator.interpolate(string));
            }

            private void inheritAttributesFrom(CommandSpec commandSpec) {
                this.setInheritedDeep();
                this.initFrom(commandSpec);
                this.updatedSubcommandsToInheritFrom(commandSpec);
            }

            private void setInheritedDeep() {
                this.inherited = true;
                for (CommandLine commandLine : this.subcommands().values()) {
                    commandLine.getCommandSpec().setInheritedDeep();
                }
            }

            private void updatedSubcommandsToInheritFrom(CommandSpec commandSpec) {
                if (commandSpec != this && commandSpec.mixinStandardHelpOptions()) {
                    this.mixinStandardHelpOptions(true);
                }
                HashSet<CommandLine> hashSet = new HashSet<CommandLine>(this.subcommands().values());
                for (CommandLine commandLine : hashSet) {
                    commandLine.getCommandSpec().inheritAttributesFrom(commandSpec);
                }
            }

            public CommandLine removeSubcommand(String string) {
                String[] stringArray;
                String string2 = string;
                if (this.parser().abbreviatedSubcommandsAllowed()) {
                    string2 = AbbreviationMatcher.match(this.commands, string, this.subcommandsCaseInsensitive(), this.commandLine).getFullName();
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                CommandLine commandLine = this.commands.remove(string2);
                if (commandLine != null) {
                    treeSet.add(string2);
                    this.commands.remove(commandLine.getCommandName());
                    treeSet.add(commandLine.getCommandName());
                    stringArray = commandLine.getCommandSpec().aliases();
                    int n2 = stringArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string3 = stringArray[i2];
                        this.commands.remove(string3);
                        treeSet.add(string3);
                    }
                }
                if ((stringArray = CommandLine.tracer()).isDebug()) {
                    stringArray.debug("Removed %d subcommand entries %s for key '%s' from '%s'", treeSet.size(), treeSet, string, this.qualifiedName());
                }
                return commandLine;
            }

            private String validateSubcommandName(String string, CommandSpec commandSpec) {
                if (string != null) {
                    return string;
                }
                if (commandSpec.name != null) {
                    return commandSpec.name;
                }
                if (!commandSpec.aliases.isEmpty()) {
                    Iterator<String> iterator = commandSpec.aliases.iterator();
                    String string2 = iterator.next();
                    iterator.remove();
                    if (string2 != null) {
                        return string2;
                    }
                }
                throw new InitializationException("Cannot add subcommand with null name to " + this.qualifiedName());
            }

            private void initCommandHierarchyWithResourceBundle(String string, ResourceBundle resourceBundle) {
                if (this.resourceBundle() == null && this.resourceBundleBaseName() == null) {
                    this.setBundle(string, resourceBundle);
                }
                for (CommandLine commandLine : this.commands.values()) {
                    commandLine.getCommandSpec().initCommandHierarchyWithResourceBundle(string, resourceBundle);
                }
            }

            public boolean isAddMethodSubcommands() {
                return this.isAddMethodSubcommands == null ? DEFAULT_IS_ADD_METHOD_SUBCOMMANDS : this.isAddMethodSubcommands;
            }

            public CommandSpec setAddMethodSubcommands(Boolean bl2) {
                this.isAddMethodSubcommands = bl2;
                return this;
            }

            public boolean interpolateVariables() {
                return this.interpolateVariables == null ? DEFAULT_INTERPOLATE_VARIABLES : this.interpolateVariables;
            }

            public CommandSpec interpolateVariables(Boolean bl2) {
                this.interpolateVariables = bl2;
                return this;
            }

            public CommandSpec addMethodSubcommands() {
                return this.addMethodSubcommands(new DefaultFactory());
            }

            public CommandSpec addMethodSubcommands(IFactory iFactory) {
                if (this.userObject.isMethod()) {
                    throw new InitializationException("Cannot discover subcommand methods of this Command Method: " + this.userObject);
                }
                for (CommandLine commandLine : CommandSpec.createMethodSubcommands(this.userObject.getType(), iFactory, true)) {
                    this.addSubcommand(commandLine.getCommandName(), commandLine);
                }
                this.isAddMethodSubcommands = true;
                return this;
            }

            static List<CommandLine> createMethodSubcommands(Class<?> clazz, IFactory iFactory, boolean bl2) {
                ArrayList<CommandLine> arrayList = new ArrayList<CommandLine>();
                for (Method method : CommandLine.getCommandMethods(clazz, null, bl2)) {
                    arrayList.add(new CommandLine(method, iFactory));
                }
                return arrayList;
            }

            public CommandSpec parent() {
                return this.parent;
            }

            public CommandSpec root() {
                CommandSpec commandSpec = this;
                while (commandSpec.parent != null) {
                    commandSpec = commandSpec.parent;
                }
                return commandSpec;
            }

            public CommandSpec parent(CommandSpec commandSpec) {
                this.parent = commandSpec;
                this.injectParentCommand(commandSpec.userObject);
                return this;
            }

            public CommandSpec add(ArgSpec argSpec) {
                return argSpec.isOption() ? this.addOption((OptionSpec)argSpec) : this.addPositional((PositionalParamSpec)argSpec);
            }

            public CommandSpec addOption(OptionSpec optionSpec) {
                Tracer tracer = CommandLine.tracer();
                for (String string : this.interpolator.interpolate(optionSpec.names())) {
                    String string2 = this.optionsByNameMap.getCaseSensitiveKey(string);
                    OptionSpec optionSpec2 = this.optionsByNameMap.put(string, optionSpec);
                    if (optionSpec2 != null) {
                        throw DuplicateOptionAnnotationsException.create(string2, optionSpec, optionSpec2);
                    }
                    String string3 = this.negatedOptionsByNameMap.getCaseSensitiveKey(string);
                    OptionSpec optionSpec3 = this.negatedOptionsByNameMap.get(string);
                    if (optionSpec3 != null && optionSpec3 != optionSpec) {
                        throw DuplicateOptionAnnotationsException.create(string3, optionSpec, optionSpec3);
                    }
                    if (string.length() != 2 || !string.startsWith("-")) continue;
                    this.posixOptionsByKeyMap.put(Character.valueOf(string.charAt(1)), optionSpec);
                }
                this.options.add(optionSpec);
                this.addOptionNegative(optionSpec, tracer);
                if (optionSpec.scopeType() == ScopeType.INHERIT) {
                    HashSet hashSet = new HashSet();
                    for (CommandLine commandLine : this.subcommands().values()) {
                        if (hashSet.contains(commandLine)) continue;
                        commandLine.getCommandSpec().addOption(((OptionSpec.Builder)OptionSpec.builder(optionSpec).inherited(true)).build());
                        hashSet.add(commandLine);
                    }
                }
                return this.addArg(optionSpec);
            }

            private void addOptionNegative(OptionSpec optionSpec, Tracer tracer) {
                if (optionSpec.negatable()) {
                    if (!optionSpec.typeInfo().isBoolean() && !optionSpec.typeInfo().isOptional()) {
                        throw new InitializationException("Only boolean options can be negatable, but " + optionSpec + " is of type " + optionSpec.typeInfo().getClassName());
                    }
                    for (String string : this.interpolator.interpolate(optionSpec.names())) {
                        String string2 = this.negatableOptionTransformer().makeNegative(string, this);
                        if (string.equals(string2)) {
                            tracer.debug("Option %s is negatable, but has no negative form.", string);
                            continue;
                        }
                        tracer.debug("Option %s is negatable, registering negative name %s.", string, string2);
                        String string3 = this.negatedOptionsByNameMap.getCaseSensitiveKey(string2);
                        OptionSpec optionSpec2 = this.negatedOptionsByNameMap.put(string2, optionSpec);
                        if (optionSpec2 == null) {
                            string3 = this.optionsByNameMap.getCaseSensitiveKey(string2);
                            optionSpec2 = this.optionsByNameMap.get(string2);
                        }
                        if (optionSpec2 == null) continue;
                        throw DuplicateOptionAnnotationsException.create(string3, optionSpec, optionSpec2);
                    }
                }
            }

            private void resetNegativeOptionNames() {
                Tracer tracer = CommandLine.tracer();
                tracer.debug("Clearing negatedOptionsByNameMap...", new Object[0]);
                this.negatedOptionsByNameMap.clear();
                for (OptionSpec optionSpec : this.options) {
                    this.addOptionNegative(optionSpec, tracer);
                }
            }

            public CommandSpec addPositional(PositionalParamSpec positionalParamSpec) {
                this.positionalParameters.add(positionalParamSpec);
                this.addArg(positionalParamSpec);
                if (positionalParamSpec.index().isUnresolved()) {
                    positionalParamSpec.index = Range.valueOf(this.interpolator.interpolate(positionalParamSpec.index().originalValue));
                    positionalParamSpec.initCapacity();
                }
                this.adjustRelativeIndices(positionalParamSpec);
                if (positionalParamSpec.scopeType() == ScopeType.INHERIT) {
                    HashSet<CommandLine> hashSet = new HashSet<CommandLine>(this.subcommands().values());
                    for (CommandLine commandLine : hashSet) {
                        commandLine.getCommandSpec().addPositional(((PositionalParamSpec.Builder)PositionalParamSpec.builder(positionalParamSpec).inherited(true)).build());
                    }
                }
                return this;
            }

            private void adjustRelativeIndices(PositionalParamSpec positionalParamSpec) {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                for (int i2 = this.positionalParameters.indexOf(positionalParamSpec); i2 < this.positionalParameters.size(); ++i2) {
                    int n2;
                    PositionalParamSpec positionalParamSpec2 = this.positionalParameters.get(i2);
                    Range range = positionalParamSpec2.index();
                    if (!range.isRelative()) continue;
                    int n3 = n2 = i2 == 0 ? -1 : this.positionalParameters.get(i2 - 1).index().max();
                    int n4 = i2 == 0 ? 0 : (n2 == Integer.MAX_VALUE ? n2 : n2 + 1);
                    n4 = range.isRelativeToAnchor() ? Math.max(n4, range.anchor()) : n4;
                    positionalParamSpec2.index = new Range(n4, n4, range.isVariable(), range.isUnspecified, range.originalValue);
                    positionalParamSpec2.initCapacity();
                }
            }

            private CommandSpec addArg(ArgSpec argSpec) {
                this.args.add(argSpec);
                argSpec.messages(this.usageMessage().messages());
                argSpec.commandSpec = this;
                if (argSpec.arity().isUnresolved()) {
                    argSpec.arity = Range.valueOf(this.interpolator.interpolate(argSpec.arity().originalValue));
                }
                if (argSpec.required() && argSpec.group() == null && !argSpec.inherited()) {
                    this.requiredArgs.add(argSpec);
                }
                return this;
            }

            public CommandSpec remove(ArgSpec argSpec) {
                if (argSpec.group() != null) {
                    throw new UnsupportedOperationException("Cannot remove ArgSpec that is part of an ArgGroup");
                }
                int n2 = CommandSpec.remove(argSpec, this.optionsByNameMap);
                n2 += CommandSpec.remove(argSpec, this.posixOptionsByKeyMap);
                n2 += CommandSpec.remove(argSpec, this.negatedOptionsByNameMap);
                this.requiredArgs.remove(argSpec);
                this.options.remove(argSpec);
                if (this.positionalParameters.remove(argSpec)) {
                    ++n2;
                }
                this.args.remove(argSpec);
                if (n2 == 0) {
                    throw new NoSuchElementException(String.valueOf(argSpec));
                }
                argSpec.commandSpec = null;
                argSpec.messages(null);
                return this;
            }

            private static <T> int remove(ArgSpec argSpec, Map<T, OptionSpec> map) {
                int n2 = 0;
                Iterator<Map.Entry<T, OptionSpec>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<T, OptionSpec> entry = iterator.next();
                    if (entry.getValue() != argSpec) continue;
                    iterator.remove();
                    ++n2;
                }
                return n2;
            }

            public CommandSpec addArgGroup(ArgGroupSpec argGroupSpec) {
                return this.addArgGroup(argGroupSpec, new HashSet<OptionSpec>(), new HashSet<PositionalParamSpec>());
            }

            private CommandSpec addArgGroup(ArgGroupSpec argGroupSpec, Set<OptionSpec> set, Set<PositionalParamSpec> set2) {
                Assert.notNull(argGroupSpec, "group");
                if (argGroupSpec.parentGroup() != null) {
                    throw new InitializationException("Groups that are part of another group should not be added to a command. Add only the top-level group.");
                }
                this.check(argGroupSpec, this.flatten(this.groups, new HashSet<ArgGroupSpec>()));
                this.groups.add(argGroupSpec);
                this.addGroupArgsToCommand(argGroupSpec, new HashMap<String, ArgGroupSpec>(), set, set2);
                return this;
            }

            private void addGroupArgsToCommand(ArgGroupSpec argGroupSpec, Map<String, ArgGroupSpec> map, Set<OptionSpec> set, Set<PositionalParamSpec> set2) {
                HashMap<String, OptionSpec> hashMap = new HashMap<String, OptionSpec>();
                for (ArgSpec object : argGroupSpec.args()) {
                    if (object.isOption()) {
                        String[] stringArray;
                        for (String string : stringArray = this.interpolator.interpolate(((OptionSpec)object).names())) {
                            ArgGroupSpec argGroupSpec2 = map.get(string);
                            if (argGroupSpec2 == null) continue;
                            if (argGroupSpec2 == argGroupSpec) {
                                throw DuplicateOptionAnnotationsException.create(string, object, (ArgSpec)hashMap.get(string));
                            }
                            throw new DuplicateNameException("An option cannot be in multiple groups but " + string + " is in " + argGroupSpec.synopsisUnit() + " and " + map.get(string).synopsisUnit() + ". Refactor to avoid this. For example, (-a | (-a -b)) can be rewritten as (-a [-b]), and (-a -b | -a -c) can be rewritten as (-a (-b | -c)).");
                        }
                        for (String string : stringArray) {
                            map.put(string, argGroupSpec);
                        }
                        for (String string : stringArray) {
                            hashMap.put(string, (OptionSpec)object);
                        }
                        set.add((OptionSpec)object);
                    } else {
                        set2.add((PositionalParamSpec)object);
                    }
                    this.add(object);
                }
                for (ArgGroupSpec argGroupSpec3 : argGroupSpec.subgroups()) {
                    this.addGroupArgsToCommand(argGroupSpec3, map, set, set2);
                }
            }

            private Set<ArgGroupSpec> flatten(Collection<ArgGroupSpec> collection, Set<ArgGroupSpec> set) {
                for (ArgGroupSpec argGroupSpec : collection) {
                    this.flatten(argGroupSpec, set);
                }
                return set;
            }

            private Set<ArgGroupSpec> flatten(ArgGroupSpec argGroupSpec, Set<ArgGroupSpec> set) {
                set.add(argGroupSpec);
                for (ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups()) {
                    this.flatten(argGroupSpec2, set);
                }
                return set;
            }

            private void check(ArgGroupSpec argGroupSpec, Set<ArgGroupSpec> set) {
                if (set.contains(argGroupSpec)) {
                    throw new InitializationException("The specified group " + argGroupSpec.synopsisUnit() + " has already been added to the " + this.qualifiedName() + " command.");
                }
                for (ArgGroupSpec argGroupSpec2 : argGroupSpec.subgroups()) {
                    this.check(argGroupSpec2, set);
                }
            }

            public CommandSpec addMixin(String string, CommandSpec commandSpec, IAnnotatedElement iAnnotatedElement) {
                CommandSpec commandSpec2 = this.addMixin(string, commandSpec);
                this.mixinAnnotatedElements.put(this.interpolator.interpolate(string), iAnnotatedElement);
                return commandSpec2;
            }

            public CommandSpec addMixin(String string, CommandSpec commandSpec) {
                this.mixins.put(this.interpolator.interpolate(string), commandSpec);
                this.initName(this.interpolator.interpolateCommandName(commandSpec.name()));
                this.initAliases(commandSpec.aliases());
                this.initFrom(commandSpec);
                for (Map.Entry<String, CommandLine> object22 : commandSpec.subcommands().entrySet()) {
                    this.addSubcommand(object22.getKey(), object22.getValue());
                }
                LinkedHashSet<OptionSpec> linkedHashSet = new LinkedHashSet<OptionSpec>(commandSpec.options());
                LinkedHashSet<PositionalParamSpec> linkedHashSet2 = new LinkedHashSet<PositionalParamSpec>(commandSpec.positionalParameters());
                for (ArgGroupSpec argGroupSpec : commandSpec.argGroups()) {
                    HashSet<OptionSpec> hashSet = new HashSet<OptionSpec>();
                    HashSet<PositionalParamSpec> hashSet2 = new HashSet<PositionalParamSpec>();
                    this.addArgGroup(argGroupSpec, hashSet, hashSet2);
                    linkedHashSet.removeAll(hashSet);
                    linkedHashSet2.removeAll(hashSet2);
                }
                Iterator<ArgGroupSpec> iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    OptionSpec optionSpec = (OptionSpec)((Object)iterator.next());
                    this.addOption(optionSpec);
                }
                for (PositionalParamSpec positionalParamSpec : linkedHashSet2) {
                    this.addPositional(positionalParamSpec);
                }
                return this;
            }

            private void initFrom(CommandSpec commandSpec) {
                this.initExitCodeOnSuccess(commandSpec.exitCodeOnSuccess());
                this.initExitCodeOnUsageHelp(commandSpec.exitCodeOnUsageHelp());
                this.initExitCodeOnVersionHelp(commandSpec.exitCodeOnVersionHelp());
                this.initExitCodeOnInvalidInput(commandSpec.exitCodeOnInvalidInput());
                this.initExitCodeOnExecutionException(commandSpec.exitCodeOnExecutionException());
                this.parser.initSeparator(commandSpec.parser.separator());
                this.initVersion(commandSpec.version());
                this.initHelpCommand(commandSpec.helpCommand());
                this.initVersionProvider(commandSpec.versionProvider());
                this.initDefaultValueProvider(commandSpec.defaultValueProvider());
                this.initModelTransformer(commandSpec.modelTransformer());
                this.initPreprocessor(commandSpec.preprocessor());
                this.usageMessage.initFromMixin(commandSpec.usageMessage, this);
                this.initSubcommandsRepeatable(commandSpec.subcommandsRepeatable());
            }

            public CommandSpec addUnmatchedArgsBinding(UnmatchedArgsBinding unmatchedArgsBinding) {
                this.unmatchedArgs.add(unmatchedArgsBinding);
                this.parser().unmatchedArgumentsAllowed(true);
                return this;
            }

            public CommandSpec addSpecElement(IAnnotatedElement iAnnotatedElement) {
                this.specElements.add(iAnnotatedElement);
                return this;
            }

            public CommandSpec addParentCommandElement(IAnnotatedElement iAnnotatedElement) {
                this.parentCommandElements.add(iAnnotatedElement);
                return this;
            }

            void injectParentCommand(CommandUserObject commandUserObject) {
                try {
                    for (IAnnotatedElement iAnnotatedElement : this.parentCommandElements()) {
                        iAnnotatedElement.setter().set(commandUserObject.getInstance());
                    }
                }
                catch (Exception exception) {
                    throw new InitializationException("Unable to initialize @ParentCommand field: " + exception, exception);
                }
            }

            public Map<String, CommandSpec> mixins() {
                return Collections.unmodifiableMap(this.mixins);
            }

            public Map<String, IAnnotatedElement> mixinAnnotatedElements() {
                return Collections.unmodifiableMap(this.mixinAnnotatedElements);
            }

            public List<OptionSpec> options() {
                return Collections.unmodifiableList(this.options);
            }

            public List<PositionalParamSpec> positionalParameters() {
                return Collections.unmodifiableList(this.positionalParameters);
            }

            public List<ArgGroupSpec> argGroups() {
                return Collections.unmodifiableList(this.groups);
            }

            public Map<String, OptionSpec> optionsMap() {
                return Collections.unmodifiableMap(this.optionsByNameMap);
            }

            public Map<String, OptionSpec> negatedOptionsMap() {
                return Collections.unmodifiableMap(this.negatedOptionsByNameMap);
            }

            public Map<Character, OptionSpec> posixOptionsMap() {
                return Collections.unmodifiableMap(this.posixOptionsByKeyMap);
            }

            public List<ArgSpec> requiredArgs() {
                return Collections.unmodifiableList(this.requiredArgs);
            }

            public List<UnmatchedArgsBinding> unmatchedArgsBindings() {
                return Collections.unmodifiableList(this.unmatchedArgs);
            }

            public List<IAnnotatedElement> specElements() {
                return Collections.unmodifiableList(this.specElements);
            }

            public List<IAnnotatedElement> parentCommandElements() {
                return Collections.unmodifiableList(this.parentCommandElements);
            }

            public String name() {
                return this.interpolator.interpolateCommandName(this.name == null ? DEFAULT_COMMAND_NAME : this.name);
            }

            public String[] aliases() {
                return this.interpolator.interpolate(this.aliases.toArray(new String[0]));
            }

            public Set<String> names() {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add(this.name());
                linkedHashSet.addAll(Arrays.asList(this.aliases()));
                return linkedHashSet;
            }

            public List<ArgSpec> args() {
                return Collections.unmodifiableList(this.args);
            }

            Object[] commandMethodParamValues() {
                Object[] objectArray = new Object[this.methodParams.length];
                CommandSpec commandSpec = this.mixins.get("mixinStandardHelpOptions");
                int n2 = commandSpec == null || commandSpec.inherited() ? 0 : 2;
                block0: for (int i2 = 0; i2 < this.methodParams.length; ++i2) {
                    if (this.methodParams[i2].isAnnotationPresent(Mixin.class)) {
                        String string = this.methodParams[i2].getAnnotation(Mixin.class).name();
                        CommandSpec commandSpec2 = this.mixins.get(CommandLine.empty(string) ? this.methodParams[i2].name : string);
                        objectArray[i2] = commandSpec2.userObject.getInstance();
                        n2 += commandSpec2.args.size();
                        continue;
                    }
                    if (this.methodParams[i2].isAnnotationPresent(ArgGroup.class)) {
                        objectArray[i2] = null;
                        for (ArgGroupSpec argGroupSpec : this.groups) {
                            if (!argGroupSpec.typeInfo.equals(this.methodParams[i2].typeInfo)) continue;
                            objectArray[i2] = argGroupSpec.userObjectOr(null);
                            n2 += argGroupSpec.argCount();
                            continue block0;
                        }
                        continue;
                    }
                    objectArray[i2] = this.args.get(n2++).getValue();
                }
                return objectArray;
            }

            public String qualifiedName() {
                return this.qualifiedName(" ");
            }

            public String qualifiedName(String string) {
                String string2 = this.name();
                if (this.parent() != null) {
                    string2 = this.parent().qualifiedName(string) + string + string2;
                }
                return string2;
            }

            public String[] version() {
                if (this.versionProvider != null) {
                    try {
                        return this.interpolator.interpolate(this.versionProvider.getVersion());
                    }
                    catch (Exception exception) {
                        String string = "Could not get version info from " + this.versionProvider + ": " + exception;
                        throw new ExecutionException(this.commandLine, string, exception);
                    }
                }
                return this.interpolator.interpolate(this.version == null ? UsageMessageSpec.DEFAULT_MULTI_LINE : this.version);
            }

            public IVersionProvider versionProvider() {
                return this.versionProvider;
            }

            public boolean helpCommand() {
                return this.isHelpCommand == null ? DEFAULT_IS_HELP_COMMAND : this.isHelpCommand;
            }

            public int exitCodeOnSuccess() {
                return this.exitCodeOnSuccess == null ? 0 : this.exitCodeOnSuccess;
            }

            public int exitCodeOnUsageHelp() {
                return this.exitCodeOnUsageHelp == null ? 0 : this.exitCodeOnUsageHelp;
            }

            public int exitCodeOnVersionHelp() {
                return this.exitCodeOnVersionHelp == null ? 0 : this.exitCodeOnVersionHelp;
            }

            public int exitCodeOnInvalidInput() {
                return this.exitCodeOnInvalidInput == null ? 2 : this.exitCodeOnInvalidInput;
            }

            public int exitCodeOnExecutionException() {
                return this.exitCodeOnExecutionException == null ? 1 : this.exitCodeOnExecutionException;
            }

            public INegatableOptionTransformer negatableOptionTransformer() {
                return this.negatableOptionTransformer;
            }

            public boolean mixinStandardHelpOptions() {
                return this.mixins.containsKey("mixinStandardHelpOptions");
            }

            public boolean subcommandsRepeatable() {
                return this.subcommandsRepeatable == null ? DEFAULT_SUBCOMMANDS_REPEATABLE : this.subcommandsRepeatable;
            }

            public String toString() {
                return this.toString == null ? "command '" + this.name + "' (user object: " + this.userObject + ")" : this.toString;
            }

            public CommandSpec name(String string) {
                this.name = string;
                return this;
            }

            public CommandSpec aliases(String ... stringArray) {
                Set<String> set = this.aliases;
                this.aliases = new LinkedHashSet<String>(Arrays.asList(stringArray == null ? new String[]{} : stringArray));
                if (this.parent != null) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.aliases);
                    linkedHashSet.removeAll(set);
                    Tracer tracer = CommandLine.tracer();
                    for (String string : linkedHashSet) {
                        this.parent.addAlias(string, this.name, this.commandLine, tracer);
                    }
                    set.removeAll(this.aliases);
                    for (String string : set) {
                        this.parent.removeAlias(string, this.commandLine, tracer);
                    }
                }
                return this;
            }

            public IDefaultValueProvider defaultValueProvider() {
                return this.defaultValueProvider;
            }

            public CommandSpec defaultValueProvider(IDefaultValueProvider iDefaultValueProvider) {
                this.defaultValueProvider = iDefaultValueProvider;
                return this;
            }

            public CommandSpec version(String ... stringArray) {
                this.version = stringArray;
                return this;
            }

            public CommandSpec versionProvider(IVersionProvider iVersionProvider) {
                this.versionProvider = iVersionProvider;
                return this;
            }

            public CommandSpec helpCommand(boolean bl2) {
                this.isHelpCommand = bl2;
                return this;
            }

            public CommandSpec exitCodeOnSuccess(int n2) {
                this.exitCodeOnSuccess = n2;
                return this;
            }

            public CommandSpec exitCodeOnUsageHelp(int n2) {
                this.exitCodeOnUsageHelp = n2;
                return this;
            }

            public CommandSpec exitCodeOnVersionHelp(int n2) {
                this.exitCodeOnVersionHelp = n2;
                return this;
            }

            public CommandSpec exitCodeOnInvalidInput(int n2) {
                this.exitCodeOnInvalidInput = n2;
                return this;
            }

            public CommandSpec exitCodeOnExecutionException(int n2) {
                this.exitCodeOnExecutionException = n2;
                return this;
            }

            public boolean inherited() {
                return this.inherited;
            }

            public ScopeType scopeType() {
                return this.scopeType == null ? ScopeType.LOCAL : this.scopeType;
            }

            public CommandSpec scopeType(ScopeType scopeType) {
                if (this.scopeType == ScopeType.INHERIT && scopeType != ScopeType.INHERIT && !this.subcommands().isEmpty()) {
                    throw new IllegalStateException("Cannot un-inherit: subcommands have already been initialized with values from this command");
                }
                this.scopeType = scopeType;
                if (scopeType == ScopeType.INHERIT) {
                    this.updatedSubcommandsToInheritFrom(this);
                }
                return this;
            }

            public IModelTransformer modelTransformer() {
                return this.modelTransformer;
            }

            public CommandSpec modelTransformer(IModelTransformer iModelTransformer) {
                this.modelTransformer = iModelTransformer;
                return this;
            }

            public IParameterPreprocessor preprocessor() {
                return this.preprocessor;
            }

            public CommandSpec preprocessor(IParameterPreprocessor iParameterPreprocessor) {
                this.preprocessor = Assert.notNull(iParameterPreprocessor, "preprocessor");
                return this;
            }

            public CommandSpec negatableOptionTransformer(INegatableOptionTransformer iNegatableOptionTransformer) {
                Tracer tracer = CommandLine.tracer();
                tracer.debug("Replacing negatableOptionTransformer %s with %s", this.negatableOptionTransformer, iNegatableOptionTransformer);
                this.negatableOptionTransformer = iNegatableOptionTransformer;
                this.resetNegativeOptionNames();
                return this;
            }

            public CommandSpec mixinStandardHelpOptions(boolean bl2) {
                block7: {
                    block6: {
                        if (!bl2) break block6;
                        CommandSpec commandSpec = CommandSpec.forAnnotatedObject(new AutoHelpMixin(), new DefaultFactory());
                        boolean bl3 = false;
                        for (String object : commandSpec.optionsMap().keySet()) {
                            if (!this.optionsMap().containsKey(object)) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) {
                            commandSpec.inherited = this.inherited();
                            this.addMixin("mixinStandardHelpOptions", commandSpec);
                        }
                        if (this.scopeType() != ScopeType.INHERIT && !this.inherited()) break block7;
                        for (CommandLine commandLine : new HashSet<CommandLine>(this.subcommands().values())) {
                            commandLine.getCommandSpec().mixinStandardHelpOptions(bl2);
                        }
                        break block7;
                    }
                    CommandSpec commandSpec = this.mixins.remove("mixinStandardHelpOptions");
                    if (commandSpec != null) {
                        this.options.removeAll(commandSpec.options);
                        for (OptionSpec optionSpec : commandSpec.options()) {
                            for (String string : this.interpolator.interpolate(optionSpec.names())) {
                                this.optionsByNameMap.remove(string);
                                if (string.length() != 2 || !string.startsWith("-")) continue;
                                this.posixOptionsByKeyMap.remove(Character.valueOf(string.charAt(1)));
                            }
                        }
                    }
                }
                return this;
            }

            public CommandSpec subcommandsRepeatable(boolean bl2) {
                this.subcommandsRepeatable = bl2;
                return this;
            }

            public CommandSpec withToString(String string) {
                this.toString = string;
                return this;
            }

            public void updateCommandAttributes(Command command, IFactory iFactory) {
                this.parser().updateSeparator(this.interpolator.interpolate(command.separator()));
                this.updateExitCodeOnSuccess(command.exitCodeOnSuccess());
                this.updateExitCodeOnUsageHelp(command.exitCodeOnUsageHelp());
                this.updateExitCodeOnVersionHelp(command.exitCodeOnVersionHelp());
                this.updateExitCodeOnInvalidInput(command.exitCodeOnInvalidInput());
                this.updateExitCodeOnExecutionException(command.exitCodeOnExecutionException());
                this.aliases(command.aliases());
                this.updateName(command.name());
                this.updateVersion(command.version());
                this.updateHelpCommand(command.helpCommand());
                this.updateSubcommandsRepeatable(command.subcommandsRepeatable());
                this.updateAddMethodSubcommands(command.addMethodSubcommands());
                this.usageMessage().updateFromCommand(command, this, iFactory != null);
                this.updateScopeType(command.scope());
                if (iFactory != null) {
                    this.updateModelTransformer(command.modelTransformer(), iFactory);
                    this.updateVersionProvider(command.versionProvider(), iFactory);
                    this.initDefaultValueProvider(command.defaultValueProvider(), iFactory);
                    this.updatePreprocessor(command.preprocessor(), iFactory);
                }
            }

            void initAliases(String[] stringArray) {
                if (stringArray != null) {
                    this.aliases.addAll(Arrays.asList(stringArray));
                }
            }

            void initName(String string) {
                if (Model.initializable(this.name, string, DEFAULT_COMMAND_NAME)) {
                    this.name = string;
                }
            }

            void initHelpCommand(boolean bl2) {
                if (Model.initializable(this.isHelpCommand, bl2, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = bl2;
                }
            }

            void initVersion(String[] stringArray) {
                if (Model.initializable(this.version, stringArray, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])stringArray.clone();
                }
            }

            void initVersionProvider(IVersionProvider iVersionProvider) {
                if (this.versionProvider == null) {
                    this.versionProvider = iVersionProvider;
                }
            }

            void initDefaultValueProvider(IDefaultValueProvider iDefaultValueProvider) {
                if (this.defaultValueProvider == null) {
                    this.defaultValueProvider = iDefaultValueProvider;
                }
            }

            void initDefaultValueProvider(Class<? extends IDefaultValueProvider> clazz, IFactory iFactory) {
                if (Model.initializable(this.defaultValueProvider, clazz, NoDefaultProvider.class)) {
                    this.defaultValueProvider = DefaultFactory.createDefaultValueProvider(iFactory, clazz);
                }
            }

            void initSubcommandsRepeatable(boolean bl2) {
                if (Model.initializable(this.subcommandsRepeatable, bl2, CommandSpec.DEFAULT_SUBCOMMANDS_REPEATABLE)) {
                    this.subcommandsRepeatable = bl2;
                }
            }

            void initExitCodeOnSuccess(int n2) {
                if (Model.initializable(this.exitCodeOnSuccess, n2, 0)) {
                    this.exitCodeOnSuccess = n2;
                }
            }

            void initExitCodeOnUsageHelp(int n2) {
                if (Model.initializable(this.exitCodeOnUsageHelp, n2, 0)) {
                    this.exitCodeOnUsageHelp = n2;
                }
            }

            void initExitCodeOnVersionHelp(int n2) {
                if (Model.initializable(this.exitCodeOnVersionHelp, n2, 0)) {
                    this.exitCodeOnVersionHelp = n2;
                }
            }

            void initExitCodeOnInvalidInput(int n2) {
                if (Model.initializable(this.exitCodeOnInvalidInput, n2, 2)) {
                    this.exitCodeOnInvalidInput = n2;
                }
            }

            void initExitCodeOnExecutionException(int n2) {
                if (Model.initializable(this.exitCodeOnExecutionException, n2, 1)) {
                    this.exitCodeOnExecutionException = n2;
                }
            }

            void updateName(String string) {
                if (Model.isNonDefault(string, DEFAULT_COMMAND_NAME)) {
                    this.name = string;
                }
            }

            void initModelTransformer(IModelTransformer iModelTransformer) {
                if (this.modelTransformer == null) {
                    this.modelTransformer = iModelTransformer;
                }
            }

            void updateModelTransformer(Class<? extends IModelTransformer> clazz, IFactory iFactory) {
                if (Model.isNonDefault(clazz, NoOpModelTransformer.class)) {
                    this.modelTransformer = DefaultFactory.create(iFactory, clazz);
                }
            }

            void initPreprocessor(IParameterPreprocessor iParameterPreprocessor) {
                if (this.preprocessor instanceof NoOpParameterPreprocessor) {
                    this.preprocessor = Assert.notNull(iParameterPreprocessor, "preprocessor");
                }
            }

            void updatePreprocessor(Class<? extends IParameterPreprocessor> clazz, IFactory iFactory) {
                if (Model.isNonDefault(clazz, NoOpParameterPreprocessor.class)) {
                    this.preprocessor = DefaultFactory.create(iFactory, clazz);
                }
            }

            void updateHelpCommand(boolean bl2) {
                if (Model.isNonDefault(bl2, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = bl2;
                }
            }

            void updateSubcommandsRepeatable(boolean bl2) {
                if (Model.isNonDefault(bl2, CommandSpec.DEFAULT_SUBCOMMANDS_REPEATABLE)) {
                    this.subcommandsRepeatable = bl2;
                }
            }

            void updateAddMethodSubcommands(boolean bl2) {
                if (Model.isNonDefault(bl2, CommandSpec.DEFAULT_IS_ADD_METHOD_SUBCOMMANDS)) {
                    this.isAddMethodSubcommands = bl2;
                }
            }

            void updateVersion(String[] stringArray) {
                if (Model.isNonDefault(stringArray, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])stringArray.clone();
                }
            }

            void updateVersionProvider(Class<? extends IVersionProvider> clazz, IFactory iFactory) {
                if (Model.isNonDefault(clazz, NoVersionProvider.class)) {
                    this.versionProvider = DefaultFactory.createVersionProvider(iFactory, clazz);
                }
            }

            void updateExitCodeOnSuccess(int n2) {
                if (Model.isNonDefault(n2, 0)) {
                    this.exitCodeOnSuccess = n2;
                }
            }

            void updateExitCodeOnUsageHelp(int n2) {
                if (Model.isNonDefault(n2, 0)) {
                    this.exitCodeOnUsageHelp = n2;
                }
            }

            void updateExitCodeOnVersionHelp(int n2) {
                if (Model.isNonDefault(n2, 0)) {
                    this.exitCodeOnVersionHelp = n2;
                }
            }

            void updateExitCodeOnInvalidInput(int n2) {
                if (Model.isNonDefault(n2, 2)) {
                    this.exitCodeOnInvalidInput = n2;
                }
            }

            void updateExitCodeOnExecutionException(int n2) {
                if (Model.isNonDefault(n2, 1)) {
                    this.exitCodeOnExecutionException = n2;
                }
            }

            void updateScopeType(ScopeType scopeType) {
                if (this.scopeType == null) {
                    this.scopeType(scopeType);
                }
            }

            public OptionSpec findOption(char c2) {
                return CommandSpec.findOption(c2, this.options());
            }

            public OptionSpec findOption(String string) {
                return CommandSpec.findOption(string, this.options());
            }

            static OptionSpec findOption(char c2, Iterable<OptionSpec> iterable) {
                for (OptionSpec optionSpec : iterable) {
                    for (String string : optionSpec.names()) {
                        if (string.length() == 2 && string.charAt(0) == '-' && string.charAt(1) == c2) {
                            return optionSpec;
                        }
                        if (string.length() != 1 || string.charAt(0) != c2) continue;
                        return optionSpec;
                    }
                }
                return null;
            }

            static OptionSpec findOption(String string, List<OptionSpec> list) {
                for (OptionSpec optionSpec : list) {
                    for (String string2 : optionSpec.names()) {
                        if (!string2.equals(string) && !CommandSpec.stripPrefix(string2).equals(string)) continue;
                        return optionSpec;
                    }
                }
                return null;
            }

            static String stripPrefix(String string) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    if (!Character.isJavaIdentifierPart(string.charAt(i2))) continue;
                    return string.substring(i2);
                }
                return string;
            }

            List<String> findVisibleOptionNamesWithPrefix(String string) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (OptionSpec optionSpec : this.options()) {
                    for (String string2 : optionSpec.names()) {
                        if (optionSpec.hidden() || !CommandSpec.stripPrefix(string2).startsWith(string)) continue;
                        arrayList.add(string2);
                    }
                }
                return arrayList;
            }

            boolean resemblesOption(String string) {
                if (string == null) {
                    return false;
                }
                Tracer tracer = CommandLine.tracer();
                if (string.length() == 1) {
                    if (tracer != null && tracer.isDebug()) {
                        tracer.debug("Single-character arguments that don't match known options are considered positional parameters", string);
                    }
                    return false;
                }
                try {
                    Long.decode(string);
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double.parseDouble(string);
                        return false;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        boolean bl2;
                        if (this.options().isEmpty()) {
                            boolean bl3 = string.startsWith("-");
                            if (tracer != null && tracer.isDebug()) {
                                tracer.debug("'%s' %s an option", string, bl3 ? "resembles" : "doesn't resemble");
                            }
                            return bl3;
                        }
                        int n2 = 0;
                        for (String string2 : this.optionsMap().keySet()) {
                            for (int i2 = 0; i2 < string.length() && string2.length() > i2 && string.charAt(i2) == string2.charAt(i2); ++i2) {
                                ++n2;
                            }
                        }
                        boolean bl4 = bl2 = n2 > 0 && n2 * 10 >= this.optionsMap().size() * 9;
                        if (tracer != null && tracer.isDebug()) {
                            tracer.debug("'%s' %s an option: %d matching prefix chars out of %d option names", string, bl2 ? "resembles" : "doesn't resemble", n2, this.optionsMap().size());
                        }
                        return bl2;
                    }
                }
            }

            static /* synthetic */ TypedMember[] access$16802(CommandSpec commandSpec, TypedMember[] typedMemberArray) {
                commandSpec.methodParams = typedMemberArray;
                return typedMemberArray;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CaseAwareLinkedMap<K, V>
        extends AbstractMap<K, V> {
            private final LinkedHashMap<K, V> targetMap = new LinkedHashMap();
            private final HashMap<K, K> keyMap = new HashMap();
            private final Set<K> keySet = new CaseAwareKeySet();
            private boolean caseInsensitive = false;
            private final Locale locale;

            public CaseAwareLinkedMap() {
                this(Locale.ENGLISH);
            }

            public CaseAwareLinkedMap(Locale locale) {
                this.locale = locale;
            }

            public CaseAwareLinkedMap(CaseAwareLinkedMap<? extends K, ? extends V> caseAwareLinkedMap) {
                this.targetMap.putAll(caseAwareLinkedMap.targetMap);
                this.keyMap.putAll(caseAwareLinkedMap.keyMap);
                this.caseInsensitive = caseAwareLinkedMap.caseInsensitive;
                this.locale = caseAwareLinkedMap.locale;
            }

            static boolean isCaseConvertible(Class<?> clazz) {
                return clazz == String.class || clazz == Character.class;
            }

            private K toLowerCase(Object object) {
                if (object.getClass() == String.class) {
                    return (K)((String)object).toLowerCase(this.locale);
                }
                if (object.getClass() == Character.class) {
                    return (K)Character.valueOf(Character.toLowerCase(((Character)object).charValue()));
                }
                throw new UnsupportedOperationException("Unsupported case-conversion for key " + object.getClass());
            }

            public boolean isCaseInsensitive() {
                return this.caseInsensitive;
            }

            public void setCaseInsensitive(boolean bl2) {
                if (!this.isCaseInsensitive() && bl2) {
                    for (K k2 : this.targetMap.keySet()) {
                        K k3 = this.keyMap.put(k2 != null ? (Object)this.toLowerCase(k2) : null, k2);
                        if (k3 == null) continue;
                        throw new DuplicateNameException("Duplicated keys: " + k3 + " and " + k2);
                    }
                } else if (this.isCaseInsensitive()) {
                    this.keyMap.clear();
                }
                this.caseInsensitive = bl2;
            }

            public Locale getLocale() {
                return this.locale;
            }

            public K getCaseSensitiveKey(K k2) {
                if (k2 != null && this.caseInsensitive) {
                    return this.keyMap.get(this.toLowerCase(k2));
                }
                return k2;
            }

            @Override
            public int size() {
                return this.targetMap.size();
            }

            @Override
            public boolean containsKey(Object object) {
                if (object != null && this.caseInsensitive) {
                    if (!CaseAwareLinkedMap.isCaseConvertible(object.getClass())) {
                        return false;
                    }
                    return this.keyMap.containsKey(this.toLowerCase(object));
                }
                return this.targetMap.containsKey(object);
            }

            @Override
            public boolean containsValue(Object object) {
                return this.targetMap.containsValue(object);
            }

            @Override
            public V get(Object object) {
                if (object != null && CaseAwareLinkedMap.isCaseConvertible(object.getClass()) && this.caseInsensitive) {
                    K k2 = this.keyMap.get(this.toLowerCase(object));
                    if (k2 == null) {
                        return null;
                    }
                    return this.targetMap.get(k2);
                }
                return this.targetMap.get(object);
            }

            @Override
            public V put(K k2, V v2) {
                K k3;
                if (k2 != null && this.caseInsensitive && (k3 = this.keyMap.put(this.toLowerCase(k2), k2)) != null) {
                    Object v3 = this.targetMap.remove(k3);
                    this.targetMap.put(k2, v2);
                    return v3;
                }
                return this.targetMap.put(k2, v2);
            }

            @Override
            public V remove(Object object) {
                if (object != null && this.caseInsensitive) {
                    K k2 = this.keyMap.remove(this.toLowerCase(object));
                    if (k2 == null) {
                        return null;
                    }
                    return this.targetMap.remove(k2);
                }
                return this.targetMap.remove(object);
            }

            @Override
            public void clear() {
                this.targetMap.clear();
                this.keyMap.clear();
            }

            @Override
            public Set<K> keySet() {
                return this.keySet;
            }

            @Override
            public Collection<V> values() {
                return this.targetMap.values();
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return this.targetMap.entrySet();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CaseAwareKeySet
            extends AbstractSet<K> {
                CaseAwareKeySet() {
                }

                @Override
                public boolean contains(Object object) {
                    return CaseAwareLinkedMap.this.containsKey(object);
                }

                @Override
                public Iterator<K> iterator() {
                    return CaseAwareLinkedMap.this.targetMap.keySet().iterator();
                }

                @Override
                public int size() {
                    return CaseAwareLinkedMap.this.targetMap.keySet().size();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ISetter {
            public <T> T set(T var1) throws Exception;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IGetter {
            public <T> T get() throws Exception;
        }

        public static interface IScoped {
            public IScope getScope();
        }

        public static interface IScope
        extends IGetter,
        ISetter {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Comparable<Range> {
        @Deprecated
        public final int min;
        @Deprecated
        public final int max;
        @Deprecated
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;
        private final boolean relative;
        private final int anchor;

        public Range(int n2, int n3, boolean bl2, boolean bl3, String string) {
            if (n2 < 0 || n3 < 0) {
                throw new InitializationException("Invalid negative range (min=" + n2 + ", max=" + n3 + ")");
            }
            if (n2 > n3) {
                throw new InitializationException("Invalid range (min=" + n2 + ", max=" + n3 + ")");
            }
            this.min = n2;
            this.max = n3;
            this.isVariable = bl2;
            this.isUnspecified = bl3;
            this.originalValue = string;
            boolean bl4 = this.relative = string != null && string.contains("+");
            this.anchor = this.relative ? ("+".equals(string) ? Integer.MAX_VALUE : Range.parseInt(string, Integer.MAX_VALUE)) : n2;
        }

        public static Range optionArity(Field field) {
            return Range.optionArity(new Model.TypedMember(field));
        }

        private static Range optionArity(Model.IAnnotatedElement iAnnotatedElement) {
            return iAnnotatedElement.isAnnotationPresent(Option.class) ? Range.adjustForType(Range.valueOf(iAnnotatedElement.getAnnotation(Option.class).arity()), iAnnotatedElement) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return Range.parameterArity(new Model.TypedMember(field));
        }

        private static Range parameterArity(Model.IAnnotatedElement iAnnotatedElement) {
            if (iAnnotatedElement.isAnnotationPresent(Parameters.class)) {
                return Range.adjustForType(Range.valueOf(iAnnotatedElement.getAnnotation(Parameters.class).arity()), iAnnotatedElement);
            }
            return iAnnotatedElement.isMethodParameter() ? Range.adjustForType(Range.valueOf(""), iAnnotatedElement) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return Range.parameterIndex(new Model.TypedMember(field));
        }

        private static Range parameterIndex(Model.IAnnotatedElement iAnnotatedElement) {
            if (iAnnotatedElement.isAnnotationPresent(Parameters.class)) {
                Range range = Range.valueOf(iAnnotatedElement.getAnnotation(Parameters.class).index());
                if (!range.isUnspecified) {
                    return range;
                }
            }
            if (iAnnotatedElement.isMethodParameter()) {
                int n2 = iAnnotatedElement.getMethodParamPosition();
                int n3 = iAnnotatedElement.isMultiValue() ? Integer.MAX_VALUE : n2;
                return new Range(n2, n3, iAnnotatedElement.isMultiValue(), false, null);
            }
            return Range.defaultParameterIndex(iAnnotatedElement.getTypeInfo());
        }

        private static Range defaultParameterIndex(Model.ITypeInfo iTypeInfo) {
            return Range.valueOf(iTypeInfo.isMultiValue() ? "*" : "0+");
        }

        static Range adjustForType(Range range, Model.IAnnotatedElement iAnnotatedElement) {
            return range.isUnspecified ? Range.defaultArity(iAnnotatedElement) : range;
        }

        public static Range defaultArity(Field field) {
            return Range.defaultArity(new Model.TypedMember(field));
        }

        private static Range defaultArity(Model.IAnnotatedElement iAnnotatedElement) {
            if (iAnnotatedElement.isInteractive()) {
                return Range.valueOf("0").unspecified(true);
            }
            Model.ITypeInfo iTypeInfo = iAnnotatedElement.getTypeInfo();
            if (iAnnotatedElement.isAnnotationPresent(Option.class)) {
                boolean bl2 = iTypeInfo.isBoolean() || iTypeInfo.isMultiValue() && iTypeInfo.getAuxiliaryTypeInfos().get(0).isBoolean();
                return bl2 ? Range.valueOf("0").unspecified(true) : Range.valueOf("1").unspecified(true);
            }
            if (iTypeInfo.isMultiValue()) {
                return Range.valueOf("0..1").unspecified(true);
            }
            return Range.valueOf("1").unspecified(true);
        }

        @Deprecated
        public static Range defaultArity(Class<?> clazz) {
            return CommandLine.isBoolean(clazz) ? Range.valueOf("0").unspecified(true) : Range.valueOf("1").unspecified(true);
        }

        private int size() {
            return this.isRelative() ? 1 : 1 + this.max - this.min;
        }

        static Range parameterCapacity(Model.IAnnotatedElement iAnnotatedElement) {
            Range range = Range.parameterArity(iAnnotatedElement);
            if (!iAnnotatedElement.isMultiValue()) {
                return range;
            }
            Range range2 = Range.parameterIndex(iAnnotatedElement);
            return Range.parameterCapacity(range, range2);
        }

        private static Range parameterCapacity(Range range, Range range2) {
            if (range.max == 0) {
                return range;
            }
            if (range2.size() == 1) {
                return range;
            }
            if (range2.isVariable) {
                return Range.valueOf(range.min + "..*");
            }
            if (range.size() == 1) {
                return Range.valueOf(range.min * range2.size() + "");
            }
            if (range.isVariable) {
                return Range.valueOf(range.min * range2.size() + "..*");
            }
            return Range.valueOf(range.min * range2.size() + ".." + range.max * range2.size());
        }

        public static Range valueOf(String string) {
            boolean bl2;
            int n2;
            int n3;
            if (string.contains("${")) {
                return new Range(0, 0, false, false, string);
            }
            boolean bl3 = (string = string.trim()).length() == 0 || string.startsWith("..");
            int n4 = string.indexOf("..");
            if (n4 >= 0) {
                n3 = Range.parseInt(string.substring(0, n4), 0);
                n2 = Range.parseInt(string.substring(n4 + 2), Integer.MAX_VALUE);
                bl2 = n2 == Integer.MAX_VALUE;
            } else {
                n2 = Range.parseInt(string, Integer.MAX_VALUE);
                bl2 = !string.contains("+") && n2 == Integer.MAX_VALUE;
                n3 = bl2 ? 0 : n2;
            }
            return new Range(n3, n2, bl2, bl3, bl3 ? null : string);
        }

        private static int parseInt(String string, int n2) {
            try {
                int n3 = string.indexOf(43);
                return Integer.parseInt(n3 < 0 ? string : string.substring(0, string.indexOf(43)));
            }
            catch (Exception exception) {
                return n2;
            }
        }

        public Range min(int n2) {
            return new Range(n2, Math.max(n2, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int n2) {
            return new Range(Math.min(this.min, n2), n2, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range unspecified(boolean bl2) {
            return new Range(this.min, this.max, this.isVariable, bl2, this.originalValue);
        }

        public boolean isUnspecified() {
            return this.isUnspecified;
        }

        public boolean isUnresolved() {
            return this.originalValue != null && this.originalValue.contains("${");
        }

        public boolean isRelative() {
            return this.relative;
        }

        int anchor() {
            return this.anchor;
        }

        boolean isRelativeToAnchor() {
            return this.anchor != Integer.MAX_VALUE && this.isRelative();
        }

        public String originalValue() {
            return this.originalValue;
        }

        public int min() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public boolean isVariable() {
            return this.isVariable;
        }

        public boolean contains(int n2) {
            return this.min <= n2 && this.max >= n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range range = (Range)object;
            return range.max == this.max && range.min == this.min && range.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            if (this.isUnresolved()) {
                return this.originalValue;
            }
            if (this.min == this.max) {
                return this.relative && this.min == Integer.MAX_VALUE ? "+" : String.valueOf(this.min);
            }
            return this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        String internalToString() {
            if (this.isUnresolved()) {
                return this.originalValue;
            }
            return this.isRelative() ? this.originalValue + " (" + this.toString() + ")" : this.toString();
        }

        @Override
        public int compareTo(Range range) {
            int n2;
            if (this.originalValue != null && range.originalValue != null && this.originalValue.equals(range.originalValue)) {
                return 0;
            }
            int n3 = this.anchor() < range.anchor() ? -1 : (n2 = this.anchor() == range.anchor() ? 0 : 1);
            if (n2 == 0) {
                int n4 = this.max < range.max ? -1 : (n2 = this.max == range.max ? 0 : 1);
            }
            if (n2 == 0 && this.isRelative() != range.isRelative()) {
                n2 = this.isRelative() ? 1 : -1;
            }
            return n2;
        }

        boolean isValidForInteractiveArgs() {
            return this.min == 0 && (this.max == 0 || this.max == 1);
        }

        boolean overlaps(Range range) {
            return this.contains(range.min) || this.contains(range.max) || range.contains(this.min) || range.contains(this.max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFactory
    implements IFactory {
        static Class<?> GROOVY_CLOSURE_CLASS = DefaultFactory.loadClosureClass();

        private DefaultFactory() {
        }

        private static Class<?> loadClosureClass() {
            if (Boolean.getBoolean("picocli.disable.closures")) {
                CommandLine.tracer().info("DefaultFactory: groovy Closures in annotations are disabled and will not be loaded", new Object[0]);
                return null;
            }
            try {
                return Class.forName("groovy.lang.Closure");
            }
            catch (Exception exception) {
                return null;
            }
        }

        public <T> T create(Class<T> clazz) throws Exception {
            if (GROOVY_CLOSURE_CLASS != null && GROOVY_CLOSURE_CLASS.isAssignableFrom(clazz)) {
                Callable callable = (Callable)Callable.class.cast(clazz.getConstructor(Object.class, Object.class).newInstance(null, null));
                try {
                    return (T)callable.call();
                }
                catch (Exception exception) {
                    throw new InitializationException("Error in Groovy closure: " + exception);
                }
            }
            if (clazz.isInterface()) {
                if (Collection.class.isAssignableFrom(clazz)) {
                    if (List.class.isAssignableFrom(clazz)) {
                        return clazz.cast(new ArrayList());
                    }
                    if (SortedSet.class.isAssignableFrom(clazz)) {
                        return clazz.cast(new TreeSet());
                    }
                    if (Set.class.isAssignableFrom(clazz)) {
                        return clazz.cast(new LinkedHashSet());
                    }
                    if (Queue.class.isAssignableFrom(clazz)) {
                        return clazz.cast(new LinkedList());
                    }
                    return clazz.cast(new ArrayList());
                }
                if (SortedMap.class.isAssignableFrom(clazz)) {
                    return clazz.cast(new TreeMap());
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    return clazz.cast(new LinkedHashMap());
                }
            }
            try {
                T t2 = clazz.newInstance();
                return t2;
            }
            catch (Exception exception) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
            }
        }

        private static ITypeConverter<?>[] createConverter(IFactory iFactory, Class<? extends ITypeConverter<?>>[] classArray) {
            ITypeConverter[] iTypeConverterArray = new ITypeConverter[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                iTypeConverterArray[i2] = DefaultFactory.create(iFactory, classArray[i2]);
            }
            return iTypeConverterArray;
        }

        static IVersionProvider createVersionProvider(IFactory iFactory, Class<? extends IVersionProvider> clazz) {
            return DefaultFactory.create(iFactory, clazz);
        }

        static IDefaultValueProvider createDefaultValueProvider(IFactory iFactory, Class<? extends IDefaultValueProvider> clazz) {
            return DefaultFactory.create(iFactory, clazz);
        }

        static Iterable<String> createCompletionCandidates(IFactory iFactory, Class<? extends Iterable<String>> clazz) {
            return DefaultFactory.create(iFactory, clazz);
        }

        static IParameterConsumer createParameterConsumer(IFactory iFactory, Class<? extends IParameterConsumer> clazz) {
            return DefaultFactory.create(iFactory, clazz);
        }

        static <T> T create(IFactory iFactory, Class<T> clazz) {
            try {
                return iFactory.create(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InitializationException("Cannot instantiate " + clazz.getName() + ": the class has no constructor", noSuchMethodException);
            }
            catch (InitializationException initializationException) {
                throw initializationException;
            }
            catch (Exception exception) {
                throw new InitializationException("Could not instantiate " + clazz + ": " + exception, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFactory {
        public <K> K create(Class<K> var1) throws Exception;
    }

    private static class DefaultHelpFactory
    implements IHelpFactory {
        private DefaultHelpFactory() {
        }

        public Help create(Model.CommandSpec commandSpec, Help.ColorScheme colorScheme) {
            return new Help(commandSpec, colorScheme);
        }
    }

    public static interface IHelpFactory {
        public Help create(Model.CommandSpec var1, Help.ColorScheme var2);
    }

    public static class RegexTransformer
    implements INegatableOptionTransformer {
        final Map<Pattern, String> replacements;
        final Map<Pattern, String> synopsis;

        RegexTransformer(Builder builder) {
            this.replacements = Collections.unmodifiableMap(new LinkedHashMap<Pattern, String>(builder.replacements));
            this.synopsis = Collections.unmodifiableMap(new LinkedHashMap<Pattern, String>(builder.synopsis));
        }

        public static RegexTransformer createDefault() {
            RegexTransformer regexTransformer = new Builder().addPattern("^--no-(\\w(-|\\w)*)$", "--$1", "--[no-]$1").addPattern("^--(\\w(-|\\w)*)$", "--no-$1", "--[no-]$1").addPattern("^(-|--)(\\w*:)\\+(\\w(-|\\w)*)$", "$1$2-$3", "$1$2(+|-)$3").addPattern("^(-|--)(\\w*:)\\-(\\w(-|\\w)*)$", "$1$2+$3", "$1$2(+|-)$3").build();
            return regexTransformer;
        }

        public static RegexTransformer createCaseInsensitive() {
            RegexTransformer regexTransformer = new Builder().addPattern("^--((?i)no)-(\\w(-|\\w)*)$", "--$2", "--[$1-]$2").addPattern("^--(\\w(-|\\w)*)$", "--no-$1", "--[no-]$1").addPattern("^(-|--)(\\w*:)\\+(\\w(-|\\w)*)$", "$1$2-$3", "$1$2(+|-)$3").addPattern("^(-|--)(\\w*:)\\-(\\w(-|\\w)*)$", "$1$2+$3", "$1$2(+|-)$3").build();
            return regexTransformer;
        }

        public String makeNegative(String string, Model.CommandSpec commandSpec) {
            for (Map.Entry<Pattern, String> entry : this.replacements.entrySet()) {
                Matcher matcher = entry.getKey().matcher(string);
                if (!matcher.find()) continue;
                return matcher.replaceAll(entry.getValue());
            }
            return string;
        }

        public String makeSynopsis(String string, Model.CommandSpec commandSpec) {
            for (Map.Entry<Pattern, String> entry : this.synopsis.entrySet()) {
                Matcher matcher = entry.getKey().matcher(string);
                if (!matcher.find()) continue;
                return matcher.replaceAll(entry.getValue());
            }
            return string;
        }

        public String toString() {
            return this.getClass().getName() + "[replacements=" + this.replacements + ", synopsis=" + this.synopsis + "]@" + System.identityHashCode(this);
        }

        public static class Builder {
            Map<Pattern, String> replacements = new LinkedHashMap<Pattern, String>();
            Map<Pattern, String> synopsis = new LinkedHashMap<Pattern, String>();

            public Builder() {
            }

            public Builder(RegexTransformer regexTransformer) {
                this.replacements.putAll(regexTransformer.replacements);
                this.synopsis.putAll(regexTransformer.synopsis);
            }

            public Builder addPattern(String string, String string2, String string3) {
                Pattern pattern = Pattern.compile(string);
                this.replacements.put(pattern, string2);
                this.synopsis.put(pattern, string3);
                return this;
            }

            public Builder removePattern(String string) {
                Iterator<Pattern> iterator = this.replacements.keySet().iterator();
                while (iterator.hasNext()) {
                    Pattern pattern = iterator.next();
                    if (!pattern.toString().equals(string)) continue;
                    iterator.remove();
                    this.synopsis.remove(pattern);
                }
                return this;
            }

            public RegexTransformer build() {
                return new RegexTransformer(this);
            }
        }
    }

    public static interface INegatableOptionTransformer {
        public String makeNegative(String var1, Model.CommandSpec var2);

        public String makeSynopsis(String var1, Model.CommandSpec var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpParameterPreprocessor
    implements IParameterPreprocessor {
        private NoOpParameterPreprocessor() {
        }

        @Override
        public boolean preprocess(Stack<String> stack, Model.CommandSpec commandSpec, Model.ArgSpec argSpec, Map<String, Object> map) {
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof NoOpParameterPreprocessor;
        }

        public int hashCode() {
            return NoOpParameterPreprocessor.class.hashCode() + 7;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParameterPreprocessor {
        public boolean preprocess(Stack<String> var1, Model.CommandSpec var2, Model.ArgSpec var3, Map<String, Object> var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullParameterConsumer
    implements IParameterConsumer {
        private NullParameterConsumer() {
        }

        @Override
        public void consumeParameters(Stack<String> stack, Model.ArgSpec argSpec, Model.CommandSpec commandSpec) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParameterConsumer {
        public void consumeParameters(Stack<String> var1, Model.ArgSpec var2, Model.CommandSpec var3);
    }

    private static class NoDefaultProvider
    implements IDefaultValueProvider {
        private NoDefaultProvider() {
        }

        public String defaultValue(Model.ArgSpec argSpec) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IDefaultValueProvider {
        public String defaultValue(Model.ArgSpec var1) throws Exception;
    }

    private static class NoOpModelTransformer
    implements IModelTransformer {
        private NoOpModelTransformer() {
        }

        public Model.CommandSpec transform(Model.CommandSpec commandSpec) {
            return commandSpec;
        }
    }

    public static interface IModelTransformer {
        public Model.CommandSpec transform(Model.CommandSpec var1);
    }

    private static class NoVersionProvider
    implements IVersionProvider {
        private NoVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UseDefaultConverter
    implements ITypeConverter<Object> {
        @Override
        public Object convert(String string) throws Exception {
            throw new UnsupportedOperationException("This method should never be called.");
        }
    }

    public static interface IVersionProvider {
        public String[] getVersion() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface ArgGroup {
        public String heading() default "__no_heading__";

        public String headingKey() default "__no_heading_key__";

        public boolean exclusive() default true;

        public String multiplicity() default "0..1";

        public boolean validate() default true;

        public int order() default -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.FIELD, ElementType.PACKAGE, ElementType.METHOD})
    public static @interface Command {
        public String name() default "<main class>";

        public String[] aliases() default {};

        public Class<?>[] subcommands() default {};

        public boolean subcommandsRepeatable() default false;

        public boolean addMethodSubcommands() default true;

        public String separator() default "=";

        public String[] version() default {};

        public Class<? extends IVersionProvider> versionProvider() default NoVersionProvider.class;

        public boolean mixinStandardHelpOptions() default false;

        public boolean helpCommand() default false;

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String synopsisSubcommandLabel() default "[COMMAND]";

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public boolean sortSynopsis() default true;

        public char requiredOptionMarker() default 32;

        public Class<? extends IDefaultValueProvider> defaultValueProvider() default NoDefaultProvider.class;

        public boolean showDefaultValues() default false;

        public boolean showAtFileInUsageHelp() default false;

        public boolean showEndOfOptionsDelimiterInUsageHelp() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};

        public boolean hidden() default false;

        public String resourceBundle() default "";

        public int usageHelpWidth() default 80;

        public boolean usageHelpAutoWidth() default false;

        public int exitCodeOnSuccess() default 0;

        public int exitCodeOnUsageHelp() default 0;

        public int exitCodeOnVersionHelp() default 0;

        public int exitCodeOnInvalidInput() default 2;

        public int exitCodeOnExecutionException() default 1;

        public String exitCodeListHeading() default "";

        public String[] exitCodeList() default {};

        public ScopeType scope() default ScopeType.LOCAL;

        public Class<? extends IModelTransformer> modelTransformer() default NoOpModelTransformer.class;

        public Class<? extends IParameterPreprocessor> preprocessor() default NoOpParameterPreprocessor.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @java.lang.annotation.Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Spec {
        public Target value() default Target.SELF;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Target {
            SELF,
            MIXEE;

        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Mixin {
        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Unmatched {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParentCommand {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Parameters {
        public static final String NULL_VALUE = "_NULL_";

        public String index() default "";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public String splitSynopsisLabel() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public boolean echo() default false;

        public String prompt() default "";

        public String descriptionKey() default "";

        public ScopeType scope() default ScopeType.LOCAL;

        public Class<? extends IParameterConsumer> parameterConsumer() default NullParameterConsumer.class;

        public String mapFallbackValue() default "__unspecified__";

        public Class<? extends IParameterPreprocessor> preprocessor() default NoOpParameterPreprocessor.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    public static @interface Option {
        public static final String NULL_VALUE = "_NULL_";

        public String[] names();

        public boolean required() default false;

        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public boolean hideParamSyntax() default false;

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public String splitSynopsisLabel() default "";

        public boolean hidden() default false;

        public String defaultValue() default "__no_default_value__";

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;

        public Class<? extends Iterable<String>> completionCandidates() default NoCompletionCandidates.class;

        public boolean interactive() default false;

        public boolean echo() default false;

        public String prompt() default "";

        public String descriptionKey() default "";

        public int order() default -1;

        public boolean negatable() default false;

        public ScopeType scope() default ScopeType.LOCAL;

        public String fallbackValue() default "";

        public String mapFallbackValue() default "__unspecified__";

        public Class<? extends IParameterConsumer> parameterConsumer() default NullParameterConsumer.class;

        public Class<? extends IParameterPreprocessor> preprocessor() default NoOpParameterPreprocessor.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeType {
        LOCAL,
        INHERIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoCompletionCandidates
    implements Iterable<String> {
        private NoCompletionCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAll
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public int execute(ParseResult parseResult) throws ExecutionException {
            return super.execute(parseResult);
        }

        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            ArrayList arrayList = new ArrayList();
            for (CommandLine commandLine : list) {
                CommandLine.executeUserObject(commandLine, arrayList);
            }
            return this.returnResultOrExit(arrayList);
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            Tracer tracer = CommandLine.tracer();
            return this.returnResultOrExit(this.recursivelyExecuteUserObject(parseResult, new ArrayList<Object>(), tracer));
        }

        private List<Object> recursivelyExecuteUserObject(ParseResult parseResult, List<Object> list, Tracer tracer) throws ExecutionException {
            tracer.debug("%s: executing user object for '%s'...", this.getClass().getSimpleName(), parseResult.commandSpec.qualifiedName());
            CommandLine.executeUserObject(parseResult.commandSpec().commandLine(), list);
            for (ParseResult parseResult2 : parseResult.subcommands()) {
                this.recursivelyExecuteUserObject(parseResult2, list, tracer);
            }
            return list;
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            return this.recursivelyExtractExitCodeGenerators(parseResult, new ArrayList<IExitCodeGenerator>());
        }

        private List<IExitCodeGenerator> recursivelyExtractExitCodeGenerators(ParseResult parseResult, List<IExitCodeGenerator> list) throws ExecutionException {
            if (parseResult.commandSpec().userObject() instanceof IExitCodeGenerator) {
                list.add((IExitCodeGenerator)parseResult.commandSpec().userObject());
            }
            for (ParseResult parseResult2 : parseResult.subcommands()) {
                this.recursivelyExtractExitCodeGenerators(parseResult2, list);
            }
            return list;
        }

        @Override
        protected RunAll self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunLast
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public int execute(ParseResult parseResult) throws ExecutionException {
            return super.execute(parseResult);
        }

        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(RunLast.executeUserObjectOfLastSubcommandWithSameParent(list));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            return RunLast.executeUserObjectOfLastSubcommandWithSameParent(parseResult.asCommandLineList());
        }

        private static List<Object> executeUserObjectOfLastSubcommandWithSameParent(List<CommandLine> list) {
            Tracer tracer = CommandLine.tracer();
            int n2 = RunLast.indexOfLastSubcommandWithSameParent(list);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = n2; i2 < list.size(); ++i2) {
                tracer.debug("RunLast: executing user object for '%s'...", list.get(i2).commandSpec.qualifiedName());
                CommandLine.executeUserObject(list.get(i2), arrayList);
            }
            return arrayList;
        }

        private static int indexOfLastSubcommandWithSameParent(List<CommandLine> list) {
            int n2 = list.size() - 1;
            int n3 = list.size() - 2;
            while (n3 >= 0 && list.get(n3).getParent() == list.get(n3 + 1).getParent()) {
                n2 = n3--;
            }
            return n2;
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            List<CommandLine> list = parseResult.asCommandLineList();
            int n2 = RunLast.indexOfLastSubcommandWithSameParent(list);
            ArrayList<IExitCodeGenerator> arrayList = new ArrayList<IExitCodeGenerator>();
            for (int i2 = n2; i2 < list.size(); ++i2) {
                Object object = list.get(i2).getCommandSpec().userObject();
                if (!(object instanceof IExitCodeGenerator)) continue;
                arrayList.add((IExitCodeGenerator)object);
            }
            return arrayList;
        }

        @Override
        protected RunLast self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunFirst
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public int execute(ParseResult parseResult) throws ExecutionException {
            return super.execute(parseResult);
        }

        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.executeUserObject(list.get(0), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            Tracer tracer = CommandLine.tracer();
            tracer.debug("RunFirst: executing user object for '%s'...", parseResult.commandSpec().qualifiedName());
            return CommandLine.executeUserObject(parseResult.commandSpec().commandLine(), new ArrayList());
        }

        @Override
        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            if (parseResult.commandSpec().userObject() instanceof IExitCodeGenerator) {
                return Collections.singletonList((IExitCodeGenerator)parseResult.commandSpec().userObject());
            }
            return Collections.emptyList();
        }

        @Override
        protected RunFirst self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class AbstractParseResultHandler<R>
    extends AbstractHandler<R, AbstractParseResultHandler<R>>
    implements IParseResultHandler2<R>,
    IExecutionStrategy {
        @Override
        public R handleParseResult(ParseResult parseResult) throws ExecutionException {
            if (CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), this.out(), this.err(), this.colorScheme())) {
                return this.returnResultOrExit(null);
            }
            return this.returnResultOrExit(this.handle(parseResult));
        }

        @Override
        public int execute(ParseResult parseResult) throws ExecutionException {
            Integer n2 = CommandLine.executeHelpRequest(parseResult);
            if (n2 != null) {
                return n2;
            }
            Tracer tracer = CommandLine.tracer();
            tracer.debug("%s: handling ParseResult...", this.getClass().getSimpleName());
            R r2 = this.handle(parseResult);
            List<IExitCodeGenerator> list = this.extractExitCodeGenerators(parseResult);
            tracer.debug("%s: ParseResult has %s exit code generators", this.getClass().getSimpleName(), list.size());
            return this.resolveExitCode(parseResult.commandSpec().exitCodeOnSuccess(), r2, list);
        }

        private int resolveExitCode(int n2, R r2, List<IExitCodeGenerator> list) {
            int n3 = 0;
            for (IExitCodeGenerator object : list) {
                try {
                    int exception = object.getExitCode();
                    if ((exception <= 0 || exception <= n3) && (exception >= n3 || n3 > 0)) continue;
                    n3 = exception;
                }
                catch (Exception iterator) {
                    n3 = n3 == 0 ? 1 : n3;
                    iterator.printStackTrace();
                }
            }
            Tracer tracer = CommandLine.tracer();
            tracer.debug("resolveExitCode: exit code generators resulted in exit code=%d", n3);
            if (r2 instanceof List) {
                List list2 = (List)r2;
                for (Object e2 : list2) {
                    int n4;
                    if (!(e2 instanceof Integer) || ((n4 = ((Integer)e2).intValue()) <= 0 || n4 <= n3) && (n4 >= n3 || n3 > 0)) continue;
                    n3 = n4;
                }
            }
            tracer.debug("resolveExitCode: execution results resulted in exit code=%d", n3);
            tracer.debug("resolveExitCode: returning exit code=%d", n3 == 0 ? n2 : n3);
            return n3 == 0 ? n2 : n3;
        }

        protected abstract R handle(ParseResult var1) throws ExecutionException;

        protected List<IExitCodeGenerator> extractExitCodeGenerators(ParseResult parseResult) {
            return Collections.emptyList();
        }
    }

    static class ColoredStackTraceWriter
    extends StringWriter {
        Help.ColorScheme colorScheme;

        public ColoredStackTraceWriter(Help.ColorScheme colorScheme) {
            this.colorScheme = colorScheme;
        }

        public void write(String string, int n2, int n3) {
            List<Help.Ansi.IStyle> list = string.startsWith("\t") ? this.colorScheme.stackTraceStyles() : this.colorScheme.errorStyles();
            super.write(this.colorScheme.apply(string.substring(n2, n3), list).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class DefaultExceptionHandler<R>
    extends AbstractHandler<R, DefaultExceptionHandler<R>>
    implements IExceptionHandler,
    IExceptionHandler2<R> {
        @Override
        public List<Object> handleException(ParameterException parameterException, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
            DefaultExceptionHandler.internalHandleParseException(parameterException, CommandLine.newPrintWriter(printStream, CommandLine.getStdoutEncoding()), Help.defaultColorScheme(ansi));
            return Collections.emptyList();
        }

        @Override
        public R handleParseException(ParameterException parameterException, String[] stringArray) {
            DefaultExceptionHandler.internalHandleParseException(parameterException, CommandLine.newPrintWriter(this.err(), CommandLine.getStderrEncoding()), this.colorScheme());
            return this.returnResultOrExit(null);
        }

        static void internalHandleParseException(ParameterException parameterException, PrintWriter printWriter, Help.ColorScheme colorScheme) {
            Tracer tracer;
            printWriter.println(colorScheme.errorText(parameterException.getMessage()));
            if (!UnmatchedArgumentException.printSuggestions(parameterException, printWriter)) {
                parameterException.getCommandLine().usage(printWriter, colorScheme);
            }
            if ((tracer = CommandLine.tracer()).isDebug()) {
                parameterException.printStackTrace(tracer.stream);
            }
        }

        @Override
        public R handleExecutionException(ExecutionException executionException, ParseResult parseResult) {
            return this.throwOrExit(executionException);
        }

        @Override
        protected DefaultExceptionHandler<R> self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class AbstractHandler<R, T extends AbstractHandler<R, T>> {
        private Help.ColorScheme colorScheme = Help.defaultColorScheme(Help.Ansi.AUTO);
        private Integer exitCode;
        private PrintStream out = System.out;
        private PrintStream err = System.err;

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }

        @Deprecated
        public Help.Ansi ansi() {
            return this.colorScheme.ansi();
        }

        public Help.ColorScheme colorScheme() {
            return this.colorScheme;
        }

        public Integer exitCode() {
            return this.exitCode;
        }

        public boolean hasExitCode() {
            return this.exitCode != null;
        }

        protected R returnResultOrExit(R r2) {
            if (this.hasExitCode()) {
                this.exit(this.exitCode());
            }
            return r2;
        }

        protected R throwOrExit(ExecutionException executionException) {
            if (this.hasExitCode()) {
                executionException.printStackTrace(this.err());
                this.exit(this.exitCode());
                return null;
            }
            throw executionException;
        }

        protected void exit(int n2) {
            System.exit(n2);
        }

        protected abstract T self();

        @Deprecated
        public T useOut(PrintStream printStream) {
            this.out = Assert.notNull(printStream, "out");
            return this.self();
        }

        @Deprecated
        public T useErr(PrintStream printStream) {
            this.err = Assert.notNull(printStream, "err");
            return this.self();
        }

        @Deprecated
        public T useAnsi(Help.Ansi ansi) {
            this.colorScheme = Help.defaultColorScheme(Assert.notNull(ansi, "ansi"));
            return this.self();
        }

        @Deprecated
        public T andExit(int n2) {
            this.exitCode = n2;
            return this.self();
        }
    }

    public static interface IExecutionExceptionHandler {
        public int handleExecutionException(Exception var1, CommandLine var2, ParseResult var3) throws Exception;
    }

    public static interface IParameterExceptionHandler {
        public int handleParseException(ParameterException var1, String[] var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler2<R> {
        public R handleParseException(ParameterException var1, String[] var2);

        public R handleExecutionException(ExecutionException var1, ParseResult var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    public static interface IExecutionStrategy {
        public int execute(ParseResult var1) throws ExecutionException, ParameterException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler2<R> {
        public R handleParseResult(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }

    public static interface IExitCodeExceptionMapper {
        public int getExitCode(Throwable var1);
    }

    public static interface IExitCodeGenerator {
        public int getExitCode();
    }

    public static final class ExitCode {
        public static final int OK = 0;
        public static final int SOFTWARE = 1;
        public static final int USAGE = 2;

        private ExitCode() {
        }
    }
}

