/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.javafx.Icon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class StackedFontIcon
extends StackPane
implements Icon {
    private static final String KEY_STACKED_FONT_ICON_SIZE = StackedFontIcon.class.getName() + ".iconSize";
    private StyleableIntegerProperty iconSize;
    private StyleableObjectProperty<Paint> iconColor;
    private double[] iconSizes = new double[0];
    private ChangeListener<Number> iconSizeChangeListener = (observableValue, number, number2) -> this.setIconSizeOnChildren(number2.intValue());
    private ChangeListener<Paint> iconColorChangeListener = (observableValue, paint, paint2) -> this.setIconColorOnChildren((Paint)paint2);

    public static void setIconSize(Node node, double d2) {
        if (node != null && d2 >= 0.0 && d2 <= 1.0) {
            node.getProperties().put((Object)KEY_STACKED_FONT_ICON_SIZE, (Object)d2);
        }
    }

    public static double getIconSize(Node node) {
        Object object;
        if (node != null && (object = node.getProperties().get((Object)KEY_STACKED_FONT_ICON_SIZE)) instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 1.0;
    }

    public StackedFontIcon() {
        this.getStyleClass().setAll((Object[])new String[]{"stacked-ikonli-font-icon"});
        final String string = StackedFontIcon.class.getName() + "-" + System.identityHashCode(this);
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    if (change.wasAdded()) {
                        int n2 = change.getTo() - change.getFrom();
                        StackedFontIcon.this.iconSizes = Arrays.copyOf(StackedFontIcon.this.iconSizes, StackedFontIcon.this.iconSizes.length + n2);
                        for (int i2 = change.getFrom(); i2 < change.getTo(); ++i2) {
                            StackedFontIcon.this.iconSizes[i2] = StackedFontIcon.getIconSize((Node)change.getList().get(i2));
                        }
                        for (Node node : change.getAddedSubList()) {
                            node.getProperties().put((Object)string, (Object)new NodeSizeListener(node));
                        }
                        continue;
                    }
                    if (change.wasRemoved()) {
                        int n3;
                        int n4 = change.getTo() - change.getFrom();
                        double[] dArray = new double[StackedFontIcon.this.iconSizes.length - n4];
                        int n5 = 0;
                        for (n3 = 0; n3 < change.getFrom(); ++n3) {
                            dArray[n5++] = StackedFontIcon.this.iconSizes[n3];
                        }
                        for (n3 = change.getTo(); n3 < StackedFontIcon.this.iconSizes.length; ++n3) {
                            dArray[n5++] = StackedFontIcon.this.iconSizes[n3];
                        }
                        StackedFontIcon.this.iconSizes = dArray;
                        for (Node node : change.getRemoved()) {
                            node.getProperties().remove((Object)string);
                        }
                        continue;
                    }
                    if (!change.wasPermutated()) continue;
                    double[] dArray = Arrays.copyOf(StackedFontIcon.this.iconSizes, StackedFontIcon.this.iconSizes.length);
                    for (int i3 = change.getFrom(); i3 <= change.getTo(); ++i3) {
                        dArray[i3] = change.getPermutation(i3);
                    }
                    StackedFontIcon.this.iconSizes = dArray;
                }
            }
        });
    }

    @Override
    public IntegerProperty iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableIntegerProperty(16){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_SIZE;
                }

                public Object getBean() {
                    return StackedFontIcon.this;
                }

                public String getName() {
                    return "iconSize";
                }

                public StyleOrigin getStyleOrigin() {
                    return StyleOrigin.USER_AGENT;
                }
            };
            this.iconSize.addListener(this.iconSizeChangeListener);
        }
        return this.iconSize;
    }

    @Override
    public ObjectProperty<Paint> iconColorProperty() {
        if (this.iconColor == null) {
            this.iconColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_COLOR;
                }

                public Object getBean() {
                    return StackedFontIcon.this;
                }

                public String getName() {
                    return "iconColor";
                }

                public StyleOrigin getStyleOrigin() {
                    return StyleOrigin.USER_AGENT;
                }
            };
            this.iconColor.addListener(this.iconColorChangeListener);
        }
        return this.iconColor;
    }

    @Override
    public void setIconSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalStateException("Argument 'size' must be greater than zero.");
        }
        this.iconSizeProperty().set(n2);
    }

    @Override
    public int getIconSize() {
        return this.iconSizeProperty().get();
    }

    @Override
    public void setIconColor(Paint paint) {
        Objects.requireNonNull(paint, "Argument 'paint' must not be null");
        this.iconColorProperty().set((Object)paint);
    }

    @Override
    public Paint getIconColor() {
        return (Paint)this.iconColorProperty().get();
    }

    public void setIconCodes(Ikon ... ikonArray) {
        this.getChildren().clear();
        this.initializeSizesIfNeeded(ikonArray);
        this.updateIconCodes(ikonArray);
    }

    public void setIconCodeLiterals(String ... stringArray) {
        this.getChildren().clear();
        Ikon[] ikonArray = new Ikon[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ikonArray[i2] = IkonResolver.getInstance().resolve(stringArray[i2]).resolve(stringArray[i2]);
        }
        this.initializeSizesIfNeeded(stringArray);
        this.updateIconCodes(ikonArray);
    }

    public void setIconSizes(double ... dArray) {
        this.iconSizes = dArray;
        this.setIconSizeOnChildren(this.getIconSize());
    }

    public void setColors(Paint ... paintArray) {
        int n2 = 0;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            ((Icon)node).setIconColor(paintArray[n2++]);
        }
    }

    private void initializeSizesIfNeeded(Object[] objectArray) {
        if (this.iconSizes.length == 0 || this.iconSizes.length != objectArray.length) {
            this.iconSizes = new double[objectArray.length];
            Arrays.fill(this.iconSizes, 1.0);
        }
    }

    private void updateIconCodes(Ikon[] ikonArray) {
        for (int i2 = 0; i2 < ikonArray.length; ++i2) {
            this.getChildren().add((Object)this.createFontIcon(ikonArray[i2], i2));
        }
    }

    private FontIcon createFontIcon(Ikon ikon, int n2) {
        FontIcon fontIcon = new FontIcon(ikon);
        fontIcon.setIconSize(this.getIconSize());
        fontIcon.setIconColor(this.getIconColor());
        int n3 = fontIcon.getIconSize();
        this.applySizeToIcon(n3, fontIcon, n2);
        return fontIcon;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedFontIcon.getClassCssMetaData();
    }

    private void setIconSizeOnChildren(int n2) {
        int n3 = 0;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            this.applySizeToIcon(n2, (Icon)node, n3++);
        }
    }

    private void applySizeToIcon(int n2, Icon icon, int n3) {
        double d2 = this.iconSizes[n3];
        double d3 = (double)n2 * d2;
        icon.setIconSize((int)d3);
    }

    private void setIconColorOnChildren(Paint paint) {
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            ((Icon)node).setIconColor(paint);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedFontIcon, Number> ICON_SIZE = new CssMetaData<StackedFontIcon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)16.0){

            public boolean isSettable(StackedFontIcon stackedFontIcon) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(StackedFontIcon stackedFontIcon) {
                return (StyleableProperty)stackedFontIcon.iconSizeProperty();
            }
        };
        private static final CssMetaData<StackedFontIcon, Paint> ICON_COLOR = new CssMetaData<StackedFontIcon, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public boolean isSettable(StackedFontIcon stackedFontIcon) {
                return true;
            }

            public StyleableProperty<Paint> getStyleableProperty(StackedFontIcon stackedFontIcon) {
                return (StyleableProperty)stackedFontIcon.iconColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> arrayList = new ArrayList<Object>(StackPane.getClassCssMetaData());
            arrayList.add(ICON_SIZE);
            arrayList.add(ICON_COLOR);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private class NodeSizeListener
    implements MapChangeListener<Object, Object> {
        private Node node;

        private NodeSizeListener(Node node) {
            this.node = node;
        }

        public void onChanged(MapChangeListener.Change<?, ?> change) {
            if (KEY_STACKED_FONT_ICON_SIZE.equals(String.valueOf(change.getKey()))) {
                int n2 = StackedFontIcon.this.getChildren().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.node != StackedFontIcon.this.getChildren().get(i2)) continue;
                    double d2 = 0.0;
                    Object object = change.getValueAdded();
                    d2 = object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble(String.valueOf(object));
                    StackedFontIcon.this.iconSizes[i2] = d2;
                    return;
                }
            }
        }
    }
}

