/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.skin.NotificationBar;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.stage.Popup;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.control.action.Action;
import org.controlsfx.tools.Utils;

public class Notifications {
    private static final String STYLE_CLASS_DARK = "dark";
    private String title;
    private String text;
    private Node graphic;
    private ObservableList<Action> actions = FXCollections.observableArrayList();
    private Pos position = Pos.BOTTOM_RIGHT;
    private Duration hideAfterDuration = Duration.seconds((double)5.0);
    private boolean hideCloseButton;
    private EventHandler<ActionEvent> onAction;
    private Window owner;
    private Screen screen = null;
    private List<String> styleClass = new ArrayList<String>();
    private int threshold;
    private Notifications thresholdNotification;

    private Notifications() {
    }

    public static Notifications create() {
        return new Notifications();
    }

    public Notifications text(String string) {
        this.text = string;
        return this;
    }

    public Notifications title(String string) {
        this.title = string;
        return this;
    }

    public Notifications graphic(Node node) {
        this.graphic = node;
        return this;
    }

    public Notifications position(Pos pos) {
        this.position = pos;
        return this;
    }

    public Notifications owner(Object object) {
        if (object instanceof Screen) {
            this.screen = (Screen)object;
        } else {
            this.owner = Utils.getWindow(object);
        }
        return this;
    }

    public Notifications hideAfter(Duration duration) {
        this.hideAfterDuration = duration;
        return this;
    }

    public Notifications onAction(EventHandler<ActionEvent> eventHandler) {
        this.onAction = eventHandler;
        return this;
    }

    public Notifications darkStyle() {
        this.styleClass.add(STYLE_CLASS_DARK);
        return this;
    }

    public Notifications styleClass(String ... stringArray) {
        this.styleClass.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Notifications hideCloseButton() {
        this.hideCloseButton = true;
        return this;
    }

    public Notifications action(Action ... actionArray) {
        this.actions = actionArray == null ? FXCollections.observableArrayList() : FXCollections.observableArrayList((Object[])actionArray);
        return this;
    }

    public Notifications threshold(int n2, Notifications notifications) {
        this.threshold = n2;
        this.thresholdNotification = notifications;
        return this;
    }

    public void showWarning() {
        this.graphic((Node)new ImageView(Notifications.class.getResource("/org/controlsfx/dialog/dialog-warning.png").toExternalForm()));
        this.show();
    }

    public void showInformation() {
        this.graphic((Node)new ImageView(Notifications.class.getResource("/org/controlsfx/dialog/dialog-information.png").toExternalForm()));
        this.show();
    }

    public void showError() {
        this.graphic((Node)new ImageView(Notifications.class.getResource("/org/controlsfx/dialog/dialog-error.png").toExternalForm()));
        this.show();
    }

    public void showConfirm() {
        this.graphic((Node)new ImageView(Notifications.class.getResource("/org/controlsfx/dialog/dialog-confirm.png").toExternalForm()));
        this.show();
    }

    public void show() {
        NotificationPopupHandler.getInstance().show(this);
    }

    public List<String> getStyleClass() {
        return this.styleClass;
    }

    private static final class NotificationPopupHandler {
        private static final NotificationPopupHandler INSTANCE = new NotificationPopupHandler();
        private static final String FINAL_ANCHOR_Y = "finalAnchorY";
        private double startX;
        private double startY;
        private double screenWidth;
        private double screenHeight;
        private final Map<Pos, List<Popup>> popupsMap = new HashMap<Pos, List<Popup>>();
        private static final double PADDING = 15.0;
        private static final double SPACING = 15.0;
        private ParallelTransition parallelTransition = new ParallelTransition();
        private boolean isShowing = false;

        private NotificationPopupHandler() {
        }

        static final NotificationPopupHandler getInstance() {
            return INSTANCE;
        }

        public void show(Notifications notifications) {
            Window window;
            if (notifications.owner == null) {
                window = Utils.getWindow(null);
                Screen screen = notifications.screen != null ? notifications.screen : this.getScreenBounds(window).orElse(Screen.getPrimary());
                Rectangle2D rectangle2D = screen.getBounds();
                this.startX = rectangle2D.getMinX();
                this.startY = rectangle2D.getMinY();
                this.screenWidth = rectangle2D.getWidth();
                this.screenHeight = rectangle2D.getHeight();
            } else {
                this.startX = notifications.owner.getX();
                this.startY = notifications.owner.getY();
                this.screenWidth = notifications.owner.getWidth();
                this.screenHeight = notifications.owner.getHeight();
                window = notifications.owner;
            }
            this.show(window, notifications);
        }

        private Optional<Screen> getScreenBounds(Window window) {
            if (window == null) {
                return Optional.empty();
            }
            ObservableList observableList = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
            return observableList.stream().filter(Objects::nonNull).findFirst();
        }

        private void show(Window window, Notifications notifications) {
            Object object;
            Object object2;
            Object object3;
            Scene scene;
            Window window2 = window;
            while (window2 instanceof PopupWindow) {
                window2 = ((PopupWindow)window2).getOwnerWindow();
            }
            Scene scene2 = scene = window2 == null ? null : window2.getScene();
            if (scene != null) {
                object3 = Notifications.class.getResource("notificationpopup.css").toExternalForm();
                if (!scene.getStylesheets().contains(object3)) {
                    scene.getStylesheets().add(0, object3);
                }
            }
            object3 = new Popup();
            object3.setAutoFix(false);
            Pos pos = notifications.position;
            List<Popup> list = this.popupsMap.get(pos);
            if (notifications.threshold > 0 && list != null && list.size() >= notifications.threshold) {
                for (Popup popup : list) {
                    popup.hide();
                }
                object2 = notifications.thresholdNotification;
                if (((Notifications)object2).text == null || ((Notifications)object2).text.isEmpty()) {
                    ((Notifications)object2).text = MessageFormat.format(Localization.getString("notifications.threshold.text"), list.size());
                }
                object = object2;
            } else {
                object = notifications;
            }
            object2 = new NotificationBar((Notifications)object, (Popup)object3, pos){
                final /* synthetic */ Notifications val$notificationToShow;
                final /* synthetic */ Popup val$popup;
                final /* synthetic */ Pos val$p;
                {
                    this.val$notificationToShow = notifications;
                    this.val$popup = popup;
                    this.val$p = pos;
                }

                @Override
                public String getTitle() {
                    return this.val$notificationToShow.title;
                }

                @Override
                public String getText() {
                    return this.val$notificationToShow.text;
                }

                @Override
                public Node getGraphic() {
                    return this.val$notificationToShow.graphic;
                }

                @Override
                public ObservableList<Action> getActions() {
                    return this.val$notificationToShow.actions;
                }

                @Override
                public boolean isShowing() {
                    return isShowing;
                }

                @Override
                public boolean isShowFromTop() {
                    return this.isShowFromTop(this.val$notificationToShow.position);
                }

                @Override
                public void hide() {
                    isShowing = false;
                    this.createHideTimeline(this.val$popup, this, this.val$p, Duration.ZERO).play();
                }

                @Override
                public boolean isCloseButtonVisible() {
                    return !this.val$notificationToShow.hideCloseButton;
                }

                @Override
                public double getContainerHeight() {
                    return startY + screenHeight;
                }

                @Override
                public void relocateInParent(double d2, double d3) {
                    switch (this.val$p) {
                        case BOTTOM_LEFT: 
                        case BOTTOM_CENTER: 
                        case BOTTOM_RIGHT: {
                            this.val$popup.setAnchorY(d3 - 15.0);
                            break;
                        }
                    }
                }
            };
            object2.setMinWidth(400.0);
            object2.getStyleClass().addAll(((Notifications)object).styleClass);
            object2.setOnMouseClicked(arg_0 -> this.lambda$show$0((Notifications)object, (NotificationBar)((Object)object2), (Popup)object3, pos, arg_0));
            object3.getContent().add(object2);
            object3.show(window2, 0.0, 0.0);
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = object2.getWidth();
            double d5 = object2.getHeight();
            switch (pos) {
                case BOTTOM_LEFT: 
                case TOP_LEFT: 
                case CENTER_LEFT: {
                    d2 = 15.0 + this.startX;
                    break;
                }
                case BOTTOM_CENTER: 
                case TOP_CENTER: 
                case CENTER: {
                    d2 = this.startX + this.screenWidth / 2.0 - d4 / 2.0 - 7.5;
                    break;
                }
                default: {
                    d2 = this.startX + this.screenWidth - d4 - 15.0;
                }
            }
            switch (pos) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    d3 = 15.0 + this.startY;
                    break;
                }
                case CENTER_LEFT: 
                case CENTER: 
                case CENTER_RIGHT: {
                    d3 = this.startY + this.screenHeight / 2.0 - d5 / 2.0 - 7.5;
                    break;
                }
                default: {
                    d3 = this.startY + this.screenHeight - d5 - 15.0;
                }
            }
            object3.setAnchorX(d2);
            this.setFinalAnchorY((Popup)object3, d3);
            object3.setAnchorY(d3);
            this.isShowing = true;
            ((NotificationBar)((Object)object2)).doShow();
            this.addPopupToMap(pos, (Popup)object3);
            Timeline timeline = this.createHideTimeline((Popup)object3, (NotificationBar)((Object)object2), pos, notifications.hideAfterDuration);
            timeline.play();
        }

        private void hide(Popup popup, Pos pos) {
            popup.hide();
            this.removePopupFromMap(pos, popup);
        }

        private Timeline createHideTimeline(Popup popup, NotificationBar notificationBar, Pos pos, Duration duration) {
            KeyValue keyValue = new KeyValue((WritableValue)notificationBar.opacityProperty(), (Object)1.0);
            KeyValue keyValue2 = new KeyValue((WritableValue)notificationBar.opacityProperty(), (Object)0.0);
            KeyFrame keyFrame = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue});
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{keyValue2});
            Timeline timeline = new Timeline(new KeyFrame[]{keyFrame, keyFrame2});
            timeline.setDelay(duration);
            timeline.setOnFinished(actionEvent -> this.hide(popup, pos));
            return timeline;
        }

        private void addPopupToMap(Pos pos, Popup popup) {
            List<Object> list;
            if (!this.popupsMap.containsKey(pos)) {
                list = new LinkedList();
                this.popupsMap.put(pos, list);
            } else {
                list = this.popupsMap.get(pos);
            }
            this.doAnimation(pos, popup);
            list.add(popup);
        }

        private void removePopupFromMap(Pos pos, Popup popup) {
            if (this.popupsMap.containsKey(pos)) {
                List<Popup> list = this.popupsMap.get(pos);
                list.remove(popup);
            }
        }

        private void doAnimation(Pos pos, Popup popup) {
            Popup popup2;
            int n2;
            List<Popup> list = this.popupsMap.get(pos);
            if (list == null) {
                return;
            }
            this.parallelTransition.stop();
            this.parallelTransition.getChildren().clear();
            boolean bl2 = this.isShowFromTop(pos);
            double d2 = 0.0;
            double[] dArray = new double[list.size()];
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                popup2 = list.get(n2);
                NotificationBar notificationBar = (NotificationBar)((Object)popup2.getContent().get(0));
                double d3 = notificationBar.minHeight(notificationBar.getWidth());
                if (bl2) {
                    d2 = n2 == list.size() - 1 ? this.getFinalAnchorY(popup) + d3 + 15.0 : (d2 += d3 + 15.0);
                    dArray[n2] = d2;
                    popup2.setAnchorY(d2 - d3);
                    continue;
                }
                d2 = n2 == list.size() - 1 ? this.getFinalAnchorY(popup) - (d3 + 15.0) : (d2 -= d3 + 15.0);
                dArray[n2] = d2;
                popup2.setAnchorY(d2 + d3);
            }
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                popup2 = list.get(n2);
                popup2.setAnchorX(popup.getAnchorX());
                double d4 = dArray[n2];
                if (d4 < this.startY) {
                    popup2.hide();
                }
                double d5 = this.getFinalAnchorY(popup2);
                double d6 = d4 - d5;
                this.setFinalAnchorY(popup2, d5 + d6);
                CustomTransition customTransition = new CustomTransition(popup2, d5, d6);
                customTransition.setCycleCount(1);
                this.parallelTransition.getChildren().add((Object)customTransition);
            }
            this.parallelTransition.play();
        }

        private double getFinalAnchorY(Popup popup) {
            return (Double)popup.getProperties().get((Object)FINAL_ANCHOR_Y);
        }

        private void setFinalAnchorY(Popup popup, double d2) {
            popup.getProperties().put((Object)FINAL_ANCHOR_Y, (Object)d2);
        }

        private boolean isShowFromTop(Pos pos) {
            switch (pos) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    return true;
                }
            }
            return false;
        }

        private /* synthetic */ void lambda$show$0(Notifications notifications, NotificationBar notificationBar, Popup popup, Pos pos, MouseEvent mouseEvent) {
            if (notifications.onAction != null) {
                ActionEvent actionEvent = new ActionEvent((Object)notificationBar, (EventTarget)notificationBar);
                notifications.onAction.handle((Event)actionEvent);
                this.createHideTimeline(popup, notificationBar, pos, Duration.ZERO).play();
            }
        }

        class CustomTransition
        extends Transition {
            private WeakReference<Popup> popupWeakReference;
            private double oldAnchorY;
            private double distance;

            CustomTransition(Popup popup, double d2, double d3) {
                this.popupWeakReference = new WeakReference<Popup>(popup);
                this.oldAnchorY = d2;
                this.distance = d3;
                this.setCycleDuration(Duration.millis((double)350.0));
            }

            protected void interpolate(double d2) {
                Popup popup = (Popup)this.popupWeakReference.get();
                if (popup != null) {
                    double d3 = this.oldAnchorY + this.distance * d2;
                    popup.setAnchorY(d3);
                }
            }
        }
    }
}

