/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.generation.CharSequenceJavaFileObject;
import org.agrona.generation.ClassFileManager;

public final class CompilerUtil {
    private static final String TEMP_DIR_NAME = SystemUtil.tmpDirName();

    private CompilerUtil() {
    }

    public static Class<?> compileInMemory(String string, Map<String, CharSequence> map) throws ClassNotFoundException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (null == javaCompiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        ClassFileManager<StandardJavaFileManager> classFileManager = new ClassFileManager<StandardJavaFileManager>(javaCompiler.getStandardFileManager(null, null, null));
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, classFileManager, diagnosticCollector, null, null, CompilerUtil.wrap(map));
        return CompilerUtil.compileAndLoad(string, diagnosticCollector, classFileManager, compilationTask);
    }

    public static Class<?> compileOnDisk(String string, Map<String, CharSequence> map) throws ClassNotFoundException, IOException {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (null == javaCompiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        try (StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);){
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("-classpath", System.getProperty("java.class.path") + File.pathSeparator + TEMP_DIR_NAME));
            Collection<File> collection = CompilerUtil.persist(map);
            Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(collection);
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, standardJavaFileManager, diagnosticCollector, arrayList, null, iterable);
            Class<?> clazz = CompilerUtil.compileAndLoad(string, diagnosticCollector, standardJavaFileManager, compilationTask);
            return clazz;
        }
    }

    public static Class<?> compileAndLoad(String string, DiagnosticCollector<JavaFileObject> diagnosticCollector, JavaFileManager javaFileManager, JavaCompiler.CompilationTask compilationTask) throws ClassNotFoundException {
        if (!CompilerUtil.compile(diagnosticCollector, compilationTask)) {
            return null;
        }
        return javaFileManager.getClassLoader(null).loadClass(string);
    }

    public static boolean compile(DiagnosticCollector<JavaFileObject> diagnosticCollector, JavaCompiler.CompilationTask compilationTask) {
        Boolean bl2 = compilationTask.call();
        if (!bl2.booleanValue()) {
            for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
                System.err.println(diagnostic.getCode());
                System.err.println((Object)diagnostic.getKind());
                JavaFileObject javaFileObject = diagnostic.getSource();
                System.err.printf("Line = %d, Col = %d, File = %s", diagnostic.getLineNumber(), diagnostic.getColumnNumber(), javaFileObject);
                System.err.println("Start: " + diagnostic.getStartPosition());
                System.err.println("End: " + diagnostic.getEndPosition());
                System.err.println("Pos: " + diagnostic.getPosition());
                try {
                    String string = javaFileObject.getCharContent(true).toString();
                    int n2 = string.lastIndexOf(10, (int)diagnostic.getStartPosition());
                    int n3 = string.indexOf(10, (int)diagnostic.getEndPosition());
                    System.err.println(diagnostic.getMessage(null));
                    System.err.println(string.substring(Math.max(0, n2), n3));
                }
                catch (IOException iOException) {
                    LangUtil.rethrowUnchecked(iOException);
                }
            }
        }
        return bl2;
    }

    public static Collection<File> persist(Map<String, CharSequence> map) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>(map.size());
        for (Map.Entry<String, CharSequence> entry : map.entrySet()) {
            String string;
            String string2 = string = entry.getKey();
            Path path = Paths.get(TEMP_DIR_NAME, new String[0]);
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string2 = string.substring(n2 + 1);
                path = Paths.get(TEMP_DIR_NAME + string.substring(0, n2).replace('.', File.separatorChar), new String[0]);
                Files.createDirectories(path, new FileAttribute[0]);
            }
            File file = new File(path.toString(), string2 + ".java");
            arrayList.add(file);
            FileWriter fileWriter = new FileWriter(file);
            Throwable throwable = null;
            try {
                fileWriter.append(entry.getValue());
                fileWriter.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileWriter == null) continue;
                if (throwable != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileWriter.close();
            }
        }
        return arrayList;
    }

    private static Collection<CharSequenceJavaFileObject> wrap(Map<String, CharSequence> map) {
        return map.entrySet().stream().map(entry -> new CharSequenceJavaFileObject((String)entry.getKey(), (CharSequence)entry.getValue())).collect(Collectors.toList());
    }
}

