/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntArrayList;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class CountersManager
extends CountersReader {
    private final long freeToReuseTimeoutMs;
    private int highWaterMarkId = -1;
    private final IntArrayList freeList = new IntArrayList();
    private final EpochClock epochClock;

    public CountersManager(AtomicBuffer atomicBuffer, AtomicBuffer atomicBuffer2, Charset charset, EpochClock epochClock, long l2) {
        super(atomicBuffer, atomicBuffer2, charset);
        atomicBuffer2.verifyAlignment();
        this.epochClock = epochClock;
        this.freeToReuseTimeoutMs = l2;
        if (atomicBuffer.capacity() < atomicBuffer2.capacity() * 4) {
            throw new IllegalArgumentException("metadata buffer is too small");
        }
    }

    public CountersManager(AtomicBuffer atomicBuffer, AtomicBuffer atomicBuffer2, Charset charset) {
        this(atomicBuffer, atomicBuffer2, charset, new CachedEpochClock(), 0L);
    }

    public CountersManager(AtomicBuffer atomicBuffer, AtomicBuffer atomicBuffer2) {
        this(atomicBuffer, atomicBuffer2, StandardCharsets.UTF_8, new CachedEpochClock(), 0L);
    }

    public int capacity() {
        return this.maxCounterId + 1;
    }

    public int available() {
        int n2 = 0;
        if (!this.freeList.isEmpty()) {
            long l2 = this.epochClock.time();
            int n3 = this.freeList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = this.freeList.getInt(i2);
                if (l2 < this.metaDataBuffer.getLong(CountersManager.metaDataOffset(n4) + 8)) continue;
                ++n2;
            }
        }
        return this.capacity() - this.highWaterMarkId - 1 + n2;
    }

    public int allocate(String string) {
        return this.allocate(string, 0);
    }

    public int allocate(String string, int n2) {
        int n3 = this.nextCounterId();
        int n4 = CountersManager.metaDataOffset(n3);
        try {
            this.metaDataBuffer.putInt(n4 + 4, n2);
            this.metaDataBuffer.putLong(n4 + 8, Long.MAX_VALUE);
            this.putLabel(n4, string);
            this.metaDataBuffer.putIntOrdered(n4, 1);
        }
        catch (Exception exception) {
            this.freeList.pushInt(n3);
            LangUtil.rethrowUnchecked(exception);
        }
        return n3;
    }

    public int allocate(String string, int n2, Consumer<MutableDirectBuffer> consumer) {
        int n3 = this.nextCounterId();
        try {
            int n4 = CountersManager.metaDataOffset(n3);
            this.metaDataBuffer.putInt(n4 + 4, n2);
            consumer.accept(new UnsafeBuffer(this.metaDataBuffer, n4 + 16, 112));
            this.metaDataBuffer.putLong(n4 + 8, Long.MAX_VALUE);
            this.putLabel(n4, string);
            this.metaDataBuffer.putIntOrdered(n4, 1);
        }
        catch (Exception exception) {
            this.freeList.pushInt(n3);
            LangUtil.rethrowUnchecked(exception);
        }
        return n3;
    }

    public int allocate(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6) {
        int n7 = this.nextCounterId();
        try {
            int n8;
            int n9 = CountersManager.metaDataOffset(n7);
            this.metaDataBuffer.putInt(n9 + 4, n2);
            this.metaDataBuffer.putLong(n9 + 8, Long.MAX_VALUE);
            if (null != directBuffer) {
                n8 = Math.min(n4, 112);
                this.metaDataBuffer.putBytes(n9 + 16, directBuffer, n3, n8);
            }
            n8 = Math.min(n6, 380);
            this.metaDataBuffer.putInt(n9 + 128, n8);
            this.metaDataBuffer.putBytes(n9 + 128 + 4, directBuffer2, n5, n8);
            this.metaDataBuffer.putIntOrdered(n9, 1);
        }
        catch (Exception exception) {
            this.freeList.pushInt(n7);
            LangUtil.rethrowUnchecked(exception);
        }
        return n7;
    }

    public AtomicCounter newCounter(String string) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(string), this);
    }

    public AtomicCounter newCounter(String string, int n2) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(string, n2), this);
    }

    public AtomicCounter newCounter(String string, int n2, Consumer<MutableDirectBuffer> consumer) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(string, n2, consumer), this);
    }

    public AtomicCounter newCounter(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(n2, directBuffer, n3, n4, directBuffer2, n5, n6), this);
    }

    public void free(int n2) {
        this.validateCounterId(n2);
        int n3 = CountersManager.metaDataOffset(n2);
        if (1 != this.metaDataBuffer.getIntVolatile(n3)) {
            throw new IllegalStateException("counter not allocated: id=" + n2);
        }
        this.metaDataBuffer.putIntOrdered(n3, -1);
        this.metaDataBuffer.setMemory(n3 + 16, 112, (byte)0);
        this.metaDataBuffer.putLong(n3 + 8, this.epochClock.time() + this.freeToReuseTimeoutMs);
        this.freeList.addInt(n2);
    }

    public void setCounterValue(int n2, long l2) {
        this.validateCounterId(n2);
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(n2), l2);
    }

    public void setCounterRegistrationId(int n2, long l2) {
        this.validateCounterId(n2);
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(n2) + 8, l2);
    }

    public void setCounterOwnerId(int n2, long l2) {
        this.validateCounterId(n2);
        this.valuesBuffer.putLong(CountersManager.counterOffset(n2) + 16, l2);
    }

    public void setCounterReferenceId(int n2, long l2) {
        this.validateCounterId(n2);
        this.valuesBuffer.putLong(CountersManager.counterOffset(n2) + 24, l2);
    }

    public void setCounterLabel(int n2, String string) {
        this.validateCounterId(n2);
        this.putLabel(CountersManager.metaDataOffset(n2), string);
    }

    public void setCounterKey(int n2, Consumer<MutableDirectBuffer> consumer) {
        this.validateCounterId(n2);
        consumer.accept(new UnsafeBuffer(this.metaDataBuffer, CountersManager.metaDataOffset(n2) + 16, 112));
    }

    public void setCounterKey(int n2, DirectBuffer directBuffer, int n3, int n4) {
        this.validateCounterId(n2);
        if (n4 > 112) {
            throw new IllegalArgumentException("key is too long: " + n4 + ", max: " + 112);
        }
        this.metaDataBuffer.putBytes(CountersManager.metaDataOffset(n2) + 16, directBuffer, n3, n4);
    }

    public void appendToLabel(int n2, String string) {
        this.appendLabel(CountersManager.metaDataOffset(n2), string);
    }

    public String toString() {
        return "CountersManager{freeToReuseTimeoutMs=" + this.freeToReuseTimeoutMs + ", highWaterMarkId=" + this.highWaterMarkId + ", freeList=" + this.freeList + ", epochClock=" + this.epochClock + '}';
    }

    private int nextCounterId() {
        if (!this.freeList.isEmpty()) {
            long l2 = this.epochClock.time();
            int n2 = this.freeList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.freeList.getInt(i2);
                if (l2 < this.metaDataBuffer.getLong(CountersManager.metaDataOffset(n3) + 8)) continue;
                this.freeList.remove(i2);
                int n4 = CountersManager.counterOffset(n3);
                this.valuesBuffer.putLongOrdered(n4 + 8, 0L);
                this.valuesBuffer.putLong(n4 + 16, 0L);
                this.valuesBuffer.putLong(n4 + 24, 0L);
                this.valuesBuffer.putLongOrdered(n4, 0L);
                return n3;
            }
        }
        this.checkCountersCapacity(this.highWaterMarkId + 1);
        return ++this.highWaterMarkId;
    }

    private void putLabel(int n2, String string) {
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            int n3 = this.metaDataBuffer.putStringWithoutLengthAscii(n2 + 128 + 4, string, 0, 380);
            this.metaDataBuffer.putIntOrdered(n2 + 128, n3);
        } else {
            byte[] byArray = string.getBytes(this.labelCharset);
            int n4 = Math.min(byArray.length, 380);
            this.metaDataBuffer.putBytes(n2 + 128 + 4, byArray, 0, n4);
            this.metaDataBuffer.putIntOrdered(n2 + 128, n4);
        }
    }

    private void appendLabel(int n2, String string) {
        int n3 = this.metaDataBuffer.getInt(n2 + 128);
        int n4 = 380 - n3;
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            int n5 = this.metaDataBuffer.putStringWithoutLengthAscii(n2 + 128 + 4 + n3, string, 0, n4);
            this.metaDataBuffer.putIntOrdered(n2 + 128, n3 + n5);
        } else {
            byte[] byArray = string.getBytes(this.labelCharset);
            int n6 = Math.min(byArray.length, n4);
            this.metaDataBuffer.putBytes(n2 + 128 + 4 + n3, byArray, 0, n6);
            this.metaDataBuffer.putIntOrdered(n2 + 128, n3 + n6);
        }
    }

    private void checkCountersCapacity(int n2) {
        if (n2 > this.maxCounterId) {
            throw new IllegalStateException("unable to allocate counter, buffer is full: maxCounterId=" + this.maxCounterId);
        }
    }
}

