/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.errors;

import java.io.PrintStream;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.errors.DistinctErrorLog;

public class LoggingErrorHandler
implements ErrorHandler,
AutoCloseable {
    private volatile boolean isClosed;
    private final DistinctErrorLog log;
    private final PrintStream errorOverflow;

    public LoggingErrorHandler(DistinctErrorLog distinctErrorLog) {
        this(distinctErrorLog, System.err);
    }

    public LoggingErrorHandler(DistinctErrorLog distinctErrorLog, PrintStream printStream) {
        Objects.requireNonNull(distinctErrorLog, "log");
        Objects.requireNonNull(distinctErrorLog, "errorOverflow");
        this.log = distinctErrorLog;
        this.errorOverflow = printStream;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public DistinctErrorLog distinctErrorLog() {
        return this.log;
    }

    public PrintStream errorOverflow() {
        return this.errorOverflow;
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.isClosed) {
            this.errorOverflow.println("error log is closed");
            throwable.printStackTrace(this.errorOverflow);
        } else if (!this.log.record(throwable)) {
            this.errorOverflow.println("error log is full, consider increasing length of error buffer");
            throwable.printStackTrace(this.errorOverflow);
        }
    }
}

