/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.ByteBuffer;
import org.agrona.AbstractMutableDirectBuffer;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.AtomicBuffer;

public class UnsafeBuffer
extends AbstractMutableDirectBuffer
implements AtomicBuffer {
    public static final int ALIGNMENT = 8;
    public static final String DISABLE_BOUNDS_CHECKS_PROP_NAME = "agrona.disable.bounds.checks";
    public static final boolean SHOULD_BOUNDS_CHECK = DirectBuffer.SHOULD_BOUNDS_CHECK;
    private ByteBuffer byteBuffer;
    private int wrapAdjustment;

    public UnsafeBuffer() {
        this.wrap(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public UnsafeBuffer(byte[] byArray) {
        this.wrap(byArray);
    }

    public UnsafeBuffer(byte[] byArray, int n2, int n3) {
        this.wrap(byArray, n2, n3);
    }

    public UnsafeBuffer(ByteBuffer byteBuffer) {
        this.wrap(byteBuffer);
    }

    public UnsafeBuffer(ByteBuffer byteBuffer, int n2, int n3) {
        this.wrap(byteBuffer, n2, n3);
    }

    public UnsafeBuffer(DirectBuffer directBuffer) {
        this.wrap(directBuffer);
    }

    public UnsafeBuffer(DirectBuffer directBuffer, int n2, int n3) {
        this.wrap(directBuffer, n2, n3);
    }

    public UnsafeBuffer(long l2, int n2) {
        this.wrap(l2, n2);
    }

    @Override
    public void wrap(byte[] byArray) {
        this.capacity = byArray.length;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
        this.byteBuffer = null;
        this.wrapAdjustment = 0;
        if (byArray != this.byteArray) {
            this.byteArray = byArray;
        }
    }

    @Override
    public void wrap(byte[] byArray, int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(n2, n3, byArray.length);
        }
        this.capacity = n3;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)n2;
        this.byteBuffer = null;
        this.wrapAdjustment = n2;
        if (byArray != this.byteArray) {
            this.byteArray = byArray;
        }
    }

    @Override
    public void wrap(ByteBuffer byteBuffer) {
        this.capacity = byteBuffer.capacity();
        if (byteBuffer != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
        if (byteBuffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(byteBuffer);
            this.wrapAdjustment = 0;
        } else {
            this.byteArray = BufferUtil.array(byteBuffer);
            int n2 = BufferUtil.arrayOffset(byteBuffer);
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)n2;
            this.wrapAdjustment = n2;
        }
    }

    @Override
    public void wrap(ByteBuffer byteBuffer, int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(n2, n3, byteBuffer.capacity());
        }
        this.capacity = n3;
        if (byteBuffer != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
        if (byteBuffer.isDirect()) {
            this.byteArray = null;
            this.addressOffset = BufferUtil.address(byteBuffer) + (long)n2;
            this.wrapAdjustment = n2;
        } else {
            this.byteArray = BufferUtil.array(byteBuffer);
            int n4 = BufferUtil.arrayOffset(byteBuffer) + n2;
            this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)n4;
            this.wrapAdjustment = n4;
        }
    }

    @Override
    public void wrap(DirectBuffer directBuffer) {
        ByteBuffer byteBuffer;
        this.capacity = directBuffer.capacity();
        this.addressOffset = directBuffer.addressOffset();
        this.wrapAdjustment = directBuffer.wrapAdjustment();
        byte[] byArray = directBuffer.byteArray();
        if (byArray != this.byteArray) {
            this.byteArray = byArray;
        }
        if ((byteBuffer = directBuffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(DirectBuffer directBuffer, int n2, int n3) {
        ByteBuffer byteBuffer;
        if (SHOULD_BOUNDS_CHECK) {
            UnsafeBuffer.boundsCheckWrap(n2, n3, directBuffer.capacity());
        }
        this.capacity = n3;
        this.addressOffset = directBuffer.addressOffset() + (long)n2;
        this.wrapAdjustment = directBuffer.wrapAdjustment() + n2;
        byte[] byArray = directBuffer.byteArray();
        if (byArray != this.byteArray) {
            this.byteArray = byArray;
        }
        if ((byteBuffer = directBuffer.byteBuffer()) != this.byteBuffer) {
            this.byteBuffer = byteBuffer;
        }
    }

    @Override
    public void wrap(long l2, int n2) {
        this.capacity = n2;
        this.addressOffset = l2;
        this.byteArray = null;
        this.byteBuffer = null;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int wrapAdjustment() {
        return this.wrapAdjustment;
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void verifyAlignment() {
        if (null != this.byteArray) {
            String string = "AtomicBuffer was created from a byte[] and is not correctly aligned by 8";
            if (STRICT_ALIGNMENT_CHECKS) {
                throw new IllegalStateException("AtomicBuffer was created from a byte[] and is not correctly aligned by 8");
            }
            System.err.println("AtomicBuffer was created from a byte[] and is not correctly aligned by 8");
        } else if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException("AtomicBuffer is not correctly aligned: addressOffset=" + this.addressOffset + " is not divisible by " + 8);
        }
    }

    @Override
    public long getLongVolatile(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putLongVolatile(int n2, long l2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(this.byteArray, this.addressOffset + (long)n2, l2);
    }

    @Override
    public void putLongOrdered(int n2, long l2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset + (long)n2, l2);
    }

    @Override
    public long addLongOrdered(int n2, long l2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        long l3 = this.addressOffset + (long)n2;
        byte[] byArray = this.byteArray;
        long l4 = UnsafeAccess.UNSAFE.getLong(byArray, l3);
        UnsafeAccess.UNSAFE.putOrderedLong(byArray, l3, l4 + l2);
        return l4;
    }

    @Override
    public boolean compareAndSetLong(int n2, long l2, long l3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.byteArray, this.addressOffset + (long)n2, l2, l3);
    }

    @Override
    public long getAndSetLong(int n2, long l2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(this.byteArray, this.addressOffset + (long)n2, l2);
    }

    @Override
    public long getAndAddLong(int n2, long l2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(this.byteArray, this.addressOffset + (long)n2, l2);
    }

    @Override
    public int getIntVolatile(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putIntVolatile(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(this.byteArray, this.addressOffset + (long)n2, n3);
    }

    @Override
    public void putIntOrdered(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(this.byteArray, this.addressOffset + (long)n2, n3);
    }

    @Override
    public int addIntOrdered(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        long l2 = this.addressOffset + (long)n2;
        byte[] byArray = this.byteArray;
        int n4 = UnsafeAccess.UNSAFE.getInt(byArray, l2);
        UnsafeAccess.UNSAFE.putOrderedInt(byArray, l2, n4 + n3);
        return n4;
    }

    @Override
    public boolean compareAndSetInt(int n2, int n3, int n4) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(this.byteArray, this.addressOffset + (long)n2, n3, n4);
    }

    @Override
    public int getAndSetInt(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(this.byteArray, this.addressOffset + (long)n2, n3);
    }

    @Override
    public int getAndAddInt(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(this.byteArray, this.addressOffset + (long)n2, n3);
    }

    @Override
    public short getShortVolatile(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putShortVolatile(int n2, short s2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(this.byteArray, this.addressOffset + (long)n2, s2);
    }

    @Override
    public byte getByteVolatile(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 1);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putByteVolatile(int n2, byte by2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 1);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(this.byteArray, this.addressOffset + (long)n2, by2);
    }

    @Override
    public char getCharVolatile(int n2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(this.byteArray, this.addressOffset + (long)n2);
    }

    @Override
    public void putCharVolatile(int n2, char c2) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(this.byteArray, this.addressOffset + (long)n2, c2);
    }

    public String toString() {
        return "UnsafeBuffer{addressOffset=" + this.addressOffset + ", capacity=" + this.capacity + ", byteArray=" + (null == this.byteArray ? "null" : "byte[" + this.byteArray.length + "]") + ", byteBuffer=" + this.byteBuffer + '}';
    }

    @Override
    protected final void ensureCapacity(int n2, int n3) {
        if (SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(n2, n3);
        }
    }

    private static void boundsCheckWrap(int n2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid offset: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("invalid length: " + n3);
        }
        if (n2 > n4 - n3 || n3 > n4 - n2) {
            throw new IllegalArgumentException("offset=" + n2 + " length=" + n3 + " not valid for capacity=" + n4);
        }
    }
}

