/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.agrona.concurrent.AtomicBuffer;

public class RecordBuffer {
    public static final int DID_NOT_CLAIM_RECORD = -1;
    private static final int UNUSED = 0;
    private static final int PENDING = 1;
    private static final int COMMITTED = 2;
    private static final int SIZE_OF_POSITION_FIELD = 4;
    private static final int SIZE_OF_STATUS_FIELD = 4;
    private static final int SIZE_OF_KEY_FIELD = 4;
    private static final int SIZE_OF_RECORD_FRAME = 8;
    private static final long PAUSE_TIME_NS = TimeUnit.MICROSECONDS.toNanos(1000L);
    private final AtomicBuffer buffer;
    private final int positionFieldOffset;
    private final int endOfPositionField;
    private final int slotSize;

    public RecordBuffer(AtomicBuffer atomicBuffer, int n2, int n3) {
        this.buffer = atomicBuffer;
        this.positionFieldOffset = n2;
        this.endOfPositionField = n2 + 4;
        this.slotSize = n3 + 8;
    }

    public void initialise() {
        this.movePosition(this.endOfPositionField);
    }

    public boolean isInitialised() {
        return this.position() != 0;
    }

    public void forEach(RecordHandler recordHandler) {
        int n2 = this.position();
        for (int i2 = this.endOfPositionField; i2 < n2; i2 += this.slotSize) {
            if (this.statusVolatile(i2) != 2) continue;
            int n3 = this.key(i2);
            recordHandler.onRecord(n3, i2 + 8);
        }
    }

    public int get(int n2) {
        int n3 = this.position();
        for (int i2 = this.endOfPositionField; i2 < n3; i2 += this.slotSize) {
            if (this.statusVolatile(i2) != 2 || n2 != this.key(i2)) continue;
            return i2 + 8;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean withRecord(int n2, RecordWriter recordWriter) {
        int n3 = this.claimRecord(n2);
        if (n3 == -1) {
            return false;
        }
        try {
            recordWriter.writeRecord(n3);
        }
        finally {
            this.commit(n3);
        }
        return true;
    }

    public int claimRecord(int n2) {
        int n3;
        for (n3 = this.endOfPositionField; n3 < this.position(); n3 += this.slotSize) {
            if (n2 != this.key(n3)) continue;
            if (this.statusVolatile(n3) == 1) {
                return -1;
            }
            this.compareAndSetStatus(n3, 2, 1);
            return n3 + 8;
        }
        if (n3 + this.slotSize > this.buffer.capacity()) {
            return -1;
        }
        int n4 = this.movePosition(this.slotSize);
        this.compareAndSetStatus(n4, 0, 1);
        this.key(n4, n2);
        return n4 + 8;
    }

    public void commit(int n2) {
        this.compareAndSetStatus(n2 - 8, 1, 2);
    }

    private int statusVolatile(int n2) {
        return this.buffer.getIntVolatile(n2);
    }

    private void compareAndSetStatus(int n2, int n3, int n4) {
        while (!this.buffer.compareAndSetInt(n2, n3, n4)) {
            LockSupport.parkNanos(PAUSE_TIME_NS);
        }
    }

    private int key(int n2) {
        return this.buffer.getInt(n2 + 4);
    }

    private void key(int n2, int n3) {
        this.buffer.putInt(n2 + 4, n3);
    }

    private int position() {
        return this.buffer.getIntVolatile(this.positionFieldOffset);
    }

    private int movePosition(int n2) {
        return this.buffer.getAndAddInt(this.positionFieldOffset, n2);
    }

    public static interface RecordWriter {
        public void writeRecord(int var1);
    }

    public static interface RecordHandler {
        public void onRecord(int var1, int var2);
    }
}

