/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class IntHashSet
extends AbstractSet<Integer> {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final int MISSING_VALUE = -1;
    private final boolean shouldAvoidAllocation;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private int[] values;
    private IntIterator iterator;

    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int n2) {
        this(n2, 0.65f, true);
    }

    public IntHashSet(int n2, float f2) {
        this(n2, f2, true);
    }

    public IntHashSet(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.shouldAvoidAllocation = bl2;
        this.loadFactor = f2;
        this.sizeOfArrayValues = 0;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.values = new int[n3];
        Arrays.fill(this.values, -1);
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Integer n2) {
        return this.add((int)n2);
    }

    @Override
    public boolean add(int n2) {
        int n3;
        if (-1 == n2) {
            boolean bl2 = this.containsMissingValue;
            this.containsMissingValue = true;
            return !bl2;
        }
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(n2, n4);
        while (-1 != (n3 = nArray[n5])) {
            if (n3 == n2) {
                return false;
            }
            n5 = IntHashSet.next(n5, n4);
        }
        nArray[n5] = n2;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int n2 = this.values.length * 2;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size());
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        int[] nArray;
        int n3 = n2;
        int n4 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        int[] nArray2 = new int[n3];
        Arrays.fill(nArray2, -1);
        for (int n5 : nArray = this.values) {
            if (-1 == n5) continue;
            int n6 = Hashing.hash(n5, n4);
            while (-1 != nArray2[n6]) {
                ++n6;
                n6 &= n4;
            }
            nArray2[n6] = n5;
        }
        this.values = nArray2;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove((Integer)object);
    }

    public boolean remove(int n2) {
        int n3;
        if (-1 == n2) {
            boolean bl2 = this.containsMissingValue;
            this.containsMissingValue = false;
            return bl2;
        }
        int[] nArray = this.values;
        int n4 = nArray.length - 1;
        int n5 = Hashing.hash(n2, n4);
        while (-1 != (n3 = nArray[n5])) {
            if (n3 == n2) {
                nArray[n5] = -1;
                this.compactChain(n5);
                --this.sizeOfArrayValues;
                return true;
            }
            n5 = IntHashSet.next(n5, n4);
        }
        return false;
    }

    private static int next(int n2, int n3) {
        return n2 + 1 & n3;
    }

    void compactChain(int n2) {
        int[] nArray = this.values;
        int n3 = nArray.length - 1;
        int n4 = n2;
        int n5;
        while (-1 != (n5 = nArray[n4 = IntHashSet.next(n4, n3)])) {
            int n6 = Hashing.hash(n5, n3);
            if ((n4 >= n6 || n6 > n2 && n2 > n4) && (n6 > n2 || n2 > n4)) continue;
            nArray[n2] = n5;
            nArray[n4] = -1;
            n2 = n4;
        }
        return;
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public boolean contains(Object object) {
        return this.contains((Integer)object);
    }

    public boolean contains(int n2) {
        int n3;
        if (-1 == n2) {
            return this.containsMissingValue;
        }
        int n4 = this.values.length - 1;
        int n5 = Hashing.hash(n2, n4);
        while (-1 != (n3 = this.values[n5])) {
            if (n3 == n2) {
                return true;
            }
            n5 = IntHashSet.next(n5, n4);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.size() > 0) {
            Arrays.fill(this.values, -1);
            this.sizeOfArrayValues = 0;
            this.containsMissingValue = false;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        boolean bl2 = false;
        for (Integer n2 : collection) {
            bl2 |= this.add(n2);
        }
        return bl2;
    }

    public boolean addAll(IntHashSet intHashSet) {
        boolean bl2 = false;
        for (int n2 : intHashSet.values) {
            if (-1 == n2) continue;
            bl2 |= this.add(n2);
        }
        if (intHashSet.containsMissingValue) {
            bl2 |= this.add(-1);
        }
        return bl2;
    }

    public boolean containsAll(IntHashSet intHashSet) {
        for (int n2 : intHashSet.values) {
            if (-1 == n2 || this.contains(n2)) continue;
            return false;
        }
        return this.containsMissingValue || !intHashSet.containsMissingValue;
    }

    public IntHashSet difference(IntHashSet intHashSet) {
        int[] nArray;
        IntHashSet intHashSet2 = null;
        for (int n2 : nArray = this.values) {
            if (-1 == n2 || intHashSet.contains(n2)) continue;
            if (null == intHashSet2) {
                intHashSet2 = new IntHashSet();
            }
            intHashSet2.add(n2);
        }
        if (this.containsMissingValue && !intHashSet.containsMissingValue) {
            if (null == intHashSet2) {
                intHashSet2 = new IntHashSet();
            }
            intHashSet2.add(-1);
        }
        return intHashSet2;
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> predicate) {
        return super.removeIf(predicate);
    }

    public boolean removeIfInt(IntPredicate intPredicate) {
        boolean bl2 = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (!intPredicate.test(intIterator.nextValue())) continue;
            intIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl2 = false;
        for (Object obj : collection) {
            bl2 |= this.remove(obj);
        }
        return bl2;
    }

    public boolean removeAll(IntHashSet intHashSet) {
        boolean bl2 = false;
        for (int n2 : intHashSet.values) {
            if (-1 == n2) continue;
            bl2 |= this.remove(n2);
        }
        if (intHashSet.containsMissingValue) {
            bl2 |= this.remove(-1);
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl2 = false;
        for (int n2 : this.values) {
            if (-1 == n2 || collection.contains(n2)) continue;
            var3_3[var5_5] = -1;
            --this.sizeOfArrayValues;
            bl2 = true;
        }
        if (bl2 && this.sizeOfArrayValues > 0) {
            int n2;
            n2 = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(n2);
        }
        if (this.containsMissingValue && !collection.contains(-1)) {
            this.containsMissingValue = false;
            bl2 = true;
        }
        return bl2;
    }

    public boolean retainAll(IntHashSet intHashSet) {
        boolean bl2 = false;
        for (int n2 : this.values) {
            if (-1 == n2 || intHashSet.contains(n2)) continue;
            this.values[var4_4] = -1;
            --this.sizeOfArrayValues;
            bl2 = true;
        }
        if (bl2 && this.sizeOfArrayValues > 0) {
            int n2;
            n2 = Math.max(8, BitUtil.findNextPositivePowerOfTwo(this.sizeOfArrayValues));
            this.rehash(n2);
        }
        if (this.containsMissingValue && !intHashSet.contains(-1)) {
            this.containsMissingValue = false;
            bl2 = true;
        }
        return bl2;
    }

    public IntIterator iterator() {
        IntIterator intIterator = this.iterator;
        if (null == intIterator) {
            intIterator = new IntIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = intIterator;
            }
        }
        return intIterator.reset();
    }

    public void forEachInt(IntConsumer intConsumer) {
        if (this.sizeOfArrayValues > 0) {
            int[] nArray;
            for (int n2 : nArray = this.values) {
                if (-1 == n2) continue;
                intConsumer.accept(n2);
            }
        }
        if (this.containsMissingValue) {
            intConsumer.accept(-1);
        }
    }

    public void copy(IntHashSet intHashSet) {
        if (this.values.length != intHashSet.values.length) {
            throw new IllegalArgumentException("cannot copy object: masks not equal");
        }
        System.arraycopy(intHashSet.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = intHashSet.sizeOfArrayValues;
        this.containsMissingValue = intHashSet.containsMissingValue;
    }

    @Override
    public String toString() {
        int[] nArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int n2 : nArray = this.values) {
            if (-1 == n2) continue;
            stringBuilder.append(n2).append(", ");
        }
        if (this.containsMissingValue) {
            stringBuilder.append(-1).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Class<Integer> clazz = TArray.getClass().getComponentType();
        if (!clazz.isAssignableFrom(Integer.class)) {
            throw new ArrayStoreException("cannot store Integers in array of type " + clazz);
        }
        int n2 = this.size();
        Object[] objectArray = TArray.length >= n2 ? TArray : (Object[])Array.newInstance(clazz, n2);
        this.copyValues(objectArray);
        return objectArray;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.copyValues(objectArray);
        return objectArray;
    }

    private void copyValues(Object[] objectArray) {
        int[] nArray;
        int n2 = 0;
        for (int n3 : nArray = this.values) {
            if (-1 == n3) continue;
            objectArray[n2++] = n3;
        }
        if (this.containsMissingValue) {
            objectArray[this.sizeOfArrayValues] = -1;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntHashSet) {
            IntHashSet intHashSet = (IntHashSet)object;
            return intHashSet.containsMissingValue == this.containsMissingValue && intHashSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(intHashSet);
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(set);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (int n3 : this.values) {
            if (-1 == n3) continue;
            n2 += Integer.hashCode(n3);
        }
        if (this.containsMissingValue) {
            n2 += Integer.hashCode(-1);
        }
        return n2;
    }

    public final class IntIterator
    implements Iterator<Integer> {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        IntIterator reset() {
            int n2;
            this.remaining = IntHashSet.this.size();
            int[] nArray = IntHashSet.this.values;
            int n3 = n2 = nArray.length;
            if (-1 != nArray[n2 - 1]) {
                for (n3 = 0; n3 < n2 && -1 != nArray[n3]; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.positionCounter = n3 + n2;
            this.isPositionValid = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            if (this.remaining == 1 && IntHashSet.this.containsMissingValue) {
                this.remaining = 0;
                this.isPositionValid = true;
                return -1;
            }
            this.findNext();
            int[] nArray = IntHashSet.this.values;
            return nArray[this.position(nArray)];
        }

        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (0 == this.remaining && IntHashSet.this.containsMissingValue) {
                    IntHashSet.this.containsMissingValue = false;
                } else {
                    int[] nArray = IntHashSet.this.values;
                    int n2 = this.position(nArray);
                    nArray[n2] = -1;
                    --IntHashSet.this.sizeOfArrayValues;
                    IntHashSet.this.compactChain(n2);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }

        private void findNext() {
            int[] nArray = IntHashSet.this.values;
            int n2 = nArray.length - 1;
            this.isPositionValid = true;
            int n3 = this.stopCounter;
            for (int i2 = this.positionCounter - 1; i2 >= n3; --i2) {
                int n4 = i2 & n2;
                if (-1 == nArray[n4]) continue;
                this.positionCounter = i2;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new NoSuchElementException();
        }

        private int position(int[] nArray) {
            return this.positionCounter & nArray.length - 1;
        }
    }
}

