/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class BiInt2ObjectMap<V> {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private long[] keys;
    private Object[] values;

    public BiInt2ObjectMap() {
        this(8, 0.65f);
    }

    public BiInt2ObjectMap(int n2, float f2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.keys = new long[n3];
        this.values = new Object[n3];
    }

    public int capacity() {
        return this.values.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, null);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public V put(int n2, int n3, V v2) {
        Object object;
        Object object2 = this.mapNullValue(v2);
        long l2 = Hashing.compoundKey(n2, n3);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        if (null == object) {
            ++this.size;
            lArray[n5] = l2;
        }
        objectArray[n5] = object2;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return this.unmapNullValue(object);
    }

    protected Object mapNullValue(Object object) {
        return object;
    }

    protected V unmapNullValue(Object object) {
        return (V)object;
    }

    private V getMapping(int n2, int n3) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        return (V)object;
    }

    public V get(int n2, int n3) {
        return this.unmapNullValue(this.getMapping(n2, n3));
    }

    public V getOrDefault(int n2, int n3, V v2) {
        V v3 = this.getMapping(n2, n3);
        return this.unmapNullValue(null != v3 ? v3 : v2);
    }

    public boolean containsKey(int n2, int n3) {
        long l2 = Hashing.compoundKey(n2, n3);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        boolean bl2 = false;
        while (null != objectArray[n5]) {
            if (l2 == lArray[n5]) {
                bl2 = true;
                break;
            }
            ++n5;
            n5 &= n4;
        }
        return bl2;
    }

    public V remove(int n2, int n3) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5])) {
            if (l2 == lArray[n5]) {
                objectArray[n5] = null;
                --this.size;
                this.compactChain(n5);
                break;
            }
            ++n5;
            n5 &= n4;
        }
        return (V)object;
    }

    public V computeIfAbsent(int n2, int n3, EntryFunction<? extends V> entryFunction) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Objects.requireNonNull(entryFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        V v2 = this.unmapNullValue(object);
        if (null == v2 && (v2 = entryFunction.apply(n2, n3)) != null) {
            objectArray[n5] = v2;
            if (null == object) {
                lArray[n5] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        }
        return v2;
    }

    public V computeIfPresent(int n2, int n3, EntryRemap<? super V, ? extends V> entryRemap) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Objects.requireNonNull(entryRemap);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        V v2 = this.unmapNullValue(object);
        if (null != v2) {
            v2 = entryRemap.apply(n2, n3, v2);
            objectArray[n5] = v2;
            if (null == v2) {
                --this.size;
                this.compactChain(n5);
            }
        }
        return v2;
    }

    public V compute(int n2, int n3, EntryRemap<? super V, ? extends V> entryRemap) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Objects.requireNonNull(entryRemap);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        V v2 = entryRemap.apply(n2, n3, this.unmapNullValue(object));
        if (null != v2) {
            objectArray[n5] = v2;
            if (null == object) {
                lArray[n5] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n5] = null;
            --this.size;
            this.compactChain(n5);
        }
        return v2;
    }

    public V merge(int n2, int n3, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v3;
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Objects.requireNonNull(v2);
        Objects.requireNonNull(biFunction);
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        V v4 = this.unmapNullValue(object);
        V v5 = v3 = null == v4 ? v2 : biFunction.apply(v4, v2);
        if (null != v3) {
            objectArray[n5] = v3;
            if (null == object) {
                lArray[n5] = l2;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (null != object) {
            objectArray[n5] = null;
            --this.size;
            this.compactChain(n5);
        }
        return v3;
    }

    public void forEach(Consumer<V> consumer) {
        int n2 = this.size;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; n2 > 0 && i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            consumer.accept(object);
            --n2;
        }
    }

    public void forEach(EntryConsumer<V> entryConsumer) {
        int n2 = this.size;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = objectArray.length;
        for (int i2 = 0; n2 > 0 && i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            long l2 = lArray[i2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)(l2 & 0xFFFFFFFFL);
            entryConsumer.accept(n4, n5, this.unmapNullValue(object));
            --n2;
        }
    }

    public V replace(int n2, int n3, V v2) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5])) {
            if (l2 == lArray[n5]) {
                objectArray[n5] = object2;
                break;
            }
            ++n5;
            n5 &= n4;
        }
        return this.unmapNullValue(object);
    }

    public boolean replace(int n2, int n3, V v2, V v3) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Object object2 = this.mapNullValue(v3);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5])) {
            if (l2 == lArray[n5]) {
                if (!Objects.equals(this.unmapNullValue(object), v2)) break;
                objectArray[n5] = object2;
                return true;
            }
            ++n5;
            n5 &= n4;
        }
        return false;
    }

    public V putIfAbsent(int n2, int n3, V v2) {
        Object object;
        long l2 = Hashing.compoundKey(n2, n3);
        Object object2 = this.mapNullValue(v2);
        Objects.requireNonNull(object2, "value cannot be null");
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n4 = objectArray.length - 1;
        int n5 = Hashing.hash(l2, n4);
        while (null != (object = objectArray[n5]) && l2 != lArray[n5]) {
            ++n5;
            n5 &= n4;
        }
        V v3 = this.unmapNullValue(object);
        if (null == v3) {
            if (null == object) {
                ++this.size;
                lArray[n5] = l2;
            }
            objectArray[n5] = object2;
            if (this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return v3;
    }

    public boolean remove(int n2, int n3, V v2) {
        long l2 = Hashing.compoundKey(n2, n3);
        Object object = this.mapNullValue(v2);
        if (null != object) {
            Object object2;
            long[] lArray = this.keys;
            Object[] objectArray = this.values;
            int n4 = objectArray.length - 1;
            int n5 = Hashing.hash(l2, n4);
            while (null != (object2 = objectArray[n5])) {
                if (l2 == lArray[n5]) {
                    if (!Objects.equals(this.unmapNullValue(object2), v2)) break;
                    objectArray[n5] = null;
                    --this.size;
                    this.compactChain(n5);
                    return true;
                }
                ++n5;
                n5 &= n4;
            }
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            if (null == object) continue;
            long l2 = lArray[i2];
            int n3 = (int)(l2 >>> 32);
            int n4 = (int)(l2 & 0xFFFFFFFFL);
            stringBuilder.append(n3).append('_').append(n4).append('=').append(object).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        long[] lArray = new long[n2];
        Object[] objectArray = new Object[n2];
        long[] lArray2 = this.keys;
        Object[] objectArray2 = this.values;
        int n4 = objectArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = objectArray2[i2];
            if (null == object) continue;
            long l2 = lArray2[i2];
            int n5 = Hashing.hash(l2, n3);
            while (null != objectArray[n5]) {
                ++n5;
                n5 &= n3;
            }
            lArray[n5] = l2;
            objectArray[n5] = object;
        }
        this.keys = lArray;
        this.values = objectArray;
    }

    private void compactChain(int n2) {
        int n3 = this.values.length - 1;
        int n4 = n2;
        long[] lArray = this.keys;
        Object[] objectArray = this.values;
        while (true) {
            ++n4;
            Object object = objectArray[n4 &= n3];
            if (null == object) break;
            long l2 = lArray[n4];
            int n5 = Hashing.hash(l2, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            lArray[n2] = l2;
            objectArray[n2] = object;
            objectArray[n4] = null;
            n2 = n4;
        }
    }

    private void increaseCapacity() {
        int n2 = this.values.length << 1;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(n2);
    }

    public static interface EntryRemap<V, V1> {
        public V1 apply(int var1, int var2, V var3);
    }

    public static interface EntryFunction<V> {
        public V apply(int var1, int var2);
    }

    public static interface EntryConsumer<V> {
        public void accept(int var1, int var2, V var3);
    }
}

