/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;

public class DeadlineTimerWheel {
    public static final long NULL_DEADLINE = Long.MAX_VALUE;
    private static final int INITIAL_TICK_ALLOCATION = 16;
    private final long tickResolution;
    private long startTime;
    private long currentTick;
    private long timerCount;
    private final int ticksPerWheel;
    private final int tickMask;
    private final int resolutionBitsToShift;
    private int tickAllocation;
    private int allocationBitsToShift;
    private int pollIndex;
    private final TimeUnit timeUnit;
    private long[] wheel;

    public DeadlineTimerWheel(TimeUnit timeUnit, long l2, long l3, int n2) {
        this(timeUnit, l2, l3, n2, 16);
    }

    public DeadlineTimerWheel(TimeUnit timeUnit, long l2, long l3, int n2, int n3) {
        DeadlineTimerWheel.checkTicksPerWheel(n2);
        DeadlineTimerWheel.checkResolution(l3);
        DeadlineTimerWheel.checkInitialTickAllocation(n3);
        this.timeUnit = timeUnit;
        this.ticksPerWheel = n2;
        this.tickAllocation = n3;
        this.tickMask = n2 - 1;
        this.tickResolution = l3;
        this.resolutionBitsToShift = Long.numberOfTrailingZeros(l3);
        this.allocationBitsToShift = Integer.numberOfTrailingZeros(n3);
        this.startTime = l2;
        this.wheel = new long[n2 * n3];
        Arrays.fill(this.wheel, Long.MAX_VALUE);
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long tickResolution() {
        return this.tickResolution;
    }

    public int ticksPerWheel() {
        return this.ticksPerWheel;
    }

    public long startTime() {
        return this.startTime;
    }

    public long timerCount() {
        return this.timerCount;
    }

    public void resetStartTime(long l2) {
        if (this.timerCount > 0L) {
            throw new IllegalStateException("can not reset startTime with active timers");
        }
        this.startTime = l2;
        this.currentTick = 0L;
        this.pollIndex = 0;
    }

    public long currentTickTime() {
        return this.currentTickTime0();
    }

    public void currentTickTime(long l2) {
        this.currentTick = Math.max(l2 - this.startTime >> this.resolutionBitsToShift, this.currentTick);
    }

    public void clear() {
        long l2 = this.timerCount;
        if (0L == l2) {
            return;
        }
        int n2 = this.wheel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Long.MAX_VALUE == this.wheel[i2]) continue;
            this.wheel[i2] = Long.MAX_VALUE;
            if (--l2 > 0L) continue;
            this.timerCount = 0L;
            return;
        }
    }

    public long scheduleTimer(long l2) {
        long l3 = Math.max(l2 - this.startTime >> this.resolutionBitsToShift, this.currentTick);
        int n2 = (int)(l3 & (long)this.tickMask);
        int n3 = n2 << this.allocationBitsToShift;
        for (int i2 = 0; i2 < this.tickAllocation; ++i2) {
            int n4 = n3 + i2;
            if (Long.MAX_VALUE != this.wheel[n4]) continue;
            this.wheel[n4] = l2;
            ++this.timerCount;
            return DeadlineTimerWheel.timerIdForSlot(n2, i2);
        }
        return this.increaseCapacity(l2, n2);
    }

    public boolean cancelTimer(long l2) {
        int n2 = DeadlineTimerWheel.tickForTimerId(l2);
        int n3 = DeadlineTimerWheel.indexInTickArray(l2);
        int n4 = (n2 << this.allocationBitsToShift) + n3;
        if (n2 < this.ticksPerWheel && n3 < this.tickAllocation && Long.MAX_VALUE != this.wheel[n4]) {
            this.wheel[n4] = Long.MAX_VALUE;
            --this.timerCount;
            return true;
        }
        return false;
    }

    public int poll(long l2, TimerHandler timerHandler, int n2) {
        int n3 = 0;
        if (this.timerCount > 0L) {
            int n4 = (int)this.currentTick & this.tickMask;
            int n5 = this.tickAllocation;
            for (int i2 = 0; i2 < n5 && n2 > n3; ++i2) {
                int n6 = (n4 << this.allocationBitsToShift) + this.pollIndex;
                long l3 = this.wheel[n6];
                if (l2 >= l3) {
                    this.wheel[n6] = Long.MAX_VALUE;
                    --this.timerCount;
                    ++n3;
                    if (!timerHandler.onTimerExpiry(this.timeUnit, l2, DeadlineTimerWheel.timerIdForSlot(n4, this.pollIndex))) {
                        this.wheel[n6] = l3;
                        ++this.timerCount;
                        return --n3;
                    }
                }
                this.pollIndex = this.pollIndex + 1 >= n5 ? 0 : this.pollIndex + 1;
            }
            if (n2 > n3 && l2 >= this.currentTickTime0()) {
                ++this.currentTick;
                this.pollIndex = 0;
            } else if (this.pollIndex >= this.tickAllocation) {
                this.pollIndex = 0;
            }
        } else if (l2 >= this.currentTickTime0()) {
            ++this.currentTick;
            this.pollIndex = 0;
        }
        return n3;
    }

    public void forEach(TimerConsumer timerConsumer) {
        long l2 = this.timerCount;
        int n2 = this.wheel.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = this.wheel[i2];
            if (Long.MAX_VALUE == l3) continue;
            timerConsumer.accept(l3, DeadlineTimerWheel.timerIdForSlot(i2 >> this.allocationBitsToShift, i2 & this.tickMask));
            if (--l2 > 0L) continue;
            return;
        }
    }

    public long deadline(long l2) {
        int n2 = DeadlineTimerWheel.tickForTimerId(l2);
        int n3 = DeadlineTimerWheel.indexInTickArray(l2);
        int n4 = (n2 << this.allocationBitsToShift) + n3;
        if (n2 < this.ticksPerWheel && n3 < this.tickAllocation) {
            return this.wheel[n4];
        }
        return Long.MAX_VALUE;
    }

    private long currentTickTime0() {
        return (this.currentTick + 1L << this.resolutionBitsToShift) + this.startTime;
    }

    private long increaseCapacity(long l2, int n2) {
        int n3 = this.tickAllocation << 1;
        int n4 = Integer.numberOfTrailingZeros(n3);
        long l3 = (long)this.ticksPerWheel * (long)n3;
        if (l3 > 0x40000000L) {
            throw new IllegalStateException("max capacity reached at tickAllocation=" + this.tickAllocation);
        }
        long[] lArray = new long[(int)l3];
        Arrays.fill(lArray, Long.MAX_VALUE);
        for (int i2 = 0; i2 < this.ticksPerWheel; ++i2) {
            int n5 = i2 << this.allocationBitsToShift;
            int n6 = i2 << n4;
            System.arraycopy(this.wheel, n5, lArray, n6, this.tickAllocation);
        }
        lArray[(n2 << n4) + this.tickAllocation] = l2;
        long l4 = DeadlineTimerWheel.timerIdForSlot(n2, this.tickAllocation);
        ++this.timerCount;
        this.tickAllocation = n3;
        this.allocationBitsToShift = n4;
        this.wheel = lArray;
        return l4;
    }

    private static long timerIdForSlot(int n2, int n3) {
        return (long)n2 << 32 | (long)n3;
    }

    private static int tickForTimerId(long l2) {
        return (int)(l2 >> 32);
    }

    private static int indexInTickArray(long l2) {
        return (int)l2;
    }

    private static void checkTicksPerWheel(int n2) {
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("ticks per wheel must be a power of 2: " + n2);
        }
    }

    private static void checkResolution(long l2) {
        if (!BitUtil.isPowerOfTwo(l2)) {
            throw new IllegalArgumentException("tick resolution must be a power of 2: " + l2);
        }
    }

    private static void checkInitialTickAllocation(int n2) {
        if (!BitUtil.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("tick allocation must be a power of 2: " + n2);
        }
    }

    @FunctionalInterface
    public static interface TimerConsumer {
        public void accept(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TimerHandler {
        public boolean onTimerExpiry(TimeUnit var1, long var2, long var4);
    }
}

