/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram.packedarray;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.HdrHistogram.packedarray.IterationValue;
import org.HdrHistogram.packedarray.ResizeException;

abstract class AbstractPackedArrayContext
implements Serializable {
    private static final int PACKED_ARRAY_GROWTH_INCREMENT = 16;
    private static final int PACKED_ARRAY_GROWTH_FRACTION_POW2 = 4;
    private static final int SET_0_START_INDEX = 0;
    private static final int NUMBER_OF_SETS = 8;
    private static final int LEAF_LEVEL_SHIFT = 3;
    private static final int NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS = 2;
    private static final int NON_LEAF_ENTRY_SLOT_INDICATORS_OFFSET = 0;
    private static final int NON_LEAF_ENTRY_PREVIOUS_VERSION_OFFSET = 1;
    static final int MINIMUM_INITIAL_PACKED_ARRAY_CAPACITY = 16;
    static final int MAX_SUPPORTED_PACKED_COUNTS_ARRAY_LENGTH = 8191;
    private final boolean isPacked;
    private int physicalLength;
    private int virtualLength = 0;
    private int topLevelShift = Integer.MAX_VALUE;

    AbstractPackedArrayContext(int n2, int n3) {
        this.physicalLength = Math.max(n3, 16);
        boolean bl2 = this.isPacked = this.physicalLength <= 8191;
        if (!this.isPacked) {
            this.physicalLength = n2;
        }
    }

    void init(int n2) {
        if (!this.isPacked()) {
            this.virtualLength = n2;
            return;
        }
        while (!this.casPopulatedShortLength(this.getPopulatedShortLength(), 8)) {
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            this.setAtShortIndex(0 + i2, (short)0);
        }
        this.setVirtualLength(n2);
    }

    abstract int length();

    abstract int getPopulatedShortLength();

    abstract boolean casPopulatedShortLength(int var1, int var2);

    abstract boolean casPopulatedLongLength(int var1, int var2);

    abstract long getAtLongIndex(int var1);

    abstract boolean casAtLongIndex(int var1, long var2, long var4);

    abstract void lazySetAtLongIndex(int var1, long var2);

    abstract void clearContents();

    abstract void resizeArray(int var1);

    abstract long getAtUnpackedIndex(int var1);

    abstract void setAtUnpackedIndex(int var1, long var2);

    abstract void lazysetAtUnpackedIndex(int var1, long var2);

    abstract long incrementAndGetAtUnpackedIndex(int var1);

    abstract long addAndGetAtUnpackedIndex(int var1, long var2);

    abstract String unpackedToString();

    void setValuePart(int n2, long l2, long l3, int n3) {
        long l4;
        long l5;
        boolean bl2;
        while (!(bl2 = this.casAtLongIndex(n2, l5 = this.getAtLongIndex(n2), l4 = l5 & (l3 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n3))) {
        }
    }

    short getAtShortIndex(int n2) {
        return (short)(this.getAtLongIndex(n2 >> 2) >> ((n2 & 3) << 4) & 0xFFFFL);
    }

    short getIndexAtShortIndex(int n2) {
        return (short)(this.getAtLongIndex(n2 >> 2) >> ((n2 & 3) << 4) & 0x7FFFL);
    }

    void setAtShortIndex(int n2, short s2) {
        int n3 = n2 >> 2;
        int n4 = (n2 & 3) << 4;
        long l2 = 65535L << n4;
        long l3 = (long)s2 & 0xFFFFL;
        this.setValuePart(n3, l3, l2, n4);
    }

    boolean casAtShortIndex(int n2, short s2, short s3) {
        long l2;
        long l3;
        boolean bl2;
        int n3 = n2 >> 2;
        int n4 = (n2 & 3) << 4;
        long l4 = 65535L << n4 ^ 0xFFFFFFFFFFFFFFFFL;
        long l5 = (long)s3 & 0xFFFFL;
        long l6 = (long)s2 & 0xFFFFL;
        do {
            long l7;
            if ((l7 = (l3 = this.getAtLongIndex(n3)) >> n4 & 0xFFFFL) == l6) continue;
            return false;
        } while (!(bl2 = this.casAtLongIndex(n3, l3, l2 = l3 & l4 | l5 << n4)));
        return true;
    }

    byte getAtByteIndex(int n2) {
        return (byte)(this.getAtLongIndex(n2 >> 3) >> ((n2 & 7) << 3) & 0xFFL);
    }

    void setAtByteIndex(int n2, byte by2) {
        int n3 = n2 >> 3;
        int n4 = (n2 & 7) << 3;
        long l2 = 255L << n4;
        long l3 = (long)by2 & 0xFFL;
        this.setValuePart(n3, l3, l2, n4);
    }

    long addAtByteIndex(int n2, byte by2) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        boolean bl2;
        int n3 = n2 >> 3;
        int n4 = (n2 & 7) << 3;
        long l7 = 255L << n4;
        while (!(bl2 = this.casAtLongIndex(n3, l6 = this.getAtLongIndex(n3), l5 = l6 & (l7 ^ 0xFFFFFFFFFFFFFFFFL) | (l4 = (l3 = (l2 = l6 >> n4 & 0xFFL) + ((long)by2 & 0xFFL)) & 0xFFL) << n4))) {
        }
        return l3;
    }

    private int getPackedSlotIndicators(int n2) {
        return this.getAtShortIndex(n2 + 0) & 0xFFFF;
    }

    private void setPackedSlotIndicators(int n2, short s2) {
        this.setAtShortIndex(n2 + 0, s2);
    }

    private short getPreviousVersionIndex(int n2) {
        return this.getAtShortIndex(n2 + 1);
    }

    private void setPreviousVersionIndex(int n2, short s2) {
        this.setAtShortIndex(n2 + 1, s2);
    }

    private short getIndexAtEntrySlot(int n2, int n3) {
        return this.getAtShortIndex(n2 + 2 + n3);
    }

    private void setIndexAtEntrySlot(int n2, int n3, short s2) {
        this.setAtShortIndex(n2 + 2 + n3, s2);
    }

    private boolean casIndexAtEntrySlot(int n2, int n3, short s2, short s3) {
        return this.casAtShortIndex(n2 + 2 + n3, s2, s3);
    }

    private boolean casIndexAtEntrySlotIfNonZeroAndLessThan(int n2, int n3, short s2) {
        short s3;
        boolean bl2;
        do {
            if ((s3 = this.getIndexAtEntrySlot(n2, n3)) == 0) {
                return false;
            }
            if (s2 > s3) continue;
            return false;
        } while (!(bl2 = this.casIndexAtEntrySlot(n2, n3, s3, s2)));
        return true;
    }

    private void expandArrayIfNeeded(int n2) throws ResizeException {
        int n3 = this.length();
        if (this.length() < this.getPopulatedLongLength() + n2) {
            int n4 = Math.max(n2, 16);
            n4 = Math.max(n4, this.getPopulatedLongLength() >> 4);
            throw new ResizeException(n3 + n4);
        }
    }

    private int newEntry(int n2) throws ResizeException {
        int n3;
        boolean bl2;
        do {
            n3 = this.getPopulatedShortLength();
            this.expandArrayIfNeeded((n2 >> 2) + 1);
        } while (!(bl2 = this.casPopulatedShortLength(n3, n3 + n2)));
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setAtShortIndex(n3 + i2, (short)-1);
        }
        return n3;
    }

    private int newLeafEntry() throws ResizeException {
        int n2;
        boolean bl2;
        do {
            n2 = this.getPopulatedLongLength();
            this.expandArrayIfNeeded(1);
        } while (!(bl2 = this.casPopulatedLongLength(n2, n2 + 1)));
        this.lazySetAtLongIndex(n2, 0L);
        return n2;
    }

    private void consolidateEntry(int n2) {
        short s2 = this.getPreviousVersionIndex(n2);
        if (s2 == 0) {
            return;
        }
        if (this.getPreviousVersionIndex(s2) != 0) {
            throw new IllegalStateException("Encountered Previous Version Entry that is not itself consolidated.");
        }
        int n3 = this.getPackedSlotIndicators(s2);
        int n4 = this.getPackedSlotIndicators(n2);
        int n5 = n4 ^ n3;
        int n6 = n4 & n5 - 1;
        int n7 = Integer.bitCount(n6);
        int n8 = Integer.bitCount(n4);
        int n9 = 0;
        for (int i2 = 0; i2 < n8; ++i2) {
            if (i2 == n7) continue;
            boolean bl2 = true;
            do {
                short s3;
                if ((s3 = this.getIndexAtEntrySlot(s2, n9)) == 0) continue;
                this.casIndexAtEntrySlotIfNonZeroAndLessThan(n2, i2, s3);
                bl2 = this.casIndexAtEntrySlot(s2, n9, s3, (short)0);
            } while (!bl2);
            ++n9;
        }
        this.setPreviousVersionIndex(n2, (short)0);
    }

    private int expandEntry(int n2, int n3, int n4, int n5, boolean bl2) throws RetryException, ResizeException {
        int n6 = this.getAtShortIndex(n2) & 0xFFFF;
        int n7 = Integer.bitCount(n6 |= n5);
        if (n4 >= n7) {
            throw new IllegalStateException("inserted slot index is out of range given provided masks");
        }
        int n8 = n7 + 2;
        int n9 = 0;
        if (bl2) {
            n9 = this.newLeafEntry();
        } else {
            n9 = this.newEntry(2);
            this.setPackedSlotIndicators(n9, (short)0);
            this.setPreviousVersionIndex(n9, (short)0);
        }
        short s2 = (short)n9;
        int n10 = this.newEntry(n8);
        this.setPackedSlotIndicators(n10, (short)n6);
        this.setPreviousVersionIndex(n10, (short)n2);
        this.setIndexAtEntrySlot(n10, n4, s2);
        boolean bl3 = this.casAtShortIndex(n3, (short)n2, (short)n10);
        if (!bl3) {
            throw new RetryException();
        }
        this.consolidateEntry(n10);
        return n10;
    }

    private int getRootEntry(int n2) {
        try {
            return this.getRootEntry(n2, false);
        }
        catch (RetryException | ResizeException exception) {
            throw new IllegalStateException("Should not Resize or Retry exceptions on real-only read: ", exception);
        }
    }

    private int getRootEntry(int n2, boolean bl2) throws RetryException, ResizeException {
        int n3 = 0 + n2;
        int n4 = this.getIndexAtShortIndex(n3);
        if (n4 == 0) {
            if (!bl2) {
                return 0;
            }
            n4 = this.newEntry(2);
            this.setPackedSlotIndicators(n4, (short)0);
            this.setPreviousVersionIndex(n4, (short)0);
            boolean bl3 = this.casAtShortIndex(n3, (short)0, (short)n4);
            if (!bl3) {
                throw new RetryException();
            }
        }
        if (this.getTopLevelShift() != 3 && this.getPreviousVersionIndex(n4) != 0) {
            this.consolidateEntry(n4);
        }
        return n4;
    }

    int getPackedIndex(int n2, int n3, boolean bl2) throws ResizeException {
        int n4 = 0;
        do {
            try {
                assert (n2 >= 0 && n2 < 8);
                if (n3 >= this.getVirtualLength()) {
                    throw new ArrayIndexOutOfBoundsException(String.format("Attempting access at index %d, beyond virtualLength %d", n3, this.getVirtualLength()));
                }
                int n5 = 0 + n2;
                int n6 = this.getRootEntry(n2, bl2);
                if (n6 == 0) {
                    return -1;
                }
                for (int i2 = this.getTopLevelShift(); i2 >= 3; i2 -= 4) {
                    boolean bl3 = i2 == 3;
                    int n7 = this.getPackedSlotIndicators(n6);
                    int n8 = n3 >>> i2 & 0xF;
                    int n9 = 1 << n8;
                    int n10 = n7 & n9 - 1;
                    int n11 = Integer.bitCount(n10);
                    if ((n7 & n9) == 0) {
                        if (!bl2) {
                            return -1;
                        }
                        n6 = this.expandEntry(n6, n5, n11, n9, bl3);
                    }
                    if ((n6 = (int)this.getIndexAtShortIndex(n5 = n6 + 2 + n11)) == 0) {
                        throw new RetryException();
                    }
                    if (bl3 || this.getPreviousVersionIndex(n6) == 0) continue;
                    this.consolidateEntry(n6);
                }
                n4 = (n6 << 3) + (n3 & 7);
            }
            catch (RetryException retryException) {
                // empty catch block
            }
        } while (n4 == 0);
        return n4;
    }

    private long contextLocalGetValueAtIndex(int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            long l3;
            int n3 = 0;
            do {
                try {
                    n3 = this.getPackedIndex(i2, n2, false);
                    if (n3 < 0) {
                        return l2;
                    }
                    l3 = ((long)this.getAtByteIndex(n3) & 0xFFL) << (i2 << 3);
                }
                catch (ResizeException resizeException) {
                    throw new IllegalStateException("Should never encounter a resize excpetion without inserts");
                }
            } while (n3 == 0);
            l2 += l3;
        }
        return l2;
    }

    void populateEquivalentEntriesWithZerosFromOther(AbstractPackedArrayContext abstractPackedArrayContext) {
        if (this.getVirtualLength() < abstractPackedArrayContext.getVirtualLength()) {
            throw new IllegalStateException("Cannot populate array of smaller virtrual length");
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            short s2 = abstractPackedArrayContext.getAtShortIndex(0 + i2);
            if (s2 == 0) continue;
            int n2 = 0 + i2;
            for (i2 = this.getTopLevelShift(); i2 > abstractPackedArrayContext.getTopLevelShift(); i2 -= 4) {
                int n3 = 3;
                int n4 = 0;
                do {
                    try {
                        n4 = this.newEntry(n3);
                    }
                    catch (ResizeException resizeException) {
                        this.resizeArray(resizeException.getNewSize());
                    }
                } while (n4 == 0);
                this.setAtShortIndex(n2, (short)n4);
                this.setPackedSlotIndicators(n4, (short)1);
                this.setPreviousVersionIndex(n4, (short)0);
                n2 = n4 + 2;
            }
            this.copyEntriesAtLevelFromOther(abstractPackedArrayContext, s2, n2, abstractPackedArrayContext.getTopLevelShift());
        }
    }

    private void copyEntriesAtLevelFromOther(AbstractPackedArrayContext abstractPackedArrayContext, int n2, int n3, int n4) {
        boolean bl2 = n4 == 3;
        int n5 = abstractPackedArrayContext.getPackedSlotIndicators(n2);
        int n6 = Integer.bitCount(n5);
        int n7 = 2 + n6;
        int n8 = 0;
        do {
            try {
                n8 = this.newEntry(n7);
            }
            catch (ResizeException resizeException) {
                this.resizeArray(resizeException.getNewSize());
            }
        } while (n8 == 0);
        this.setAtShortIndex(n3, (short)n8);
        this.setAtShortIndex(n8 + 0, (short)n5);
        this.setAtShortIndex(n8 + 1, (short)0);
        for (int i2 = 0; i2 < n6; ++i2) {
            int n9;
            if (bl2) {
                n9 = 0;
                do {
                    try {
                        n9 = this.newLeafEntry();
                    }
                    catch (ResizeException resizeException) {
                        this.resizeArray(resizeException.getNewSize());
                    }
                } while (n9 == 0);
                this.setIndexAtEntrySlot(n8, i2, (short)n9);
                this.lazySetAtLongIndex(n9, 0L);
                continue;
            }
            n9 = abstractPackedArrayContext.getIndexAtEntrySlot(n2, i2);
            this.copyEntriesAtLevelFromOther(abstractPackedArrayContext, n9, n8 + 2 + i2, n4 - 4);
        }
    }

    private int seekToPopulatedVirtualIndexStartingAtLevel(int n2, int n3, int n4) throws RetryException {
        boolean bl2;
        int n5 = n2;
        int n6 = (n5 >>> n4 | 0xF) + 1 << n4;
        boolean bl3 = bl2 = n4 == 3;
        do {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if ((n12 = Integer.numberOfTrailingZeros(n11 = (n10 = this.getPackedSlotIndicators(n3)) & ~((n9 = 1 << (n8 = n5 >>> n4 & 0xF)) - 1))) > 15) {
                n7 = n4 + 4;
                n5 += 1 << n7;
                return -(n5 &= ~((1 << n7) - 1));
            }
            if (n12 != n8) {
                n5 += n12 - n8 << n4;
                n5 &= ~((1 << n4) - 1);
            }
            if (bl2) {
                return n5;
            }
            n7 = 1 << n12;
            int n13 = n10 & n7 - 1;
            int n14 = Integer.bitCount(n13);
            if ((n10 & n7) == 0) {
                throw new IllegalStateException("Unexpected 0 at slot index");
            }
            int n15 = n3 + 2 + n14;
            short s2 = this.getIndexAtShortIndex(n15);
            if (s2 == 0) {
                throw new RetryException();
            }
            if (this.getPreviousVersionIndex(s2) != 0) {
                this.consolidateEntry(s2);
            }
            if ((n5 = this.seekToPopulatedVirtualIndexStartingAtLevel(n5, s2, n4 - 4)) >= 0) {
                return n5;
            }
            n5 = -n5;
        } while (n5 < n6);
        return n5;
    }

    private int findFirstPotentiallyPopulatedVirtualIndexStartingAt(int n2) {
        boolean bl2;
        int n3 = -1;
        do {
            bl2 = false;
            try {
                int n4 = this.getRootEntry(0);
                if (n4 == 0) {
                    return this.getVirtualLength();
                }
                n3 = this.seekToPopulatedVirtualIndexStartingAtLevel(n2, n4, this.getTopLevelShift());
            }
            catch (RetryException retryException) {
                bl2 = true;
            }
        } while (bl2);
        if (n3 < 0 || n3 >= this.getVirtualLength()) {
            return this.getVirtualLength();
        }
        return n3;
    }

    Iterable<IterationValue> nonZeroValues() {
        return new Iterable<IterationValue>(){

            @Override
            public Iterator<IterationValue> iterator() {
                return new NonZeroValuesIterator();
            }
        };
    }

    boolean isPacked() {
        return this.isPacked;
    }

    int getPhysicalLength() {
        return this.physicalLength;
    }

    int getVirtualLength() {
        return this.virtualLength;
    }

    int determineTopLevelShiftForVirtualLength(int n2) {
        int n3 = (int)Math.ceil(Math.log(n2) / Math.log(2.0));
        int n4 = n3 - 3;
        int n5 = (int)Math.ceil((double)n4 / 4.0) * 4;
        n5 = Math.max(n5, 8);
        int n6 = n5 - 4 + 3;
        return n6;
    }

    void setVirtualLength(int n2) {
        if (!this.isPacked()) {
            throw new IllegalStateException("Should never be adjusting the virtual size of a non-packed context");
        }
        int n3 = this.determineTopLevelShiftForVirtualLength(n2);
        this.setTopLevelShift(n3);
        this.virtualLength = n2;
    }

    int getTopLevelShift() {
        return this.topLevelShift;
    }

    private void setTopLevelShift(int n2) {
        this.topLevelShift = n2;
    }

    int getPopulatedLongLength() {
        return this.getPopulatedShortLength() + 3 >> 2;
    }

    int getPopulatedByteLength() {
        return this.getPopulatedShortLength() << 1;
    }

    private String nonLeafEntryToString(int n2, int n3, int n4) {
        int n5;
        String string = "";
        for (n5 = 0; n5 < n4; ++n5) {
            string = string + "  ";
        }
        try {
            int n6;
            n5 = this.getPackedSlotIndicators(n2);
            string = string + String.format("slotIndiators: 0x%02x, prevVersionIndex: %3d: [ ", n5, this.getPreviousVersionIndex(n2));
            int n7 = Integer.bitCount(n5);
            for (n6 = 0; n6 < n7; ++n6) {
                string = string + String.format("%d", this.getIndexAtEntrySlot(n2, n6));
                if (n6 >= n7 - 1) continue;
                string = string + ", ";
            }
            string = string + String.format(" ] (indexShift = %d)\n", n3);
            n6 = n3 == 3 ? 1 : 0;
            for (int i2 = 0; i2 < n7; ++i2) {
                short s2 = this.getIndexAtEntrySlot(n2, i2);
                string = n6 != 0 ? string + this.leafEntryToString(s2, n4 + 4) : string + this.nonLeafEntryToString(s2, n3 - 4, n4 + 4);
            }
        }
        catch (Exception exception) {
            string = string + String.format("Exception thrown at nonLeafEnty at index %d with indexShift %d\n", n2, n3);
        }
        return string;
    }

    private String leafEntryToString(int n2, int n3) {
        int n4;
        String string = "";
        for (n4 = 0; n4 < n3; ++n4) {
            string = string + "  ";
        }
        try {
            string = string + "Leaf bytes : ";
            for (n4 = 56; n4 >= 0; n4 -= 8) {
                string = string + String.format("0x%02x ", this.getAtLongIndex(n2) >>> n4 & 0xFFL);
            }
            string = string + "\n";
        }
        catch (Exception exception) {
            string = string + String.format("Exception thrown at leafEnty at index %d\n", n2);
        }
        return string;
    }

    private String recordedValuesToString() {
        String string = "";
        try {
            for (IterationValue iterationValue : this.nonZeroValues()) {
                string = string + String.format("[%d] : %d\n", iterationValue.getIndex(), iterationValue.getValue());
            }
            return string;
        }
        catch (Exception exception) {
            string = string + "!!! Exception thown in value iteration...\n";
            return string;
        }
    }

    public String toString() {
        String string = "PackedArrayContext:\n";
        if (!this.isPacked()) {
            return string + "Context is unpacked:\n" + this.unpackedToString();
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            try {
                int n2 = 0 + i2;
                short s2 = this.getIndexAtShortIndex(n2);
                string = string + String.format("Set %d: root = %d \n", i2, (int)s2);
                if (s2 == 0) continue;
                string = string + this.nonLeafEntryToString(s2, this.getTopLevelShift(), 4);
                continue;
            }
            catch (Exception exception) {
                string = string + String.format("Exception thrown in set %d\n", i2);
            }
        }
        string = string + this.recordedValuesToString();
        return string;
    }

    private static class RetryException
    extends Exception {
        private RetryException() {
        }
    }

    class NonZeroValues
    implements Iterable<IterationValue> {
        NonZeroValues() {
        }

        @Override
        public Iterator<IterationValue> iterator() {
            return new NonZeroValuesIterator();
        }
    }

    class NonZeroValuesIterator
    implements Iterator<IterationValue> {
        int nextVirtrualIndex = 0;
        long nextValue;
        final IterationValue currentIterationValue = new IterationValue();

        private void findFirstNonZeroValueVirtualIndexStartingAt(int n2) {
            if (!AbstractPackedArrayContext.this.isPacked()) {
                this.nextVirtrualIndex = n2;
                while (this.nextVirtrualIndex < AbstractPackedArrayContext.this.getVirtualLength()) {
                    this.nextValue = AbstractPackedArrayContext.this.getAtUnpackedIndex(this.nextVirtrualIndex);
                    if (this.nextValue != 0L) {
                        return;
                    }
                    ++this.nextVirtrualIndex;
                }
                return;
            }
            this.nextVirtrualIndex = n2;
            while (true) {
                this.nextVirtrualIndex = AbstractPackedArrayContext.this.findFirstPotentiallyPopulatedVirtualIndexStartingAt(this.nextVirtrualIndex);
                if (this.nextVirtrualIndex >= AbstractPackedArrayContext.this.getVirtualLength() || (this.nextValue = AbstractPackedArrayContext.this.contextLocalGetValueAtIndex(this.nextVirtrualIndex)) != 0L) break;
                ++this.nextVirtrualIndex;
            }
        }

        @Override
        public IterationValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentIterationValue.set(this.nextVirtrualIndex, this.nextValue);
            this.findFirstNonZeroValueVirtualIndexStartingAt(this.nextVirtrualIndex + 1);
            return this.currentIterationValue;
        }

        @Override
        public boolean hasNext() {
            return this.nextVirtrualIndex >= 0 && this.nextVirtrualIndex < AbstractPackedArrayContext.this.getVirtualLength();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        NonZeroValuesIterator() {
            this.findFirstNonZeroValueVirtualIndexStartingAt(0);
        }
    }
}

