/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string, String string2, long l2, String string3, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.name = string;
        this.value = string2;
        this.expiresAt = l2;
        this.domain = string3;
        this.path = string4;
        this.secure = bl2;
        this.httpOnly = bl3;
        this.hostOnly = bl4;
        this.persistent = bl5;
    }

    Cookie(Builder builder) {
        if (builder.name == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (builder.value == null) {
            throw new NullPointerException("builder.value == null");
        }
        if (builder.domain == null) {
            throw new NullPointerException("builder.domain == null");
        }
        this.name = builder.name;
        this.value = builder.value;
        this.expiresAt = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean matches(HttpUrl httpUrl) {
        boolean bl2;
        boolean bl3 = bl2 = this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain);
        if (!bl2) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    private static boolean domainMatch(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(string2) && string.charAt(string.length() - string2.length() - 1) == '.' && !Util.verifyAsIpAddress(string);
    }

    private static boolean pathMatch(HttpUrl httpUrl, String string) {
        String string2 = httpUrl.encodedPath();
        if (string2.equals(string)) {
            return true;
        }
        if (string2.startsWith(string)) {
            if (string.endsWith("/")) {
                return true;
            }
            if (string2.charAt(string.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string);
    }

    @Nullable
    static Cookie parse(long l2, HttpUrl httpUrl, String string) {
        long l3;
        int n2 = 0;
        int n3 = string.length();
        int n4 = Util.delimiterOffset(string, n2, n3, ';');
        int n5 = Util.delimiterOffset(string, n2, n4, '=');
        if (n5 == n4) {
            return null;
        }
        String string2 = Util.trimSubstring(string, n2, n5);
        if (string2.isEmpty() || Util.indexOfControlOrNonAscii(string2) != -1) {
            return null;
        }
        String string3 = Util.trimSubstring(string, n5 + 1, n4);
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        long l4 = 253402300799999L;
        long l5 = -1L;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        n2 = n4 + 1;
        while (n2 < n3) {
            String string6;
            int n6 = Util.delimiterOffset(string, n2, n3, ';');
            int n7 = Util.delimiterOffset(string, n2, n6, '=');
            String string7 = Util.trimSubstring(string, n2, n7);
            String string8 = string6 = n7 < n6 ? Util.trimSubstring(string, n7 + 1, n6) : "";
            if (string7.equalsIgnoreCase("expires")) {
                try {
                    l4 = Cookie.parseExpires(string6, 0, string6.length());
                    bl5 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("max-age")) {
                try {
                    l5 = Cookie.parseMaxAge(string6);
                    bl5 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string7.equalsIgnoreCase("domain")) {
                try {
                    string4 = Cookie.parseDomain(string6);
                    bl4 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("path")) {
                string5 = string6;
            } else if (string7.equalsIgnoreCase("secure")) {
                bl2 = true;
            } else if (string7.equalsIgnoreCase("httponly")) {
                bl3 = true;
            }
            n2 = n6 + 1;
        }
        if (l5 == Long.MIN_VALUE) {
            l4 = Long.MIN_VALUE;
        } else if (l5 != -1L && ((l4 = l2 + (l3 = l5 <= 9223372036854775L ? l5 * 1000L : Long.MAX_VALUE)) < l2 || l4 > 253402300799999L)) {
            l4 = 253402300799999L;
        }
        String string9 = httpUrl.host();
        if (string4 == null) {
            string4 = string9;
        } else if (!Cookie.domainMatch(string9, string4)) {
            return null;
        }
        if (string9.length() != string4.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string4) == null) {
            return null;
        }
        if (string5 == null || !string5.startsWith("/")) {
            String string10 = httpUrl.encodedPath();
            int n8 = string10.lastIndexOf(47);
            string5 = n8 != 0 ? string10.substring(0, n8) : "/";
        }
        return new Cookie(string2, string3, l4, string4, string5, bl2, bl3, bl4, bl5);
    }

    private static long parseExpires(String string, int n2, int n3) {
        n2 = Cookie.dateCharacterOffset(string, n2, n3, false);
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string);
        while (n2 < n3) {
            int n10 = Cookie.dateCharacterOffset(string, n2 + 1, n3, true);
            matcher.region(n2, n10);
            if (n4 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n4 = Integer.parseInt(matcher.group(1));
                n5 = Integer.parseInt(matcher.group(2));
                n6 = Integer.parseInt(matcher.group(3));
            } else if (n7 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n7 = Integer.parseInt(matcher.group(1));
            } else if (n8 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n8 = MONTH_PATTERN.pattern().indexOf(string2) / 4;
            } else if (n9 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n9 = Integer.parseInt(matcher.group(1));
            }
            n2 = Cookie.dateCharacterOffset(string, n10 + 1, n3, false);
        }
        if (n9 >= 70 && n9 <= 99) {
            n9 += 1900;
        }
        if (n9 >= 0 && n9 <= 69) {
            n9 += 2000;
        }
        if (n9 < 1601) {
            throw new IllegalArgumentException();
        }
        if (n8 == -1) {
            throw new IllegalArgumentException();
        }
        if (n7 < 1 || n7 > 31) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException();
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException();
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(1, n9);
        gregorianCalendar.set(2, n8 - 1);
        gregorianCalendar.set(5, n7);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static int dateCharacterOffset(String string, int n2, int n3, boolean bl2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            boolean bl3 = c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':';
            if (bl3 != !bl2) continue;
            return i2;
        }
        return n3;
    }

    private static long parseMaxAge(String string) {
        try {
            long l2 = Long.parseLong(string);
            return l2 <= 0L ? Long.MIN_VALUE : l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches("-?\\d+")) {
                return string.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string) {
        String string2;
        if (string.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((string2 = Util.canonicalizeHost(string)) == null) {
            throw new IllegalArgumentException();
        }
        return string2;
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers headers) {
        List<String> list = headers.values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse(httpUrl, list.get(i2));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (bl2) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        return cookie.name.equals(this.name) && cookie.value.equals(this.value) && cookie.domain.equals(this.domain) && cookie.path.equals(this.path) && cookie.expiresAt == this.expiresAt && cookie.secure == this.secure && cookie.httpOnly == this.httpOnly && cookie.persistent == this.persistent && cookie.hostOnly == this.hostOnly;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + this.name.hashCode();
        n2 = 31 * n2 + this.value.hashCode();
        n2 = 31 * n2 + this.domain.hashCode();
        n2 = 31 * n2 + this.path.hashCode();
        n2 = 31 * n2 + (int)(this.expiresAt ^ this.expiresAt >>> 32);
        n2 = 31 * n2 + (this.secure ? 0 : 1);
        n2 = 31 * n2 + (this.httpOnly ? 0 : 1);
        n2 = 31 * n2 + (this.persistent ? 0 : 1);
        n2 = 31 * n2 + (this.hostOnly ? 0 : 1);
        return n2;
    }

    public static final class Builder {
        String name;
        String value;
        long expiresAt = 253402300799999L;
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        public Builder name(String string) {
            if (string == null) {
                throw new NullPointerException("name == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("name is not trimmed");
            }
            this.name = string;
            return this;
        }

        public Builder value(String string) {
            if (string == null) {
                throw new NullPointerException("value == null");
            }
            if (!string.trim().equals(string)) {
                throw new IllegalArgumentException("value is not trimmed");
            }
            this.value = string;
            return this;
        }

        public Builder expiresAt(long l2) {
            if (l2 <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            if (l2 > 253402300799999L) {
                l2 = 253402300799999L;
            }
            this.expiresAt = l2;
            this.persistent = true;
            return this;
        }

        public Builder domain(String string) {
            return this.domain(string, false);
        }

        public Builder hostOnlyDomain(String string) {
            return this.domain(string, true);
        }

        private Builder domain(String string, boolean bl2) {
            if (string == null) {
                throw new NullPointerException("domain == null");
            }
            String string2 = Util.canonicalizeHost(string);
            if (string2 == null) {
                throw new IllegalArgumentException("unexpected domain: " + string);
            }
            this.domain = string2;
            this.hostOnly = bl2;
            return this;
        }

        public Builder path(String string) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("path must start with '/'");
            }
            this.path = string;
            return this;
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

