/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.functions.AbstractFunction1D;
import io.fair_acc.math.functions.Function1D;

public class SigmoidFunction
extends AbstractFunction1D
implements Function1D {
    public SigmoidFunction(String string) {
        this(string, null);
    }

    public SigmoidFunction(String string, double[] dArray) {
        super(string, new double[3]);
        this.setParameterName(0, "location");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "slope");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "scaling");
        this.setParameterValue(2, 1.0);
        this.fixParameter(2, true);
        if (dArray == null) {
            return;
        }
        for (int i2 = 0; i2 < Math.min(dArray.length, 3); ++i2) {
            this.setParameterValue(i2, dArray[i2]);
        }
    }

    @Override
    public double getValue(double d2) {
        return this.fparameter[2] / (1.0 + MathBase.exp(-this.fparameter[1] * (d2 - this.fparameter[0])));
    }
}

