/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.Histogram;
import io.fair_acc.dataset.Histogram1D;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractHistogram;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.List;

public class Histogram
extends AbstractHistogram
implements Histogram1D,
DataSet2D {
    private static final long serialVersionUID = -8609726961834745312L;
    protected final boolean isHorizontal;

    public Histogram(String string, double[] dArray) {
        this(string, dArray, true);
    }

    public Histogram(String string, double[] dArray, boolean bl2) {
        super(string, dArray);
        this.isHorizontal = bl2;
        if (!this.isHorizontal) {
            this.flipAbscissaWithOrdinate();
        }
    }

    public Histogram(String string, int n2, double d2, double d3, AbstractHistogram.HistogramOuterBounds histogramOuterBounds) {
        this(string, n2, d2, d3, true, histogramOuterBounds);
    }

    public Histogram(String string, int n2, double d2, double d3, boolean bl2, AbstractHistogram.HistogramOuterBounds histogramOuterBounds) {
        super(string, n2, d2, d3, histogramOuterBounds);
        this.isHorizontal = bl2;
        if (!this.isHorizontal) {
            this.flipAbscissaWithOrdinate();
        }
    }

    @Override
    public void addBinContent(int n2, double d2) {
        this.lock().writeLockGuard(() -> {
            int n3 = n2;
            this.data[n3] = this.data[n3] + d2;
            if (n2 == 0 || n2 == this.data.length - 1) {
                return;
            }
            if (this.getDimension() == 2) {
                this.getAxisDescription(this.isHorizontal ? 1 : 0).add(this.data[n2]);
            } else {
                this.getAxisDescription(this.getDimension() - 1).add(this.data[n2]);
            }
        });
        this.fireInvalidated(ChartBits.DataSetData);
    }

    @Override
    public int fill(double d2, double d3) {
        int n2 = this.lock().writeLockGuard(() -> {
            int n2 = this.findBin(this.isHorizontal ? 0 : 1, d2);
            this.addBinContent(n2, d3);
            return n2;
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return n2;
    }

    @Override
    public void fillN(double[] dArray, double[] dArray2, int n2) {
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.fill(dArray[i2], dArray2[i2]);
            }
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
    }

    @Override
    public double get(int n2, int n3) {
        switch (this.getBoundsType()) {
            case BINS_CENTERED_ON_BOUNDARY: {
                switch (n2) {
                    case 0: {
                        return this.isHorizontal ? this.getBinCenter(0, n3 + 1) : this.getBinContent(n3 + 1);
                    }
                    case 1: {
                        return this.isHorizontal ? this.getBinContent(n3 + 1) : this.getBinCenter(1, n3 + 1);
                    }
                }
                return n2 + 1 < this.getDimension() ? this.getBinCenter(0, n3 + 1) : this.getBinContent(n3 + 1);
            }
        }
        switch (n2) {
            case 0: {
                return this.isHorizontal ? this.getBinLimits(0, Histogram.Boundary.LOWER, n3 + 1) : this.getBinContent(n3 + 1);
            }
            case 1: {
                return this.isHorizontal ? this.getBinContent(n3 + 1) : this.getBinLimits(1, Histogram.Boundary.LOWER, n3 + 1);
            }
        }
        return n2 + 1 < this.getDimension() ? this.getBinLimits(0, Histogram.Boundary.LOWER, n3 + 1) : this.getBinContent(n3 + 1);
    }

    @Override
    public int getIndex(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("value", dArray, 1);
        return Math.max(this.findBin(n2, dArray[0]) - 1, 0);
    }

    @Override
    public List<String> getWarningList() {
        List<String> list = super.getWarningList();
        if (this.getBinContent(0) > 0.0 && !list.contains("under-range")) {
            list.add("under-range");
        }
        if (this.getBinContent(this.data.length - 1) > 0.0 && !list.contains("over-range")) {
            list.add("over-range");
        }
        return list;
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        super.getWarningList().remove("under-range");
        super.getWarningList().remove("over-range");
        if (this.getDimension() == 2) {
            this.getAxisDescription(this.isHorizontal ? 1 : 0).clear();
        } else {
            this.getAxisDescription(this.getDimension() - 1).clear();
        }
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException("set is not implemented");
    }

    protected void flipAbscissaWithOrdinate() {
        this.getAxisDescription(1).set(this.getAxisDescription(0));
        this.getAxisDescription(0).clear();
        Histogram.swap(this.axisBins, 0, 1);
    }
}

