/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractErrorDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import io.fair_acc.dataset.spi.utils.DoublePointError;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.LimitedQueue;
import java.util.ArrayList;

public class FifoDoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSetError,
DataSet2D {
    private static final int SAFE_BET = 1;
    private static final long serialVersionUID = -7153702141838930486L;
    protected final transient LimitedQueue<DataBlob> data;
    protected double maxDistance;

    public FifoDoubleErrorDataSet(String string, int n2) {
        this(string, n2, Double.MAX_VALUE);
    }

    public FifoDoubleErrorDataSet(String string, int n2, double d2) {
        super(string, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.SYMMETRIC);
        if (n2 <= 0) {
            throw new IllegalArgumentException("negative or zero initialSize = " + n2);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("negative or zero maxDistance = " + d2);
        }
        this.maxDistance = d2;
        this.data = new LimitedQueue(n2);
    }

    public FifoDoubleErrorDataSet add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, null);
    }

    public FifoDoubleErrorDataSet add(double d2, double d3, double d4, double d5, String string) {
        return this.add(d2, d3, d4, d5, string, null);
    }

    public FifoDoubleErrorDataSet add(double d2, double d3, double d4, double d5, String string, String string2) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DataBlob(d2, d3, d4, d5, string, string2));
            this.getAxisDescription(0).add(d2);
            this.getAxisDescription(1).add(d3 - d4);
            this.getAxisDescription(1).add(d3 + d5);
            this.expire(d2);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return this;
    }

    public FifoDoubleErrorDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        AssertUtils.notNull("X coordinates", dArray);
        AssertUtils.notNull("Y coordinates", dArray2);
        AssertUtils.notNull("Y error neg", dArray3);
        AssertUtils.notNull("Y error pos", dArray4);
        int n2 = Math.min(Math.min(dArray.length, dArray2.length), Math.min(dArray3.length, dArray4.length));
        return this.add(dArray, dArray2, dArray3, dArray4, n2);
    }

    public FifoDoubleErrorDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        this.lock().writeLockGuard(() -> {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add(dArray[i2], dArray2[i2], dArray3[i2], dArray4[i2]);
            }
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return this;
    }

    public int expire(double d2) {
        int n2 = this.lock().writeLockGuard(() -> {
            ArrayList<DataBlob> arrayList = new ArrayList<DataBlob>(1);
            for (DataBlob dataBlob : this.data) {
                double d3 = dataBlob.getX();
                if (Double.isFinite(d3) && !(Math.abs(d2 - d3) > this.maxDistance)) continue;
                arrayList.add(dataBlob);
            }
            if (!arrayList.isEmpty()) {
                this.data.removeAll(arrayList);
                this.getAxisDescriptions().forEach(AxisDescription::clear);
            }
            return arrayList.size();
        });
        if (n2 != 0) {
            this.fireInvalidated(ChartBits.DataSetDataRemoved);
        }
        return n2;
    }

    @Override
    public final double get(int n2, int n3) {
        return n2 == 0 ? ((DataBlob)this.data.get(n3)).getX() : ((DataBlob)this.data.get(n3)).getY();
    }

    public LimitedQueue<DataBlob> getData() {
        return this.data;
    }

    @Override
    public int getDataCount() {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int n2) {
        return ((DataBlob)this.data.get(n2)).getDataLabel();
    }

    @Override
    public double getErrorNegative(int n2, int n3) {
        return n2 == 0 ? 0.0 : ((DataBlob)this.data.get(n3)).getErrorX();
    }

    @Override
    public double getErrorPositive(int n2, int n3) {
        return n2 == 0 ? 0.0 : ((DataBlob)this.data.get(n3)).getErrorY();
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public String getStyle(int n2) {
        return ((DataBlob)this.data.get(n2)).getStyle();
    }

    public void reset() {
        this.data.clear();
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
    }

    public void setMaxDistance(double d2) {
        this.maxDistance = d2;
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            this.reset();
            int n2 = dataSet.getDataCount();
            if (dataSet instanceof DataSetError) {
                this.add(dataSet.getValues(0), dataSet.getValues(1), ((DataSetError)dataSet).getErrorsNegative(1), ((DataSetError)dataSet).getErrorsPositive(1), dataSet.getDataCount());
            } else {
                this.add(dataSet.getValues(0), dataSet.getValues(1), new double[n2], new double[n2], dataSet.getDataCount());
            }
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return this.getThis();
    }

    protected static class DataBlob
    extends DoublePointError {
        protected String style;
        protected String tag;

        protected DataBlob(double d2, double d3, double d4, double d5, String string, String string2) {
            super(d2, d3, d4, d5);
            this.tag = string;
            this.style = string2;
        }

        public String getDataLabel() {
            return this.tag;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

