/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractErrorDataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.CircularBuffer;
import io.fair_acc.dataset.utils.DoubleCircularBuffer;

public class CircularDoubleErrorDataSet
extends AbstractErrorDataSet<CircularDoubleErrorDataSet>
implements DataSetError,
DataSet2D {
    private static final long serialVersionUID = -8010355203980379253L;
    protected DoubleCircularBuffer xValues;
    protected DoubleCircularBuffer yValues;
    protected DoubleCircularBuffer yErrorsPos;
    protected DoubleCircularBuffer yErrorsNeg;
    protected CircularBuffer<String> dataLabels;
    protected CircularBuffer<String> dataStyles;

    public CircularDoubleErrorDataSet(String string, int n2) {
        super(string, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initialSize", n2);
        this.xValues = new DoubleCircularBuffer(n2);
        this.yValues = new DoubleCircularBuffer(n2);
        this.yErrorsPos = new DoubleCircularBuffer(n2);
        this.yErrorsNeg = new DoubleCircularBuffer(n2);
        this.dataLabels = new CircularBuffer(n2);
        this.dataStyles = new CircularBuffer(n2);
    }

    public CircularDoubleErrorDataSet add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, null);
    }

    public CircularDoubleErrorDataSet add(double d2, double d3, double d4, double d5, String string) {
        return this.add(d2, d3, d4, d5, string, null);
    }

    public CircularDoubleErrorDataSet add(double d2, double d3, double d4, double d5, String string, String string2) {
        this.lock().writeLockGuard(() -> {
            this.xValues.put(d2);
            this.yValues.put(d3);
            this.yErrorsPos.put(d5);
            this.yErrorsNeg.put(d4);
            this.dataLabels.put(string);
            this.dataStyles.put(string2);
            this.getAxisDescription(0).setMin(this.xValues.get(0));
            this.getAxisDescription(0).setMax(this.xValues.get(this.xValues.available() - 1));
            this.getAxisDescription(1).clear();
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (CircularDoubleErrorDataSet)this.getThis();
    }

    public CircularDoubleErrorDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        AssertUtils.notNull("X coordinates", dArray);
        AssertUtils.notNull("Y coordinates", dArray2);
        AssertUtils.notNull("Y error neg", dArray3);
        AssertUtils.notNull("Y error pos", dArray4);
        int n2 = Math.min(Math.min(dArray.length, dArray2.length), Math.min(dArray3.length, dArray4.length));
        return this.add(dArray, dArray2, dArray3, dArray4, n2);
    }

    public CircularDoubleErrorDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2) {
        AssertUtils.notNull("X coordinates", dArray);
        AssertUtils.notNull("Y coordinates", dArray2);
        AssertUtils.notNull("Y error neg", dArray3);
        AssertUtils.notNull("Y error pos", dArray4);
        AssertUtils.gtOrEqual("X coordinates", n2, dArray.length);
        AssertUtils.gtOrEqual("Y coordinates", n2, dArray2.length);
        AssertUtils.gtOrEqual("Y error neg", n2, dArray3.length);
        AssertUtils.gtOrEqual("Y error pos", n2, dArray4.length);
        this.lock().writeLockGuard(() -> {
            this.xValues.put(dArray, n2);
            this.yValues.put(dArray2, n2);
            this.yErrorsNeg.put(dArray3, n2);
            this.yErrorsPos.put(dArray4, n2);
            this.dataLabels.put((String[])new String[dArray2.length], n2);
            this.dataStyles.put((String[])new String[dArray2.length], n2);
            this.getAxisDescription(0).setMin(this.xValues.get(0));
            this.getAxisDescription(0).setMax(this.xValues.get(this.xValues.available() - 1));
            this.getAxisDescription(1).clear();
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (CircularDoubleErrorDataSet)this.getThis();
    }

    @Override
    public int getDataCount() {
        return this.xValues.available();
    }

    @Override
    public String getDataLabel(int n2) {
        return this.dataLabels.get(n2);
    }

    @Override
    public double getErrorNegative(int n2, int n3) {
        return n2 == 0 ? 0.0 : this.yErrorsNeg.get(n3);
    }

    @Override
    public double getErrorPositive(int n2, int n3) {
        return n2 == 0 ? 0.0 : this.yErrorsPos.get(n3);
    }

    @Override
    public String getStyle(int n2) {
        return this.dataStyles.get(n2);
    }

    @Override
    public final double get(int n2, int n3) {
        return n2 == 0 ? this.xValues.get(n3) : this.yValues.get(n3);
    }

    @Override
    public String addDataLabel(int n2, String string) {
        throw new UnsupportedOperationException("Adding data labels later is not supported, supply labels to add()");
    }

    @Override
    public String addDataStyle(int n2, String string) {
        throw new UnsupportedOperationException("Adding data styles later is not supported, supply labels to add()");
    }

    @Override
    public String removeStyle(int n2) {
        throw new UnsupportedOperationException("Removing data styles is not supported for this type of DataSet");
    }

    @Override
    public String removeDataLabel(int n2) {
        throw new UnsupportedOperationException("Removing data labels is not supported for this type of DataSet");
    }

    public CircularDoubleErrorDataSet reset() {
        this.lock().writeLockGuard(() -> {
            this.xValues.reset();
            this.yValues.reset();
            this.yErrorsNeg.reset();
            this.yErrorsPos.reset();
            this.dataLabels.reset();
            this.dataStyles.reset();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (CircularDoubleErrorDataSet)this.getThis();
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            this.reset();
            if (dataSet.getDataCount() == 0) {
                return;
            }
            int n2 = dataSet.getDataCount();
            if (dataSet instanceof DataSetError) {
                this.add(dataSet.getValues(0), dataSet.getValues(1), ((DataSetError)dataSet).getErrorsNegative(1), ((DataSetError)dataSet).getErrorsPositive(1), dataSet.getDataCount());
            } else {
                this.add(dataSet.getValues(0), dataSet.getValues(1), new double[n2], new double[n2], dataSet.getDataCount());
            }
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return this.getThis();
    }
}

