/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DataRange;

public abstract class AbstractGridDataSet<U>
extends AbstractDataSet<AbstractGridDataSet<U>>
implements GridDataSet {
    public AbstractGridDataSet(String string, int n2) {
        super(string, n2);
    }

    @Override
    public int getGridIndex(int n2, double d2) {
        if (n2 >= this.getNGrid()) {
            throw new IndexOutOfBoundsException("dim index out of bounds");
        }
        if (this.getShape(n2) == 0) {
            return 0;
        }
        if (!Double.isFinite(d2)) {
            return 0;
        }
        if (d2 <= this.getAxisDescription(n2).getMin()) {
            return 0;
        }
        int n4 = this.getShape(n2) - 1;
        if (d2 >= this.getAxisDescription(n2).getMax()) {
            return n4;
        }
        return AbstractGridDataSet.binarySearch(d2, 0, n4, n3 -> this.getGrid(n2, n3));
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        int n3 = this.getNGrid();
        int[] nArray = new int[n3];
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2;
            if (dArray[i2] < this.getAxisDescription(i2).getMin() || dArray[i2] > this.getAxisDescription(i2).getMax()) {
                return Double.NaN;
            }
            nArray[i2] = this.getGridIndex(i2, dArray[i2]);
            double d3 = this.getGrid(i2, nArray[i2]);
            if (dArray[i2] < d3) {
                d2 = d3;
                int n4 = i2;
                nArray[n4] = nArray[n4] - 1;
                d3 = this.getGrid(i2, nArray[i2]);
            } else {
                d2 = this.getGrid(i2, nArray[i2] + 1);
            }
            dArray2[i2] = (d2 - dArray[i2]) / (d2 - d3);
        }
        double d4 = 0.0;
        int[] nArray2 = new int[n3];
        for (int i3 = 0; i3 < 1 << n3; ++i3) {
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            double d5 = 1.0;
            for (int i4 = 0; i4 < n3; ++i4) {
                if ((i3 >> i4 & 1) > 0) {
                    int n5 = i4;
                    nArray2[n5] = nArray2[n5] + 1;
                    d5 *= 1.0 - dArray2[i4];
                    continue;
                }
                d5 *= dArray2[i4];
            }
            d4 += d5 * this.get(n2, nArray2);
        }
        return d4;
    }

    @Override
    public DataSet recomputeLimits(int n2) {
        DataRange dataRange = new DataRange();
        if (n2 < this.getNGrid()) {
            int n3 = this.getShape(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                dataRange.add(this.getGrid(n2, i2));
            }
        } else {
            int n4 = this.getDataCount();
            for (int i3 = 0; i3 < n4; ++i3) {
                dataRange.add(this.get(n2, i3));
            }
        }
        this.getAxisDescription(n2).set(dataRange.getMin(), dataRange.getMax());
        return this;
    }
}

