/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.utils.NumberFormatter;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class ScientificNotationStringConverter
extends StringConverter<Number>
implements NumberFormatter {
    private int precision = 2;
    private final DecimalFormat format = new DecimalFormat();

    public ScientificNotationStringConverter() {
        this.buildFormat(this.precision);
    }

    public ScientificNotationStringConverter(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
    }

    private void buildFormat(int n2) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("0.");
        stringBuilder.append("0".repeat(Math.max(0, n2)));
        stringBuilder.append("E0");
        this.format.applyPattern(stringBuilder.toString());
    }

    public Number fromString(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public int getDecimalPlaces() {
        return this.precision;
    }

    @Override
    public boolean isExponentialForm() {
        return true;
    }

    @Override
    public NumberFormatter setExponentialForm(boolean bl2) {
        return this;
    }

    @Override
    public NumberFormatter setDecimalPlaces(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
        return this;
    }

    @Override
    public String toString(double d2) {
        return this.toString((Number)d2);
    }

    public String toString(Number number) {
        return this.format.format(number);
    }
}

