/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import java.util.ArrayList;
import javafx.beans.value.ObservableValue;

public class MasterSlaveAxisSynchronizer {
    private final AbstractAxis master;
    private final ArrayList<AbstractAxis> slaves = new ArrayList();

    public MasterSlaveAxisSynchronizer(AbstractAxis abstractAxis) {
        this.master = abstractAxis;
        abstractAxis.maxProperty().addListener((observableValue, number, number2) -> this.upperBoundChanged(number2.doubleValue()));
        abstractAxis.minProperty().addListener((observableValue, number, number2) -> this.lowerBoundChanged(number2.doubleValue()));
    }

    public void add(AbstractAxis abstractAxis) {
        this.slaves.add(abstractAxis);
        abstractAxis.setAutoRanging(false);
        abstractAxis.tickUnitProperty().bind((ObservableValue)this.master.tickUnitProperty());
    }

    private void lowerBoundChanged(double d2) {
        if (Double.isNaN(d2)) {
            return;
        }
        for (AbstractAxis abstractAxis : this.slaves) {
            abstractAxis.setMin(d2);
        }
    }

    public void remove(AbstractAxis abstractAxis) {
        this.slaves.remove(abstractAxis);
        abstractAxis.tickUnitProperty().unbind();
        abstractAxis.setAutoRanging(true);
    }

    private void upperBoundChanged(double d2) {
        if (Double.isNaN(d2)) {
            return;
        }
        for (AbstractAxis abstractAxis : this.slaves) {
            abstractAxis.setMax(d2);
        }
    }
}

