/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import java.security.InvalidParameterException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableListBase;

public class ObservableDeque<E>
extends ObservableListBase<E>
implements Deque<E> {
    private final transient Deque<E> deque;

    public ObservableDeque(Deque<E> deque) {
        if (deque == null) {
            throw new InvalidParameterException("deque must not be null");
        }
        this.deque = deque;
    }

    @Override
    public void clear() {
        if (this.hasListeners()) {
            this.beginChange();
            this.nextRemove(0, (List)((Object)this));
        }
        this.deque.clear();
        ++this.modCount;
        if (this.hasListeners()) {
            this.endChange();
        }
    }

    @Override
    public boolean offer(E e2) {
        this.beginChange();
        boolean bl2 = this.deque.offer(e2);
        if (bl2) {
            this.nextAdd(this.deque.size() - 1, this.deque.size());
        }
        this.endChange();
        return bl2;
    }

    @Override
    public boolean add(E e2) {
        this.beginChange();
        try {
            this.deque.add(e2);
            this.nextAdd(this.deque.size() - 1, this.deque.size());
            boolean bl2 = true;
            return bl2;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public E remove() {
        this.beginChange();
        try {
            E e2 = this.deque.remove();
            this.nextRemove(0, e2);
            E e3 = e2;
            return e3;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public E poll() {
        this.beginChange();
        E e2 = this.deque.poll();
        if (e2 != null) {
            this.nextRemove(0, e2);
        }
        this.endChange();
        return e2;
    }

    @Override
    public E element() {
        return this.deque.element();
    }

    @Override
    public E peek() {
        return this.deque.peek();
    }

    public E get(int n2) {
        Iterator<E> iterator = this.deque.iterator();
        for (int i2 = 0; i2 < n2; ++i2) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public void addFirst(E e2) {
        this.beginChange();
        try {
            this.deque.addFirst(e2);
            this.nextAdd(0, 1);
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public void addLast(E e2) {
        this.beginChange();
        try {
            this.deque.addLast(e2);
            this.nextAdd(this.deque.size() - 1, this.deque.size());
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public boolean offerFirst(E e2) {
        if (this.deque.offerFirst(e2)) {
            this.beginChange();
            try {
                this.nextAdd(0, this.deque.size());
            }
            finally {
                this.endChange();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean offerLast(E e2) {
        if (this.deque.offerLast(e2)) {
            try {
                this.deque.addLast(e2);
                this.nextAdd(this.deque.size() - 1, this.deque.size());
            }
            finally {
                this.endChange();
            }
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        this.beginChange();
        E e2 = this.deque.removeFirst();
        if (e2 != null) {
            this.nextRemove(0, e2);
        }
        this.endChange();
        return e2;
    }

    @Override
    public E removeLast() {
        this.beginChange();
        E e2 = this.deque.removeLast();
        if (e2 != null) {
            this.nextRemove(this.deque.size() - 1, e2);
        }
        this.endChange();
        return e2;
    }

    @Override
    public E pollFirst() {
        this.beginChange();
        E e2 = this.deque.pollFirst();
        if (e2 != null) {
            this.nextRemove(0, e2);
        }
        this.endChange();
        return e2;
    }

    @Override
    public E pollLast() {
        this.beginChange();
        E e2 = this.deque.pollLast();
        if (e2 != null) {
            this.nextRemove(this.deque.size(), e2);
        }
        this.endChange();
        return e2;
    }

    @Override
    public E getFirst() {
        return this.deque.getFirst();
    }

    @Override
    public E getLast() {
        return this.deque.getLast();
    }

    @Override
    public E peekFirst() {
        return this.deque.peekFirst();
    }

    @Override
    public E peekLast() {
        return this.deque.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        Iterator<E> iterator = this.deque.iterator();
        this.beginChange();
        for (int i2 = 0; i2 < this.deque.size(); ++i2) {
            E e2 = iterator.next();
            if (!object.equals(e2)) continue;
            this.nextRemove(i2, e2);
            this.endChange();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        Iterator<E> iterator = this.deque.descendingIterator();
        this.beginChange();
        for (int i2 = 0; i2 < this.deque.size(); ++i2) {
            E e2 = iterator.next();
            if (!object.equals(e2)) continue;
            this.nextRemove(this.deque.size() - 1 - i2, e2);
            this.endChange();
            return true;
        }
        return false;
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.deque.descendingIterator();
    }
}

