/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRenderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.spi.DoubleDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.canvas.GraphicsContext;

public class HistoryDataSetRenderer
extends ErrorDataSetRenderer
implements Renderer {
    protected static final int DEFAULT_HISTORY_DEPTH = 3;
    final int historyDepth;

    public HistoryDataSetRenderer() {
        this(3);
    }

    public HistoryDataSetRenderer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("historyDepth=='%d' should be larger than '0'", n2));
        }
        this.historyDepth = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        double d2 = dataSetNode.getIntensity();
        try {
            List<DataSet> list = ((HistoryDataSetNode)dataSetNode).getHistory();
            int n2 = list.size() - 1;
            for (DataSet dataSet2 : list) {
                double d3 = Math.pow(this.getIntensityFading(), (double)n2 + 2.0) * d2;
                dataSetNode.setIntensity((int)d3);
                --n2;
                super.render(graphicsContext, dataSet2, dataSetNode);
            }
        }
        finally {
            dataSetNode.setIntensity(d2);
        }
        super.render(graphicsContext, dataSet, dataSetNode);
    }

    @Override
    protected void updateAxisRange(AxisRange axisRange, int n2) {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            if (!dataSetNode.isVisible()) continue;
            this.updateAxisRange(dataSetNode.getDataSet(), axisRange, n2);
            for (DataSet dataSet : ((HistoryDataSetNode)dataSetNode).getHistory()) {
                this.updateAxisRange(dataSet, axisRange, n2);
            }
        }
    }

    public void clearHistory() {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            ((HistoryDataSetNode)dataSetNode).clear();
        }
    }

    public void shiftHistory() {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            ((HistoryDataSetNode)dataSetNode).shift();
        }
    }

    @Override
    protected HistoryDataSetNode createNode(DataSet dataSet) {
        return new HistoryDataSetNode(this, dataSet, this.historyDepth);
    }

    static class HistoryDataSetNode
    extends DataSetNode {
        final int depth;
        final LinkedList<DataSet> history = new LinkedList();

        HistoryDataSetNode(AbstractRenderer<?> abstractRenderer, DataSet dataSet, int n2) {
            super(abstractRenderer, dataSet);
            this.depth = n2;
        }

        public List<DataSet> getHistory() {
            return this.history;
        }

        public void shift() {
            DataSet dataSet = this.getDataSet();
            if (this.history.size() < this.depth) {
                this.history.add(HistoryDataSetNode.copy(dataSet));
            } else {
                this.history.add(this.history.removeFirst().set(dataSet));
            }
            String string = dataSet.getName().split("_")[0];
            int n2 = this.history.size() - 1;
            for (DataSet dataSet2 : this.history) {
                ((EditableDataSet)dataSet2).setName(string + "History_{-" + n2-- + "}");
            }
        }

        public void clear() {
            this.history.clear();
        }

        static DataSet copy(DataSet dataSet) {
            return dataSet instanceof DataSetError ? new DoubleErrorDataSet(dataSet) : new DoubleDataSet(dataSet);
        }
    }
}

