/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.bench.AggregateDurationMeasure;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.spi.AbstractPointReducingRenderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRenderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.DataSetStyleParser;
import io.fair_acc.chartfx.utils.FastDoubleArrayCache;
import io.fair_acc.dataset.DataSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.Styleable;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class BasicDataSetRenderer
extends AbstractRendererXY<BasicDataSetRenderer> {
    private final BooleanProperty assumeSortedData = this.css().createBooleanProperty(this, "assumeSortedData", true, new Runnable[0]);
    private final BooleanProperty drawMarker = this.css().createBooleanProperty(this, "drawMarker", true, new Runnable[0]);
    private final ObjectProperty<LineStyle> polyLineStyle = this.css().createEnumProperty((Styleable)this, "polyLineStyle", LineStyle.NORMAL, false, LineStyle.class);
    private static final double minPointPixelDistance = 1.0;
    AggregateDurationMeasure benchComputeCoords = AggregateDurationMeasure.DISABLED;
    AggregateDurationMeasure benchDrawMarker = AggregateDurationMeasure.DISABLED;
    AggregateDurationMeasure benchPolyLine = AggregateDurationMeasure.DISABLED;
    private final DataSetStyleParser styleParser = DataSetStyleParser.newInstance();
    private static final CssPropertyFactory<AbstractRenderer<?>> CSS = new CssPropertyFactory(AbstractPointReducingRenderer.getClassCssMetaData());
    private static final FastDoubleArrayCache SHARED_ARRAYS = new FastDoubleArrayCache(2);

    public BasicDataSetRenderer(DataSet ... dataSetArray) {
        this.getDatasets().setAll((Object[])dataSetArray);
    }

    @Override
    protected void render(GraphicsContext graphicsContext, DataSet dataSet, DataSetNode dataSetNode) {
        int n2;
        int n3;
        if (this.isAssumeSortedData()) {
            n3 = Math.max(0, dataSet.getIndex(0, this.xMin) - 1);
            n2 = Math.min(dataSet.getIndex(0, this.xMax) + 2, dataSet.getDataCount());
        } else {
            n3 = 0;
            n2 = dataSet.getDataCount();
        }
        int n4 = n2 - n3;
        if (n4 <= 0) {
            return;
        }
        double[] dArray = SHARED_ARRAYS.getArray(0, n4);
        double[] dArray2 = SHARED_ARRAYS.getArray(1, n4);
        graphicsContext.save();
        dataSetNode.applyLineStrokeStyle(graphicsContext);
        graphicsContext.setFill(dataSetNode.getMarkerColor());
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        int n5 = n3;
        while (n5 < n2) {
            double d4;
            double d5;
            this.benchComputeCoords.start();
            int n6 = 0;
            while (n5 < n2) {
                d5 = dataSet.get(0, n5);
                d4 = dataSet.get(1, n5);
                ++n5;
                if (Double.isNaN(d4) || Double.isNaN(d5)) continue;
                d2 = dArray[0] = this.xAxis.getDisplayPosition(d5);
                d3 = dArray2[0] = this.yAxis.getDisplayPosition(d4);
                n6 = 1;
                break;
            }
            while (n5 < n2) {
                double d6;
                d5 = dataSet.get(0, n5);
                d4 = dataSet.get(1, n5);
                ++n5;
                if (Double.isNaN(d4) || Double.isNaN(d5)) break;
                double d7 = this.xAxis.getDisplayPosition(d5);
                if (BasicDataSetRenderer.isSamePoint(d2, d3, d7, d6 = this.yAxis.getDisplayPosition(d4))) continue;
                dArray[n6] = d2 = d7;
                dArray2[n6] = d3 = d6;
                ++n6;
            }
            this.benchComputeCoords.stop();
            if (n6 <= 0) continue;
            this.drawMarkers(graphicsContext, dataSetNode, dArray, dArray2, n6);
            this.drawPolyLine(graphicsContext, dataSetNode, dArray, dArray2, n6);
        }
        this.drawCustomStyledMarkers(graphicsContext, dataSetNode, dataSet, n3, n2);
        graphicsContext.restore();
        this.benchComputeCoords.recordResult();
        this.benchDrawMarker.recordResult();
        this.benchPolyLine.recordResult();
    }

    protected void drawMarkers(GraphicsContext graphicsContext, DataSetNode dataSetNode, double[] dArray, double[] dArray2, int n2) {
        double d2 = dataSetNode.getMarkerSize();
        if (!this.isDrawMarker() || d2 == 0.0) {
            return;
        }
        Marker marker = dataSetNode.getMarkerType();
        this.benchDrawMarker.start();
        for (int i2 = 0; i2 < n2; ++i2) {
            marker.draw(graphicsContext, dArray[i2], dArray2[i2], d2);
        }
        this.benchDrawMarker.stop();
    }

    protected void drawPolyLine(GraphicsContext graphicsContext, DataSetNode dataSetNode, double[] dArray, double[] dArray2, int n2) {
        if (this.getPolyLineStyle() == LineStyle.NONE || dataSetNode.getLineWidth() == 0.0) {
            return;
        }
        this.benchPolyLine.start();
        if (n2 > 1) {
            graphicsContext.strokePolyline(dArray, dArray2, n2);
        } else {
            graphicsContext.strokeLine(dArray[0], dArray2[0], dArray[0], dArray2[0]);
        }
        this.benchPolyLine.stop();
    }

    protected void drawCustomStyledMarkers(GraphicsContext graphicsContext, DataSetNode dataSetNode, DataSet dataSet, int n3, int n4) {
        if (!this.isDrawMarker() || !dataSet.hasStyles()) {
            return;
        }
        dataSet.forEachStyle(n3, n4, (n2, string) -> {
            if (!this.styleParser.tryParse(string)) {
                return;
            }
            double d2 = this.styleParser.getMarkerSize().orElse(dataSetNode.getMarkerSize());
            if (d2 == 0.0) {
                return;
            }
            double d3 = this.xAxis.getDisplayPosition(dataSet.get(0, n2));
            double d4 = this.yAxis.getDisplayPosition(dataSet.get(1, n2));
            if (Double.isNaN(d4) || Double.isNaN(d3)) {
                return;
            }
            Marker marker = this.styleParser.getMarkerType().orElse(dataSetNode.getMarkerType());
            Paint paint = this.styleParser.getMarkerColor().orElse(dataSetNode.getMarkerColor());
            graphicsContext.save();
            graphicsContext.setFill(paint);
            graphicsContext.setStroke(paint);
            graphicsContext.setLineDashes(this.styleParser.getMarkerLineDashes().orElse(dataSetNode.getMarkerLineDashes()));
            graphicsContext.setLineWidth(this.styleParser.getMarkerLineWidth().orElse(dataSetNode.getMarkerLineWidth()));
            marker.draw(graphicsContext, d3, d4, d2);
            graphicsContext.restore();
        });
    }

    public boolean isAssumeSortedData() {
        return this.assumeSortedData.get();
    }

    public BooleanProperty assumeSortedDataProperty() {
        return this.assumeSortedData;
    }

    public void setAssumeSortedData(boolean bl2) {
        this.assumeSortedData.set(bl2);
    }

    public boolean isDrawMarker() {
        return this.drawMarker.get();
    }

    public BooleanProperty drawMarkerProperty() {
        return this.drawMarker;
    }

    public void setDrawMarker(boolean bl2) {
        this.drawMarker.set(bl2);
    }

    public LineStyle getPolyLineStyle() {
        return (LineStyle)((Object)this.polyLineStyle.get());
    }

    public ObjectProperty<LineStyle> polyLineStyleProperty() {
        return this.polyLineStyle;
    }

    public void setPolyLineStyle(LineStyle lineStyle) {
        this.polyLineStyle.set((Object)lineStyle);
    }

    public static boolean isSamePoint(double d2, double d3, double d4, double d5) {
        double d6 = Math.abs(d4 - d2);
        double d7 = Math.abs(d5 - d3);
        return d6 < 1.0 && d7 < 1.0;
    }

    @Override
    protected BasicDataSetRenderer getThis() {
        return this;
    }

    @Override
    public void setRecorder(MeasurementRecorder measurementRecorder) {
        super.setRecorder(measurementRecorder);
        this.benchComputeCoords = measurementRecorder.newDebugDurationSum("basic-computeCoords");
        this.benchDrawMarker = measurementRecorder.newDebugDurationSum("basic-drawMarker");
        this.benchPolyLine = measurementRecorder.newDebugDurationSum("basic-drawPolyLine");
    }

    @Override
    protected CssPropertyFactory<AbstractRenderer<?>> css() {
        return CSS;
    }

    public static void trimCache() {
        SHARED_ARRAYS.trim();
    }
}

