/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements.utils;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.plugins.YValueIndicator;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;

public class ValueIndicatorSelector
extends GridPane {
    private static final int DEFAULT_SELECTOR_HEIGHT = 100;
    private static final int ROW_HEIGHT = 24;
    private final ObservableList<AbstractSingleValueIndicator> valueIndicators = FXCollections.observableArrayList(new NoDuplicatesList());
    private final ObservableList<AbstractSingleValueIndicator> valueIndicatorsUser = FXCollections.observableArrayList(new NoDuplicatesList());
    protected final ListView<AbstractSingleValueIndicator> indicatorListView = new ListView(this.valueIndicators);
    private final AxisMode axisMode;
    protected final CheckBox reuseIndicators = new CheckBox();
    protected ListChangeListener<? super ChartPlugin> pluginsChanged = change -> {
        while (change.next()) {
            change.getRemoved().forEach(this::removeIndicators);
            change.getAddedSubList().forEach(this::addNewIndicators);
        }
    };
    protected ChangeListener<? super Chart> chartChangeListener = (observableValue, chart, chart2) -> {
        if (chart != null) {
            chart.getPlugins().removeListener(this.pluginsChanged);
        }
        if (chart2 != null) {
            chart2.getPlugins().addListener(this.pluginsChanged);
        }
    };
    protected ListChangeListener<? super Integer> selectionChangeListener = change -> {
        while (change.next()) {
            ArrayList<AbstractSingleValueIndicator> arrayList = new ArrayList<AbstractSingleValueIndicator>(2);
            Iterator iterator = this.indicatorListView.getSelectionModel().getSelectedIndices().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                arrayList.add((AbstractSingleValueIndicator)this.valueIndicators.get(n2));
            }
            this.valueIndicatorsUser.setAll(arrayList);
        }
    };

    public ValueIndicatorSelector(ParameterMeasurements parameterMeasurements, AxisMode axisMode, int n2) {
        if (parameterMeasurements == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        this.axisMode = axisMode;
        this.reuseIndicators.setSelected(true);
        parameterMeasurements.chartProperty().addListener(this.chartChangeListener);
        if (parameterMeasurements.getChart() != null) {
            parameterMeasurements.getChart().getPlugins().addListener(this.pluginsChanged);
            parameterMeasurements.getChart().getPlugins().forEach(this::addNewIndicators);
        }
        Label label = new Label("re-use inidcators: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        GridPane.setConstraints((Node)this.reuseIndicators, (int)1, (int)0);
        this.indicatorListView.disableProperty().bind((ObservableValue)this.reuseIndicators.selectedProperty().not());
        this.indicatorListView.setOrientation(Orientation.VERTICAL);
        this.indicatorListView.setPrefSize(-1.0, 100.0);
        this.indicatorListView.setCellFactory(listView -> new DataSelectorLabel());
        this.indicatorListView.setPrefHeight((double)(Math.max(2, this.valueIndicators.size()) * 24) + 2.0);
        GridPane.setConstraints(this.indicatorListView, (int)1, (int)1);
        MultipleSelectionModel multipleSelectionModel = this.indicatorListView.getSelectionModel();
        multipleSelectionModel.getSelectedIndices().addListener(this.selectionChangeListener);
        if (n2 == 0) {
            this.setVisible(false);
        } else if (n2 == 1) {
            multipleSelectionModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (n2 >= 2) {
            multipleSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (multipleSelectionModel.getSelectedIndices().isEmpty()) {
            for (int i2 = 0; i2 < Math.min(2, this.valueIndicators.size()); ++i2) {
                multipleSelectionModel.select((Object)((AbstractSingleValueIndicator)this.valueIndicators.get(i2)));
            }
        }
        if (n2 > 0) {
            this.getChildren().addAll((Object[])new Node[]{label, this.reuseIndicators, this.indicatorListView});
        }
    }

    public CheckBox getReuseIndicators() {
        return this.reuseIndicators;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicators() {
        return this.valueIndicators;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicatorsUser() {
        return this.valueIndicatorsUser;
    }

    public boolean isReuseIndicators() {
        return this.reuseIndicators.isSelected();
    }

    protected void addNewIndicators(ChartPlugin chartPlugin) {
        if (this.axisMode == AxisMode.X && chartPlugin instanceof XValueIndicator || this.axisMode == AxisMode.Y && chartPlugin instanceof YValueIndicator) {
            if (!this.valueIndicators.contains((Object)chartPlugin)) {
                this.valueIndicators.add((Object)((AbstractSingleValueIndicator)chartPlugin));
            }
            if (this.reuseIndicators.isSelected() && this.valueIndicatorsUser.size() < (this.indicatorListView.getSelectionModel().getSelectionMode() == SelectionMode.SINGLE ? 1 : 2) && !this.valueIndicatorsUser.contains((Object)chartPlugin)) {
                this.indicatorListView.getSelectionModel().select((Object)((AbstractSingleValueIndicator)chartPlugin));
            }
        }
    }

    protected void removeIndicators(ChartPlugin chartPlugin) {
        this.valueIndicators.remove((Object)chartPlugin);
        this.valueIndicatorsUser.remove((Object)chartPlugin);
    }

    protected static class DataSelectorLabel
    extends ListCell<AbstractSingleValueIndicator> {
        protected DataSelectorLabel() {
        }

        public void updateItem(AbstractSingleValueIndicator abstractSingleValueIndicator, boolean bl2) {
            super.updateItem((Object)abstractSingleValueIndicator, bl2);
            if (abstractSingleValueIndicator != null) {
                this.setText(abstractSingleValueIndicator.getText());
            }
        }
    }
}

