/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements.utils;

import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.dataset.DataSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;

public class DataSetSelector
extends GridPane {
    private static final int DEFAULT_SELECTOR_HEIGHT = 50;
    private static final int ROW_HEIGHT = 24;
    protected final ListView<DataSet> dataSetListView;
    protected final ObservableList<DataSet> allDataSets;

    public DataSetSelector(ParameterMeasurements parameterMeasurements, int n2) {
        if (parameterMeasurements == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        this.allDataSets = parameterMeasurements.getChart() != null ? FXCollections.observableArrayList(parameterMeasurements.getChart().getAllDatasets()) : FXCollections.emptyObservableList();
        Label label = new Label("Selected Dataset: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        this.dataSetListView = new ListView(this.allDataSets);
        GridPane.setConstraints(this.dataSetListView, (int)1, (int)0);
        this.dataSetListView.setOrientation(Orientation.VERTICAL);
        this.dataSetListView.setPrefSize(-1.0, 50.0);
        this.dataSetListView.setCellFactory(listView -> new DataSetLabel());
        this.dataSetListView.setPrefHeight((double)(Math.max(2, this.allDataSets.size()) * 24) + 2.0);
        MultipleSelectionModel multipleSelectionModel = this.dataSetListView.getSelectionModel();
        if (n2 == 1) {
            multipleSelectionModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (n2 >= 2) {
            multipleSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (multipleSelectionModel.getSelectedIndices().isEmpty() && this.allDataSets.size() >= n2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                multipleSelectionModel.select(i2);
            }
        }
        if (n2 >= 1) {
            this.getChildren().addAll((Object[])new Node[]{label, this.dataSetListView});
        }
    }

    public int getNumberDataSets() {
        return this.allDataSets.size();
    }

    public DataSet getSelectedDataSet() {
        MultipleSelectionModel multipleSelectionModel = this.dataSetListView.getSelectionModel();
        return (DataSet)multipleSelectionModel.getSelectedItem();
    }

    public ObservableList<DataSet> getSelectedDataSets() {
        MultipleSelectionModel multipleSelectionModel = this.dataSetListView.getSelectionModel();
        return multipleSelectionModel.getSelectedItems();
    }

    public ListView<DataSet> getDataSetListView() {
        return this.dataSetListView;
    }

    protected static class DataSetLabel
    extends ListCell<DataSet> {
        protected DataSetLabel() {
        }

        public void updateItem(DataSet dataSet, boolean bl2) {
            super.updateItem((Object)dataSet, bl2);
            if (dataSet != null) {
                this.setText(dataSet.getName());
            }
        }
    }
}

