/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractDataFormattingPlugin;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.ErrorDataSetRenderer;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.utils.Tuple;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;

public class DataPointTooltip
extends AbstractDataFormattingPlugin {
    public static final String STYLE_CLASS_LABEL = "chart-datapoint-tooltip-label";
    public static final int DEFAULT_PICKING_DISTANCE = 5;
    private static final int LABEL_X_OFFSET = 15;
    private static final int LABEL_Y_OFFSET = 5;
    private final Label label = new Label();
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 5.0){

        protected void invalidated() {
            if (this.get() <= 0.0) {
                throw new IllegalArgumentException("The " + this.getName() + " must be a positive value");
            }
        }
    };
    private final EventHandler<MouseEvent> mouseMoveHandler = this::updateToolTip;

    public DataPointTooltip() {
        this.label.getStyleClass().add((Object)STYLE_CLASS_LABEL);
        this.label.setWrapText(true);
        this.label.setMinWidth(0.0);
        this.label.setManaged(false);
        this.registerInputEventHandler(MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
    }

    public DataPointTooltip(double d2) {
        this();
        this.setPickingDistance(d2);
    }

    protected Optional<DataPoint> findDataPoint(MouseEvent mouseEvent, Bounds bounds) {
        if (!bounds.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return Optional.empty();
        }
        Point2D point2D = this.getLocationInPlotArea(mouseEvent);
        return this.findNearestDataPointWithinPickingDistance(point2D);
    }

    protected Optional<DataPoint> findNearestDataPointWithinPickingDistance(Point2D point2D) {
        Chart chart = this.getChart();
        if (!(chart instanceof XYChart)) {
            return Optional.empty();
        }
        XYChart xYChart = (XYChart)chart;
        ObservableList<DataSet> observableList = xYChart.getDatasets();
        return xYChart.getRenderers().stream().flatMap(renderer -> Stream.of(renderer.getDatasets(), observableList).flatMap(Collection::stream).flatMap(dataSet -> this.getPointsCloseToCursor((DataSet)dataSet, (Renderer)renderer, point2D))).reduce((dataPoint, dataPoint2) -> dataPoint.distanceFromMouse <= dataPoint2.distanceFromMouse ? dataPoint : dataPoint2);
    }

    protected Stream<DataPoint> getPointsCloseToCursor(DataSet dataSet, Renderer renderer, Point2D point2D) {
        Axis axis = this.findXAxis(renderer);
        Axis axis2 = this.findYAxis(renderer);
        if (axis == null || axis2 == null) {
            return Stream.empty();
        }
        if (dataSet instanceof GridDataSet) {
            return Stream.empty();
        }
        return dataSet.lock().readLockGuard(() -> {
            int n3 = 0;
            int n4 = dataSet.getDataCount();
            if (this.isDataSorted(renderer)) {
                double d2 = axis.getValueForDisplay(point2D.getX() - this.getPickingDistance());
                double d3 = axis.getValueForDisplay(point2D.getX() + this.getPickingDistance());
                n3 = Math.max(0, dataSet.getIndex(0, d2) - 1);
                n4 = Math.min(dataSet.getDataCount(), dataSet.getIndex(0, d3) + 1);
            }
            return IntStream.range(n3, n4).mapToObj(n2 -> this.getDataPointFromDataSet(renderer, dataSet, axis, axis2, point2D, n2)).filter(dataPoint -> dataPoint.distanceFromMouse <= this.getPickingDistance()).map(dataPoint -> dataPoint.withFormattedLabel(this.formatLabel((DataPoint)dataPoint))).collect(Collectors.toList()).stream();
        });
    }

    private boolean isDataSorted(Renderer renderer) {
        return renderer instanceof ErrorDataSetRenderer && ((ErrorDataSetRenderer)renderer).isAssumeSortedData();
    }

    private Axis findYAxis(Renderer renderer) {
        return renderer.getAxes().stream().filter(axis -> axis.getSide().isVertical()).findFirst().orElse(null);
    }

    private Axis findXAxis(Renderer renderer) {
        return renderer.getAxes().stream().filter(axis -> axis.getSide().isHorizontal()).findFirst().orElse(null);
    }

    protected DataPoint getDataPointFromDataSet(Renderer renderer, DataSet dataSet, Axis axis, Axis axis2, Point2D point2D, int n2) {
        double d2 = dataSet.get(0, n2);
        double d3 = dataSet.get(1, n2);
        double d4 = axis.getDisplayPosition(d2);
        double d5 = axis2.getDisplayPosition(d3);
        double d6 = new Point2D(d4, d5).distance(point2D);
        String string = this.getDataLabelSafe(dataSet, n2);
        return new DataPoint(renderer, d2, d3, string, d6);
    }

    protected String formatDataPoint(DataPoint dataPoint) {
        return this.formatData(dataPoint.renderer, new Tuple<Number, Number>(dataPoint.x, dataPoint.y));
    }

    protected String formatLabel(DataPoint dataPoint) {
        return String.format("'%s'%n%s", dataPoint.label, this.formatDataPoint(dataPoint));
    }

    protected String getDataLabelSafe(DataSet dataSet, int n2) {
        String string = dataSet.getDataLabel(n2);
        if (string == null) {
            return String.format("%s [%d]", dataSet.getName(), n2);
        }
        return string;
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    public final void setPickingDistance(double d2) {
        this.pickingDistanceProperty().set(d2);
    }

    protected void updateLabel(MouseEvent mouseEvent, Bounds bounds, DataPoint dataPoint) {
        double d2;
        double d3;
        this.label.setText(dataPoint.formattedLabel);
        double d4 = mouseEvent.getX();
        double d5 = d4 - bounds.getMinX();
        double d6 = bounds.getWidth() - d5;
        double d7 = this.label.prefWidth(-1.0);
        boolean bl2 = true;
        if (d6 >= d7 + 15.0) {
            d3 = d4 + 15.0;
        } else if (d5 >= d7 + 15.0) {
            d3 = d4 - 15.0 - d7;
        } else if (d7 < bounds.getWidth()) {
            d3 = d5 > d6 ? bounds.getMaxX() - d7 : bounds.getMinX();
            bl2 = false;
        } else {
            d7 = bounds.getWidth();
            d3 = bounds.getMinX();
            bl2 = false;
        }
        double d8 = mouseEvent.getY();
        double d9 = d8 - bounds.getMinY();
        double d10 = bounds.getHeight() - d9;
        double d11 = this.label.prefHeight(d7);
        if (d11 < d10) {
            d2 = d8 + 5.0;
        } else if (d11 < d9) {
            d2 = d8 - 5.0 - d11;
        } else if (bl2 && d11 < bounds.getHeight()) {
            d2 = d9 < d10 ? bounds.getMaxY() - d11 : bounds.getMinY();
        } else if (bl2) {
            d2 = bounds.getMinY();
            d11 = bounds.getHeight();
        } else if (d10 > d9) {
            d2 = d8 + 5.0;
            d11 = d10 - 5.0;
        } else {
            d2 = bounds.getMinY();
            d11 = d9 - 5.0;
        }
        this.label.resizeRelocate(d3, d2, d7, d11);
    }

    private void updateToolTip(MouseEvent mouseEvent) {
        Bounds bounds = this.getChart().getPlotArea().getBoundsInLocal();
        Optional<DataPoint> optional = this.findDataPoint(mouseEvent, bounds);
        if (optional.isEmpty()) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        this.updateLabel(mouseEvent, bounds, optional.get());
        if (!this.getChartChildren().contains((Object)this.label)) {
            this.getChartChildren().add((Object)this.label);
            this.label.requestLayout();
        }
    }

    public static class DataPoint {
        public final Renderer renderer;
        public final double x;
        public final double y;
        public final String label;
        public final String formattedLabel;
        public final double distanceFromMouse;

        public DataPoint(Renderer renderer, double d2, double d3, String string, double d4, String string2) {
            this.renderer = renderer;
            this.x = d2;
            this.y = d3;
            this.label = string;
            this.distanceFromMouse = d4;
            this.formattedLabel = string2;
        }

        public DataPoint(Renderer renderer, double d2, double d3, String string, double d4) {
            this(renderer, d2, d3, string, d4, "");
        }

        public DataPoint withFormattedLabel(String string) {
            return new DataPoint(this.renderer, this.x, this.y, string, this.distanceFromMouse, string);
        }
    }
}

