/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractValueIndicator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;

public abstract class AbstractRangeValueIndicator
extends AbstractValueIndicator {
    protected static final String STYLE_CLASS_LABEL = "range-indicator-label";
    protected static final String STYLE_CLASS_RECT = "range-indicator-rect";
    protected final Rectangle rectangle = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private final DoubleProperty lowerBound = new SimpleDoubleProperty(this, "lowerBound"){

        protected void invalidated() {
            AbstractRangeValueIndicator.this.runPostLayout();
        }
    };
    private final DoubleProperty upperBound = new SimpleDoubleProperty(this, "upperBound"){

        protected void invalidated() {
            AbstractRangeValueIndicator.this.runPostLayout();
        }
    };
    private final DoubleProperty labelHorizontalPosition = new SimpleDoubleProperty(this, "labelHorizontalPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelHorizontalPosition must be in rage [0,1]");
            }
            AbstractRangeValueIndicator.this.runPostLayout();
        }
    };
    private final DoubleProperty labelVerticalPosition = new SimpleDoubleProperty(this, "labelVerticalPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelVerticalPosition must be in rage [0,1]");
            }
            AbstractRangeValueIndicator.this.runPostLayout();
        }
    };

    protected AbstractRangeValueIndicator(Axis axis, double d2, double d3, String string) {
        super(axis, string);
        this.setLowerBound(d2);
        this.setUpperBound(d3);
        this.rectangle.setMouseTransparent(true);
        this.rectangle.setManaged(false);
        this.getChartChildren().addAll((Object[])new Node[]{this.rectangle, this.label});
    }

    public final double getLabelHorizontalPosition() {
        return this.labelHorizontalPositionProperty().get();
    }

    public final double getLabelVerticalPosition() {
        return this.labelVerticalPositionProperty().get();
    }

    public final double getLowerBound() {
        return this.lowerBoundProperty().get();
    }

    public final double getUpperBound() {
        return this.upperBoundProperty().get();
    }

    public final DoubleProperty labelHorizontalPositionProperty() {
        return this.labelHorizontalPosition;
    }

    public final DoubleProperty labelVerticalPositionProperty() {
        return this.labelVerticalPosition;
    }

    protected void layout(Bounds bounds) {
        if (bounds.intersects(this.getChart().getCanvas().getBoundsInLocal())) {
            this.layoutLabel(bounds, this.getLabelHorizontalPosition(), this.getLabelVerticalPosition());
            this.rectangle.setX(bounds.getMinX());
            this.rectangle.setY(bounds.getMinY());
            this.rectangle.setWidth(bounds.getWidth());
            this.rectangle.setHeight(bounds.getHeight());
            this.addChildNodeIfNotPresent((Node)this.rectangle);
        } else {
            this.getChartChildren().clear();
        }
    }

    public final DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    public final void setLabelHorizontalPosition(double d2) {
        this.labelHorizontalPositionProperty().set(d2);
    }

    public final void setLabelVerticalPosition(double d2) {
        this.labelVerticalPositionProperty().set(d2);
    }

    public final void setLowerBound(double d2) {
        this.lowerBoundProperty().set(d2);
    }

    public final void setUpperBound(double d2) {
        this.upperBoundProperty().set(d2);
    }

    public final DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }
}

